/*
 *  FOR.C - for command.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *
 * 16 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 19 Jul 1998 (Hans B Pufal) [HBP_001]
 *   Implementation of FOR
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 10-Aug-1998 ska
 * - added malloc() checking
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "command.h"
#include "batch.h"
#include "strings.h"

#pragma argsused
int cmd_for(char *param)
{
	/*
	 * Perform FOR command.
	 *
	 * First check syntax is correct : FOR %v IN ( <list> ) DO <command>
	 *   v must be alphabetic, <command> must not be empty.
	 *
	 * If all is correct build a new bcontext structure which preserves
	 *   the necessary information so that readbatchline can expand
	 *   each the command prototype for each list element.
	 *
	 * You might look on a FOR as being a called batch file with one line
	 *   per list element.
	 */

	char *pp;
	char var;

	/* Check that first element is % then an alpha char followed by space */

	if ((*param != '%') || !isalpha(*(param + 1)) || !isspace(*(param + 2)))
	{
		display_string(TEXT_ERROR_BAD_VERABLE);
		return 1;
	}

	param++;
	var = *param++;               /* Save FOR var name */

	while (isspace(*param))
		param++;

	/* Check next element is 'IN' */

	if ((strncmpi(param, "in", 2) != 0) || !isspace(*(param + 2)))
	{
		display_string(TEXT_ERROR_IN_MISSING);
		return 1;
	}

	param += 2;
	while (isspace(*param))
		param++;

	/* Folowed by a '(', find also matching ')' */

	if ((*param != '(') || (NULL == (pp = strchr(param, ')'))))
	{
		display_string(TEXT_ERROR_MISSING_PARENTHESES);
		return 1;
	}

	*pp++ = '\0';
	param++;                      /* param now points at null terminated list */

	while (isspace(*pp))
		pp++;

	/* Check DO follows */

	if ((strncmpi(pp, "do", 2) != 0) || !isspace(*(pp + 2)))
	{
		display_string(TEXT_ERROR_DO_MISSING);
		return 1;
	}

	pp += 2;
	while (isspace(*pp))
		pp++;

	/* Check that command tail is not empty */

	if (*pp == '\0')
	{
		display_string(TEXT_ERROR_NO_COMMAND_AFTER_DO);
		return 1;
	}

	/* OK all is correct, build a bcontext.... */

	{
		struct bcontext
		 *new = newBatchContext();

		if (!new)
			return 1;

		if ((bc->forproto = strdup(pp)) == NULL)
		{
			bc = bc->prev;
			free(new);
			error_out_of_memory();
			return 1;
		}

		bc->params = batch_params("", param); /* Split out list */
		bc->forvar = var;
	}

	return 0;
}
