/*
 * ERROR.C -- Error reporting functions
 *
 * 07/12/98 (Rob Lake)
 *      started
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 *  1998/08/10 ska
 *  - added "long line in batchfile", "batchfile vanished"
 */

#include "config.h"

#include <stdio.h>
#include "command.h"
#include "strings.h"

void error_invalid_switch(char c)
{
  display_string(TEXT_ERROR_INVALID_SWITCH, c);
}

void error_too_many_parameters(char *s)
{
  display_string(TEXT_ERROR_TOO_MANY_PARAMETERS_STR, s);
}

void error_path_not_found(void)
{
  display_string(TEXT_ERROR_PATH_NOT_FOUND);
}

void error_file_not_found(void)
{
  display_string(TEXT_ERROR_FILE_NOT_FOUND);
}

void error_sfile_not_found(char *f)
{
  display_string(TEXT_ERROR_FILE_NOT_FOUND, f);
}

void error_req_param_missing(void)
{
  display_string(TEXT_ERROR_REQ_PARAM_MISSING);
}

void error_invalid_drive(void)
{
  display_string(TEXT_ERROR_INVALID_DRIVE);
}

void error_bad_command(void)
{
  display_string(TEXT_ERROR_BADCOMMAND);
}

void error_no_pipe(void)
{
  display_string(TEXT_ERROR_CANNOTPIPE);
}

void error_out_of_memory(void)
{
  display_string(TEXT_ERROR_OUT_OF_MEMORY);
}

void error_syntax(char *s)
{
  if (s)
    display_string(TEXT_ERROR_SYNTAX_STR, s);
  else
    display_string(TEXT_ERROR_SYNTAX);
}

void msg_pause(void)
{
  display_string(TEXT_MSG_PAUSE);
}

void error_long_batchline(char *fnam, long linenr)
{
  display_string(TEXT_ERROR_LONG_LINE_BATCHFILE, linenr, fnam);
}

void error_bfile_vanished(char *fnam)
{
  display_string(TEXT_ERROR_BFILE_VANISHED, fnam);
}

void error_bfile_no_such_label(char *fnam, char *label)
{
  display_string(TEXT_ERROR_BFILE_LABEL, fnam, label);
}

void error_env(void)
{
  display_string(TEXT_ERROR_ENVIRONMENT_ERR);
}

void error_env_var(char *var)
{
  display_string(TEXT_ERROR_SET_ENV_VAR, var);
}

void error_env_var_not_found(char *var)
{
  display_string(TEXT_ERROR_ENV_VAR_NOT_FOUND, var);
}

void error_filename_too_long(char *fname)
{
  display_string(TEXT_ERROR_FILENAME_TOO_LONG, fname);
}

void error_command_too_long(void)
{
  display_string(TEXT_ERROR_COMMAND_TOO_LONG);
}

void error_line_too_long(void)
{
  display_string(TEXT_ERROR_LINE_TOO_LONG);
}

void error_tempfile(void)
{
	display_string(TEXT_ERROR_TEMPFILE);
}

void error_close_quote(int quote)
{
	display_string(TEXT_ERROR_CLOSE_QUOTE, quote);
}
//void newperror(unsigned error_id)
//{
//
//}
