
;   FreeDOS DISPLAY.SYS           v0.09
;   FreeDOS PRINTER.SYS
;
;   ===================================================================
;
;   FreeDOS driver to add support of codepage management for the
;   default CON driver (for screen) or default PRN driver (for printer)
;
;   Copyright (C) 2002-03 Aitor Santamara_Merino
;   email:  aitor.sm@wanadoo.es
;
;   (contributed code from DISPLAY 0.5b package, and patches by
;    Ilya V. Vasilyev aka AtH//UgF@hMoscow (hscool@netclub.ru)
;    in  VIDEOINT.ASM, SELECTD.ASM and DISPHW.ASM)
;
;   WWW:    http://www.freedos.org/
;
;   ===================================================================
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;   ===================================================================
;
;   Limitations before version 1.0:
;   - commandline tool (no device driver, no IOCTL yet)
;   - to be used with supplied MODECON.EXE only
;   - parses RAW files only (no CPI files)

CPU     8086

;
;   Driver you want to compile (uncomment ONLY one!)
;

%define DISPLAY
;%define PRINTER

;       .       .       .       .       .       .       line that rules
;
;===================================================================
; VERSION CONSTANT
;===================================================================
;
; NOTE: To change it, please also modify the output string at the
;       bottom of the file

Version                 EQU     0009H   ; Version of the driver


;===================================================================
; DRIVER ERROR CONSTANTS
;===================================================================
;
; Explained the functions where errors are admissible

ERR_CPNotPrepared       EQU     26      ; Select (SW)
ERR_CPNotSelected       EQU     26      ; Query
ERR_KEYBFailed          EQU     27      ; Select (HW/SW)
ERR_QueryDeviceError    EQU     27      ; Query
ERR_DevCPNotFound       EQU     27      ; Prepare
ERR_SelPrepDeviceError  EQU     29      ; Select (HW/SW), Prepare
ERR_FileDamaged         EQU     31      ; Prepare

;===================================================================
; OTHER CONSTANTS
;===================================================================
;

CommandLine_Offset      EQU     080h    ; where in PSP is commandline

;===================================================================
; PROGRAM HEADER
;===================================================================
;
;               .       .       .       .       .       line that rules

                ORG     100H
                jmp     NEAR Install     ; simply go to Install

DevName         DB      "        "      ; Device name

;===================================================================
; INTERRUPT SERVICES  (DISPLAY only)
;===================================================================
;
;       .       .       .       .       .       .       line that rules

%ifdef          DISPLAY

%include        "videoint.asm"
%include        "muxint.asm"

%endif

;===================================================================
; RESIDENT SUBROUTINES
;===================================================================
;
;       .       .       .       .       .       .       line that rules


; Fn:   FindCodepage
; Does: Finds a codepage in the prepared array
; In:   BX=new codepage
; Out:  CL=position in table (starts on 0=first hardware codepage, ...)
;          (0ffh if not found)
;       CH=00h


FindCodepage:   xor     cx,cx           ; CL: total table size
                mov     cl,[cs:wNumSoftCPs]
                add     cl,[cs:wNumHardCPs]
                push    bx
                mov     ax,bx
                mov     bl,cl           ; copy of table size on BL
                inc     cl              ; to control the loop better

                mov     di,wHardCPs     ; DS:SI: begining of table
                push    es
                push    cs
                pop     es
                cld

        repne   scasw

                test    cl,0ffh
                jnz     CodepageFound
                mov     cl,0ffh
                jmp     FindCodepageEnd


CodepageFound:
                xchg    bl,cl
                sub     cl,bl           ; tablesize-loop = position

FindCodepageEnd:
                pop     es
                pop     bx
                ret


; Fn:   SelectCodepage
; Does: Selects a codepage from the pool
; In:   BX=new codepage
; Out:  AX=0 if not found, and in this case
;         DX= error code (otherwise DX untouched)
;


SelectCodepage: ;************ PUSH globally DI, SI, DX

                push    di
                push    si
                push    dx

                ;************ check if KEYB/PRINT are ready for the change

                push    bx              ; save cp number, just in case
jmp KeybOK
%ifdef          DISPLAYe
                mov     ax,0ad80h       ; first see if it is installed
                int     02fh
                cmp     al,0ffh
                jne     KeybOK          ; if not found, continue
                mov     ax,0ad81h
                pop     bx
                clc
                push    bx
                int     02fh
                jnc     KeybOK
                jmp     KeybFailed
%endif

%ifdef          PRINTER
                push    ds
                mov     ax,0104h        ; Freeze status to read config
                int     02fh
                jc      PrintFailed
                mov     dl,[ds:si]      ; get first byte of the first
                pop     ds              ; file in the print queue
                mov     ax,0105h        ; Restore status (hope to succeed!)
                int     02fh
                test    dl,0ffh         ; now test if there are files to
                jz      KeybOK          ; print, if there is any -> fail
                jmp     KeybFailed      ; (DS already pop-ed)

PrintFailed:    pop     ds
%endif

KeybFailed:     pop     bx              ; KEYB or PRINT are not ready
                mov     dx, ERR_KEYBFailed
                jmp     SelectCodepageError

                ;************ If =current, then REFRESH

KeybOK:
                pop     bx              ; recover codepage number

                cmp     bx, [cs:wCPselected]
                jne     CheckBuffer

                push    cx
                test    BYTE [cs:bActive], 0ffh
                jz      RefreshHW

PreRefreshSW:
                push    es
                push    ds
                
                jmp     RefreshSW

                ;************ see if it is the one in the buffer

CheckBuffer:
                cmp     bx,[cs:wCPbuffer]
                jne     NotRefresh

                push    cx
                jmp     PreRefreshSW

                ;************ see if it is in the table
                
NotRefresh:
                push    cx
                call    FindCodepage    ; see if we find it
                cmp     cl, 0ffh
                jne     CPFound
                mov     dx, ERR_CPNotPrepared
                pop     cx
                jmp     SelectCodepageError

CPFound:
                ;************ READY TO SELECT

                cmp     cx,[cs:wNumHardCPs]
                jae     SetSWCodepage
                mov     [cs:whtCPselected], cx

                ;************ set the hardware codepage

RefreshHW:      mov     cx,[cs:whtCPselected]
                call    [cs:pRefreshHWcp]
                pop     cx

                jc      SelectCodepageError

                mov     BYTE [cs:bActive],0

                jmp     SelectCodepageSuccess

                ;************ set the software codepage

SetSWCodepage:

                push    es
                push    ds

                push    cs              ; source at ds:si
                pop     ds

                mov     si,SCP1
                sub     cx,[cs:wNumHardCPs]
                mov     al,cl
                mov     dx,[cs:wTableSize]
                shl     dx,1            ; table size is in Words
                mul     dx              ; offset = SCP1 + TableSize * pos
                add     si,ax

                push    cs              ; target at es:di
                pop     es

                mov     di,bFont8x8

                mov     cx,[cs:wTableSize]
           rep  movsw

RefreshSW:
                mov     ax,0b000h       ; first see if GRAFTABL is active
                int     02fh
                cmp     al,0ffh
                jne     NoGraftabl

                push    bx              ; preserve BX!
                mov     ax,0b001h       ; GRAFTABL present, import the
                push    cs              ; table to DS:BX
                pop     ds
                mov     bx,dGraftablBuf
                int     02fh
                pop     bx
                
NoGraftabl:
                mov     al,-1           ; unknown vide mode!
                call    [cs:pRefreshSWcp]

                pop     ds
                pop     es
                pop     cx

                mov     [cs:wCPbuffer],bx
                                        ; the buffer we copied

                mov     dx, ERR_SelPrepDeviceError
                                        ; in case of success, DX will be
                                        ; POP-ed

                jc      SelectCodepageError
                
                mov     BYTE [cs:bActive],1

                ;************ exit routines: we have BX=CP

SelectCodepageSuccess:

                mov     [cs:wCPselected],bx
                mov     ax, 0001h
                clc

                jmp     SelectCodepageEnd2

SelectCodepageError:
                mov     si,sp
                mov     word [ss:si],dx
                xor     ax,ax
                stc
                jmp     SelectCodepageEnd2

SelectCodepageEnd:
                pop     cx
SelectCodepageEnd2:
                pop     dx
                pop     si
                pop     di
                ret
                

; Fn:   PrepareCodepage
; Does: Prepares the codepage in the oldest pool
; In:   BX:      codepage number
;       DS:SI->  RAW table to be copied from
;       DX:      position in the table where TO copy (starts on 0)
; Out:  DX:      Error code, 0 if not error
;

PrepareCodepage:
                push    ax
                push    cx
                push    es
                push    di

                cmp     dl,[cs:wNumSoftCPs]
                ja      passtable       ; compare position with array size

                mov     di, [cs:wNumHardCPs]
                add     di, dx
                shl     di, 1
                add     di, wHardCPs    ; everything correct: store cp
                mov     [cs:di], bx

                mov     ax, [cs:wTableSize]
                shl     ax, 1           ; table size is in Words
                mul     dx              ; offset = SCP1 + TableSize * pos
                add     ax, SCP1
                mov     di, ax

                push    cs              ; segment = CS
                pop     es

		cld			; for crazy callers
                mov     cx,[cs:wTableSize]
           rep  movsw

                xor     dx,dx
                jmp     prepareEnd

passtable:
                mov     dx, ERR_SelPrepDeviceError

prepareEnd:
                pop     di
                pop     es
                pop     cx
                pop     ax

                ret


;===================================================================
; HARDWARE DEPENDANT SELECT ROUTINES
;===================================================================
;
;       .       .       .       .       .       .       line that rules

%ifdef          DISPLAY
%include        "selectd.asm"
%endif

%ifdef          PRINTER
%include        "selectp.asm"
%endif




;===================================================================
; DISPLAY DATA SEGMENT
;===================================================================
;
;               .       .       .       .       .       line that rules

bActive         DB      0               ; SW codepage selected?
dGraftablBuf    DD      0               ; Graftabl table Buffer
wCPselected     DW      -1              ; Selected codepage
wCPbuffer       DW      0               ; CP in buffer bFont8x8
whtCPselected   DW      0               ; position in the hardware table of
                                        ; current hardware codepage
wTableSize	DW	0		; Total RAW table size in WORDS

pRefreshHWcp    DW      0               ; Hardware codepage select procedure
pRefreshSWcp    DW      0               ; Software codepage select procedure

bFont8x8:       times   2048 DB 0       ; space for the 8x8 font
bFont8x14:      times   3584 DB 0       ; space for the 8x14 font
bFont8x16:      times   4096 DB 0       ; space for the 8x16 font

wNumSoftCPs     DW      0               ; number of software codepages
wNumSubFonts    DW      0               ; number of subfonts (m)
wNumHardCPs     DW      1               ; number of hardware codepages
wHardCPs        DW      0               ; hardware CP list
wSoftCPs        DW      0,0,0,0,0       ; number of software codepages


;===================================================================
; DISPLAY DATA POOLS
;===================================================================
;               .       .       .       .       .       line that rules
;
; Prepared Codepage Tables (array of these structures)
; (maximum= 5 of the (8,14,16) size
;

SCP1            times 9728 db 0
                times 9728 db 0
                times 9728 db 0
                times 9728 db 0
                times 9728 db 0

bLastByte:


;===================================================================
; NON-RESIDENT VARIABLES
;===================================================================
;

pMemTop:        DW      bLastByte       ; top of memory
wMinFontSize:   DW      0               ; minimum font size
                                        ; 1=8x8  2=8x8,14  3=8x8,14,16
bMaxHWcpNumber: DB      0               ; maximum number of hardware CPs
                                        ; admissible, 0 if unknown


;===================================================================
; NON-RESIDENT HARDWARE DEPENDANT ROUTINES AND TABLE
;===================================================================
;

%ifdef          DISPLAY
%include        "HWInitD.asm"
%endif

%ifdef          PRINTER
%include        "HWInitP.asm"
%endif



;===================================================================
; MAIN FOR THE .COM VERSION
;===================================================================
;
;               .       .       .       .       .       line that rules


Install:
                push    cs
                call    DoInstall       ; call DoInstall
                jc      Done            ; Carry? then we should exit
                mov     dx,[pMemTop]
                int     27H             ; TSR  for .COM files
Done:           int     20H             ; Exit for .COM files



;===================================================================
; INSTALLATION RUNTIME FUNCTIONS
;===================================================================
;
;               .       .       .       .       .       line that rules


; Fn:   OutStrDX
; In:   DX: near pointer to string to be displayed
; Out:  -

OutStrDX:       mov     ah,9
                int     21H
		stc			; Error
                ret			; From DoInstall



; Fn:   DoInstall
; In:   -
; Out:  CF on error (do not stay resident)


DoInstall:
                ;****** show copyright and version

                mov     dx,copyVer
                call    OutStrDX

                ;****** check if already loaded
%ifdef DISPLAY
                mov     ax,0ad00H
                int     2fH
                cmp     al,-1
                jne     TestDRK

                mov     dx,errAlready
                jmp     OutStrDX

                ;****** Some versions of DR-KEYB are a no-no
TestDRK:
                mov     ax,0ad80h
                xor     bx,bx
                mov     cx,bx
                int     02fh
                cmp     ah,0ffh         ; KEYB installed?
                jne     ScanCommandline
                test    bx,0ffffh       ; MS-KEYB?
                jnz     ScanCommandline
                test    cx,0ffffh       ; FD-KEYB?
                jz      ScanCommandline
                cmp     ch,7
                jae     ScanCommandline ; check DR-KEYB version
                mov     dx,errNoDRDOS
                jmp     OutStrDX
%endif

                ;****** SCAN COMMANDLINE, in STAGES
ScanCommandline:
                cld 
                cli

                push    cs
                pop     es
                push    cs
                pop     ds


                ; 1.- Find the string and capitalize it

                mov     cx, [cs:CommandLine_Offset]
                mov     si, CommandLine_Offset+1
loop0:          mov     al, [cs:si]
                cmp     al, 13
                je      endUpper
                cmp     al, 'a'
                jb      cont0
                cmp     al, 'z'
                ja      cont0
                sub     al, 'a'-'A'
                mov     [cs:si], al
cont0:          inc     si
                loop    loop0
endUpper:

                ; 2.- Remove starting spaces
    
                mov     cx, [cs:CommandLine_Offset]
                mov     si, CommandLine_Offset+1
loop1:          lodsb
                cmp     al, 13
                jne     skp1
                mov     dx, SES_ParamRequired
                jmp     SyntaxError
skp1:           cmp     al, ' '
                loopne  loop1


                ; 3.- Save device name
                ;     Also block illegal chars (ASCII compatibility
                ;     assumed)

                mov     di, DevName
                mov     cx, 8
loop2:          mov     al, [es:si]
                cmp     al, '='
                je      EndDevName
                cmp     al, ':'
                je      EndDevName
                cmp     al, 13
                jne     skp2
                mov     dx, SES_UnexpectedEOL
                jmp     SyntaxError
skp2:           cmp     al, '/'
                je      illegalChar
                cmp     al, '\'
                je      illegalChar
                cmp     al, 34          ; illegal char: "
                je      illegalChar
                cmp     al, '*'
                je      illegalChar
                cmp     al, '|'
                je      illegalChar
                cmp     al, '<'         ; illegal chars: '<'..'?'
                jb      cont1
                cmp     al, '?'
                ja      cont1
                cmp     al, '='         ; and =
                je      cont1              
                jmp     illegalChar
cont1:          movsb
                loop    loop2
                mov     dx, SES_NameTooLong
                jmp     SyntaxError

illegalChar:    mov     dx, SES_IllegalChar
                jmp     SyntaxError

EndDevName:
                cmp     al, ':'
                jne     cont2
                inc     si

cont2:          inc     si              ; it was pointing to =
                mov     al, '('
                mov     di, si
                scasb
                je      skp3
                mov     dx, SES_OpenBrExpected
                jmp     SyntaxError
       

                ; 4.- Get hardware name and initialize it

skp3:           inc     si
                mov     di, HardwareTables

loop3b:
                push    si              ; si->begining of the name
                mov     cx, 8           ; length+1
           repe cmpsb
                je      HwTypeFound     ; if =, then CX=0 => found
                dec     si
                mov     al, [ds:si]
                cmp     al, ','
                jne     skp3b           ; if commandline<>, error
                dec     di
                mov     al, [es:di]
                test    al, 0ffh
                jz      HwTypeFound     ; if sourcename<>0 error

skp3b:          pop     si              ; recover si->beginig of the name
                add     di,cx           ; di->CP-HardwareName
                add     di,12           ; skip the table
                mov     al, [es:di]
                test    al, 0ffh        ; 0=end of the table
                jnz     loop3b

                mov     dx, SES_WrongHwName
                jmp     SyntaxError     ; hardware NOT supported

HwTypeFound:
                pop     di              ; discard 1 element from stack
                mov     di, si
                mov     al, ','
                scasb
                je      jmp4

needC:          mov     dx, SES_CommaExpected
                jmp     SyntaxError
jmp4:           inc     si

                                        ; initialize it!
                mov     ax,[cs:HardwareTables+18]
                call    [cs:HardwareTables+16]
                jc      OutStrDX        ; print error string and exit

                ; 5.- HWCodepage
                cmp     byte [cs:si],'('
                jne     HW1codepage
                inc     si
                mov     di,wHardCPs
                mov     ch,5
                call    ReadSW
                xor     ch,ch
                mov     [cs:wNumHardCPs],cx
                jmp     CommaBeforeFonts
HW1codepage:
                call    ReadNumber
                mov     [cs:wHardCPs], ax

CommaBeforeFonts:
                mov     di, si
                mov     al,','
                scasb
                jne     needC           ; , expected
                inc     si

                ; check that it does not exceed the maximum number of hw fonts
                test     BYTE [cs:bMaxHWcpNumber],0ffh
                jz       ArraySize
                mov      cx,[cs:wNumHardCPs]
                cmp      cx,[cs:bMaxHWcpNumber]
                jna      ArraySize
                mov      dx, SES_TooManyHWPools
                jmp      SyntaxError

                ; 6.- ArraySize

ArraySize:
%ifdef          DISPLAY
                cmp     byte [cs:si],'('
                jne     NoSubfonts      ; (fonts,subfonts) specified
                inc     si
                mov     di,wNumSoftCPs
                mov     ch,2
                call    ReadSW
                mov     ax,[cs:wNumSoftCPs]
                jmp     numberOk
NoSubfonts:
%endif
                call    ReadNumber      ; number of fonts only
                cmp     ax, 5           ; maximum: 5
                jna     numberOk
                mov     dx, SES_TooManyPools
                jmp     SyntaxError

numberOk:
                test    al,0ffh         ; minimum: 1
                jnz     jmp4b
                inc     al
jmp4b:          mov     [cs:wNumSoftCPs], ax
                                        ; number of subfonts ok?
                mov     ax,[cs:wMinFontSize]
                cmp     ax,[cs:wNumSubFonts]
                jbe     ClosingBracket
                mov     [cs:wNumSubFonts],ax

                ; 7.- No more arguments

ClosingBracket:
                mov     di, si
                mov     al,')'
                scasb
                je      jmp5
                mov     dx, SES_CloseBrExpected
                jmp     SyntaxError
jmp5:           inc     si

loop4b:         lodsb
                cmp     al,' '
                je      loop4b
                cmp     al,13
                je      jmp6
                mov     dx, SES_WrongNumberPars
                jmp     SyntaxError     ; wrong # of params specified

jmp6:           sti                     ; success


                ;****** END SCAN COMMANDLINE (everything OK)

                ;****** Compute the size of the table (from subfonts)

                mov     ax,[cs:wNumSubFonts]
                cmp     ax,1
                ja      Subfonts2
                mov     WORD [wTableSize],128*8
                jmp     SetVectors
Subfonts2:      cmp     ax,2
                ja      Subfonts3
                mov     WORD [wTableSize],128*(8+14)
                jmp     SetVectors
Subfonts3:      mov     WORD [wTableSize],128*(8+14+16)

                ;****** fill the GraftablBuffer

                mov     WORD [cs:dGraftablBuf],bFont8x8
                push    cs
                pop     ax
                mov     [cs:dGraftablBuf+2],ax

                ;****** set our interrupt vectors (DISPLAY ONLY)
SetVectors:

%ifdef          DISPLAY

                mov     ax,352fH        ; Get vector 2f
                int     21H
                mov     [dOld2f],bx
                mov     [dOld2f+2],es

                mov     dx,New2f
                mov     ax,252fH        ; Set vector 2f
                int     21H

                mov     ax,3510H        ; Get vector 10
                int     21H
                mov     [dOld10],bx
                mov     [dOld10+2],es

                mov     dx,New10
                mov     ax,2510H        ; Set vector 10
                int     21H
%endif

                ;****** Compute the resident size

                mov     dx,[cs:wNumSoftCPs]
                mov     ax,[cs:wTableSize]
                shl     ax,1
                mul     dx              ; wTableSize x NumSoftCPs
                add     ax,SCP1         ; + BeginCodepage1
                mov     [cs:pMemTop],ax

                ;****** Free environtment space

EndInstall:
                mov     ax, [cs:02ch]
                mov     es, ax
                mov     ah, 049h
                int     21h

                clc
                retf

; Fn:   WriteNumber
; In:   AX: number of at most 3 cyphers to be written
; Out:  -
; Note: SyntaxErrorStr space is reused (as it is no longer used when
;       this function is called)
;       I know this is not the most optimal code in the world...

WriteNumber:     mov    di,SyntaxErrorStr     ; reuse the space
                 mov    bx,100
                 call   DWriteCypher
div10:           mov    al,ah
                 xor    ah,ah
                 mov    bx,10
                 call   DWriteCypher
                 mov    al,ah
                 call   WriteCypher
                 mov    BYTE [es:di],'$'
                 mov    dx, SyntaxErrorStr
                 jmp    OutStrDX              ; write the str and exit

DWriteCypher:    div    bl

; with these two lines, heading 0 were not printer, but numbers 100-109
; were not correctly printed; I don't think it's worth to make this nicer
;
; -- Aitor
;                 test   al,0FFh
;                 jz     retWC
WriteCypher:     add    al,'0'
                 mov    [es:di],al
                 inc    di
retWC:           ret


; Fn:   SyntaxError
; In:   DX: error string to be displayed
; Out:  -

SyntaxError:     push   dx                 ; save address of string to output
                 mov    dx, SyntaxErrorStr
                 call   OutStrDX

                 mov    ax, si
                 sub    ax, CommandLine_Offset
                 call   WriteNumber

                 pop    dx
                 call   OutStrDX

                 mov    dx, ReturnString
                 call   OutStrDX

                 sti
                 stc
                 jmp    Done

; Fn:   ReadNumber
; In:   ES:SI -> a string number of at most 5 cyphers
; Out:  AX the number read
; Note: it stops whenever it finds the first non-number character or
;       whenever 5 characters are read
;       I know this is not the most optimal code in the world...


ReadNumber:      xor    ax,ax
                 xor    bx,bx
                 mov    cx,5
loop5:           cmp    BYTE [es:si],'0'
                 jb     EndReadNumber
                 cmp    BYTE [es:si],'9'
                 ja     EndReadNumber
                 mov    dx, 10             ; DX annihilated by MUL!
                 mul    dx
                 mov    bl, [es:si]
                 add    ax, bx
                 sub    ax, '0'
                 inc    si
                 loop   loop5
EndReadNumber:   ret



; Fn:   ReadSW
; In:   ES:SI -> list of the form [number,] ... )
;       ES:DI -> array of WORD to store the list
;       CH maximum admissible length
; Out:  CL lenght of the list
; Note: it stops whenever it finds the )
;       on error condition (illegal char, list too long) it aborts
;       automatically


ReadSW:          xor    cl, cl
NextItemListSW:  push   cx
                 call   ReadNumber
                 pop    cx
                 inc    cl
                 stosw
                 lodsb
                 cmp    al, ','
                 jne    NotCommaSW
                 cmp    cl, ch
                 jb     NextItemListSW
                 mov    dx, SES_ListTooLong
                 jmp    SyntaxError
NotCommaSW:      cmp    al, ')'
                 je     ReadSWEnd
                 mov    dx, SES_IllegalChar
                 jmp    SyntaxError
ReadSWEnd:       ret


;===================================================================
; STRINGS, ARRAYS and STRUCTURES
;
;               .       .       .       .       .       line that rules


; Copyright message
%ifdef           DISPLAY
copyVer          DB     "FreeDOS DISPLAY ver. 0.09", 0dH, 0aH, "$"
%endif
%ifdef           PRINTER
copyVer          DB     "FreeDOS PRINTER ver. 0.09", 0dH, 0aH, "$"
%endif
ReturnString     DB      0dH, 0aH, "$"

;               LOCALISED Strings

%include        "strings.en"

                 END
