#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<io.h>
#include<fcntl.h>
#include<DOS.h>

#define CF 1	/*Carry flag */


unsigned int ShowCodepage ( void )
{
	unsigned int cp=0;

	asm {  MOV AX, 0xAD02
		 INT 0x2F
		 MOV cp, BX
	}
	puts   ("Status for device CON:");
	puts   ("======================");
	puts   ("");
	if (cp != 0xFFFF)
		printf ("Active codepage for device CON is %u\n", cp);
	else
		puts   ("Active codepage was never set");
	puts   ("");
	puts   ("MODE status code page function completed");
	return (cp);
}



unsigned int CodepageSelect ( unsigned int cp )
{
	unsigned int success;

	asm { MOV AX, 0xAD01
		MOV BX, cp
		INT 0x2F
		MOV success, AX
	}
	if (success)
		printf ("MODE select codepage %u function completed\n", cp);
	else
		printf ("MODE: unable to select codepage %u\n", cp);
	return (success);
}



unsigned int CheckFDDisplayVer ( void )
{
	unsigned char Rah;
	unsigned int  Rbx;

	asm { MOV AX, 0xAD00
		INT 0x2F
		MOV Rah, AH
		MOV Rbx, BX
	}
	return ( (Rah==0xFF) && (Rbx==0x0006));  /* version 0.06 only! */
}



unsigned int CodepagePrepare (unsigned int cp, char *filename)
{
	int cpf;
	unsigned char buf[9728];
	unsigned int  s,o,f;

	/** Determine that it is FreeDOS DISPLAY **/
/*	if (!CheckFDDisplayVer())
	{
		puts ("MODE: FreeDOS Display ver. 0.X not found");
		return (-1);
	} */

	/** Check that the file exists **/
	if ((cpf = open(filename, O_RDONLY | O_BINARY)) == -1)
	{
	   printf ("MODE: File not found - %s", filename);
	   return (-1);
	}

	/** Check that the file has the correct size **/
	if ( filelength(cpf) != 9728)  /*  9728=256*(8+14+16)  */
	{
		puts ("MODE: File hasn't got the appropriate size (9728b)");
		printf ("(it has %u)\n",filelength(cpf));
		return (-1);
	}

	/** Read the buffer **/
	if ( read(cpf, buf, 9728) != 9728 )
	{
		puts ("MODE: Read error when reading from file");
		return (-1);
	}

	/** Send the buffer **/
	s = FP_SEG(buf);
	o = FP_OFF(buf);
	asm {   MOV AX, 0xAD0E
		  MOV BX, cp
		  MOV DS, s
		  MOV SI, o
		  INT 0x2F
		  PUSHF
		  POP AX
		  MOV f, AX
	}

	/** Check the result **/
	if ( f & CF )
	{
		printf ("MODE: Error when setting codepage %u\n", cp);
		puts   ("(HINT: hardware codepage should be selected to");
		puts   ("perform this operation)");
		return (-1);
	}

		printf ("MODE prepare codepage %u function completed\n", cp);

}



#define NoAction    	0
#define GetCodepage 	1
#define SetCodepage 	2
#define PrepareCodepage 3
#define FastHelp		4
#define SyntaxError	10
#define CPSyntaxError	11

int main (int argc, char *argv[])
{

	unsigned char action = NoAction;
	unsigned int  codpn  = 0;

	switch (argc)
	{
		case 2:
		   if ( !strcmp (argv[1], "/?") )	/* check FastHelp /? */
		   {
			action = FastHelp;
			break;
		   }
		case 4: case 5:

		   /*** First param should always be CODEPAGE ***/
		   strupr (argv[1]);
		   if ( strcmp (argv[1], "CODEPAGE") && strcmp (argv[1], "CP"))
		   {
			action = SyntaxError;
			break;
		   }
		   if (argc==2)
		   {
			action = GetCodepage;
			break;
		   }

		   /*** If 3 or 4 parameters, should be either PREPARE or SELECT ***/
		   strupr (argv[2]);
		   if ( !strcmp (argv[2], "SELECT") )
		   {
			action = SetCodepage;
			break;
		   }
		   if ( argc==4 )
		   {
			action = SyntaxError;
			break;
		   }

		   if ( !strcmp (argv[2], "PREPARE") )
		   {
			action = PrepareCodepage;
			break;
		   }
		default:
		   action = SyntaxError;
	}


	if ( (action==SetCodepage) || (action==PrepareCodepage))
		if  ( ! (codpn = atoi (argv[3])) )
			action = CPSyntaxError;

	switch (action)
	{
			case GetCodepage:
			   ShowCodepage ();
			   break;
			case SetCodepage:
			   CodepageSelect (codpn);
			   break;
			case PrepareCodepage:
			   CodepagePrepare (codpn, argv[4]);
			   break;
			case FastHelp:
			   puts ("MODECON  CODEPAGE  [ SELECT  n]");
			   puts ("MODECON  CODEPAGE  PREPARE n filename");
			   puts ("MODECON   /?");
			   puts ("");
			   puts ("Interfaces codepage management with FreeDOS DISPLAY 0.06 driver");
			   puts ("CODEPAGE                     Shows currently active codepage");
			   puts ("CODEPAGE PREPARE n filename  Prepares codepage number n");
			   puts ("CODEPAGE SELECT n            Sets (previously prepared) codepage n");
			   puts (" 				         as active codepage");
			   puts ("REMARKS");
			   puts ("- CODEPAGE may be abbreviated by CP");
			   puts ("- Codepages should be prepared before they can be selected");
			   puts ("- Preparing codepage n requires the existence of the CPn.RAW file");
			   break;
			case SyntaxError:
			   puts ("MODECON: Syntax error");
			   puts ("Please, check  MODECON /?  for further information");
			   return (-1);
			case CPSyntaxError:
			   puts ("MODECON: Invalid codepage number.");
			   return (-1);
			default:
			   puts ("MODECON: Internal error");
			   puts ("Please, report commandline to aitor.sm@wanadoo.es");
			   return (-1);
	}
}
