#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include "symglobl.h"

/* Read DJGPP-style symlinks */
ssize_t readlink( const char * restrict path, char * restrict buf, size_t bufl )
{
    char link[ 510 ], *p = link + 10, *b = buf;
    int handle, i = 0, j = bufl;

    if( ( handle = _open( path, O_RDONLY ) ) == -1 ) return( -1 );

    if( ( i = _read( handle, link, 510 ) ) != 510 ) {
        if( i != -1 ) errno = EINVAL; /* Not a symlink (510 bytes long) */

        _close( handle );
        return( -1 );
    }
    _close( handle );

    if( strncmp( link, __beginsymb, 10 ) != 0 ) {
        errno = EINVAL;

        return( -1 );
    }

    i = 0;

    while( j && *p != '\n' ) {
        *b = *p;
        j--, p++, b++, i++;
    }

    *b = '\0';
    p++;

    if( strncmp( p, __finishsym, 105 ) != 0 ) {
        errno = EINVAL;

        return( -1 );
    }

    strcpy( link, buf );

    if( ( handle = readlink( link, buf, bufl ) ) == -1 ) return( i );

    return( handle );
}

