\ 4tH library - PARSING - Copyright 2009, 2012 J.L. Bezemer
\ You can redistribute this file and/or modify it under
\ the terms of the GNU General Public License

[UNDEFINED] "parse" [IF]
\ Perform a normal parse, but take quoted fields 
\ with embedded delimiters into account

: "parse"                              ( c -- a n)
  dup parse dup                        \ save delimiter and parse
  if                                   \ is string not empty?
    over c@ [char] " =                 \ is the first character a quote?
    if                                 ( n1 a2 n2)
      begin                            \ drop last character preliminary
        1- 2dup chars + c@ [char] " <> \ is the last character not a quote?
      while                            \ if so, parse again for delimiter
        1+ >r over parse chars + over - dup r> =
      until chop                       \ chop first character
    then 
  then rot drop                        \ drop the delimiter
;

\ perform a user defined parse, but leave a false flag when EOL is detected
: (parse?) >in @ >r execute >in @ r> > ;
: parse? :noname parse ; (parse?) ;    ( c -- a n f)
: "parse"? ['] "parse" (parse?) ;      ( c -- a n f)
[THEN]
