\ Generated by MAKEINFO.4TH - Copyright J.L. Bezemer 2014

include lib/info.4th

width string search-key

offset info-4th
  TAG info-4th "!"
    c" ! CORE" 10 c,
    c" Pronunciation: store" 10 c,
    c" Compiles to: ! (0)" 10 c,
    c" Stack effects: n x ---" 10 c,
    c" Stores n in the variable at address x." 10 c,
    0 c,
  TAG info-4th "#"
    c" # CORE" 10 c,
    c" Pronunciation: number-sign" 10 c,
    c" Compiles to: # (0)" 10 c,
    c" Stack effects: n1 --- n2" 10 c,
    c" Forth: In Forth a double number is required." 10 c,
    c" Generate from n1 the next ASCII character which is placed in an" 10 c,
    c" output string, stored in PAD. Result n2 is the quotient after the" 10 c,
    c" division by BASE, and is remained for further processing. Used" 10 c,
    c" between <# and #>." 10 c,
    0 c,
  TAG info-4th "#!"
    c" #! 4TH" 10 c,
    c" Syntax: #!<space><string>" 10 c,
    c" The remainder of the line is discarded. This word is used to" 10 c,
    c" start a 4tH source program from a Unix type shell. An alias for" 10 c,
    c" \." 10 c,
    0 c,
  TAG info-4th "#>"
    c" #> CORE" 10 c,
    c" Pronunciation: number-sign-greater" 10 c,
    c" Compiles to: #> (0)" 10 c,
    c" Stack effects: n1 --- addr n2" 10 c,
    c" Forth: In Forth a double number is required." 10 c,
    c" Terminates numeric output conversion by dropping n1, leaving the" 10 c,
    c" address in PAD and character count n2 suitable for TYPE." 10 c,
    0 c,
  TAG info-4th "#S"
    c" #S CORE" 10 c,
    c" Pronunciation: number-sign-s" 10 c,
    c" Compiles to: #S (0)" 10 c,
    c" Stack effects: n1 --- n2" 10 c,
    c" Forth: In Forth a double number is required." 10 c,
    c" Generates ASCII text in PAD by the use of # until a zero number" 10 c,
    c" n2 results. Used between <# and #>." 10 c,
    0 c,
  TAG info-4th "#TIB"
    c" #TIB CORE EXT" 10 c,
    c" Pronunciation: number-t-i-b" 10 c,
    c" Include: obsolete.4th" 10 c,
    c" Stack effects: --- x" 10 c,
    c" X is the address of a cell containing the number of characters in" 10 c,
    c" the terminal input buffer (see /TIB)." 10 c,
    0 c,
  TAG info-4th "'"
    c" ' CORE" 10 c,
    c" Pronunciation: tick" 10 c,
    c" Compiles to: LITERAL (<argument of symbol>)" 10 c,
    c" Syntax: '<space><name>" 10 c,
    c" Stack effects: --- x | xt | n" 10 c,
    c" Forth: In Forth you can determine the address of variables," 10 c,
    c" constants, etc. In 4tH the contents of the symboltable entry is" 10 c,
    c" returned. Of course the token addresses of built-in primitives" 10 c,
    c" cannot be determined either. E.g. use" 10 c,
    c" : _+ + ; ' _+" 10 c,
    c" instead of" 10 c,
    c" ' +" 10 c,
    c" Compile the value contents of the symboltable entry identified as" 10 c,
    c" symbol <name> as a literal." 10 c,
    0 c,
  TAG info-4th "("
    c" ( CORE   FILE" 10 c,
    c" Pronunciation: paren" 10 c,
    c" Syntax: (<space><string>)" 10 c,
    c" Ignore a comment that will be delimited by a right parenthesis." 10 c,
    c" May occur inside or outside a colon-definition. A blank after the" 10 c,
    c" leading parenthesis is required." 10 c,
    0 c,
  TAG info-4th "(ERROR)"
    c" (ERROR) 4TH" 10 c,
    c" Compiles to: LITERAL (<largest negative integer>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Returns 4tHs internal error-flag. This number cannot be printed." 10 c,
    c" Usually -2^31." 10 c,
    0 c,
  TAG info-4th ")"
    c" ) 4TH" 10 c,
    c" Compiles to: EQ0 (0)" 10 c,
    c" 0BRANCH (<address of THROW>)" 10 c,
    c" LITERAL (<M4ASSERT>)" 10 c,
    c" THROW (0)" 10 c,
    c" Stack effects: f ---" 10 c,
    c" Forth: Similar constructions are available in GForth and" 10 c,
    c" Win32Forth." 10 c,
    c" If flag f is FALSE, the program will terminate with an error. Its" 10 c,
    c" compilation is dependant on the presence of [ASSERT] (see:" 10 c,
    c" [ASSERT] and ASSERT()." 10 c,
    0 c,
  TAG info-4th "*"
    c" * CORE" 10 c,
    c" Pronunciation: star" 10 c,
    c" Compiles to: * (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leave the product n3 of two numbers n1 and n2." 10 c,
    0 c,
  TAG info-4th "*/"
    c" */ CORE" 10 c,
    c" Pronunciation: star-slash" 10 c,
    c" Compiles to: */ (0)" 10 c,
    c" Stack effects: n1 n2 n3 --- n4" 10 c,
    c" Leave the ratio n4 = n1*n2/n3." 10 c,
    0 c,
  TAG info-4th "*/MOD"
    c" */MOD CORE" 10 c,
    c" Pronunciation: star-slash-mod" 10 c,
    c" Compiles to: >R (0)" 10 c,
    c" * (0)" 10 c,
    c" R> (0)" 10 c,
    c" /MOD (0)" 10 c,
    c" Stack effects: n1 n2 n3 --- n4 n5" 10 c,
    c" Leave the quotient n5 and remainder n4 of the operation n1*n2/n3." 10 c,
    0 c,
  TAG info-4th "*CONSTANT"
    c" *CONSTANT 4TH" 10 c,
    c" Syntax: <literal><space>*CONSTANT<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for *CONSTANT. The instruction pointer is decremented, actually" 10 c,
    c" deleting the literal." 10 c,
    c" A defining word used to create word <name>. When <name> is later" 10 c,
    c" executed, it will multiply the top of the stack with the value of" 10 c,
    c" <literal>." 10 c,
    0 c,
  TAG info-4th "+"
    c" + CORE" 10 c,
    c" Pronunciation: plus" 10 c,
    c" Compiles to: + (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leave the sum n3 of n1+n2." 10 c,
    0 c,
  TAG info-4th "+!"
    c" +! CORE" 10 c,
    c" Pronunciation: plus-store" 10 c,
    c" Compiles to: +! (0)" 10 c,
    c" Stack effects: n x ---" 10 c,
    c" Add n to the value in variable at address x." 10 c,
    0 c,
  TAG info-4th "+CONSTANT"
    c" +CONSTANT 4TH" 10 c,
    c" Syntax: <literal><space>+CONSTANT<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for +CONSTANT. The instruction pointer is decremented, actually" 10 c,
    c" deleting the literal." 10 c,
    c" A defining word used to create word <name>. When <name> is later" 10 c,
    c" executed, it will add the value of <literal> on the top of the" 10 c,
    c" stack." 10 c,
    0 c,
  TAG info-4th "+FIELD"
    c" +FIELD FACILITY EXT" 10 c,
    c" Syntax:" 10 c,
    c" STRUCT<space><literal><space>+FIELD<space><name><space>END-STRUCT<space><name>" 10 c,
    c" Compiler: Take two previous compiled literals. The last literal" 10 c,
    c" is added to the first and recompiled. The first literal is the" 10 c,
    c" value of a named +CONSTANT. The instruction pointer does not" 10 c,
    c" change." 10 c,
    c" Create a field for STRUCTURE implementations. The created" 10 c,
    c" fieldname is an +CONSTANT that memorizes the current offset (see:" 10 c,
    c" +FIELD, /FIELD, STRUCT, END-STRUCT)." 10 c,
    0 c,
  TAG info-4th "+LOOP"
    c" +LOOP CORE" 10 c,
    c" Pronunciation: plus-loop" 10 c,
    c" Compiles to: +LOOP (<address of matching DO token>)" 10 c,
    c" Syntax: DO<space>..<space>+LOOP" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Used in the form DO .. n1 +LOOP. At runtime, +LOOP selectively" 10 c,
    c" controls branching back to the corresponding DO based on n1, the" 10 c,
    c" loop index and the loop limit. The increment n1 is added to the" 10 c,
    c" index and the total compared to the limit. The branch back to DO" 10 c,
    c" occurs until the new index is equal to or greater than the limit" 10 c,
    c" (n > 0), or until the new index is less than the limit (n < 0)." 10 c,
    c" Upon exiting the loop, the parameters are discarded and execution" 10 c,
    c" continues ahead." 10 c,
    0 c,
  TAG info-4th "+PLACE"
    c" +PLACE COMUS" 10 c,
    c" Compiles to: COUNT (0)" 10 c,
    c" + (0)" 10 c,
    c" PLACE (0)" 10 c,
    c" Stack effects: addr1 n addr2 ---" 10 c,
    c" Copies the string at address addr1 with count n to address addr2." 10 c,
    0 c,
  TAG info-4th "+X/STRING"
    c" +X/STRING XCHAR EXT" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: addr1 n1 --- addr2 n2" 10 c,
    c" Step forward by one xchar in the buffer defined by addr1 n1." 10 c,
    c" addr2 n2 is the remaining buffer after stepping over the first" 10 c,
    c" xchar in the buffer." 10 c,
    0 c,
  TAG info-4th ","
    c" , CORE" 10 c,
    c" Pronunciation: comma" 10 c,
    c" Compiles to: , (<literal>)" 10 c,
    c" Syntax: <literal><space>," 10 c,
    c" Compiler: The previously compiled literal is changed into a NOOP" 10 c,
    c" instruction. The instruction pointer is not incremented." 10 c,
    c" Forth: Forth pops a value from the stack. This is not possible in" 10 c,
    c" 4tH. Instead the previously compiled literal has its codefield" 10 c,
    c" changed to NOOP." 10 c,
    c" Store the literal into the next available location." 10 c,
    0 c,
  TAG info-4th |,"|
    c| ," COMUS| 10 c,
    c| Compiles to: ," (<address of string constant>)| 10 c,
    c| Syntax: ,"<space><string>"| 10 c,
    c" Forth: Compilation characteristics are quite different. 4tH" 10 c,
    c" compiles only the address, Forth compiles the entire string." 10 c,
    c| Compile the string, delimited by " in the String Segment and| 10 c,
    c" leave the offset as the address of a string constant (see: @C)." 10 c,
    0 c,
  TAG info-4th ",|"
    c" ,| 4TH" 10 c,
    c| Compiles to: ," (<address of string constant>)| 10 c,
    c" Syntax: ,|<space><string>|" 10 c,
    c" Compile the string, delimited by | in the String Segment and" 10 c,
    c" leave the offset as the address of a string constant (see: @C)." 10 c,
    0 c,
  TAG info-4th "-"
    c" - CORE" 10 c,
    c" Pronunciation: minus" 10 c,
    c" Compiles to: - (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leave the difference of n1 - n2 in n3." 10 c,
    0 c,
  TAG info-4th "->"
    c" -> 4TH" 10 c,
    c" Compiler: The instruction pointer is not incremented. In fact, ->" 10 c,
    c" is a dummy." 10 c,
    c" Syntax: <name><space>-><space><name>" 10 c,
    c" Separation between a structure and its member." 10 c,
    0 c,
  TAG info-4th "-ROT"
    c" -ROT COMUS" 10 c,
    c" Compiles to: ROT (0)" 10 c,
    c" ROT (0)" 10 c,
    c" Stack effects: n1 n2 n3 --- n3 n1 n2" 10 c,
    c" Rotate top stack item below the next two items." 10 c,
    0 c,
  TAG info-4th "-TRAILING"
    c" -TRAILING STRING" 10 c,
    c" Pronunciation: dash-trailing" 10 c,
    c" Compiles to: -TRAILING (0)" 10 c,
    c" Stack effects: addr n1 --- addr n2" 10 c,
    c" Adjusts the character count n1 of a string beginning address to" 10 c,
    c" suppress the output of trailing blanks, i.e. the characters from" 10 c,
    c" addr+n1 to addr+n2 are blanks." 10 c,
    0 c,
  TAG info-4th "-TRAILING-GARBAGE"
    c" -TRAILING-GARBAGE XCHAR EXT" 10 c,
    c" Include: anstools.4th" 10 c,
    c" Stack effects: addr n1 --- addr n2" 10 c,
    c" Examine the last xchar in the string addr n1 - if the encoding is" 10 c,
    c" correct and it represents a full xchar, n2 equals n1, otherwise," 10 c,
    c" n2 represents the string without the last (garbled) xchar." 10 c,
    c" -TRAILING-GARBAGE does not change this garbled xchar." 10 c,
    c" . CORE" 10 c,
    c" Pronunciation: dot" 10 c,
    c" Compiles to: . (0)" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Print a number to the current output device, converted according" 10 c,
    c" to the numeric BASE. A trailing blank follows." 10 c,
    0 c,
  TAG info-4th |."|
    c| ." CORE| 10 c,
    c" Pronunciation: dot-quote" 10 c,
    c| Compiles to: ." (<address of string constant>)| 10 c,
    c| Syntax: ."<space><string>"| 10 c,
    c" Compiles string in the String Segment with an execution procedure" 10 c,
    c" to transmit the string to the selected output device." 10 c,
    0 c,
  TAG info-4th ".("
    c" .( CORE EXT" 10 c,
    c" Pronunciation: dot-paren" 10 c,
    c| Compiles to: ." (<address of string constant>)| 10 c,
    c" Syntax: .(<space><string>)" 10 c,
    c" Compiles string in the String Segment with an execution procedure" 10 c,
    c" to transmit the string to the selected output device. An alias" 10 c,
    c| for .".| 10 c,
    0 c,
  TAG info-4th ".R"
    c" .R CORE EXT" 10 c,
    c" Pronunciation: dot-r" 10 c,
    c" Compiles to: .R (0)" 10 c,
    c" Stack effects: n1 n2 ---" 10 c,
    c" Print the number n1 right aligned in a field whose width is n2 to" 10 c,
    c" the current output device. No following blank is printed." 10 c,
    0 c,
  TAG info-4th ".S"
    c" .S TOOLS" 10 c,
    c" Pronunciation: dot-s" 10 c,
    c" Include: anstools.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Copy and display the values currently on the data stack." 10 c,
    0 c,
  TAG info-4th ".|"
    c" .| 4TH" 10 c,
    c| Compiles to: ." (<address of string constant>)| 10 c,
    c" Syntax: .|<space><string>|" 10 c,
    c" Compiles string in the String Segment with an execution procedure" 10 c,
    c" to transmit the string to the selected output device." 10 c,
    0 c,
  TAG info-4th "/"
    c" / CORE" 10 c,
    c" Pronunciation: slash" 10 c,
    c" Compiles to: / (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leaves the quotient n3 of n1/n2." 10 c,
    0 c,
  TAG info-4th "/CELL"
    c" /CELL COMUS" 10 c,
    c" Compiles to: LITERAL (<size of a cell>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Returns the size of a cell in address units." 10 c,
    0 c,
  TAG info-4th "/CHAR"
    c" /CHAR COMUS" 10 c,
    c" Compiles to: LITERAL (<size of char>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Returns the size of a character in address units." 10 c,
    0 c,
  TAG info-4th "/CONSTANT"
    c" /CONSTANT 4TH" 10 c,
    c" Syntax: <literal><space>/CONSTANT<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for /CONSTANT. The instruction pointer is decremented, actually" 10 c,
    c" deleting the literal." 10 c,
    c" A defining word used to create word <name>. When <name> is later" 10 c,
    c" executed, it will divide the top of the stack by the value of" 10 c,
    c" <literal>." 10 c,
    0 c,
  TAG info-4th "/FIELD"
    c" /FIELD 4TH" 10 c,
    c" Syntax:" 10 c,
    c" STRUCT<space><literal><space>/FIELD<space>END-STRUCT<space><name>" 10 c,
    c" Compiler: Take two previous compiled literals. The last literal" 10 c,
    c" is compared to the first and the larger one of the two is" 10 c,
    c" recompiled. The instruction pointer does not change." 10 c,
    c" Create a field for UNION implementations (see: +FIELD, /FIELD," 10 c,
    c" STRUCT, END-STRUCT)." 10 c,
    0 c,
  TAG info-4th "/MOD"
    c" /MOD CORE" 10 c,
    c" Pronunciation: slash-mod" 10 c,
    c" Compiles to: /MOD (0)" 10 c,
    c" Stack effects: n1 n2 --- n3 n4" 10 c,
    c" Leave the remainder n3 and quotient n4 of n1/n2." 10 c,
    0 c,
  TAG info-4th "/PAD"
    c" /PAD 4TH" 10 c,
    c" Compiles to: LITERAL (<size of PAD>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Forth: Equivalent to:" 10 c,
    c| : /PAD S" /PAD" ENVIRONMENT? DROP ;| 10 c,
    c" Returns the size of PAD." 10 c,
    0 c,
  TAG info-4th "/STRING"
    c" /STRING STRING" 10 c,
    c" Pronunciation: slash-string" 10 c,
    c" Compiles to: SWAP (0)" 10 c,
    c" OVER (0)" 10 c,
    c" - (0)" 10 c,
    c" >R (0)" 10 c,
    c" + (0)" 10 c,
    c" R> (0)" 10 c,
    c" Stack effects: addr1 n1 n2 --- addr2 n3" 10 c,
    c" Adjust the character string at addr1 by n2 characters. The" 10 c,
    c" resulting character string, specified by addr2 n3 , begins at" 10 c,
    c" addr1 plus n2 characters and is n1 minus n characters long." 10 c,
    0 c,
  TAG info-4th "/TIB"
    c" /TIB 4TH" 10 c,
    c" Compiles to: LITERAL (<size of TIB>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Returns the size of the terminal input buffer." 10 c,
    0 c,
  TAG info-4th "0<"
    c" 0< CORE" 10 c,
    c" Pronunciation: zero-less" 10 c,
    c" Compiles to: 0< (0)" 10 c,
    c" Stack effects: n --- f" 10 c,
    c" Leave a TRUE flag if number n is less than zero (negative)," 10 c,
    c" otherwise leave a FALSE flag in f." 10 c,
    0 c,
  TAG info-4th "0<>"
    c" 0<> CORE EXT" 10 c,
    c" Pronunciation: zero-not-equals" 10 c,
    c" Compiles to: 0<> (0)" 10 c,
    c" Stack effects: n --- f" 10 c,
    c" Leave a TRUE flag if number n is not equal to zero, otherwise" 10 c,
    c" leave a FALSE flag in f." 10 c,
    0 c,
  TAG info-4th "0="
    c" 0= CORE" 10 c,
    c" Pronunciation: zero-equals" 10 c,
    c" Compiles to: 0= (0)" 10 c,
    c" Stack effects: n --- f" 10 c,
    c" Leave a TRUE flag if number n is equal to zero, otherwise leave a" 10 c,
    c" FALSE flag in f." 10 c,
    0 c,
  TAG info-4th "0>"
    c" 0> CORE EXT" 10 c,
    c" Pronunciation: zero-greater" 10 c,
    c" Compiles to: 0> (0)" 10 c,
    c" Stack effects: n --- f" 10 c,
    c" Leave a TRUE flag if number n is greater than zero (positive)," 10 c,
    c" otherwise leave a FALSE flag in f." 10 c,
    0 c,
  TAG info-4th "1+"
    c" 1+ CORE" 10 c,
    c" Pronunciation: one-plus" 10 c,
    c" Compiles to: +LITERAL (1)" 10 c,
    c" Stack effects: n --- n+1" 10 c,
    c" Increment n by 1." 10 c,
    0 c,
  TAG info-4th "1-"
    c" 1- CORE" 10 c,
    c" Pronunciation: one-minus" 10 c,
    c" Compiles to: +LITERAL (-1)" 10 c,
    c" Stack effects: n --- n-1" 10 c,
    c" Decrement n by 1." 10 c,
    0 c,
  TAG info-4th "2!"
    c" 2! CORE" 10 c,
    c" Pronunciation: two-store" 10 c,
    c" Include: anscore.4th" 10 c,
    c" Stack effects: n1 n2 x ---" 10 c,
    c" Store the cell pair n1 n2 at x, with n2 at x and n2 at the next" 10 c,
    c" consecutive cell." 10 c,
    0 c,
  TAG info-4th "2*"
    c" 2* CORE" 10 c,
    c" Pronunciation: two-star" 10 c,
    c" Compiles to: *LITERAL (2)" 10 c,
    c" Stack effects: n --- n*2" 10 c,
    c" Multiply n by 2. Performs a left shift." 10 c,
    0 c,
  TAG info-4th "2/"
    c" 2/ CORE" 10 c,
    c" Pronunciation: two-slash" 10 c,
    c" Compiles to: 2/ (0)" 10 c,
    c" Stack effects: n --- n/2" 10 c,
    c" Divide n by 2. Performs a right shift." 10 c,
    0 c,
  TAG info-4th "2>R"
    c" 2>R CORE EXT" 10 c,
    c" Pronunciation: two-to-r" 10 c,
    c" Compiles to: >R (0)" 10 c,
    c" >R (0)" 10 c,
    c" Stack effects: n1 n2 ---" 10 c,
    c" Forth: Forth swaps both values before transfering them to the" 10 c,
    c" return stack." 10 c,
    c" Transfer cell pair n1 n2 to the return stack." 10 c,
    0 c,
  TAG info-4th "2@"
    c" 2@ CORE" 10 c,
    c" Pronunciation: two-fetch" 10 c,
    c" Include: anscore.4th" 10 c,
    c" Stack effects: x --- n1 n2" 10 c,
    c" Fetch the cell pair n1 n2 stored at x. n2 is stored at x and n1" 10 c,
    c" at the next consecutive cell." 10 c,
    0 c,
  TAG info-4th "2DROP"
    c" 2DROP CORE" 10 c,
    c" Pronunciation: two-drop" 10 c,
    c" Compiles to: DROP (0)" 10 c,
    c" DROP (0)" 10 c,
    c" Stack effects: n1 n2 ---" 10 c,
    c" Drop cell pair n1 n2 from the stack." 10 c,
    0 c,
  TAG info-4th "2DUP"
    c" 2DUP CORE" 10 c,
    c" Pronunciation: two-dupe" 10 c,
    c" Compiles to: OVER (0)" 10 c,
    c" OVER (0)" 10 c,
    c" Stack effects: n1 n2 --- n1 n2 n1 n2" 10 c,
    c" Duplicate cell pair n1 n2." 10 c,
    0 c,
  TAG info-4th "2NIP"
    c" 2NIP TOOLBELT" 10 c,
    c" Compiles to: ROT (0)" 10 c,
    c" DROP (0)" 10 c,
    c" ROT (0)" 10 c,
    c" DROP (0)" 10 c,
    c" Stack effects: n1 n2 n3 n4 --- n3 n4" 10 c,
    c" Drop the third and fourth items on the stack." 10 c,
    0 c,
  TAG info-4th "2OVER"
    c" 2OVER CORE" 10 c,
    c" Pronunciation: two-over" 10 c,
    c" Include: anscore.4th" 10 c,
    c" Stack effects: n1 n2 n3 n4 --- n1 n2 n3 n4 n1 n2" 10 c,
    c" Copy cell pair n1 n2 to the top of the stack." 10 c,
    0 c,
  TAG info-4th "2R>"
    c" 2R> CORE EXT" 10 c,
    c" Pronunciation: two-r-from" 10 c,
    c" Compiles to: R> (0)" 10 c,
    c" R> (0)" 10 c,
    c" Stack effects: --- n1 n2" 10 c,
    c" Forth: Forth swaps both values after transfering them from the" 10 c,
    c" return stack." 10 c,
    c" Transfer cell pair n1 n2 from the return stack." 10 c,
    0 c,
  TAG info-4th "2R@"
    c" 2R@ CORE EXT" 10 c,
    c" Pronunciation: two-r-fetch" 10 c,
    c" Compiles to: R> (0)" 10 c,
    c" I (0)" 10 c,
    c" OVER (0)" 10 c,
    c" >R (0)" 10 c,
    c" Stack effects: --- n1 n2" 10 c,
    c" Forth: Forth swaps both values after transfering them from the" 10 c,
    c" return stack." 10 c,
    c" Copy cell pair n1 n2 from the return stack." 10 c,
    0 c,
  TAG info-4th "2ROT"
    c" 2ROT DOUBLE EXT" 10 c,
    c" Pronunciation: two-rote" 10 c,
    c" Include: anscore.4th" 10 c,
    c" Stack effects: n1 n2 n3 n4 n5 n6 --- n3 n4 n5 n6 n1 n2" 10 c,
    c" Rotate the top three cell pairs on the stack bringing cell pair" 10 c,
    c" n1 n2 to the top of the stack." 10 c,
    0 c,
  TAG info-4th "2SWAP"
    c" 2SWAP CORE" 10 c,
    c" Pronunciation: two-swap" 10 c,
    c" Compiles to: ROT (0)" 10 c,
    c" >R (0)" 10 c,
    c" ROT (0)" 10 c,
    c" R> (0)" 10 c,
    c" Stack effects: n1 n2 n3 n4 --- n3 n4 n1 n2" 10 c,
    c" Exchange the top two cell pairs." 10 c,
    0 c,
  TAG info-4th "4TH#"
    c" 4TH# 4TH" 10 c,
    c" Compiles to: LITERAL (<4tH version in hexadecimal>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Constant containing the 4tH version in hexadecimal." 10 c,
    0 c,
  TAG info-4th ":"
    c" : CORE" 10 c,
    c" Pronunciation: colon" 10 c,
    c" Compiles to: BRANCH (<address of matching ; token>)" 10 c,
    c" Syntax: :<space><name>..<space>;" 10 c,
    c" Creates a subroutine defining <name> as equivalent to the" 10 c,
    c" following sequence of 4tH word definitions until the next ;." 10 c,
    0 c,
  TAG info-4th ":NONAME"
    c" :NONAME CORE EXT" 10 c,
    c" Pronunciation: colon-no-name" 10 c,
    c" Compiles to: LITERAL (<address of next BRANCH>)" 10 c,
    c" BRANCH (<address of matching ; token>)" 10 c,
    c" Syntax: :NONAME<space>..<space>;" 10 c,
    c" Stack effects: --- xt" 10 c,
    c" Create an execution token xt and compile the current definition." 10 c,
    c" The execution semantics of xt will be determined by the words" 10 c,
    c" compiled into the body of the definition. This definition can be" 10 c,
    c" executed later by using xt EXECUTE." 10 c,
    0 c,
  TAG info-4th ":REDO"
    c" :REDO 4TH" 10 c,
    c" Compiles to: BRANCH (<address of matching ; token>)" 10 c,
    c" LITERAL (<original value>) | VARIABLE (<original value>)" 10 c,
    c" Syntax: :REDO<space><name><space>..<space>;" 10 c,
    c" Create an subroutine <name> that first pushes the original value" 10 c,
    c" of <name> on the stack. The words after <name> determine what the" 10 c,
    c" actual execution behavior will be (see: DOES>)." 10 c,
    0 c,
  TAG info-4th ":TOKEN"
    c" :TOKEN 4TH" 10 c,
    c" Compiles to: BRANCH (<address of matching ; token>)" 10 c,
    c" Syntax: :TOKEN<space><name><space>..<space>;" 10 c,
    c" Forth: The equivalent in Forth is:" 10 c,
    c" :noname ; constant <name>" 10 c,
    c" Create an execution token <name> and compile the current" 10 c,
    c" definition. The execution semantics of <name> will be determined" 10 c,
    c" by the words compiled into the body of the definition. This" 10 c,
    c" definition can be executed later by using <name> EXECUTE." 10 c,
    0 c,
  TAG info-4th ";"
    c" ; CORE" 10 c,
    c" Pronunciation: semi-colon" 10 c,
    c" Compiles to: EXIT (0)" 10 c,
    c" Syntax: See :" 10 c,
    c" Terminate a colon definition. At runtime, return to the calling" 10 c,
    c" word by popping a token-address from the return stack." 10 c,
    0 c,
  TAG info-4th ";]"
    c" ;] COMP.LANG.FORTH" 10 c,
    c" Compiles to: EXIT (0)" 10 c,
    c" Syntax: See [:" 10 c,
    c" Forth: Several Forths support this word, e.g. gForth, iForth and" 10 c,
    c" VFX Forth." 10 c,
    c" Ends the current nested definition, and resumes compilation to" 10 c,
    c" the previous current definition (if any)." 10 c,
    0 c,
  TAG info-4th "<"
    c" < CORE" 10 c,
    c" Pronunciation: less-than" 10 c,
    c" Compiles to: < (0)" 10 c,
    c" Stack effects: n1 n2 --- f" 10 c,
    c" Leave a TRUE flag if n1 is less than n2; otherwise leave a FALSE" 10 c,
    c" flag in f." 10 c,
    0 c,
  TAG info-4th "<#"
    c" <# CORE" 10 c,
    c" Pronunciation: less-number-sign" 10 c,
    c" Compiles to: <# (0)" 10 c,
    c" Forth: In Forth a double number is required." 10 c,
    c" Setup for pictured numeric output formatting in PAD using the" 10 c,
    c" words <#, #, #S, SIGN, HOLD, #>." 10 c,
    0 c,
  TAG info-4th "<>"
    c" <> CORE EXT" 10 c,
    c" Pronunciation: not-equals" 10 c,
    c" Compiles to: <> (0)" 10 c,
    c" Stack effects: n1 n2 --- f" 10 c,
    c" Leave a TRUE flag if n1 does not equal n2; otherwise leave a" 10 c,
    c" FALSE flag in f." 10 c,
    0 c,
  TAG info-4th "<="
    c" <= 4TH" 10 c,
    c" Compiles to: > (0)" 10 c,
    c" 0= (0)" 10 c,
    c" Stack effects: n1 n2 --- f" 10 c,
    c" Leave a TRUE flag if n1 is less or equal than n2; otherwise leave" 10 c,
    c" a FALSE flag in f." 10 c,
    0 c,
  TAG info-4th "="
    c" = CORE" 10 c,
    c" Pronunciation: equals" 10 c,
    c" Compiles to: = (0)" 10 c,
    c" Stack effects: n1 n2 --- f" 10 c,
    c" Leave a TRUE flag if n1 equals n2; otherwise leave a FALSE flag" 10 c,
    c" in f." 10 c,
    0 c,
  TAG info-4th ">"
    c" > CORE" 10 c,
    c" Pronunciation: greater-than" 10 c,
    c" Compiles to: > (0)" 10 c,
    c" Stack effects: n1 n2 --- f" 10 c,
    c" Leave a TRUE flag if n1 is greater than n2; otherwise leave a" 10 c,
    c" FALSE flag in f." 10 c,
    0 c,
  TAG info-4th ">="
    c" >= 4TH" 10 c,
    c" Compiles to: < (0)" 10 c,
    c" 0= (0)" 10 c,
    c" Stack effects: n1 n2 --- f" 10 c,
    c" Leave a TRUE flag if n1 is greater or equal than n2; otherwise" 10 c,
    c" leave a FALSE flag in f." 10 c,
    0 c,
  TAG info-4th ">BODY"
    c" >BODY CORE" 10 c,
    c" Pronunciation: to-body" 10 c,
    c" Compiles to: ENVIRON (<address of FIRST>)" 10 c,
    c" + (0)" 10 c,
    c" Stack effects: n --- x" 10 c,
    c" Forth: In Forth, >BODY works with every CREATEd datatype." 10 c,
    c" n is the ticked value of a VARIABLE, VALUE, DEFER or FILE. >BODY" 10 c,
    c" returns its address in the Variable Area." 10 c,
    0 c,
  TAG info-4th ">FLOAT"
    c" >FLOAT FLOATING" 10 c,
    c" Pronunciation: to-float" 10 c,
    c" Include: ansfpio.4th" 10 c,
    c" zenfpio.4th" 10 c,
    c" fpin.4th" 10 c,
    c" Stack effects: addr n --- f" 10 c,
    c" Floating: --- r" 10 c,
    c" An attempt is made to convert the string specified by addr and n" 10 c,
    c" to internal floating-point representation. If the string" 10 c,
    c" represents a valid floating-point number in the syntax ?CYenmantissa" 10 c,
    c" (with optional exponent)?CYen, its value r and true are returned. If" 10 c,
    c" the string does not represent a valid floating-point number only" 10 c,
    c" false is returned." 10 c,
    0 c,
  TAG info-4th ">IN"
    c" >IN CORE" 10 c,
    c" Pronunciation: to-in" 10 c,
    c" Compiles to: LITERAL (<address of >IN>)" 10 c,
    c" Stack effects: --- x" 10 c,
    c" A variable containing the address within the Character Segment" 10 c,
    c" from which the next text will be parsed. PARSE uses and moves the" 10 c,
    c" value of >IN." 10 c,
    0 c,
  TAG info-4th ">NUMBER"
    c" >NUMBER CORE" 10 c,
    c" Pronunciation: to-number" 10 c,
    c" Include: tonumber.4th" 10 c,
    c" todbl.4th" 10 c,
    c" Stack effects: n1 a1 n2 --- n3 a2 n4" 10 c,
    c" d1 a1 n1 --- d2 a2 n4" 10 c,
    c" n3|d2 is the unsigned result of converting the characters within" 10 c,
    c" the string specified by a1 n2 into digits, using the number in" 10 c,
    c" BASE, and adding each into n1|d1 after multiplying n1|d2 by the" 10 c,
    c" number in BASE. Conversion continues left-to-right until a" 10 c,
    c" character that is not convertible, including any + or -, is" 10 c,
    c" encountered or the string is entirely converted. a2 is the" 10 c,
    c" location of the first unconverted character or the first" 10 c,
    c" character past the end of the string if the string was entirely" 10 c,
    c" converted. n4 is the number of unconverted characters in the" 10 c,
    c" string. An ambiguous condition exists if n3|d2 overflows during" 10 c,
    c" the conversion." 10 c,
    0 c,
  TAG info-4th ">R"
    c" >R CORE" 10 c,
    c" Pronunciation: to-r" 10 c,
    c" Compiles to: >R (0)" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Remove n from the stack and place it on the return stack. Use" 10 c,
    c" should be balanced with R> in the same definition." 10 c,
    0 c,
  TAG info-4th ">STRING"
    c" >STRING 4TH" 10 c,
    c" Compiles to: OVER (0)" 10 c,
    c" PLACE (0)" 10 c,
    c" Stack effects: a n ---" 10 c,
    c" Convert a string identified by address a and length n to a" 10 c,
    c" terminated string at address a. Use only on string variables." 10 c,
    0 c,
  TAG info-4th "?"
    c" ? TOOLS" 10 c,
    c" Pronunciation: question" 10 c,
    c" Compiles to: @ (0)" 10 c,
    c" . (0)" 10 c,
    c" Stack effects: x ---" 10 c,
    c" Print the value contained in the variable at address x in free" 10 c,
    c" format according to the current BASE." 10 c,
    0 c,
  TAG info-4th "?DO"
    c" ?DO CORE EXT" 10 c,
    c" Pronunciation: question-do" 10 c,
    c" Compiles to: ?DO (0)" 10 c,
    c" Syntax: ?DO<space>..<space>+LOOP" 10 c,
    c" ?DO<space>..<space>LOOP" 10 c,
    c" Stack effects: n1 n2 ---" 10 c,
    c" If n1 is equal to n2, continue execution at LOOP or +LOOP." 10 c,
    c" Otherwise set up loop control parameters with index n2 and limit" 10 c,
    c" n1 and continue executing immediately following ?DO. Anything" 10 c,
    c" already on the return stack becomes unavailable until the loop" 10 c,
    c" control parameters are discarded." 10 c,
    0 c,
  TAG info-4th "?DUP"
    c" ?DUP CORE" 10 c,
    c" Pronunciation: question-dupe" 10 c,
    c" Include: pickroll.4th" 10 c,
    c" Stack effects: n --- 0 | n n" 10 c,
    c" Duplicate n if it is non-zero." 10 c,
    0 c,
  TAG info-4th "@"
    c" @ CORE" 10 c,
    c" Pronunciation: fetch" 10 c,
    c" Compiles to: @ (0)" 10 c,
    c" Stack effects: x --- n" 10 c,
    c" Leave the contents n of the variable at address x on the stack." 10 c,
    0 c,
  TAG info-4th "@C"
    c" @C CROSS EXT" 10 c,
    c" Compiles to: @C (0)" 10 c,
    c" Stack effects: xt --- n | addr" 10 c,
    c" Forth: In Forth the word @ can also be used to fetch values from" 10 c,
    c" the dictionary. Due to 4tHs internal structure this is not" 10 c,
    c" possible." 10 c,
    c" Leave the contents n of the parameter field of token address xt" 10 c,
    c" on the stack. If n contains an string constant compiled by ,?CYen it" 10 c,
    c" is copied to the PAD. Its address is returned as addr." 10 c,
    0 c,
  TAG info-4th "@GOTO"
    c" @GOTO 4TH" 10 c,
    c" Syntax: @GOTO<space><string>" 10 c,
    c" The remainder of the line is discarded. This word is used to" 10 c,
    c" start a 4tH source program from a MS type shell. An alias for \." 10 c,
    0 c,
  TAG info-4th "ABORT"
    c" ABORT CORE" 10 c,
    c" Forth: In Forth the behaviour of ABORT is different from QUIT (-1" 10 c,
    c" THROW). In 4tH it doesn't really matter which one you use." 10 c,
    c" An alias for QUIT." 10 c,
    0 c,
  TAG info-4th |ABORT"|
    c| ABORT" CORE| 10 c,
    c" Pronunciation: abort-quote" 10 c,
    c" Compiles to: 0BRANCH (<address of QUIT>)" 10 c,
    c" LITERAL (stdout)" 10 c,
    c" USE (0)" 10 c,
    c" .?CYen (<address of string constant>)" 10 c,
    c" CR (0)" 10 c,
    c" QUIT (0)" 10 c,
    c" Syntax: ABORT?CYen<space><string>?CYen" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Forth: In Forth the behaviour of ABORT?CYen is different from QUIT" 10 c,
    c" (-2 THROW)." 10 c,
    c" Remove n from the stack. If any bit of n is not zero, display the" 10 c,
    c" string and set the program counter to the end of the program." 10 c,
    c" Effectively quits execution." 10 c,
    0 c,
  TAG info-4th "ABS"
    c" ABS CORE" 10 c,
    c" Pronunciation: abs" 10 c,
    c" Compiles to: ABS (0)" 10 c,
    c" Stack effects: n1 --- n2" 10 c,
    c" Leave the absolute value of n1 as n2." 10 c,
    0 c,
  TAG info-4th "ACCEPT"
    c" ACCEPT CORE" 10 c,
    c" Compiles to: ACCEPT (0)" 10 c,
    c" Stack effects: addr n1 --- n2" 10 c,
    c" Forth: In Forth no null character is appended." 10 c,
    c" Read n1 characters from the current input device to address addr." 10 c,
    c" If input is read from the terminal CR will terminate the input" 10 c,
    c" stream. All other devices will terminate reading when an EOF" 10 c,
    c" occurs. In all cases input will end when n1 characters have been" 10 c,
    c" read. A null character is added to the end of the input when" 10 c,
    c" reading from the keyboard. The number n2 represents the number of" 10 c,
    c" characters actually read." 10 c,
    0 c,
  TAG info-4th "AGAIN"
    c" AGAIN CORE EXT" 10 c,
    c" Compiles to: BRANCH (<address of the token following BEGIN>)" 10 c,
    c" Syntax: BEGIN<space>..<space>AGAIN" 10 c,
    c" At runtime, AGAIN forces execution to return to the corresponding" 10 c,
    c" BEGIN. Execution cannot leave this loop. AGAIN is an alias for" 10 c,
    c" REPEAT." 10 c,
    0 c,
  TAG info-4th "AKA"
    c" AKA 4TH" 10 c,
    c" Syntax: AKA<space><word name><space><name>" 10 c,
    c" Create a word <name> with the same compilation and execution" 10 c,
    c" semantics as the existing word <word name>. The word <word name>" 10 c,
    c" has to be user defined, a built-in constant or a word that" 10 c,
    c" compiles to a single token. Flow control words, preprocessor[footnote:" 10 c,
    c" 4tHs internal preprocessor, not the external preprocessor PP4tH." 10 c,
    c" External preprocessor words are not recognized by 4tH at all, so" 10 c,
    c" they can't be 'AKA'ed anyway." 10 c,
    c" ] words, defining words and inline macros cannot be 'AKA'ed." 10 c,
    0 c,
  TAG info-4th "ALIAS"
    c" ALIAS 4TH" 10 c,
    c" Compiles to: TO (<variable address>)" 10 c,
    c" Stack effects: xt ---" 10 c,
    c" Syntax: ALIAS<space><name>" 10 c,
    c" Store xt in the value identified by name. ALIAS is an alias for" 10 c,
    c" IS, but does not require a previously defined DEFER." 10 c,
    0 c,
  TAG info-4th "ALIGN"
    c" ALIGN CORE" 10 c,
    c" Compiler: The instruction pointer is not incremented. In fact," 10 c,
    c" ALIGN is a dummy." 10 c,
    c" If the dataspace pointer is not aligned, reserve enough space to" 10 c,
    c" align it." 10 c,
    0 c,
  TAG info-4th "ALIGNED"
    c" ALIGNED CORE" 10 c,
    c" Compiler: The instruction pointer is not incremented. In fact," 10 c,
    c" ALIGNED is a dummy." 10 c,
    c" Stack effects: n --- n" 10 c,
    c" n is the first aligned address greater than or equal to n." 10 c,
    0 c,
  TAG info-4th "ALLOCATE"
    c" ALLOCATE MEMORY" 10 c,
    c" Include: ansmem.4th" 10 c,
    c" memchar.4th" 10 c,
    c" memcell.4th" 10 c,
    c" Stack effects: n --- addr f" 10 c,
    c" Allocate n address units of contiguous data space. The initial" 10 c,
    c" content of the allocated space is undefined. If the allocation" 10 c,
    c" succeeds, addr is the aligned starting address of the allocated" 10 c,
    c" space and f is false. If the operation fails, addr does not" 10 c,
    c" represent a valid address and f is true." 10 c,
    0 c,
  TAG info-4th "AND"
    c" AND CORE" 10 c,
    c" Compiles to: AND (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leave the bitwise logical AND of n1 AND n2 as n3." 10 c,
    0 c,
  TAG info-4th "APP"
    c" APP 4TH" 10 c,
    c" Compiles to: LITERAL (<application variable>)" 10 c,
    c" Stack effects: --- x" 10 c,
    c" This word returns the variable address x in the Variable Area to" 10 c,
    c" an array of application specific variables. If APP equals FIRST" 10 c,
    c" no application specific variables have been defined." 10 c,
    0 c,
  TAG info-4th "APPEND"
    c" APPEND 4TH" 10 c,
    c" Compiles to: LITERAL (<fam>)" 10 c,
    c" Stack effects: --- fam" 10 c,
    c" This will leave a file access method modifier on the stack," 10 c,
    c" signalling that output will be appended. Must be added to another" 10 c,
    c" file access modifier. Used in combination with OUTPUT." 10 c,
    0 c,
  TAG info-4th "ARGN"
    c" ARGN 4TH" 10 c,
    c" Compiles to: ARGN (0)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Returns the number of arguments that have been passed to 4tH" 10 c,
    c" (see: ARGS)." 10 c,
    0 c,
  TAG info-4th "ARGS"
    c" ARGS 4TH" 10 c,
    c" Compiles to: ARGS (0)" 10 c,
    c" Stack effects: n1 --- addr n2" 10 c,
    c" Copies argument n1 to the PAD and leaves address addr and length" 10 c,
    c" n2 on the stack (see: ARGN)." 10 c,
    0 c,
  TAG info-4th "ARRAY"
    c" ARRAY 4TH" 10 c,
    c" Syntax: <literal><space>ARRAY<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for ARRAY. The instruction pointer is decremented, actually" 10 c,
    c" deleting the literal." 10 c,
    c" Forth: Roughly equivalent to:" 10 c,
    c" : ARRAY CREATE CELLS ALLOT ;" 10 c,
    c" Allocate <literal> cells of contiguous data space beginning at" 10 c,
    c" <name> in the Integer Segment. The initial content of the" 10 c,
    c" allocated space is undefined." 10 c,
    0 c,
  TAG info-4th "ASSERT("
    c" ASSERT( 4TH" 10 c,
    c" Syntax: ASSERT(<space><word>..<word><space>)" 10 c,
    c" Forth: Similar constructions are available in GForth and" 10 c,
    c" Win32For." 10 c,
    c" Mark the beginning of an assertion. If assertions are disabled" 10 c,
    c" all words following upto ) are commented out (see: [ASSERT] and )" 10 c,
    c" )." 10 c,
    0 c,
  TAG info-4th "BASE"
    c" BASE CORE" 10 c,
    c" Compiles to: LITERAL (<address of BASE>)" 10 c,
    c" Stack effects: --- x" 10 c,
    c" A variable containing the current number BASE used for input and" 10 c,
    c" output." 10 c,
    0 c,
  TAG info-4th "BEGIN"
    c" BEGIN CORE" 10 c,
    c" Syntax: BEGIN<space>..<space>AGAIN" 10 c,
    c" BEGIN<space>..<space>WHILE<space>..<space>UNTIL" 10 c,
    c" BEGIN<space>..<space>WHILE<space>..<space>REPEAT" 10 c,
    c" Forth: Within a BEGIN .. REPEAT construct, multiple WHILEs may be" 10 c,
    c" used as well, but additional words are necessary to complete the" 10 c,
    c" construct." 10 c,
    c" At runtime begin marks the start of a sequence that may be" 10 c,
    c" repetitively executed. It serves as a return point from the" 10 c,
    c" corresponding UNTIL, AGAIN or REPEAT. When executing UNTIL, a" 10 c,
    c" return to BEGIN will occur if the top of the stack is false; for" 10 c,
    c" AGAIN and REPEAT a return to BEGIN always occurs. Multiple WHILEs" 10 c,
    c" may be used." 10 c,
    0 c,
  TAG info-4th "B/BUF"
    c" B/BUF SOURCEFORGE" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Returns the length of a block." 10 c,
    0 c,
  TAG info-4th "BIN"
    c" BIN FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: fam1 --- fam2" 10 c,
    c" Modify file access method fam1 to additionally select a binary," 10 c,
    c" i.e., not line oriented, file access method, giving access method" 10 c,
    c" fam2. Since 4tH does this automatically, BIN is a dummy." 10 c,
    0 c,
  TAG info-4th "BL"
    c" BL CORE" 10 c,
    c" Pronunciation: b-l" 10 c,
    c" Compiles to: LITERAL (<ASCII value of space>)" 10 c,
    c" Stack effects: --- c" 10 c,
    c| A constant that leaves the ASCII value for "blank".| 10 c,
    0 c,
  TAG info-4th "BLANK"
    c" BLANK STRING" 10 c,
    c" Compiles to: LITERAL (<ASCII value of space)" 10 c,
    c" FILL (0)" 10 c,
    c" Stack effects: n addr ---" 10 c,
    c" If n is greater than zero, store the character value for space in" 10 c,
    c" n consecutive character positions beginning at addr." 10 c,
    0 c,
  TAG info-4th "BLK"
    c" BLK BLOCK" 10 c,
    c" Pronunciation: b-l-k" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: --- x" 10 c,
    c" Forth: In Forth, a block cannot have the number zero. BLK" 10 c,
    c" contains the number of the block being interpreted." 10 c,
    c" x is the address of a cell containing the number of the" 10 c,
    c" mass-storage block currently cached. An ambiguous condition" 10 c,
    c" exists if a program directly alters the contents of BLK." 10 c,
    0 c,
  TAG info-4th "BLOCK"
    c" BLOCK BLOCK" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: n --- addr" 10 c,
    c" Addr is the address of the first character of the block buffer" 10 c,
    c" assigned to mass-storage block n. An ambiguous condition exists" 10 c,
    c" if u is not an available block number. If block n is already in a" 10 c,
    c" block buffer, addr is the address of that block buffer. If block" 10 c,
    c" n is not already in memory, unassign the block buffer. If the" 10 c,
    c" block in that buffer has been UPDATEd, transfer the block to mass" 10 c,
    c" storage and transfer block n from mass storage into that buffer." 10 c,
    c" a-addr is the address of that block buffer. At the conclusion of" 10 c,
    c" the operation, the block buffer pointed to by addr is the current" 10 c,
    c" block buffer and is assigned to n." 10 c,
    0 c,
  TAG info-4th "BOUNDS"
    c" BOUNDS COMUS" 10 c,
    c" Compiles to: OVER (0)" 10 c,
    c" + (0)" 10 c,
    c" SWAP (0)" 10 c,
    c" Stack effects: addr n --- addr addr+n" 10 c,
    c" Convert a starting value and count into the form required for a" 10 c,
    c" DO or ?DO loop." 10 c,
    0 c,
  TAG info-4th "BUFFER"
    c" BUFFER BLOCK" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: n --- addr" 10 c,
    c" Addr is the address of the first character of the block buffer" 10 c,
    c" assigned to mass-storage block n. An ambiguous condition exists" 10 c,
    c" if n is not an available block number. If block n is already in a" 10 c,
    c" block buffer, addr is the address of that block buffer. If block" 10 c,
    c" n is not already in memory, unassign the block buffer. If the" 10 c,
    c" block in that buffer has been UPDATEd, transfer the block to mass" 10 c,
    c" storage. a-addr is the address of that block buffer. At the" 10 c,
    c" conclusion of the operation, the block buffer pointed to by addr" 10 c,
    c" is the current block buffer and is assigned to n." 10 c,
    0 c,
  TAG info-4th "BUFFER:"
    c" BUFFER: CORE EXT" 10 c,
    c" Syntax: <literal><space>BUFFER:<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for BUFFER:. The instruction pointer is decremented, actually" 10 c,
    c" deleting the literal." 10 c,
    c" Allocate <literal> address units of contiguous data space" 10 c,
    c" beginning at <name> in the Character Segment. The initial content" 10 c,
    c" of the allocated space is undefined." 10 c,
    0 c,
  TAG info-4th "C!"
    c" C! CORE" 10 c,
    c" Pronunciation: c-store" 10 c,
    c" Compiles to: C! (0)" 10 c,
    c" Stack effects: c addr ---" 10 c,
    c" Store 8 bits of c at address addr in the Character Segment." 10 c,
    0 c,
  TAG info-4th |C"|
    c| C" 4TH| 10 c,
    c| Syntax: C"<space><string>"| 10 c,
    c" Compiler: All printable characters from the string are added as" 10 c,
    c" characters to the String Segment. Nothing is actually compiled." 10 c,
    c" Forth: There is a rarely used[footnote:" 10 c,
    c" A.3.1.3.4 Counted strings (abridged): ?CYenForth 94 moved toward the" 10 c,
    c" consistent use of the 'c-addr u' representation of strings on the" 10 c,
    c" stack. The use of the alternate 'address of counted string' stack" 10 c,
    c| representation is discouraged. The new word C", added as a| 10 c,
    c" porting aid for existing programs, also uses the counted string" 10 c,
    c" representation?CYen." 10 c,
    c" ] CORE EXT word in ANS-Forth with the same name. This one behaves" 10 c,
    c" entirely different." 10 c,
    c" Reserve space for all the printable characters of the string" 10 c,
    c" issued in the String Segment and store those characters in that" 10 c,
    c" space." 10 c,
    0 c,
  TAG info-4th "C,"
    c" C, CORE" 10 c,
    c" Pronunciation: c-comma" 10 c,
    c" Syntax: <literal><space>C," 10 c,
    c" Compiler: The previously compiled literal is added as a character" 10 c,
    c" to the String Segment. The instruction pointer is decremented," 10 c,
    c" actually deleting the literal." 10 c,
    c" Forth: Forth pops a value from the stack. This is not possible in" 10 c,
    c" 4tH." 10 c,
    c" Reserve space for one character in the String Segment and store" 10 c,
    c" char in the space." 10 c,
    0 c,
  TAG info-4th "C@"
    c" C@ CORE" 10 c,
    c" Pronunciation: c-fetch" 10 c,
    c" Compiles to: C@ (0)" 10 c,
    c" Stack effects: addr --- c" 10 c,
    c" Leave the 8 bits contents of Character Segment address addr as c." 10 c,
    0 c,
  TAG info-4th "CATCH"
    c" CATCH EXCEPTION" 10 c,
    c" Compiles to: CATCH (0)" 10 c,
    c" (CATCH) (0)" 10 c,
    c" Stack effects: xt --- n" 10 c,
    c" Push an exception frame on the return stack and execute the" 10 c,
    c" execution token xt in such a way that control can be transferred" 10 c,
    c" to a point just after CATCH if THROW is executed during the" 10 c,
    c" execution of xt (see: THROW)." 10 c,
    0 c,
  TAG info-4th "CELL+"
    c" CELL+ CORE" 10 c,
    c" Pronunciation: cell-plus" 10 c,
    c" Compiles to: +LITERAL (1)" 10 c,
    c" Stack effects: x1 --- x2" 10 c,
    c" Add the the size of a cell in cells to x1 giving x2." 10 c,
    0 c,
  TAG info-4th "CELL-"
    c" CELL- COMUS" 10 c,
    c" Compiles to: +LITERAL (-1)" 10 c,
    c" Stack effects: x1 --- x2" 10 c,
    c" Subtract the the size of a cell in cells to x1 giving x2." 10 c,
    0 c,
  TAG info-4th "CELLS"
    c" CELLS CORE" 10 c,
    c" Compiler: The instruction pointer is not incremented. In fact," 10 c,
    c" CELLS is a dummy." 10 c,
    c" Stack effects: n --- n" 10 c,
    c" n is the size in cells of n cells." 10 c,
    0 c,
  TAG info-4th "CFIELD:"
    c" CFIELD: FACILITY EXT" 10 c,
    c" Syntax: CFIELD:<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for CFIELD: and incremented afterwards. The instruction pointer" 10 c,
    c" is left unchanged." 10 c,
    c" Forth: This word may only be used in structures that are" 10 c,
    c" completely made up out of CHARS. In Forth, there is no such" 10 c,
    c" restriction." 10 c,
    c" The semantics are identical to the execution semantics of the" 10 c,
    c" phrase 1 CHARS +FIELD." 10 c,
    0 c,
  TAG info-4th "CHAR"
    c" CHAR CORE" 10 c,
    c" Pronunciation: char" 10 c,
    c" Compiles to: LITERAL (<ASCII-value of character>)" 10 c,
    c" Syntax: CHAR<space><char>" 10 c,
    c" Stack effects: --- c" 10 c,
    c" Compiles the ASCII-value of <char> as a literal. At runtime the" 10 c,
    c" value is thrown on the stack." 10 c,
    0 c,
  TAG info-4th "CHAR+"
    c" CHAR+ CORE" 10 c,
    c" Pronunciation: char-plus" 10 c,
    c" Compiles to: +LITERAL (1)" 10 c,
    c" Stack effects: addr1 --- addr2" 10 c,
    c" Add the the size of a character in characters to addr1 giving" 10 c,
    c" addr2." 10 c,
    0 c,
  TAG info-4th "CHAR-"
    c" CHAR- 4TH" 10 c,
    c" Compiles to: +LITERAL (-1)" 10 c,
    c" Stack effects: addr1 --- addr2" 10 c,
    c" Subtract the the size of a character in characters to addr1" 10 c,
    c" giving addr2." 10 c,
    0 c,
  TAG info-4th "CHARS"
    c" CHARS CORE" 10 c,
    c" Pronunciation: chars" 10 c,
    c" Compiler: The instruction pointer is not incremented. In fact," 10 c,
    c" CHARS is a dummy." 10 c,
    c" Stack effects: n --- n" 10 c,
    c" Forth: In 4tH CHARS is a dummy, but it can be used to make a" 10 c,
    c" program ANS-compatible." 10 c,
    c" n is the size in characters of n characters." 10 c,
    0 c,
  TAG info-4th "CHOP"
    c" CHOP 4TH" 10 c,
    c" Compiles to: +LITERAL (-1)" 10 c,
    c" SWAP (0)" 10 c,
    c" +LITERAL (1)" 10 c,
    c" SWAP (0)" 10 c,
    c" Stack effects: a n --- a+1 n-1" 10 c,
    c" Deletes the first character from the string defined by address a" 10 c,
    c" and length n." 10 c,
    0 c,
  TAG info-4th "CIN"
    c" CIN 4TH" 10 c,
    c" Compiles to: ENVIRON (<address of CIN>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Identifies the input source." 10 c,
    0 c,
  TAG info-4th "CLOSE"
    c" CLOSE 4TH" 10 c,
    c" Compiles to: CLOSE (0)" 10 c,
    c" Stack effects: h ---" 10 c,
    c" CLOSE will close a file or pipe, previously opened by OPEN and" 10 c,
    c" release the stream. Depending on the file access method, the" 10 c,
    c" terminal will be made the current input-device, otherwise the" 10 c,
    c" screen will be made the current output-device." 10 c,
    0 c,
  TAG info-4th "CLOSE-BLOCKFILE"
    c" CLOSE-BLOCKFILE SOURCEFORGE" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Flush and close the current block file." 10 c,
    0 c,
  TAG info-4th "CLOSE-FILE"
    c" CLOSE-FILE FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: h --- f" 10 c,
    c" Close the file identified by handle h. Flag f is the" 10 c,
    c" implementation-defined I/O result code." 10 c,
    0 c,
  TAG info-4th "CMOVE"
    c" CMOVE STRING" 10 c,
    c" Pronunciation: c-move" 10 c,
    c" Compiles to: CMOVE (0)" 10 c,
    c" Stack effects: addr1 addr2 n ---" 10 c,
    c" Forth: In Forth there are two words for this operation, CMOVE and" 10 c,
    c" CMOVE>. Usage depends on the direction of the move. In 4tH CMOVE" 10 c,
    c" is smart, like MOVE." 10 c,
    c" Move the specified quantity of bytes (n) beginning at address" 10 c,
    c" addr1 to addr2." 10 c,
    0 c,
  TAG info-4th "CMOVE>"
    c" CMOVE> STRING" 10 c,
    c" Pronunciation: c-move-up" 10 c,
    c" Compiles to: CMOVE (0)" 10 c,
    c" Stack effects: addr1 addr2 n ---" 10 c,
    c" An alias for CMOVE (see: CMOVE)." 10 c,
    0 c,
  TAG info-4th "COMPARE"
    c" COMPARE STRING" 10 c,
    c" Include: compare.4th" 10 c,
    c" Stack effects: addr1 n1 addr2 n2 --- n3" 10 c,
    c" Compare the string specified by addr1 n1 to the string specified" 10 c,
    c" by addr2 n2 . The strings are compared, beginning at the given" 10 c,
    c" addresses, character by character, up to the length of the" 10 c,
    c" shorter string or until a difference is found. If the two strings" 10 c,
    c" are identical, n3 is zero. If the two strings are identical up to" 10 c,
    c" the length of the shorter string, n3 is -1 if n1 is less than n2" 10 c,
    c" and 1 otherwise. If the two strings are not identical up to the" 10 c,
    c" length of the shorter string, n3 is -1 if the first non-matching" 10 c,
    c" character in the string specified by addr1 n1 has a lesser" 10 c,
    c" numeric value than the corresponding character in the string" 10 c,
    c" specified by addr2 n2 and 1 otherwise." 10 c,
    0 c,
  TAG info-4th "CONSTANT"
    c" CONSTANT CORE" 10 c,
    c" Syntax: <literal><space>CONSTANT<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for CONSTANT. The instruction pointer is decremented, actually" 10 c,
    c" deleting the literal." 10 c,
    c" Forth: In Forth, the literal value is popped from the stack. This" 10 c,
    c" cannot be done in 4tH." 10 c,
    c" A defining word used to create word <name>. When <name> is later" 10 c,
    c" executed, it will push the value of <literal> on the stack." 10 c,
    0 c,
  TAG info-4th "COUNT"
    c" COUNT CORE" 10 c,
    c" Compiles to: COUNT (0)" 10 c,
    c" Stack effects: addr1 --- addr2 n" 10 c,
    c" Forth: Programs assuming that the string is a so-called counted" 10 c,
    c" string will not work. Well-written programs only assume the" 10 c,
    c" correct input- and output-parameters." 10 c,
    c" Leave the Character Segment address addr2 and count n of an" 10 c,
    c" ASCIIZ string beginning at Character Segment address addr1." 10 c,
    c" Typically COUNT is followed by TYPE." 10 c,
    0 c,
  TAG info-4th "COUT"
    c" COUT 4TH" 10 c,
    c" Compiles to: ENVIRON (<address of COUT>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Identifies the output source." 10 c,
    0 c,
  TAG info-4th "CR"
    c" CR CORE" 10 c,
    c" Pronunciation: c-r" 10 c,
    c" Compiles to: CR (0)" 10 c,
    c" Transmit a carriage return to the selected output-device. The" 10 c,
    c" actual sequence sent is OS- and stream-dependant." 10 c,
    0 c,
  TAG info-4th "CREATE"
    c" CREATE CORE" 10 c,
    c" Syntax: CREATE<space><name>" 10 c,
    c" Forth: In Forth this will create a dictionary header." 10 c,
    c" Leaves <name> in the symboltable and replace further occurences" 10 c,
    c" with LITERAL <xt>. <xt> represents the address in the Code" 10 c,
    c" Segment where CREATE was compiled." 10 c,
    0 c,
  TAG info-4th "CREATE-BLOCKFILE"
    c" CREATE-BLOCKFILE SOURCEFORGE" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: n1 addr n2---" 10 c,
    c" Create a blank block file named in the character string specified" 10 c,
    c" by addr and n2, with a size of n1 blocks." 10 c,
    0 c,
  TAG info-4th "CREATE-FILE"
    c" CREATE-FILE FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: addr n fam --- h f" 10 c,
    c" Create the file named in the character string specified by addr" 10 c,
    c" and n, and open it with file access method fam. The meaning of" 10 c,
    c" values of fam is implementation defined. If a file with the same" 10 c,
    c" name already exists, recreate it as an empty file. If the file" 10 c,
    c" was successfully created and opened, f is zero, handle h is its" 10 c,
    c" identifier, and the file has been positioned to the start of the" 10 c,
    c" file. Otherwise, f is the implementation-defined I/O result code" 10 c,
    c" and h is undefined." 10 c,
    0 c,
  TAG info-4th "C|"
    c" C| 4TH" 10 c,
    c" Syntax: C|<space><string>|" 10 c,
    c" Compiler: All printable characters from the string are added as" 10 c,
    c" characters to the String Segment. Nothing is actually compiled." 10 c,
    c" Reserve space for all the printable characters of the string" 10 c,
    c" issued in the String Segment and store those characters in that" 10 c,
    c" space." 10 c,
    0 c,
  TAG info-4th "D+"
    c" D+ DOUBLE" 10 c,
    c" Pronunciation: d-plus" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 d2 --- d3" 10 c,
    c" Add d1 to d2, giving the sum d3." 10 c,
    0 c,
  TAG info-4th "D-"
    c" D- DOUBLE" 10 c,
    c" Pronunciation: d-minus" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 d2 --- d3" 10 c,
    c" Subtract d2 from d1, giving the difference d3." 10 c,
    0 c,
  TAG info-4th "D."
    c" D. DOUBLE" 10 c,
    c" Pronunciation: d-dot" 10 c,
    c" Include: dbldot.4th" 10 c,
    c" Stack effects: d ---" 10 c,
    c" Display d in free field format." 10 c,
    0 c,
  TAG info-4th "D.R"
    c" D.R DOUBLE" 10 c,
    c" Pronunciation: d-dot-r" 10 c,
    c" Include: dbldot.4th" 10 c,
    c" Stack effects: d n ---" 10 c,
    c" Display d right aligned in a field n characters wide. If the" 10 c,
    c" number of characters required to display d is greater than n, all" 10 c,
    c" digits are displayed with no leading spaces in a field as wide as" 10 c,
    c" necessary." 10 c,
    0 c,
  TAG info-4th "D0<"
    c" D0< DOUBLE" 10 c,
    c" Pronunciation: d-zero-less" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d --- f" 10 c,
    c" Flag f is true if and only if d is less than zero." 10 c,
    0 c,
  TAG info-4th "D0="
    c" D0= DOUBLE" 10 c,
    c" Pronunciation: d-zero-equals" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d --- f" 10 c,
    c" Flag f is true if and only if d is equal to zero." 10 c,
    0 c,
  TAG info-4th "D2*"
    c" D2* DOUBLE" 10 c,
    c" Pronunciation: d-two-star" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 --- d2" 10 c,
    c" D2 is the result of shifting d1 one bit toward the" 10 c,
    c" most-significant bit, filling the vacated least-significant bit" 10 c,
    c" with zero." 10 c,
    0 c,
  TAG info-4th "D2/"
    c" D2/ DOUBLE" 10 c,
    c" Pronunciation: d-two-slash" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 --- d2" 10 c,
    c" D2 is the result of shifting d1 one bit toward the" 10 c,
    c" least-significant bit, leaving the most-significant bit" 10 c,
    c" unchanged." 10 c,
    0 c,
  TAG info-4th "D<"
    c" D< DOUBLE" 10 c,
    c" Pronunciation: d-less-than" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 d2 --- f" 10 c,
    c" Flag f is true if and only if d1 is less than d2." 10 c,
    0 c,
  TAG info-4th "D="
    c" D= DOUBLE" 10 c,
    c" Pronunciation: d-equals" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 d2 --- f" 10 c,
    c" Flag f is true if and only if d1 is equal to d2." 10 c,
    0 c,
  TAG info-4th "D>F"
    c" D>F FLOATING" 10 c,
    c" Pronunciation: d-to-f" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zentodbl.4th" 10 c,
    c" Stack effects: d ---" 10 c,
    c" Floating: --- r" 10 c,
    c" r is the floating-point equivalent of d. An ambiguous condition" 10 c,
    c" exists if d cannot be precisely represented as a floating-point" 10 c,
    c" value." 10 c,
    0 c,
  TAG info-4th "D>S"
    c" D>S DOUBLE" 10 c,
    c" Pronunciation: d-to-s" 10 c,
    c" Compiler: The instruction pointer is not incremented. In fact," 10 c,
    c" D>S is a dummy." 10 c,
    c" Stack effects: n --- n" 10 c,
    c" Convert the number n to number n with the same numerical value." 10 c,
    0 c,
  TAG info-4th "DABS"
    c" DABS DOUBLE" 10 c,
    c" Pronunciation: d-abs" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 --- d2" 10 c,
    c" D2 is the absolute value of d1." 10 c,
    0 c,
  TAG info-4th "DECIMAL"
    c" DECIMAL CORE" 10 c,
    c" Compiles to: RADIX (10)" 10 c,
    c" Forth: See HEX." 10 c,
    c" Set the numeric conversion BASE for decimal output at runtime." 10 c,
    0 c,
  TAG info-4th "DEFER"
    c" DEFER CORE EXT" 10 c,
    c" Compiles to: LITERAL ((ERROR))" 10 c,
    c" TO (<variable address>)" 10 c,
    c" Syntax: DEFER<space><name>" 10 c,
    c" Stack effects: ---" 10 c,
    c" Create a value name which will hold an execution token for a word" 10 c,
    c" whose behavior will be determined later and may be varied. The" 10 c,
    c" initial value will trigger an error if used before proper" 10 c,
    c" assignment." 10 c,
    0 c,
  TAG info-4th "DEFER!"
    c" DEFER! CORE EXT" 10 c,
    c" Compiles to: ENVIRON (<address of FIRST>)" 10 c,
    c" + (0)" 10 c,
    c" ! (0)" 10 c,
    c" Stack effects: xt x ---" 10 c,
    c" Set the vector x to execute xt." 10 c,
    0 c,
  TAG info-4th "DEFER@"
    c" DEFER@ CORE EXT" 10 c,
    c" Compiles to: ENVIRON (<address of FIRST>)" 10 c,
    c" + (0)" 10 c,
    c" @ (0)" 10 c,
    c" Stack effects: x --- xt" 10 c,
    c" xt is the xt associated with the deferred word corresponding to" 10 c,
    c" x." 10 c,
    0 c,
  TAG info-4th "DELETE-FILE"
    c" DELETE-FILE FILE" 10 c,
    c" Compiles to: DELETE-FILE (0)" 10 c,
    c" Stack effects: a n --- f" 10 c,
    c" Delete the ?1/4ule named in the character string speci?1/4ued by c-addr" 10 c,
    c" u. Return zero on success or true on failure." 10 c,
    0 c,
  TAG info-4th "DEPTH"
    c" DEPTH CORE" 10 c,
    c" Compiles to: SP@ (0)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Returns the number of items on the stack in n, before DEPTH was" 10 c,
    c" executed. An alias for SP@." 10 c,
    0 c,
  TAG info-4th "DMAX"
    c" DMAX DOUBLE" 10 c,
    c" Pronunciation: d-max" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 d2 --- d3" 10 c,
    c" D3 is the greater of d1 and d2." 10 c,
    0 c,
  TAG info-4th "DMIN"
    c" DMIN DOUBLE" 10 c,
    c" Pronunciation: d-min" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 d2 --- d3" 10 c,
    c" D3 is the lesser of d1 and d2." 10 c,
    0 c,
  TAG info-4th "DNEGATE"
    c" DNEGATE DOUBLE" 10 c,
    c" Pronunciation: d-negate" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 --- d2" 10 c,
    c" D2 is the negation of d1." 10 c,
    0 c,
  TAG info-4th "DO"
    c" DO CORE" 10 c,
    c" Compiles to: DO (0)" 10 c,
    c" Syntax: DO<space>..<space>+LOOP" 10 c,
    c" DO<space>..<space>LOOP" 10 c,
    c" Stack effects: n1 n2 ---" 10 c,
    c" At runtime DO begins a sequence with repetitive execution" 10 c,
    c" controlled by a loop limit n1 and an index with initial value n2." 10 c,
    c" DO removes these from the stack. Upon reaching LOOP or +LOOP the" 10 c,
    c" index is altered. Until the new index equals or exceeds the" 10 c,
    c" limit, execution loops back to just after DO; otherwise the loop" 10 c,
    c" parameters are discarded and execution continues ahead. Both n1" 10 c,
    c" and n2 are determined at runtime and may be the result of other" 10 c,
    c" operations. Within a loop I will copy the current value of the" 10 c,
    c" index on the stack." 10 c,
    0 c,
  TAG info-4th "DOES>"
    c" DOES> CORE" 10 c,
    c" Pronunciation: does" 10 c,
    c" Compiles to: BRANCH (<address of matching ; token>)" 10 c,
    c" LITERAL (<original value>) | VARIABLE (<original value>)" 10 c,
    c" Syntax: CREATE|BUFFER:|STRING|CONSTANT|VARIABLE|ARRAY<space>.." 10 c,
    c" <space>DOES><space>..<space>;" 10 c,
    c" Forth: In ANS-Forth, DOES> is typically combined with CREATE and" 10 c,
    c" has no interpretation semantics. The typical use of DOES> in 4tH" 10 c,
    c" will lead usually to compilation errors. Some Forth compilers" 10 c,
    c" (like gForth) are largely compatible with this 4tH construct." 10 c,
    c" Replace the execution semantics of the most recent definition" 10 c,
    c" with the execution semantics following DOES>. An error condition" 10 c,
    c" exists if the most recent definition was not a CREATE, BUFFER:," 10 c,
    c" STRING, CONSTANT, VARIABLE or ARRAY." 10 c,
    0 c,
  TAG info-4th "DONE"
    c" DONE 4TH" 10 c,
    c" Compiles to: BRANCH (<address of matching DONE, REPEAT or UNTIL" 10 c,
    c" token>)" 10 c,
    c" Syntax: WHILE<space>..<space>DONE<space>..<space>DONE" 10 c,
    c" Forth: Equivalent to:" 10 c,
    c" : DONE 1 CS-ROLL POSTPONE ELSE 1 CS-ROLL ; IMMEDIATE" 10 c,
    c" At runtime DONE executes after the true following WHILE. DONE" 10 c,
    c" forces execution to skip over the following false part and" 10 c,
    c" resumes execution after the second DONE, which skips execution to" 10 c,
    c" just after REPEAT or UNTIL, effectively exiting the structure." 10 c,
    0 c,
  TAG info-4th "DROP"
    c" DROP CORE" 10 c,
    c" Compiles to: DROP (0)" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Drop the number from the stack." 10 c,
    0 c,
  TAG info-4th "DU<"
    c" DU< DOUBLE EXT" 10 c,
    c" Pronunciation: d-u-less" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: d1 d2 --- f" 10 c,
    c" Flag is true if and only if usigned double d1 is less than" 10 c,
    c" unsigned double d2." 10 c,
    0 c,
  TAG info-4th "DUMP"
    c" DUMP TOOLS" 10 c,
    c" Include: dump.4th" 10 c,
    c" dumpbase.4th" 10 c,
    c" Stack effects: addr n ---" 10 c,
    c" Display the contents of n consecutive addresses starting at addr." 10 c,
    0 c,
  TAG info-4th "DUP"
    c" DUP CORE" 10 c,
    c" Pronunciation: dupe" 10 c,
    c" Compiles to: DUP (0)" 10 c,
    c" Stack effects: n --- n n" 10 c,
    c" Duplicate the value on the stack." 10 c,
    0 c,
  TAG info-4th "ELSE"
    c" ELSE CORE" 10 c,
    c" Compiles to: BRANCH (<address of matching THEN token>)" 10 c,
    c" Syntax: IF<space>..<space>ELSE<space>..<space>THEN" 10 c,
    c" At runtime ELSE executes after the true following IF. ELSE forces" 10 c,
    c" execution to skip over the following false part and resumes" 10 c,
    c" execution after the THEN." 10 c,
    0 c,
  TAG info-4th "EMIT"
    c" EMIT CORE" 10 c,
    c" Compiles to: EMIT (0)" 10 c,
    c" Stack effects: c ---" 10 c,
    c" Transmit the ASCII character with code n to the selected output" 10 c,
    c" device." 10 c,
    0 c,
  TAG info-4th "EMPTY-BUFFERS"
    c" EMPTY-BUFFERS BLOCK EXT" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Unassign all block buffers. Do not transfer the contents of any" 10 c,
    c" UPDATEd block buffer to mass storage." 10 c,
    0 c,
  TAG info-4th "END-STRUCT"
    c" END-STRUCT 4TH" 10 c,
    c" Syntax:" 10 c,
    c" STRUCT<space><literal><space>+FIELD<space><name><space>END-STRUCT<space><name>" 10 c,
    c" STRUCT<space><literal><space>/FIELD<space>END-STRUCT<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for END-STRUCT, creating a constant that holds the length of the" 10 c,
    c" STRUCT. The instruction pointer is decremented, actually deleting" 10 c,
    c" the literal." 10 c,
    c" Forth: Similar constructions are available in gForth. +FIELD is" 10 c,
    c" part of the Forth 200x draft." 10 c,
    c" Terminate the definition of a STRUCT. The created structure is an" 10 c,
    c" constant that memorizes the size of the structure (see: +FIELD," 10 c,
    c" /FIELD, STRUCT)." 10 c,
    0 c,
  TAG info-4th "ENUM"
    c" ENUM 4TH" 10 c,
    c" Syntax: <literal><space>ENUM<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for ENUM and incremented afterwards. The instruction pointer is" 10 c,
    c" left unchanged." 10 c,
    c" Forth: This word is available in some Forths." 10 c,
    c" A defining word used to create word <name>. When <name> is later" 10 c,
    c" executed, it will push the value of <literal> on the stack." 10 c,
    0 c,
  TAG info-4th "ENVIRON@"
    c" ENVIRON@ 4TH" 10 c,
    c" Compiles to: ENVIRON@ (0)" 10 c,
    c" Stack effects: addr1 n1 --- addr2 n2" 10 c,
    c" addr1 is the address of a character string containing the name of" 10 c,
    c" an environment variable and n1 is the string's character count." 10 c,
    c" If successful, it returns address addr2 and count n2 of the" 10 c,
    c" contents of the environment variable. On error both address addr2" 10 c,
    c" and count n2 are zero. Note that the contents may be truncated if" 10 c,
    c" there is not enough space available in the PAD." 10 c,
    0 c,
  TAG info-4th "ENVIRONMENT?"
    c" ENVIRONMENT? CORE" 10 c,
    c" Pronunciation: environment-query" 10 c,
    c" Include: environ.4th" 10 c,
    c" Stack effects: addr n --- -f" 10 c,
    c" addr is the address of a character string and n is the string's" 10 c,
    c" character count. The character string should contain a keyword" 10 c,
    c" from ANS-Forth environmental queries or the optional word sets to" 10 c,
    c" be checked for correspondence with an attribute of the present" 10 c,
    c" environment. The system treats the attribute as unknown, the" 10 c,
    c" returned flag is false." 10 c,
    0 c,
  TAG info-4th "EQUATES"
    c" EQUATES 4TH" 10 c,
    c" Syntax: <variable><space>EQUATES<space><name>" 10 c,
    c" Compiler: A variable, with an optional literal expression" 10 c,
    c" containing an offset, is entered as a new variable in the symbol" 10 c,
    c" table." 10 c,
    c" Forth: This word is equivalent to CONSTANT in most Forths." 10 c,
    c" A defining word used to create a static pointer to a variable or" 10 c,
    c" an array, which will behave as if it were a normal variable. When" 10 c,
    c" <name> is later executed, it will push the address <var> on the" 10 c,
    c" stack, so that a fetch or store may access this location." 10 c,
    0 c,
  TAG info-4th "ERASE"
    c" ERASE CORE EXT" 10 c,
    c" Compiles to: LITERAL (0)" 10 c,
    c" FILL (0)" 10 c,
    c" Stack effects: addr n ---" 10 c,
    c" If n is greater than zero, clear all bits in each of n" 10 c,
    c" consecutive address units of memory beginning at addr." 10 c,
    0 c,
  TAG info-4th "ERROR?"
    c" ERROR? 4TH" 10 c,
    c" Compiles to: LITERAL (<largest negative integer>)" 10 c,
    c" OVER (0)" 10 c,
    c" = (0)" 10 c,
    c" Stack effects: n --- n f" 10 c,
    c" If n equals (ERROR), leave a true flag, otherwise leave a false" 10 c,
    c" flag. Determines whether n indicates an error condition. The" 10 c,
    c" resulting stack diagram is ANS-Forth compliant." 10 c,
    0 c,
  TAG info-4th "EVALUATE"
    c" EVALUATE CORE" 10 c,
    c" Include: evaluate.4th" 10 c,
    c" Stack effects: addr n ---" 10 c,
    c" Forth: In Forth, the entire dictionary is available. In 4tH, the" 10 c,
    c" only words available are explicitly defined by the program." 10 c,
    c" Make the string described by addr and n the input buffer and" 10 c,
    c" interpret. Other stack effects are due to the words EVALUATEd." 10 c,
    0 c,
  TAG info-4th "EXECUTE"
    c" EXECUTE CORE" 10 c,
    c" Compiles to: EXECUTE (0)" 10 c,
    c" Stack effects: xt ---" 10 c,
    c" Execute the colon definition whose token-address xt is on the" 10 c,
    c" stack. The current token-address is pushed on the returnstack." 10 c,
    0 c,
  TAG info-4th "EXIT"
    c" EXIT CORE" 10 c,
    c" Compiles to: EXIT (0)" 10 c,
    c" When compiled within a colon-definition, terminates execution of" 10 c,
    c" that definition at that point. At runtime functionally equivalent" 10 c,
    c" to ;." 10 c,
    0 c,
  TAG info-4th "EXPECT"
    c" EXPECT CORE EXT" 10 c,
    c" Include: obsolete.4th" 10 c,
    c" Stack effects: addr n ---" 10 c,
    c" Receive a string of at most n-1 characters. The editing" 10 c,
    c" functions, if any, that the system performs in order to construct" 10 c,
    c" the string of characters are implementation-defined. Input" 10 c,
    c" terminates when an implementation-defined line terminator is" 10 c,
    c" received or when the string is n-1 characters long. When input" 10 c,
    c" terminates the display is maintained in an implementation-defined" 10 c,
    c" way. Store the string at addr and its length in SPAN (see SPAN)." 10 c,
    0 c,
  TAG info-4th "F!"
    c" F! FLOATING" 10 c,
    c" Pronunciation: f-store" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: x ---" 10 c,
    c" Floating: r ---" 10 c,
    c" Store r at address x." 10 c,
    0 c,
  TAG info-4th "F*"
    c" F* FLOATING" 10 c,
    c" Pronunciation: f-star" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r3" 10 c,
    c" Multiply r1 by r2 giving r3." 10 c,
    0 c,
  TAG info-4th "F**"
    c" F** FLOATING EXT" 10 c,
    c" Pronunciation: f-star-star" 10 c,
    c" Include: falog.4th" 10 c,
    c" zenfalog.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r3" 10 c,
    c" Raise r1 to the power r2, giving the product r3." 10 c,
    0 c,
  TAG info-4th "F+"
    c" F+ FLOATING" 10 c,
    c" Pronunciation: f-plus" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r3" 10 c,
    c" Add r1 to r2 giving the sum r3." 10 c,
    0 c,
  TAG info-4th "F-"
    c" F- FLOATING" 10 c,
    c" Pronunciation: f-minus" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r3" 10 c,
    c" Subtract r2 from r1 giving r3." 10 c,
    0 c,
  TAG info-4th "F."
    c" F. FLOATING EXT" 10 c,
    c" Pronunciation: f-dot" 10 c,
    c" Include: ansfpio.4th" 10 c,
    c" zenfpio.4th" 10 c,
    c" fpout.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r ---" 10 c,
    c" Display, with a trailing space, the top number on the" 10 c,
    c" floating-point stack using fixedpoint notation. An ambiguous" 10 c,
    c" condition exists if the value of BASE is not (decimal) ten or if" 10 c,
    c" the character string representation exceeds the size of the" 10 c,
    c" pictured numeric output string buffer." 10 c,
    0 c,
  TAG info-4th "F/"
    c" F/ FLOATING" 10 c,
    c" Pronunciation: f-slash" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r3" 10 c,
    c" Divide r1 by r2, giving the quotient r3. An ambiguous condition" 10 c,
    c" exists if r2 is zero, or the quotient lies outside of the range" 10 c,
    c" of a floating-point number." 10 c,
    0 c,
  TAG info-4th "F0<"
    c" F0< FLOATING" 10 c,
    c" Pronunciation: f-zero-less-than" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: --- f" 10 c,
    c" Floating: r ---" 10 c,
    c" Flag f is true if and only if r is less than zero." 10 c,
    0 c,
  TAG info-4th "F0="
    c" F0= FLOATING" 10 c,
    c" Pronunciation: f-zero-equals" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: --- f" 10 c,
    c" Floating: r ---" 10 c,
    c" Flag f is true if and only if r is equal to zero." 10 c,
    0 c,
  TAG info-4th "F<"
    c" F< FLOATING" 10 c,
    c" Pronunciation: f-less-than" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: --- f" 10 c,
    c" Floating: r1 r2 ---" 10 c,
    c" Flag f is true if and only if r1 is less than r2." 10 c,
    0 c,
  TAG info-4th "F>D"
    c" F>D FLOATING" 10 c,
    c" Pronunciation: f-to-d" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zentodbl.4th" 10 c,
    c" Stack effects: --- d" 10 c,
    c" Floating: r ---" 10 c,
    c" Double number d is the double-cell signed-integer equivalent of" 10 c,
    c" the integer portion of r. The fractional portion of r is" 10 c,
    c" discarded. An ambiguous condition exists if the integer portion" 10 c,
    c" of r cannot be precisely represented as a double-cell signed" 10 c,
    c" integer." 10 c,
    0 c,
  TAG info-4th "F>S"
    c" F>S FLOATING EXT" 10 c,
    c" Pronunciation: f-to-s" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Floating: r ---" 10 c,
    c" Number n is the less significant portion of the double word that" 10 c,
    c" would be produced by the word F>D applied to the floating-point" 10 c,
    c" value r. An ambiguous condition exists if applying F>D to r would" 10 c,
    c" result in an ambiguous condition." 10 c,
    0 c,
  TAG info-4th "F@"
    c" F@ FLOATING" 10 c,
    c" Pronunciation: f-fetch" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: x ---" 10 c,
    c" Floating: --- r" 10 c,
    c" Float r is the value stored at address x." 10 c,
    0 c,
  TAG info-4th "FABS"
    c" FABS FLOATING EXT" 10 c,
    c" Pronunciation: f-abs" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the absolute value of r1." 10 c,
    0 c,
  TAG info-4th "FACOS"
    c" FACOS FLOATING EXT" 10 c,
    c" Pronunciation: f-a-cos" 10 c,
    c" Include: asinacos.4th" 10 c,
    c" zenfasin.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the principal radian angle whose cosine is r1. An" 10 c,
    c" ambiguous condition exists if | r1 | is greater than one." 10 c,
    0 c,
  TAG info-4th "FACOSH"
    c" FACOSH FLOATING EXT" 10 c,
    c" Pronunciation: f-a-cosh" 10 c,
    c" Include: fatanh.4th" 10 c,
    c" zenatanh.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the floating-point value whose hyperbolic cosine is" 10 c,
    c" r1. An ambiguous condition exists if r1 is less than one." 10 c,
    0 c,
  TAG info-4th "FALIGN"
    c" FALIGN FLOATING" 10 c,
    c" Pronunciation: f-align" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: ---" 10 c,
    c" If the data-space pointer is not float aligned, reserve enough" 10 c,
    c" data space to make it so. In 4tH, it is a dummy." 10 c,
    0 c,
  TAG info-4th "FALIGNED"
    c" FALIGNED FLOATING" 10 c,
    c" Pronunciation: f-aligned" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" Stack effects: x --- x" 10 c,
    c" Floating: ---" 10 c,
    c" Address x is the first float-aligned address greater than or" 10 c,
    c" equal to address x. In 4tH, it is a dummy." 10 c,
    0 c,
  TAG info-4th "FALOG"
    c" FALOG FLOATING EXT" 10 c,
    c" Pronunciation: f-a-log" 10 c,
    c" Include: falog.4th" 10 c,
    c" zenfalog.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Raise ten to the power r1, giving r2." 10 c,
    0 c,
  TAG info-4th "FALSE"
    c" FALSE CORE EXT" 10 c,
    c" Compiles to: LITERAL (<false>)" 10 c,
    c" Stack effects: --- -f" 10 c,
    c" Returns a FALSE flag on the stack." 10 c,
    0 c,
  TAG info-4th "FASIN"
    c" FASIN FLOATING EXT" 10 c,
    c" Pronunciation: f-a-sine" 10 c,
    c" Include: asinacos.4th" 10 c,
    c" zenfasin.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the principal radian angle whose sine is r1. An" 10 c,
    c" ambiguous condition exists if | r1 | is greater than one." 10 c,
    0 c,
  TAG info-4th "FASINH"
    c" FASINH FLOATING EXT" 10 c,
    c" Pronunciation: f-a-cinch" 10 c,
    c" Include: fatanh.4th" 10 c,
    c" zenatanh.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the floating-point value whose hyperbolic sine is r1." 10 c,
    c" An ambiguous condition exists if r1 is less than zero." 10 c,
    0 c,
  TAG info-4th "FATAN"
    c" FATAN FLOATING EXT" 10 c,
    c" Pronunciation: f-a-tan" 10 c,
    c" Include: asinacos.4th" 10 c,
    c" zenfasin.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the principal radian angle whose tangent is r1." 10 c,
    0 c,
  TAG info-4th "FATAN2"
    c" FATAN2 FLOATING EXT" 10 c,
    c" Pronunciation: f-a-tan-two" 10 c,
    c" Include: fatan2.4th" 10 c,
    c" zenatan2.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r3" 10 c,
    c" Float r3 is the radian angle whose tangent is r1/r2. An ambiguous" 10 c,
    c" condition exists if r1 and r2 are zero." 10 c,
    0 c,
  TAG info-4th "FATANH"
    c" FATANH FLOATING EXT" 10 c,
    c" Pronunciation: f-a-tan-h" 10 c,
    c" Include: fatanh.4th" 10 c,
    c" zenatanh.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the floating-point value whose hyperbolic tangent is" 10 c,
    c" r1. An ambiguous condition exists if r1 is outside the range of" 10 c,
    c" -1 to 1." 10 c,
    0 c,
  TAG info-4th "FCOS"
    c" FCOS FLOATING EXT" 10 c,
    c" Pronunciation: f-cos" 10 c,
    c" Include: fsinfcos.4th" 10 c,
    c" fsincost.4th" 10 c,
    c" zenfsin.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the cosine of the radian angle r1." 10 c,
    0 c,
  TAG info-4th "FCOSH"
    c" FCOSH FLOATING EXT" 10 c,
    c" Pronunciation: f-cosh" 10 c,
    c" Include: sinhcosh.4th" 10 c,
    c" zenfsinh.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the hyperbolic cosine of r1." 10 c,
    0 c,
  TAG info-4th "FDEPTH"
    c" FDEPTH FLOATING" 10 c,
    c" Pronunciation: f-depth" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Floating: ---" 10 c,
    c" N is the number of values contained on the default separate" 10 c,
    c" floating-point stack." 10 c,
    0 c,
  TAG info-4th "FDROP"
    c" FDROP FLOATING" 10 c,
    c" Pronunciation: f-drop" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r ---" 10 c,
    c" Remove r from the floating-point stack." 10 c,
    0 c,
  TAG info-4th "FDUP"
    c" FDUP FLOATING" 10 c,
    c" Pronunciation: f-dupe" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r --- r r" 10 c,
    c" Duplicate r." 10 c,
    0 c,
  TAG info-4th "FE."
    c" FE. FLOATING EXT" 10 c,
    c" Pronunciation: f-e-dot" 10 c,
    c" Include: ansfpio.4th" 10 c,
    c" fpout.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r ---" 10 c,
    c" Display, with a trailing space, the top number on the" 10 c,
    c" floating-point stack using engineering notation, where the" 10 c,
    c" significand is greater than or equal to 1.0 and less than 1000.0" 10 c,
    c" and the decimal exponent is a multiple of three. An ambiguous" 10 c,
    c" condition exists if the value of BASE is not (decimal) ten or if" 10 c,
    c" the character string representation exceeds the size of the" 10 c,
    c" pictured numeric output string buffer." 10 c,
    0 c,
  TAG info-4th "FEXP"
    c" FEXP FLOATING EXT" 10 c,
    c" Pronunciation: f-e-x-p" 10 c,
    c" Include: fexp.4th" 10 c,
    c" fexpt.4th" 10 c,
    c" zenfexp.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Raise e to the power r1, giving r2." 10 c,
    0 c,
  TAG info-4th "FEXPM1"
    c" FEXPM1 FLOATING EXT" 10 c,
    c" Pronunciation: f-e-x-p-m-one" 10 c,
    c" Include: fexpm1.4th" 10 c,
    c" zenexpm1.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Raise e to the power r1 and subtract one, giving r2." 10 c,
    0 c,
  TAG info-4th "FIELD:"
    c" FIELD: FACILITY EXT" 10 c,
    c" Syntax: FIELD:<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for FIELD: and incremented afterwards. The instruction pointer is" 10 c,
    c" left unchanged." 10 c,
    c" Forth: This word may only be used in structures that are" 10 c,
    c" completely made up out of CELLS. In Forth, there is no such" 10 c,
    c" restriction." 10 c,
    c" The semantics are identical to the execution semantics of the" 10 c,
    c" phrase ALIGNED 1 CELLS +FIELD." 10 c,
    0 c,
  TAG info-4th "FILE"
    c" FILE 4TH" 10 c,
    c" Compiles to: LITERAL ((ERROR))" 10 c,
    c" TO (<variable address>)" 10 c,
    c" Syntax: FILE<space><name>" 10 c,
    c" Stack effects: ---" 10 c,
    c" Create a value name which will hold a filehandle. The initial" 10 c,
    c" value will trigger an error if used before proper assignment." 10 c,
    0 c,
  TAG info-4th "FILE-POSITION"
    c" FILE-POSITION FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: h --- n f" 10 c,
    c" n is the current file position for the file identified by handle" 10 c,
    c" h. Flag f is the implementation-defined I/O result code. n is" 10 c,
    c" undefined if f is non-zero." 10 c,
    0 c,
  TAG info-4th "FILE-SIZE"
    c" FILE-SIZE FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: h --- n f" 10 c,
    c" n is the size, in characters, of the file identified by handle h." 10 c,
    c" Flag f is the implementation-defined I/O result code. This" 10 c,
    c" operation does not affect the value returned by FILE-POSITION. n" 10 c,
    c" is undefined if f is true." 10 c,
    0 c,
  TAG info-4th "FILE-STATUS"
    c" FILE-STATUS FILE EXT" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: addr n1 --- n2 f" 10 c,
    c" Return the status of the file identified by the character string" 10 c,
    c" addr n1. If the file exists, flag f is zero; otherwise flag f is" 10 c,
    c" the implementation-defined I/O result code. n2 contains" 10 c,
    c" implementation defined information about the file." 10 c,
    0 c,
  TAG info-4th "FILES"
    c" FILES 4TH" 10 c,
    c" Compiles to: LITERAL (<number of open files>)" 10 c,
    c" Stack_effects: --- n" 10 c,
    c" Returns the maximum number of open streams 4tH can handle. Two of" 10 c,
    c" these streams are predefined, STDIN and STDOUT." 10 c,
    0 c,
  TAG info-4th "FILL"
    c" FILL CORE" 10 c,
    c" Compiles to: FILL (0)" 10 c,
    c" Stack effects: addr n c ---" 10 c,
    c" Fills n bytes in the Character Segment, beginning at address" 10 c,
    c" addr, with character c." 10 c,
    0 c,
  TAG info-4th "FIRST"
    c" FIRST 4TH" 10 c,
    c" Compiles to: ENVIRON (<address of FIRST>)" 10 c,
    c" Stack effects: --- x" 10 c,
    c" Leaves the variable address x of the first user-variable. If" 10 c,
    c" FIRST is greater than LAST, no user-variables have been defined." 10 c,
    0 c,
  TAG info-4th "FLN"
    c" FLN FLOATING EXT" 10 c,
    c" Pronunciation: f-l-n" 10 c,
    c" Include: flnflog.4th" 10 c,
    c" flnflogb.4th" 10 c,
    c" zenfln.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the natural logarithm of r1. An ambiguous condition" 10 c,
    c" exists if r1 is less than or equal to zero." 10 c,
    0 c,
  TAG info-4th "FLNP1"
    c" FLNP1 FLOATING EXT" 10 c,
    c" Pronunciation: f-l-n-p-one" 10 c,
    c" Include: flnp1.4th" 10 c,
    c" zenflnp1.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the natural logarithm of the quantity r1 plus one. An" 10 c,
    c" ambiguous condition exists if r1 is less than or equal to" 10 c,
    c" negative one." 10 c,
    0 c,
  TAG info-4th "FLOAT+"
    c" FLOAT+ FLOATING" 10 c,
    c" Pronunciation: float-plus" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: x1 --- x2" 10 c,
    c" Floating: ---" 10 c,
    c" Add the size in address units of a floating-point number to" 10 c,
    c" address x1, giving address x2." 10 c,
    0 c,
  TAG info-4th "FLOATS"
    c" FLOATS FLOATING" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: n1 --- n2" 10 c,
    c" Floating: ---" 10 c,
    c" Number n2 is the size in address units of n1 floating-point" 10 c,
    c" numbers." 10 c,
    0 c,
  TAG info-4th "FLOG"
    c" FLOG FLOATING EXT" 10 c,
    c" Pronunciation: f-log" 10 c,
    c" Include: flnflog.4th" 10 c,
    c" flnflogb.4th" 10 c,
    c" zenfln.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the base-ten logarithm of r1. An ambiguous condition" 10 c,
    c" exists if r1 is less than or equal to zero." 10 c,
    0 c,
  TAG info-4th "FLOOR"
    c" FLOOR FLOATING" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloor.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Round r1 to an integral value using the ?CYenround toward negative" 10 c,
    c" infinity?CYen rule, giving r2." 10 c,
    0 c,
  TAG info-4th "FLUSH"
    c" FLUSH BLOCK" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Perform the function of SAVE-BUFFERS, then unassign the block" 10 c,
    c" buffer." 10 c,
    0 c,
  TAG info-4th "FLUSH-FILE"
    c" FLUSH-FILE FILE EXT" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: h --- f" 10 c,
    c" Attempt to force any buffered information written to the file" 10 c,
    c" referred to by handle h to be written to mass storage, and the" 10 c,
    c" size information for the file to be recorded in the storage" 10 c,
    c" directory if changed. If the operation is successful, f is zero." 10 c,
    c" Otherwise, it is an implementation-defined I/O result code." 10 c,
    0 c,
  TAG info-4th "FM/MOD"
    c" FM/MOD CORE" 10 c,
    c" Pronunciation: f-m-slash-mod" 10 c,
    c" Include: mixed.4th" 10 c,
    c" Stack effects: d1 n1 --- n2 n3" 10 c,
    c" Divide d1 by n1, giving the floored quotient n3 and the remainder" 10 c,
    c" n2. Input and output stack arguments are signed. An ambiguous" 10 c,
    c" condition exists if n1 is zero or if the quotient lies outside" 10 c,
    c" the range of a single-cell signed integer." 10 c,
    0 c,
  TAG info-4th "FMAX"
    c" FMAX FLOATING" 10 c,
    c" Pronunciation: f-max" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfmin.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r3" 10 c,
    c" Float r3 is the greater of r1 and r2." 10 c,
    0 c,
  TAG info-4th "FMIN"
    c" FMIN FLOATING" 10 c,
    c" Pronunciation: f-min" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfmin.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r3" 10 c,
    c" Float r3 is the lesser of r1 and r2." 10 c,
    0 c,
  TAG info-4th "FNEGATE"
    c" FNEGATE FLOATING" 10 c,
    c" Pronunciation: f-negate" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the negation of r1." 10 c,
    0 c,
  TAG info-4th "FOVER"
    c" FOVER FLOATING" 10 c,
    c" Pronunciation: f-over" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r1 r2 r1" 10 c,
    c" Place a copy of r1 on top of the floating-point stack." 10 c,
    0 c,
  TAG info-4th "FREE"
    c" FREE MEMORY" 10 c,
    c" Include: ansmem.4th" 10 c,
    c" memchar.4th" 10 c,
    c" memcell.4th" 10 c,
    c" Stack effects: addr --- f" 10 c,
    c" Return the contiguous region of data space indicated by addr to" 10 c,
    c" the system for later allocation. addr shall indicate a region of" 10 c,
    c" data space that was previously obtained by ALLOCATE or RESIZE. If" 10 c,
    c" the operation succeeds, f is false. If the operation fails, f is" 10 c,
    c" true." 10 c,
    0 c,
  TAG info-4th "FROT"
    c" FROT FLOATING" 10 c,
    c" Pronunciation: f-rot" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 r3 --- r2 r3 r1" 10 c,
    c" Rotate the top three floating-point stack entries." 10 c,
    0 c,
  TAG info-4th "FROUND"
    c" FROUND FLOATING" 10 c,
    c" Pronunciation: f-round" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenround.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Round r1 to an integral value using the ?CYenround to nearest?CYen rule," 10 c,
    c" giving r2." 10 c,
    0 c,
  TAG info-4th "FS."
    c" FS. FLOATING EXT" 10 c,
    c" Pronunciation: f-s-dot" 10 c,
    c" Include: ansfpio.4th" 10 c,
    c" fpout.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r ---" 10 c,
    c" Display, with a trailing space, the top number on the" 10 c,
    c" floating-point stack in scientific notation. An ambiguous" 10 c,
    c" condition exists if the value of BASE is not (decimal) ten or if" 10 c,
    c" the character string representation exceeds the size of the" 10 c,
    c" pictured numeric output string buffer." 10 c,
    0 c,
  TAG info-4th "FSIN"
    c" FSIN FLOATING EXT" 10 c,
    c" Pronunciation: f-sine" 10 c,
    c" Include: fsinfcos.4th" 10 c,
    c" fsincost.4th" 10 c,
    c" zenfsin.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the sine of the radian angle r1." 10 c,
    0 c,
  TAG info-4th "FSINCOS"
    c" FSINCOS FLOATING EXT" 10 c,
    c" Pronunciation: f-sine-cos" 10 c,
    c" Include: fsinfcos.4th" 10 c,
    c" fsincost.4th" 10 c,
    c" zenfsin.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2 r3" 10 c,
    c" Float r2 is the sine of the radian angle r1. Float r3 is the" 10 c,
    c" cosine of the radian angle r1." 10 c,
    0 c,
  TAG info-4th "FSINH"
    c" FSINH FLOATING EXT" 10 c,
    c" Pronunciation: f-cinch" 10 c,
    c" Include: sinhcosh.4th" 10 c,
    c" zenfsinh.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the hyperbolic sine of r1." 10 c,
    0 c,
  TAG info-4th "FSQRT"
    c" FSQRT FLOATING EXT" 10 c,
    c" Pronunciation: f-square-root" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfsqrt.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the square root of r1. An ambiguous condition exists" 10 c,
    c" if r1 is less than zero." 10 c,
    0 c,
  TAG info-4th "FSWAP"
    c" FSWAP FLOATING" 10 c,
    c" Pronunciation: f-swap" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 r2 --- r2 r1" 10 c,
    c" Exchange the top two floating-point stack items." 10 c,
    0 c,
  TAG info-4th "FTAN"
    c" FTAN FLOATING EXT" 10 c,
    c" Pronunciation: f-tan" 10 c,
    c" Include: fsinfcos.4th" 10 c,
    c" fsincost.4th" 10 c,
    c" zenfsin.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the tangent of the radian angle r1. An ambiguous" 10 c,
    c" condition exists if cos (r1) is zero." 10 c,
    0 c,
  TAG info-4th "FTANH"
    c" FTANH FLOATING EXT" 10 c,
    c" Pronunciation: f-tan-h" 10 c,
    c" Include: sinhcosh.4th" 10 c,
    c" zenfsinh.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Floating: r1 --- r2" 10 c,
    c" Float r2 is the hyperbolic tangent of r1." 10 c,
    0 c,
  TAG info-4th "F~"
    c" F~ FLOATING EXT" 10 c,
    c" Pronunciation: f-proximate" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfprox.4th" 10 c,
    c" Stack effects: --- f" 10 c,
    c" Floating: r1 r2 r3 ---" 10 c,
    c" If r3 is positive, flag is true if the absolute value of (r1" 10 c,
    c" minus r2) is less than r3. If r3 is zero, flag is true if the" 10 c,
    c" implementation-dependent encoding of r1 and r2 are exactly" 10 c,
    c" identical. If r3 is negative, flag is true if the absolute value" 10 c,
    c" of (r1 minus r2) is less than the absolute value of r3 times the" 10 c,
    c" sum of the absolute values of r1 and r2." 10 c,
    0 c,
  TAG info-4th "HERE"
    c" HERE CORE" 10 c,
    c" Compiles to: LITERAL (<token address>)" 10 c,
    c" Stack effects: --- xt" 10 c,
    c" Forth: Leaves the address of the next available dictionary" 10 c,
    c" location. Since 4tH doesn't have a dictionary location, its use" 10 c,
    c" is very different." 10 c,
    c" At runtime, HERE leaves the address xt in the Code Segment where" 10 c,
    c" it was compiled." 10 c,
    0 c,
  TAG info-4th "HEX"
    c" HEX CORE EXT" 10 c,
    c" Compiles to: RADIX (16)" 10 c,
    c" Forth: In Forth this construction" 10 c,
    c" HEX : SOMETIN 16 ;" 10 c,
    c" will compile 16 as a hexadecimal number. In 4tH it will simply" 10 c,
    c" be compiled and 16 will be compiled as a decimal number. To" 10 c,
    c" emulate this construction use" 10 c,
    c" [HEX] : SOMETIN 16 ;" 10 c,
    c" instead." 10 c,
    c" Set the numeric conversion BASE for hexadecimal output at" 10 c,
    c" runtime." 10 c,
    0 c,
  TAG info-4th "HI"
    c" HI 4TH" 10 c,
    c" Compiles to: ENVIRON (<address of HI>)" 10 c,
    c" Stack effects: --- addr" 10 c,
    c" Leaves the address of the last character in the Character" 10 c,
    c" Segment." 10 c,
    0 c,
  TAG info-4th "HIDE"
    c" HIDE 4TH" 10 c,
    c" Syntax: HIDE<space><name>" 10 c,
    c" Find <name>, then delete name from the symbol table. Used to" 10 c,
    c" create private definitions." 10 c,
    0 c,
  TAG info-4th "HOLD"
    c" HOLD CORE" 10 c,
    c" Compiles to: HOLD (0)" 10 c,
    c" Stack effects: c ---" 10 c,
    c" Used between <# and #> to insert an ASCII character into a" 10 c,
    c" pictured numeric output string, e.g. [HEX] 2E HOLD will place a" 10 c,
    c" decimal point." 10 c,
    0 c,
  TAG info-4th "HOLDS"
    c" HOLDS CORE EXT" 10 c,
    c" Include: holds.4th" 10 c,
    c" Stack effects: a n ---" 10 c,
    c" Adds a string to the picture numeric output buffer." 10 c,
    0 c,
  TAG info-4th "I"
    c" I CORE" 10 c,
    c" Compiles to: I (0)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Used with a DO .. LOOP to copy the loop index to the stack. An" 10 c,
    c" alias for R." 10 c,
    0 c,
  TAG info-4th "IF"
    c" IF CORE" 10 c,
    c" Compiles to: 0BRANCH (<address of matching ELSE|THEN token>)" 10 c,
    c" Stack effects: f ---" 10 c,
    c" Syntax: See ELSE, THEN" 10 c,
    c" At runtime, IF selects execution based on f. If f is non-zero," 10 c,
    c" execution continues ahead through the true part. If f is zero" 10 c,
    c" execution skips till just after ELSE to execute the false part." 10 c,
    c" After each part, execution resumes after THEN." 10 c,
    0 c,
  TAG info-4th "IMMEDIATE"
    c" IMMEDIATE CORE" 10 c,
    c" Compiler: The instruction pointer is not incremented. In fact," 10 c,
    c" IMMEDIATE is a dummy." 10 c,
    c" Stack effects: ---" 10 c,
    c" Make the most recent definition an immediate word." 10 c,
    0 c,
  TAG info-4th "INCLUDE"
    c" INCLUDE COMUS" 10 c,
    c" Syntax: INCLUDE<space><string><space>" 10 c,
    c" Compiler: The contents of the file are inserted at this position." 10 c,
    c" An alias for [NEEDS (see: [NEEDS)." 10 c,
    0 c,
  TAG info-4th "INPUT"
    c" INPUT 4TH" 10 c,
    c" Compiles to: LITERAL (<fam>)" 10 c,
    c" Stack effects: --- fam" 10 c,
    c" This will leave a file access method on the stack, signalling an" 10 c,
    c" operation on an input-device." 10 c,
    0 c,
  TAG info-4th "INVERT"
    c" INVERT CORE" 10 c,
    c" Compiles to: INVERT (0)" 10 c,
    c" Stack effects: n1 --- n2" 10 c,
    c" Leave n1's binary complement as n2. This word is not equivalent" 10 c,
    c" to 0=." 10 c,
    0 c,
  TAG info-4th "IS"
    c" IS CORE EXT" 10 c,
    c" Compiles to: TO (<variable address>)" 10 c,
    c" Stack effects: xt ---" 10 c,
    c" Syntax: IS<space><name>" 10 c,
    c" Store xt in the value identified by name, previously defined by" 10 c,
    c" DEFER (see: DEFER)." 10 c,
    0 c,
  TAG info-4th "J"
    c" J CORE" 10 c,
    c" Compiles to: J (0)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Used with an embedded DO .. +LOOP to copy the outer loop index to" 10 c,
    c" the stack. Copies in fact the third item of the returnstack." 10 c,
    0 c,
  TAG info-4th "KEY"
    c" KEY CORE" 10 c,
    c" Include: key.4th" 10 c,
    c" Stack effects: --- c" 10 c,
    c" Forth: This implementation is identical to the one in pForth. It" 10 c,
    c" requires hitting the <ENTER> key, before any character is" 10 c,
    c" returned." 10 c,
    c" Receive one character char, a member of the" 10 c,
    c" implementation-defined character set. All standard characters can" 10 c,
    c" be received." 10 c,
    0 c,
  TAG info-4th "KEY?"
    c" KEY? FACILITY" 10 c,
    c" Pronunciation: key-question" 10 c,
    c" Include: key.4th" 10 c,
    c" Stack effects: --- f" 10 c,
    c" Forth: This implementation is identical to the one in pForth." 10 c,
    c" KEY? always returns false." 10 c,
    c" If a character is available, return true. Otherwise, return" 10 c,
    c" false." 10 c,
    0 c,
  TAG info-4th "LAST"
    c" LAST 4TH" 10 c,
    c" Compiles to: ENVIRON (<address of LAST>)" 10 c,
    c" Stack effects: --- x" 10 c,
    c" Leaves the variable address x of the last variable in the" 10 c,
    c" Variable Area." 10 c,
    0 c,
  TAG info-4th "LATEST"
    c" LATEST 4TH" 10 c,
    c" Compiles to: The last defined word" 10 c,
    c" Compile the last word that has been added to the symbol table" 10 c,
    c" (defined). Is equivalent to RECURSE if used within a colon" 10 c,
    c" definition." 10 c,
    0 c,
  TAG info-4th "LEAVE"
    c" LEAVE CORE" 10 c,
    c" Compiles to: LEAVE (0)" 10 c,
    c" Force termination of a DO .. +LOOP at the next opportunity by" 10 c,
    c" setting the loop index equal to the loop limit. The limit itself" 10 c,
    c" remains unchanged, and execution proceeds normally until +LOOP is" 10 c,
    c" encountered." 10 c,
    0 c,
  TAG info-4th "LIST"
    c" LIST BLOCK EXT" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Display block n in an implementation-defined format. Store n in" 10 c,
    c" SCR." 10 c,
    0 c,
  TAG info-4th "LO"
    c" LO 4TH" 10 c,
    c" Compiles to: LITERAL (<TIB+PAD>)" 10 c,
    c" Stack effects: --- addr" 10 c,
    c" Leaves the offset of the first character of the Allocation Area" 10 c,
    c" in the Character Segment. If LO is greater than HI, no memory has" 10 c,
    c" been allocated." 10 c,
    0 c,
  TAG info-4th "LOAD"
    c" LOAD BLOCK" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Before: evaluate.4th" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Forth: In Forth, the entire dictionary is available. In 4tH, the" 10 c,
    c" only words available are explicitly defined by the program." 10 c,
    c" Save the current input-source specification. Store n in BLK (thus" 10 c,
    c" making block n the input source and setting the input buffer to" 10 c,
    c" encompass its contents), set >IN to zero, and execute EVALUATE." 10 c,
    c" When the parse area is exhausted, restore the prior input source" 10 c,
    c" specification." 10 c,
    0 c,
  TAG info-4th "LOOP"
    c" LOOP CORE" 10 c,
    c" Compiles to: LOOP (<address of matching DO token>)" 10 c,
    c" Syntax: DO<space>..<space>+LOOP" 10 c,
    c" Used in the form DO .. LOOP. At runtime, LOOP selectively" 10 c,
    c" controls branching back to the corresponding DO based on the loop" 10 c,
    c" index and the loop limit. The index is incrementex and compared" 10 c,
    c" to the limit. The branch back to DO occurs until the new index is" 10 c,
    c" equal to the limit. Upon exiting the loop, the parameters are" 10 c,
    c" discarded and execution continues ahead." 10 c,
    0 c,
  TAG info-4th "LSHIFT"
    c" LSHIFT CORE" 10 c,
    c" Pronunciation: l-shift" 10 c,
    c" Compiles to: SHIFT (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Performs a logical bit shift on n1. Specifically, SHIFT shifts a" 10 c,
    c" number a number of bits, specified in n2, using a logical" 10 c,
    c" register shift. An alias for SHIFT." 10 c,
    0 c,
  TAG info-4th "M*"
    c" M* CORE" 10 c,
    c" Pronunciation: m-star" 10 c,
    c" Include: mixed.4th" 10 c,
    c" Stack effects: n1 n2 --- d" 10 c,
    c" d is the signed product of n1 times n2." 10 c,
    0 c,
  TAG info-4th "M*/"
    c" M*/ DOUBLE" 10 c,
    c" Pronunciation: m-star" 10 c,
    c" Include: mixed.4th" 10 c,
    c" Stack effects: d1 n1 n2 --- d2" 10 c,
    c" Multiply d1 by n1 producing the triple-cell intermediate result" 10 c,
    c" t. Divide t by n2 giving the double-cell quotient d2. An" 10 c,
    c" ambiguous condition exists if n2 is zero or negative, or the" 10 c,
    c" quotient lies outside of the range of a double-precision signed" 10 c,
    c" integer." 10 c,
    0 c,
  TAG info-4th "M+"
    c" M+ DOUBLE" 10 c,
    c" Pronunciation: m-star" 10 c,
    c" Include: mixed.4th" 10 c,
    c" Stack effects: d1 n1 --- d2" 10 c,
    c" Add n1 to d1, giving the sum d2." 10 c,
    0 c,
  TAG info-4th "MAX"
    c" MAX CORE" 10 c,
    c" Compiles to: MAX (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leave n3 as the greater of the two numbers n1 and n2." 10 c,
    0 c,
  TAG info-4th "MAX-N"
    c" MAX-N COMUS" 10 c,
    c" Compiles to: LITERAL (<largest positive integer>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Forth: Equivalent to:" 10 c,
    c| : MAX-N S" MAX-N" ENVIRONMENT? DROP ;| 10 c,
    c" Returns the largest positive integer that 4tH can handle. Usually" 10 c,
    c" 2^31." 10 c,
    0 c,
  TAG info-4th "MIN"
    c" MIN CORE" 10 c,
    c" Compiles to: MIN (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leave n3 as the smaller of the two numbers n1 and n2." 10 c,
    0 c,
  TAG info-4th "MOD"
    c" MOD CORE" 10 c,
    c" Compiles to: MOD (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leave the remainder of n1/n2 with the same sign as n1 in n3." 10 c,
    0 c,
  TAG info-4th "MOVE"
    c" MOVE CORE" 10 c,
    c" Compiles to: CMOVE (0)" 10 c,
    c" Stack effects: addr1 addr2 n ---" 10 c,
    c" Move the specified quantity of bytes (n) beginning at address" 10 c,
    c" addr1 to addr2 in the Character Segment." 10 c,
    0 c,
  TAG info-4th "MS"
    c" MS FACILITY EXT" 10 c,
    c" Include: ansfacil.4th" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Forth: In Forth, the resolution is significantly higher than" 10 c,
    c" between +0 and +1999 ms." 10 c,
    c" Wait at least u milliseconds." 10 c,
    0 c,
  TAG info-4th "N>R"
    c" N>R TOOLS EXT" 10 c,
    c" Include: ntor.4th" 10 c,
    c" Stack effects: n1 n2 n3 nx x ---" 10 c,
    c" Remove x+1 items from the data stack and store them for later" 10 c,
    c" retrieval by NR>. The return stack may be used to store the data." 10 c,
    c" Until this data has been retrieved by NR>: (a) this data will not" 10 c,
    c" be overwritten by a subsequent invocation of N>R and (b) a" 10 c,
    c" program may not access data placed on the return stack before the" 10 c,
    c" invocation of N>R. Be sure to undercut tail optimization by" 10 c,
    c" applying the [FORCE] directive to each definition using this" 10 c,
    c" word! (see [FORCE])." 10 c,
    0 c,
  TAG info-4th "NEGATE"
    c" NEGATE CORE" 10 c,
    c" Compiles to: NEGATE (0)" 10 c,
    c" Stack effects: n1 --- -n1" 10 c,
    c" Leave n1 negated (two's complement)." 10 c,
    0 c,
  TAG info-4th "NIP"
    c" NIP CORE EXT" 10 c,
    c" Compiles to: SWAP (0)" 10 c,
    c" DROP (0)" 10 c,
    c" Stack effects: n1 n2 --- n2" 10 c,
    c" Drop the first item below the top of stack." 10 c,
    0 c,
  TAG info-4th "NOT"
    c" NOT COMUS" 10 c,
    c" Compiles to: 0= (0)" 10 c,
    c" Stack effects: n --- f" 10 c,
    c" An alias for 0= (see: 0=)." 10 c,
    0 c,
  TAG info-4th "NR>"
    c" NR> TOOLS EXT" 10 c,
    c" Include: ntor.4th" 10 c,
    c" Stack effects: --- n1 n2 n3 nx x" 10 c,
    c" Retrieve the items previously stored by an invocation of N>R. x" 10 c,
    c" is the number of items placed on the data stack. It is an" 10 c,
    c" ambiguous condition if NR> is used with data not stored by N>R." 10 c,
    c" Be sure to undercut tail optimization by applying the [FORCE]" 10 c,
    c" directive to each definition using this word! (see [FORCE])." 10 c,
    0 c,
  TAG info-4th "NUMBER"
    c" NUMBER 4TH" 10 c,
    c" Compiles to: NUMBER (0)" 10 c,
    c" Stack effects: addr n1 --- n2" 10 c,
    c" Forth: Some Forths support this word too, but issue a message on" 10 c,
    c" error." 10 c,
    c" Convert an string at offset addr with length n1 in the Character" 10 c,
    c" Segment to number n2. If numeric conversion is not possible" 10 c,
    c" (ERROR) is left on the stack." 10 c,
    0 c,
  TAG info-4th "OCTAL"
    c" OCTAL 4TH" 10 c,
    c" Compiles to: RADIX (8)" 10 c,
    c" Forth: See HEX." 10 c,
    c" Set the numeric conversion BASE for octal output at runtime." 10 c,
    0 c,
  TAG info-4th "OFFSET"
    c" OFFSET 4TH" 10 c,
    c" Syntax: OFFSET<space><name>" 10 c,
    c" Forth: Equivalent to:" 10 c,
    c" : OFFSET CREATE DOES> SWAP CHARS + C@ ;" 10 c,
    c" Leaves <name> in the symboltable and replaces further occurences" 10 c,
    c" of <name> with an execution procedure which takes an index from" 10 c,
    c" the stack and leaves the character concerned on the stack." 10 c,
    0 c,
  TAG info-4th "OMIT"
    c" OMIT 4TH" 10 c,
    c" Compiles to: OMIT (0)" 10 c,
    c" Stack effects: c ---" 10 c,
    c" Skips all leading delimiters in the Character Segment, using" 10 c,
    c" character c as a delimiter." 10 c,
    0 c,
  TAG info-4th "OPEN"
    c" OPEN 4TH" 10 c,
    c" Compiles to: OPEN (0)" 10 c,
    c" Stack effects: addr n fam --- h" 10 c,
    c" OPEN will open the file, which name has been specified by an" 10 c,
    c" ASCIIZ string, starting at offset addr in the Character Segment" 10 c,
    c" and having length n. Depending on the file access method, the" 10 c,
    c" file or pipe will be opened for reading, otherwise for writing." 10 c,
    c" If the file or pipe was succesfully opened it will be connected" 10 c,
    c" to a stream and a valid filehandle will be left on the stack. If" 10 c,
    c" not, (ERROR) will be left on the stack. Note that OPEN does not" 10 c,
    c" connect a stream to a channel (see: USE)." 10 c,
    0 c,
  TAG info-4th "OPEN-BLOCKFILE"
    c" OPEN-BLOCKFILE SOURCEFORGE" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: addr n ---" 10 c,
    c" Open the block file named in the character string specified by" 10 c,
    c" addr n. If successful then set it as the current block file," 10 c,
    c" otherwise abort." 10 c,
    0 c,
  TAG info-4th "OPEN-FILE"
    c" OPEN-FILE FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: addr n fam --- h f" 10 c,
    c" Open the file named in the character string specified by addr n," 10 c,
    c" with file access method indicated by fam. The meaning of values" 10 c,
    c" of fam is implementation defined. If the file is successfully" 10 c,
    c" opened, flag f is zero, handle h is its identifier, and the file" 10 c,
    c" has been positioned to the start of the file. Otherwise, f is the" 10 c,
    c" implementation-defined I/O result code and h is undefined." 10 c,
    0 c,
  TAG info-4th "OR"
    c" OR CORE" 10 c,
    c" Compiles to: OR (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leave the bitwise logical OR in n3 of the numbers n1 and n2." 10 c,
    0 c,
  TAG info-4th "OUT"
    c" OUT COMUS" 10 c,
    c" Compiles to: LITERAL (<address of OUT>)" 10 c,
    c" Stack effects: --- x" 10 c,
    c" A variable containing the the value that will be returned to the" 10 c,
    c" host program." 10 c,
    0 c,
  TAG info-4th "OUTPUT"
    c" OUTPUT 4TH" 10 c,
    c" Compiles to: LITERAL (<fam>)" 10 c,
    c" Stack effects: --- fam" 10 c,
    c" This will leave a file access method on the stack, signalling an" 10 c,
    c" operation on an output-device." 10 c,
    0 c,
  TAG info-4th "OVER"
    c" OVER CORE" 10 c,
    c" Compiles to: OVER (0)" 10 c,
    c" Stack effects: n1 n2 --- n1 n2 n1" 10 c,
    c" Copy the second stack value to the top of the stack." 10 c,
    0 c,
  TAG info-4th "PAD"
    c" PAD CORE EXT" 10 c,
    c" Compiles to: LITERAL (<address of PAD>)" 10 c,
    c" Stack effects: --- addr" 10 c,
    c" Leave the address of the text output buffer." 10 c,
    0 c,
  TAG info-4th "PARSE"
    c" PARSE CORE EXT" 10 c,
    c" Compiles to: PARSE (0)" 10 c,
    c" Stack effects: c --- addr n" 10 c,
    c" Reads a string from the Character Segment, using character c as a" 10 c,
    c" delimiter. Leaves the addr/count pair addr n. The resulting" 10 c,
    c" string is not zero-terminated. If the parse area was empty, the" 10 c,
    c" resulting string has a zero length." 10 c,
    0 c,
  TAG info-4th "PARSE-WORD"
    c" PARSE-WORD 4TH" 10 c,
    c" Compiles to: DUP (0)" 10 c,
    c" OMIT (0)" 10 c,
    c" PARSE (0)" 10 c,
    c" Stack effects: c --- addr n" 10 c,
    c" Reads a string from the Character Segment, using character c as a" 10 c,
    c" delimiter and skipping all leading delimiters. Leaves the" 10 c,
    c" addr/count pair addr n. The resulting string is not" 10 c,
    c" zero-terminated." 10 c,
    0 c,
  TAG info-4th "PAUSE"
    c" PAUSE 4TH" 10 c,
    c" Compiles to: PAUSE (0)" 10 c,
    c" Stack_effects: ---" 10 c,
    c" Saves a stackframe, closes all files and quits execution. Leaves" 10 c,
    c" the virtual machine in a state where it can resume execution." 10 c,
    0 c,
  TAG info-4th "PICK"
    c" PICK CORE EXT" 10 c,
    c" Include: pickroll.4th" 10 c,
    c" Stack effects: nu .. n1 n2 u --- nu .. n1 n2 nu" 10 c,
    c" Remove u. Copy the nu to the top of the stack." 10 c,
    0 c,
  TAG info-4th "PIPE"
    c" PIPE 4TH" 10 c,
    c" Compiles to: LITERAL (<fam>)" 10 c,
    c" Stack effects: --- fam" 10 c,
    c" This will leave a file access method modifier on the stack," 10 c,
    c" signalling an operation on a pipe. Must be added to another file" 10 c,
    c" access modifier. Used in combination with INPUT and OUTPUT. If an" 10 c,
    c" OS does not support pipes, opening a pipe will always fail." 10 c,
    0 c,
  TAG info-4th "PLACE"
    c" PLACE COMUS" 10 c,
    c" Compiles to: PLACE (0)" 10 c,
    c" Stack effects: addr1 n addr2 ---" 10 c,
    c" Copies the string at address addr1 with count n to address addr2." 10 c,
    0 c,
  TAG info-4th "PRECISION"
    c" PRECISION FLOATING EXT" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Floating: ---" 10 c,
    c" Return the number of significant digits currently used by F, FE," 10 c,
    c" or FS as n." 10 c,
    0 c,
  TAG info-4th "QUERY"
    c" QUERY CORE EXT" 10 c,
    c" Include: obsolete.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Make the user input device the input source. Receive input into" 10 c,
    c" the terminal input buffer, replacing any previous contents. Make" 10 c,
    c" the result, whose address is returned by TIB, the input buffer." 10 c,
    c" Set >IN to zero." 10 c,
    0 c,
  TAG info-4th "QUIT"
    c" QUIT CORE" 10 c,
    c" Compiles to: QUIT (0)" 10 c,
    c" Forth: This word has quite another meaning in Forth." 10 c,
    c" Sets the program counter to the end of the program. Effectively" 10 c,
    c" quits execution." 10 c,
    0 c,
  TAG info-4th "R>"
    c" R> CORE" 10 c,
    c" Pronunciation: r-from" 10 c,
    c" Compiles to: R> (0)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Remove the top value from the return stack and leave it on the" 10 c,
    c" stack." 10 c,
    0 c,
  TAG info-4th "R'@"
    c" R'@ TOOLBELT" 10 c,
    c" Compiles to: R> (0)" 10 c,
    c" I (0)" 10 c,
    c" SWAP (0)" 10 c,
    c" >R (0)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Copy the second return stack item to the stack." 10 c,
    0 c,
  TAG info-4th "R/O"
    c" R/O FILE" 10 c,
    c" Pronunciation: r-o" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: --- fam" 10 c,
    c" fam is the implementation-defined value for selecting the read" 10 c,
    c" only file access method." 10 c,
    0 c,
  TAG info-4th "R/W"
    c" R/W FILE" 10 c,
    c" Pronunciation: r-w" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: --- fam" 10 c,
    c" fam is the implementation-defined value for selecting the read" 10 c,
    c" write file access method." 10 c,
    0 c,
  TAG info-4th "R@"
    c" R@ CORE" 10 c,
    c" Pronunciation: r-fetch" 10 c,
    c" Compiles to: I (0)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Copy the top of the return stack to the stack." 10 c,
    0 c,
  TAG info-4th "READ-FILE"
    c" READ-FILE FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: addr n1 h --- n2 f" 10 c,
    c" Read n1 consecutive characters to addr from the current position" 10 c,
    c" of the file identified by handle h. If n1 characters are read" 10 c,
    c" without an exception, flag f is zero and n2 is equal to n1. If" 10 c,
    c" the end of the file is reached before n1 characters are read," 10 c,
    c" flag f is zero and n2 is the number of characters actually read." 10 c,
    c" At the conclusion of the operation, FILE-POSITION returns the" 10 c,
    c" next file position after the last character read." 10 c,
    0 c,
  TAG info-4th "READ-LINE"
    c" READ-LINE FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: addr n1 h --- n2 f1 f2" 10 c,
    c" Read the next line from the file specified by handle h into" 10 c,
    c" memory at the address addr. At most n1 characters are read. Up to" 10 c,
    c" two implementation-defined line terminating characters may be" 10 c,
    c" read into memory at the end of the line, but are not included in" 10 c,
    c" the count n2. The line buffer provided by addr should be at least" 10 c,
    c" n1+2 characters long. If the operation succeeded, flag f1 is true" 10 c,
    c" and flag f2 is zero. If a line terminator was received before n1" 10 c,
    c" characters were read, then n2 is the number of characters, not" 10 c,
    c" including the line terminator, actually read (0 <= n2 <= n1)." 10 c,
    c" When n1 = n2 the line terminator has yet to be reached. If the" 10 c,
    c" operation is initiated when the value returned by FILE-POSITION" 10 c,
    c" is equal to the value returned by FILE-SIZE for the file" 10 c,
    c" identified by handle h, flag f1 is false, flag f2 is zero, and n2" 10 c,
    c" is zero. If flag f2 is non-zero, an exception occurred during the" 10 c,
    c" operation and f2 is the implementation-defined I/O result code." 10 c,
    c" At the conclusion of the operation, FILE-POSITION returns the" 10 c,
    c" next file position after the last character read." 10 c,
    0 c,
  TAG info-4th "RECURSE"
    c" RECURSE CORE" 10 c,
    c" Compiles to: CALL (<last defined word>)" 10 c,
    c" Compile a call to the current colon-definition inside the current" 10 c,
    c" colon-definition. If this word is used outside a colon definition" 10 c,
    c" it is undefined." 10 c,
    0 c,
  TAG info-4th "REFILL"
    c" REFILL CORE EXT   FILE EXT" 10 c,
    c" Compiles to: REFILL (0)" 10 c,
    c" Stack effects: --- f" 10 c,
    c" Attempt to fill the input buffer from the input source, returning" 10 c,
    c" a true flag if successful. When the input source is the user" 10 c,
    c" input device, attempt to receive input into the terminal input" 10 c,
    c" buffer. When the input source is a text file, attempt to read the" 10 c,
    c" next line from the text-input file. If successful, make the" 10 c,
    c" result the input buffer, set >IN to zero, and return true." 10 c,
    c" Receipt of a line containing no characters is considered" 10 c,
    c" successful. If there is no input available from the current input" 10 c,
    c" source, return false." 10 c,
    0 c,
  TAG info-4th "RENAME-FILE"
    c" RENAME-FILE FILE EXT" 10 c,
    c" Include: ansren.4th" 10 c,
    c" Stack effects: a1 n1 a2 n2 --- f" 10 c,
    c" Forth: Forth usually does a true rename. 4tH copies the original" 10 c,
    c" file to a new file and deletes the old one." 10 c,
    c" Rename the ?1/4ule named by the character string a1 n1 to the name in" 10 c,
    c" the character string a2 n2. It returns true on error and false on" 10 c,
    c" success." 10 c,
    0 c,
  TAG info-4th "REPEAT"
    c" REPEAT CORE" 10 c,
    c" Compiles to: BRANCH (<address of matching BEGIN>)" 10 c,
    c" Syntax: BEGIN<space>..<space>WHILE<space>..<space>REPEAT" 10 c,
    c" Forth: Within a BEGIN .. REPEAT construct, multiple WHILEs may be" 10 c,
    c" used as well, but additional words are necessary to complete the" 10 c,
    c" construct." 10 c,
    c" At runtime, REPEAT forces an unconditional branch back to just" 10 c,
    c" after the corresponding BEGIN. Multiple WHILEs may be used." 10 c,
    0 c,
  TAG info-4th "REPLACES"
    c" REPLACES STRING EXT" 10 c,
    c" Include: substit.4th" 10 c,
    c" Stack effects: a1 n2 a2 n2 ---" 10 c,
    c" Set the string defined by a1 and n1 as the text to substitute for" 10 c,
    c" the substitution named by a2 and n2. If the substitution does not" 10 c,
    c" exist it is created. The program may then reuse the buffer a1 n1" 10 c,
    c" without affecting the definition of the substitution. Ambiguous" 10 c,
    c" conditions occur as follows:" 10 c,
    c" 1. The substitution cannot be created." 10 c,
    c" 2. The name of a substitution contains a delimiter character." 10 c,
    0 c,
  TAG info-4th "REPOSITION-FILE"
    c" REPOSITION-FILE FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: n h --- f" 10 c,
    c" Reposition the file identified by handle h to n. Flag f is the" 10 c,
    c" implementation-defined I/O result code. An ambiguous condition" 10 c,
    c" exists if the file is positioned outside the file boundaries. At" 10 c,
    c" the conclusion of the operation, FILE-POSITION returns the value" 10 c,
    c" n." 10 c,
    0 c,
  TAG info-4th "REPRESENT"
    c" REPRESENT FLOATING" 10 c,
    c" Include: represnt.4th" 10 c,
    c" Stack effects: addr n1 --- n2 f1 f2" 10 c,
    c" Floating: r ---" 10 c,
    c" At addr, place the character-string external representation of" 10 c,
    c" the significand of the floating-point number r. The size of the" 10 c,
    c" buffer identified by addr must be greater than or equal to" 10 c,
    c" MAXDIGITS and will not be terminated by REPRESENT. Return the" 10 c,
    c" decimal-base exponent as n2, the sign as f1 and ?CYenvalid result?CYen as" 10 c,
    c" f2. The character string shall consist of the n1 most significant" 10 c,
    c" digits of the significand represented as a decimal fraction with" 10 c,
    c" the implied decimal point to the left of the first digit, and the" 10 c,
    c" first digit zero only if all digits are zero. The significand is" 10 c,
    c" rounded to n1 digits following the ?CYenround to nearest?CYen rule; n2 is" 10 c,
    c" adjusted, if necessary, to correspond to the rounded magnitude of" 10 c,
    c" the significand. If f2 is true then r was in the" 10 c,
    c" implementation-defined range of floating-point numbers. If f1 is" 10 c,
    c" true then r is negative. An ambiguous condition exists if the" 10 c,
    c" value of BASE is not decimal ten." 10 c,
    0 c,
  TAG info-4th "RESIZE"
    c" RESIZE MEMORY" 10 c,
    c" Include: ansmem.4th" 10 c,
    c" memchar.4th" 10 c,
    c" memcell.4th" 10 c,
    c" Stack effects: addr1 n --- addr2 f" 10 c,
    c" Change the allocation of the contiguous data space starting at" 10 c,
    c" the address addr1, previously allocated by ALLOCATE or RESIZE, to" 10 c,
    c" n address units. n may be either larger or smaller than the" 10 c,
    c" current size of the region. If the operation succeeds, addr2 is" 10 c,
    c" the aligned starting address of n address units of allocated" 10 c,
    c" memory and f is false. The values contained in the region at" 10 c,
    c" addr1 are copied to addr2, up to the minimum size of either of" 10 c,
    c" the two regions. If they are the same, the values contained in" 10 c,
    c" the region are preserved to the minimum of n or the original" 10 c,
    c" size. If addr2 is not the same as addr1, the region of memory at" 10 c,
    c" addr1 is returned to the system according to the operation of" 10 c,
    c" FREE. If the operation fails, addr2 equals addr1, the region of" 10 c,
    c" memory at addr1 is unaffected, and f is true." 10 c,
    0 c,
  TAG info-4th "RESTORE-INPUT"
    c" RESTORE-INPUT CORE EXT" 10 c,
    c" Include: evaluate.4th" 10 c,
    c" Stack effects: n1 n2 a1 n3 h n4 --- f" 10 c,
    c" Attempt to restore the input source specification to the state" 10 c,
    c" described by n1 through h. Flag is true if the input source" 10 c,
    c" specification cannot be so restored." 10 c,
    0 c,
  TAG info-4th "REWIND"
    c" REWIND 4TH" 10 c,
    c" Compiles to: LITERAL (0)" 10 c,
    c" SWAP (0)" 10 c,
    c" SEEK (0)" 10 c,
    c" Stack effects: h --- f" 10 c,
    c" Reposition the file identified by handle h to the beginning of" 10 c,
    c" the file. If the operation is successful, FALSE is returned," 10 c,
    c" otherwise TRUE." 10 c,
    0 c,
  TAG info-4th "ROLL"
    c" ROLL CORE EXT" 10 c,
    c" Include: pickroll.4th" 10 c,
    c" Stack effects: nu n1 .. n2 u --- n1 .. n2 nu" 10 c,
    c" Remove u. Rotate u+1 items on the top of the stack." 10 c,
    0 c,
  TAG info-4th "ROT"
    c" ROT CORE" 10 c,
    c" Pronunciation: rote" 10 c,
    c" Compiles to: ROT (0)" 10 c,
    c" Stack effects: n1 n2 n3 --- n2 n3 n1" 10 c,
    c" Rotate the top three values on the stack, bringing the third to" 10 c,
    c" the top." 10 c,
    0 c,
  TAG info-4th "RP@"
    c" RP@ 4TH" 10 c,
    c" Compiles to: RP@ (0)" 10 c,
    c" Stack effects: --- sp" 10 c,
    c" Return the address sp of the stack position of the top of the" 10 c,
    c" return stack as it was before RP@ was executed." 10 c,
    0 c,
  TAG info-4th "RSHIFT"
    c" RSHIFT CORE" 10 c,
    c" Pronunciation: r-shift" 10 c,
    c" Compiles to: NEGATE (0)" 10 c,
    c" SHIFT (0)" 10 c,
    c" Stack effects: n1 n2 --- n3 )" 10 c,
    c" Perform a logical right shift of n2 bit-places on n1, giving n2." 10 c,
    c" Put zeroes into the most significant bits vacated by the shift" 10 c,
    c" (depends on implementation[footnote:" 10 c,
    c" Some C compilers do an arithmetic shift, leaving the most" 10 c,
    c" significant bit set." 10 c,
    c" ])." 10 c,
    0 c,
  TAG info-4th |S"|
    c| S" CORE   FILE| 10 c,
    c" Pronunciation: s-quote" 10 c,
    c| Compiles to: S" (<address of string constant>)| 10 c,
    c| Syntax: S"<space><string>"| 10 c,
    c" Stack effects: --- addr n" 10 c,
    c| Compiles string delimited by " in the String Segment with an| 10 c,
    c" execution procedure to move the string to PAD. Leaves the address" 10 c,
    c" and the length of the string on the stack." 10 c,
    0 c,
  TAG info-4th "S>D"
    c" S>D CORE" 10 c,
    c" Pronunciation: s-to-d" 10 c,
    c" Compiler: The instruction pointer is not incremented. In fact," 10 c,
    c" S>D is a dummy." 10 c,
    c" Stack effects: n --- n" 10 c,
    c" Convert the number n to double number n with the same numerical" 10 c,
    c" value." 10 c,
    0 c,
  TAG info-4th "S>F"
    c" S>F FLOATING EXT" 10 c,
    c" Pronunciation: s-to-f" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenfloat.4th" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Floating: --- r" 10 c,
    c" r is the floating-point equivalent of the single-cell value n." 10 c,
    0 c,
  TAG info-4th "S|"
    c" S| 4TH" 10 c,
    c| Compiles to: S" (<address of string constant>)| 10 c,
    c" Syntax: S|<space><string>|" 10 c,
    c" Stack effects: --- addr n" 10 c,
    c" Compiles string delimited by | in the String Segment with an" 10 c,
    c" execution procedure to move the string to PAD. Leaves the address" 10 c,
    c" and the length of the string on the stack." 10 c,
    0 c,
  TAG info-4th "SAVE-BUFFERS"
    c" SAVE-BUFFERS BLOCK" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Transfer the contents of each UPDATEd block buffer to mass" 10 c,
    c" storage. Mark the buffer as unmodified." 10 c,
    0 c,
  TAG info-4th "SAVE-INPUT"
    c" SAVE-INPUT CORE EXT" 10 c,
    c" Include: evaluate.4th" 10 c,
    c" Stack effects: --- n1 n2 a1 n3 h n4" 10 c,
    c" n1 through h describe the current state of the input source" 10 c,
    c" specification for later use by RESTORE-INPUT." 10 c,
    0 c,
  TAG info-4th "SCONSTANT"
    c" SCONSTANT 4TH" 10 c,
    c| Syntax: S"<space><string>"<space>SCONSTANT<space><name>| 10 c,
    c" Compiler: The previously compiled string address is taken as an" 10 c,
    c" argument for SCONSTANT. The instruction pointer is decremented," 10 c,
    c" actually deleting the string address." 10 c,
    c" A defining word used to create word <name>. When <name> is later" 10 c,
    c" executed, it will push the current address and the length of the" 10 c,
    c" string constant on the stack." 10 c,
    0 c,
  TAG info-4th "SCR"
    c" SCR BLOCK EXT" 10 c,
    c" Pronunciation: s-c-r" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: --- x" 10 c,
    c" x is the address of a cell containing the block number of the" 10 c,
    c" block most recently LISTed." 10 c,
    0 c,
  TAG info-4th "SEARCH"
    c" SEARCH STRING" 10 c,
    c" Include: search.4th" 10 c,
    c" Stack effects: addr1 n1 addr2 n2 --- addr3 n3 f" 10 c,
    c" Search the string specified by addr1 n1 for the string specified" 10 c,
    c" by addr2 n2 . If flag is true, a match was found at addr3 with n3" 10 c,
    c" characters remaining. If flag is false there was no match and" 10 c,
    c" addr3 is addr1 and n3 is n1." 10 c,
    0 c,
  TAG info-4th "SEEK"
    c" SEEK 4TH" 10 c,
    c" Compiles to: SEEK (0)" 10 c,
    c" Stack effects: n h --- f" 10 c,
    c" Reposition the file identified by handle h to n. If n is" 10 c,
    c" positive, TELL returns the value n. If n is negative, the file is" 10 c,
    c" repositioned relative to the end of the file. If n equals" 10 c,
    c" (ERROR), the file is repositioned to the end of the file. If the" 10 c,
    c" operation is successful, FALSE is returned, otherwise TRUE." 10 c,
    0 c,
  TAG info-4th "SET-PRECISION"
    c" SET-PRECISION FLOATING EXT" 10 c,
    c" Include: ansfloat.4th" 10 c,
    c" zenans.4th" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Floating: ---" 10 c,
    c" Set the number of significant digits currently used by F, FE, or" 10 c,
    c" FS to n." 10 c,
    0 c,
  TAG info-4th "SHIFT"
    c" SHIFT 4TH" 10 c,
    c" Compiles to: SHIFT (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Performs a logical bit shift on n1. Specifically, SHIFT shifts a" 10 c,
    c" number a number of bits, specified in n2, using a logical" 10 c,
    c" register shift." 10 c,
    0 c,
  TAG info-4th "SIGN"
    c" SIGN CORE" 10 c,
    c" Compiles to: SIGN (0)" 10 c,
    c" Stack effects: n1 n2 --- n2" 10 c,
    c" Stores an ASCII '-' sign just before the converted numeric output" 10 c,
    c" string in PAD when n1 is negative. n1 is discarded, but n2 is" 10 c,
    c" maintained. Must be used between <# and #>." 10 c,
    0 c,
  TAG info-4th "SM/REM"
    c" SM/REM CORE" 10 c,
    c" Pronunciation: s-m-slash-rem" 10 c,
    c" Include: mixed.4th" 10 c,
    c" Stack effects: d n1 --- n2 n3" 10 c,
    c" Divide d by n1, giving the symmetric quotient n3 and the" 10 c,
    c" remainder n2. Input and output stack arguments are signed. An" 10 c,
    c" ambiguous condition exists if n1 is zero or if the quotient lies" 10 c,
    c" outside the range of a single-cell signed integer." 10 c,
    0 c,
  TAG info-4th "SMOVE"
    c" SMOVE 4TH" 10 c,
    c" Compiles to: SMOVE (0)" 10 c,
    c" Stack effects: x1 x2 n ---" 10 c,
    c" Forth: Equivalent to:" 10 c,
    c" : SMOVE CELLS MOVE ;" 10 c,
    c" Move the specified quantity of cells (n) beginning at address x1" 10 c,
    c" to x2." 10 c,
    0 c,
  TAG info-4th "SOURCE"
    c" SOURCE CORE" 10 c,
    c" Compiles to: LITERAL (<address of TIB variable>)" 10 c,
    c" @ (0)" 10 c,
    c" LITERAL (<address of TIB-size variable>)" 10 c,
    c" @ (0)" 10 c,
    c" Stack effects: --- addr n" 10 c,
    c" addr is the address of, and n is the number of characters in, the" 10 c,
    c" currently used TIB." 10 c,
    0 c,
  TAG info-4th "SOURCE!"
    c" SOURCE! SOURCEFORGE" 10 c,
    c" Compiles to: LITERAL (<address of TIB-size variable>)" 10 c,
    c" ! (0)" 10 c,
    c" LITERAL (<address of TIB variable>)" 10 c,
    c" ! (0)" 10 c,
    c" Stack effects: addr n ---" 10 c,
    c" Forth: In Forth, >IN is set to zero. In 4tH this is left up to" 10 c,
    c" the application programmer." 10 c,
    c" Make the string described by c-addr and u the current input" 10 c,
    c" buffer. A program is allowed to refill the input buffer without" 10 c,
    c" restoring the original input source; upon a refill, the system" 10 c,
    c" shall accept the new portion of text to the current refill buffer" 10 c,
    c" and make it the input buffer." 10 c,
    0 c,
  TAG info-4th "SOURCE-ID"
    c" SOURCE-ID CORE EXT   FILE" 10 c,
    c" Pronunciation: source-i-d" 10 c,
    c" Compiles to: ENVIRON (<address of CIN>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Identifies the input source." 10 c,
    0 c,
  TAG info-4th "SP@"
    c" SP@ 4TH" 10 c,
    c" Compiles to: SP@ (0)" 10 c,
    c" Stack effects: --- sp" 10 c,
    c" Return the address sp of the stack position of the top of the" 10 c,
    c" stack as it was before SP@ was executed." 10 c,
    0 c,
  TAG info-4th "SPACE"
    c" SPACE CORE" 10 c,
    c" Compiles to: LITERAL (<ASCII value of space>)" 10 c,
    c" EMIT (0)" 10 c,
    c" Transmit an ASCII blank to the current output device." 10 c,
    0 c,
  TAG info-4th "SPACES"
    c" SPACES CORE" 10 c,
    c" Compiles to: SPACES (0)" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Transmit n ASCII blanks to the current output device." 10 c,
    0 c,
  TAG info-4th "SPAN"
    c" SPAN CORE EXT" 10 c,
    c" Include: obsolete.4th" 10 c,
    c" Stack effects: --- x" 10 c,
    c" X is the address of a cell containing the count of characters" 10 c,
    c" stored by the last execution of EXPECT (see EXPECT)." 10 c,
    0 c,
  TAG info-4th "STACK-CELLS"
    c" STACK-CELLS 4TH" 10 c,
    c" Compiles to: LITERAL (<number of integers>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Forth: Equivalent to:" 10 c,
    c| : STACK-CELLS S" STACK-CELLS" ENVIRONMENT? DROP ;| 10 c,
    c" Returns the number of integers that the Stack Area can contain." 10 c,
    c" Both stacks share the Stack Area." 10 c,
    0 c,
  TAG info-4th "STDIN"
    c" STDIN 4TH" 10 c,
    c" Compiles to: LITERAL (<address of stream>)" 10 c,
    c" Stack effects: --- h" 10 c,
    c" Leaves a filehandle on the stack associated with the standard" 10 c,
    c" keyboard input device. This stream cannot be closed." 10 c,
    0 c,
  TAG info-4th "STDOUT"
    c" STDOUT 4TH" 10 c,
    c" Compiles to: LITERAL (<address of stream>)" 10 c,
    c" Stack effects: --- h" 10 c,
    c" Leaves a filehandle on the stack associated with the standard" 10 c,
    c" screen output device. This stream cannot be closed." 10 c,
    0 c,
  TAG info-4th "STRING"
    c" STRING 4TH" 10 c,
    c" Syntax: <literal><space>STRING<space><name>" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for STRING. The instruction pointer is decremented, actually" 10 c,
    c" deleting the literal." 10 c,
    c" Forth: This word is 4tH specific. Roughly equivalent to:" 10 c,
    c" : STRING CREATE CHARS ALLOT ;" 10 c,
    c" Allocate <literal> characters of contiguous data space beginning" 10 c,
    c" at <name> in the Character Segment. The initial content of the" 10 c,
    c" allocated space is undefined." 10 c,
    0 c,
  TAG info-4th "STRUCT"
    c" STRUCT 4TH" 10 c,
    c" Compiles to: LITERAL (0)" 10 c,
    c" Syntax:" 10 c,
    c" STRUCT<space><literal><space>+FIELD<space><name><space>END-STRUCT<space><name>" 10 c,
    c" STRUCT<space><literal><space>/FIELD<space>END-STRUCT<space><name>" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Forth: Similar constructions are available in GForth. +FIELD is" 10 c,
    c" part of the Forth 200x draft." 10 c,
    c" A constant, which initiates a STRUCT definition (see: +FIELD," 10 c,
    c" /FIELD, END-STRUCT)." 10 c,
    0 c,
  TAG info-4th "SUBSTITUTE"
    c" SUBSTITUTE STRING EXT" 10 c,
    c" Include: substit.4th" 10 c,
    c" Stack effects: a1 n1 a2 n2 -- a2 n3 n4" 10 c,
    c" Perform substitution on the string at a1 and n1 placing the" 10 c,
    c" result at string a2 and n2, returning a2 and n3, the length of" 10 c,
    c" the resulting string. An ambiguous condition occurs if the" 10 c,
    c" resulting string will not fit into a2 n2 or if a2 is the same as" 10 c,
    c" a1. The return value n4 is positive (0..+n) on success and" 10 c,
    c" indicates the number of substitutions made. A negative value for" 10 c,
    c" n4 indicates that an error occurred, leaving a2 and n3 undefined." 10 c,
    c" Substitution occurs from the start of a1 and n1 in one pass and" 10 c,
    c" is non-recursive. When a substitution name surrounded by '%'" 10 c,
    c" delimiters is encountered by SUBSTITUTE, the following occurs:" 10 c,
    c" 1. If the name is null, a single delimiter character is" 10 c,
    c" substituted, i.e. %% is replaced by %." 10 c,
    c" 2. If the name is a valid substitution name, the leading and" 10 c,
    c" trailing delimiter characters and the enclosed substitution" 10 c,
    c" name are replaced by the substitution text." 10 c,
    c" 3. If the name is not a valid substitution name, the name with" 10 c,
    c" leading and trailing delimiters is passed unchanged to the" 10 c,
    c" output." 10 c,
    0 c,
  TAG info-4th "SWAP"
    c" SWAP CORE" 10 c,
    c" Compiles to: SWAP (0)" 10 c,
    c" Stack effects: n1 n2 --- n2 n1" 10 c,
    c" Exchange the top two values on the stack." 10 c,
    0 c,
  TAG info-4th "SYNC"
    c" SYNC 4TH" 10 c,
    c" Compiles to: SYNC (0)" 10 c,
    c" Stack effects: ---" 10 c,
    c" Attempt to force any buffered information written to the device" 10 c,
    c" referred to by the output channel to be written." 10 c,
    0 c,
  TAG info-4th "TABLE"
    c" TABLE 4TH" 10 c,
    c" Syntax: TABLE<space><name>" 10 c,
    c" Forth: Available in some Forths." 10 c,
    c" Leaves <name> in the symboltable and replace further occurences" 10 c,
    c" with LITERAL <xt>. <xt> represents the address in the Code" 10 c,
    c" Segment where TABLE was compiled. An alias for CREATE." 10 c,
    0 c,
  TAG info-4th "TAG"
    c" TAG 4TH" 10 c,
    c" Syntax: TAG<space><name1><space><name2>" 10 c,
    c" Forth: This word is 4tH specific. Roughly equivalent to:" 10 c,
    c" : TAG ' >BODY 1 CELLS - CREATE , DOES> DUP @ - ;" 10 c,
    c" Create a CONSTANT <name2> which contains the difference in" 10 c,
    c" characters between the current address of the String Segment and" 10 c,
    c" previously defined OFFSET <name1>. This constant can be used as" 10 c,
    c" an index to <name1> to retrieve any binary strings defined" 10 c,
    c" directly after the definition of <name2>." 10 c,
    0 c,
  TAG info-4th "TELL"
    c" TELL 4TH" 10 c,
    c" Compiles to: TELL (0)" 10 c,
    c" Stack effects: h --- n" 10 c,
    c" n is the current file position for the file identified by handle" 10 c,
    c" h." 10 c,
    0 c,
  TAG info-4th "TH"
    c" TH COMUS" 10 c,
    c" Compiles to: + (0)" 10 c,
    c" Stack effects: x1 n --- x2" 10 c,
    c" Forth: This word is not part of ANS-Forth or Forth-79, but can be" 10 c,
    c" found in other Forths. It can be very handy when porting 4tH" 10 c,
    c" programs. Just define TH as:" 10 c,
    c" : TH CELLS + ;" 10 c,
    c" When you're using a construction like:" 10 c,
    c" VAR 2 TH" 10 c,
    c" In both 4tH and Forth the third element will be referenced. The" 10 c,
    c" use of TH to reference an element of a string in the Character" 10 c,
    c" Segment is allowed in 4tH, but the resulting source cannot be" 10 c,
    c" ported to Forth." 10 c,
    c" Used to reference an element in an array of integers. Will return" 10 c,
    c" the address of the n-th element in array x1 as x2. An alias for" 10 c,
    c" +." 10 c,
    0 c,
  TAG info-4th "THEN"
    c" THEN CORE" 10 c,
    c" Syntax: IF<space>..<space>ELSE<space>..<space>THEN" 10 c,
    c" At runtime THEN serves only as the destination of a forward" 10 c,
    c" branch from IF or ELSE. It marks the conclusion of the" 10 c,
    c" conditional structure." 10 c,
    0 c,
  TAG info-4th "THROW"
    c" THROW EXCEPTION" 10 c,
    c" Compiles to: THROW (0)" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Forth: The values of THROW are not conforming the ANS-Forth" 10 c,
    c" standard." 10 c,
    c" If n is non-zero, pop the topmost exception frame from the return" 10 c,
    c" stack, along with everything beyond that frame. Then adjust the" 10 c,
    c" return- and datastacks so they are the same as the depths saved" 10 c,
    c" in the exception frame, put n on top of the data stack, and" 10 c,
    c" transfer control to a point just after the CATCH that pushed that" 10 c,
    c" exception frame (see: CATCH)." 10 c,
    0 c,
  TAG info-4th "TIB"
    c" TIB CORE EXT" 10 c,
    c" Pronunciation: t-i-b" 10 c,
    c" Compiles to: LITERAL (<address of Terminal Input Buffer>)" 10 c,
    c" Stack effects: --- addr" 10 c,
    c" Forth: In Forth this is a variable. However, it is unlikely" 10 c,
    c" you'll ever find a program which assigns another value to it." 10 c,
    c" A constant which leaves the address of the Terminal Input Buffer" 10 c,
    c" on the stack." 10 c,
    0 c,
  TAG info-4th "TIME"
    c" TIME 4TH" 10 c,
    c" Compiles to: TIME (0)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" Returns the number of seconds since January 1st, 1970." 10 c,
    0 c,
  TAG info-4th "TIME&DATE"
    c" TIME&DATE FACILITY" 10 c,
    c" Pronunciation: time-and-date" 10 c,
    c" Include: ansfacil.4th" 10 c,
    c" Stack effects: --- n1 n2 n3 n4 n5 n6" 10 c,
    c" Return the current time and date. n1 is the second {0...59}, n2" 10 c,
    c" is the minute {0...59}, n3 is the hour {0...23}, n4 is the day" 10 c,
    c" {1...31}, n5 is the month {1...12}, and n6 is the year (e.g.," 10 c,
    c" 1991)." 10 c,
    0 c,
  TAG info-4th "TO"
    c" TO CORE EXT" 10 c,
    c" Compiles to: TO (<variable address>)" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Syntax: TO<space><name>" 10 c,
    c" Store n in the value identified by name." 10 c,
    0 c,
  TAG info-4th "TRUE"
    c" TRUE CORE EXT" 10 c,
    c" Compiles to: LITERAL (<flag>)" 10 c,
    c" Stack effects: --- f" 10 c,
    c" Forth: In ANS-Forth TRUE is represented by a -1 value." 10 c,
    c" Returns a true flag on the stack." 10 c,
    0 c,
  TAG info-4th "TUCK"
    c" TUCK CORE EXT" 10 c,
    c" Compiles to: SWAP (0)" 10 c,
    c" OVER (0)" 10 c,
    c" Stack effects: n1 n2 --- n2 n1 n2 )" 10 c,
    c" Copy the first (top) stack item below the second stack item." 10 c,
    0 c,
  TAG info-4th "TYPE"
    c" TYPE CORE" 10 c,
    c" Compiles to: TYPE (0)" 10 c,
    c" Stack effects: addr n ---" 10 c,
    c" Transmit n characters from addr to the selected output device." 10 c,
    0 c,
  TAG info-4th "U."
    c" U. CORE" 10 c,
    c" Pronunciation: u-dot" 10 c,
    c" Include: dbldot.4th" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Display n in free field format as an unsigned number." 10 c,
    0 c,
  TAG info-4th "U.R"
    c" U.R CORE EXT" 10 c,
    c" Pronunciation: u-dot-r" 10 c,
    c" Include: dbldot.4th" 10 c,
    c" Stack effects: n1 n2 ---" 10 c,
    c" Display unsigned number n1 right aligned in a field n2 characters" 10 c,
    c" wide. If the number of characters required to display n1 is" 10 c,
    c" greater than n2, all digits are displayed with no leading spaces" 10 c,
    c" in a field as wide as necessary." 10 c,
    0 c,
  TAG info-4th "U<"
    c" U< CORE" 10 c,
    c" Pronunciation: u-less-than" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: n1 n2 --- f" 10 c,
    c" Flag f is true if and only if unsigned number n1 is less than" 10 c,
    c" unsigned number n2." 10 c,
    0 c,
  TAG info-4th "U>"
    c" U> CORE EXT" 10 c,
    c" Pronunciation: u-greater-than" 10 c,
    c" Include: ansdbl.4th" 10 c,
    c" Stack effects: n1 n2 --- f" 10 c,
    c" Flag f is true if and only if unsigned number n1 is greater than" 10 c,
    c" unsigned number n2." 10 c,
    0 c,
  TAG info-4th "UM*"
    c" UM* CORE" 10 c,
    c" Pronunciation: u-m-star" 10 c,
    c" Include: mixed.4th" 10 c,
    c" Stack effects: n1 n2 --- d" 10 c,
    c" Multiply n1 by n2, giving the unsigned double-cell product d. All" 10 c,
    c" values and arithmetic are unsigned." 10 c,
    0 c,
  TAG info-4th "UM/MOD"
    c" UM/MOD CORE" 10 c,
    c" Pronunciation: u-m-slash-mod" 10 c,
    c" Include: mixed.4th" 10 c,
    c" Stack effects: d n1 --- n2 n3" 10 c,
    c" Divide d by n1, giving the quotient n3 and the remainder n2. All" 10 c,
    c" values and arithmetic are unsigned. An ambiguous condition exists" 10 c,
    c" if n1 is zero or if the quotient lies outside the range of a" 10 c,
    c" single-cell unsigned integer." 10 c,
    0 c,
  TAG info-4th "UNESCAPE"
    c" UNESCAPE STRING EXT" 10 c,
    c" Include: substit.4th" 10 c,
    c" Stack effects: a1 n1 a2 -- a2 n2" 10 c,
    c" Replace each '%' character in the input string a1 n1 by two '%'" 10 c,
    c" characters. The output is represented by a2 n2. The buffer at a2" 10 c,
    c" must be big enough to hold the unescaped string." 10 c,
    0 c,
  TAG info-4th "UNLOOP"
    c" UNLOOP CORE" 10 c,
    c" Compiles to: R> (0)" 10 c,
    c" R> (0)" 10 c,
    c" DROP (0)" 10 c,
    c" DROP (0)" 10 c,
    c" Stack effects: ---" 10 c,
    c" Discard the loop-control parameters for the current nesting" 10 c,
    c" level. An UNLOOP is required for each nesting level before the" 10 c,
    c" definition may be EXITed." 10 c,
    0 c,
  TAG info-4th "UNTIL"
    c" UNTIL CORE" 10 c,
    c" Compiles to: 0BRANCH (<address of matching BEGIN>)" 10 c,
    c" Stack effects: f ---" 10 c,
    c" Syntax: BEGIN<space>..<space>WHILE<space>..<space>UNTIL" 10 c,
    c" Forth: The optional WHILE word is not supported." 10 c,
    c" At runtime UNTIL controls the conditional branch back to the" 10 c,
    c" corresponding BEGIN. If f is FALSE execution returns to just" 10 c,
    c" after BEGIN; if f is TRUE execution continues ahead." 10 c,
    0 c,
  TAG info-4th "UPDATE"
    c" UPDATE BLOCK" 10 c,
    c" Include: ansblock.4th" 10 c,
    c" multiblk.4th" 10 c,
    c" Stack effects: ---" 10 c,
    c" Mark the current block buffer as modified. An ambiguous condition" 10 c,
    c" exists if there is no current block buffer. UPDATE does not" 10 c,
    c" immediately cause I/O." 10 c,
    0 c,
  TAG info-4th "USE"
    c" USE 4TH" 10 c,
    c" Compiles to: USE (0)" 10 c,
    c" Stack effects: h ---" 10 c,
    c" USE will associate the stream identified by filehandle h with the" 10 c,
    c" appropriate input- or output-channel, depending on the file" 10 c,
    c" access method used when opening the stream (see: OPEN). No" 10 c,
    c" streams are closed." 10 c,
    0 c,
  TAG info-4th "VALUE"
    c" VALUE CORE EXT" 10 c,
    c" Compiles to: TO (<variable address>)" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Syntax: <literal><space>VALUE<space><name>" 10 c,
    c" Create a symboltable entry for the value name with an initial" 10 c,
    c" value n. At runtime, n will be placed on the stack. In 4tH it is" 10 c,
    c" an alias for TO." 10 c,
    0 c,
  TAG info-4th "VARIABLE"
    c" VARIABLE CORE" 10 c,
    c" Syntax: VARIABLE<space><name>" 10 c,
    c" A defining word used to create variable <name>. When <name> is" 10 c,
    c" later executed, it will push the address <var> on the stack, so" 10 c,
    c" that a fetch or store may access this location." 10 c,
    0 c,
  TAG info-4th "VARS"
    c" VARS 4TH" 10 c,
    c" Compiles to: VARS (0)" 10 c,
    c" Stack effects: --- x" 10 c,
    c" This word returns the begin of the variables area." 10 c,
    0 c,
  TAG info-4th "W/O"
    c" W/O FILE" 10 c,
    c" Pronunciation: w-o" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: --- fam" 10 c,
    c" fam is the implementation-defined value for selecting the write" 10 c,
    c" only file access method." 10 c,
    0 c,
  TAG info-4th "WHILE"
    c" WHILE CORE" 10 c,
    c" Compiles to: 0BRANCH (<address of matching REPEAT token>)" 10 c,
    c" Stack effects: f ---" 10 c,
    c" Syntax: BEGIN<space>..<space>WHILE<space>..<space>REPEAT" 10 c,
    c" BEGIN<space>..<space>WHILE<space>..<space>UNTIL" 10 c,
    c" Forth: Within a BEGIN .. REPEAT construct, multiple WHILEs may be" 10 c,
    c" used as well, but additional words are necessary to complete the" 10 c,
    c" construct." 10 c,
    c" At runtime, WHILE selects conditional execution based on number" 10 c,
    c" n. If f is TRUE, WHILE continues execution of the code thru to" 10 c,
    c" REPEAT, which branches back to BEGIN. If f is FALSE, execution" 10 c,
    c" skips to just after REPEAT, exiting the structure. Multiple" 10 c,
    c" WHILEs may be used." 10 c,
    0 c,
  TAG info-4th "WIDTH"
    c" WIDTH 4TH" 10 c,
    c" Compiles to: LITERAL (<number of characters>)" 10 c,
    c" Stack effects: --- n" 10 c,
    c" A constant which leaves the maximum number of characters, allowed" 10 c,
    c" in a <name> label." 10 c,
    0 c,
  TAG info-4th "WITHIN"
    c" WITHIN CORE EXT" 10 c,
    c" Include: range.4th" 10 c,
    c" Stack effects: n1 n2 n3 --- f" 10 c,
    c" Perform a comparison of a test value n1 with a lower limit n2 and" 10 c,
    c" an upper limit n3 , returning true if either (n2 < n3 and (n2 <=" 10 c,
    c" n1 and n1 < n3)) or (n2 > n3 and (n2 <= n1 or n1 < n3)) is true," 10 c,
    c" returning false otherwise." 10 c,
    0 c,
  TAG info-4th "WORD"
    c" WORD CORE" 10 c,
    c" Include: word.4th" 10 c,
    c" Stack effects: c --- addr" 10 c,
    c" Skip leading delimiters and parse characters delimited by c. Addr" 10 c,
    c" is the address of the parsed word. If the parse area was empty or" 10 c,
    c" contained no characters other than the delimiter, the resulting" 10 c,
    c" string has a zero length." 10 c,
    0 c,
  TAG info-4th "WRITE-FILE"
    c" WRITE-FILE FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: addr n h --- f" 10 c,
    c" Write n characters from addr to the file identified by handle h" 10 c,
    c" starting at its current position. Flag f is the" 10 c,
    c" implementation-defined I/O result code. At the conclusion of the" 10 c,
    c" operation, FILE-POSITION returns the next file position after the" 10 c,
    c" last character written to the file, and FILE-SIZE returns a value" 10 c,
    c" greater than or equal to the value returned by FILE-POSITION." 10 c,
    0 c,
  TAG info-4th "WRITE-LINE"
    c" WRITE-LINE FILE" 10 c,
    c" Include: ansfile.4th" 10 c,
    c" Stack effects: addr n h --- f" 10 c,
    c" Write n characters from addr followed by the" 10 c,
    c" implementation-dependent line terminator to the file identified" 10 c,
    c" by handle h starting at its current position. Flag f is the" 10 c,
    c" implementation-defined I/O result code. At the conclusion of the" 10 c,
    c" operation, FILE-POSITION returns the next file position after the" 10 c,
    c" last character written to the file, and FILE-SIZE returns a value" 10 c,
    c" greater than or equal to the value returned by FILE-POSITION." 10 c,
    0 c,
  TAG info-4th "X-SIZE"
    c" X-SIZE XCHAR" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: addr n1 --- n2" 10 c,
    c" n2 is the number of chars used to encode the first xchar stored" 10 c,
    c" in the string addr n1. To calculate the size of the xchar, only" 10 c,
    c" the bytes inside the buffer may be accessed. An ambiguous" 10 c,
    c" condition exists if the xchar is incomplete or malformed." 10 c,
    0 c,
  TAG info-4th "X-WIDTH"
    c" X-WIDTH XCHAR EXT" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: addr n1 --- n2" 10 c,
    c" n2 is the number of monospace ASCII characters that take the same" 10 c,
    c" space to display as the the xchar string addr n1; assuming a" 10 c,
    c" monospaced display font, i.e. xchar width is always an integer" 10 c,
    c" multiple of the width of an ASCII character." 10 c,
    0 c,
  TAG info-4th "X\STRING-"
    c" X\STRING- XCHAR EXT" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: addr n1 --- addr1 n2" 10 c,
    c" Search for the penultimate xchar in the string addr1 n1. The" 10 c,
    c" string addr1 n2 contains all xchars of addr n1, but the last." 10 c,
    c" Unlike XCHAR-, X\STRING- can be implemented in encodings where" 10 c,
    c" xchar boundaries can only reliably detected when scanning in" 10 c,
    c" forward direction." 10 c,
    0 c,
  TAG info-4th "XC-SIZE"
    c" XC-SIZE XCHAR" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: addr --- n" 10 c,
    c" n is the number of pchars used to encode xchar in memory." 10 c,
    0 c,
  TAG info-4th "XC-WIDTH"
    c" XC-WIDTH XCHAR EXT" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: n1 --- n2" 10 c,
    c" n2 is the number of monospace ASCII characters that take the same" 10 c,
    c" space to display as the xchar; i.e. xchar width is always an" 10 c,
    c" integer multiple of the width of an ASCII char." 10 c,
    0 c,
  TAG info-4th "XC@+"
    c" XC@+ XCHAR" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: addr1 --- addr2 n" 10 c,
    c" Fetches the xchar at addr1. addr2 points to the first memory" 10 c,
    c" location after the retrieved xchar." 10 c,
    0 c,
  TAG info-4th "XC!+"
    c" XC!+ XCHAR" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: n addr1 --- addr2" 10 c,
    c" Stores the xchar at addr1. addr2 points to the first memory" 10 c,
    c" location after the stored xchar." 10 c,
    0 c,
  TAG info-4th "XC!+?"
    c" XC!+? XCHAR" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: n1 addr1 n2 --- addr2 n3 f" 10 c,
    c" Stores the xchar into the string buffer specified by addr1 n2." 10 c,
    c" addr2 n3 is the remaining string buffer. If the xchar did fit" 10 c,
    c" into the buffer, flag is true, otherwise flag is false, and addr2" 10 c,
    c" n3 equal addr1 n2. XC!+? is safe for buffer overflows." 10 c,
    0 c,
  TAG info-4th "XCHAR+"
    c" XCHAR+ XCHAR" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: addr1 --- addr2" 10 c,
    c" Adds the size of the xchar stored at addr1 to this address," 10 c,
    c" giving addr2." 10 c,
    0 c,
  TAG info-4th "XCHAR-"
    c" XCHAR- XCHAR EXT" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: addr1 --- addr2" 10 c,
    c" Goes backward from addr1 until it finds an xchar so that the size" 10 c,
    c" of this xchar added to addr2 gives addr1. There is an ambiguous" 10 c,
    c" condition when the encoding doesn't permit reliable backward" 10 c,
    c" stepping through the text." 10 c,
    0 c,
  TAG info-4th "XEMIT"
    c" XEMIT XCHAR" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Prints an xchar on the terminal." 10 c,
    0 c,
  TAG info-4th "XHOLD"
    c" XHOLD XCHAR EXT" 10 c,
    c" Include: xchar.4th" 10 c,
    c" Stack effects: n ---" 10 c,
    c" Adds an xchar to the picture numeric output buffer." 10 c,
    0 c,
  TAG info-4th "XOR"
    c" XOR CORE" 10 c,
    c" Pronunciation: x-or" 10 c,
    c" Compiles to: XOR (0)" 10 c,
    c" Stack effects: n1 n2 --- n3" 10 c,
    c" Leave the bitwise logical XOR of n1 XOR n2 as n3." 10 c,
    0 c,
  TAG info-4th "[']"
    c" ['] CORE" 10 c,
    c" Pronunciation: bracket-tick" 10 c,
    c" Compiles to: LITERAL (<tok>)" 10 c,
    c" Syntax: [']<space><name>" 10 c,
    c" Stack effects: --- n | x | xt" 10 c,
    c" Forth: See '." 10 c,
    c" Compile the value contents of the symboltable entry identified as" 10 c,
    c" symbol <name> as a literal. An alias for '." 10 c,
    0 c,
  TAG info-4th "[:"
    c" [: COMP.LANG.FORTH" 10 c,
    c" Compiles to: LITERAL (<address of next BRANCH>)" 10 c,
    c" BRANCH (<address of matching ; token>)" 10 c,
    c" Syntax: [:<space>..<space>;]" 10 c,
    c" Stack effects: --- xt" 10 c,
    c" Forth: Several Forths support this word, e.g. gForth, iForth and" 10 c,
    c" VFX Forth." 10 c,
    c" Suspends compiling to the current definition (if any), starts a" 10 c,
    c" new nested definition, and compilation continues with this nested" 10 c,
    c" definition." 10 c,
    0 c,
  TAG info-4th "[=]"
    c" [=] 4TH" 10 c,
    c" Compiles to: LITERAL (<flag>)" 10 c,
    c" Syntax: <literal><space><literal><space>[=]" 10 c,
    c" Compiler: Two previously compiled literals are taken as arguments" 10 c,
    c" and a true flag is recompiled when they are equal. The" 10 c,
    c" instruction pointer is decremented, actually deleting the" 10 c,
    c" literals." 10 c,
    c" Stack effects: --- f" 10 c,
    c" Forth: Equivalent to =." 10 c,
    0 c,
  TAG info-4th "[ABORT]"
    c" [ABORT] 4TH" 10 c,
    c" Forth: Roughly equivalent to:" 10 c,
    c" [ ABORT ]" 10 c,
    c" Compilation is aborted immediately." 10 c,
    0 c,
  TAG info-4th "[ASSERT]"
    c" [ASSERT] 4TH" 10 c,
    c" Toggles assertions. Assertions are disabled by default (see:" 10 c,
    c" ASSERT( and ) )." 10 c,
    0 c,
  TAG info-4th "[BINARY]"
    c" [BINARY] 4TH" 10 c,
    c" Forth: Roughly equivalent to:" 10 c,
    c" [ 2 BASE ! ]" 10 c,
    c" When encountered during compilation it will set the radix to" 10 c,
    c" binary. All subsequent literals will be interpreted as binary" 10 c,
    c" numbers. Runtime behaviour will be controlled by HEX, OCTAL and" 10 c,
    c" DECIMAL." 10 c,
    0 c,
  TAG info-4th "[CHAR]"
    c" [CHAR] CORE" 10 c,
    c" Pronunciation: bracket-char" 10 c,
    c" Compiles to: LITERAL (<ASCII-value of character>)" 10 c,
    c" Syntax: [CHAR]<space><char>" 10 c,
    c" Stack effects: --- c" 10 c,
    c" Compiles the ASCII-value of <char> as a literal. At runtime the" 10 c,
    c" value is thrown on the stack. An alias for CHAR." 10 c,
    0 c,
  TAG info-4th "[DECIMAL]"
    c" [DECIMAL] 4TH" 10 c,
    c" Forth: Roughly equivalent to:" 10 c,
    c" [ DECIMAL ]" 10 c,
    c" When encountered during compilation it will set the radix to" 10 c,
    c" decimal. All subsequent literals will be interpreted as decimal" 10 c,
    c" numbers. Runtime behaviour will be controlled by HEX, OCTAL and" 10 c,
    c" DECIMAL." 10 c,
    0 c,
  TAG info-4th "[DEFINED]"
    c" [DEFINED] SEARCH EXT" 10 c,
    c" Compiles to: LITERAL (<flag>)" 10 c,
    c" Stack effects: --- f" 10 c,
    c" Syntax: [DEFINED]<space><name>" 10 c,
    c" If the name is defined, return TRUE, else return FALSE." 10 c,
    0 c,
  TAG info-4th "[ELSE]"
    c" [ELSE] TOOLS EXT" 10 c,
    c" Pronunciation: bracket-else" 10 c,
    c" Syntax:" 10 c,
    c" <literal><space>[IF]<space><word>..[ELSE]<space><word>..[THEN]" 10 c,
    c" Skipping leading spaces, parse and discard space-delimited words" 10 c,
    c" from the parse area, including nested occurrences of [IF] ..." 10 c,
    c" [THEN] and [IF] ... [ELSE] ... [THEN], until the word [THEN] has" 10 c,
    c" been parsed and discarded." 10 c,
    0 c,
  TAG info-4th "[FORCE]"
    c" [FORCE] 4TH" 10 c,
    c" Disables all optimization for the compilation of one single word." 10 c,
    0 c,
  TAG info-4th "[HEX]"
    c" [HEX] 4TH" 10 c,
    c" Forth: Roughly equivalent to:" 10 c,
    c" [ HEX ]" 10 c,
    c" When encountered during compilation it will set the radix to" 10 c,
    c" hexadecimal. All subsequent literals will be interpreted as" 10 c,
    c" hexadecimal numbers. Runtime behaviour will be controlled by HEX," 10 c,
    c" OCTAL and DECIMAL." 10 c,
    0 c,
  TAG info-4th "[IF]"
    c" [IF] TOOLS EXT" 10 c,
    c" Pronunciation: bracket-if" 10 c,
    c" Syntax:" 10 c,
    c" <literal><space>[IF]<space><word>..[ELSE]<space><word>..[THEN]" 10 c,
    c" Compiler: The previously compiled literal is taken as an argument" 10 c,
    c" for [IF]. The instruction pointer is decremented, actually" 10 c,
    c" deleting the literal." 10 c,
    c" Forth: Forth pops a value from the stack. This is not possible in" 10 c,
    c" 4tH." 10 c,
    c" If flag is true, do nothing. Otherwise, skipping leading spaces," 10 c,
    c" parse and discard space-delimited words from the parse area," 10 c,
    c" including nested occurrences of [IF] ... [THEN] and [IF] ..." 10 c,
    c" [ELSE] ... [THEN], until either the word [ELSE] or the word" 10 c,
    c" [THEN] has been parsed and discarded." 10 c,
    0 c,
  TAG info-4th "[IGNORE]"
    c" [IGNORE] 4TH" 10 c,
    c" Syntax: [IGNORE]<space><name>" 10 c,
    c" Compiler: The name is added to the symboltable. Subsequent" 10 c,
    c" occurrences of the name will be ignored." 10 c,
    c" Forth: Roughly equivalent to:" 10 c,
    c" : [ignore] create does> drop ;" 10 c,
    c" Recognize name, but do not perform any action or compile any code" 10 c,
    c" for it." 10 c,
    0 c,
  TAG info-4th "[MAX]"
    c" [MAX] 4TH" 10 c,
    c" Compiles to: LITERAL (<max>)" 10 c,
    c" Syntax: <literal><space><literal><space>[MAX]" 10 c,
    c" Compiler: Two previously compiled literals are taken as" 10 c,
    c" arguments, the larger one of the two is recompiled. The" 10 c,
    c" instruction pointer is decremented, actually deleting the" 10 c,
    c" literals." 10 c,
    c" Stack effects: --- n" 10 c,
    c" Forth: Equivalent to MAX." 10 c,
    0 c,
  TAG info-4th "[NEEDS"
    c" [NEEDS 4TH" 10 c,
    c" Syntax: [NEEDS<space><string>]" 10 c,
    c" Compiler: The contents of the file are inserted at this position." 10 c,
    c" Open the file specified by <string> and include its contents at" 10 c,
    c" the current position. When the end of the file is reached, close" 10 c,
    c" the file and continue compilation. An error condition exists if" 10 c,
    c" the named file can not be opened, if an I/O exception occurs" 10 c,
    c" reading the file, or if an I/O exception occurs while closing the" 10 c,
    c" file." 10 c,
    0 c,
  TAG info-4th "[NOT]"
    c" [NOT] 4TH" 10 c,
    c" Compiles to: LITERAL (<flag>)" 10 c,
    c" Syntax: <literal><space>[NOT]" 10 c,
    c" Compiler: A previously compiled literal is taken as an argument" 10 c,
    c" and a true flag is recompiled when it is equal to zero. The" 10 c,
    c" instruction pointer is decremented, actually deleting the" 10 c,
    c" literal." 10 c,
    c" Stack effects: --- f" 10 c,
    c" Forth: Equivalent to 0=." 10 c,
    0 c,
  TAG info-4th "[OCTAL]"
    c" [OCTAL] 4TH" 10 c,
    c" Forth: Roughly equivalent to:" 10 c,
    c" [ 8 BASE ! ]" 10 c,
    c" When encountered during compilation it will set the radix to" 10 c,
    c" octal. All subsequent literals will be interpreted as octal" 10 c,
    c" numbers. Runtime behaviour will be controlled by HEX, OCTAL and" 10 c,
    c" DECIMAL." 10 c,
    0 c,
  TAG info-4th "[PRAGMA]"
    c" [PRAGMA] 4TH" 10 c,
    c" Syntax: [PRAGMA]<space><name>" 10 c,
    c" A defining word used to create word <name>. When <name> is later" 10 c,
    c" executed, it will push the value TRUE on the stack. Intended to" 10 c,
    c" define pragmas for use in an include file." 10 c,
    c" [SIGN] 4TH" 10 c,
    c" Compiles to: LITERAL (<sign>)" 10 c,
    c" Syntax: <literal><space>[SIGN]" 10 c,
    c" Compiler: A previously compiled literal is taken as an argument," 10 c,
    c" and its sign recompiled. The instruction pointer is decremented," 10 c,
    c" actually deleting the literal." 10 c,
    c" Stack effects: --- -1|0|1" 10 c,
    c" Used to convert a previously compiled literal to a single value," 10 c,
    c" leaving only its sign." 10 c,
    0 c,
  TAG info-4th "[THEN]"
    c" [THEN] TOOLS EXT" 10 c,
    c" Pronunciation: bracket-then" 10 c,
    c" Does nothing. Acts as a marker for [IF] (see: [IF])." 10 c,
    0 c,
  TAG info-4th "[UNDEFINED]"
    c" [UNDEFINED] SEARCH EXT" 10 c,
    c" Compiles to: LITERAL (<flag>)" 10 c,
    c" Stack effects: --- f" 10 c,
    c" Syntax: [UNDEFINED]<space><name>" 10 c,
    c" If the name is defined, return FALSE, else return TRUE." 10 c,
    0 c,
  TAG info-4th "\"
    c" \ CORE EXT" 10 c,
    c" Pronunciation: backslash" 10 c,
    c" Syntax: \<space><string>" 10 c,
    c" The remainder of the line is discarded. Used for comment." 10 c,
    0 c,

create .info-4th
  ," \" "\" ,
  ," [UNDEFINED]" "[UNDEFINED]" ,
  ," [THEN]" "[THEN]" ,
  ," [PRAGMA]" "[PRAGMA]" ,
  ," [OCTAL]" "[OCTAL]" ,
  ," [NOT]" "[NOT]" ,
  ," [NEEDS" "[NEEDS" ,
  ," [MAX]" "[MAX]" ,
  ," [IGNORE]" "[IGNORE]" ,
  ," [IF]" "[IF]" ,
  ," [HEX]" "[HEX]" ,
  ," [FORCE]" "[FORCE]" ,
  ," [ELSE]" "[ELSE]" ,
  ," [DEFINED]" "[DEFINED]" ,
  ," [DECIMAL]" "[DECIMAL]" ,
  ," [CHAR]" "[CHAR]" ,
  ," [BINARY]" "[BINARY]" ,
  ," [ASSERT]" "[ASSERT]" ,
  ," [ABORT]" "[ABORT]" ,
  ," [=]" "[=]" ,
  ," [:" "[:" ,
  ," [']" "[']" ,
  ," XOR" "XOR" ,
  ," XHOLD" "XHOLD" ,
  ," XEMIT" "XEMIT" ,
  ," XCHAR-" "XCHAR-" ,
  ," XCHAR+" "XCHAR+" ,
  ," XC!+?" "XC!+?" ,
  ," XC!+" "XC!+" ,
  ," XC@+" "XC@+" ,
  ," XC-WIDTH" "XC-WIDTH" ,
  ," XC-SIZE" "XC-SIZE" ,
  ," X\STRING-" "X\STRING-" ,
  ," X-WIDTH" "X-WIDTH" ,
  ," X-SIZE" "X-SIZE" ,
  ," WRITE-LINE" "WRITE-LINE" ,
  ," WRITE-FILE" "WRITE-FILE" ,
  ," WORD" "WORD" ,
  ," WITHIN" "WITHIN" ,
  ," WIDTH" "WIDTH" ,
  ," WHILE" "WHILE" ,
  ," W/O" "W/O" ,
  ," VARS" "VARS" ,
  ," VARIABLE" "VARIABLE" ,
  ," VALUE" "VALUE" ,
  ," USE" "USE" ,
  ," UPDATE" "UPDATE" ,
  ," UNTIL" "UNTIL" ,
  ," UNLOOP" "UNLOOP" ,
  ," UNESCAPE" "UNESCAPE" ,
  ," UM/MOD" "UM/MOD" ,
  ," UM*" "UM*" ,
  ," U>" "U>" ,
  ," U<" "U<" ,
  ," U.R" "U.R" ,
  ," U." "U." ,
  ," TYPE" "TYPE" ,
  ," TUCK" "TUCK" ,
  ," TRUE" "TRUE" ,
  ," TO" "TO" ,
  ," TIME&DATE" "TIME&DATE" ,
  ," TIME" "TIME" ,
  ," TIB" "TIB" ,
  ," THROW" "THROW" ,
  ," THEN" "THEN" ,
  ," TH" "TH" ,
  ," TELL" "TELL" ,
  ," TAG" "TAG" ,
  ," TABLE" "TABLE" ,
  ," SYNC" "SYNC" ,
  ," SWAP" "SWAP" ,
  ," SUBSTITUTE" "SUBSTITUTE" ,
  ," STRUCT" "STRUCT" ,
  ," STRING" "STRING" ,
  ," STDOUT" "STDOUT" ,
  ," STDIN" "STDIN" ,
  ," STACK-CELLS" "STACK-CELLS" ,
  ," SPAN" "SPAN" ,
  ," SPACES" "SPACES" ,
  ," SPACE" "SPACE" ,
  ," SP@" "SP@" ,
  ," SOURCE-ID" "SOURCE-ID" ,
  ," SOURCE!" "SOURCE!" ,
  ," SOURCE" "SOURCE" ,
  ," SMOVE" "SMOVE" ,
  ," SM/REM" "SM/REM" ,
  ," SIGN" "SIGN" ,
  ," SHIFT" "SHIFT" ,
  ," SET-PRECISION" "SET-PRECISION" ,
  ," SEEK" "SEEK" ,
  ," SEARCH" "SEARCH" ,
  ," SCR" "SCR" ,
  ," SCONSTANT" "SCONSTANT" ,
  ," SAVE-INPUT" "SAVE-INPUT" ,
  ," SAVE-BUFFERS" "SAVE-BUFFERS" ,
  ," S|" "S|" ,
  ," S>F" "S>F" ,
  ," S>D" "S>D" ,
  ,| S"| |S"| ,
  ," RSHIFT" "RSHIFT" ,
  ," RP@" "RP@" ,
  ," ROT" "ROT" ,
  ," ROLL" "ROLL" ,
  ," REWIND" "REWIND" ,
  ," RESTORE-INPUT" "RESTORE-INPUT" ,
  ," RESIZE" "RESIZE" ,
  ," REPRESENT" "REPRESENT" ,
  ," REPOSITION-FILE" "REPOSITION-FILE" ,
  ," REPLACES" "REPLACES" ,
  ," REPEAT" "REPEAT" ,
  ," RENAME-FILE" "RENAME-FILE" ,
  ," REFILL" "REFILL" ,
  ," RECURSE" "RECURSE" ,
  ," READ-LINE" "READ-LINE" ,
  ," READ-FILE" "READ-FILE" ,
  ," R@" "R@" ,
  ," R/W" "R/W" ,
  ," R/O" "R/O" ,
  ," R'@" "R'@" ,
  ," R>" "R>" ,
  ," QUIT" "QUIT" ,
  ," QUERY" "QUERY" ,
  ," PRECISION" "PRECISION" ,
  ," PLACE" "PLACE" ,
  ," PIPE" "PIPE" ,
  ," PICK" "PICK" ,
  ," PAUSE" "PAUSE" ,
  ," PARSE-WORD" "PARSE-WORD" ,
  ," PARSE" "PARSE" ,
  ," PAD" "PAD" ,
  ," OVER" "OVER" ,
  ," OUTPUT" "OUTPUT" ,
  ," OUT" "OUT" ,
  ," OR" "OR" ,
  ," OPEN-FILE" "OPEN-FILE" ,
  ," OPEN-BLOCKFILE" "OPEN-BLOCKFILE" ,
  ," OPEN" "OPEN" ,
  ," OMIT" "OMIT" ,
  ," OFFSET" "OFFSET" ,
  ," OCTAL" "OCTAL" ,
  ," NUMBER" "NUMBER" ,
  ," NR>" "NR>" ,
  ," NOT" "NOT" ,
  ," NIP" "NIP" ,
  ," NEGATE" "NEGATE" ,
  ," N>R" "N>R" ,
  ," MS" "MS" ,
  ," MOVE" "MOVE" ,
  ," MOD" "MOD" ,
  ," MIN" "MIN" ,
  ," MAX-N" "MAX-N" ,
  ," MAX" "MAX" ,
  ," M+" "M+" ,
  ," M*/" "M*/" ,
  ," M*" "M*" ,
  ," LSHIFT" "LSHIFT" ,
  ," LOOP" "LOOP" ,
  ," LOAD" "LOAD" ,
  ," LO" "LO" ,
  ," LIST" "LIST" ,
  ," LEAVE" "LEAVE" ,
  ," LATEST" "LATEST" ,
  ," LAST" "LAST" ,
  ," KEY?" "KEY?" ,
  ," KEY" "KEY" ,
  ," J" "J" ,
  ," IS" "IS" ,
  ," INVERT" "INVERT" ,
  ," INPUT" "INPUT" ,
  ," INCLUDE" "INCLUDE" ,
  ," IMMEDIATE" "IMMEDIATE" ,
  ," IF" "IF" ,
  ," I" "I" ,
  ," HOLDS" "HOLDS" ,
  ," HOLD" "HOLD" ,
  ," HIDE" "HIDE" ,
  ," HI" "HI" ,
  ," HEX" "HEX" ,
  ," HERE" "HERE" ,
  ," F~" "F~" ,
  ," FTANH" "FTANH" ,
  ," FTAN" "FTAN" ,
  ," FSWAP" "FSWAP" ,
  ," FSQRT" "FSQRT" ,
  ," FSINH" "FSINH" ,
  ," FSINCOS" "FSINCOS" ,
  ," FSIN" "FSIN" ,
  ," FS." "FS." ,
  ," FROUND" "FROUND" ,
  ," FROT" "FROT" ,
  ," FREE" "FREE" ,
  ," FOVER" "FOVER" ,
  ," FNEGATE" "FNEGATE" ,
  ," FMIN" "FMIN" ,
  ," FMAX" "FMAX" ,
  ," FM/MOD" "FM/MOD" ,
  ," FLUSH-FILE" "FLUSH-FILE" ,
  ," FLUSH" "FLUSH" ,
  ," FLOOR" "FLOOR" ,
  ," FLOG" "FLOG" ,
  ," FLOATS" "FLOATS" ,
  ," FLOAT+" "FLOAT+" ,
  ," FLNP1" "FLNP1" ,
  ," FLN" "FLN" ,
  ," FIRST" "FIRST" ,
  ," FILL" "FILL" ,
  ," FILES" "FILES" ,
  ," FILE-STATUS" "FILE-STATUS" ,
  ," FILE-SIZE" "FILE-SIZE" ,
  ," FILE-POSITION" "FILE-POSITION" ,
  ," FILE" "FILE" ,
  ," FIELD:" "FIELD:" ,
  ," FEXPM1" "FEXPM1" ,
  ," FEXP" "FEXP" ,
  ," FE." "FE." ,
  ," FDUP" "FDUP" ,
  ," FDROP" "FDROP" ,
  ," FDEPTH" "FDEPTH" ,
  ," FCOSH" "FCOSH" ,
  ," FCOS" "FCOS" ,
  ," FATANH" "FATANH" ,
  ," FATAN2" "FATAN2" ,
  ," FATAN" "FATAN" ,
  ," FASINH" "FASINH" ,
  ," FASIN" "FASIN" ,
  ," FALSE" "FALSE" ,
  ," FALOG" "FALOG" ,
  ," FALIGNED" "FALIGNED" ,
  ," FALIGN" "FALIGN" ,
  ," FACOSH" "FACOSH" ,
  ," FACOS" "FACOS" ,
  ," FABS" "FABS" ,
  ," F@" "F@" ,
  ," F>S" "F>S" ,
  ," F>D" "F>D" ,
  ," F<" "F<" ,
  ," F0=" "F0=" ,
  ," F0<" "F0<" ,
  ," F/" "F/" ,
  ," F." "F." ,
  ," F-" "F-" ,
  ," F+" "F+" ,
  ," F**" "F**" ,
  ," F*" "F*" ,
  ," F!" "F!" ,
  ," EXPECT" "EXPECT" ,
  ," EXIT" "EXIT" ,
  ," EXECUTE" "EXECUTE" ,
  ," EVALUATE" "EVALUATE" ,
  ," ERROR?" "ERROR?" ,
  ," ERASE" "ERASE" ,
  ," EQUATES" "EQUATES" ,
  ," ENVIRONMENT?" "ENVIRONMENT?" ,
  ," ENVIRON@" "ENVIRON@" ,
  ," ENUM" "ENUM" ,
  ," END-STRUCT" "END-STRUCT" ,
  ," EMPTY-BUFFERS" "EMPTY-BUFFERS" ,
  ," EMIT" "EMIT" ,
  ," ELSE" "ELSE" ,
  ," DUP" "DUP" ,
  ," DUMP" "DUMP" ,
  ," DU<" "DU<" ,
  ," DROP" "DROP" ,
  ," DONE" "DONE" ,
  ," DOES>" "DOES>" ,
  ," DO" "DO" ,
  ," DNEGATE" "DNEGATE" ,
  ," DMIN" "DMIN" ,
  ," DMAX" "DMAX" ,
  ," DEPTH" "DEPTH" ,
  ," DELETE-FILE" "DELETE-FILE" ,
  ," DEFER@" "DEFER@" ,
  ," DEFER!" "DEFER!" ,
  ," DEFER" "DEFER" ,
  ," DECIMAL" "DECIMAL" ,
  ," DABS" "DABS" ,
  ," D>S" "D>S" ,
  ," D>F" "D>F" ,
  ," D=" "D=" ,
  ," D<" "D<" ,
  ," D2/" "D2/" ,
  ," D2*" "D2*" ,
  ," D0=" "D0=" ,
  ," D0<" "D0<" ,
  ," D.R" "D.R" ,
  ," D." "D." ,
  ," D-" "D-" ,
  ," D+" "D+" ,
  ," C|" "C|" ,
  ," CREATE-FILE" "CREATE-FILE" ,
  ," CREATE-BLOCKFILE" "CREATE-BLOCKFILE" ,
  ," CREATE" "CREATE" ,
  ," CR" "CR" ,
  ," COUT" "COUT" ,
  ," COUNT" "COUNT" ,
  ," CONSTANT" "CONSTANT" ,
  ," COMPARE" "COMPARE" ,
  ," CMOVE>" "CMOVE>" ,
  ," CMOVE" "CMOVE" ,
  ," CLOSE-FILE" "CLOSE-FILE" ,
  ," CLOSE-BLOCKFILE" "CLOSE-BLOCKFILE" ,
  ," CLOSE" "CLOSE" ,
  ," CIN" "CIN" ,
  ," CHOP" "CHOP" ,
  ," CHARS" "CHARS" ,
  ," CHAR-" "CHAR-" ,
  ," CHAR+" "CHAR+" ,
  ," CHAR" "CHAR" ,
  ," CFIELD:" "CFIELD:" ,
  ," CELLS" "CELLS" ,
  ," CELL-" "CELL-" ,
  ," CELL+" "CELL+" ,
  ," CATCH" "CATCH" ,
  ," C@" "C@" ,
  ," C," "C," ,
  ,| C"| |C"| ,
  ," C!" "C!" ,
  ," BUFFER:" "BUFFER:" ,
  ," BUFFER" "BUFFER" ,
  ," BOUNDS" "BOUNDS" ,
  ," BLOCK" "BLOCK" ,
  ," BLK" "BLK" ,
  ," BLANK" "BLANK" ,
  ," BL" "BL" ,
  ," BIN" "BIN" ,
  ," B/BUF" "B/BUF" ,
  ," BEGIN" "BEGIN" ,
  ," BASE" "BASE" ,
  ," ASSERT(" "ASSERT(" ,
  ," ARRAY" "ARRAY" ,
  ," ARGS" "ARGS" ,
  ," ARGN" "ARGN" ,
  ," APPEND" "APPEND" ,
  ," APP" "APP" ,
  ," AND" "AND" ,
  ," ALLOCATE" "ALLOCATE" ,
  ," ALIGNED" "ALIGNED" ,
  ," ALIGN" "ALIGN" ,
  ," ALIAS" "ALIAS" ,
  ," AKA" "AKA" ,
  ," AGAIN" "AGAIN" ,
  ," ACCEPT" "ACCEPT" ,
  ," ABS" "ABS" ,
  ,| ABORT"| |ABORT"| ,
  ," ABORT" "ABORT" ,
  ," @GOTO" "@GOTO" ,
  ," @C" "@C" ,
  ," @" "@" ,
  ," ?DUP" "?DUP" ,
  ," ?DO" "?DO" ,
  ," ?" "?" ,
  ," >STRING" ">STRING" ,
  ," >R" ">R" ,
  ," >NUMBER" ">NUMBER" ,
  ," >IN" ">IN" ,
  ," >FLOAT" ">FLOAT" ,
  ," >BODY" ">BODY" ,
  ," >=" ">=" ,
  ," >" ">" ,
  ," =" "=" ,
  ," <=" "<=" ,
  ," <>" "<>" ,
  ," <#" "<#" ,
  ," <" "<" ,
  ," ;]" ";]" ,
  ," ;" ";" ,
  ," :TOKEN" ":TOKEN" ,
  ," :REDO" ":REDO" ,
  ," :NONAME" ":NONAME" ,
  ," :" ":" ,
  ," 4TH#" "4TH#" ,
  ," 2SWAP" "2SWAP" ,
  ," 2ROT" "2ROT" ,
  ," 2R@" "2R@" ,
  ," 2R>" "2R>" ,
  ," 2OVER" "2OVER" ,
  ," 2NIP" "2NIP" ,
  ," 2DUP" "2DUP" ,
  ," 2DROP" "2DROP" ,
  ," 2@" "2@" ,
  ," 2>R" "2>R" ,
  ," 2/" "2/" ,
  ," 2*" "2*" ,
  ," 2!" "2!" ,
  ," 1-" "1-" ,
  ," 1+" "1+" ,
  ," 0>" "0>" ,
  ," 0=" "0=" ,
  ," 0<>" "0<>" ,
  ," 0<" "0<" ,
  ," /TIB" "/TIB" ,
  ," /STRING" "/STRING" ,
  ," /PAD" "/PAD" ,
  ," /MOD" "/MOD" ,
  ," /FIELD" "/FIELD" ,
  ," /CONSTANT" "/CONSTANT" ,
  ," /CHAR" "/CHAR" ,
  ," /CELL" "/CELL" ,
  ," /" "/" ,
  ," .|" ".|" ,
  ," .S" ".S" ,
  ," .R" ".R" ,
  ," .(" ".(" ,
  ,| ."| |."| ,
  ," -TRAILING-GARBAGE" "-TRAILING-GARBAGE" ,
  ," -TRAILING" "-TRAILING" ,
  ," -ROT" "-ROT" ,
  ," ->" "->" ,
  ," -" "-" ,
  ," ,|" ",|" ,
  ,| ,"| |,"| ,
  ," ," "," ,
  ," +X/STRING" "+X/STRING" ,
  ," +PLACE" "+PLACE" ,
  ," +LOOP" "+LOOP" ,
  ," +FIELD" "+FIELD" ,
  ," +CONSTANT" "+CONSTANT" ,
  ," +!" "+!" ,
  ," +" "+" ,
  ," *CONSTANT" "*CONSTANT" ,
  ," */MOD" "*/MOD" ,
  ," */" "*/" ,
  ," *" "*" ,
  ," )" ")" ,
  ," (ERROR)" "(ERROR)" ,
  ," (" "(" ,
  ," '" "'" ,
  ," #TIB" "#TIB" ,
  ," #S" "#S" ,
  ," #>" "#>" ,
  ," #!" "#!" ,
  ," #" "#" ,
  ," !" "!" ,
  NULL ,
does> [: info-4th ;] is info-entry info ;

argn 2 < abort" Usage: info-4th keyword"
1 args search-key place search-key count .info-4th
