/*
	Software License Agreement (BSD License)
	
	Copyright (c) 1997-2008, David Lindauer, (LADSoft).
	All rights reserved.
	
	Redistribution and use of this software in source and binary forms, with or without modification, are
	permitted provided that the following conditions are met:
	
	* Redistributions of source code must retain the above
	  copyright notice, this list of conditions and the
	  following disclaimer.
	
	* Redistributions in binary form must reproduce the above
	  copyright notice, this list of conditions and the
	  following disclaimer in the documentation and/or other
	  materials provided with the distribution.
	
	* Neither the name of LADSoft nor the names of its
	  contributors may be used to endorse or promote products
	  derived from this software without specific prior
	  written permission of LADSoft.
	
	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
	WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
	ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

#define MAX_ATEXIT 32

extern int _RTL_DATA _abterm;

static int atexitval = 0;
static void (*funclist[MAX_ATEXIT])(void);

static struct _onx_l {
	struct _onx_l *next;
	onexit_t func;
} *onx_list;

#pragma rundown __procexit 225

void __procexit(void)
{
	int i;
   __ll_enter_critical() ;
	if (!_abterm)
	{
		for (i=atexitval; i >0; i--)
			(*funclist[i-1])();
		while (onx_list)
		{
			(*onx_list->func)();
			onx_list = onx_list->next;
		}
	}
   __ll_exit_critical() ;
}

int _RTL_FUNC atexit(atexit_t func)
{
   __ll_enter_critical() ;
	if (atexitval < MAX_ATEXIT) {
		funclist[atexitval++] = func;
      __ll_exit_critical() ;
	  return 0;
	}
  __ll_exit_critical() ;
  return -1;
}
onexit_t _RTL_FUNC onexit(onexit_t func)
{
	struct _onx_l *l = malloc(sizeof(struct _onx_l));
	if (!l)
		return NULL;
   __ll_enter_critical() ;
   l->next = onx_list;
   onx_list = l;
   l->func = func;
  __ll_exit_critical() ;
  return func;
}
_onexit_t _RTL_FUNC _onexit(_onexit_t func)
{
	return onexit(func);
}
