#pragma once

#include once "guiddef.bi"

#define _NTDDNDIS_
#define DD_NDIS_DEVICE_NAME !"\\Device\\UNKNOWN"
#define _NDIS_CONTROL_CODE(request, method) CTL_CODE(FILE_DEVICE_PHYSICAL_NETCARD, request, method, FILE_ANY_ACCESS)
#define IOCTL_NDIS_QUERY_GLOBAL_STATS _NDIS_CONTROL_CODE(0, METHOD_OUT_DIRECT)
#define IOCTL_NDIS_QUERY_ALL_STATS _NDIS_CONTROL_CODE(1, METHOD_OUT_DIRECT)
#define IOCTL_NDIS_DO_PNP_OPERATION _NDIS_CONTROL_CODE(2, METHOD_BUFFERED)
#define IOCTL_NDIS_QUERY_SELECTED_STATS _NDIS_CONTROL_CODE(3, METHOD_OUT_DIRECT)
#define IOCTL_NDIS_ENUMERATE_INTERFACES _NDIS_CONTROL_CODE(4, METHOD_BUFFERED)
#define IOCTL_NDIS_ADD_TDI_DEVICE _NDIS_CONTROL_CODE(5, METHOD_BUFFERED)
#define IOCTL_NDIS_GET_LOG_DATA _NDIS_CONTROL_CODE(7, METHOD_OUT_DIRECT)
#define IOCTL_NDIS_GET_VERSION _NDIS_CONTROL_CODE(8, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED7 _NDIS_CONTROL_CODE(&hF, METHOD_OUT_DIRECT)
type NDIS_OID as ULONG
type PNDIS_OID as ULONG ptr

type _NDIS_STATISTICS_VALUE
	Oid as NDIS_OID
	DataLength as ULONG
	Data(0 to 0) as UCHAR
end type

type NDIS_STATISTICS_VALUE as _NDIS_STATISTICS_VALUE
type PNDIS_STATISTICS_VALUE as _NDIS_STATISTICS_VALUE ptr

type _NDIS_VAR_DATA_DESC
	Length as USHORT
	MaximumLength as USHORT
	Offset as ULONG_PTR
end type

type NDIS_VAR_DATA_DESC as _NDIS_VAR_DATA_DESC
type PNDIS_VAR_DATA_DESC as _NDIS_VAR_DATA_DESC ptr

type _NDIS_OBJECT_HEADER
	as UCHAR Type
	Revision as UCHAR
	Size as USHORT
end type

type NDIS_OBJECT_HEADER as _NDIS_OBJECT_HEADER
type PNDIS_OBJECT_HEADER as _NDIS_OBJECT_HEADER ptr
const OID_GEN_SUPPORTED_LIST = &h00010101
const OID_GEN_HARDWARE_STATUS = &h00010102
const OID_GEN_MEDIA_SUPPORTED = &h00010103
const OID_GEN_MEDIA_IN_USE = &h00010104
const OID_GEN_MAXIMUM_LOOKAHEAD = &h00010105
const OID_GEN_MAXIMUM_FRAME_SIZE = &h00010106
const OID_GEN_LINK_SPEED = &h00010107
const OID_GEN_TRANSMIT_BUFFER_SPACE = &h00010108
const OID_GEN_RECEIVE_BUFFER_SPACE = &h00010109
const OID_GEN_TRANSMIT_BLOCK_SIZE = &h0001010A
const OID_GEN_RECEIVE_BLOCK_SIZE = &h0001010B
const OID_GEN_VENDOR_ID = &h0001010C
const OID_GEN_VENDOR_DESCRIPTION = &h0001010D
const OID_GEN_CURRENT_PACKET_FILTER = &h0001010E
const OID_GEN_CURRENT_LOOKAHEAD = &h0001010F
const OID_GEN_DRIVER_VERSION = &h00010110
const OID_GEN_MAXIMUM_TOTAL_SIZE = &h00010111
const OID_GEN_PROTOCOL_OPTIONS = &h00010112
const OID_GEN_MAC_OPTIONS = &h00010113
const OID_GEN_MEDIA_CONNECT_STATUS = &h00010114
const OID_GEN_MAXIMUM_SEND_PACKETS = &h00010115
const OID_GEN_VENDOR_DRIVER_VERSION = &h00010116
const OID_GEN_SUPPORTED_GUIDS = &h00010117
const OID_GEN_NETWORK_LAYER_ADDRESSES = &h00010118
const OID_GEN_TRANSPORT_HEADER_OFFSET = &h00010119
const OID_GEN_MACHINE_NAME = &h0001021A
const OID_GEN_RNDIS_CONFIG_PARAMETER = &h0001021B
const OID_GEN_VLAN_ID = &h0001021C
const OID_GEN_MEDIA_CAPABILITIES = &h00010201
const OID_GEN_PHYSICAL_MEDIUM = &h00010202
const OID_GEN_XMIT_OK = &h00020101
const OID_GEN_RCV_OK = &h00020102
const OID_GEN_XMIT_ERROR = &h00020103
const OID_GEN_RCV_ERROR = &h00020104
const OID_GEN_RCV_NO_BUFFER = &h00020105
const OID_GEN_DIRECTED_BYTES_XMIT = &h00020201
const OID_GEN_DIRECTED_FRAMES_XMIT = &h00020202
const OID_GEN_MULTICAST_BYTES_XMIT = &h00020203
const OID_GEN_MULTICAST_FRAMES_XMIT = &h00020204
const OID_GEN_BROADCAST_BYTES_XMIT = &h00020205
const OID_GEN_BROADCAST_FRAMES_XMIT = &h00020206
const OID_GEN_DIRECTED_BYTES_RCV = &h00020207
const OID_GEN_DIRECTED_FRAMES_RCV = &h00020208
const OID_GEN_MULTICAST_BYTES_RCV = &h00020209
const OID_GEN_MULTICAST_FRAMES_RCV = &h0002020A
const OID_GEN_BROADCAST_BYTES_RCV = &h0002020B
const OID_GEN_BROADCAST_FRAMES_RCV = &h0002020C
const OID_GEN_RCV_CRC_ERROR = &h0002020D
const OID_GEN_TRANSMIT_QUEUE_LENGTH = &h0002020E
const OID_GEN_GET_TIME_CAPS = &h0002020F
const OID_GEN_GET_NETCARD_TIME = &h00020210
const OID_GEN_NETCARD_LOAD = &h00020211
const OID_GEN_DEVICE_PROFILE = &h00020212
const OID_GEN_INIT_TIME_MS = &h00020213
const OID_GEN_RESET_COUNTS = &h00020214
const OID_GEN_MEDIA_SENSE_COUNTS = &h00020215
const OID_GEN_FRIENDLY_NAME = &h00020216
const OID_GEN_MINIPORT_INFO = &h00020217
const OID_GEN_RESET_VERIFY_PARAMETERS = &h00020218
#define OID_GEN_CO_SUPPORTED_LIST OID_GEN_SUPPORTED_LIST
#define OID_GEN_CO_HARDWARE_STATUS OID_GEN_HARDWARE_STATUS
#define OID_GEN_CO_MEDIA_SUPPORTED OID_GEN_MEDIA_SUPPORTED
#define OID_GEN_CO_MEDIA_IN_USE OID_GEN_MEDIA_IN_USE
#define OID_GEN_CO_LINK_SPEED OID_GEN_LINK_SPEED
#define OID_GEN_CO_VENDOR_ID OID_GEN_VENDOR_ID
#define OID_GEN_CO_VENDOR_DESCRIPTION OID_GEN_VENDOR_DESCRIPTION
#define OID_GEN_CO_DRIVER_VERSION OID_GEN_DRIVER_VERSION
#define OID_GEN_CO_PROTOCOL_OPTIONS OID_GEN_PROTOCOL_OPTIONS
#define OID_GEN_CO_MAC_OPTIONS OID_GEN_MAC_OPTIONS
#define OID_GEN_CO_MEDIA_CONNECT_STATUS OID_GEN_MEDIA_CONNECT_STATUS
#define OID_GEN_CO_VENDOR_DRIVER_VERSION OID_GEN_VENDOR_DRIVER_VERSION
#define OID_GEN_CO_SUPPORTED_GUIDS OID_GEN_SUPPORTED_GUIDS
#define OID_GEN_CO_GET_TIME_CAPS OID_GEN_GET_TIME_CAPS
#define OID_GEN_CO_GET_NETCARD_TIME OID_GEN_GET_NETCARD_TIME
const OID_GEN_CO_MINIMUM_LINK_SPEED = &h00020120
#define OID_GEN_CO_XMIT_PDUS_OK OID_GEN_XMIT_OK
#define OID_GEN_CO_RCV_PDUS_OK OID_GEN_RCV_OK
#define OID_GEN_CO_XMIT_PDUS_ERROR OID_GEN_XMIT_ERROR
#define OID_GEN_CO_RCV_PDUS_ERROR OID_GEN_RCV_ERROR
#define OID_GEN_CO_RCV_PDUS_NO_BUFFER OID_GEN_RCV_NO_BUFFER
#define OID_GEN_CO_RCV_CRC_ERROR OID_GEN_RCV_CRC_ERROR
#define OID_GEN_CO_TRANSMIT_QUEUE_LENGTH OID_GEN_TRANSMIT_QUEUE_LENGTH
#define OID_GEN_CO_BYTES_XMIT OID_GEN_DIRECTED_BYTES_XMIT
#define OID_GEN_CO_BYTES_RCV OID_GEN_DIRECTED_BYTES_RCV
#define OID_GEN_CO_NETCARD_LOAD OID_GEN_NETCARD_LOAD
#define OID_GEN_CO_DEVICE_PROFILE OID_GEN_DEVICE_PROFILE
const OID_GEN_CO_BYTES_XMIT_OUTSTANDING = &h00020221
const OID_802_3_PERMANENT_ADDRESS = &h01010101
const OID_802_3_CURRENT_ADDRESS = &h01010102
const OID_802_3_MULTICAST_LIST = &h01010103
const OID_802_3_MAXIMUM_LIST_SIZE = &h01010104
const OID_802_3_MAC_OPTIONS = &h01010105
const NDIS_802_3_MAC_OPTION_PRIORITY = &h00000001
const OID_802_3_RCV_ERROR_ALIGNMENT = &h01020101
const OID_802_3_XMIT_ONE_COLLISION = &h01020102
const OID_802_3_XMIT_MORE_COLLISIONS = &h01020103
const OID_802_3_XMIT_DEFERRED = &h01020201
const OID_802_3_XMIT_MAX_COLLISIONS = &h01020202
const OID_802_3_RCV_OVERRUN = &h01020203
const OID_802_3_XMIT_UNDERRUN = &h01020204
const OID_802_3_XMIT_HEARTBEAT_FAILURE = &h01020205
const OID_802_3_XMIT_TIMES_CRS_LOST = &h01020206
const OID_802_3_XMIT_LATE_COLLISIONS = &h01020207
const OID_802_5_PERMANENT_ADDRESS = &h02010101
const OID_802_5_CURRENT_ADDRESS = &h02010102
const OID_802_5_CURRENT_FUNCTIONAL = &h02010103
const OID_802_5_CURRENT_GROUP = &h02010104
const OID_802_5_LAST_OPEN_STATUS = &h02010105
const OID_802_5_CURRENT_RING_STATUS = &h02010106
const OID_802_5_CURRENT_RING_STATE = &h02010107
const OID_802_5_LINE_ERRORS = &h02020101
const OID_802_5_LOST_FRAMES = &h02020102
const OID_802_5_BURST_ERRORS = &h02020201
const OID_802_5_AC_ERRORS = &h02020202
const OID_802_5_ABORT_DELIMETERS = &h02020203
const OID_802_5_FRAME_COPIED_ERRORS = &h02020204
const OID_802_5_FREQUENCY_ERRORS = &h02020205
const OID_802_5_TOKEN_ERRORS = &h02020206
const OID_802_5_INTERNAL_ERRORS = &h02020207
const OID_FDDI_LONG_PERMANENT_ADDR = &h03010101
const OID_FDDI_LONG_CURRENT_ADDR = &h03010102
const OID_FDDI_LONG_MULTICAST_LIST = &h03010103
const OID_FDDI_LONG_MAX_LIST_SIZE = &h03010104
const OID_FDDI_SHORT_PERMANENT_ADDR = &h03010105
const OID_FDDI_SHORT_CURRENT_ADDR = &h03010106
const OID_FDDI_SHORT_MULTICAST_LIST = &h03010107
const OID_FDDI_SHORT_MAX_LIST_SIZE = &h03010108
const OID_FDDI_ATTACHMENT_TYPE = &h03020101
const OID_FDDI_UPSTREAM_NODE_LONG = &h03020102
const OID_FDDI_DOWNSTREAM_NODE_LONG = &h03020103
const OID_FDDI_FRAME_ERRORS = &h03020104
const OID_FDDI_FRAMES_LOST = &h03020105
const OID_FDDI_RING_MGT_STATE = &h03020106
const OID_FDDI_LCT_FAILURES = &h03020107
const OID_FDDI_LEM_REJECTS = &h03020108
const OID_FDDI_LCONNECTION_STATE = &h03020109
const OID_FDDI_SMT_STATION_ID = &h03030201
const OID_FDDI_SMT_OP_VERSION_ID = &h03030202
const OID_FDDI_SMT_HI_VERSION_ID = &h03030203
const OID_FDDI_SMT_LO_VERSION_ID = &h03030204
const OID_FDDI_SMT_MANUFACTURER_DATA = &h03030205
const OID_FDDI_SMT_USER_DATA = &h03030206
const OID_FDDI_SMT_MIB_VERSION_ID = &h03030207
const OID_FDDI_SMT_MAC_CT = &h03030208
const OID_FDDI_SMT_NON_MASTER_CT = &h03030209
const OID_FDDI_SMT_MASTER_CT = &h0303020A
const OID_FDDI_SMT_AVAILABLE_PATHS = &h0303020B
const OID_FDDI_SMT_CONFIG_CAPABILITIES = &h0303020C
const OID_FDDI_SMT_CONFIG_POLICY = &h0303020D
const OID_FDDI_SMT_CONNECTION_POLICY = &h0303020E
const OID_FDDI_SMT_T_NOTIFY = &h0303020F
const OID_FDDI_SMT_STAT_RPT_POLICY = &h03030210
const OID_FDDI_SMT_TRACE_MAX_EXPIRATION = &h03030211
const OID_FDDI_SMT_PORT_INDEXES = &h03030212
const OID_FDDI_SMT_MAC_INDEXES = &h03030213
const OID_FDDI_SMT_BYPASS_PRESENT = &h03030214
const OID_FDDI_SMT_ECM_STATE = &h03030215
const OID_FDDI_SMT_CF_STATE = &h03030216
const OID_FDDI_SMT_HOLD_STATE = &h03030217
const OID_FDDI_SMT_REMOTE_DISCONNECT_FLAG = &h03030218
const OID_FDDI_SMT_STATION_STATUS = &h03030219
const OID_FDDI_SMT_PEER_WRAP_FLAG = &h0303021A
const OID_FDDI_SMT_MSG_TIME_STAMP = &h0303021B
const OID_FDDI_SMT_TRANSITION_TIME_STAMP = &h0303021C
const OID_FDDI_SMT_SET_COUNT = &h0303021D
const OID_FDDI_SMT_LAST_SET_STATION_ID = &h0303021E
const OID_FDDI_MAC_FRAME_STATUS_FUNCTIONS = &h0303021F
const OID_FDDI_MAC_BRIDGE_FUNCTIONS = &h03030220
const OID_FDDI_MAC_T_MAX_CAPABILITY = &h03030221
const OID_FDDI_MAC_TVX_CAPABILITY = &h03030222
const OID_FDDI_MAC_AVAILABLE_PATHS = &h03030223
const OID_FDDI_MAC_CURRENT_PATH = &h03030224
const OID_FDDI_MAC_UPSTREAM_NBR = &h03030225
const OID_FDDI_MAC_DOWNSTREAM_NBR = &h03030226
const OID_FDDI_MAC_OLD_UPSTREAM_NBR = &h03030227
const OID_FDDI_MAC_OLD_DOWNSTREAM_NBR = &h03030228
const OID_FDDI_MAC_DUP_ADDRESS_TEST = &h03030229
const OID_FDDI_MAC_REQUESTED_PATHS = &h0303022A
const OID_FDDI_MAC_DOWNSTREAM_PORT_TYPE = &h0303022B
const OID_FDDI_MAC_INDEX = &h0303022C
const OID_FDDI_MAC_SMT_ADDRESS = &h0303022D
const OID_FDDI_MAC_LONG_GRP_ADDRESS = &h0303022E
const OID_FDDI_MAC_SHORT_GRP_ADDRESS = &h0303022F
const OID_FDDI_MAC_T_REQ = &h03030230
const OID_FDDI_MAC_T_NEG = &h03030231
const OID_FDDI_MAC_T_MAX = &h03030232
const OID_FDDI_MAC_TVX_VALUE = &h03030233
const OID_FDDI_MAC_T_PRI0 = &h03030234
const OID_FDDI_MAC_T_PRI1 = &h03030235
const OID_FDDI_MAC_T_PRI2 = &h03030236
const OID_FDDI_MAC_T_PRI3 = &h03030237
const OID_FDDI_MAC_T_PRI4 = &h03030238
const OID_FDDI_MAC_T_PRI5 = &h03030239
const OID_FDDI_MAC_T_PRI6 = &h0303023A
const OID_FDDI_MAC_FRAME_CT = &h0303023B
const OID_FDDI_MAC_COPIED_CT = &h0303023C
const OID_FDDI_MAC_TRANSMIT_CT = &h0303023D
const OID_FDDI_MAC_TOKEN_CT = &h0303023E
const OID_FDDI_MAC_ERROR_CT = &h0303023F
const OID_FDDI_MAC_LOST_CT = &h03030240
const OID_FDDI_MAC_TVX_EXPIRED_CT = &h03030241
const OID_FDDI_MAC_NOT_COPIED_CT = &h03030242
const OID_FDDI_MAC_LATE_CT = &h03030243
const OID_FDDI_MAC_RING_OP_CT = &h03030244
const OID_FDDI_MAC_FRAME_ERROR_THRESHOLD = &h03030245
const OID_FDDI_MAC_FRAME_ERROR_RATIO = &h03030246
const OID_FDDI_MAC_NOT_COPIED_THRESHOLD = &h03030247
const OID_FDDI_MAC_NOT_COPIED_RATIO = &h03030248
const OID_FDDI_MAC_RMT_STATE = &h03030249
const OID_FDDI_MAC_DA_FLAG = &h0303024A
const OID_FDDI_MAC_UNDA_FLAG = &h0303024B
const OID_FDDI_MAC_FRAME_ERROR_FLAG = &h0303024C
const OID_FDDI_MAC_NOT_COPIED_FLAG = &h0303024D
const OID_FDDI_MAC_MA_UNITDATA_AVAILABLE = &h0303024E
const OID_FDDI_MAC_HARDWARE_PRESENT = &h0303024F
const OID_FDDI_MAC_MA_UNITDATA_ENABLE = &h03030250
const OID_FDDI_PATH_INDEX = &h03030251
const OID_FDDI_PATH_RING_LATENCY = &h03030252
const OID_FDDI_PATH_TRACE_STATUS = &h03030253
const OID_FDDI_PATH_SBA_PAYLOAD = &h03030254
const OID_FDDI_PATH_SBA_OVERHEAD = &h03030255
const OID_FDDI_PATH_CONFIGURATION = &h03030256
const OID_FDDI_PATH_T_R_MODE = &h03030257
const OID_FDDI_PATH_SBA_AVAILABLE = &h03030258
const OID_FDDI_PATH_TVX_LOWER_BOUND = &h03030259
const OID_FDDI_PATH_T_MAX_LOWER_BOUND = &h0303025A
const OID_FDDI_PATH_MAX_T_REQ = &h0303025B
const OID_FDDI_PORT_MY_TYPE = &h0303025C
const OID_FDDI_PORT_NEIGHBOR_TYPE = &h0303025D
const OID_FDDI_PORT_CONNECTION_POLICIES = &h0303025E
const OID_FDDI_PORT_MAC_INDICATED = &h0303025F
const OID_FDDI_PORT_CURRENT_PATH = &h03030260
const OID_FDDI_PORT_REQUESTED_PATHS = &h03030261
const OID_FDDI_PORT_MAC_PLACEMENT = &h03030262
const OID_FDDI_PORT_AVAILABLE_PATHS = &h03030263
const OID_FDDI_PORT_MAC_LOOP_TIME = &h03030264
const OID_FDDI_PORT_PMD_CLASS = &h03030265
const OID_FDDI_PORT_CONNECTION_CAPABILITIES = &h03030266
const OID_FDDI_PORT_INDEX = &h03030267
const OID_FDDI_PORT_MAINT_LS = &h03030268
const OID_FDDI_PORT_BS_FLAG = &h03030269
const OID_FDDI_PORT_PC_LS = &h0303026A
const OID_FDDI_PORT_EB_ERROR_CT = &h0303026B
const OID_FDDI_PORT_LCT_FAIL_CT = &h0303026C
const OID_FDDI_PORT_LER_ESTIMATE = &h0303026D
const OID_FDDI_PORT_LEM_REJECT_CT = &h0303026E
const OID_FDDI_PORT_LEM_CT = &h0303026F
const OID_FDDI_PORT_LER_CUTOFF = &h03030270
const OID_FDDI_PORT_LER_ALARM = &h03030271
const OID_FDDI_PORT_CONNNECT_STATE = &h03030272
const OID_FDDI_PORT_PCM_STATE = &h03030273
const OID_FDDI_PORT_PC_WITHHOLD = &h03030274
const OID_FDDI_PORT_LER_FLAG = &h03030275
const OID_FDDI_PORT_HARDWARE_PRESENT = &h03030276
const OID_FDDI_SMT_STATION_ACTION = &h03030277
const OID_FDDI_PORT_ACTION = &h03030278
const OID_FDDI_IF_DESCR = &h03030279
const OID_FDDI_IF_TYPE = &h0303027A
const OID_FDDI_IF_MTU = &h0303027B
const OID_FDDI_IF_SPEED = &h0303027C
const OID_FDDI_IF_PHYS_ADDRESS = &h0303027D
const OID_FDDI_IF_ADMIN_STATUS = &h0303027E
const OID_FDDI_IF_OPER_STATUS = &h0303027F
const OID_FDDI_IF_LAST_CHANGE = &h03030280
const OID_FDDI_IF_IN_OCTETS = &h03030281
const OID_FDDI_IF_IN_UCAST_PKTS = &h03030282
const OID_FDDI_IF_IN_NUCAST_PKTS = &h03030283
const OID_FDDI_IF_IN_DISCARDS = &h03030284
const OID_FDDI_IF_IN_ERRORS = &h03030285
const OID_FDDI_IF_IN_UNKNOWN_PROTOS = &h03030286
const OID_FDDI_IF_OUT_OCTETS = &h03030287
const OID_FDDI_IF_OUT_UCAST_PKTS = &h03030288
const OID_FDDI_IF_OUT_NUCAST_PKTS = &h03030289
const OID_FDDI_IF_OUT_DISCARDS = &h0303028A
const OID_FDDI_IF_OUT_ERRORS = &h0303028B
const OID_FDDI_IF_OUT_QLEN = &h0303028C
const OID_FDDI_IF_SPECIFIC = &h0303028D
const OID_WAN_PERMANENT_ADDRESS = &h04010101
const OID_WAN_CURRENT_ADDRESS = &h04010102
const OID_WAN_QUALITY_OF_SERVICE = &h04010103
const OID_WAN_PROTOCOL_TYPE = &h04010104
const OID_WAN_MEDIUM_SUBTYPE = &h04010105
const OID_WAN_HEADER_FORMAT = &h04010106
const OID_WAN_GET_INFO = &h04010107
const OID_WAN_SET_LINK_INFO = &h04010108
const OID_WAN_GET_LINK_INFO = &h04010109
const OID_WAN_LINE_COUNT = &h0401010A
const OID_WAN_PROTOCOL_CAPS = &h0401010B
const OID_WAN_GET_BRIDGE_INFO = &h0401020A
const OID_WAN_SET_BRIDGE_INFO = &h0401020B
const OID_WAN_GET_COMP_INFO = &h0401020C
const OID_WAN_SET_COMP_INFO = &h0401020D
const OID_WAN_GET_STATS_INFO = &h0401020E
const OID_WAN_CO_GET_INFO = &h04010180
const OID_WAN_CO_SET_LINK_INFO = &h04010181
const OID_WAN_CO_GET_LINK_INFO = &h04010182
const OID_WAN_CO_GET_COMP_INFO = &h04010280
const OID_WAN_CO_SET_COMP_INFO = &h04010281
const OID_WAN_CO_GET_STATS_INFO = &h04010282
const OID_LTALK_CURRENT_NODE_ID = &h05010102
const OID_LTALK_IN_BROADCASTS = &h05020101
const OID_LTALK_IN_LENGTH_ERRORS = &h05020102
const OID_LTALK_OUT_NO_HANDLERS = &h05020201
const OID_LTALK_COLLISIONS = &h05020202
const OID_LTALK_DEFERS = &h05020203
const OID_LTALK_NO_DATA_ERRORS = &h05020204
const OID_LTALK_RANDOM_CTS_ERRORS = &h05020205
const OID_LTALK_FCS_ERRORS = &h05020206
const OID_ARCNET_PERMANENT_ADDRESS = &h06010101
const OID_ARCNET_CURRENT_ADDRESS = &h06010102
const OID_ARCNET_RECONFIGURATIONS = &h06020201
const OID_TAPI_ACCEPT = &h07030101
const OID_TAPI_ANSWER = &h07030102
const OID_TAPI_CLOSE = &h07030103
const OID_TAPI_CLOSE_CALL = &h07030104
const OID_TAPI_CONDITIONAL_MEDIA_DETECTION = &h07030105
const OID_TAPI_CONFIG_DIALOG = &h07030106
const OID_TAPI_DEV_SPECIFIC = &h07030107
const OID_TAPI_DIAL = &h07030108
const OID_TAPI_DROP = &h07030109
const OID_TAPI_GET_ADDRESS_CAPS = &h0703010A
const OID_TAPI_GET_ADDRESS_ID = &h0703010B
const OID_TAPI_GET_ADDRESS_STATUS = &h0703010C
const OID_TAPI_GET_CALL_ADDRESS_ID = &h0703010D
const OID_TAPI_GET_CALL_INFO = &h0703010E
const OID_TAPI_GET_CALL_STATUS = &h0703010F
const OID_TAPI_GET_DEV_CAPS = &h07030110
const OID_TAPI_GET_DEV_CONFIG = &h07030111
const OID_TAPI_GET_EXTENSION_ID = &h07030112
const OID_TAPI_GET_ID = &h07030113
const OID_TAPI_GET_LINE_DEV_STATUS = &h07030114
const OID_TAPI_MAKE_CALL = &h07030115
const OID_TAPI_NEGOTIATE_EXT_VERSION = &h07030116
const OID_TAPI_OPEN = &h07030117
const OID_TAPI_PROVIDER_INITIALIZE = &h07030118
const OID_TAPI_PROVIDER_SHUTDOWN = &h07030119
const OID_TAPI_SECURE_CALL = &h0703011A
const OID_TAPI_SELECT_EXT_VERSION = &h0703011B
const OID_TAPI_SEND_USER_USER_INFO = &h0703011C
const OID_TAPI_SET_APP_SPECIFIC = &h0703011D
const OID_TAPI_SET_CALL_PARAMS = &h0703011E
const OID_TAPI_SET_DEFAULT_MEDIA_DETECTION = &h0703011F
const OID_TAPI_SET_DEV_CONFIG = &h07030120
const OID_TAPI_SET_MEDIA_MODE = &h07030121
const OID_TAPI_SET_STATUS_MESSAGES = &h07030122
const OID_TAPI_GATHER_DIGITS = &h07030123
const OID_TAPI_MONITOR_DIGITS = &h07030124
const OID_ATM_SUPPORTED_VC_RATES = &h08010101
const OID_ATM_SUPPORTED_SERVICE_CATEGORY = &h08010102
const OID_ATM_SUPPORTED_AAL_TYPES = &h08010103
const OID_ATM_HW_CURRENT_ADDRESS = &h08010104
const OID_ATM_MAX_ACTIVE_VCS = &h08010105
const OID_ATM_MAX_ACTIVE_VCI_BITS = &h08010106
const OID_ATM_MAX_ACTIVE_VPI_BITS = &h08010107
const OID_ATM_MAX_AAL0_PACKET_SIZE = &h08010108
const OID_ATM_MAX_AAL1_PACKET_SIZE = &h08010109
const OID_ATM_MAX_AAL34_PACKET_SIZE = &h0801010A
const OID_ATM_MAX_AAL5_PACKET_SIZE = &h0801010B
const OID_ATM_SIGNALING_VPIVCI = &h08010201
const OID_ATM_ASSIGNED_VPI = &h08010202
const OID_ATM_ACQUIRE_ACCESS_NET_RESOURCES = &h08010203
const OID_ATM_RELEASE_ACCESS_NET_RESOURCES = &h08010204
const OID_ATM_ILMI_VPIVCI = &h08010205
const OID_ATM_DIGITAL_BROADCAST_VPIVCI = &h08010206
const OID_ATM_GET_NEAREST_FLOW = &h08010207
const OID_ATM_ALIGNMENT_REQUIRED = &h08010208
const OID_ATM_LECS_ADDRESS = &h08010209
const OID_ATM_SERVICE_ADDRESS = &h0801020A
const OID_ATM_CALL_PROCEEDING = &h0801020B
const OID_ATM_CALL_ALERTING = &h0801020C
const OID_ATM_PARTY_ALERTING = &h0801020D
const OID_ATM_CALL_NOTIFY = &h0801020E
const OID_ATM_MY_IP_NM_ADDRESS = &h0801020F
const OID_ATM_RCV_CELLS_OK = &h08020101
const OID_ATM_XMIT_CELLS_OK = &h08020102
const OID_ATM_RCV_CELLS_DROPPED = &h08020103
const OID_ATM_RCV_INVALID_VPI_VCI = &h08020201
const OID_ATM_CELLS_HEC_ERROR = &h08020202
const OID_ATM_RCV_REASSEMBLY_ERROR = &h08020203
const OID_WW_GEN_NETWORK_TYPES_SUPPORTED = &h09010101
const OID_WW_GEN_NETWORK_TYPE_IN_USE = &h09010102
const OID_WW_GEN_HEADER_FORMATS_SUPPORTED = &h09010103
const OID_WW_GEN_HEADER_FORMAT_IN_USE = &h09010104
const OID_WW_GEN_INDICATION_REQUEST = &h09010105
const OID_WW_GEN_DEVICE_INFO = &h09010106
const OID_WW_GEN_OPERATION_MODE = &h09010107
const OID_WW_GEN_LOCK_STATUS = &h09010108
const OID_WW_GEN_DISABLE_TRANSMITTER = &h09010109
const OID_WW_GEN_NETWORK_ID = &h0901010A
const OID_WW_GEN_PERMANENT_ADDRESS = &h0901010B
const OID_WW_GEN_CURRENT_ADDRESS = &h0901010C
const OID_WW_GEN_SUSPEND_DRIVER = &h0901010D
const OID_WW_GEN_BASESTATION_ID = &h0901010E
const OID_WW_GEN_CHANNEL_ID = &h0901010F
const OID_WW_GEN_ENCRYPTION_SUPPORTED = &h09010110
const OID_WW_GEN_ENCRYPTION_IN_USE = &h09010111
const OID_WW_GEN_ENCRYPTION_STATE = &h09010112
const OID_WW_GEN_CHANNEL_QUALITY = &h09010113
const OID_WW_GEN_REGISTRATION_STATUS = &h09010114
const OID_WW_GEN_RADIO_LINK_SPEED = &h09010115
const OID_WW_GEN_LATENCY = &h09010116
const OID_WW_GEN_BATTERY_LEVEL = &h09010117
const OID_WW_GEN_EXTERNAL_POWER = &h09010118
const OID_WW_GEN_PING_ADDRESS = &h09010201
const OID_WW_GEN_RSSI = &h09010202
const OID_WW_GEN_SIM_STATUS = &h09010203
const OID_WW_GEN_ENABLE_SIM_PIN = &h09010204
const OID_WW_GEN_CHANGE_SIM_PIN = &h09010205
const OID_WW_GEN_SIM_PUK = &h09010206
const OID_WW_GEN_SIM_EXCEPTION = &h09010207
const OID_WW_MBX_SUBADDR = &h09050101
const OID_WW_MBX_FLEXLIST = &h09050103
const OID_WW_MBX_GROUPLIST = &h09050104
const OID_WW_MBX_TRAFFIC_AREA = &h09050105
const OID_WW_MBX_LIVE_DIE = &h09050106
const OID_WW_MBX_TEMP_DEFAULTLIST = &h09050107
const OID_WW_PIN_LOC_AUTHORIZE = &h09090101
const OID_WW_PIN_LAST_LOCATION = &h09090102
const OID_WW_PIN_LOC_FIX = &h09090103
const OID_WW_CDPD_SPNI = &h090D0101
const OID_WW_CDPD_WASI = &h090D0102
const OID_WW_CDPD_AREA_COLOR = &h090D0103
const OID_WW_CDPD_TX_POWER_LEVEL = &h090D0104
const OID_WW_CDPD_EID = &h090D0105
const OID_WW_CDPD_HEADER_COMPRESSION = &h090D0106
const OID_WW_CDPD_DATA_COMPRESSION = &h090D0107
const OID_WW_CDPD_CHANNEL_SELECT = &h090D0108
const OID_WW_CDPD_CHANNEL_STATE = &h090D0109
const OID_WW_CDPD_NEI = &h090D010A
const OID_WW_CDPD_NEI_STATE = &h090D010B
const OID_WW_CDPD_SERVICE_PROVIDER_IDENTIFIER = &h090D010C
const OID_WW_CDPD_SLEEP_MODE = &h090D010D
const OID_WW_CDPD_CIRCUIT_SWITCHED = &h090D010E
const OID_WW_CDPD_TEI = &h090D010F
const OID_WW_CDPD_RSSI = &h090D0110
const OID_WW_CDPD_CS_SERVICE_PREFERENCE = &h090D0111
const OID_WW_CDPD_CS_SERVICE_STATUS = &h090D0112
const OID_WW_CDPD_CS_INFO = &h090D0113
const OID_WW_CDPD_CS_SUSPEND = &h090D0114
const OID_WW_CDPD_CS_DEFAULT_DIAL_CODE = &h090D0115
const OID_WW_CDPD_CS_CALLBACK = &h090D0116
const OID_WW_CDPD_CS_SID_LIST = &h090D0117
const OID_WW_CDPD_CS_CONFIGURATION = &h090D0118
const OID_WW_ARD_SNDCP = &h09110101
const OID_WW_ARD_TMLY_MSG = &h09110102
const OID_WW_ARD_DATAGRAM = &h09110103
const OID_WW_TAC_COMPRESSION = &h09150101
const OID_WW_TAC_SET_CONFIG = &h09150102
const OID_WW_TAC_GET_STATUS = &h09150103
const OID_WW_TAC_USER_HEADER = &h09150104
const OID_WW_TAC_UNIQUE_SDU_TAG = &h09150105
const OID_WW_TAC_SEND_COMMAND = &h09150106
const OID_WW_TAC_GET_RESPONSE = &h09150107
const OID_WW_TAC_DISABLE_RECEIVER = &h09150108
const OID_WW_TAC_ANTENNA_MODE = &h09150109
const OID_WW_TAC_FLUSH_DATA = &h0915010A
const OID_WW_TAC_SHUTDOWN_DEVICE = &h0915010B
const OID_WW_TAC_DEVICE_EXCEPTION = &h0915010C
const OID_WW_TAC_RECEIVE_EXCEPTION = &h0915010D
const OID_WW_TAC_BUFFER_EXCEPTION = &h0915010E
const OID_WW_TAC_BATTERY_EXCEPTION = &h0915010F
const OID_WW_TAC_TRANSMITTER_KEYED = &h09150110
const OID_WW_TAC_SYSTEM_TABLE = &h09150111
const OID_WW_TAC_CHANNEL_TABLE = &h09150112
const OID_WW_TAC_DCHANNEL_TABLE = &h09150113
const OID_WW_TAC_RECEIVE_QUEUE_COUNT = &h09150114
const OID_WW_TAC_STATISTICS = &h09160101
const OID_WW_MET_FUNCTION = &h09190101
const OID_802_11_BSSID = &h0D010101
const OID_802_11_SSID = &h0D010102
const OID_802_11_NETWORK_TYPES_SUPPORTED = &h0D010203
const OID_802_11_NETWORK_TYPE_IN_USE = &h0D010204
const OID_802_11_TX_POWER_LEVEL = &h0D010205
const OID_802_11_RSSI = &h0D010206
const OID_802_11_RSSI_TRIGGER = &h0D010207
const OID_802_11_INFRASTRUCTURE_MODE = &h0D010108
const OID_802_11_FRAGMENTATION_THRESHOLD = &h0D010209
const OID_802_11_RTS_THRESHOLD = &h0D01020A
const OID_802_11_NUMBER_OF_ANTENNAS = &h0D01020B
const OID_802_11_RX_ANTENNA_SELECTED = &h0D01020C
const OID_802_11_TX_ANTENNA_SELECTED = &h0D01020D
const OID_802_11_SUPPORTED_RATES = &h0D01020E
const OID_802_11_DESIRED_RATES = &h0D010210
const OID_802_11_CONFIGURATION = &h0D010211
const OID_802_11_STATISTICS = &h0D020212
const OID_802_11_ADD_WEP = &h0D010113
const OID_802_11_REMOVE_WEP = &h0D010114
const OID_802_11_DISASSOCIATE = &h0D010115
const OID_802_11_POWER_MODE = &h0D010216
const OID_802_11_BSSID_LIST = &h0D010217
const OID_802_11_AUTHENTICATION_MODE = &h0D010118
const OID_802_11_PRIVACY_FILTER = &h0D010119
const OID_802_11_BSSID_LIST_SCAN = &h0D01011A
const OID_802_11_WEP_STATUS = &h0D01011B
#define OID_802_11_ENCRYPTION_STATUS OID_802_11_WEP_STATUS
const OID_802_11_RELOAD_DEFAULTS = &h0D01011C
const OID_802_11_ADD_KEY = &h0D01011D
const OID_802_11_REMOVE_KEY = &h0D01011E
const OID_802_11_ASSOCIATION_INFORMATION = &h0D01011F
const OID_802_11_TEST = &h0D010120
const OID_802_11_MEDIA_STREAM_MODE = &h0D010121
const NDIS_802_11_LENGTH_SSID = 32
const NDIS_802_11_LENGTH_RATES = 8
const NDIS_802_11_LENGTH_RATES_EX = 16

type _NDIS_802_11_STATUS_TYPE as long
enum
	Ndis802_11StatusType_Authentication
	Ndis802_11StatusType_MediaStreamMode
	Ndis802_11StatusTypeMax
end enum

type NDIS_802_11_STATUS_TYPE as _NDIS_802_11_STATUS_TYPE
type PNDIS_802_11_STATUS_TYPE as _NDIS_802_11_STATUS_TYPE ptr

type _NDIS_802_11_STATUS_INDICATION
	StatusType as NDIS_802_11_STATUS_TYPE
end type

type NDIS_802_11_STATUS_INDICATION as _NDIS_802_11_STATUS_INDICATION
type PNDIS_802_11_STATUS_INDICATION as _NDIS_802_11_STATUS_INDICATION ptr
const NDIS_802_11_AUTH_REQUEST_AUTH_FIELDS = &h0f
const NDIS_802_11_AUTH_REQUEST_REAUTH = &h01
const NDIS_802_11_AUTH_REQUEST_KEYUPDATE = &h02
const NDIS_802_11_AUTH_REQUEST_PAIRWISE_ERROR = &h06
const NDIS_802_11_AUTH_REQUEST_GROUP_ERROR = &h0E

type _NDIS_802_11_AUTHENTICATION_REQUEST
	Length as ULONG
	Bssid(0 to 5) as UCHAR
	Flags as ULONG
end type

type NDIS_802_11_AUTHENTICATION_REQUEST as _NDIS_802_11_AUTHENTICATION_REQUEST
type PNDIS_802_11_AUTHENTICATION_REQUEST as _NDIS_802_11_AUTHENTICATION_REQUEST ptr

type _NDIS_802_11_NETWORK_TYPE as long
enum
	Ndis802_11FH
	Ndis802_11DS
	Ndis802_11OFDM5
	Ndis802_11OFDM24
	Ndis802_11Automode
	Ndis802_11NetworkTypeMax
end enum

type NDIS_802_11_NETWORK_TYPE as _NDIS_802_11_NETWORK_TYPE
type PNDIS_802_11_NETWORK_TYPE as _NDIS_802_11_NETWORK_TYPE ptr

type _NDIS_802_11_NETWORK_TYPE_LIST
	NumberOfItems as ULONG
	NetworkType(0 to 0) as NDIS_802_11_NETWORK_TYPE
end type

type NDIS_802_11_NETWORK_TYPE_LIST as _NDIS_802_11_NETWORK_TYPE_LIST
type PNDIS_802_11_NETWORK_TYPE_LIST as _NDIS_802_11_NETWORK_TYPE_LIST ptr

type _NDIS_802_11_POWER_MODE as long
enum
	Ndis802_11PowerModeCAM
	Ndis802_11PowerModeMAX_PSP
	Ndis802_11PowerModeFast_PSP
	Ndis802_11PowerModeMax
end enum

type NDIS_802_11_POWER_MODE as _NDIS_802_11_POWER_MODE
type PNDIS_802_11_POWER_MODE as _NDIS_802_11_POWER_MODE ptr
type NDIS_802_11_TX_POWER_LEVEL as ULONG
type NDIS_802_11_RSSI as LONG

type _NDIS_802_11_CONFIGURATION_FH
	Length as ULONG
	HopPattern as ULONG
	HopSet as ULONG
	DwellTime as ULONG
end type

type NDIS_802_11_CONFIGURATION_FH as _NDIS_802_11_CONFIGURATION_FH
type PNDIS_802_11_CONFIGURATION_FH as _NDIS_802_11_CONFIGURATION_FH ptr

type _NDIS_802_11_CONFIGURATION
	Length as ULONG
	BeaconPeriod as ULONG
	ATIMWindow as ULONG
	DSConfig as ULONG
	FHConfig as NDIS_802_11_CONFIGURATION_FH
end type

type NDIS_802_11_CONFIGURATION as _NDIS_802_11_CONFIGURATION
type PNDIS_802_11_CONFIGURATION as _NDIS_802_11_CONFIGURATION ptr

type _NDIS_802_11_STATISTICS
	Length as ULONG
	TransmittedFragmentCount as LARGE_INTEGER
	MulticastTransmittedFrameCount as LARGE_INTEGER
	FailedCount as LARGE_INTEGER
	RetryCount as LARGE_INTEGER
	MultipleRetryCount as LARGE_INTEGER
	RTSSuccessCount as LARGE_INTEGER
	RTSFailureCount as LARGE_INTEGER
	ACKFailureCount as LARGE_INTEGER
	FrameDuplicateCount as LARGE_INTEGER
	ReceivedFragmentCount as LARGE_INTEGER
	MulticastReceivedFrameCount as LARGE_INTEGER
	FCSErrorCount as LARGE_INTEGER
end type

type NDIS_802_11_STATISTICS as _NDIS_802_11_STATISTICS
type PNDIS_802_11_STATISTICS as _NDIS_802_11_STATISTICS ptr
type NDIS_802_11_KEY_INDEX as ULONG
type NDIS_802_11_KEY_RSC as ULONGLONG

type _NDIS_802_11_KEY
	Length as ULONG
	KeyIndex as ULONG
	KeyLength as ULONG
	BSSID(0 to 5) as UCHAR
	KeyRSC as NDIS_802_11_KEY_RSC
	KeyMaterial(0 to 0) as UCHAR
end type

type NDIS_802_11_KEY as _NDIS_802_11_KEY
type PNDIS_802_11_KEY as _NDIS_802_11_KEY ptr

type _NDIS_802_11_REMOVE_KEY
	Length as ULONG
	KeyIndex as ULONG
	BSSID(0 to 5) as UCHAR
end type

type NDIS_802_11_REMOVE_KEY as _NDIS_802_11_REMOVE_KEY
type PNDIS_802_11_REMOVE_KEY as _NDIS_802_11_REMOVE_KEY ptr

type _NDIS_802_11_WEP
	Length as ULONG
	KeyIndex as ULONG
	KeyLength as ULONG
	KeyMaterial(0 to 0) as UCHAR
end type

type NDIS_802_11_WEP as _NDIS_802_11_WEP
type PNDIS_802_11_WEP as _NDIS_802_11_WEP ptr

type _NDIS_802_11_NETWORK_INFRASTRUCTURE as long
enum
	Ndis802_11IBSS
	Ndis802_11Infrastructure
	Ndis802_11AutoUnknown
	Ndis802_11InfrastructureMax
end enum

type NDIS_802_11_NETWORK_INFRASTRUCTURE as _NDIS_802_11_NETWORK_INFRASTRUCTURE
type PNDIS_802_11_NETWORK_INFRASTRUCTURE as _NDIS_802_11_NETWORK_INFRASTRUCTURE ptr

type _NDIS_802_11_AUTHENTICATION_MODE as long
enum
	Ndis802_11AuthModeOpen
	Ndis802_11AuthModeShared
	Ndis802_11AuthModeAutoSwitch
	Ndis802_11AuthModeWPA
	Ndis802_11AuthModeWPAPSK
	Ndis802_11AuthModeWPANone
	Ndis802_11AuthModeMax
end enum

type NDIS_802_11_AUTHENTICATION_MODE as _NDIS_802_11_AUTHENTICATION_MODE
type PNDIS_802_11_AUTHENTICATION_MODE as _NDIS_802_11_AUTHENTICATION_MODE ptr

type _NDIS_802_11_SSID
	SsidLength as ULONG
	Ssid(0 to 31) as UCHAR
end type

type NDIS_802_11_SSID as _NDIS_802_11_SSID
type PNDIS_802_11_SSID as _NDIS_802_11_SSID ptr

type _NDIS_WLAN_BSSID
	Length as ULONG
	MacAddress(0 to 5) as UCHAR
	Reserved(0 to 1) as UCHAR
	Ssid as NDIS_802_11_SSID
	Privacy as ULONG
	Rssi as NDIS_802_11_RSSI
	NetworkTypeInUse as NDIS_802_11_NETWORK_TYPE
	Configuration as NDIS_802_11_CONFIGURATION
	InfrastructureMode as NDIS_802_11_NETWORK_INFRASTRUCTURE
	SupportedRates(0 to 7) as UCHAR
end type

type NDIS_WLAN_BSSID as _NDIS_WLAN_BSSID
type PNDIS_WLAN_BSSID as _NDIS_WLAN_BSSID ptr

type _NDIS_802_11_BSSID_LIST
	NumberOfItems as ULONG
	Bssid(0 to 0) as NDIS_WLAN_BSSID
end type

type NDIS_802_11_BSSID_LIST as _NDIS_802_11_BSSID_LIST
type PNDIS_802_11_BSSID_LIST as _NDIS_802_11_BSSID_LIST ptr

type _NDIS_WLAN_BSSID_EX
	Length as ULONG
	MacAddress(0 to 5) as UCHAR
	Reserved(0 to 1) as UCHAR
	Ssid as NDIS_802_11_SSID
	Privacy as ULONG
	Rssi as NDIS_802_11_RSSI
	NetworkTypeInUse as NDIS_802_11_NETWORK_TYPE
	Configuration as NDIS_802_11_CONFIGURATION
	InfrastructureMode as NDIS_802_11_NETWORK_INFRASTRUCTURE
	SupportedRates(0 to 15) as UCHAR
	IELength as ULONG
	IEs(0 to 0) as UCHAR
end type

type NDIS_WLAN_BSSID_EX as _NDIS_WLAN_BSSID_EX
type PNDIS_WLAN_BSSID_EX as _NDIS_WLAN_BSSID_EX ptr

type _NDIS_802_11_BSSID_LIST_EX
	NumberOfItems as ULONG
	Bssid(0 to 0) as NDIS_WLAN_BSSID_EX
end type

type NDIS_802_11_BSSID_LIST_EX as _NDIS_802_11_BSSID_LIST_EX
type PNDIS_802_11_BSSID_LIST_EX as _NDIS_802_11_BSSID_LIST_EX ptr

type _NDIS_802_11_FIXED_IEs
	Timestamp(0 to 7) as UCHAR
	BeaconInterval as USHORT
	Capabilities as USHORT
end type

type NDIS_802_11_FIXED_IEs as _NDIS_802_11_FIXED_IEs
type PNDIS_802_11_FIXED_IEs as _NDIS_802_11_FIXED_IEs ptr

type _NDIS_802_11_VARIABLE_IEs
	ElementID as UCHAR
	Length as UCHAR
	data(0 to 0) as UCHAR
end type

type NDIS_802_11_VARIABLE_IEs as _NDIS_802_11_VARIABLE_IEs
type PNDIS_802_11_VARIABLE_IEs as _NDIS_802_11_VARIABLE_IEs ptr
type NDIS_802_11_FRAGMENTATION_THRESHOLD as ULONG
type NDIS_802_11_RTS_THRESHOLD as ULONG
type NDIS_802_11_ANTENNA as ULONG

type _NDIS_802_11_PRIVACY_FILTER as long
enum
	Ndis802_11PrivFilterAcceptAll
	Ndis802_11PrivFilter8021xWEP
end enum

type NDIS_802_11_PRIVACY_FILTER as _NDIS_802_11_PRIVACY_FILTER
type PNDIS_802_11_PRIVACY_FILTER as _NDIS_802_11_PRIVACY_FILTER ptr

type _NDIS_802_11_WEP_STATUS as long
enum
	Ndis802_11WEPEnabled
	Ndis802_11Encryption1Enabled = Ndis802_11WEPEnabled
	Ndis802_11WEPDisabled
	Ndis802_11EncryptionDisabled = Ndis802_11WEPDisabled
	Ndis802_11WEPKeyAbsent
	Ndis802_11Encryption1KeyAbsent = Ndis802_11WEPKeyAbsent
	Ndis802_11WEPNotSupported
	Ndis802_11EncryptionNotSupported = Ndis802_11WEPNotSupported
	Ndis802_11Encryption2Enabled
	Ndis802_11Encryption2KeyAbsent
	Ndis802_11Encryption3Enabled
	Ndis802_11Encryption3KeyAbsent
end enum

type NDIS_802_11_WEP_STATUS as _NDIS_802_11_WEP_STATUS
type PNDIS_802_11_WEP_STATUS as _NDIS_802_11_WEP_STATUS ptr
type NDIS_802_11_ENCRYPTION_STATUS as _NDIS_802_11_WEP_STATUS
type PNDIS_802_11_ENCRYPTION_STATUS as _NDIS_802_11_WEP_STATUS ptr

type _NDIS_802_11_RELOAD_DEFAULTS as long
enum
	Ndis802_11ReloadWEPKeys
end enum

type NDIS_802_11_RELOAD_DEFAULTS as _NDIS_802_11_RELOAD_DEFAULTS
type PNDIS_802_11_RELOAD_DEFAULTS as _NDIS_802_11_RELOAD_DEFAULTS ptr
const NDIS_802_11_AI_REQFI_CAPABILITIES = 1
const NDIS_802_11_AI_REQFI_LISTENINTERVAL = 2
const NDIS_802_11_AI_REQFI_CURRENTAPADDRESS = 4
const NDIS_802_11_AI_RESFI_CAPABILITIES = 1
const NDIS_802_11_AI_RESFI_STATUSCODE = 2
const NDIS_802_11_AI_RESFI_ASSOCIATIONID = 4

type _NDIS_802_11_AI_REQFI
	Capabilities as USHORT
	ListenInterval as USHORT
	CurrentAPAddress(0 to 5) as UCHAR
end type

type NDIS_802_11_AI_REQFI as _NDIS_802_11_AI_REQFI
type PNDIS_802_11_AI_REQFI as _NDIS_802_11_AI_REQFI ptr

type _NDIS_802_11_AI_RESFI
	Capabilities as USHORT
	StatusCode as USHORT
	AssociationId as USHORT
end type

type NDIS_802_11_AI_RESFI as _NDIS_802_11_AI_RESFI
type PNDIS_802_11_AI_RESFI as _NDIS_802_11_AI_RESFI ptr

type _NDIS_802_11_ASSOCIATION_INFORMATION
	Length as ULONG
	AvailableRequestFixedIEs as USHORT
	RequestFixedIEs as NDIS_802_11_AI_REQFI
	RequestIELength as ULONG
	OffsetRequestIEs as ULONG
	AvailableResponseFixedIEs as USHORT
	ResponseFixedIEs as NDIS_802_11_AI_RESFI
	ResponseIELength as ULONG
	OffsetResponseIEs as ULONG
end type

type NDIS_802_11_ASSOCIATION_INFORMATION as _NDIS_802_11_ASSOCIATION_INFORMATION
type PNDIS_802_11_ASSOCIATION_INFORMATION as _NDIS_802_11_ASSOCIATION_INFORMATION ptr

type _NDIS_802_11_AUTHENTICATION_EVENT
	Status as NDIS_802_11_STATUS_INDICATION
	Request(0 to 0) as NDIS_802_11_AUTHENTICATION_REQUEST
end type

type NDIS_802_11_AUTHENTICATION_EVENT as _NDIS_802_11_AUTHENTICATION_EVENT
type PNDIS_802_11_AUTHENTICATION_EVENT as _NDIS_802_11_AUTHENTICATION_EVENT ptr

type _NDIS_802_11_TEST
	Length as ULONG
	as ULONG Type

	union
		AuthenticationEvent as NDIS_802_11_AUTHENTICATION_EVENT
		RssiTrigger as NDIS_802_11_RSSI
	end union
end type

type NDIS_802_11_TEST as _NDIS_802_11_TEST
type PNDIS_802_11_TEST as _NDIS_802_11_TEST ptr

type _NDIS_802_11_MEDIA_STREAM_MODE as long
enum
	Ndis802_11MediaStreamOff
	Ndis802_11MediaStreamOn
end enum

type NDIS_802_11_MEDIA_STREAM_MODE as _NDIS_802_11_MEDIA_STREAM_MODE
type PNDIS_802_11_MEDIA_STREAM_MODE as _NDIS_802_11_MEDIA_STREAM_MODE ptr
const OID_IRDA_RECEIVING = &h0A010100
const OID_IRDA_TURNAROUND_TIME = &h0A010101
const OID_IRDA_SUPPORTED_SPEEDS = &h0A010102
const OID_IRDA_LINK_SPEED = &h0A010103
const OID_IRDA_MEDIA_BUSY = &h0A010104
const OID_IRDA_EXTRA_RCV_BOFS = &h0A010200
const OID_IRDA_RATE_SNIFF = &h0A010201
const OID_IRDA_UNICAST_LIST = &h0A010202
const OID_IRDA_MAX_UNICAST_LIST_SIZE = &h0A010203
const OID_IRDA_MAX_RECEIVE_WINDOW_SIZE = &h0A010204
const OID_IRDA_MAX_SEND_WINDOW_SIZE = &h0A010205
const OID_IRDA_RESERVED1 = &h0A01020A
const OID_IRDA_RESERVED2 = &h0A01020F
const OID_BPC_ADAPTER_CAPS = &h0B010100
const OID_BPC_DEVICES = &h0B010101
const OID_BPC_DEVICE_CAPS = &h0B010102
const OID_BPC_DEVICE_SETTINGS = &h0B010103
const OID_BPC_CONNECTION_STATUS = &h0B010104
const OID_BPC_ADDRESS_COMPARE = &h0B010105
const OID_BPC_PROGRAM_GUIDE = &h0B010106
const OID_BPC_LAST_ERROR = &h0B020107
const OID_BPC_POOL = &h0B010108
const OID_BPC_PROVIDER_SPECIFIC = &h0B020109
const OID_BPC_ADAPTER_SPECIFIC = &h0B02010A
const OID_BPC_CONNECT = &h0B01010B
const OID_BPC_COMMIT = &h0B01010C
const OID_BPC_DISCONNECT = &h0B01010D
const OID_BPC_CONNECTION_ENABLE = &h0B01010E
const OID_BPC_POOL_RESERVE = &h0B01010F
const OID_BPC_POOL_RETURN = &h0B010110
const OID_BPC_FORCE_RECEIVE = &h0B010111
const OID_BPC_LAST = &h0B020112
const OID_1394_LOCAL_NODE_INFO = &h0C010101
const OID_1394_VC_INFO = &h0C010102
const OID_CO_ADD_PVC = &hFE000001
const OID_CO_DELETE_PVC = &hFE000002
const OID_CO_GET_CALL_INFORMATION = &hFE000003
const OID_CO_ADD_ADDRESS = &hFE000004
const OID_CO_DELETE_ADDRESS = &hFE000005
const OID_CO_GET_ADDRESSES = &hFE000006
const OID_CO_ADDRESS_CHANGE = &hFE000007
const OID_CO_SIGNALING_ENABLED = &hFE000008
const OID_CO_SIGNALING_DISABLED = &hFE000009
const OID_CO_AF_CLOSE = &hFE00000A
const OID_CO_TAPI_CM_CAPS = &hFE001001
const OID_CO_TAPI_LINE_CAPS = &hFE001002
const OID_CO_TAPI_ADDRESS_CAPS = &hFE001003
const OID_CO_TAPI_TRANSLATE_TAPI_CALLPARAMS = &hFE001004
const OID_CO_TAPI_TRANSLATE_NDIS_CALLPARAMS = &hFE001005
const OID_CO_TAPI_TRANSLATE_TAPI_SAP = &hFE001006
const OID_CO_TAPI_GET_CALL_DIAGNOSTICS = &hFE001007
const OID_CO_TAPI_REPORT_DIGITS = &hFE001008
const OID_CO_TAPI_DONT_REPORT_DIGITS = &hFE001009
const OID_PNP_CAPABILITIES = &hFD010100
const OID_PNP_SET_POWER = &hFD010101
const OID_PNP_QUERY_POWER = &hFD010102
const OID_PNP_ADD_WAKE_UP_PATTERN = &hFD010103
const OID_PNP_REMOVE_WAKE_UP_PATTERN = &hFD010104
const OID_PNP_WAKE_UP_PATTERN_LIST = &hFD010105
const OID_PNP_ENABLE_WAKE_UP = &hFD010106
const OID_PNP_WAKE_UP_OK = &hFD020200
const OID_PNP_WAKE_UP_ERROR = &hFD020201
const NDIS_PNP_WAKE_UP_MAGIC_PACKET = &h00000001
const NDIS_PNP_WAKE_UP_PATTERN_MATCH = &h00000002
const NDIS_PNP_WAKE_UP_LINK_CHANGE = &h00000004
const OID_TCP_TASK_OFFLOAD = &hFC010201
const OID_TCP_TASK_IPSEC_ADD_SA = &hFC010202
const OID_TCP_TASK_IPSEC_DELETE_SA = &hFC010203
const OID_TCP_SAN_SUPPORT = &hFC010204
const OID_TCP_TASK_IPSEC_ADD_UDPESP_SA = &hFC010205
const OID_TCP_TASK_IPSEC_DELETE_UDPESP_SA = &hFC010206
const OID_FFP_SUPPORT = &hFC010210
const OID_FFP_FLUSH = &hFC010211
const OID_FFP_CONTROL = &hFC010212
const OID_FFP_PARAMS = &hFC010213
const OID_FFP_DATA = &hFC010214
const OID_FFP_DRIVER_STATS = &hFC020210
const OID_FFP_ADAPTER_STATS = &hFC020211
const OID_QOS_TC_SUPPORTED = &hFB010100
const OID_QOS_REMAINING_BANDWIDTH = &hFB010101
const OID_QOS_ISSLOW_FLOW = &hFB010102
const OID_QOS_BESTEFFORT_BANDWIDTH = &hFB010103
const OID_QOS_LATENCY = &hFB010104
const OID_QOS_FLOW_IP_CONFORMING = &hFB010105
const OID_QOS_FLOW_COUNT = &hFB010106
const OID_QOS_NON_BESTEFFORT_LIMIT = &hFB010107
const OID_QOS_SCHEDULING_PROFILES_SUPPORTED = &hFB010108
const OID_QOS_CURRENT_SCHEDULING_PROFILE = &hFB010109
const OID_QOS_TIMER_RESOLUTION = &hFB01010A
const OID_QOS_STATISTICS_BUFFER = &hFB01010B
const OID_QOS_HIERARCHY_CLASS = &hFB01010C
const OID_QOS_FLOW_MODE = &hFB01010D
const OID_QOS_ISSLOW_FRAGMENT_SIZE = &hFB01010E
const OID_QOS_FLOW_IP_NONCONFORMING = &hFB01010F
const OID_QOS_FLOW_8021P_CONFORMING = &hFB010110
const OID_QOS_FLOW_8021P_NONCONFORMING = &hFB010111
const OID_QOS_ENABLE_AVG_STATS = &hFB010112
const OID_QOS_ENABLE_WINDOW_ADJUSTMENT = &hFB010113

type NDIS_CO_DEVICE_PROFILE
	DeviceDescription as NDIS_VAR_DATA_DESC
	DevSpecificInfo as NDIS_VAR_DATA_DESC
	ulTAPISupplementaryPassThru as ULONG
	ulAddressModes as ULONG
	ulNumAddresses as ULONG
	ulBearerModes as ULONG
	ulMaxTxRate as ULONG
	ulMinTxRate as ULONG
	ulMaxRxRate as ULONG
	ulMinRxRate as ULONG
	ulMediaModes as ULONG
	ulGenerateToneModes as ULONG
	ulGenerateToneMaxNumFreq as ULONG
	ulGenerateDigitModes as ULONG
	ulMonitorToneMaxNumFreq as ULONG
	ulMonitorToneMaxNumEntries as ULONG
	ulMonitorDigitModes as ULONG
	ulGatherDigitsMinTimeout as ULONG
	ulGatherDigitsMaxTimeout as ULONG
	ulDevCapFlags as ULONG
	ulMaxNumActiveCalls as ULONG
	ulAnswerMode as ULONG
	ulUUIAcceptSize as ULONG
	ulUUIAnswerSize as ULONG
	ulUUIMakeCallSize as ULONG
	ulUUIDropSize as ULONG
	ulUUISendUserUserInfoSize as ULONG
	ulUUICallInfoSize as ULONG
end type

type PNDIS_CO_DEVICE_PROFILE as NDIS_CO_DEVICE_PROFILE ptr
type IPAddr as ULONG
type IPMask as ULONG
type SPI_TYPE as ULONG

type _OFFLOAD_OPERATION_E as long
enum
	AUTHENTICATE = 1
	ENCRYPT
end enum

type OFFLOAD_OPERATION_E as _OFFLOAD_OPERATION_E

type _OFFLOAD_ALGO_INFO
	algoIdentifier as ULONG
	algoKeylen as ULONG
	algoRounds as ULONG
end type

type OFFLOAD_ALGO_INFO as _OFFLOAD_ALGO_INFO
type POFFLOAD_ALGO_INFO as _OFFLOAD_ALGO_INFO ptr

type _OFFLOAD_CONF_ALGO as long
enum
	OFFLOAD_IPSEC_CONF_NONE
	OFFLOAD_IPSEC_CONF_DES
	OFFLOAD_IPSEC_CONF_RESERVED
	OFFLOAD_IPSEC_CONF_3_DES
	OFFLOAD_IPSEC_CONF_MAX
end enum

type OFFLOAD_CONF_ALGO as _OFFLOAD_CONF_ALGO

type _OFFLOAD_INTEGRITY_ALGO as long
enum
	OFFLOAD_IPSEC_INTEGRITY_NONE
	OFFLOAD_IPSEC_INTEGRITY_MD5
	OFFLOAD_IPSEC_INTEGRITY_SHA
	OFFLOAD_IPSEC_INTEGRITY_MAX
end enum

type OFFLOAD_INTEGRITY_ALGO as _OFFLOAD_INTEGRITY_ALGO

type _OFFLOAD_SECURITY_ASSOCIATION
	Operation as OFFLOAD_OPERATION_E
	SPI as SPI_TYPE
	IntegrityAlgo as OFFLOAD_ALGO_INFO
	ConfAlgo as OFFLOAD_ALGO_INFO
	Reserved as OFFLOAD_ALGO_INFO
end type

type OFFLOAD_SECURITY_ASSOCIATION as _OFFLOAD_SECURITY_ASSOCIATION
type POFFLOAD_SECURITY_ASSOCIATION as _OFFLOAD_SECURITY_ASSOCIATION ptr
const OFFLOAD_MAX_SAS = 3
const OFFLOAD_INBOUND_SA = &h0001
const OFFLOAD_OUTBOUND_SA = &h0002

type _OFFLOAD_IPSEC_ADD_SA
	SrcAddr as IPAddr
	SrcMask as IPMask
	DestAddr as IPAddr
	DestMask as IPMask
	Protocol as ULONG
	SrcPort as USHORT
	DestPort as USHORT
	SrcTunnelAddr as IPAddr
	DestTunnelAddr as IPAddr
	Flags as USHORT
	NumSAs as SHORT
	SecAssoc(0 to 2) as OFFLOAD_SECURITY_ASSOCIATION
	OffloadHandle as HANDLE
	KeyLen as ULONG
	KeyMat(0 to 0) as UCHAR
end type

type OFFLOAD_IPSEC_ADD_SA as _OFFLOAD_IPSEC_ADD_SA
type POFFLOAD_IPSEC_ADD_SA as _OFFLOAD_IPSEC_ADD_SA ptr

type _OFFLOAD_IPSEC_DELETE_SA
	OffloadHandle as HANDLE
end type

type OFFLOAD_IPSEC_DELETE_SA as _OFFLOAD_IPSEC_DELETE_SA
type POFFLOAD_IPSEC_DELETE_SA as _OFFLOAD_IPSEC_DELETE_SA ptr

type _UDP_ENCAP_TYPE as long
enum
	OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_IKE
	OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_OTHER
end enum

type UDP_ENCAP_TYPE as _UDP_ENCAP_TYPE
type PUDP_ENCAP_TYPE as _UDP_ENCAP_TYPE ptr

type _OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY
	UdpEncapType as UDP_ENCAP_TYPE
	DstEncapPort as USHORT
end type

type OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY as _OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY
type POFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY as _OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY ptr

type _OFFLOAD_IPSEC_ADD_UDPESP_SA
	SrcAddr as IPAddr
	SrcMask as IPMask
	DstAddr as IPAddr
	DstMask as IPMask
	Protocol as ULONG
	SrcPort as USHORT
	DstPort as USHORT
	SrcTunnelAddr as IPAddr
	DstTunnelAddr as IPAddr
	Flags as USHORT
	NumSAs as SHORT
	SecAssoc(0 to 2) as OFFLOAD_SECURITY_ASSOCIATION
	OffloadHandle as HANDLE
	EncapTypeEntry as OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY
	EncapTypeEntryOffldHandle as HANDLE
	KeyLen as ULONG
	KeyMat(0 to 0) as UCHAR
end type

type OFFLOAD_IPSEC_ADD_UDPESP_SA as _OFFLOAD_IPSEC_ADD_UDPESP_SA
type POFFLOAD_IPSEC_ADD_UDPESP_SA as _OFFLOAD_IPSEC_ADD_UDPESP_SA ptr

type _OFFLOAD_IPSEC_DELETE_UDPESP_SA
	OffloadHandle as HANDLE
	EncapTypeEntryOffldHandle as HANDLE
end type

type OFFLOAD_IPSEC_DELETE_UDPESP_SA as _OFFLOAD_IPSEC_DELETE_UDPESP_SA
type POFFLOAD_IPSEC_DELETE_UDPESP_SA as _OFFLOAD_IPSEC_DELETE_UDPESP_SA ptr
type NDIS_VLAN_ID as ULONG

type _NDIS_MEDIUM as long
enum
	NdisMedium802_3
	NdisMedium802_5
	NdisMediumFddi
	NdisMediumWan
	NdisMediumLocalTalk
	NdisMediumDix
	NdisMediumArcnetRaw
	NdisMediumArcnet878_2
	NdisMediumAtm
	NdisMediumWirelessWan
	NdisMediumIrda
	NdisMediumBpc
	NdisMediumCoWan
	NdisMedium1394
	NdisMediumInfiniBand
	NdisMediumMax
end enum

type NDIS_MEDIUM as _NDIS_MEDIUM
type PNDIS_MEDIUM as _NDIS_MEDIUM ptr

type _NDIS_PHYSICAL_MEDIUM as long
enum
	NdisPhysicalMediumUnspecified
	NdisPhysicalMediumWirelessLan
	NdisPhysicalMediumCableModem
	NdisPhysicalMediumPhoneLine
	NdisPhysicalMediumPowerLine
	NdisPhysicalMediumDSL
	NdisPhysicalMediumFibreChannel
	NdisPhysicalMedium1394
	NdisPhysicalMediumWirelessWan
	NdisPhysicalMediumNative802_11
	NdisPhysicalMediumBluetooth
	NdisPhysicalMediumInfiniband
	NdisPhysicalMediumWiMax
	NdisPhysicalMediumUWB
	NdisPhysicalMedium802_3
	NdisPhysicalMedium802_5
	NdisPhysicalMediumIrda
	NdisPhysicalMediumWiredWAN
	NdisPhysicalMediumWiredCoWan
	NdisPhysicalMediumOther
	NdisPhysicalMediumMax
end enum

type NDIS_PHYSICAL_MEDIUM as _NDIS_PHYSICAL_MEDIUM
type PNDIS_PHYSICAL_MEDIUM as _NDIS_PHYSICAL_MEDIUM ptr
const NDIS_PROTOCOL_ID_DEFAULT = &h00
const NDIS_PROTOCOL_ID_TCP_IP = &h02
const NDIS_PROTOCOL_ID_IPX = &h06
const NDIS_PROTOCOL_ID_NBF = &h07
const NDIS_PROTOCOL_ID_MAX = &h0F
const NDIS_PROTOCOL_ID_MASK = &h0F

type _TRANSPORT_HEADER_OFFSET
	ProtocolType as USHORT
	HeaderOffset as USHORT
end type

type TRANSPORT_HEADER_OFFSET as _TRANSPORT_HEADER_OFFSET
type PTRANSPORT_HEADER_OFFSET as _TRANSPORT_HEADER_OFFSET ptr

type _NETWORK_ADDRESS
	AddressLength as USHORT
	AddressType as USHORT
	Address(0 to 0) as UCHAR
end type

type NETWORK_ADDRESS as _NETWORK_ADDRESS
type PNETWORK_ADDRESS as _NETWORK_ADDRESS ptr

type _NETWORK_ADDRESS_LIST
	AddressCount as LONG
	AddressType as USHORT
	Address(0 to 0) as NETWORK_ADDRESS
end type

type NETWORK_ADDRESS_LIST as _NETWORK_ADDRESS_LIST
type PNETWORK_ADDRESS_LIST as _NETWORK_ADDRESS_LIST ptr

type _NETWORK_ADDRESS_IP
	sin_port as USHORT
	in_addr as ULONG
	sin_zero(0 to 7) as UCHAR
end type

type NETWORK_ADDRESS_IP as _NETWORK_ADDRESS_IP
type PNETWORK_ADDRESS_IP as _NETWORK_ADDRESS_IP ptr
#define NETWORK_ADDRESS_LENGTH_IP sizeof(NETWORK_ADDRESS_IP)

type _NETWORK_ADDRESS_IPX
	NetworkAddress as ULONG
	NodeAddress(0 to 5) as UCHAR
	Socket as USHORT
end type

type NETWORK_ADDRESS_IPX as _NETWORK_ADDRESS_IPX
type PNETWORK_ADDRESS_IPX as _NETWORK_ADDRESS_IPX ptr
#define NETWORK_ADDRESS_LENGTH_IPX sizeof(NETWORK_ADDRESS_IPX)

type _NDIS_HARDWARE_STATUS as long
enum
	NdisHardwareStatusReady
	NdisHardwareStatusInitializing
	NdisHardwareStatusReset
	NdisHardwareStatusClosing
	NdisHardwareStatusNotReady
end enum

type NDIS_HARDWARE_STATUS as _NDIS_HARDWARE_STATUS
type PNDIS_HARDWARE_STATUS as _NDIS_HARDWARE_STATUS ptr

type _GEN_GET_TIME_CAPS
	Flags as ULONG
	ClockPrecision as ULONG
end type

type GEN_GET_TIME_CAPS as _GEN_GET_TIME_CAPS
type PGEN_GET_TIME_CAPS as _GEN_GET_TIME_CAPS ptr
const READABLE_LOCAL_CLOCK = &h00000001
const CLOCK_NETWORK_DERIVED = &h00000002
const CLOCK_PRECISION = &h00000004
const RECEIVE_TIME_INDICATION_CAPABLE = &h00000008
const TIMED_SEND_CAPABLE = &h00000010
const TIME_STAMP_CAPABLE = &h00000020

type _GEN_GET_NETCARD_TIME
	ReadTime as ULONGLONG
end type

type GEN_GET_NETCARD_TIME as _GEN_GET_NETCARD_TIME
type PGEN_GET_NETCARD_TIME as _GEN_GET_NETCARD_TIME ptr

type _NDIS_PM_PACKET_PATTERN
	Priority as ULONG
	Reserved as ULONG
	MaskSize as ULONG
	PatternOffset as ULONG
	PatternSize as ULONG
	PatternFlags as ULONG
end type

type NDIS_PM_PACKET_PATTERN as _NDIS_PM_PACKET_PATTERN
type PNDIS_PM_PACKET_PATTERN as _NDIS_PM_PACKET_PATTERN ptr

type _NDIS_DEVICE_POWER_STATE as long
enum
	NdisDeviceStateUnspecified = 0
	NdisDeviceStateD0
	NdisDeviceStateD1
	NdisDeviceStateD2
	NdisDeviceStateD3
	NdisDeviceStateMaximum
end enum

type NDIS_DEVICE_POWER_STATE as _NDIS_DEVICE_POWER_STATE
type PNDIS_DEVICE_POWER_STATE as _NDIS_DEVICE_POWER_STATE ptr

type _NDIS_PM_WAKE_UP_CAPABILITIES
	MinMagicPacketWakeUp as NDIS_DEVICE_POWER_STATE
	MinPatternWakeUp as NDIS_DEVICE_POWER_STATE
	MinLinkChangeWakeUp as NDIS_DEVICE_POWER_STATE
end type

type NDIS_PM_WAKE_UP_CAPABILITIES as _NDIS_PM_WAKE_UP_CAPABILITIES
type PNDIS_PM_WAKE_UP_CAPABILITIES as _NDIS_PM_WAKE_UP_CAPABILITIES ptr
const NDIS_DEVICE_WAKE_UP_ENABLE = &h00000001
const NDIS_DEVICE_WAKE_ON_PATTERN_MATCH_ENABLE = &h00000002
const NDIS_DEVICE_WAKE_ON_MAGIC_PACKET_ENABLE = &h00000004

type _NDIS_PNP_CAPABILITIES
	Flags as ULONG
	WakeUpCapabilities as NDIS_PM_WAKE_UP_CAPABILITIES
end type

type NDIS_PNP_CAPABILITIES as _NDIS_PNP_CAPABILITIES
type PNDIS_PNP_CAPABILITIES as _NDIS_PNP_CAPABILITIES ptr

type _NDIS_FDDI_ATTACHMENT_TYPE as long
enum
	NdisFddiTypeIsolated = 1
	NdisFddiTypeLocalA
	NdisFddiTypeLocalB
	NdisFddiTypeLocalAB
	NdisFddiTypeLocalS
	NdisFddiTypeWrapA
	NdisFddiTypeWrapB
	NdisFddiTypeWrapAB
	NdisFddiTypeWrapS
	NdisFddiTypeCWrapA
	NdisFddiTypeCWrapB
	NdisFddiTypeCWrapS
	NdisFddiTypeThrough
end enum

type NDIS_FDDI_ATTACHMENT_TYPE as _NDIS_FDDI_ATTACHMENT_TYPE
type PNDIS_FDDI_ATTACHMENT_TYPE as _NDIS_FDDI_ATTACHMENT_TYPE ptr

type _NDIS_FDDI_RING_MGT_STATE as long
enum
	NdisFddiRingIsolated = 1
	NdisFddiRingNonOperational
	NdisFddiRingOperational
	NdisFddiRingDetect
	NdisFddiRingNonOperationalDup
	NdisFddiRingOperationalDup
	NdisFddiRingDirected
	NdisFddiRingTrace
end enum

type NDIS_FDDI_RING_MGT_STATE as _NDIS_FDDI_RING_MGT_STATE
type PNDIS_FDDI_RING_MGT_STATE as _NDIS_FDDI_RING_MGT_STATE ptr

type _NDIS_FDDI_LCONNECTION_STATE as long
enum
	NdisFddiStateOff = 1
	NdisFddiStateBreak
	NdisFddiStateTrace
	NdisFddiStateConnect
	NdisFddiStateNext
	NdisFddiStateSignal
	NdisFddiStateJoin
	NdisFddiStateVerify
	NdisFddiStateActive
	NdisFddiStateMaintenance
end enum

type NDIS_FDDI_LCONNECTION_STATE as _NDIS_FDDI_LCONNECTION_STATE
type PNDIS_FDDI_LCONNECTION_STATE as _NDIS_FDDI_LCONNECTION_STATE ptr

type _NDIS_WAN_MEDIUM_SUBTYPE as long
enum
	NdisWanMediumHub
	NdisWanMediumX_25
	NdisWanMediumIsdn
	NdisWanMediumSerial
	NdisWanMediumFrameRelay
	NdisWanMediumAtm
	NdisWanMediumSonet
	NdisWanMediumSW56K
	NdisWanMediumPPTP
	NdisWanMediumL2TP
	NdisWanMediumIrda
	NdisWanMediumParallel
	NdisWanMediumPppoe
end enum

type NDIS_WAN_MEDIUM_SUBTYPE as _NDIS_WAN_MEDIUM_SUBTYPE
type PNDIS_WAN_MEDIUM_SUBTYPE as _NDIS_WAN_MEDIUM_SUBTYPE ptr

type _NDIS_WAN_HEADER_FORMAT as long
enum
	NdisWanHeaderNative
	NdisWanHeaderEthernet
end enum

type NDIS_WAN_HEADER_FORMAT as _NDIS_WAN_HEADER_FORMAT
type PNDIS_WAN_HEADER_FORMAT as _NDIS_WAN_HEADER_FORMAT ptr

type _NDIS_WAN_QUALITY as long
enum
	NdisWanRaw
	NdisWanErrorControl
	NdisWanReliable
end enum

type NDIS_WAN_QUALITY as _NDIS_WAN_QUALITY
type PNDIS_WAN_QUALITY as _NDIS_WAN_QUALITY ptr

type _NDIS_WAN_PROTOCOL_CAPS
	Flags as ULONG
	Reserved as ULONG
end type

type NDIS_WAN_PROTOCOL_CAPS as _NDIS_WAN_PROTOCOL_CAPS
type PNDIS_WAN_PROTOCOL_CAPS as _NDIS_WAN_PROTOCOL_CAPS ptr
const WAN_PROTOCOL_KEEPS_STATS = &h00000001

type _NDIS_802_5_RING_STATE as long
enum
	NdisRingStateOpened = 1
	NdisRingStateClosed
	NdisRingStateOpening
	NdisRingStateClosing
	NdisRingStateOpenFailure
	NdisRingStateRingFailure
end enum

type NDIS_802_5_RING_STATE as _NDIS_802_5_RING_STATE
type PNDIS_802_5_RING_STATE as _NDIS_802_5_RING_STATE ptr

type _NDIS_MEDIA_STATE as long
enum
	NdisMediaStateConnected
	NdisMediaStateDisconnected
end enum

type NDIS_MEDIA_STATE as _NDIS_MEDIA_STATE
type PNDIS_MEDIA_STATE as _NDIS_MEDIA_STATE ptr
type Priority_802_3 as ULONG

type _NDIS_CO_LINK_SPEED
	Outbound as ULONG
	Inbound as ULONG
end type

type NDIS_CO_LINK_SPEED as _NDIS_CO_LINK_SPEED
type PNDIS_CO_LINK_SPEED as _NDIS_CO_LINK_SPEED ptr
type NDIS_STATUS as long
type PNDIS_STATUS as long ptr

type _NDIS_GUID
	Guid as GUID

	union
		Oid as NDIS_OID
		Status as NDIS_STATUS
	end union

	Size as ULONG
	Flags as ULONG
end type

type NDIS_GUID as _NDIS_GUID
type PNDIS_GUID as _NDIS_GUID ptr
const fNDIS_GUID_TO_OID = &h00000001
const fNDIS_GUID_TO_STATUS = &h00000002
const fNDIS_GUID_ANSI_STRING = &h00000004
const fNDIS_GUID_UNICODE_STRING = &h00000008
const fNDIS_GUID_ARRAY = &h00000010
const fNDIS_GUID_ALLOW_READ = &h00000020
const fNDIS_GUID_ALLOW_WRITE = &h00000040
const NDIS_PACKET_TYPE_DIRECTED = &h00000001
const NDIS_PACKET_TYPE_MULTICAST = &h00000002
const NDIS_PACKET_TYPE_ALL_MULTICAST = &h00000004
const NDIS_PACKET_TYPE_BROADCAST = &h00000008
const NDIS_PACKET_TYPE_SOURCE_ROUTING = &h00000010
const NDIS_PACKET_TYPE_PROMISCUOUS = &h00000020
const NDIS_PACKET_TYPE_SMT = &h00000040
const NDIS_PACKET_TYPE_ALL_LOCAL = &h00000080
const NDIS_PACKET_TYPE_GROUP = &h00001000
const NDIS_PACKET_TYPE_ALL_FUNCTIONAL = &h00002000
const NDIS_PACKET_TYPE_FUNCTIONAL = &h00004000
const NDIS_PACKET_TYPE_MAC_FRAME = &h00008000
const NDIS_RING_SIGNAL_LOSS = &h00008000
const NDIS_RING_HARD_ERROR = &h00004000
const NDIS_RING_SOFT_ERROR = &h00002000
const NDIS_RING_TRANSMIT_BEACON = &h00001000
const NDIS_RING_LOBE_WIRE_FAULT = &h00000800
const NDIS_RING_AUTO_REMOVAL_ERROR = &h00000400
const NDIS_RING_REMOVE_RECEIVED = &h00000200
const NDIS_RING_COUNTER_OVERFLOW = &h00000100
const NDIS_RING_SINGLE_STATION = &h00000080
const NDIS_RING_RING_RECOVERY = &h00000040
const NDIS_PROT_OPTION_ESTIMATED_LENGTH = &h00000001
const NDIS_PROT_OPTION_NO_LOOPBACK = &h00000002
const NDIS_PROT_OPTION_NO_RSVD_ON_RCVPKT = &h00000004
const NDIS_PROT_OPTION_SEND_RESTRICTED = &h00000008
const NDIS_MAC_OPTION_COPY_LOOKAHEAD_DATA = &h00000001
const NDIS_MAC_OPTION_RECEIVE_SERIALIZED = &h00000002
const NDIS_MAC_OPTION_TRANSFERS_NOT_PEND = &h00000004
const NDIS_MAC_OPTION_NO_LOOPBACK = &h00000008
const NDIS_MAC_OPTION_FULL_DUPLEX = &h00000010
const NDIS_MAC_OPTION_EOTX_INDICATION = &h00000020
const NDIS_MAC_OPTION_8021P_PRIORITY = &h00000040
const NDIS_MAC_OPTION_SUPPORTS_MAC_ADDRESS_OVERWRITE = &h00000080
const NDIS_MAC_OPTION_RECEIVE_AT_DPC = &h00000100
const NDIS_MAC_OPTION_8021Q_VLAN = &h00000200
const NDIS_MAC_OPTION_RESERVED = &h80000000
const NDIS_MEDIA_CAP_TRANSMIT = &h00000001
const NDIS_MEDIA_CAP_RECEIVE = &h00000002
const NDIS_CO_MAC_OPTION_DYNAMIC_LINK_SPEED = &h00000001

type _NDIS_IRDA_PACKET_INFO
	ExtraBOFs as ULONG
	MinTurnAroundTime as ULONG
end type

type NDIS_IRDA_PACKET_INFO as _NDIS_IRDA_PACKET_INFO
type PNDIS_IRDA_PACKET_INFO as _NDIS_IRDA_PACKET_INFO ptr

type _BPC_FILETIME
	dwLowDateTime as ULONG
	dwHighDateTime as ULONG
end type

type BPC_FILETIME as _BPC_FILETIME
type PBPC_FILETIME as _BPC_FILETIME ptr
type BPC_HANDLE as PVOID

const BPC_MIN_DIMENSION = 1
const BPC_MAX_BUFFER_SIZE = 64
const BPC_MIN_BUFFER_SIZE = 4
#define BPC_DEVICE_ANY cast(BPC_HANDLE, &hFFFFFFFF)

type _NDIS_BPC_INDICATE_REASON as long
enum
	bpcBufferFull = 0
	bpcBufferForced
	bpcBufferTimeOut
	bpcBufferDiscontinuity
	bpcBufferOverflow
	bpcBufferStatusEvent
end enum

type NDIS_BPC_INDICATE_REASON as _NDIS_BPC_INDICATE_REASON
type PNDIS_BPC_INDICATE_REASON as _NDIS_BPC_INDICATE_REASON ptr
const BPC_STREAM_TYPE_GENERIC_MIN = &h01000000
const BPC_STREAM_TYPE_RAW = &h01000000
const BPC_STREAM_TYPE_MPT_128 = &h01000001
const BPC_STREAM_TYPE_MPT_128_CRC = &h01000002
const BPC_STREAM_TYPE_IP = &h01000003
const BPC_STREAM_TYPE_PROVIDER_MIN = &h02000000
const BPC_STREAM_TYPE_PROVIDER_MAX = &h02ffffff
const BPC_STREAM_TYPE_ADAPTER_MIN = &h03000000
const BPC_STREAM_TYPE_ADAPTER_MAX = &h03ffffff

type _NDIS_BPC_ADAPTER_CAPS
	ulBPCMajorRev as ULONG
	ulBPCMinorRev as ULONG
	ulcHSDataDevices as ULONG
	ulbpsHSDeviceMax as ULONG
	ulcLSDataDevices as ULONG
	ulbpsLSDeviceMax as ULONG
	ulcTuningDevices as ULONG
	ulcbLargestStatus as ULONG
	ulVendorId as ULONG
	ulAdapterId as ULONG
	guidProvider as GUID
end type

type NDIS_BPC_ADAPTER_CAPS as _NDIS_BPC_ADAPTER_CAPS
type PNDIS_BPC_ADAPTER_CAPS as _NDIS_BPC_ADAPTER_CAPS ptr

type _NDIS_BPC_DEVICES
	ulcDevices as ULONG
	rgnhDevices(0 to 0) as BPC_HANDLE
end type

type NDIS_BPC_DEVICES as _NDIS_BPC_DEVICES
type PNDIS_BPC_DEVICES as _NDIS_BPC_DEVICES ptr
#define CbDevices(cnt) (FIELD_OFFSET(NDIS_BPC_DEVICES, rgnhDevices) + ((cnt) * sizeof(BPC_HANDLE)))

type NDIS_BPC_DEVICE_CAPS
	nhDevice as BPC_HANDLE
	ulBPCCaps as ULONG
	ulbpsMax as ULONG
	ulcStreamTypes as ULONG
	rgulStreamTypes(0 to 0) as ULONG
end type

type PNDIS_BPC_DEVICE_CAPS as NDIS_BPC_DEVICE_CAPS ptr
#define CbDeviceCaps(cnt) (FIELD_OFFSET(NDIS_BPC_DEVICE_CAPS, rgulStreamTypes) + ((cnt) * sizeof(ULONG)))
const BPCCapBusMasteredData = &h01
const BPCCapIndependentTuner = &h02
const BPCCapExternalDataBus = &h04
const BPCCapLowSpeedData = &h10
const BPCCapHighSpeedData = &h20

type NDIS_BPC_DEVICE_SETTINGS
	nhDevice as BPC_HANDLE
	ulBPCCaps as ULONG
	ulcConnections as ULONG
	fEnabled as BOOLEAN
	ulStreamType as ULONG
	ulcbAddressConnection as ULONG
	rgulAddressConnection(0 to 0) as ULONG
end type

type PNDIS_BPC_DEVICE_SETTINGS as NDIS_BPC_DEVICE_SETTINGS ptr
#define CbDeviceSettings(cnt) (FIELD_OFFSET(NDIS_BPC_DEVICE_SETTINGS, rgulAddressConnection) + ((cnt) * sizeof(ULONG)))
const BPC_CONNECT_STATE_UNCOMMITTED = 0
const BPC_CONNECT_STATE_QUEUED = 1
const BPC_CONNECT_STATE_ACTIVE = 2
const BPC_CONNECT_STATE_DISCONNECTING = 3

type NDIS_BPC_CONNECTION_STATUS
	nhConnection as BPC_HANDLE
	nhDevice as BPC_HANDLE
	ulConnectPriority as ULONG
	ulDisconnectPriority as ULONG
	ulbpsAverage as ULONG
	ulbpsBurst as ULONG
	ulState as ULONG
	fEnabled as BOOLEAN
end type

type PNDIS_BPC_CONNECTION_STATUS as NDIS_BPC_CONNECTION_STATUS ptr

type NDIS_BPC_ADDRESS_COMPARE
	fEqual as BOOLEAN
	ulcbFirstOffset as ULONG
	ulcbFirstLength as ULONG
	ulcbSecondOffset as ULONG
	ulcbSecondLength as ULONG
end type

type PNDIS_BPC_ADDRESS_COMPARE as NDIS_BPC_ADDRESS_COMPARE ptr
const BPC_GUIDE_GENERIC_MIN = &h01000000
const BPC_GUIDE_GENERIC_MAX = &h01ffffff
const BPC_GUIDE_PROVIDER_MIN = &h02000000
const BPC_GUIDE_PROVIDER_MAX = &h02ffffff
const BPC_GUIDE_ADAPTER_MIN = &h03000000
const BPC_GUIDE_ADAPTER_MAX = &h03ffffff

type NDIS_BPC_PROGRAM_GUIDE
	ulGuideType as ULONG
	ftLastUpdate as BPC_FILETIME
	ulChangeNumber as ULONG
	ulcbGuideSize as ULONG
	rgulGuideData(0 to 0) as ULONG
end type

type PNDIS_BPC_PROGRAM_GUIDE as NDIS_BPC_PROGRAM_GUIDE ptr

type _NDIS_BPC_ERROR as long
enum
	bpcErrorUnknownFailure = &hc0ff0000
	bpcErrorHardwareFailure
	bpcErrorProviderFailure
	bpcErrorNoDataDevice
	bpcErrorNoTuningDevice
	bpcErrorDeviceNotCapable
	bpcErrorConflictingDevice
	bpcErrorConflictingCapability
	bpcErrorNoBufferMemory
	bpcErrorNoResources
	bpcErrorAdapterClosing
	bpcErrorConnectionClosing
	bpcErrorTooComplex
	bpcErrorProviderNotSupported
	bpcErrorUnknownProviderStructure
	bpcErrorAddressNotSupported
	bpcErrorInvalidAddress
	bpcErrorUnknownAdapterStructure
end enum

type NDIS_BPC_ERROR as _NDIS_BPC_ERROR
type PNDIS_BPC_ERROR as _NDIS_BPC_ERROR ptr

type NDIS_BPC_LAST_ERROR
	ulErrorContext as ULONG
	ulBPCError as ULONG
	ulAdapterError as ULONG
	ulAdapterContext as ULONG
end type

type PNDIS_BPC_LAST_ERROR as NDIS_BPC_LAST_ERROR ptr

type NDIS_BPC_POOL
	nhConnection as BPC_HANDLE
	ulcbPoolSize as ULONG
	ulcbMaxBufferSize as ULONG
	ulcbBufferReserved as ULONG
end type

type PNDIS_BPC_POOL as NDIS_BPC_POOL ptr

type NDIS_BPC_CONNECT
	nhConnection as BPC_HANDLE
	nhDevice as BPC_HANDLE
	ulConnectPriority as ULONG
	ulDisconnectPriority as ULONG
	fImmediate as BOOLEAN
	ulcbAddress as ULONG
	guidProvider as GUID
	rgulAddress(0 to 0) as ULONG
end type

type PNDIS_BPC_CONNECT as NDIS_BPC_CONNECT ptr
#define CbConnect(cnt) (FIELD_OFFSET(NDIS_BPC_CONNECT, rgulAddress) + ((cnt) * sizeof(ULONG)))

type NDIS_BPC_COMMIT
	ulcConnections as ULONG
	rgnhConnections(0 to 0) as BPC_HANDLE
end type

type PNDIS_BPC_COMMIT as NDIS_BPC_COMMIT ptr

type NDIS_BPC_DISCONNECT
	nhConnection as BPC_HANDLE
end type

type PNDIS_BPC_DISCONNECT as NDIS_BPC_DISCONNECT ptr

type NDIS_BPC_CONNECTION_ENABLE
	nhConnection as BPC_HANDLE
	fEnabled as BOOLEAN
end type

type PNDIS_BPC_CONNECTION_ENABLE as NDIS_BPC_CONNECTION_ENABLE ptr

type NDIS_BPC_POOL_RETURN
	nhConnection as BPC_HANDLE
end type

type PNDIS_BPC_POOL_RETURN as NDIS_BPC_POOL_RETURN ptr

type NDIS_BPC_FORCE_RECEIVE
	nhConnection as BPC_HANDLE
	ulReasonCode as ULONG
end type

type PNDIS_BPC_FORCE_RECEIVE as NDIS_BPC_FORCE_RECEIVE ptr

type NDIS_BPC_MEDIA_SPECIFIC_INFORMATION
	nhConnection as BPC_HANDLE
	ulBPCStreamType as ULONG
	ulReasonCode as ULONG
	pvMiniportReserved1 as PVOID
	ulMiniportReserved2 as ULONG
end type

type PNDIS_BPC_MEDIA_SPECIFIC_INFORMATION as NDIS_BPC_MEDIA_SPECIFIC_INFORMATION ptr
const BPC_CATEGORY_BPC = &h01000000
const BPC_CATEGORY_PROVIDER = &h02000000
const BPC_CATEGORY_ADAPTER = &h03000000
const BPC_STATUS_CONNECTED = &h00000001
const BPC_STATUS_QUEUED = &h00000002
const BPC_STATUS_ACTIVE = &h00000003
const BPC_STATUS_DISCONNECTED = &h00000004
const BPC_STATUS_OVERFLOW = &h00000005
const BPC_STATUS_DATA_STOP = &h00000006
const BPC_STATUS_DATA_START = &h00000007
const BPC_STATUS_DATA_ERROR = &h00000008

type NDIS_BPC_STATUS
	ulStatusCategory as ULONG
	ulStatusType as ULONG
	ulcbStatus as ULONG
	rgulStatus as ULONG
end type

type PNDIS_BPC_STATUS as NDIS_BPC_STATUS ptr

type NDIS_BPC_STATUS_CONNECTION
	nhConnection as BPC_HANDLE
	nhDevice as BPC_HANDLE
end type

type NDIS_BPC_STATUS_CONNECTED as NDIS_BPC_STATUS_CONNECTION
type PNDIS_BPC_STATUS_CONNECTED as NDIS_BPC_STATUS_CONNECTION ptr
const NDIS_MINIPORT_BUS_MASTER = &h00000001
const NDIS_MINIPORT_WDM_DRIVER = &h00000002
const NDIS_MINIPORT_SG_LIST = &h00000004
const NDIS_MINIPORT_SUPPORTS_MEDIA_QUERY = &h00000008
const NDIS_MINIPORT_INDICATES_PACKETS = &h00000010
const NDIS_MINIPORT_IGNORE_PACKET_QUEUE = &h00000020
const NDIS_MINIPORT_IGNORE_REQUEST_QUEUE = &h00000040
const NDIS_MINIPORT_IGNORE_TOKEN_RING_ERRORS = &h00000080
const NDIS_MINIPORT_INTERMEDIATE_DRIVER = &h00000100
const NDIS_MINIPORT_IS_NDIS_5 = &h00000200
const NDIS_MINIPORT_IS_CO = &h00000400
const NDIS_MINIPORT_DESERIALIZE = &h00000800
const NDIS_MINIPORT_REQUIRES_MEDIA_POLLING = &h00001000
const NDIS_MINIPORT_SUPPORTS_MEDIA_SENSE = &h00002000
const NDIS_MINIPORT_NETBOOT_CARD = &h00004000
const NDIS_MINIPORT_PM_SUPPORTED = &h00008000
const NDIS_MINIPORT_SUPPORTS_MAC_ADDRESS_OVERWRITE = &h00010000
const NDIS_MINIPORT_USES_SAFE_BUFFER_APIS = &h00020000
const NDIS_MINIPORT_HIDDEN = &h00040000
const NDIS_MINIPORT_SWENUM = &h00080000
const NDIS_MINIPORT_SURPRISE_REMOVE_OK = &h00100000
const NDIS_MINIPORT_NO_HALT_ON_SUSPEND = &h00200000
const NDIS_MINIPORT_HARDWARE_DEVICE = &h00400000
const NDIS_MINIPORT_SUPPORTS_CANCEL_SEND_PACKETS = &h00800000
const NDIS_MINIPORT_64BITS_DMA = &h01000000
const NDIS_MINIPORT_USE_NEW_BITS = &h02000000
const NDIS_MINIPORT_EXCLUSIVE_INTERRUPT = &h04000000
const NDIS_MINIPORT_SENDS_PACKET_ARRAY = &h08000000
const NDIS_MINIPORT_FILTER_IM = &h10000000
const NDIS_MINIPORT_SHORT_PACKETS_ARE_PADDED = &h20000000
