''
''
'' winnt -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __win_winnt_bi__
#define __win_winnt_bi__

#include once "win/winerror.bi"

type CHAR as byte
type CCHAR as byte
type PCCHAR as byte ptr
type UCHAR as ubyte
type PUCHAR as ubyte ptr
type PUSHORT as ushort ptr
type PULONG as ulong ptr
type PSZ as byte ptr
type PVOID as any ptr
type LPVOID as any ptr
type PVOID64 as any ptr

#ifndef wchar_t
type wchar_t as ushort
#endif

type WCHAR as wchar_t
type PWCHAR as WCHAR ptr
type LPWCH as WCHAR ptr
type PWCH as WCHAR ptr
type NWPSTR as wstring ptr
type LPWSTR as wstring ptr
type PWSTR as wstring ptr
type LPCWCH as const WCHAR ptr
type PCWCH as const WCHAR ptr
type LPCWSTR as const wstring ptr
type PCWSTR as const wstring ptr

type PCHAR as CHAR ptr
type LPCH as CHAR ptr
type PCH as CHAR ptr
type NPSTR as zstring ptr
type LPSTR as zstring ptr
type PSTR as zstring ptr
type LPCCH as const CHAR ptr
type PCSTR as const zstring ptr
type LPCSTR as const zstring ptr

#ifndef TCHAR
# ifdef UNICODE
type TCHAR as WCHAR 
type _TCHAR as WCHAR
# else
type TCHAR as CHAR
type _TCHAR as CHAR
# endif
#endif

#ifdef UNICODE
type PTSTR as wstring ptr
type LPTSTR as wstring ptr
type LP as wstring ptr
type LPCTSTR as wstring ptr
#else
type PTSTR as zstring ptr
type LPTSTR as zstring ptr
type LP as zstring ptr
type LPCTSTR as zstring ptr
#endif

type TBYTE as TCHAR
type PTCH as TCHAR ptr
type PTBYTE as TCHAR ptr
type LPTCH as TCHAR ptr
type PTCHAR as TCHAR ptr

type PSHORT as SHORT ptr
type PLONG as LONG ptr
type HANDLE as any ptr
type PHANDLE as HANDLE ptr
type LPHANDLE as HANDLE ptr
#define DECLARE_HANDLE(n) type n as HANDLE
type LCID as DWORD
type PLCID as PDWORD
type LANGID as WORD

#ifdef UNICODE
#define __TEXT(q) wstr(q)
#else
#define __TEXT(q) q
#endif

#define _INTEGRAL_MAX_BITS 64

type LONGLONG as longint
type DWORDLONG as ulongint
type PLONGLONG as LONGLONG ptr
type PDWORDLONG as DWORDLONG ptr
type ULONGLONG as DWORDLONG
type PULONGLONG as DWORDLONG ptr
type USN as LONGLONG

#define Int32x32To64(a,b) (clngint(a) * clngint(b))
#define UInt32x32To64(a,b) (culngint(a) * culngint(b))
#define Int64ShllMod32(a,b) (culngint(a) shl (b))
#define Int64ShraMod32(a,b) (clngint(a) shr (b))
#define Int64ShrlMod32(a,b) (culngint(a) shr (b))

#define ANSI_NULL 0
#define UNICODE_NULL 0

type BOOLEAN as UBYTE
type PBOOLEAN as UBYTE ptr
type FCHAR as UBYTE
type FSHORT as WORD
type FLONG as DWORD

#include once "win/basetsd.bi"

#define APPLICATION_ERROR_MASK &h20000000
#define ERROR_SEVERITY_SUCCESS &h00000000
#define ERROR_SEVERITY_INFORMATIONAL &h40000000
#define ERROR_SEVERITY_WARNING &h80000000
#define ERROR_SEVERITY_ERROR &hC0000000
#define COMPRESSION_FORMAT_NONE (&h0000)
#define COMPRESSION_FORMAT_DEFAULT (&h0001)
#define COMPRESSION_FORMAT_LZNT1 (&h0002)
#define COMPRESSION_ENGINE_STANDARD (&h0000)
#define COMPRESSION_ENGINE_MAXIMUM (&h0100)
#define COMPRESSION_ENGINE_HIBER (&h0200)
#define ACCESS_ALLOWED_ACE_TYPE (&h0)
#define ACCESS_DENIED_ACE_TYPE (&h1)
#define SYSTEM_AUDIT_ACE_TYPE (&h2)
#define SYSTEM_ALARM_ACE_TYPE (&h3)
#define ANYSIZE_ARRAY 1
#define OBJECT_INHERIT_ACE 1
#define CONTAINER_INHERIT_ACE 2
#define NO_PROPAGATE_INHERIT_ACE 4
#define INHERIT_ONLY_ACE 8
#define VALID_INHERIT_FLAGS 16
#define SUCCESSFUL_ACCESS_ACE_FLAG 64
#define FAILED_ACCESS_ACE_FLAG 128
#define DELETE_ &h00010000L
#define READ_CONTROL &h20000L
#define WRITE_DAC &h40000L
#define WRITE_OWNER &h80000L
#define SYNCHRONIZE &h100000L
#define STANDARD_RIGHTS_REQUIRED &hF0000
#define STANDARD_RIGHTS_READ &h20000
#define STANDARD_RIGHTS_WRITE &h20000
#define STANDARD_RIGHTS_EXECUTE &h20000
#define STANDARD_RIGHTS_ALL &h1F0000
#define SPECIFIC_RIGHTS_ALL &hFFFF
#define ACCESS_SYSTEM_SECURITY &h1000000
#define MAXIMUM_ALLOWED &h2000000
#define GENERIC_READ &h80000000
#define GENERIC_WRITE &h40000000
#define GENERIC_EXECUTE &h20000000
#define GENERIC_ALL &h10000000
#define INVALID_FILE_ATTRIBUTES	cuint(-1)
#define FILE_LIST_DIRECTORY &h00000001
#define FILE_READ_DATA &h00000001
#define FILE_ADD_FILE &h00000002
#define FILE_WRITE_DATA &h00000002
#define FILE_ADD_SUBDIRECTORY &h00000004
#define FILE_APPEND_DATA &h00000004
#define FILE_CREATE_PIPE_INSTANCE &h00000004
#define FILE_READ_EA &h00000008
#define FILE_READ_PROPERTIES &h00000008
#define FILE_WRITE_EA &h00000010
#define FILE_WRITE_PROPERTIES &h00000010
#define FILE_EXECUTE &h00000020
#define FILE_TRAVERSE &h00000020
#define FILE_DELETE_CHILD &h00000040
#define FILE_READ_ATTRIBUTES &h00000080
#define FILE_WRITE_ATTRIBUTES &h00000100
#define FILE_SUPERSEDED &h00000000
#define FILE_OPENED &h00000001
#define FILE_CREATED &h00000002
#define FILE_OVERWRITTEN &h00000003
#define FILE_EXISTS &h00000004
#define FILE_DOES_NOT_EXIST &h00000005
#define FILE_SHARE_READ &h00000001
#define FILE_SHARE_WRITE &h00000002
#define FILE_SHARE_DELETE &h00000004
#define FILE_SHARE_VALID_FLAGS &h00000007
#define FILE_ATTRIBUTE_READONLY &h00000001
#define FILE_ATTRIBUTE_HIDDEN &h00000002
#define FILE_ATTRIBUTE_SYSTEM &h00000004
#define FILE_ATTRIBUTE_DIRECTORY &h00000010
#define FILE_ATTRIBUTE_ARCHIVE &h00000020
#define FILE_ATTRIBUTE_DEVICE &h00000040
#define FILE_ATTRIBUTE_NORMAL &h00000080
#define FILE_ATTRIBUTE_TEMPORARY &h00000100
#define FILE_ATTRIBUTE_SPARSE_FILE &h00000200
#define FILE_ATTRIBUTE_REPARSE_POINT &h00000400
#define FILE_ATTRIBUTE_COMPRESSED &h00000800
#define FILE_ATTRIBUTE_OFFLINE &h00001000
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED &h00002000
#define FILE_ATTRIBUTE_ENCRYPTED &h00004000
#define FILE_ATTRIBUTE_VALID_FLAGS &h00007fb7
#define FILE_ATTRIBUTE_VALID_SET_FLAGS &h000031a7
#define FILE_COPY_STRUCTURED_STORAGE &h00000041
#define FILE_STRUCTURED_STORAGE &h00000441
#define FILE_VALID_OPTION_FLAGS &h00ffffff
#define FILE_VALID_PIPE_OPTION_FLAGS &h00000032
#define FILE_VALID_MAILSLOT_OPTION_FLAGS &h00000032
#define FILE_VALID_SET_FLAGS &h00000036
#define FILE_SUPERSEDE &h00000000
#define FILE_OPEN &h00000001
#define FILE_CREATE &h00000002
#define FILE_OPEN_IF &h00000003
#define FILE_OVERWRITE &h00000004
#define FILE_OVERWRITE_IF &h00000005
#define FILE_MAXIMUM_DISPOSITION &h00000005
#define FILE_DIRECTORY_FILE &h00000001
#define FILE_WRITE_THROUGH &h00000002
#define FILE_SEQUENTIAL_ONLY &h00000004
#define FILE_NO_INTERMEDIATE_BUFFERING &h00000008
#define FILE_SYNCHRONOUS_IO_ALERT &h00000010
#define FILE_SYNCHRONOUS_IO_NONALERT &h00000020
#define FILE_NON_DIRECTORY_FILE &h00000040
#define FILE_CREATE_TREE_CONNECTION &h00000080
#define FILE_COMPLETE_IF_OPLOCKED &h00000100
#define FILE_NO_EA_KNOWLEDGE &h00000200
#define FILE_OPEN_FOR_RECOVERY &h00000400
#define FILE_RANDOM_ACCESS &h00000800
#define FILE_DELETE_ON_CLOSE &h00001000
#define FILE_OPEN_BY_FILE_ID &h00002000
#define FILE_OPEN_FOR_BACKUP_INTENT &h00004000
#define FILE_NO_COMPRESSION &h00008000
#define FILE_RESERVE_OPFILTER &h00100000
#define FILE_OPEN_REPARSE_POINT &h00200000
#define FILE_OPEN_NO_RECALL &h00400000
#define FILE_OPEN_FOR_FREE_SPACE_QUERY &h00800000
#define FILE_ALL_ACCESS (&hF0000 or &h100000L or &h1FF)
#define FILE_GENERIC_EXECUTE (&h20000 or &h00000080 or &h00000020 or &h100000L)
#define FILE_GENERIC_READ (&h20000 or &h00000001 or &h00000080 or &h00000008 or &h100000L)
#define FILE_GENERIC_WRITE (&h20000 or &h00000002 or &h00000100 or &h00000010 or &h00000004 or &h100000L)
#define FILE_NOTIFY_CHANGE_FILE_NAME &h00000001
#define FILE_NOTIFY_CHANGE_DIR_NAME &h00000002
#define FILE_NOTIFY_CHANGE_NAME &h00000003
#define FILE_NOTIFY_CHANGE_ATTRIBUTES &h00000004
#define FILE_NOTIFY_CHANGE_SIZE &h00000008
#define FILE_NOTIFY_CHANGE_LAST_WRITE &h00000010
#define FILE_NOTIFY_CHANGE_LAST_ACCESS &h00000020
#define FILE_NOTIFY_CHANGE_CREATION &h00000040
#define FILE_NOTIFY_CHANGE_EA &h00000080
#define FILE_NOTIFY_CHANGE_SECURITY &h00000100
#define FILE_NOTIFY_CHANGE_STREAM_NAME &h00000200
#define FILE_NOTIFY_CHANGE_STREAM_SIZE &h00000400
#define FILE_NOTIFY_CHANGE_STREAM_WRITE &h00000800
#define FILE_NOTIFY_VALID_MASK &h00000fff
#define FILE_CASE_SENSITIVE_SEARCH &h00000001
#define FILE_CASE_PRESERVED_NAMES &h00000002
#define FILE_UNICODE_ON_DISK &h00000004
#define FILE_PERSISTENT_ACLS &h00000008
#define FILE_FILE_COMPRESSION &h00000010
#define FILE_VOLUME_QUOTAS &h00000020
#define FILE_SUPPORTS_SPARSE_FILES &h00000040
#define FILE_SUPPORTS_REPARSE_POINTS &h00000080
#define FILE_SUPPORTS_REMOTE_STORAGE &h00000100
#define FS_LFN_APIS &h00004000
#define FILE_VOLUME_IS_COMPRESSED &h00008000
#define FILE_SUPPORTS_OBJECT_IDS &h00010000
#define FILE_SUPPORTS_ENCRYPTION &h00020000
#define FILE_NAMED_STREAMS &h00040000
#define IO_COMPLETION_QUERY_STATE &h0001
#define IO_COMPLETION_MODIFY_STATE &h0002
#define IO_COMPLETION_ALL_ACCESS (&hF0000 or &h100000L or &h3)
#define DUPLICATE_CLOSE_SOURCE &h00000001
#define DUPLICATE_SAME_ACCESS &h00000002
#define DUPLICATE_SAME_ATTRIBUTES &h00000004
#define MAILSLOT_NO_MESSAGE	cuint(-1)
#define MAILSLOT_WAIT_FOREVER cuint(-1)
#define PROCESS_TERMINATE 1
#define PROCESS_CREATE_THREAD 2
#define PROCESS_SET_SESSIONID 4
#define PROCESS_VM_OPERATION 8
#define PROCESS_VM_READ 16
#define PROCESS_VM_WRITE 32
#define PROCESS_DUP_HANDLE 64
#define PROCESS_CREATE_PROCESS 128
#define PROCESS_SET_QUOTA 256
#define PROCESS_SET_INFORMATION 512
#define PROCESS_QUERY_INFORMATION 1024
#define PROCESS_ALL_ACCESS (&hF0000 or &h100000L or &hFFF)
#define THREAD_TERMINATE 1
#define THREAD_SUSPEND_RESUME 2
#define THREAD_GET_CONTEXT 8
#define THREAD_SET_CONTEXT 16
#define THREAD_SET_INFORMATION 32
#define THREAD_QUERY_INFORMATION 64
#define THREAD_SET_THREAD_TOKEN 128
#define THREAD_IMPERSONATE 256
#define THREAD_DIRECT_IMPERSONATION &h200
#define THREAD_ALL_ACCESS (&hF0000 or &h100000L or &h3FF)
#define THREAD_BASE_PRIORITY_LOWRT 15
#define THREAD_BASE_PRIORITY_MAX 2
#define THREAD_BASE_PRIORITY_MIN (-2)
#define THREAD_BASE_PRIORITY_IDLE (-15)
#define EXCEPTION_NONCONTINUABLE 1
#define EXCEPTION_MAXIMUM_PARAMETERS 15
#define MUTANT_QUERY_STATE &h0001
#define MUTANT_ALL_ACCESS (&hF0000 or &h100000L or &h0001)
#define TIMER_QUERY_STATE &h0001
#define TIMER_MODIFY_STATE &h0002
#define TIMER_ALL_ACCESS (&hF0000 or &h100000L or &h0001 or &h0002)
#define SECURITY_NULL_SID_AUTHORITY	{0,0,0,0,0,0}
#define SECURITY_WORLD_SID_AUTHORITY	{0,0,0,0,0,1}
#define SECURITY_LOCAL_SID_AUTHORITY	{0,0,0,0,0,2}
#define SECURITY_CREATOR_SID_AUTHORITY	{0,0,0,0,0,3}
#define SECURITY_NON_UNIQUE_AUTHORITY	{0,0,0,0,0,4}
#define SECURITY_NT_AUTHORITY	{0,0,0,0,0,5}
#define SECURITY_NULL_RID 0
#define SECURITY_WORLD_RID (&h00000000L)
#define SECURITY_LOCAL_RID 0
#define SECURITY_CREATOR_OWNER_RID 0
#define SECURITY_CREATOR_GROUP_RID 1
#define SECURITY_DIALUP_RID 1
#define SECURITY_NETWORK_RID 2
#define SECURITY_BATCH_RID 3
#define SECURITY_INTERACTIVE_RID 4
#define SECURITY_LOGON_IDS_RID 5
#define SECURITY_SERVICE_RID 6
#define SECURITY_LOCAL_SYSTEM_RID 18
#define SECURITY_BUILTIN_DOMAIN_RID 32
#define SECURITY_PRINCIPAL_SELF_RID 10
#define SECURITY_CREATOR_OWNER_SERVER_RID &h2
#define SECURITY_CREATOR_GROUP_SERVER_RID &h3
#define SECURITY_LOGON_IDS_RID_COUNT &h3
#define SECURITY_ANONYMOUS_LOGON_RID &h7
#define SECURITY_PROXY_RID &h8
#define SECURITY_ENTERPRISE_CONTROLLERS_RID &h9
#define SECURITY_SERVER_LOGON_RID &h9
#define SECURITY_AUTHENTICATED_USER_RID &hB
#define SECURITY_RESTRICTED_CODE_RID &hC
#define SECURITY_NT_NON_UNIQUE_RID &h15
#define SID_REVISION 1
#define DOMAIN_USER_RID_ADMIN &h1F4L
#define DOMAIN_USER_RID_GUEST &h1F5L
#define DOMAIN_GROUP_RID_ADMINS &h200L
#define DOMAIN_GROUP_RID_USERS &h201L
#define DOMAIN_ALIAS_RID_ADMINS &h220L
#define DOMAIN_ALIAS_RID_USERS &h221L
#define DOMAIN_ALIAS_RID_GUESTS &h222L
#define DOMAIN_ALIAS_RID_POWER_USERS &h223L
#define DOMAIN_ALIAS_RID_ACCOUNT_OPS &h224L
#define DOMAIN_ALIAS_RID_SYSTEM_OPS &h225L
#define DOMAIN_ALIAS_RID_PRINT_OPS &h226L
#define DOMAIN_ALIAS_RID_BACKUP_OPS &h227L
#define DOMAIN_ALIAS_RID_REPLICATOR &h228L
#define SE_CREATE_TOKEN_NAME "SeCreateTokenPrivilege"
#define SE_ASSIGNPRIMARYTOKEN_NAME "SeAssignPrimaryTokenPrivilege"
#define SE_LOCK_MEMORY_NAME "SeLockMemoryPrivilege"
#define SE_INCREASE_QUOTA_NAME "SeIncreaseQuotaPrivilege"
#define SE_UNSOLICITED_INPUT_NAME "SeUnsolicitedInputPrivilege"
#define SE_MACHINE_ACCOUNT_NAME "SeMachineAccountPrivilege"
#define SE_TCB_NAME "SeTcbPrivilege"
#define SE_SECURITY_NAME "SeSecurityPrivilege"
#define SE_TAKE_OWNERSHIP_NAME "SeTakeOwnershipPrivilege"
#define SE_LOAD_DRIVER_NAME "SeLoadDriverPrivilege"
#define SE_SYSTEM_PROFILE_NAME "SeSystemProfilePrivilege"
#define SE_SYSTEMTIME_NAME "SeSystemtimePrivilege"
#define SE_PROF_SINGLE_PROCESS_NAME "SeProfileSingleProcessPrivilege"
#define SE_INC_BASE_PRIORITY_NAME "SeIncreaseBasePriorityPrivilege"
#define SE_CREATE_PAGEFILE_NAME "SeCreatePagefilePrivilege"
#define SE_CREATE_PERMANENT_NAME "SeCreatePermanentPrivilege"
#define SE_BACKUP_NAME "SeBackupPrivilege"
#define SE_RESTORE_NAME "SeRestorePrivilege"
#define SE_SHUTDOWN_NAME "SeShutdownPrivilege"
#define SE_DEBUG_NAME "SeDebugPrivilege"
#define SE_AUDIT_NAME "SeAuditPrivilege"
#define SE_SYSTEM_ENVIRONMENT_NAME "SeSystemEnvironmentPrivilege"
#define SE_CHANGE_NOTIFY_NAME "SeChangeNotifyPrivilege"
#define SE_REMOTE_SHUTDOWN_NAME "SeRemoteShutdownPrivilege"
#define SE_GROUP_MANDATORY 1
#define SE_GROUP_ENABLED_BY_DEFAULT 2
#define SE_GROUP_ENABLED 4
#define SE_GROUP_OWNER 8
#define SE_GROUP_USE_FOR_DENY_ONLY 16
#define SE_GROUP_LOGON_ID 3221225472U
#define SE_GROUP_RESOURCE 536870912
#define LANG_NEUTRAL &h00
#define LANG_ARABIC &h01
#define LANG_BULGARIAN &h02
#define LANG_CATALAN &h03
#define LANG_CHINESE &h04
#define LANG_CZECH &h05
#define LANG_DANISH &h06
#define LANG_GERMAN &h07
#define LANG_GREEK &h08
#define LANG_ENGLISH &h09
#define LANG_SPANISH &h0a
#define LANG_FINNISH &h&b
#define LANG_FRENCH &h0c
#define LANG_HEBREW &h0d
#define LANG_HUNGARIAN &h0e
#define LANG_ICELANDIC &h0f
#define LANG_ITALIAN &h10
#define LANG_JAPANESE &h11
#define LANG_KOREAN &h12
#define LANG_DUTCH &h13
#define LANG_NORWEGIAN &h14
#define LANG_POLISH &h15
#define LANG_PORTUGUESE &h16
#define LANG_ROMANIAN &h18
#define LANG_RUSSIAN &h19
#define LANG_CROATIAN &h1a
#define LANG_SERBIAN &h1a
#define LANG_SLOVAK &h1b
#define LANG_ALBANIAN &h1c
#define LANG_SWEDISH &h1d
#define LANG_THAI &h1e
#define LANG_TURKISH &h1f
#define LANG_URDU &h20
#define LANG_INDONESIAN &h21
#define LANG_UKRAINIAN &h22
#define LANG_BELARUSIAN &h23
#define LANG_SLOVENIAN &h24
#define LANG_ESTONIAN &h25
#define LANG_LATVIAN &h26
#define LANG_LITHUANIAN &h27
#define LANG_FARSI &h29
#define LANG_VIETNAMESE &h2a
#define LANG_ARMENIAN &h2b
#define LANG_AZERI &h2c
#define LANG_BASQUE &h2d
#define LANG_MACEDONIAN &h2f
#define LANG_AFRIKAANS &h36
#define LANG_GEORGIAN &h37
#define LANG_FAEROESE &h38
#define LANG_HINDI &h39
#define LANG_MALAY &h3e
#define LANG_KAZAK &h3f
#define LANG_KYRGYZ &h40
#define LANG_SWAHILI &h41
#define LANG_UZBEK &h43
#define LANG_TATAR &h44
#define LANG_BENGALI &h45
#define LANG_PUNJABI &h46
#define LANG_GUJARATI &h47
#define LANG_ORIYA &h48
#define LANG_TAMIL &h49
#define LANG_TELUGU &h4a
#define LANG_KANNADA &h4b
#define LANG_MALAYALAM &h4c
#define LANG_ASSAMESE &h4d
#define LANG_MARATHI &h4e
#define LANG_SANSKRIT &h4f
#define LANG_MONGOLIAN &h50
#define LANG_GALICIAN &h56
#define LANG_KONKANI &h57
#define LANG_MANIPURI &h58
#define LANG_SINDHI &h59
#define LANG_SYRIAC &h5a
#define LANG_KASHMIRI &h60
#define LANG_NEPALI &h61
#define LANG_DIVEHI &h65
#define LANG_INVARIANT &h7f
#define SUBLANG_NEUTRAL &h00
#define SUBLANG_DEFAULT &h01
#define SUBLANG_SYS_DEFAULT &h02
#define SUBLANG_ARABIC_SAUDI_ARABIA &h01
#define SUBLANG_ARABIC_IRAQ &h02
#define SUBLANG_ARABIC_EGYPT &h03
#define SUBLANG_ARABIC_LIBYA &h04
#define SUBLANG_ARABIC_ALGERIA &h05
#define SUBLANG_ARABIC_MOROCCO &h06
#define SUBLANG_ARABIC_TUNISIA &h07
#define SUBLANG_ARABIC_OMAN &h08
#define SUBLANG_ARABIC_YEMEN &h09
#define SUBLANG_ARABIC_SYRIA &h0a
#define SUBLANG_ARABIC_JORDAN &h&b
#define SUBLANG_ARABIC_LEBANON &h0c
#define SUBLANG_ARABIC_KUWAIT &h0d
#define SUBLANG_ARABIC_UAE &h0e
#define SUBLANG_ARABIC_BAHRAIN &h0f
#define SUBLANG_ARABIC_QATAR &h10
#define SUBLANG_AZERI_LATIN &h01
#define SUBLANG_AZERI_CYRILLIC &h02
#define SUBLANG_CHINESE_TRADITIONAL &h01
#define SUBLANG_CHINESE_SIMPLIFIED &h02
#define SUBLANG_CHINESE_HONGKONG &h03
#define SUBLANG_CHINESE_SINGAPORE &h04
#define SUBLANG_CHINESE_MACAU &h05
#define SUBLANG_DUTCH &h01
#define SUBLANG_DUTCH_BELGIAN &h02
#define SUBLANG_ENGLISH_US &h01
#define SUBLANG_ENGLISH_UK &h02
#define SUBLANG_ENGLISH_AUS &h03
#define SUBLANG_ENGLISH_CAN &h04
#define SUBLANG_ENGLISH_NZ &h05
#define SUBLANG_ENGLISH_EIRE &h06
#define SUBLANG_ENGLISH_SOUTH_AFRICA &h07
#define SUBLANG_ENGLISH_JAMAICA &h08
#define SUBLANG_ENGLISH_CARIBBEAN &h09
#define SUBLANG_ENGLISH_BELIZE &h0a
#define SUBLANG_ENGLISH_TRINIDAD &h&b
#define SUBLANG_ENGLISH_ZIMBABWE &h0c
#define SUBLANG_ENGLISH_PHILIPPINES &h0d
#define SUBLANG_FRENCH &h01
#define SUBLANG_FRENCH_BELGIAN &h02
#define SUBLANG_FRENCH_CANADIAN &h03
#define SUBLANG_FRENCH_SWISS &h04
#define SUBLANG_FRENCH_LUXEMBOURG &h05
#define SUBLANG_FRENCH_MONACO &h06
#define SUBLANG_GERMAN &h01
#define SUBLANG_GERMAN_SWISS &h02
#define SUBLANG_GERMAN_AUSTRIAN &h03
#define SUBLANG_GERMAN_LUXEMBOURG &h04
#define SUBLANG_GERMAN_LIECHTENSTEIN &h05
#define SUBLANG_ITALIAN &h01
#define SUBLANG_ITALIAN_SWISS &h02
#define SUBLANG_KASHMIRI_INDIA &h02
#define SUBLANG_KASHMIRI_SASIA &h02
#define SUBLANG_KOREAN &h01
#define SUBLANG_LITHUANIAN &h01
#define SUBLANG_MALAY_MALAYSIA &h01
#define SUBLANG_MALAY_BRUNEI_DARUSSALAM &h02
#define SUBLANG_NEPALI_INDIA &h02
#define SUBLANG_NORWEGIAN_BOKMAL &h01
#define SUBLANG_NORWEGIAN_NYNORSK &h02
#define SUBLANG_PORTUGUESE_BRAZILIAN &h01
#define SUBLANG_PORTUGUESE &h02
#define SUBLANG_SERBIAN_LATIN &h02
#define SUBLANG_SERBIAN_CYRILLIC &h03
#define SUBLANG_SPANISH &h01
#define SUBLANG_SPANISH_MEXICAN &h02
#define SUBLANG_SPANISH_MODERN &h03
#define SUBLANG_SPANISH_GUATEMALA &h04
#define SUBLANG_SPANISH_COSTA_RICA &h05
#define SUBLANG_SPANISH_PANAMA &h06
#define SUBLANG_SPANISH_DOMINICAN_REPUBLIC &h07
#define SUBLANG_SPANISH_VENEZUELA &h08
#define SUBLANG_SPANISH_COLOMBIA &h09
#define SUBLANG_SPANISH_PERU &h0a
#define SUBLANG_SPANISH_ARGENTINA &h&b
#define SUBLANG_SPANISH_ECUADOR &h0c
#define SUBLANG_SPANISH_CHILE &h0d
#define SUBLANG_SPANISH_URUGUAY &h0e
#define SUBLANG_SPANISH_PARAGUAY &h0f
#define SUBLANG_SPANISH_BOLIVIA &h10
#define SUBLANG_SPANISH_EL_SALVADOR &h11
#define SUBLANG_SPANISH_HONDURAS &h12
#define SUBLANG_SPANISH_NICARAGUA &h13
#define SUBLANG_SPANISH_PUERTO_RICO &h14
#define SUBLANG_SWEDISH &h01
#define SUBLANG_SWEDISH_FINLAND &h02
#define SUBLANG_URDU_PAKISTAN &h01
#define SUBLANG_URDU_INDIA &h02
#define SUBLANG_UZBEK_LATIN &h01
#define SUBLANG_UZBEK_CYRILLIC &h02
#define NLS_VALID_LOCALE_MASK 1048575
#define SORT_DEFAULT 0
#define SORT_JAPANESE_XJIS 0
#define SORT_JAPANESE_UNICODE 1
#define SORT_CHINESE_BIG5 0
#define SORT_CHINESE_PRCP 0
#define SORT_CHINESE_UNICODE 1
#define SORT_CHINESE_PRC 2
#define SORT_CHINESE_BOPOMOFO 3
#define SORT_KOREAN_KSC 0
#define SORT_KOREAN_UNICODE 1
#define SORT_GERMAN_PHONE_BOOK 1
#define SORT_HUNGARIAN_DEFAULT 0
#define SORT_HUNGARIAN_TECHNICAL 1
#define SORT_GEORGIAN_TRADITIONAL 0
#define SORT_GEORGIAN_MODERN 1

#define MAKELANGID(p,s)	((cushort(s) shl 10) or cushort(p))
#define MAKELCID(l,s) (cuint(((cuint(cushort(s))) shl 16) or (cuint(cushort(l)))))
#define PRIMARYLANGID(l)	(cushort(l) and &h3ff)
#define SORTIDFROMLCID(l)	(cushort(((cuint(l)) and NLS_VALID_LOCALE_MASK) shr 16))
#define SORTVERSIONFROMLCID(l) (cushort(((cuint(l)) shr 20) and &hf))
#define SUBLANGID(l)	(cushort(l) shr 10)
#define LANGIDFROMLCID(l)	(cushort(l))
#define LANG_SYSTEM_DEFAULT	MAKELANGID(LANG_NEUTRAL,SUBLANG_SYS_DEFAULT)
#define LANG_USER_DEFAULT	MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT)
#define LOCALE_NEUTRAL	MAKELCID(MAKELANGID(LANG_NEUTRAL,SUBLANG_NEUTRAL),SORT_DEFAULT)

#define ACL_REVISION 2
#define ACL_REVISION_DS 4
#define ACL_REVISION1 1
#define ACL_REVISION2 2
#define ACL_REVISION3 3
#define ACL_REVISION4 4
#define MIN_ACL_REVISION 2
#define MAX_ACL_REVISION 4
#define MINCHAR &h80
#define MAXCHAR &h7f
#define MINSHORT &h8000
#define MAXSHORT &h7fff
#define MINLONG &h80000000
#define MAXLONG &h7fffffff
#define MAXBYTE &hff
#define MAXWORD &hffff
#define MAXDWORD &hffffffff
#define PROCESSOR_INTEL_386 386
#define PROCESSOR_INTEL_486 486
#define PROCESSOR_INTEL_PENTIUM 586
#define PROCESSOR_MIPS_R4000 4000
#define PROCESSOR_ALPHA_21064 21064
#define PROCESSOR_INTEL_IA64 2200
#define PROCESSOR_ARCHITECTURE_INTEL 0
#define PROCESSOR_ARCHITECTURE_MIPS 1
#define PROCESSOR_ARCHITECTURE_ALPHA 2
#define PROCESSOR_ARCHITECTURE_PPC 3
#define PROCESSOR_ARCHITECTURE_SHX 4
#define PROCESSOR_ARCHITECTURE_ARM 5
#define PROCESSOR_ARCHITECTURE_IA64 6
#define PROCESSOR_ARCHITECTURE_ALPHA64 7
#define PROCESSOR_ARCHITECTURE_MSIL 8
#define PROCESSOR_ARCHITECTURE_AMD64 9
#define PROCESSOR_ARCHITECTURE_IA32_ON_WIN64 10
#define PROCESSOR_ARCHITECTURE_UNKNOWN &hFFFF
#define PF_FLOATING_POINT_PRECISION_ERRATA 0
#define PF_FLOATING_POINT_EMULATED 1
#define PF_COMPARE_EXCHANGE_DOUBLE 2
#define PF_MMX_INSTRUCTIONS_AVAILABLE 3
#define PF_PPC_MOVEMEM_64BIT_OK 4
#define PF_ALPHA_BYTE_INSTRUCTIONS 5
#define PF_XMMI_INSTRUCTIONS_AVAILABLE 6
#define PF_3DNOW_INSTRUCTIONS_AVAILABLE 7
#define PF_RDTSC_INSTRUCTION_AVAILABLE 8
#define PF_PAE_ENABLED 9
#define PF_XMMI64_INSTRUCTIONS_AVAILABLE 10
#define FILE_ACTION_ADDED &h00000001
#define FILE_ACTION_REMOVED &h00000002
#define FILE_ACTION_MODIFIED &h00000003
#define FILE_ACTION_RENAMED_OLD_NAME &h00000004
#define FILE_ACTION_RENAMED_NEW_NAME &h00000005
#define FILE_ACTION_ADDED_STREAM &h00000006
#define FILE_ACTION_REMOVED_STREAM &h00000007
#define FILE_ACTION_MODIFIED_STREAM &h00000008
#define FILE_ACTION_REMOVED_BY_DELETE &h00000009
#define FILE_ACTION_ID_NOT_TUNNELLED &h0000000A
#define FILE_ACTION_TUNNELLED_ID_COLLISION &h0000000B
#define HEAP_NO_SERIALIZE 1
#define HEAP_GROWABLE 2
#define HEAP_GENERATE_EXCEPTIONS 4
#define HEAP_ZERO_MEMORY 8
#define HEAP_REALLOC_IN_PLACE_ONLY 16
#define HEAP_TAIL_CHECKING_ENABLED 32
#define HEAP_FREE_CHECKING_ENABLED 64
#define HEAP_DISABLE_COALESCE_ON_FREE 128
#define HEAP_CREATE_ALIGN_16 &h0000
#define HEAP_CREATE_ENABLE_TRACING &h20000
#define HEAP_MAXIMUM_TAG &hFFF
#define HEAP_PSEUDO_TAG_FLAG &h8000
#define HEAP_TAG_SHIFT 16
#define HEAP_MAKE_TAG_FLAGS(b,o) cuint((b)+(o) shl 16)
#define KEY_QUERY_VALUE 1
#define KEY_SET_VALUE 2
#define KEY_CREATE_SUB_KEY 4
#define KEY_ENUMERATE_SUB_KEYS 8
#define KEY_NOTIFY 16
#define KEY_CREATE_LINK 32
#define KEY_WRITE &h20006
#define KEY_EXECUTE &h20019
#define KEY_READ &h20019
#define KEY_ALL_ACCESS &hf003f
#define REG_WHOLE_HIVE_VOLATILE 1
#define REG_REFRESH_HIVE 2
#define REG_NO_LAZY_FLUSH 4
#define REG_OPTION_RESERVED 0
#define REG_OPTION_NON_VOLATILE 0
#define REG_OPTION_VOLATILE 1
#define REG_OPTION_CREATE_LINK 2
#define REG_OPTION_BACKUP_RESTORE 4
#define REG_OPTION_OPEN_LINK 8
#define REG_LEGAL_OPTION 15
#define OWNER_SECURITY_INFORMATION 1
#define GROUP_SECURITY_INFORMATION 2
#define DACL_SECURITY_INFORMATION 4
#define SACL_SECURITY_INFORMATION 8
#define MAXIMUM_PROCESSORS 32
#define PAGE_NOACCESS &h0001
#define PAGE_READONLY &h0002
#define PAGE_READWRITE &h0004
#define PAGE_WRITECOPY &h0008
#define PAGE_EXECUTE &h0010
#define PAGE_EXECUTE_READ &h0020
#define PAGE_EXECUTE_READWRITE &h0040
#define PAGE_EXECUTE_WRITECOPY &h0080
#define PAGE_GUARD &h0100
#define PAGE_NOCACHE &h0200
#define MEM_COMMIT &h1000
#define MEM_RESERVE &h2000
#define MEM_DECOMMIT &h4000
#define MEM_RELEASE &h8000
#define MEM_FREE &h10000
#define MEM_PRIVATE &h20000
#define MEM_MAPPED &h40000
#define MEM_RESET &h80000
#define MEM_TOP_DOWN &h100000
#define MEM_WRITE_WATCH &h200000
#define MEM_PHYSICAL &h400000
#define MEM_4MB_PAGES &h80000000
#define SEC_BASED &h00200000
#define SEC_NO_CHANGE &h00400000
#define SEC_FILE &h00800000
#define SEC_IMAGE &h01000000
#define SEC_VLM &h02000000
#define SEC_RESERVE &h04000000
#define SEC_COMMIT &h08000000
#define SEC_NOCACHE &h10000000
#define SECTION_EXTEND_SIZE 16
#define SECTION_MAP_READ 4
#define SECTION_MAP_WRITE 2
#define SECTION_QUERY 1
#define SECTION_MAP_EXECUTE 8
#define SECTION_ALL_ACCESS &hf001f
#define MESSAGE_RESOURCE_UNICODE 1
#define RTL_CRITSECT_TYPE 0
#define RTL_RESOURCE_TYPE 1
#define FIELD_OFFSET(t,f) offsetof(t,f)
#define IMAGE_SIZEOF_FILE_HEADER 20
#define IMAGE_FILE_RELOCS_STRIPPED 1
#define IMAGE_FILE_EXECUTABLE_IMAGE 2
#define IMAGE_FILE_LINE_NUMS_STRIPPED 4
#define IMAGE_FILE_LOCAL_SYMS_STRIPPED 8
#define IMAGE_FILE_AGGRESIVE_WS_TRIM 16
#define IMAGE_FILE_LARGE_ADDRESS_AWARE 32
#define IMAGE_FILE_BYTES_REVERSED_LO 128
#define IMAGE_FILE_32BIT_MACHINE 256
#define IMAGE_FILE_DEBUG_STRIPPED 512
#define IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP 1024
#define IMAGE_FILE_NET_RUN_FROM_SWAP 2048
#define IMAGE_FILE_SYSTEM 4096
#define IMAGE_FILE_DLL 8192
#define IMAGE_FILE_UP_SYSTEM_ONLY 16384
#define IMAGE_FILE_BYTES_REVERSED_HI 32768
#define IMAGE_FILE_MACHINE_UNKNOWN 0
#define IMAGE_FILE_MACHINE_I386 332
#define IMAGE_FILE_MACHINE_R3000 354
#define IMAGE_FILE_MACHINE_R4000 358
#define IMAGE_FILE_MACHINE_R10000 360
#define IMAGE_FILE_MACHINE_ALPHA 388
#define IMAGE_FILE_MACHINE_POWERPC 496
#define IMAGE_DOS_SIGNATURE &h5A4D
#define IMAGE_OS2_SIGNATURE &h454E
#define IMAGE_OS2_SIGNATURE_LE &h454C
#define IMAGE_VXD_SIGNATURE &h454C
#define IMAGE_NT_SIGNATURE &h00004550
#define IMAGE_NT_OPTIONAL_HDR_MAGIC &h1&b
#define IMAGE_ROM_OPTIONAL_HDR_MAGIC &h107
#define IMAGE_SEPARATE_DEBUG_SIGNATURE &h4944
#define IMAGE_NUMBEROF_DIRECTORY_ENTRIES 16
#define IMAGE_SIZEOF_ROM_OPTIONAL_HEADER 56
#define IMAGE_SIZEOF_STD_OPTIONAL_HEADER 28
#define IMAGE_SIZEOF_NT_OPTIONAL_HEADER 224
#define IMAGE_SIZEOF_SHORT_NAME 8
#define IMAGE_SIZEOF_SECTION_HEADER 40
#define IMAGE_SIZEOF_SYMBOL 18
#define IMAGE_SIZEOF_AUX_SYMBOL 18
#define IMAGE_SIZEOF_RELOCATION 10
#define IMAGE_SIZEOF_BASE_RELOCATION 8
#define IMAGE_SIZEOF_LINENUMBER 6
#define IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR 60
#define SIZEOF_RFPO_DATA 16
#define IMAGE_SUBSYSTEM_UNKNOWN 0
#define IMAGE_SUBSYSTEM_NATIVE 1
#define IMAGE_SUBSYSTEM_WINDOWS_GUI 2
#define IMAGE_SUBSYSTEM_WINDOWS_CUI 3
#define IMAGE_SUBSYSTEM_OS2_CUI 5
#define IMAGE_SUBSYSTEM_POSIX_CUI 7
#define IMAGE_SUBSYSTEM_XBOX 14
#define IMAGE_FIRST_SECTION(h) cptr(PIMAGE_SECTION_HEADER, cuint(h)+FIELD_OFFSET(IMAGE_NT_HEADERS,OptionalHeader)+cptr(PIMAGE_NT_HEADERS,h)->FileHeader.SizeOfOptionalHeader)
#define IMAGE_DIRECTORY_ENTRY_EXPORT 0
#define IMAGE_DIRECTORY_ENTRY_IMPORT 1
#define IMAGE_DIRECTORY_ENTRY_RESOURCE 2
#define IMAGE_DIRECTORY_ENTRY_EXCEPTION 3
#define IMAGE_DIRECTORY_ENTRY_SECURITY 4
#define IMAGE_DIRECTORY_ENTRY_BASERELOC 5
#define IMAGE_DIRECTORY_ENTRY_DEBUG 6
#define IMAGE_DIRECTORY_ENTRY_COPYRIGHT 7
#define IMAGE_DIRECTORY_ENTRY_GLOBALPTR 8
#define IMAGE_DIRECTORY_ENTRY_TLS 9
#define IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG 10
#define IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT 11
#define IMAGE_DIRECTORY_ENTRY_IAT 12
#define IMAGE_SCN_TYPE_NO_PAD 8
#define IMAGE_SCN_CNT_CODE 32
#define IMAGE_SCN_CNT_INITIALIZED_DATA 64
#define IMAGE_SCN_CNT_UNINITIALIZED_DATA 128
#define IMAGE_SCN_LNK_OTHER 256
#define IMAGE_SCN_LNK_INFO 512
#define IMAGE_SCN_LNK_REMOVE 2048
#define IMAGE_SCN_LNK_COMDAT 4096
#define IMAGE_SCN_MEM_FARDATA &h8000
#define IMAGE_SCN_MEM_PURGEABLE &h20000
#define IMAGE_SCN_MEM_16BIT &h20000
#define IMAGE_SCN_MEM_LOCKED &h40000
#define IMAGE_SCN_MEM_PRELOAD &h80000
#define IMAGE_SCN_ALIGN_1BYTES &h100000
#define IMAGE_SCN_ALIGN_2BYTES &h200000
#define IMAGE_SCN_ALIGN_4BYTES &h300000
#define IMAGE_SCN_ALIGN_8BYTES &h400000
#define IMAGE_SCN_ALIGN_16BYTES &h500000
#define IMAGE_SCN_ALIGN_32BYTES &h600000
#define IMAGE_SCN_ALIGN_64BYTES &h700000
#define IMAGE_SCN_LNK_NRELOC_OVFL &h1000000
#define IMAGE_SCN_MEM_DISCARDABLE &h2000000
#define IMAGE_SCN_MEM_NOT_CACHED &h4000000
#define IMAGE_SCN_MEM_NOT_PAGED &h8000000
#define IMAGE_SCN_MEM_SHARED &h10000000
#define IMAGE_SCN_MEM_EXECUTE &h20000000
#define IMAGE_SCN_MEM_READ &h40000000
#define IMAGE_SCN_MEM_WRITE &h80000000
#define IMAGE_SYM_UNDEFINED 0
#define IMAGE_SYM_ABSOLUTE (-1)
#define IMAGE_SYM_DEBUG (-2)
#define IMAGE_SYM_TYPE_NULL 0
#define IMAGE_SYM_TYPE_VOID 1
#define IMAGE_SYM_TYPE_CHAR 2
#define IMAGE_SYM_TYPE_SHORT 3
#define IMAGE_SYM_TYPE_INT 4
#define IMAGE_SYM_TYPE_LONG 5
#define IMAGE_SYM_TYPE_FLOAT 6
#define IMAGE_SYM_TYPE_DOUBLE 7
#define IMAGE_SYM_TYPE_STRUCT 8
#define IMAGE_SYM_TYPE_UNION 9
#define IMAGE_SYM_TYPE_ENUM 10
#define IMAGE_SYM_TYPE_MOE 11
#define IMAGE_SYM_TYPE_BYTE 12
#define IMAGE_SYM_TYPE_WORD 13
#define IMAGE_SYM_TYPE_UINT 14
#define IMAGE_SYM_TYPE_DWORD 15
#define IMAGE_SYM_TYPE_PCODE 32768
#define IMAGE_SYM_DTYPE_NULL 0
#define IMAGE_SYM_DTYPE_POINTER 1
#define IMAGE_SYM_DTYPE_FUNCTION 2
#define IMAGE_SYM_DTYPE_ARRAY 3
#define IMAGE_SYM_CLASS_END_OF_FUNCTION (-1)
#define IMAGE_SYM_CLASS_NULL 0
#define IMAGE_SYM_CLASS_AUTOMATIC 1
#define IMAGE_SYM_CLASS_EXTERNAL 2
#define IMAGE_SYM_CLASS_STATIC 3
#define IMAGE_SYM_CLASS_REGISTER 4
#define IMAGE_SYM_CLASS_EXTERNAL_DEF 5
#define IMAGE_SYM_CLASS_LABEL 6
#define IMAGE_SYM_CLASS_UNDEFINED_LABEL 7
#define IMAGE_SYM_CLASS_MEMBER_OF_STRUCT 8
#define IMAGE_SYM_CLASS_ARGUMENT 9
#define IMAGE_SYM_CLASS_STRUCT_TAG 10
#define IMAGE_SYM_CLASS_MEMBER_OF_UNION 11
#define IMAGE_SYM_CLASS_UNION_TAG 12
#define IMAGE_SYM_CLASS_TYPE_DEFINITION 13
#define IMAGE_SYM_CLASS_UNDEFINED_STATIC 14
#define IMAGE_SYM_CLASS_ENUM_TAG 15
#define IMAGE_SYM_CLASS_MEMBER_OF_ENUM 16
#define IMAGE_SYM_CLASS_REGISTER_PARAM 17
#define IMAGE_SYM_CLASS_BIT_FIELD 18
#define IMAGE_SYM_CLASS_FAR_EXTERNAL 68
#define IMAGE_SYM_CLASS_BLOCK 100
#define IMAGE_SYM_CLASS_FUNCTION 101
#define IMAGE_SYM_CLASS_END_OF_STRUCT 102
#define IMAGE_SYM_CLASS_FILE 103
#define IMAGE_SYM_CLASS_SECTION 104
#define IMAGE_SYM_CLASS_WEAK_EXTERNAL 105
#define IMAGE_COMDAT_SELECT_NODUPLICATES 1
#define IMAGE_COMDAT_SELECT_ANY 2
#define IMAGE_COMDAT_SELECT_SAME_SIZE 3
#define IMAGE_COMDAT_SELECT_EXACT_MATCH 4
#define IMAGE_COMDAT_SELECT_ASSOCIATIVE 5
#define IMAGE_COMDAT_SELECT_LARGEST 6
#define IMAGE_COMDAT_SELECT_NEWEST 7
#define IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY 1
#define IMAGE_WEAK_EXTERN_SEARCH_LIBRARY 2
#define IMAGE_WEAK_EXTERN_SEARCH_ALIAS 3
#define IMAGE_REL_I386_ABSOLUTE 0
#define IMAGE_REL_I386_DIR16 1
#define IMAGE_REL_I386_REL16 2
#define IMAGE_REL_I386_DIR32 6
#define IMAGE_REL_I386_DIR32NB 7
#define IMAGE_REL_I386_SEG12 9
#define IMAGE_REL_I386_SECTION 10
#define IMAGE_REL_I386_SECREL 11
#define IMAGE_REL_I386_REL32 20
#define IMAGE_REL_MIPS_ABSOLUTE 0
#define IMAGE_REL_MIPS_REFHALF 1
#define IMAGE_REL_MIPS_REFWORD 2
#define IMAGE_REL_MIPS_JMPADDR 3
#define IMAGE_REL_MIPS_REFHI 4
#define IMAGE_REL_MIPS_REFLO 5
#define IMAGE_REL_MIPS_GPREL 6
#define IMAGE_REL_MIPS_LITERAL 7
#define IMAGE_REL_MIPS_SECTION 10
#define IMAGE_REL_MIPS_SECREL 11
#define IMAGE_REL_MIPS_SECRELLO 12
#define IMAGE_REL_MIPS_SECRELHI 13
#define IMAGE_REL_MIPS_REFWORDNB 34
#define IMAGE_REL_MIPS_PAIR 35
#define IMAGE_REL_ALPHA_ABSOLUTE 0
#define IMAGE_REL_ALPHA_REFLONG 1
#define IMAGE_REL_ALPHA_REFQUAD 2
#define IMAGE_REL_ALPHA_GPREL32 3
#define IMAGE_REL_ALPHA_LITERAL 4
#define IMAGE_REL_ALPHA_LITUSE 5
#define IMAGE_REL_ALPHA_GPDISP 6
#define IMAGE_REL_ALPHA_BRADDR 7
#define IMAGE_REL_ALPHA_HINT 8
#define IMAGE_REL_ALPHA_INLINE_REFLONG 9
#define IMAGE_REL_ALPHA_REFHI 10
#define IMAGE_REL_ALPHA_REFLO 11
#define IMAGE_REL_ALPHA_PAIR 12
#define IMAGE_REL_ALPHA_MATCH 13
#define IMAGE_REL_ALPHA_SECTION 14
#define IMAGE_REL_ALPHA_SECREL 15
#define IMAGE_REL_ALPHA_REFLONGNB 16
#define IMAGE_REL_ALPHA_SECRELLO 17
#define IMAGE_REL_ALPHA_SECRELHI 18
#define IMAGE_REL_PPC_ABSOLUTE 0
#define IMAGE_REL_PPC_ADDR64 1
#define IMAGE_REL_PPC_ADDR32 2
#define IMAGE_REL_PPC_ADDR24 3
#define IMAGE_REL_PPC_ADDR16 4
#define IMAGE_REL_PPC_ADDR14 5
#define IMAGE_REL_PPC_REL24 6
#define IMAGE_REL_PPC_REL14 7
#define IMAGE_REL_PPC_TOCREL16 8
#define IMAGE_REL_PPC_TOCREL14 9
#define IMAGE_REL_PPC_ADDR32NB 10
#define IMAGE_REL_PPC_SECREL 11
#define IMAGE_REL_PPC_SECTION 12
#define IMAGE_REL_PPC_IFGLUE 13
#define IMAGE_REL_PPC_IMGLUE 14
#define IMAGE_REL_PPC_SECREL16 15
#define IMAGE_REL_PPC_REFHI 16
#define IMAGE_REL_PPC_REFLO 17
#define IMAGE_REL_PPC_PAIR 18
#define IMAGE_REL_PPC_TYPEMASK 255
#define IMAGE_REL_PPC_NEG 256
#define IMAGE_REL_PPC_BRTAKEN 512
#define IMAGE_REL_PPC_BRNTAKEN 1024
#define IMAGE_REL_PPC_TOCDEFN 2048
#define IMAGE_REL_BASED_ABSOLUTE 0
#define IMAGE_REL_BASED_HIGH 1
#define IMAGE_REL_BASED_LOW 2
#define IMAGE_REL_BASED_HIGHLOW 3
#define IMAGE_REL_BASED_HIGHADJ 4
#define IMAGE_REL_BASED_MIPS_JMPADDR 5
#define IMAGE_ARCHIVE_START_SIZE 8
#define IMAGE_ARCHIVE_START "!<arch>"
#if __FB_OPTION_ESCAPE__
#define IMAGE_ARCHIVE_END "`\n"
#define IMAGE_ARCHIVE_PAD "\n"
#else
#define IMAGE_ARCHIVE_END "`" + chr( 10 )
#define IMAGE_ARCHIVE_PAD chr( 10 )
#endif
#define IMAGE_ARCHIVE_LINKER_MEMBER "/               "
#define IMAGE_ARCHIVE_LONGNAMES_MEMBER "//              "
#define IMAGE_ORDINAL_FLAG32 &h80000000
#define IMAGE_ORDINAL_FLAG64 &h8000000000000000ULL
#define IMAGE_ORDINAL_FLAG &h80000000
#define IMAGE_SNAP_BY_ORDINAL(o) ((o and IMAGE_ORDINAL_FLAG) <> 0)
#define IMAGE_ORDINAL(o) (o and &hffff)
#define IMAGE_RESOURCE_NAME_IS_STRING &h80000000
#define IMAGE_RESOURCE_DATA_IS_DIRECTORY &h80000000
#define IMAGE_DEBUG_TYPE_UNKNOWN 0
#define IMAGE_DEBUG_TYPE_COFF 1
#define IMAGE_DEBUG_TYPE_CODEVIEW 2
#define IMAGE_DEBUG_TYPE_FPO 3
#define IMAGE_DEBUG_TYPE_MISC 4
#define IMAGE_DEBUG_TYPE_EXCEPTION 5
#define IMAGE_DEBUG_TYPE_FIXUP 6
#define IMAGE_DEBUG_TYPE_OMAP_TO_SRC 7
#define IMAGE_DEBUG_TYPE_OMAP_FROM_SRC 8
#define FRAME_FPO 0
#define FRAME_TRAP 1
#define FRAME_TSS 2
#define FRAME_NONFPO 3
#define IMAGE_DEBUG_MISC_EXENAME 1
#define N_BTMASK &h000F
#define N_TMASK &h0030
#define N_TMASK1 &h00C0
#define N_TMASK2 &h00F0
#define N_BTSHFT 4
#define N_TSHIFT 2
#define IS_TEXT_UNICODE_ASCII16 1
#define IS_TEXT_UNICODE_REVERSE_ASCII16 16
#define IS_TEXT_UNICODE_STATISTICS 2
#define IS_TEXT_UNICODE_REVERSE_STATISTICS 32
#define IS_TEXT_UNICODE_CONTROLS 4
#define IS_TEXT_UNICODE_REVERSE_CONTROLS 64
#define IS_TEXT_UNICODE_SIGNATURE 8
#define IS_TEXT_UNICODE_REVERSE_SIGNATURE 128
#define IS_TEXT_UNICODE_ILLEGAL_CHARS 256
#define IS_TEXT_UNICODE_ODD_LENGTH 512
#define IS_TEXT_UNICODE_NULL_BYTES 4096
#define IS_TEXT_UNICODE_UNICODE_MASK 15
#define IS_TEXT_UNICODE_REVERSE_MASK 240
#define IS_TEXT_UNICODE_NOT_UNICODE_MASK 3840
#define IS_TEXT_UNICODE_NOT_ASCII_MASK 61440
#define SERVICE_KERNEL_DRIVER 1
#define SERVICE_FILE_SYSTEM_DRIVER 2
#define SERVICE_ADAPTER 4
#define SERVICE_RECOGNIZER_DRIVER 8
#define SERVICE_DRIVER (1 or 2 or 8)
#define SERVICE_WIN32_OWN_PROCESS 16
#define SERVICE_WIN32_SHARE_PROCESS 32
#define SERVICE_WIN32 (16 or 32)
#define SERVICE_INTERACTIVE_PROCESS 256
#define SERVICE_TYPE_ALL ((16 or 32) or 4 or (1 or 2 or 8) or 256)
#define SERVICE_BOOT_START 0
#define SERVICE_SYSTEM_START 1
#define SERVICE_AUTO_START 2
#define SERVICE_DEMAND_START 3
#define SERVICE_DISABLED 4
#define SERVICE_ERROR_IGNORE 0
#define SERVICE_ERROR_NORMAL 1
#define SERVICE_ERROR_SEVERE 2
#define SERVICE_ERROR_CRITICAL 3
#define SE_OWNER_DEFAULTED 1
#define SE_GROUP_DEFAULTED 2
#define SE_DACL_PRESENT 4
#define SE_DACL_DEFAULTED 8
#define SE_SACL_PRESENT 16
#define SE_SACL_DEFAULTED 32
#define SE_DACL_AUTO_INHERIT_REQ 256
#define SE_SACL_AUTO_INHERIT_REQ 512
#define SE_DACL_AUTO_INHERITED 1024
#define SE_SACL_AUTO_INHERITED 2048
#define SE_DACL_PROTECTED 4096
#define SE_SACL_PROTECTED 8192
#define SE_SELF_RELATIVE &h8000
#define SECURITY_DESCRIPTOR_MIN_LENGTH 20
#define SECURITY_DESCRIPTOR_REVISION 1
#define SECURITY_DESCRIPTOR_REVISION1 1
#define SE_PRIVILEGE_ENABLED_BY_DEFAULT 1
#define SE_PRIVILEGE_ENABLED 2
#define SE_PRIVILEGE_USED_FOR_ACCESS &h80000000
#define PRIVILEGE_SET_ALL_NECESSARY 1
#define SECURITY_MAX_IMPERSONATION_LEVEL SecurityDelegation
#define DEFAULT_IMPERSONATION_LEVEL SecurityImpersonation
#define SECURITY_DYNAMIC_TRACKING 1
#define SECURITY_STATIC_TRACKING 0
#define TOKEN_ASSIGN_PRIMARY (&h0001)
#define TOKEN_DUPLICATE (&h0002)
#define TOKEN_IMPERSONATE (&h0004)
#define TOKEN_QUERY (&h0008)
#define TOKEN_QUERY_SOURCE (&h0010)
#define TOKEN_ADJUST_PRIVILEGES (&h0020)
#define TOKEN_ADJUST_GROUPS (&h0040)
#define TOKEN_ADJUST_DEFAULT (&h0080)
#define TOKEN_ALL_ACCESS (&hF0000 or (&h0001) or (&h0002) or (&h0004) or (&h0008) or (&h0010) or (&h0020) or (&h0040) or (&h0080))
#define TOKEN_READ (&h20000 or (&h0008))
#define TOKEN_WRITE (&h20000 or (&h0020) or (&h0040) or (&h0080))
#define TOKEN_EXECUTE (&h20000)
#define TOKEN_SOURCE_LENGTH 8
#define DLL_PROCESS_DETACH 0
#define DLL_PROCESS_ATTACH 1
#define DLL_THREAD_ATTACH 2
#define DLL_THREAD_DETACH 3
#define DBG_CONTINUE &h10002
#define DBG_TERMINATE_THREAD &h40010003
#define DBG_TERMINATE_PROCESS &h40010004
#define DBG_CONTROL_C &h40010005
#define DBG_CONTROL_BREAK &h40010008
#define DBG_EXCEPTION_NOT_HANDLED &h80010001
#define TAPE_ABSOLUTE_POSITION 0
#define TAPE_LOGICAL_POSITION 1
#define TAPE_PSEUDO_LOGICAL_POSITION 2
#define TAPE_REWIND 0
#define TAPE_ABSOLUTE_BLOCK 1
#define TAPE_LOGICAL_BLOCK 2
#define TAPE_PSEUDO_LOGICAL_BLOCK 3
#define TAPE_SPACE_END_OF_DATA 4
#define TAPE_SPACE_RELATIVE_BLOCKS 5
#define TAPE_SPACE_FILEMARKS 6
#define TAPE_SPACE_SEQUENTIAL_FMKS 7
#define TAPE_SPACE_SETMARKS 8
#define TAPE_SPACE_SEQUENTIAL_SMKS 9
#define TAPE_DRIVE_FIXED 1
#define TAPE_DRIVE_SELECT 2
#define TAPE_DRIVE_INITIATOR 4
#define TAPE_DRIVE_ERASE_SHORT 16
#define TAPE_DRIVE_ERASE_LONG 32
#define TAPE_DRIVE_ERASE_BOP_ONLY 64
#define TAPE_DRIVE_ERASE_IMMEDIATE 128
#define TAPE_DRIVE_TAPE_CAPACITY 256
#define TAPE_DRIVE_TAPE_REMAINING 512
#define TAPE_DRIVE_FIXED_BLOCK 1024
#define TAPE_DRIVE_VARIABLE_BLOCK 2048
#define TAPE_DRIVE_WRITE_PROTECT 4096
#define TAPE_DRIVE_EOT_WZ_SIZE 8192
#define TAPE_DRIVE_ECC &h10000
#define TAPE_DRIVE_COMPRESSION &h20000
#define TAPE_DRIVE_PADDING &h40000
#define TAPE_DRIVE_REPORT_SMKS &h80000
#define TAPE_DRIVE_GET_ABSOLUTE_BLK &h100000
#define TAPE_DRIVE_GET_LOGICAL_BLK &h200000
#define TAPE_DRIVE_SET_EOT_WZ_SIZE &h400000
#define TAPE_DRIVE_EJECT_MEDIA &h1000000
#define TAPE_DRIVE_CLEAN_REQUESTS &h2000000
#define TAPE_DRIVE_SET_CMP_BOP_ONLY &h4000000
#define TAPE_DRIVE_RESERVED_BIT &h80000000
#define TAPE_DRIVE_LOAD_UNLOAD &h80000001
#define TAPE_DRIVE_TENSION &h80000002
#define TAPE_DRIVE_LOCK_UNLOCK &h80000004
#define TAPE_DRIVE_REWIND_IMMEDIATE &h80000008
#define TAPE_DRIVE_SET_BLOCK_SIZE &h80000010
#define TAPE_DRIVE_LOAD_UNLD_IMMED &h80000020
#define TAPE_DRIVE_TENSION_IMMED &h80000040
#define TAPE_DRIVE_LOCK_UNLK_IMMED &h80000080
#define TAPE_DRIVE_SET_ECC &h80000100
#define TAPE_DRIVE_SET_COMPRESSION &h80000200
#define TAPE_DRIVE_SET_PADDING &h80000400
#define TAPE_DRIVE_SET_REPORT_SMKS &h80000800
#define TAPE_DRIVE_ABSOLUTE_BLK &h80001000
#define TAPE_DRIVE_ABS_BLK_IMMED &h80002000
#define TAPE_DRIVE_LOGICAL_BLK &h80004000
#define TAPE_DRIVE_LOG_BLK_IMMED &h80008000
#define TAPE_DRIVE_END_OF_DATA &h80010000
#define TAPE_DRIVE_RELATIVE_BLKS &h80020000
#define TAPE_DRIVE_FILEMARKS &h80040000
#define TAPE_DRIVE_SEQUENTIAL_FMKS &h80080000
#define TAPE_DRIVE_SETMARKS &h80100000
#define TAPE_DRIVE_SEQUENTIAL_SMKS &h80200000
#define TAPE_DRIVE_REVERSE_POSITION &h80400000
#define TAPE_DRIVE_SPACE_IMMEDIATE &h80800000
#define TAPE_DRIVE_WRITE_SETMARKS &h81000000
#define TAPE_DRIVE_WRITE_FILEMARKS &h82000000
#define TAPE_DRIVE_WRITE_SHORT_FMKS &h84000000
#define TAPE_DRIVE_WRITE_LONG_FMKS &h88000000
#define TAPE_DRIVE_WRITE_MARK_IMMED &h90000000
#define TAPE_DRIVE_FORMAT &hA0000000
#define TAPE_DRIVE_FORMAT_IMMEDIATE &hC0000000
#define TAPE_DRIVE_HIGH_FEATURES &h80000000
#define TAPE_FIXED_PARTITIONS 0
#define TAPE_INITIATOR_PARTITIONS 2
#define TAPE_SELECT_PARTITIONS 1
#define TAPE_FILEMARKS 1
#define TAPE_LONG_FILEMARKS 3
#define TAPE_SETMARKS 0
#define TAPE_SHORT_FILEMARKS 2
#define TAPE_ERASE_LONG 1
#define TAPE_ERASE_SHORT 0
#define TAPE_LOAD 0
#define TAPE_UNLOAD 1
#define TAPE_TENSION 2
#define TAPE_LOCK 3
#define TAPE_UNLOCK 4
#define TAPE_FORMAT 5
#define VER_MINORVERSION &h0000001
#define VER_MAJORVERSION &h0000002
#define VER_BUILDNUMBER &h0000004
#define VER_PLATFORMID &h0000008
#define VER_SERVICEPACKMINOR &h0000010
#define VER_SERVICEPACKMAJOR &h0000020
#define VER_SUITENAME &h0000040
#define VER_PRODUCT_TYPE &h0000080
#define VER_EQUAL 1
#define VER_GREATER 2
#define VER_GREATER_EQUAL 3
#define VER_LESS 4
#define VER_LESS_EQUAL 5
#define VER_AND 6
#define VER_OR 7
#define VER_PLATFORM_WIN32s 0
#define VER_PLATFORM_WIN32_WINDOWS 1
#define VER_PLATFORM_WIN32_NT 2
#define VER_NT_WORKSTATION 1
#define VER_NT_DOMAIN_CONTROLLER 2
#define VER_NT_SERVER 3
#define VER_SUITE_SMALLBUSINESS 1
#define VER_SUITE_ENTERPRISE 2
#define VER_SUITE_BACKOFFICE 4
#define VER_SUITE_TERMINAL 16
#define VER_SUITE_SMALLBUSINESS_RESTRICTED 32
#define VER_SUITE_DATACENTER 128
#define VER_SUITE_PERSONAL 512
#define VER_SUITE_BLADE 1024
#define BTYPE(x) ((x) and N_BTMASK)
#define ISPTR(x) (((x) and N_TMASK)=(IMAGE_SYM_DTYPE_POINTER shl N_BTSHFT))
#define ISFCN(x) (((x) and N_TMASK)=(IMAGE_SYM_DTYPE_FUNCTION shl N_BTSHFT))
#define ISARY(x) (((x) and N_TMASK)=(IMAGE_SYM_DTYPE_ARRAY shl N_BTSHFT))
#define ISTAG(x) ((x)=IMAGE_SYM_CLASS_STRUCT_TAG or (x)=IMAGE_SYM_CLASS_UNION_TAG or (x)=IMAGE_SYM_CLASS_ENUM_TAG)
#define INCREF(x) ((((x) and not N_BTMASK) shl N_TSHIFT) or (IMAGE_SYM_DTYPE_POINTER shl N_BTSHFT) or ((x) and N_BTMASK))
#define DECREF(x) ((((x) shr N_TSHIFT) and not N_BTMASK) or ((x) and N_BTMASK))
#define WT_TRANSFER_IMPERSONATION &h00000100
#define ACTIVATION_CONTEXT_SECTION_ASSEMBLY_INFORMATION 1
#define ACTIVATION_CONTEXT_SECTION_DLL_REDIRECTION 2
#define ACTIVATION_CONTEXT_SECTION_WINDOW_CLASS_REDIRECTION 3
#define ACTIVATION_CONTEXT_SECTION_COM_SERVER_REDIRECTION 4
#define ACTIVATION_CONTEXT_SECTION_COM_INTERFACE_REDIRECTION 5
#define ACTIVATION_CONTEXT_SECTION_COM_TYPE_LIBRARY_REDIRECTION 6
#define ACTIVATION_CONTEXT_SECTION_COM_PROGID_REDIRECTION 7
#define ACTIVATION_CONTEXT_SECTION_CLR_SURROGATES 9
#define TLS_MINIMUM_AVAILABLE 64
#define MAXIMUM_REPARSE_DATA_BUFFER_SIZE 16384
#define IO_REPARSE_TAG_RESERVED_ZERO 0
#define IO_REPARSE_TAG_RESERVED_ONE 1
#define IO_REPARSE_TAG_RESERVED_RANGE 1
#define IsReparseTagMicrosoft(x) ((x) and &h80000000)
#define IsReparseTagHighLatency(x) ((x) and &h40000000)
#define IsReparseTagNameSurrogate(x) ((x) and &h20000000)
#define IO_REPARSE_TAG_VALID_VALUES &hE000FFFF
#define IsReparseTagValid(x) (not((x) and not IO_REPARSE_TAG_VALID_VALUES) and ((x) > IO_REPARSE_TAG_RESERVED_RANGE))
#define IO_REPARSE_TAG_SYMBOLIC_LINK 0
#define IO_REPARSE_TAG_MOUNT_POINT &hA0000003

type ACCESS_MASK as DWORD
type PACCESS_MASK as DWORD ptr

#define GUID_DEFINED
type GUID
	Data1 as uinteger
	Data2 as ushort
	Data3 as ushort
	Data4(0 to 8-1) as ubyte
end type

type REFGUID as GUID ptr
type LPGUID as GUID ptr

#define SYSTEM_LUID { QuadPart:999 }

type GENERIC_MAPPING
	GenericRead as ACCESS_MASK
	GenericWrite as ACCESS_MASK
	GenericExecute as ACCESS_MASK
	GenericAll as ACCESS_MASK
end type

type PGENERIC_MAPPING as GENERIC_MAPPING ptr

type ACE_HEADER
	AceType as UBYTE
	AceFlags as UBYTE
	AceSize as WORD
end type

type PACE_HEADER as ACE_HEADER ptr

type ACCESS_ALLOWED_ACE
	Header as ACE_HEADER
	Mask as ACCESS_MASK
	SidStart as DWORD
end type

type PACCESS_ALLOWED_ACE as ACCESS_ALLOWED_ACE ptr

type ACCESS_DENIED_ACE
	Header as ACE_HEADER
	Mask as ACCESS_MASK
	SidStart as DWORD
end type

type PACCESS_DENIED_ACE as ACCESS_DENIED_ACE ptr

type SYSTEM_AUDIT_ACE
	Header as ACE_HEADER
	Mask as ACCESS_MASK
	SidStart as DWORD
end type

type PSYSTEM_AUDIT_ACE as SYSTEM_AUDIT_ACE ptr

type SYSTEM_ALARM_ACE
	Header as ACE_HEADER
	Mask as ACCESS_MASK
	SidStart as DWORD
end type

type PSYSTEM_ALARM_ACE as SYSTEM_ALARM_ACE ptr

type ACCESS_ALLOWED_OBJECT_ACE
	Header as ACE_HEADER
	Mask as ACCESS_MASK
	Flags as DWORD
	ObjectType as GUID
	InheritedObjectType as GUID
	SidStart as DWORD
end type

type PACCESS_ALLOWED_OBJECT_ACE as ACCESS_ALLOWED_OBJECT_ACE ptr

type ACCESS_DENIED_OBJECT_ACE
	Header as ACE_HEADER
	Mask as ACCESS_MASK
	Flags as DWORD
	ObjectType as GUID
	InheritedObjectType as GUID
	SidStart as DWORD
end type

type PACCESS_DENIED_OBJECT_ACE as ACCESS_DENIED_OBJECT_ACE ptr

type SYSTEM_AUDIT_OBJECT_ACE
	Header as ACE_HEADER
	Mask as ACCESS_MASK
	Flags as DWORD
	ObjectType as GUID
	InheritedObjectType as GUID
	SidStart as DWORD
end type

type PSYSTEM_AUDIT_OBJECT_ACE as SYSTEM_AUDIT_OBJECT_ACE ptr

type SYSTEM_ALARM_OBJECT_ACE
	Header as ACE_HEADER
	Mask as ACCESS_MASK
	Flags as DWORD
	ObjectType as GUID
	InheritedObjectType as GUID
	SidStart as DWORD
end type

type PSYSTEM_ALARM_OBJECT_ACE as SYSTEM_ALARM_OBJECT_ACE ptr

type ACL
	AclRevision as UBYTE
	Sbz1 as UBYTE
	AclSize as WORD
	AceCount as WORD
	Sbz2 as WORD
end type

type PACL as ACL ptr

type ACL_REVISION_INFORMATION
	AclRevision as DWORD
end type

type ACL_SIZE_INFORMATION
	AceCount as DWORD
	AclBytesInUse as DWORD
	AclBytesFree as DWORD
end type

#ifdef _X86_
#define SIZE_OF_80387_REGISTERS 80
#define CONTEXT_i386 &h10000
#define CONTEXT_i486 &h10000
#define CONTEXT_CONTROL (&h10000 or &h00000001L)
#define CONTEXT_INTEGER (&h10000 or &h00000002L)
#define CONTEXT_SEGMENTS (&h10000 or &h00000004L)
#define CONTEXT_FLOATING_POINT (&h10000 or &h00000008L)
#define CONTEXT_DEBUG_REGISTERS (&h10000 or &h00000010L)
#define CONTEXT_EXTENDED_REGISTERS (&h10000 or &h00000020L)
#define CONTEXT_FULL ((&h10000 or &h00000001L) or (&h10000 or &h00000002L) or (&h10000 or &h00000004L))
#define MAXIMUM_SUPPORTED_EXTENSION 512

type FLOATING_SAVE_AREA
	ControlWord as DWORD
	StatusWord as DWORD
	TagWord as DWORD
	ErrorOffset as DWORD
	ErrorSelector as DWORD
	DataOffset as DWORD
	DataSelector as DWORD
	RegisterArea(0 to 80-1) as UBYTE
	Cr0NpxState as DWORD
end type

type CONTEXT
	ContextFlags as DWORD
	Dr0 as DWORD
	Dr1 as DWORD
	Dr2 as DWORD
	Dr3 as DWORD
	Dr6 as DWORD
	Dr7 as DWORD
	FloatSave as FLOATING_SAVE_AREA
	SegGs as DWORD
	SegFs as DWORD
	SegEs as DWORD
	SegDs as DWORD
	Edi as DWORD
	Esi as DWORD
	Ebx as DWORD
	Edx as DWORD
	Ecx as DWORD
	Eax as DWORD
	Ebp as DWORD
	Eip as DWORD
	SegCs as DWORD
	EFlags as DWORD
	Esp as DWORD
	SegSs as DWORD
	ExtendedRegisters(0 to 512-1) as UBYTE
end type

type PCONTEXT as CONTEXT ptr
type LPCONTEXT as CONTEXT ptr

#else
#error "undefined processor type"
#endif 

type EXCEPTION_RECORD
	ExceptionCode as DWORD
	ExceptionFlags as DWORD
	ExceptionRecord as EXCEPTION_RECORD ptr
	ExceptionAddress as PVOID
	NumberParameters as DWORD
	ExceptionInformation(0 to 15-1) as DWORD
end type

type PEXCEPTION_RECORD as EXCEPTION_RECORD ptr
type LPEXCEPTION_RECORD as EXCEPTION_RECORD ptr

type EXCEPTION_POINTERS
	ExceptionRecord as PEXCEPTION_RECORD
	ContextRecord as PCONTEXT
end type

type PEXCEPTION_POINTERS as EXCEPTION_POINTERS ptr
type LPEXCEPTION_POINTERS as EXCEPTION_POINTERS ptr


union LARGE_INTEGER
	type
		LowPart as DWORD
		HighPart as LONG
	end type
	QuadPart as LONGLONG
end union

type PLARGE_INTEGER as LARGE_INTEGER ptr

union ULARGE_INTEGER
	type
		LowPart as DWORD
		HighPart as DWORD
	end type
	QuadPart as ULONGLONG
end union

type PULARGE_INTEGER as ULARGE_INTEGER ptr

type LUID
	LowPart as DWORD
	HighPart as LONG
end type
type PLUID as LUID ptr

type LUID_AND_ATTRIBUTES
	Luid as LUID
	Attributes as DWORD
end type

type PLUID_AND_ATTRIBUTES as LUID_AND_ATTRIBUTES ptr
type LUID_AND_ATTRIBUTES_ARRAY as UID_AND_ATTRIBUTES ptr
type PLUID_AND_ATTRIBUTES_ARRAY as LUID_AND_ATTRIBUTES_ARRAY ptr

type PRIVILEGE_SET
	PrivilegeCount as DWORD
	Control as DWORD
	Privilege(0 to 1-1) as LUID_AND_ATTRIBUTES
end type

type PPRIVILEGE_SET as PRIVILEGE_SET ptr

type SECURITY_ATTRIBUTES
	nLength as DWORD
	lpSecurityDescriptor as LPVOID
	bInheritHandle as BOOL
end type

type PSECURITY_ATTRIBUTES as SECURITY_ATTRIBUTES ptr
type LPSECURITY_ATTRIBUTES as SECURITY_ATTRIBUTES ptr

enum SECURITY_IMPERSONATION_LEVEL
	SecurityAnonymous
	SecurityIdentification
	SecurityImpersonation
	SecurityDelegation
end enum

type PSECURITY_IMPERSONATION_LEVEL as SECURITY_IMPERSONATION_LEVEL
type SECURITY_CONTEXT_TRACKING_MODE as BOOLEAN
type PSECURITY_CONTEXT_TRACKING_MODE as BOOLEAN ptr

type SECURITY_QUALITY_OF_SERVICE
	Length as DWORD
	ImpersonationLevel as SECURITY_IMPERSONATION_LEVEL
	ContextTrackingMode as SECURITY_CONTEXT_TRACKING_MODE
	EffectiveOnly as BOOLEAN
end type

type PSECURITY_QUALITY_OF_SERVICE as SECURITY_QUALITY_OF_SERVICE ptr
type PACCESS_TOKEN as PVOID

type SE_IMPERSONATION_STATE
	Token as PACCESS_TOKEN
	CopyOnOpen as BOOLEAN
	EffectiveOnly as BOOLEAN
	Level as SECURITY_IMPERSONATION_LEVEL
end type

type PSE_IMPERSONATION_STATE as SE_IMPERSONATION_STATE ptr

type SID_IDENTIFIER_AUTHORITY
	Value(0 to 6-1) as UBYTE
end type

type PSID_IDENTIFIER_AUTHORITY as SID_IDENTIFIER_AUTHORITY ptr
type LPSID_IDENTIFIER_AUTHORITY as SID_IDENTIFIER_AUTHORITY ptr
type PSID as PVOID

type SID
	Revision as UBYTE
	SubAuthorityCount as UBYTE
	IdentifierAuthority as SID_IDENTIFIER_AUTHORITY
	SubAuthority(0 to 1-1) as DWORD
end type

type PISID as SID ptr

type SID_AND_ATTRIBUTES
	Sid as PSID
	Attributes as DWORD
end type

type PSID_AND_ATTRIBUTES as SID_AND_ATTRIBUTES ptr
type SID_AND_ATTRIBUTES_ARRAY as SID_AND_ATTRIBUTES ptr
type PSID_AND_ATTRIBUTES_ARRAY as SID_AND_ATTRIBUTES_ARRAY ptr

type TOKEN_SOURCE
	SourceName as zstring * 8
	SourceIdentifier as LUID
end type

type PTOKEN_SOURCE as TOKEN_SOURCE ptr

type TOKEN_CONTROL
	TokenId as LUID
	AuthenticationId as LUID
	ModifiedId as LUID
	TokenSource as TOKEN_SOURCE
end type

type PTOKEN_CONTROL as TOKEN_CONTROL ptr

type TOKEN_DEFAULT_DACL
	DefaultDacl as PACL
end type

type PTOKEN_DEFAULT_DACL as TOKEN_DEFAULT_DACL ptr

type TOKEN_GROUPS
	GroupCount as DWORD
	Groups(0 to 1-1) as SID_AND_ATTRIBUTES
end type

type PTOKEN_GROUPS as TOKEN_GROUPS ptr
type LPTOKEN_GROUPS as TOKEN_GROUPS ptr

type TOKEN_OWNER
	Owner as PSID
end type

type PTOKEN_OWNER as TOKEN_OWNER ptr

type TOKEN_PRIMARY_GROUP
	PrimaryGroup as PSID
end type

type PTOKEN_PRIMARY_GROUP as TOKEN_PRIMARY_GROUP ptr

type TOKEN_PRIVILEGES
	PrivilegeCount as DWORD
	Privileges(0 to 1-1) as LUID_AND_ATTRIBUTES
end type

type PTOKEN_PRIVILEGES as TOKEN_PRIVILEGES ptr
type LPTOKEN_PRIVILEGES as TOKEN_PRIVILEGES ptr

enum TOKEN_TYPE
	TokenPrimary = 1
	TokenImpersonation
end enum

type PTOKEN_TYPE as TOKEN_TYPE

type TOKEN_STATISTICS
	TokenId as LUID
	AuthenticationId as LUID
	ExpirationTime as LARGE_INTEGER
	TokenType as TOKEN_TYPE
	ImpersonationLevel as SECURITY_IMPERSONATION_LEVEL
	DynamicCharged as DWORD
	DynamicAvailable as DWORD
	GroupCount as DWORD
	PrivilegeCount as DWORD
	ModifiedId as LUID
end type

type PTOKEN_STATISTICS as TOKEN_STATISTICS ptr

type TOKEN_USER
	User as SID_AND_ATTRIBUTES
end type

type PTOKEN_USER as TOKEN_USER ptr
type SECURITY_INFORMATION as DWORD
type PSECURITY_INFORMATION as DWORD ptr
type SECURITY_DESCRIPTOR_CONTROL as WORD
type PSECURITY_DESCRIPTOR_CONTROL as WORD ptr

type SECURITY_DESCRIPTOR
	Revision as UBYTE
	Sbz1 as UBYTE
	Control as SECURITY_DESCRIPTOR_CONTROL
	Owner as PSID
	Group as PSID
	Sacl as PACL
	Dacl as PACL
end type

type PSECURITY_DESCRIPTOR as SECURITY_DESCRIPTOR ptr
type PISECURITY_DESCRIPTOR as SECURITY_DESCRIPTOR ptr

enum TOKEN_INFORMATION_CLASS
	TokenUser = 1
	TokenGroups
	TokenPrivileges
	TokenOwner
	TokenPrimaryGroup
	TokenDefaultDacl
	TokenSource
	TokenType
	TokenImpersonationLevel
	TokenStatistics
	TokenRestrictedSids
	TokenSessionId
	TokenGroupsAndPrivileges
	TokenSessionReference
	TokenSandBoxInert
	TokenAuditPolicy
	TokenOrigin
end enum

enum SID_NAME_USE
	SidTypeUser = 1
	SidTypeGroup
	SidTypeDomain
	SidTypeAlias
	SidTypeWellKnownGroup
	SidTypeDeletedAccount
	SidTypeInvalid
	SidTypeUnknown
end enum

type PSID_NAME_USE as SID_NAME_USE

type QUOTA_LIMITS
	PagedPoolLimit as SIZE_T
	NonPagedPoolLimit as SIZE_T
	MinimumWorkingSetSize as SIZE_T
	MaximumWorkingSetSize as SIZE_T
	PagefileLimit as SIZE_T
	TimeLimit as LARGE_INTEGER
end type

type PQUOTA_LIMITS as QUOTA_LIMITS ptr

type IO_COUNTERS
	ReadOperationCount as ULONGLONG
	WriteOperationCount as ULONGLONG
	OtherOperationCount as ULONGLONG
	ReadTransferCount as ULONGLONG
	WriteTransferCount as ULONGLONG
	OtherTransferCount as ULONGLONG
end type

type PIO_COUNTERS as IO_COUNTERS ptr

type FILE_NOTIFY_INFORMATION
	NextEntryOffset as DWORD
	Action as DWORD
	FileNameLength as DWORD
	FileName as wstring * 1
end type

type PFILE_NOTIFY_INFORMATION as FILE_NOTIFY_INFORMATION ptr

type TAPE_ERASE
	Type as DWORD
	Immediate as BOOLEAN
end type

type PTAPE_ERASE as TAPE_ERASE ptr

type TAPE_GET_DRIVE_PARAMETERS
	ECC as BOOLEAN
	Compression as BOOLEAN
	DataPadding as BOOLEAN
	ReportSetmarks as BOOLEAN
	DefaultBlockSize as DWORD
	MaximumBlockSize as DWORD
	MinimumBlockSize as DWORD
	MaximumPartitionCount as DWORD
	FeaturesLow as DWORD
	FeaturesHigh as DWORD
	EOTWarningZoneSize as DWORD
end type

type PTAPE_GET_DRIVE_PARAMETERS as TAPE_GET_DRIVE_PARAMETERS ptr

type TAPE_GET_MEDIA_PARAMETERS
	Capacity as LARGE_INTEGER
	Remaining as LARGE_INTEGER
	BlockSize as DWORD
	PartitionCount as DWORD
	WriteProtected as BOOLEAN
end type

type PTAPE_GET_MEDIA_PARAMETERS as TAPE_GET_MEDIA_PARAMETERS ptr

type TAPE_GET_POSITION
	Type as ULONG
	Partition as ULONG
	OffsetLow as ULONG
	OffsetHigh as ULONG
end type

type PTAPE_GET_POSITION as TAPE_GET_POSITION ptr

type TAPE_PREPARE
	Operation as DWORD
	Immediate as BOOLEAN
end type

type PTAPE_PREPARE as TAPE_PREPARE ptr

type TAPE_SET_DRIVE_PARAMETERS
	ECC as BOOLEAN
	Compression as BOOLEAN
	DataPadding as BOOLEAN
	ReportSetmarks as BOOLEAN
	EOTWarningZoneSize as ULONG
end type

type PTAPE_SET_DRIVE_PARAMETERS as TAPE_SET_DRIVE_PARAMETERS ptr

type TAPE_SET_MEDIA_PARAMETERS
	BlockSize as ULONG
end type

type PTAPE_SET_MEDIA_PARAMETERS as TAPE_SET_MEDIA_PARAMETERS ptr

type TAPE_SET_POSITION
	Method as DWORD
	Partition as DWORD
	Offset as LARGE_INTEGER
	Immediate as BOOLEAN
end type

type PTAPE_SET_POSITION as TAPE_SET_POSITION ptr

type TAPE_WRITE_MARKS
	Type as DWORD
	Count as DWORD
	Immediate as BOOLEAN
end type

type PTAPE_WRITE_MARKS as TAPE_WRITE_MARKS ptr

type TAPE_CREATE_PARTITION
	Method as DWORD
	Count as DWORD
	Size as DWORD
end type

type PTAPE_CREATE_PARTITION as TAPE_CREATE_PARTITION ptr

type MEMORY_BASIC_INFORMATION
	BaseAddress as PVOID
	AllocationBase as PVOID
	AllocationProtect as DWORD
	RegionSize as DWORD
	State as DWORD
	Protect as DWORD
	Type as DWORD
end type

type PMEMORY_BASIC_INFORMATION as MEMORY_BASIC_INFORMATION ptr

type MESSAGE_RESOURCE_ENTRY
	Length as WORD
	Flags as WORD
	Text(0 to 1-1) as UBYTE
end type

type PMESSAGE_RESOURCE_ENTRY as MESSAGE_RESOURCE_ENTRY ptr

type MESSAGE_RESOURCE_BLOCK
	LowId as DWORD
	HighId as DWORD
	OffsetToEntries as DWORD
end type

type PMESSAGE_RESOURCE_BLOCK as MESSAGE_RESOURCE_BLOCK ptr

type MESSAGE_RESOURCE_DATA
	NumberOfBlocks as DWORD
	Blocks(0 to 1-1) as MESSAGE_RESOURCE_BLOCK
end type

type PMESSAGE_RESOURCE_DATA as MESSAGE_RESOURCE_DATA ptr

type LIST_ENTRY
	Flink as LIST_ENTRY ptr
	Blink as LIST_ENTRY ptr
end type

type PLIST_ENTRY as LIST_ENTRY ptr

type SINGLE_LIST_ENTRY
	Next as SINGLE_LIST_ENTRY ptr
end type

type PSINGLE_LIST_ENTRY as SINGLE_LIST_ENTRY ptr

union SLIST_HEADER
	Alignment as ULONGLONG
	type
		Next as SINGLE_LIST_ENTRY
		Depth as WORD
		Sequence as WORD
	end type
end union

type PSLIST_HEADER as SLIST_HEADER ptr

type PRTL_CRITICAL_SECTION_DEBUG as RTL_CRITICAL_SECTION_DEBUG ptr

type RTL_CRITICAL_SECTION
	DebugInfo as PRTL_CRITICAL_SECTION_DEBUG
	LockCount as LONG
	RecursionCount as LONG
	OwningThread as HANDLE
	LockSemaphore as HANDLE
	Reserved as DWORD
end type

type PRTL_CRITICAL_SECTION as RTL_CRITICAL_SECTION ptr

type RTL_CRITICAL_SECTION_DEBUG
	Type as WORD
	CreatorBackTraceIndex as WORD
	CriticalSection as RTL_CRITICAL_SECTION ptr
	ProcessLocksList as LIST_ENTRY
	EntryCount as DWORD
	ContentionCount as DWORD
	Spare(0 to 2-1) as DWORD
end type

type EVENTLOGRECORD
	Length as DWORD
	Reserved as DWORD
	RecordNumber as DWORD
	TimeGenerated as DWORD
	TimeWritten as DWORD
	EventID as DWORD
	EventType as WORD
	NumStrings as WORD
	EventCategory as WORD
	ReservedFlags as WORD
	ClosingRecordNumber as DWORD
	StringOffset as DWORD
	UserSidLength as DWORD
	UserSidOffset as DWORD
	DataLength as DWORD
	DataOffset as DWORD
end type

type PEVENTLOGRECORD as EVENTLOGRECORD ptr

#ifndef UNICODE
type OSVERSIONINFOA
	dwOSVersionInfoSize as DWORD
	dwMajorVersion as DWORD
	dwMinorVersion as DWORD
	dwBuildNumber as DWORD
	dwPlatformId as DWORD
	szCSDVersion as zstring * 128
end type

type POSVERSIONINFOA as OSVERSIONINFOA ptr
type LPOSVERSIONINFOA as OSVERSIONINFOA ptr

#else ''UNICODE
type OSVERSIONINFOW
	dwOSVersionInfoSize as DWORD
	dwMajorVersion as DWORD
	dwMinorVersion as DWORD
	dwBuildNumber as DWORD
	dwPlatformId as DWORD
	szCSDVersion as wstring * 128
end type

type POSVERSIONINFOW as OSVERSIONINFOW ptr
type LPOSVERSIONINFOW as OSVERSIONINFOW ptr
#endif ''UNICODE

#ifndef UNICODE
type OSVERSIONINFOEXA
	dwOSVersionInfoSize as DWORD
	dwMajorVersion as DWORD
	dwMinorVersion as DWORD
	dwBuildNumber as DWORD
	dwPlatformId as DWORD
	szCSDVersion as zstring * 128
	wServicePackMajor as WORD
	wServicePackMinor as WORD
	wSuiteMask as WORD
	wProductType as UBYTE
	wReserved as UBYTE
end type

type POSVERSIONINFOEXA as OSVERSIONINFOEXA ptr
type LPOSVERSIONINFOEXA as OSVERSIONINFOEXA ptr

#else ''UNICODE
type OSVERSIONINFOEXW
	dwOSVersionInfoSize as DWORD
	dwMajorVersion as DWORD
	dwMinorVersion as DWORD
	dwBuildNumber as DWORD
	dwPlatformId as DWORD
	szCSDVersion as wstring * 128
	wServicePackMajor as WORD
	wServicePackMinor as WORD
	wSuiteMask as WORD
	wProductType as UBYTE
	wReserved as UBYTE
end type

type POSVERSIONINFOEXW as OSVERSIONINFOEXW ptr
type LPOSVERSIONINFOEXW as OSVERSIONINFOEXW ptr
#endif ''UNICODE

type IMAGE_VXD_HEADER field=2
	e32_magic as WORD
	e32_border as UBYTE
	e32_worder as UBYTE
	e32_level as DWORD
	e32_cpu as WORD
	e32_os as WORD
	e32_ver as DWORD
	e32_mflags as DWORD
	e32_mpages as DWORD
	e32_startobj as DWORD
	e32_eip as DWORD
	e32_stackobj as DWORD
	e32_esp as DWORD
	e32_pagesize as DWORD
	e32_lastpagesize as DWORD
	e32_fixupsize as DWORD
	e32_fixupsum as DWORD
	e32_ldrsize as DWORD
	e32_ldrsum as DWORD
	e32_objtab as DWORD
	e32_objcnt as DWORD
	e32_objmap as DWORD
	e32_itermap as DWORD
	e32_rsrctab as DWORD
	e32_rsrccnt as DWORD
	e32_restab as DWORD
	e32_enttab as DWORD
	e32_dirtab as DWORD
	e32_dircnt as DWORD
	e32_fpagetab as DWORD
	e32_frectab as DWORD
	e32_impmod as DWORD
	e32_impmodcnt as DWORD
	e32_impproc as DWORD
	e32_pagesum as DWORD
	e32_datapage as DWORD
	e32_preload as DWORD
	e32_nrestab as DWORD
	e32_cbnrestab as DWORD
	e32_nressum as DWORD
	e32_autodata as DWORD
	e32_debuginfo as DWORD
	e32_debuglen as DWORD
	e32_instpreload as DWORD
	e32_instdemand as DWORD
	e32_heapsize as DWORD
	e32_res3(0 to 12-1) as UBYTE
	e32_winresoff as DWORD
	e32_winreslen as DWORD
	e32_devid as WORD
	e32_ddkver as WORD
end type

type PIMAGE_VXD_HEADER as IMAGE_VXD_HEADER ptr

type IMAGE_FILE_HEADER
	Machine as WORD
	NumberOfSections as WORD
	TimeDateStamp as DWORD
	PointerToSymbolTable as DWORD
	NumberOfSymbols as DWORD
	SizeOfOptionalHeader as WORD
	Characteristics as WORD
end type

type PIMAGE_FILE_HEADER as IMAGE_FILE_HEADER ptr

type IMAGE_DATA_DIRECTORY
	VirtualAddress as DWORD
	Size as DWORD
end type

type PIMAGE_DATA_DIRECTORY as IMAGE_DATA_DIRECTORY ptr

type IMAGE_OPTIONAL_HEADER
	Magic as WORD
	MajorLinkerVersion as UBYTE
	MinorLinkerVersion as UBYTE
	SizeOfCode as DWORD
	SizeOfInitializedData as DWORD
	SizeOfUninitializedData as DWORD
	AddressOfEntryPoint as DWORD
	BaseOfCode as DWORD
	BaseOfData as DWORD
	ImageBase as DWORD
	SectionAlignment as DWORD
	FileAlignment as DWORD
	MajorOperatingSystemVersion as WORD
	MinorOperatingSystemVersion as WORD
	MajorImageVersion as WORD
	MinorImageVersion as WORD
	MajorSubsystemVersion as WORD
	MinorSubsystemVersion as WORD
	Reserved1 as DWORD
	SizeOfImage as DWORD
	SizeOfHeaders as DWORD
	CheckSum as DWORD
	Subsystem as WORD
	DllCharacteristics as WORD
	SizeOfStackReserve as DWORD
	SizeOfStackCommit as DWORD
	SizeOfHeapReserve as DWORD
	SizeOfHeapCommit as DWORD
	LoaderFlags as DWORD
	NumberOfRvaAndSizes as DWORD
	DataDirectory(0 to 16-1) as IMAGE_DATA_DIRECTORY
end type

type PIMAGE_OPTIONAL_HEADER as IMAGE_OPTIONAL_HEADER ptr

type IMAGE_ROM_OPTIONAL_HEADER
	Magic as WORD
	MajorLinkerVersion as UBYTE
	MinorLinkerVersion as UBYTE
	SizeOfCode as DWORD
	SizeOfInitializedData as DWORD
	SizeOfUninitializedData as DWORD
	AddressOfEntryPoint as DWORD
	BaseOfCode as DWORD
	BaseOfData as DWORD
	BaseOfBss as DWORD
	GprMask as DWORD
	CprMask(0 to 4-1) as DWORD
	GpValue as DWORD
end type

type PIMAGE_ROM_OPTIONAL_HEADER as IMAGE_ROM_OPTIONAL_HEADER ptr

type IMAGE_DOS_HEADER field=2
	e_magic as WORD
	e_cblp as WORD
	e_cp as WORD
	e_crlc as WORD
	e_cparhdr as WORD
	e_minalloc as WORD
	e_maxalloc as WORD
	e_ss as WORD
	e_sp as WORD
	e_csum as WORD
	e_ip as WORD
	e_cs as WORD
	e_lfarlc as WORD
	e_ovno as WORD
	e_res(0 to 4-1) as WORD
	e_oemid as WORD
	e_oeminfo as WORD
	e_res2(0 to 10-1) as WORD
	e_lfanew as LONG
end type

type PIMAGE_DOS_HEADER as IMAGE_DOS_HEADER ptr

type IMAGE_OS2_HEADER field=2
	ne_magic as WORD
	ne_ver as CHAR
	ne_rev as CHAR
	ne_enttab as WORD
	ne_cbenttab as WORD
	ne_crc as LONG
	ne_flags as WORD
	ne_autodata as WORD
	ne_heap as WORD
	ne_stack as WORD
	ne_csip as LONG
	ne_sssp as LONG
	ne_cseg as WORD
	ne_cmod as WORD
	ne_cbnrestab as WORD
	ne_segtab as WORD
	ne_rsrctab as WORD
	ne_restab as WORD
	ne_modtab as WORD
	ne_imptab as WORD
	ne_nrestab as LONG
	ne_cmovent as WORD
	ne_align as WORD
	ne_cres as WORD
	ne_exetyp as UBYTE
	ne_flagsothers as UBYTE
	ne_pretthunks as WORD
	ne_psegrefbytes as WORD
	ne_swaparea as WORD
	ne_expver as WORD
end type

type PIMAGE_OS2_HEADER as IMAGE_OS2_HEADER ptr

type IMAGE_NT_HEADERS
	Signature as DWORD
	FileHeader as IMAGE_FILE_HEADER
	OptionalHeader as IMAGE_OPTIONAL_HEADER
end type

type PIMAGE_NT_HEADERS as IMAGE_NT_HEADERS ptr

type IMAGE_ROM_HEADERS
	FileHeader as IMAGE_FILE_HEADER
	OptionalHeader as IMAGE_ROM_OPTIONAL_HEADER
end type

type PIMAGE_ROM_HEADERS as IMAGE_ROM_HEADERS ptr

union IMAGE_SECTION_HEADER_Misc
	PhysicalAddress as DWORD
	VirtualSize as DWORD
end union

type IMAGE_SECTION_HEADER
	Name(0 to 8-1) as UBYTE
	Misc as IMAGE_SECTION_HEADER_Misc
	VirtualAddress as DWORD
	SizeOfRawData as DWORD
	PointerToRawData as DWORD
	PointerToRelocations as DWORD
	PointerToLinenumbers as DWORD
	NumberOfRelocations as WORD
	NumberOfLinenumbers as WORD
	Characteristics as DWORD
end type

type PIMAGE_SECTION_HEADER as IMAGE_SECTION_HEADER ptr

type IMAGE_SYMBOL_N_Name field=2
	Short as DWORD
	Long as DWORD
end type

union IMAGE_SYMBOL_N field=2
	ShortName(0 to 8-1) as UBYTE
	LongName(0 to 2-1) as PBYTE
	Name as IMAGE_SYMBOL_N_Name
end union

type IMAGE_SYMBOL field=2
	Value as DWORD
	SectionNumber as SHORT
	Type as WORD
	StorageClass as UBYTE
	NumberOfAuxSymbols as UBYTE
	N as IMAGE_SYMBOL_N
end type

type PIMAGE_SYMBOL as IMAGE_SYMBOL ptr

type IMAGE_AUX_SYMBOL_File field=2
	Name(0 to 18-1) as UBYTE
end type

type IMAGE_AUX_SYMBOL_Sym_Misc_LnSz field=2
	Linenumber as WORD
	Size as WORD
end type

union IMAGE_AUX_SYMBOL_Sym_Misc field=2
	LnSz as IMAGE_AUX_SYMBOL_Sym_Misc_LnSz
	TotalSize as DWORD
end union

type IMAGE_AUX_SYMBOL_Sym_FcnAry_Array field=2
	Dimension(0 to 4-1) as WORD
end type

type IMAGE_AUX_SYMBOL_Sym_FcnAry_Function field=2
	PointerToLinenumber as DWORD
	PointerToNextFunction as DWORD
end type

union IMAGE_AUX_SYMBOL_Sym_FcnAry field=2
	Function as IMAGE_AUX_SYMBOL_Sym_FcnAry_Function
	Array as IMAGE_AUX_SYMBOL_Sym_FcnAry_Array
end union

type IMAGE_AUX_SYMBOL_Sym field=2
	TagIndex as DWORD
	Misc as IMAGE_AUX_SYMBOL_Sym_Misc
	FcnAry as IMAGE_AUX_SYMBOL_Sym_FcnAry
	TvIndex as WORD
end type

type IMAGE_AUX_SYMBOL_Section field=2
	Length as DWORD
	NumberOfRelocations as WORD
	NumberOfLinenumbers as WORD
	CheckSum as DWORD
	Number as SHORT
	Selection as UBYTE
end type

union IMAGE_AUX_SYMBOL field=2
	Sym as IMAGE_AUX_SYMBOL_Sym
	File as IMAGE_AUX_SYMBOL_File
	Section as IMAGE_AUX_SYMBOL_Section
end union

type PIMAGE_AUX_SYMBOL as IMAGE_AUX_SYMBOL ptr

type IMAGE_COFF_SYMBOLS_HEADER field=2
	NumberOfSymbols as DWORD
	LvaToFirstSymbol as DWORD
	NumberOfLinenumbers as DWORD
	LvaToFirstLinenumber as DWORD
	RvaToFirstByteOfCode as DWORD
	RvaToLastByteOfCode as DWORD
	RvaToFirstByteOfData as DWORD
	RvaToLastByteOfData as DWORD
end type

type PIMAGE_COFF_SYMBOLS_HEADER as IMAGE_COFF_SYMBOLS_HEADER ptr

type IMAGE_RELOCATION field=2
	union
		VirtualAddress as DWORD
		RelocCount as DWORD
	end union
	SymbolTableIndex as DWORD
	Type as WORD
end type

type PIMAGE_RELOCATION as IMAGE_RELOCATION ptr

type IMAGE_BASE_RELOCATION
	VirtualAddress as DWORD
	SizeOfBlock as DWORD
end type

type PIMAGE_BASE_RELOCATION as IMAGE_BASE_RELOCATION ptr

union IMAGE_LINENUMBER_Type field=2
	SymbolTableIndex as DWORD
	VirtualAddress as DWORD
end union

type IMAGE_LINENUMBER field=2
	Type as IMAGE_LINENUMBER_Type
	Linenumber as WORD
end type

type PIMAGE_LINENUMBER as IMAGE_LINENUMBER ptr


type IMAGE_ARCHIVE_MEMBER_HEADER
	Name(0 to 16-1) as UBYTE
	Date(0 to 12-1) as UBYTE
	UserID(0 to 6-1) as UBYTE
	GroupID(0 to 6-1) as UBYTE
	Mode(0 to 8-1) as UBYTE
	Size(0 to 10-1) as UBYTE
	EndHeader(0 to 2-1) as UBYTE
end type

type PIMAGE_ARCHIVE_MEMBER_HEADER as IMAGE_ARCHIVE_MEMBER_HEADER ptr

type IMAGE_EXPORT_DIRECTORY
	Characteristics as DWORD
	TimeDateStamp as DWORD
	MajorVersion as WORD
	MinorVersion as WORD
	Name as DWORD
	Base as DWORD
	NumberOfFunctions as DWORD
	NumberOfNames as DWORD
	AddressOfFunctions as PDWORD ptr
	AddressOfNames as PDWORD ptr
	AddressOfNameOrdinals as PWORD ptr
end type

type PIMAGE_EXPORT_DIRECTORY as IMAGE_EXPORT_DIRECTORY ptr

type IMAGE_IMPORT_BY_NAME
	Hint as WORD
	Name(0 to 1-1) as UBYTE
end type

type PIMAGE_IMPORT_BY_NAME as IMAGE_IMPORT_BY_NAME ptr

union IMAGE_THUNK_DATA_u1
	ForwarderString as PBYTE
	Function as PDWORD
	Ordinal as DWORD
	AddressOfData as PIMAGE_IMPORT_BY_NAME
end union

type IMAGE_THUNK_DATA
	u1 as IMAGE_THUNK_DATA_u1
end type

type PIMAGE_THUNK_DATA as IMAGE_THUNK_DATA ptr

type IMAGE_IMPORT_DESCRIPTOR
	union
		Characteristics as DWORD
		OriginalFirstThunk as PIMAGE_THUNK_DATA
	end union
	TimeDateStamp as DWORD
	ForwarderChain as DWORD
	Name as DWORD
	FirstThunk as PIMAGE_THUNK_DATA
end type

type PIMAGE_IMPORT_DESCRIPTOR as IMAGE_IMPORT_DESCRIPTOR ptr

type IMAGE_BOUND_IMPORT_DESCRIPTOR
	TimeDateStamp as DWORD
	OffsetModuleName as WORD
	NumberOfModuleForwarderRefs as WORD
end type

type PIMAGE_BOUND_IMPORT_DESCRIPTOR as IMAGE_BOUND_IMPORT_DESCRIPTOR ptr

type IMAGE_BOUND_FORWARDER_REF
	TimeDateStamp as DWORD
	OffsetModuleName as WORD
	Reserved as WORD
end type

type PIMAGE_BOUND_FORWARDER_REF as IMAGE_BOUND_FORWARDER_REF ptr
type PIMAGE_TLS_CALLBACK as sub (byval as PVOID, byval as DWORD, byval as PVOID)

type IMAGE_TLS_DIRECTORY
	StartAddressOfRawData as DWORD
	EndAddressOfRawData as DWORD
	AddressOfIndex as PDWORD
	AddressOfCallBacks as PIMAGE_TLS_CALLBACK ptr
	SizeOfZeroFill as DWORD
	Characteristics as DWORD
end type

type PIMAGE_TLS_DIRECTORY as IMAGE_TLS_DIRECTORY ptr

type IMAGE_TLS_DIRECTORY64
	StartAddressOfRawData as ULONGLONG
	EndAddressOfRawData as ULONGLONG
	AddressOfIndex as ULONGLONG
	AddressOfCallBacks as ULONGLONG
	SizeOfZeroFill as DWORD
	Characteristics as DWORD
end type

type PIMAGE_TLS_DIRECTORY64 as IMAGE_TLS_DIRECTORY64 ptr

type IMAGE_RESOURCE_DIRECTORY
	Characteristics as DWORD
	TimeDateStamp as DWORD
	MajorVersion as WORD
	MinorVersion as WORD
	NumberOfNamedEntries as WORD
	NumberOfIdEntries as WORD
end type

type PIMAGE_RESOURCE_DIRECTORY as IMAGE_RESOURCE_DIRECTORY ptr

type IMAGE_RESOURCE_DIRECTORY_ENTRY
	union
		type
			NameOffset:31 as DWORD
			NameIsString:1 as DWORD
		end type
		Name as DWORD
		Id as WORD
	end union
	union
		OffsetToData as DWORD
		type
			OffsetToDirectory:31 as DWORD
			DataIsDirectory:1 as DWORD
		end type
	end union
end type

type PIMAGE_RESOURCE_DIRECTORY_ENTRY as IMAGE_RESOURCE_DIRECTORY_ENTRY ptr

type IMAGE_RESOURCE_DIRECTORY_STRING
	Length as WORD
	NameString as zstring * 1
end type

type PIMAGE_RESOURCE_DIRECTORY_STRING as IMAGE_RESOURCE_DIRECTORY_STRING ptr

type IMAGE_RESOURCE_DIR_STRING_U
	Length as WORD
	NameString as wstring * 1
end type

type PIMAGE_RESOURCE_DIR_STRING_U as IMAGE_RESOURCE_DIR_STRING_U ptr

type IMAGE_RESOURCE_DATA_ENTRY
	OffsetToData as DWORD
	Size as DWORD
	CodePage as DWORD
	Reserved as DWORD
end type

type PIMAGE_RESOURCE_DATA_ENTRY as IMAGE_RESOURCE_DATA_ENTRY ptr

type IMAGE_LOAD_CONFIG_DIRECTORY
	Characteristics as DWORD
	TimeDateStamp as DWORD
	MajorVersion as WORD
	MinorVersion as WORD
	GlobalFlagsClear as DWORD
	GlobalFlagsSet as DWORD
	CriticalSectionDefaultTimeout as DWORD
	DeCommitFreeBlockThreshold as DWORD
	DeCommitTotalFreeThreshold as DWORD
	LockPrefixTable as PVOID
	MaximumAllocationSize as DWORD
	VirtualMemoryThreshold as DWORD
	ProcessHeapFlags as DWORD
	Reserved(0 to 4-1) as DWORD
end type

type PIMAGE_LOAD_CONFIG_DIRECTORY as IMAGE_LOAD_CONFIG_DIRECTORY ptr

type IMAGE_RUNTIME_FUNCTION_ENTRY
	BeginAddress as DWORD
	EndAddress as DWORD
	ExceptionHandler as PVOID
	HandlerData as PVOID
	PrologEndAddress as DWORD
end type

type PIMAGE_RUNTIME_FUNCTION_ENTRY as IMAGE_RUNTIME_FUNCTION_ENTRY ptr

type IMAGE_DEBUG_DIRECTORY
	Characteristics as DWORD
	TimeDateStamp as DWORD
	MajorVersion as WORD
	MinorVersion as WORD
	Type as DWORD
	SizeOfData as DWORD
	AddressOfRawData as DWORD
	PointerToRawData as DWORD
end type

type PIMAGE_DEBUG_DIRECTORY as IMAGE_DEBUG_DIRECTORY ptr

type FPO_DATA
	ulOffStart as DWORD
	cbProcSize as DWORD
	cdwLocals as DWORD
	cdwParams as WORD
	cbProlog:8 as WORD
	cbRegs:3 as WORD
	fHasSEH:1 as WORD
	fUseBP:1 as WORD
	reserved:1 as WORD
	cbFrame:2 as WORD
end type

type PFPO_DATA as FPO_DATA ptr

type IMAGE_DEBUG_MISC
	DataType as DWORD
	Length as DWORD
	Unicode_ as BOOLEAN
	Reserved(0 to 3-1) as UBYTE
	Data(0 to 1-1) as UBYTE
end type

type PIMAGE_DEBUG_MISC as IMAGE_DEBUG_MISC ptr

type IMAGE_FUNCTION_ENTRY
	StartingAddress as DWORD
	EndingAddress as DWORD
	EndOfPrologue as DWORD
end type

type PIMAGE_FUNCTION_ENTRY as IMAGE_FUNCTION_ENTRY ptr

type IMAGE_SEPARATE_DEBUG_HEADER
	Signature as WORD
	Flags as WORD
	Machine as WORD
	Characteristics as WORD
	TimeDateStamp as DWORD
	CheckSum as DWORD
	ImageBase as DWORD
	SizeOfImage as DWORD
	NumberOfSections as DWORD
	ExportedNamesSize as DWORD
	DebugDirectorySize as DWORD
	SectionAlignment as DWORD
	Reserved(0 to 2-1) as DWORD
end type

type PIMAGE_SEPARATE_DEBUG_HEADER as IMAGE_SEPARATE_DEBUG_HEADER ptr

enum CM_SERVICE_NODE_TYPE
	DriverType = 1
	FileSystemType = 2
	Win32ServiceOwnProcess = 16
	Win32ServiceShareProcess = 32
	AdapterType = 4
	RecognizerType = 8
end enum

type SERVICE_NODE_TYPE as CM_SERVICE_NODE_TYPE

enum CM_SERVICE_LOAD_TYPE
	BootLoad = 0
	SystemLoad = 1
	AutoLoad = 2
	DemandLoad = 3
	DisableLoad = 4
end enum

type SERVICE_LOAD_TYPE as CM_SERVICE_LOAD_TYPE

enum CM_ERROR_CONTROL_TYPE
	IgnoreError = 0
	NormalError = 1
	SevereError = 2
	CriticalError = 3
end enum

type SERVICE_ERROR_TYPE as CM_ERROR_CONTROL_TYPE

type EXCEPTION_REGISTRATION_RECORD as any

type NT_TIB
	ExceptionList as EXCEPTION_REGISTRATION_RECORD ptr
	StackBase as PVOID
	StackLimit as PVOID
	SubSystemTib as PVOID
	union
		FiberData as PVOID
		Version as DWORD
	end union
	ArbitraryUserPointer as PVOID
	Self as NT_TIB ptr
end type

type PNT_TIB as NT_TIB ptr

type REPARSE_DATA_BUFFER_u_GenericReparseBuffer
	DataBuffer(0 to 1-1) as UBYTE
end type

type REPARSE_DATA_BUFFER_u_MountPointReparseBuffer
	SubstituteNameOffset as WORD
	SubstituteNameLength as WORD
	PrintNameOffset as WORD
	PrintNameLength as WORD
	PathBuffer as wstring * 1
end type

type REPARSE_DATA_BUFFER_u_SymbolicLinkReparseBuffer
	SubstituteNameOffset as WORD
	SubstituteNameLength as WORD
	PrintNameOffset as WORD
	PrintNameLength as WORD
	PathBuffer as wstring * 1
end type

type REPARSE_DATA_BUFFER
	ReparseTag as DWORD
	ReparseDataLength as WORD
	Reserved as WORD
	union
		SymbolicLinkReparseBuffer as REPARSE_DATA_BUFFER_u_SymbolicLinkReparseBuffer
		MountPointReparseBuffer as REPARSE_DATA_BUFFER_u_MountPointReparseBuffer
		GenericReparseBuffer as REPARSE_DATA_BUFFER_u_GenericReparseBuffer
	end union
end type

type PREPARSE_DATA_BUFFER as REPARSE_DATA_BUFFER ptr

type REPARSE_GUID_DATA_BUFFER_GenericReparseBuffer
	DataBuffer(0 to 1-1) as UBYTE
end type

type REPARSE_GUID_DATA_BUFFER
	ReparseTag as DWORD
	ReparseDataLength as WORD
	Reserved as WORD
	ReparseGuid as GUID
	GenericReparseBuffer as REPARSE_GUID_DATA_BUFFER_GenericReparseBuffer
end type

type PREPARSE_GUID_DATA_BUFFER as REPARSE_GUID_DATA_BUFFER ptr

type REPARSE_POINT_INFORMATION
	ReparseDataLength as WORD
	UnparsedNameLength as WORD
end type

type PREPARSE_POINT_INFORMATION as REPARSE_POINT_INFORMATION ptr

union FILE_SEGMENT_ELEMENT
	Buffer as PVOID64
	Alignment as ULONGLONG
end union

type PFILE_SEGMENT_ELEMENT as FILE_SEGMENT_ELEMENT ptr

#define JOB_OBJECT_LIMIT_WORKINGSET &h0001
#define JOB_OBJECT_LIMIT_PROCESS_TIME &h0002
#define JOB_OBJECT_LIMIT_JOB_TIME &h0004
#define JOB_OBJECT_LIMIT_ACTIVE_PROCESS &h0008
#define JOB_OBJECT_LIMIT_AFFINITY &h0010
#define JOB_OBJECT_LIMIT_PRIORITY_CLASS &h0020
#define JOB_OBJECT_LIMIT_PRESERVE_JOB_TIME &h0040
#define JOB_OBJECT_LIMIT_SCHEDULING_CLASS &h0080
#define JOB_OBJECT_LIMIT_PROCESS_MEMORY &h0100
#define JOB_OBJECT_LIMIT_JOB_MEMORY &h0200
#define JOB_OBJECT_LIMIT_DIE_ON_UNHANDLED_EXCEPTION &h0400
#define JOB_OBJECT_BREAKAWAY_OK &h0800
#define JOB_OBJECT_SILENT_BREAKAWAY &h1000
#define JOB_OBJECT_UILIMIT_HANDLES &h0001
#define JOB_OBJECT_UILIMIT_READCLIPBOARD &h0002
#define JOB_OBJECT_UILIMIT_WRITECLIPBOARD &h0004
#define JOB_OBJECT_UILIMIT_SYSTEMPARAMETERS &h0008
#define JOB_OBJECT_UILIMIT_DISPLAYSETTINGS &h0010
#define JOB_OBJECT_UILIMIT_GLOBALATOMS &h0020
#define JOB_OBJECT_UILIMIT_DESKTOP &h0040
#define JOB_OBJECT_UILIMIT_EXITWINDOWS &h0080
#define JOB_OBJECT_SECURITY_NO_ADMIN &h0001
#define JOB_OBJECT_SECURITY_RESTRICTED_TOKEN &h0002
#define JOB_OBJECT_SECURITY_ONLY_TOKEN &h0004
#define JOB_OBJECT_SECURITY_FILTER_TOKENS &h0008
#define JOB_OBJECT_TERMINATE_AT_END_OF_JOB 0
#define JOB_OBJECT_POST_AT_END_OF_JOB 1
#define JOB_OBJECT_MSG_END_OF_JOB_TIME 1
#define JOB_OBJECT_MSG_END_OF_PROCESS_TIME 2
#define JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT 3
#define JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO 4
#define JOB_OBJECT_MSG_NEW_PROCESS 6
#define JOB_OBJECT_MSG_EXIT_PROCESS 7
#define JOB_OBJECT_MSG_ABNORMAL_EXIT_PROCESS 8
#define JOB_OBJECT_MSG_PROCESS_MEMORY_LIMIT 9
#define JOB_OBJECT_MSG_JOB_MEMORY_LIMIT 10

enum JOBOBJECTINFOCLASS
	JobObjectBasicAccountingInformation = 1
	JobObjectBasicLimitInformation
	JobObjectBasicProcessIdList
	JobObjectBasicUIRestrictions
	JobObjectSecurityLimitInformation
	JobObjectEndOfJobTimeInformation
	JobObjectAssociateCompletionPortInformation
	JobObjectBasicAndIoAccountingInformation
	JobObjectExtendedLimitInformation
	JobObjectJobSetInformation
	MaxJobObjectInfoClass
end enum

type JOBOBJECT_BASIC_ACCOUNTING_INFORMATION
	TotalUserTime as LARGE_INTEGER
	TotalKernelTime as LARGE_INTEGER
	ThisPeriodTotalUserTime as LARGE_INTEGER
	ThisPeriodTotalKernelTime as LARGE_INTEGER
	TotalPageFaultCount as DWORD
	TotalProcesses as DWORD
	ActiveProcesses as DWORD
	TotalTerminatedProcesses as DWORD
end type

type PJOBOBJECT_BASIC_ACCOUNTING_INFORMATION as JOBOBJECT_BASIC_ACCOUNTING_INFORMATION ptr

type JOBOBJECT_BASIC_LIMIT_INFORMATION
	PerProcessUserTimeLimit as LARGE_INTEGER
	PerJobUserTimeLimit as LARGE_INTEGER
	LimitFlags as DWORD
	MinimumWorkingSetSize as SIZE_T
	MaximumWorkingSetSize as SIZE_T
	ActiveProcessLimit as DWORD
	Affinity as ULONG_PTR
	PriorityClass as DWORD
	SchedulingClass as DWORD
end type

type PJOBOBJECT_BASIC_LIMIT_INFORMATION as JOBOBJECT_BASIC_LIMIT_INFORMATION ptr

type JOBOBJECT_BASIC_PROCESS_ID_LIST
	NumberOfAssignedProcesses as DWORD
	NumberOfProcessIdsInList as DWORD
	ProcessIdList(0 to 1-1) as ULONG_PTR
end type

type PJOBOBJECT_BASIC_PROCESS_ID_LIST as JOBOBJECT_BASIC_PROCESS_ID_LIST ptr

type JOBOBJECT_BASIC_UI_RESTRICTIONS
	UIRestrictionsClass as DWORD
end type

type PJOBOBJECT_BASIC_UI_RESTRICTIONS as JOBOBJECT_BASIC_UI_RESTRICTIONS ptr

type JOBOBJECT_SECURITY_LIMIT_INFORMATION
	SecurityLimitFlags as DWORD
	JobToken as HANDLE
	SidsToDisable as PTOKEN_GROUPS
	PrivilegesToDelete as PTOKEN_PRIVILEGES
	RestrictedSids as PTOKEN_GROUPS
end type

type PJOBOBJECT_SECURITY_LIMIT_INFORMATION as JOBOBJECT_SECURITY_LIMIT_INFORMATION ptr

type JOBOBJECT_END_OF_JOB_TIME_INFORMATION
	EndOfJobTimeAction as DWORD
end type

type PJOBOBJECT_END_OF_JOB_TIME_INFORMATION as JOBOBJECT_END_OF_JOB_TIME_INFORMATION ptr

type JOBOBJECT_ASSOCIATE_COMPLETION_PORT
	CompletionKey as PVOID
	CompletionPort as HANDLE
end type

type PJOBOBJECT_ASSOCIATE_COMPLETION_PORT as JOBOBJECT_ASSOCIATE_COMPLETION_PORT ptr

type JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION
	BasicInfo as JOBOBJECT_BASIC_ACCOUNTING_INFORMATION
	IoInfo as IO_COUNTERS
end type

type PJOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION as JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION ptr

type JOBOBJECT_EXTENDED_LIMIT_INFORMATION
	BasicLimitInformation as JOBOBJECT_BASIC_LIMIT_INFORMATION
	IoInfo as IO_COUNTERS
	ProcessMemoryLimit as SIZE_T
	JobMemoryLimit as SIZE_T
	PeakProcessMemoryUsed as SIZE_T
	PeakJobMemoryUsed as SIZE_T
end type

type PJOBOBJECT_EXTENDED_LIMIT_INFORMATION as JOBOBJECT_EXTENDED_LIMIT_INFORMATION ptr

type JOBOBJECT_JOBSET_INFORMATION
	MemberLevel as DWORD
end type

type PJOBOBJECT_JOBSET_INFORMATION as JOBOBJECT_JOBSET_INFORMATION ptr

#define ES_SYSTEM_REQUIRED &h00000001
#define ES_DISPLAY_REQUIRED &h00000002
#define ES_USER_PRESENT &h00000004
#define ES_CONTINUOUS &h80000000

enum LATENCY_TIME
	LT_DONT_CARE
	LT_LOWEST_LATENCY
end enum

type PLATENCY_TIME as LATENCY_TIME

enum SYSTEM_POWER_STATE
	PowerSystemUnspecified
	PowerSystemWorking
	PowerSystemSleeping1
	PowerSystemSleeping2
	PowerSystemSleeping3
	PowerSystemHibernate
	PowerSystemShutdown
	PowerSystemMaximum
end enum

type PSYSTEM_POWER_STATE as SYSTEM_POWER_STATE

enum POWER_ACTION
	PowerActionNone
	PowerActionReserved
	PowerActionSleep
	PowerActionHibernate
	PowerActionShutdown
	PowerActionShutdownReset
	PowerActionShutdownOff
	PowerActionWarmEject
end enum

enum DEVICE_POWER_STATE
	PowerDeviceUnspecified
	PowerDeviceD0
	PowerDeviceD1
	PowerDeviceD2
	PowerDeviceD3
	PowerDeviceMaximum
end enum

type PDEVICE_POWER_STATE as DEVICE_POWER_STATE

type BATTERY_REPORTING_SCALE
	Granularity as DWORD
	Capacity as DWORD
end type

type PBATTERY_REPORTING_SCALE as BATTERY_REPORTING_SCALE ptr

type POWER_ACTION_POLICY
	Action as POWER_ACTION
	Flags as ULONG
	EventCode as ULONG
end type

type PPOWER_ACTION_POLICY as POWER_ACTION_POLICY ptr

#define POWER_ACTION_QUERY_ALLOWED &h00000001
#define POWER_ACTION_UI_ALLOWED &h00000002
#define POWER_ACTION_OVERRIDE_APPS &h00000004
#define POWER_ACTION_LIGHTEST_FIRST &h10000000
#define POWER_ACTION_LOCK_CONSOLE &h20000000
#define POWER_ACTION_DISABLE_WAKES &h40000000
#define POWER_ACTION_CRITICAL &h80000000
#define POWER_LEVEL_USER_NOTIFY_TEXT &h00000001
#define POWER_LEVEL_USER_NOTIFY_SOUND &h00000002
#define POWER_LEVEL_USER_NOTIFY_EXEC &h00000004
#define POWER_USER_NOTIFY_BUTTON &h00000008
#define POWER_USER_NOTIFY_SHUTDOWN &h00000010
#define POWER_FORCE_TRIGGER_RESET &h80000000
#define DISCHARGE_POLICY_CRITICAL 0
#define DISCHARGE_POLICY_LOW 1
#define NUM_DISCHARGE_POLICIES 4
#define PO_THROTTLE_NONE 0
#define PO_THROTTLE_CONSTANT 1
#define PO_THROTTLE_DEGRADE 2
#define PO_THROTTLE_ADAPTIVE 3
#define PO_THROTTLE_MAXIMUM 4

type SYSTEM_POWER_LEVEL
	Enable as BOOLEAN
	Spare(0 to 3-1) as UCHAR
	BatteryLevel as ULONG
	PowerPolicy as POWER_ACTION_POLICY
	MinSystemState as SYSTEM_POWER_STATE
end type

type PSYSTEM_POWER_LEVEL as SYSTEM_POWER_LEVEL ptr

type SYSTEM_POWER_POLICY
	Revision as ULONG
	PowerButton as POWER_ACTION_POLICY
	SleepButton as POWER_ACTION_POLICY
	LidClose as POWER_ACTION_POLICY
	LidOpenWake as SYSTEM_POWER_STATE
	Reserved as ULONG
	Idle as POWER_ACTION_POLICY
	IdleTimeout as ULONG
	IdleSensitivity as UCHAR
	DynamicThrottle as UCHAR
	Spare2(0 to 2-1) as UCHAR
	MinSleep as SYSTEM_POWER_STATE
	MaxSleep as SYSTEM_POWER_STATE
	ReducedLatencySleep as SYSTEM_POWER_STATE
	WinLogonFlags as ULONG
	Spare3 as ULONG
	DozeS4Timeout as ULONG
	BroadcastCapacityResolution as ULONG
	DischargePolicy(0 to 4-1) as SYSTEM_POWER_LEVEL
	VideoTimeout as ULONG
	VideoDimDisplay as BOOLEAN
	VideoReserved(0 to 3-1) as ULONG
	SpindownTimeout as ULONG
	OptimizeForPower as BOOLEAN
	FanThrottleTolerance as UCHAR
	ForcedThrottle as UCHAR
	MinThrottle as UCHAR
	OverThrottled as POWER_ACTION_POLICY
end type

type PSYSTEM_POWER_POLICY as SYSTEM_POWER_POLICY ptr

type SYSTEM_POWER_CAPABILITIES
	PowerButtonPresent as BOOLEAN
	SleepButtonPresent as BOOLEAN
	LidPresent as BOOLEAN
	SystemS1 as BOOLEAN
	SystemS2 as BOOLEAN
	SystemS3 as BOOLEAN
	SystemS4 as BOOLEAN
	SystemS5 as BOOLEAN
	HiberFilePresent as BOOLEAN
	FullWake as BOOLEAN
	VideoDimPresent as BOOLEAN
	ApmPresent as BOOLEAN
	UpsPresent as BOOLEAN
	ThermalControl as BOOLEAN
	ProcessorThrottle as BOOLEAN
	ProcessorMinThrottle as UCHAR
	ProcessorMaxThrottle as UCHAR
	spare2(0 to 4-1) as UCHAR
	DiskSpinDown as BOOLEAN
	spare3(0 to 8-1) as UCHAR
	SystemBatteriesPresent as BOOLEAN
	BatteriesAreShortTerm as BOOLEAN
	BatteryScale(0 to 3-1) as BATTERY_REPORTING_SCALE
	AcOnLineWake as SYSTEM_POWER_STATE
	SoftLidWake as SYSTEM_POWER_STATE
	RtcWake as SYSTEM_POWER_STATE
	MinDeviceWakeState as SYSTEM_POWER_STATE
	DefaultLowLatencyWake as SYSTEM_POWER_STATE
end type

type PSYSTEM_POWER_CAPABILITIES as SYSTEM_POWER_CAPABILITIES ptr

type SYSTEM_BATTERY_STATE
	AcOnLine as BOOLEAN
	BatteryPresent as BOOLEAN
	Charging as BOOLEAN
	Discharging as BOOLEAN
	Spare1(0 to 4-1) as BOOLEAN
	MaxCapacity as ULONG
	RemainingCapacity as ULONG
	Rate as ULONG
	EstimatedTime as ULONG
	DefaultAlert1 as ULONG
	DefaultAlert2 as ULONG
end type

type PSYSTEM_BATTERY_STATE as SYSTEM_BATTERY_STATE ptr

enum POWER_INFORMATION_LEVEL
	SystemPowerPolicyAc
	SystemPowerPolicyDc
	VerifySystemPolicyAc
	VerifySystemPolicyDc
	SystemPowerCapabilities
	SystemBatteryState
	SystemPowerStateHandler
	ProcessorStateHandler
	SystemPowerPolicyCurrent
	AdministratorPowerPolicy
	SystemReserveHiberFile
	ProcessorInformation
	SystemPowerInformation
	ProcessorStateHandler2
	LastWakeTime
	LastSleepTime
	SystemExecutionState
	SystemPowerStateNotifyHandler
	ProcessorPowerPolicyAc
	ProcessorPowerPolicyDc
	VerifyProcessorPowerPolicyAc
	VerifyProcessorPowerPolicyDc
	ProcessorPowerPolicyCurrent
end enum

type PVECTORED_EXCEPTION_HANDLER as function (byval as PEXCEPTION_POINTERS) as LONG

type SYSTEM_POWER_INFORMATION
	MaxIdlenessAllowed as ULONG
	Idleness as ULONG
	TimeRemaining as ULONG
	CoolingMode as UCHAR
end type

type PSYSTEM_POWER_INFORMATION as SYSTEM_POWER_INFORMATION ptr

enum HEAP_INFORMATION_CLASS
	HeapCompatibilityInformation
end enum

enum ACTIVATION_CONTEXT_INFO_CLASS
	ActivationContextBasicInformation = 1
	ActivationContextDetailedInformation
	AssemblyDetailedInformationInActivationContext
	FileInformationInAssemblyOfAssemblyInActivationContext
end enum

type ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION
	ulFlags as DWORD
	ulEncodedAssemblyIdentityLength as DWORD
	ulManifestPathType as DWORD
	ulManifestPathLength as DWORD
	liManifestLastWriteTime as LARGE_INTEGER
	ulPolicyPathType as DWORD
	ulPolicyPathLength as DWORD
	liPolicyLastWriteTime as LARGE_INTEGER
	ulMetadataSatelliteRosterIndex as DWORD
	ulManifestVersionMajor as DWORD
	ulManifestVersionMinor as DWORD
	ulPolicyVersionMajor as DWORD
	ulPolicyVersionMinor as DWORD
	ulAssemblyDirectoryNameLength as DWORD
	lpAssemblyEncodedAssemblyIdentity as PCWSTR
	lpAssemblyManifestPath as PCWSTR
	lpAssemblyPolicyPath as PCWSTR
	lpAssemblyDirectoryName as PCWSTR
end type

type PACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION as ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION ptr
type PCACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION as ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION ptr

type ACTIVATION_CONTEXT_DETAILED_INFORMATION
	dwFlags as DWORD
	ulFormatVersion as DWORD
	ulAssemblyCount as DWORD
	ulRootManifestPathType as DWORD
	ulRootManifestPathChars as DWORD
	ulRootConfigurationPathType as DWORD
	ulRootConfigurationPathChars as DWORD
	ulAppDirPathType as DWORD
	ulAppDirPathChars as DWORD
	lpRootManifestPath as PCWSTR
	lpRootConfigurationPath as PCWSTR
	lpAppDirPath as PCWSTR
end type

type PACTIVATION_CONTEXT_DETAILED_INFORMATION as ACTIVATION_CONTEXT_DETAILED_INFORMATION ptr
type PCACTIVATION_CONTEXT_DETAILED_INFORMATION as ACTIVATION_CONTEXT_DETAILED_INFORMATION ptr

type ACTIVATION_CONTEXT_QUERY_INDEX
	ulAssemblyIndex as ULONG
	ulFileIndexInAssembly as ULONG
end type

type PACTIVATION_CONTEXT_QUERY_INDEX as ACTIVATION_CONTEXT_QUERY_INDEX ptr
type PCACTIVATION_CONTEXT_QUERY_INDEX as ACTIVATION_CONTEXT_QUERY_INDEX ptr

type ASSEMBLY_FILE_DETAILED_INFORMATION
	ulFlags as DWORD
	ulFilenameLength as DWORD
	ulPathLength as DWORD
	lpFileName as PCWSTR
	lpFilePath as PCWSTR
end type

type PASSEMBLY_FILE_DETAILED_INFORMATION as ASSEMBLY_FILE_DETAILED_INFORMATION ptr
type PCASSEMBLY_FILE_DETAILED_INFORMATION as ASSEMBLY_FILE_DETAILED_INFORMATION ptr

type PROCESSOR_POWER_POLICY_INFO
	TimeCheck as ULONG
	DemoteLimit as ULONG
	PromoteLimit as ULONG
	DemotePercent as UCHAR
	PromotePercent as UCHAR
	Spare(0 to 2-1) as UCHAR
	AllowDemotion:1 as ULONG
	AllowPromotion:1 as ULONG
	Reserved:30 as ULONG
end type

type PPROCESSOR_POWER_POLICY_INFO as PROCESSOR_POWER_POLICY_INFO ptr

type PROCESSOR_POWER_POLICY
	Revision as ULONG
	DynamicThrottle as UCHAR
	Spare(0 to 3-1) as UCHAR
	Reserved as ULONG
	PolicyCount as ULONG
	Policy(0 to 3-1) as PROCESSOR_POWER_POLICY_INFO
end type

type PPROCESSOR_POWER_POLICY as PROCESSOR_POWER_POLICY ptr

type ADMINISTRATOR_POWER_POLICY
	MinSleep as SYSTEM_POWER_STATE
	MaxSleep as SYSTEM_POWER_STATE
	MinVideoTimeout as ULONG
	MaxVideoTimeout as ULONG
	MinSpindownTimeout as ULONG
	MaxSpindownTimeout as ULONG
end type

type PADMINISTRATOR_POWER_POLICY as ADMINISTRATOR_POWER_POLICY ptr

type WAITORTIMERCALLBACKFUNC as sub (byval as PVOID, byval as BOOLEAN)

#ifdef UNICODE
type OSVERSIONINFO as OSVERSIONINFOW
type POSVERSIONINFO as OSVERSIONINFOW ptr
type LPOSVERSIONINFO as OSVERSIONINFOW ptr
type OSVERSIONINFOEX as OSVERSIONINFOEXW
type POSVERSIONINFOEX as OSVERSIONINFOEXW ptr
type LPOSVERSIONINFOEX as OSVERSIONINFOEXW ptr

#else ''UNICODE
type OSVERSIONINFO as OSVERSIONINFOA
type POSVERSIONINFO as OSVERSIONINFOA ptr
type LPOSVERSIONINFO as OSVERSIONINFOA ptr
type OSVERSIONINFOEX as OSVERSIONINFOEXA
type POSVERSIONINFOEX as OSVERSIONINFOEXA ptr
type LPOSVERSIONINFOEX as OSVERSIONINFOEXA ptr
#endif ''UNICODE

declare function VerSetConditionMask alias "VerSetConditionMask" (byval as ULONGLONG, byval as DWORD, byval as UBYTE) as ULONGLONG
declare function GetCurrentFiber alias "GetCurrentFiber" () as PVOID
declare function GetFiberData alias "GetFiberData" () as PVOID

#endif
