''
''
'' setupapi -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __win_setupapi_bi__
#define __win_setupapi_bi__

#inclib "setupapi"

#include once "win/commctrl.bi"

#define LINE_LEN 256
#define MAX_INF_STRING_LENGTH 4096
#define MAX_TITLE_LEN 60
#define MAX_INSTRUCTION_LEN 256
#define MAX_LABEL_LEN 30
#define MAX_SERVICE_NAME_LEN 256
#define MAX_SUBTITLE_LEN 256
#define SP_MAX_MACHINENAME_LENGTH (260+3)
#define COPYFLG_WARN_IF_SKIP &h00000001
#define COPYFLG_NOSKIP &h00000002
#define COPYFLG_NOVERSIONCHECK &h00000004
#define COPYFLG_FORCE_FILE_IN_USE &h00000008
#define COPYFLG_NO_OVERWRITE &h00000010
#define COPYFLG_NO_VERSION_DIALOG &h00000020
#define COPYFLG_OVERWRITE_OLDER_ONLY &h00000040
#define COPYFLG_REPLACEONLY &h00000400
#define COPYFLG_NODECOMP &h00000800
#define COPYFLG_REPLACE_BOOT_FILE &h00001000
#define COPYFLG_NOPRUNE &h00002000
#define DELFLG_IN_USE &h00000001
#define DELFLG_IN_USE1 &h00010000
#define DI_REMOVEDEVICE_GLOBAL &h00000001
#define DI_REMOVEDEVICE_CONFIGSPECIFIC &h00000002
#define DI_UNREMOVEDEVICE_CONFIGSPECIFIC &h00000002
#define DI_SHOWOEM &h00000001
#define DI_SHOWCOMPAT &h00000002
#define DI_SHOWCLASS &h00000004
#define DI_SHOWALL &h00000007
#define DI_NOVCP &h00000008
#define DI_DIDCOMPAT &h00000010
#define DI_DIDCLASS &h00000020
#define DI_AUTOASSIGNRES &h00000040
#define DI_NEEDRESTART &h00000080
#define DI_NEEDREBOOT &h00000100
#define DI_NOBROWSE &h00000200
#define DI_MULTMFGS &h00000400
#define DI_DISABLED &h00000800
#define DI_GENERALPAGE_ADDED &h00001000
#define DI_RESOURCEPAGE_ADDED &h00002000
#define DI_PROPERTIES_CHANGE &h00004000
#define DI_INF_IS_SORTED &h00008000
#define DI_ENUMSINGLEINF &h00010000
#define DI_DONOTCALLCONFIGMG &h00020000
#define DI_INSTALLDISABLED &h00040000
#define DI_COMPAT_FROM_CLASS &h00080000
#define DI_CLASSINSTALLPARAMS &h00100000
#define DI_NODI_DEFAULTACTION &h00200000
#define DI_QUIETINSTALL &h00800000
#define DI_NOFILECOPY &h01000000
#define DI_FORCECOPY &h02000000
#define DI_DRIVERPAGE_ADDED &h04000000
#define DI_USECI_SELECTSTRINGS &h08000000
#define DI_OVERRIDE_INFFLAGS &h10000000
#define DI_PROPS_NOCHANGEUSAGE &h20000000
#define DI_NOSELECTICONS &h40000000
#define DI_NOWRITE_IDS &h80000000
#define DI_FLAGSEX_USEOLDINFSEARCH &h00000001
#define DI_FLAGSEX_AUTOSELECTRANK0 &h00000002
#define DI_FLAGSEX_CI_FAILED &h00000004
#define DI_FLAGSEX_DIDINFOLIST &h00000010
#define DI_FLAGSEX_DIDCOMPATINFO &h00000020
#define DI_FLAGSEX_FILTERCLASSES &h00000040
#define DI_FLAGSEX_SETFAILEDINSTALL &h00000080
#define DI_FLAGSEX_DEVICECHANGE &h00000100
#define DI_FLAGSEX_ALWAYSWRITEIDS &h00000200
#define DI_FLAGSEX_PROPCHANGE_PENDING &h00000400
#define DI_FLAGSEX_ALLOWEXCLUDEDDRVS &h00000800
#define DI_FLAGSEX_NOUIONQUERYREMOVE &h00001000
#define DI_FLAGSEX_USECLASSFORCOMPAT &h00002000
#define DI_FLAGSEX_OLDINF_IN_CLASSLIST &h00004000
#define DI_FLAGSEX_NO_DRVREG_MODIFY &h00008000
#define DI_FLAGSEX_IN_SYSTEM_SETUP &h00010000
#define DI_FLAGSEX_INET_DRIVER &h00020000
#define DI_FLAGSEX_APPENDDRIVERLIST &h00040000
#define DI_FLAGSEX_PREINSTALLBACKUP &h00080000
#define DI_FLAGSEX_BACKUPONREPLACE &h00100000
#define DI_FLAGSEX_DRIVERLIST_FROM_URL &h00200000
#define DI_FLAGSEX_RESERVED1 &h00400000
#define DI_FLAGSEX_EXCLUDE_OLD_INET_DRIVERS &h00800000
#define DI_FLAGSEX_POWERPAGE_ADDED &h01000000
#define DIBCI_NOINSTALLCLASS &h00000001
#define DIBCI_NODISPLAYCLASS &h00000002
#define DICD_GENERATE_ID &h00000001
#define DICD_INHERIT_CLASSDRVS &h00000002
#define DICS_ENABLE 1
#define DICS_FLAG_GLOBAL 1
#define DICS_DISABLE 2
#define DICS_FLAG_CONFIGSPECIFIC 2
#define DICS_PROPCHANGE 3
#define DICS_START 4
#define DICS_FLAG_CONFIGGENERAL 4
#define DICS_STOP 5
#define DIF_SELECTDEVICE 1
#define DIF_INSTALLDEVICE 2
#define DIF_ASSIGNRESOURCES 3
#define DIF_PROPERTIES 4
#define DIF_REMOVE 5
#define DIF_FIRSTTIMESETUP 6
#define DIF_FOUNDDEVICE 7
#define DIF_SELECTCLASSDRIVERS 8
#define DIF_VALIDATECLASSDRIVERS 9
#define DIF_INSTALLCLASSDRIVERS 10
#define DIF_CALCDISKSPACE 11
#define DIF_DESTROYPRIVATEDATA 12
#define DIF_VALIDATEDRIVER 13
#define DIF_MOVEDEVICE 14
#define DIF_DETECT 15
#define DIF_INSTALLWIZARD 16
#define DIF_DESTROYWIZARDDATA 17
#define DIF_PROPERTYCHANGE 18
#define DIF_ENABLECLASS 19
#define DIF_DETECTVERIFY 20
#define DIF_INSTALLDEVICEFILES 21
#define DIF_UNREMOVE 22
#define DIF_SELECTBESTCOMPATDRV 23
#define DIF_ALLOW_INSTALL 24
#define DIF_REGISTERDEVICE 25
#define DIF_NEWDEVICEWIZARD_PRESELECT 26
#define DIF_NEWDEVICEWIZARD_SELECT 27
#define DIF_NEWDEVICEWIZARD_PREANALYZE 28
#define DIF_NEWDEVICEWIZARD_POSTANALYZE 29
#define DIF_NEWDEVICEWIZARD_FINISHINSTALL 30
#define DIF_UNUSED1 31
#define DIF_INSTALLINTERFACES 32
#define DIF_DETECTCANCEL 33
#define DIF_REGISTER_COINSTALLERS 34
#define DIF_ADDPROPERTYPAGE_ADVANCED 35
#define DIF_ADDPROPERTYPAGE_BASIC 36
#define DIF_RESERVED1 37
#define DIF_TROUBLESHOOTER 38
#define DIF_POWERMESSAGEWAKE 39
#define DIGCF_DEFAULT &h00000001
#define DIGCDP_FLAG_BASIC &h00000001
#define DIGCF_PRESENT &h00000002
#define DIGCDP_FLAG_ADVANCED &h00000002
#define DIGCF_ALLCLASSES &h00000004
#define DIGCF_PROFILE &h00000008
#define DIGCF_DEVICEINTERFACE &h00000010
#define DIGCF_INTERFACEDEVICE &h00000010
#define DIOCR_INSTALLER &h00000001
#define DIOCR_INTERFACE &h00000002
#define DIODI_NO_ADD &h00000001
#define DIOD_INHERIT_CLASSDRVS &h00000002
#define DIOD_CANCEL_REMOVE &h00000004
#define DIREG_DEV &h00000001
#define DIREG_DRV &h00000002
#define DIREG_BOTH &h00000004
#define DIRID_ABSOLUTE -1
#define DIRID_NULL 0
#define DIRID_SRCPATH 1
#define DIRID_WINDOWS 10
#define DIRID_SYSTEM 11
#define DIRID_DRIVERS 12
#define DIRID_INF 17
#define DIRID_HELP 18
#define DIRID_FONTS 20
#define DIRID_VIEWERS 21
#define DIRID_COLOR 23
#define DIRID_APPS 24
#define DIRID_SHARED 25
#define DIRID_BOOT 30
#define DIRID_SYSTEM16 50
#define DIRID_SPOOL 51
#define DIRID_SPOOLDRIVERS 52
#define DIRID_USERPROFILE 53
#define DIRID_LOADER 54
#define DIRID_PRINTPROCESSOR 55
#define DIRID_COMMON_STARTMENU 16406
#define DIRID_COMMON_PROGRAMS 16407
#define DIRID_COMMON_STARTUP 16408
#define DIRID_COMMON_DESKTOPDIRECTORY 16409
#define DIRID_COMMON_FAVORITES 16415
#define DIRID_COMMON_APPDATA 16419
#define DIRID_PROGRAM_FILES 16422
#define DIRID_SYSTEM_X86 16425
#define DIRID_PROGRAM_FILES_X86 16426
#define DIRID_PROGRAM_FILES_COMMON 16427
#define DIRID_PROGRAM_FILES_COMMONX86 16428
#define DIRID_COMMON_TEMPLATES 16429
#define DIRID_COMMON_DOCUMENTS 16430
#define DIRID_USER &h8000
#define DIRID_ABSOLUTE_16BIT &hffff
#define DIRID_IOSUBSYS 12
#define DIRID_DEFAULT 11
#define DMI_MASK &h00000001
#define DMI_BKCOLOR &h00000002
#define DMI_USERECT &h00000004
#define DNF_DUPDESC &h00000001
#define DNF_OLDDRIVER &h00000002
#define DNF_EXCLUDEFROMLIST &h00000004
#define DNF_NODRIVER &h00000008
#define DNF_LEGACYINF &h00000010
#define DNF_CLASS_DRIVER &h00000020
#define DNF_COMPATIBLE_DRIVER &h00000040
#define DNF_INET_DRIVER &h00000080
#define DNF_UNUSED1 &h00000100
#define DNF_INDEXED_DRIVER &h00000200
#define DNF_OLD_INET_DRIVER &h00000400
#define DNF_BAD_DRIVER &h00000800
#define DNF_DUPPROVIDER &h00001000
#define DPROMPT_SUCCESS 0
#define DPROMPT_CANCEL 1
#define DPROMPT_SKIPFILE 2
#define DPROMPT_BUFFERTOOSMALL 3
#define DPROMPT_OUTOFMEMORY 4
#define DRIVER_HARDWAREID_RANK &h00000FFF
#define DYNAWIZ_FLAG_PAGESADDED &h00000001
#define DYNAWIZ_FLAG_INSTALLDET_NEXT &h00000002
#define DYNAWIZ_FLAG_INSTALLDET_PREV &h00000004
#define DYNAWIZ_FLAG_ANALYZE_HANDLECONFLICT &h00000008
#define ENABLECLASS_QUERY 0
#define ENABLECLASS_SUCCESS 1
#define ENABLECLASS_FAILURE 2
#define ERROR_EXPECTED_SECTION_NAME (&h20000000 or &hC0000000 or 0)
#define ERROR_BAD_SECTION_NAME_LINE (&h20000000 or &hC0000000 or 1)
#define ERROR_SECTION_NAME_TOO_LONG (&h20000000 or &hC0000000 or 2)
#define ERROR_GENERAL_SYNTAX (&h20000000 or &hC0000000 or 3)
#define ERROR_WRONG_INF_STYLE (&h20000000 or &hC0000000 or &h100)
#define ERROR_NOT_INSTALLED (&h20000000 or &hC0000000 or &h1000)
#define ERROR_SECTION_NOT_FOUND (&h20000000 or &hC0000000 or &h101)
#define ERROR_LINE_NOT_FOUND (&h20000000 or &hC0000000 or &h102)
#define ERROR_NO_BACKUP (&h20000000 or &hC0000000 or &h103)
#define ERROR_NO_ASSOCIATED_CLASS (&h20000000 or &hC0000000 or &h200)
#define ERROR_CLASS_MISMATCH (&h20000000 or &hC0000000 or &h201)
#define ERROR_DUPLICATE_FOUND (&h20000000 or &hC0000000 or &h202)
#define ERROR_NO_DRIVER_SELECTED (&h20000000 or &hC0000000 or &h203)
#define ERROR_KEY_DOES_NOT_EXIST (&h20000000 or &hC0000000 or &h204)
#define ERROR_INVALID_DEVINST_NAME (&h20000000 or &hC0000000 or &h205)
#define ERROR_INVALID_CLASS (&h20000000 or &hC0000000 or &h206)
#define ERROR_DEVINST_ALREADY_EXISTS (&h20000000 or &hC0000000 or &h207)
#define ERROR_DEVINFO_NOT_REGISTERED (&h20000000 or &hC0000000 or &h208)
#define ERROR_INVALID_REG_PROPERTY (&h20000000 or &hC0000000 or &h209)
#define ERROR_NO_INF (&h20000000 or &hC0000000 or &h20A)
#define ERROR_NO_SUCH_DEVINST (&h20000000 or &hC0000000 or &h20B)
#define ERROR_CANT_LOAD_CLASS_ICON (&h20000000 or &hC0000000 or &h20C)
#define ERROR_INVALID_CLASS_INSTALLER (&h20000000 or &hC0000000 or &h20D)
#define ERROR_DI_DO_DEFAULT (&h20000000 or &hC0000000 or &h20E)
#define ERROR_DI_NOFILECOPY (&h20000000 or &hC0000000 or &h20F)
#define ERROR_INVALID_HWPROFILE (&h20000000 or &hC0000000 or &h210)
#define ERROR_NO_DEVICE_SELECTED (&h20000000 or &hC0000000 or &h211)
#define ERROR_DEVINFO_LIST_LOCKED (&h20000000 or &hC0000000 or &h212)
#define ERROR_DEVINFO_DATA_LOCKED (&h20000000 or &hC0000000 or &h213)
#define ERROR_DI_BAD_PATH (&h20000000 or &hC0000000 or &h214)
#define ERROR_NO_CLASSINSTALL_PARAMS (&h20000000 or &hC0000000 or &h215)
#define ERROR_FILEQUEUE_LOCKED (&h20000000 or &hC0000000 or &h216)
#define ERROR_BAD_SERVICE_INSTALLSECT (&h20000000 or &hC0000000 or &h217)
#define ERROR_NO_CLASS_DRIVER_LIST (&h20000000 or &hC0000000 or &h218)
#define ERROR_NO_ASSOCIATED_SERVICE (&h20000000 or &hC0000000 or &h219)
#define ERROR_NO_DEFAULT_DEVICE_INTERFACE (&h20000000 or &hC0000000 or &h21A)
#define ERROR_DEVICE_INTERFACE_ACTIVE (&h20000000 or &hC0000000 or &h21B)
#define ERROR_DEVICE_INTERFACE_REMOVED (&h20000000 or &hC0000000 or &h21C)
#define ERROR_BAD_INTERFACE_INSTALLSECT (&h20000000 or &hC0000000 or &h21D)
#define ERROR_NO_SUCH_INTERFACE_CLASS (&h20000000 or &hC0000000 or &h21E)
#define ERROR_INVALID_REFERENCE_STRING (&h20000000 or &hC0000000 or &h21F)
#define ERROR_INVALID_MACHINENAME (&h20000000 or &hC0000000 or &h220)
#define ERROR_REMOTE_COMM_FAILURE (&h20000000 or &hC0000000 or &h221)
#define ERROR_MACHINE_UNAVAILABLE (&h20000000 or &hC0000000 or &h222)
#define ERROR_NO_CONFIGMGR_SERVICES (&h20000000 or &hC0000000 or &h223)
#define ERROR_INVALID_PROPPAGE_PROVIDER (&h20000000 or &hC0000000 or &h224)
#define ERROR_NO_SUCH_DEVICE_INTERFACE (&h20000000 or &hC0000000 or &h225)
#define ERROR_DI_POSTPROCESSING_REQUIRED (&h20000000 or &hC0000000 or &h226)
#define ERROR_INVALID_COINSTALLER (&h20000000 or &hC0000000 or &h227)
#define ERROR_NO_COMPAT_DRIVERS (&h20000000 or &hC0000000 or &h228)
#define ERROR_NO_DEVICE_ICON (&h20000000 or &hC0000000 or &h229)
#define ERROR_INVALID_INF_LOGCONFIG (&h20000000 or &hC0000000 or &h22A)
#define ERROR_DI_DONT_INSTALL (&h20000000 or &hC0000000 or &h22B)
#define ERROR_INVALID_FILTER_DRIVER (&h20000000 or &hC0000000 or &h22C)
#define ERROR_NON_WINDOWS_NT_DRIVER (&h20000000 or &hC0000000 or &h22D)
#define ERROR_NON_WINDOWS_DRIVER (&h20000000 or &hC0000000 or &h22E)
#define ERROR_NO_CATALOG_FOR_OEM_INF (&h20000000 or &hC0000000 or &h22F)
#define ERROR_DEVINSTALL_QUEUE_NONNATIVE (&h20000000 or &hC0000000 or &h230)
#define ERROR_NOT_DISABLEABLE (&h20000000 or &hC0000000 or &h231)
#define ERROR_CANT_REMOVE_DEVINST (&h20000000 or &hC0000000 or &h232)
#define ERROR_INTERFACE_DEVICE_ACTIVE (&h20000000 or &hC0000000 or &h21B)
#define ERROR_INTERFACE_DEVICE_REMOVED (&h20000000 or &hC0000000 or &h21C)
#define ERROR_NO_DEFAULT_INTERFACE_DEVICE (&h20000000 or &hC0000000 or &h21A)
#define ERROR_NO_SUCH_INTERFACE_DEVICE (&h20000000 or &hC0000000 or &h225)
#define FILEOP_COPY 0
#define FILEOP_ABORT 0
#define FILE_COMPRESSION_NONE 0
#define FILEOP_RENAME 1
#define FILEOP_DOIT 1
#define FILE_COMPRESSION_WINLZA 1
#define FILEOP_DELETE 2
#define FILEOP_SKIP 2
#define FILE_COMPRESSION_MSZIP 2
#define FILEOP_BACKUP 3
#define FILE_COMPRESSION_NTCAB 3
#define FILEOP_NEWPATH 4
#define FILEOP_RETRY 1
#define FLG_ADDREG_TYPE_SZ &h00000000
#define FLG_ADDREG_BINVALUETYPE &h00000001
#define FLG_ADDREG_NOCLOBBER &h00000002
#define FLG_ADDREG_DELVAL &h00000004
#define FLG_ADDREG_APPEND &h00000008
#define FLG_ADDREG_KEYONLY &h00000010
#define FLG_ADDREG_OVERWRITEONLY &h00000020
#define FLG_ADDREG_TYPE_MULTI_SZ &h00010000
#define FLG_ADDREG_TYPE_EXPAND_SZ &h00020000
#define FLG_ADDREG_TYPE_BINARY (&h00000000 or &h00000001)
#define FLG_ADDREG_TYPE_DWORD (&h00010000 or &h00000001)
#define FLG_ADDREG_TYPE_NONE (&h00020000 or &h00000001)
#define FLG_ADDREG_TYPE_MASK (&hFFFF0000 or &h00000001)
#define FLG_DELREG_VALUE &h00000000
#define FLG_BITREG_CLEARBITS &h00000000
#define FLG_BITREG_SETBITS &h00000001
#define FLG_PROFITEM_CURRENTUSER &h00000001
#define FLG_PROFITEM_DELETE &h00000002
#define FLG_PROFITEM_GROUP &h00000004
#define FLG_PROFITEM_CSIDL &h00000008
#define FLG_REGSVR_DLLREGISTER &h00000001
#define FLG_REGSVR_DLLINSTALL &h00000002
#define MIN_IDD_DYNAWIZ_RESOURCE_ID 10000
#define MAX_IDD_DYNAWIZ_RESOURCE_ID 11000
#define IDD_DYNAWIZ_FIRSTPAGE 10000
#define IDD_DYNAWIZ_SELECT_PREVPAGE 10001
#define IDD_DYNAWIZ_SELECT_NEXTPAGE 10002
#define IDD_DYNAWIZ_ANALYZE_PREVPAGE 10003
#define IDD_DYNAWIZ_ANALYZE_NEXTPAGE 10004
#define IDD_DYNAWIZ_INSTALLDETECTED_PREVPAGE 10006
#define IDD_DYNAWIZ_INSTALLDETECTED_NEXTPAGE 10007
#define IDD_DYNAWIZ_INSTALLDETECTED_NODEVS 10008
#define IDD_DYNAWIZ_SELECTDEV_PAGE 10009
#define IDD_DYNAWIZ_ANALYZEDEV_PAGE 10010
#define IDD_DYNAWIZ_INSTALLDETECTEDDEVS_PAGE 10011
#define IDD_DYNAWIZ_SELECTCLASS_PAGE 10012
#define IDF_NOBROWSE &h00000001
#define IDF_NOSKIP &h00000002
#define IDF_NODETAILS &h00000004
#define IDF_NOCOMPRESSED &h00000008
#define IDF_CHECKFIRST &h00000100
#define IDF_NOBEEP &h00000200
#define IDF_NOFOREGROUND &h00000400
#define IDF_WARNIFSKIP &h00000800
#define IDF_OEMDISK &h80000000
#define IDI_RESOURCEFIRST 159
#define IDI_RESOURCE 159
#define IDI_RESOURCELAST 161
#define IDI_RESOURCEOVERLAYFIRST 161
#define IDI_RESOURCEOVERLAYLAST 161
#define IDI_CONFLICT 161
#define IDI_PROBLEM_OVL 500
#define IDI_DISABLED_OVL 501
#define IDI_FORCED_OVL 502
#define IDI_CLASSICON_OVERLAYFIRST 500
#define IDI_CLASSICON_OVERLAYLAST 502
#define INF_STYLE_NONE &h00000000
#define INF_STYLE_OLDNT &h00000001
#define INF_STYLE_WIN4 &h00000002
#define INF_STYLE_CACHE_ENABLE &h00000010
#define INF_STYLE_CACHE_DISABLE &h00000020
#define INFINFO_INF_SPEC_IS_HINF 1
#define INFINFO_INF_NAME_IS_ABSOLUTE 2
#define INFINFO_DEFAULT_SEARCH 3
#define INFINFO_REVERSE_DEFAULT_SEARCH 4
#define INFINFO_INF_PATH_LIST_SEARCH 5
#define LogSevInformation 0
#define LogSevWarning 1
#define LogSevError 2
#define LogSevFatalError 3
#define LogSevMaximum 4
#define MAX_INSTALLWIZARD_DYNAPAGES 20
#define NDW_INSTALLFLAG_DIDFACTDEFS &h00000001
#define NDW_INSTALLFLAG_HARDWAREALLREADYIN &h00000002
#define NDW_INSTALLFLAG_NEEDSHUTDOWN &h00000200
#define NDW_INSTALLFLAG_EXPRESSINTRO &h00000400
#define NDW_INSTALLFLAG_SKIPISDEVINSTALLED &h00000800
#define NDW_INSTALLFLAG_NODETECTEDDEVS &h00001000
#define NDW_INSTALLFLAG_INSTALLSPECIFIC &h00002000
#define NDW_INSTALLFLAG_SKIPCLASSLIST &h00004000
#define NDW_INSTALLFLAG_CI_PICKED_OEM &h00008000
#define NDW_INSTALLFLAG_PCMCIAMODE &h00010000
#define NDW_INSTALLFLAG_PCMCIADEVICE &h00020000
#define NDW_INSTALLFLAG_USERCANCEL &h00040000
#define NDW_INSTALLFLAG_KNOWNCLASS &h00080000
#define NDW_INSTALLFLAG_NEEDRESTART &h00000080
#define NDW_INSTALLFLAG_NEEDREBOOT &h00000100
#define SETDIRID_NOT_FULL_PATH &h00000001
#define SP_COPY_DELETESOURCE &h0000001
#define SP_COPY_REPLACEONLY &h0000002
#define SP_COPY_NEWER &h0000004
#define SP_COPY_NEWER_OR_SAME &h0000004
#define SP_COPY_NOOVERWRITE &h0000008
#define SP_COPY_NODECOMP &h0000010
#define SP_COPY_LANGUAGEAWARE &h0000020
#define SP_COPY_SOURCE_ABSOLUTE &h0000040
#define SP_COPY_SOURCEPATH_ABSOLUTE &h0000080
#define SP_COPY_IN_USE_NEEDS_REBOOT &h0000100
#define SP_COPY_FORCE_IN_USE &h0000200
#define SP_COPY_NOSKIP &h0000400
#define SP_COPY_FORCE_NOOVERWRITE &h0001000
#define SP_COPY_FORCE_NEWER &h0002000
#define SP_COPY_WARNIFSKIP &h0004000
#define SP_COPY_NOBROWSE &h0008000
#define SP_COPY_NEWER_ONLY &h0010000
#define SP_COPY_SOURCE_SIS_MASTER &h0020000
#define SP_COPY_OEMINF_CATALOG_ONLY &h0040000
#define SP_COPY_REPLACE_BOOT_FILE &h0080000
#define SP_COPY_NOPRUNE &h0100000
#define SP_FLAG_CABINETCONTINUATION &h0000800
#define SPCRP_SECURITY 23
#define SPCRP_SECURITY_SDS 24
#define SPCRP_DEVTYPE 25
#define SPCRP_EXCLUSIVE 26
#define SPCRP_CHARACTERISTICS 27
#define SPCRP_MAXIMUM_PROPERTY 28
#define SPDIT_NODRIVER 0
#define SPDIT_CLASSDRIVER 1
#define SPDIT_COMPATDRIVER 2
#define SPDRP_DEVICEDESC 0
#define SPDRP_HARDWAREID 1
#define SPDRP_COMPATIBLEIDS 2
#define SPDRP_UNUSED0 3
#define SPDRP_SERVICE 4
#define SPDRP_UNUSED1 5
#define SPDRP_UNUSED2 6
#define SPDRP_CLASS 7
#define SPDRP_CLASSGUID 8
#define SPDRP_DRIVER 9
#define SPDRP_CONFIGFLAGS 10
#define SPDRP_MFG 11
#define SPDRP_FRIENDLYNAME 12
#define SPDRP_LOCATION_INFORMATION 13
#define SPDRP_PHYSICAL_DEVICE_OBJECT_NAME 14
#define SPDRP_CAPABILITIES 15
#define SPDRP_UI_NUMBER 16
#define SPDRP_UPPERFILTERS 17
#define SPDRP_LOWERFILTERS 18
#define SPDRP_BUSTYPEGUID 19
#define SPDRP_LEGACYBUSTYPE 20
#define SPDRP_BUSNUMBER 21
#define SPDRP_ENUMERATOR_NAME 22
#define SPDRP_SECURITY 23
#define SPDRP_SECURITY_SDS 24
#define SPDRP_DEVTYPE 25
#define SPDRP_EXCLUSIVE 26
#define SPDRP_CHARACTERISTICS 27
#define SPDRP_ADDRESS 28
#define SPDRP_UI_NUMBER_DESC_FORMAT 30
#define SPDRP_MAXIMUM_PROPERTY 31
#define SPDSL_IGNORE_DISK 1
#define SPDSL_DISALLOW_NEGATIVE_ADJUST 2
#define SPFILENOTIFY_STARTQUEUE 1
#define SPFILENOTIFY_ENDQUEUE 2
#define SPFILENOTIFY_STARTSUBQUEUE 3
#define SPFILENOTIFY_ENDSUBQUEUE 4
#define SPFILENOTIFY_STARTDELETE 5
#define SPFILENOTIFY_ENDDELETE 6
#define SPFILENOTIFY_DELETEERROR 7
#define SPFILENOTIFY_STARTRENAME 8
#define SPFILENOTIFY_ENDRENAME 9
#define SPFILENOTIFY_RENAMEERROR 10
#define SPFILENOTIFY_STARTCOPY 11
#define SPFILENOTIFY_ENDCOPY 12
#define SPFILENOTIFY_COPYERROR 13
#define SPFILENOTIFY_NEEDMEDIA 14
#define SPFILENOTIFY_QUEUESCAN 15
#define SPFILENOTIFY_CABINETINFO 16
#define SPFILENOTIFY_FILEINCABINET 17
#define SPFILENOTIFY_NEEDNEWCABINET 18
#define SPFILENOTIFY_FILEEXTRACTED 19
#define SPFILENOTIFY_FILEOPDELAYED 20
#define SPFILENOTIFY_STARTBACKUP 21
#define SPFILENOTIFY_BACKUPERROR 22
#define SPFILENOTIFY_ENDBACKUP 23
#define SPFILENOTIFY_QUEUESCAN_EX 24
#define SPFILENOTIFY_LANGMISMATCH &h00010000
#define SPFILENOTIFY_TARGETEXISTS &h00020000
#define SPFILENOTIFY_TARGETNEWER &h00040000
#define SPFILELOG_SYSTEMLOG &h00000001
#define SPFILELOG_OEMFILE &h00000001
#define SPFILELOG_FORCENEW &h00000002
#define SPFILELOG_QUERYONLY &h00000004
#define SPFILEQ_FILE_IN_USE &h00000001
#define SPFILEQ_REBOOT_RECOMMENDED &h00000002
#define SPFILEQ_REBOOT_IN_PROGRESS &h00000004
#define SPINT_ACTIVE &h00000001
#define SPINT_DEFAULT &h00000002
#define SPINT_REMOVED &h00000004
#define SPID_ACTIVE &h00000001
#define SPID_DEFAULT &h00000002
#define SPID_REMOVED &h00000004
#define SPINST_LOGCONFIG &h00000001
#define SPINST_INIFILES &h00000002
#define SPINST_REGISTRY &h00000004
#define SPINST_INI2REG &h00000008
#define SPINST_FILES &h00000010
#define SPINST_BITREG &h00000020
#define SPINST_REGSVR &h00000040
#define SPINST_UNREGSVR &h00000080
#define SPINST_PROFILEITEMS &h00000100
#define SPINST_ALL &h000001ff
#define SPINST_SINGLESECTION &h00010000
#define SPINST_LOGCONFIG_IS_FORCED &h00020000
#define SPINST_LOGCONFIGS_ARE_OVERRIDES &h00040000
#define SPOST_NONE 0
#define SPOST_PATH 1
#define SPOST_URL 2
#define SPOST_MAX 3
#define SPPSR_SELECT_DEVICE_RESOURCES 1
#define SPPSR_ENUM_BASIC_DEVICE_PROPERTIES 2
#define SPPSR_ENUM_ADV_DEVICE_PROPERTIES 3
#define SPQ_SCAN_FILE_PRESENCE &h00000001
#define SPQ_DELAYED_COPY &h00000001
#define SPQ_SCAN_FILE_VALIDITY &h00000002
#define SPQ_SCAN_USE_CALLBACK &h00000004
#define SPQ_SCAN_USE_CALLBACKEX &h00000008
#define SPQ_SCAN_INFORM_USER &h00000010
#define SPQ_SCAN_PRUNE_COPY_QUEUE &h00000020
#define SPRDI_FIND_DUPS &h00000001
#define SPSVCINST_TAGTOFRONT &h00000001
#define SPSVCINST_ASSOCSERVICE &h00000002
#define SPSVCINST_DELETEEVENTLOGENTRY &h00000004
#define SPSVCINST_NOCLOBBER_DISPLAYNAME &h00000008
#define SPSVCINST_NOCLOBBER_STARTTYPE &h00000010
#define SPSVCINST_NOCLOBBER_ERRORCONTROL &h00000020
#define SPSVCINST_NOCLOBBER_LOADORDERGROUP &h00000040
#define SPSVCINST_NOCLOBBER_DEPENDENCIES &h00000080
#define SPSVCINST_NOCLOBBER_DESCRIPTION &h00000100
#define SPSVCINST_STOPSERVICE &h00000200
#define SPWPT_SELECTDEVICE &h00000001
#define SPWP_USE_DEVINFO_DATA &h00000001
#define SRCINFO_PATH 1
#define SRCINFO_TAGFILE 2
#define SRCINFO_DESCRIPTION 3
#define SRCINFO_FLAGS 4
#define SRCLIST_TEMPORARY &h00000001
#define SRCLIST_NOBROWSE &h00000002
#define SRCLIST_SYSTEM &h00000010
#define SRCLIST_USER &h00000020
#define SRCLIST_SYSIFADMIN &h00000040
#define SRCLIST_SUBDIRS &h00000100
#define SRCLIST_APPEND &h00000200
#define SRCLIST_NOSTRIPPLATFORM &h00000400

type HINF as PVOID
type HDSKSPC as PVOID
type HDEVINFO as PVOID
type HSPFILEQ as PVOID
type HSPFILELOG as PVOID
type DI_FUNCTION as UINT

enum SetupFileLogInfo
	SetupFileLogSourceFilename
	SetupFileLogChecksum
	SetupFileLogDiskTagfile
	SetupFileLogDiskDescription
	SetupFileLogOtherInfo
	SetupFileLogMax
end enum

type INFCONTEXT
	Inf as PVOID
	CurrentInf as PVOID
	Section as UINT
	Line as UINT
end type

type PINFCONTEXT as INFCONTEXT ptr

type SP_INF_INFORMATION
	InfStyle as DWORD
	InfCount as DWORD
	VersionData(0 to 1-1) as UBYTE
end type

type PSP_INF_INFORMATION as SP_INF_INFORMATION ptr

type SP_ALTPLATFORM_INFO
	cbSize as DWORD
	Platform as DWORD
	MajorVersion as DWORD
	MinorVersion as DWORD
	ProcessorArchitecture as WORD
	Reserved as WORD
end type

type PSP_ALTPLATFORM_INFO as SP_ALTPLATFORM_INFO ptr

#ifndef UNICODE
type SP_ORIGINAL_FILE_INFO_A
	cbSize as DWORD
	OriginalInfName as zstring * 260
	OriginalCatalogName as zstring * 260
end type

type PSP_ORIGINAL_FILE_INFO_A as SP_ORIGINAL_FILE_INFO_A ptr

#else
type SP_ORIGINAL_FILE_INFO_W
	cbSize as DWORD
	OriginalInfName as wstring * 260
	OriginalCatalogName as wstring * 260
end type

type PSP_ORIGINAL_FILE_INFO_W as SP_ORIGINAL_FILE_INFO_W ptr
#endif

#ifndef UNICODE
type FILEPATHS_A
	Target as PCSTR
	Source as PCSTR
	Win32Error as UINT
	Flags as DWORD
end type

type PFILEPATHS_A as FILEPATHS_A ptr

#else
type FILEPATHS_W
	Target as PCWSTR
	Source as PCWSTR
	Win32Error as UINT
	Flags as DWORD
end type

type PFILEPATHS_W as FILEPATHS_W ptr
#endif

#ifndef UNICODE
type SOURCE_MEDIA_A
	Reserved as PCSTR
	Tagfile as PCSTR
	Description as PCSTR
	SourcePath as PCSTR
	SourceFile as PCSTR
	Flags as DWORD
end type

type PSOURCE_MEDIA_A as SOURCE_MEDIA_A ptr

#else
type SOURCE_MEDIA_W
	Reserved as PCWSTR
	Tagfile as PCWSTR
	Description as PCWSTR
	SourcePath as PCWSTR
	SourceFile as PCWSTR
	Flags as DWORD
end type

type PSOURCE_MEDIA_W as SOURCE_MEDIA_W ptr
#endif

#ifndef UNICODE
type CABINET_INFO_A
	CabinetPath as PCSTR
	CabinetFile as PCSTR
	DiskName as PCSTR
	SetId as USHORT
	CabinetNumber as USHORT
end type

type PCABINET_INFO_A as CABINET_INFO_A ptr

#else
type CABINET_INFO_W
	CabinetPath as PCWSTR
	CabinetFile as PCWSTR
	DiskName as PCWSTR
	SetId as USHORT
	CabinetNumber as USHORT
end type

type PCABINET_INFO_W as CABINET_INFO_W ptr
#endif

#ifndef UNICODE
type FILE_IN_CABINET_INFO_A
	NameInCabinet as PCSTR
	FileSize as DWORD
	Win32Error as DWORD
	DosDate as WORD
	DosTime as WORD
	DosAttribs as WORD
	FullTargetName as zstring * 260
end type

type PFILE_IN_CABINET_INFO_A as FILE_IN_CABINET_INFO_A ptr

#else
type FILE_IN_CABINET_INFO_W
	NameInCabinet as PCWSTR
	FileSize as DWORD
	Win32Error as DWORD
	DosDate as WORD
	DosTime as WORD
	DosAttribs as WORD
	FullTargetName as wstring * 260
end type

type PFILE_IN_CABINET_INFO_W as FILE_IN_CABINET_INFO_W ptr
#endif

#ifndef UNICODE
type SP_FILE_COPY_PARAMS_A
	cbSize as DWORD
	QueueHandle as HSPFILEQ
	SourceRootPath as PCSTR
	SourcePath as PCSTR
	SourceFilename as PCSTR
	SourceDescription as PCSTR
	SourceTagfile as PCSTR
	TargetDirectory as PCSTR
	TargetFilename as PCSTR
	CopyStyle as DWORD
	LayoutInf as HINF
	SecurityDescriptor as PCSTR
end type

type PSP_FILE_COPY_PARAMS_A as SP_FILE_COPY_PARAMS_A ptr

#else
type SP_FILE_COPY_PARAMS_W
	cbSize as DWORD
	QueueHandle as HSPFILEQ
	SourceRootPath as PCWSTR
	SourcePath as PCWSTR
	SourceFilename as PCWSTR
	SourceDescription as PCWSTR
	SourceTagfile as PCWSTR
	TargetDirectory as PCWSTR
	TargetFilename as PCWSTR
	CopyStyle as DWORD
	LayoutInf as HINF
	SecurityDescriptor as PCWSTR
end type

type PSP_FILE_COPY_PARAMS_W as SP_FILE_COPY_PARAMS_W ptr
#endif

type SP_DEVINFO_DATA
	cbSize as DWORD
	ClassGuid as GUID
	DevInst as DWORD
	Reserved as ULONG_PTR
end type

type PSP_DEVINFO_DATA as SP_DEVINFO_DATA ptr

type SP_DEVICE_INTERFACE_DATA
	cbSize as DWORD
	InterfaceClassGuid as GUID
	Flags as DWORD
	Reserved as ULONG_PTR
end type

type PSP_DEVICE_INTERFACE_DATA as SP_DEVICE_INTERFACE_DATA ptr

#ifndef UNICODE
type SP_DEVICE_INTERFACE_DETAIL_DATA_A
	cbSize as DWORD
	DevicePath as zstring * 1
end type

type PSP_DEVICE_INTERFACE_DETAIL_DATA_A as SP_DEVICE_INTERFACE_DETAIL_DATA_A ptr

#else
type SP_DEVICE_INTERFACE_DETAIL_DATA_W
	cbSize as DWORD
	DevicePath as wstring * 1
end type

type PSP_DEVICE_INTERFACE_DETAIL_DATA_W as SP_DEVICE_INTERFACE_DETAIL_DATA_W ptr
#endif

#ifndef UNICODE
type SP_DEVINFO_LIST_DETAIL_DATA_A
	cbSize as DWORD
	ClassGuid as GUID
	RemoteMachineHandle as HANDLE
	RemoteMachineName as zstring * (260+3)
end type

type PSP_DEVINFO_LIST_DETAIL_DATA_A as SP_DEVINFO_LIST_DETAIL_DATA_A ptr
type PSP_FILE_CALLBACK_A as function(byval as PVOID, byval as UINT, byval as UINT_PTR, byval as UINT_PTR) as UINT

#else
type SP_DEVINFO_LIST_DETAIL_DATA_W
	cbSize as DWORD
	ClassGuid as GUID
	RemoteMachineHandle as HANDLE
	RemoteMachineName as wstring * 260+3
end type

type PSP_DEVINFO_LIST_DETAIL_DATA_W as SP_DEVINFO_LIST_DETAIL_DATA_W ptr
type PSP_FILE_CALLBACK_W as function(byval as PVOID, byval as UINT, byval as UINT_PTR, byval as UINT_PTR) as UINT
#endif

#ifndef UNICODE
type SP_DEVINSTALL_PARAMS_A
	cbSize as DWORD
	Flags as DWORD
	FlagsEx as DWORD
	hwndParent as HWND
	InstallMsgHandler as PSP_FILE_CALLBACK_A
	InstallMsgHandlerContext as PVOID
	FileQueue as HSPFILEQ
	ClassInstallReserved as ULONG_PTR
	Reserved as DWORD
	DriverPath as zstring * 260
end type

type PSP_DEVINSTALL_PARAMS_A as SP_DEVINSTALL_PARAMS_A ptr

#else
type SP_DEVINSTALL_PARAMS_W
	cbSize as DWORD
	Flags as DWORD
	FlagsEx as DWORD
	hwndParent as HWND
	InstallMsgHandler as PSP_FILE_CALLBACK_W
	InstallMsgHandlerContext as PVOID
	FileQueue as HSPFILEQ
	ClassInstallReserved as ULONG_PTR
	Reserved as DWORD
	DriverPath as wstring * 260
end type

type PSP_DEVINSTALL_PARAMS_W as SP_DEVINSTALL_PARAMS_W ptr
#endif

type SP_CLASSINSTALL_HEADER
	cbSize as DWORD
	InstallFunction as DI_FUNCTION
end type

type PSP_CLASSINSTALL_HEADER as SP_CLASSINSTALL_HEADER ptr

type SP_ENABLECLASS_PARAMS
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	ClassGuid as GUID
	EnableMessage as DWORD
end type

type PSP_ENABLECLASS_PARAMS as SP_ENABLECLASS_PARAMS ptr

type SP_MOVEDEV_PARAMS
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	SourceDeviceInfoData as SP_DEVINFO_DATA
end type

type PSP_MOVEDEV_PARAMS as SP_MOVEDEV_PARAMS ptr

type SP_PROPCHANGE_PARAMS
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	StateChange as DWORD
	Scope as DWORD
	HwProfile as DWORD
end type

type PSP_PROPCHANGE_PARAMS as SP_PROPCHANGE_PARAMS ptr

type SP_REMOVEDEVICE_PARAMS
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	Scope as DWORD
	HwProfile as DWORD
end type

type PSP_REMOVEDEVICE_PARAMS as SP_REMOVEDEVICE_PARAMS ptr

type SP_UNREMOVEDEVICE_PARAMS
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	Scope as DWORD
	HwProfile as DWORD
end type

type PSP_UNREMOVEDEVICE_PARAMS as SP_UNREMOVEDEVICE_PARAMS ptr

#ifndef UNICODE
type SP_SELECTDEVICE_PARAMS_A
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	Title as zstring * 60
	Instructions as zstring * 256
	ListLabel as zstring * 30
	SubTitle as zstring * 256
	Reserved(0 to 2-1) as UBYTE
end type

type PSP_SELECTDEVICE_PARAMS_A as SP_SELECTDEVICE_PARAMS_A ptr

#else
type SP_SELECTDEVICE_PARAMS_W
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	Title as wstring * 60
	Instructions as wstring * 256
	ListLabel as wstring * 30
	SubTitle as wstring * 256
end type

type PSP_SELECTDEVICE_PARAMS_W as SP_SELECTDEVICE_PARAMS_W ptr
#endif

type PDETECT_PROGRESS_NOTIFY as function(byval as PVOID, byval as DWORD) as BOOL

type SP_DETECTDEVICE_PARAMS
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	DetectProgressNotify as PDETECT_PROGRESS_NOTIFY
	ProgressNotifyParam as PVOID
end type

type PSP_DETECTDEVICE_PARAMS as SP_DETECTDEVICE_PARAMS ptr

type SP_INSTALLWIZARD_DATA
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	Flags as DWORD
	DynamicPages(0 to 20-1) as HPROPSHEETPAGE
	NumDynamicPages as DWORD
	DynamicPageFlags as DWORD
	PrivateFlags as DWORD
	PrivateData as LPARAM
	hwndWizardDlg as HWND
end type

type PSP_INSTALLWIZARD_DATA as SP_INSTALLWIZARD_DATA ptr

type SP_NEWDEVICEWIZARD_DATA
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	Flags as DWORD
	DynamicPages(0 to 20-1) as HPROPSHEETPAGE
	NumDynamicPages as DWORD
	hwndWizardDlg as HWND
end type

type PSP_NEWDEVICEWIZARD_DATA as SP_NEWDEVICEWIZARD_DATA ptr
type SP_ADDPROPERTYPAGE_DATA as SP_NEWDEVICEWIZARD_DATA
type PSP_ADDPROPERTYPAGE_DATA as SP_NEWDEVICEWIZARD_DATA ptr

#ifndef UNICODE
type SP_TROUBLESHOOTER_PARAMS_A
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	ChmFile as zstring * 260
	HtmlTroubleShooter as zstring * 260
end type

type PSP_TROUBLESHOOTER_PARAMS_A as SP_TROUBLESHOOTER_PARAMS_A ptr

#else
type SP_TROUBLESHOOTER_PARAMS_W
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	ChmFile as wstring * 260
	HtmlTroubleShooter as wstring * 260
end type

type PSP_TROUBLESHOOTER_PARAMS_W as SP_TROUBLESHOOTER_PARAMS_W ptr
#endif

#ifndef UNICODE
type SP_POWERMESSAGEWAKE_PARAMS_A
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	PowerMessageWake as zstring * 256*2
end type

type PSP_POWERMESSAGEWAKE_PARAMS_A as SP_POWERMESSAGEWAKE_PARAMS_A ptr

#else
type SP_POWERMESSAGEWAKE_PARAMS_W
	ClassInstallHeader as SP_CLASSINSTALL_HEADER
	PowerMessageWake as wstring * 256*2
end type

type PSP_POWERMESSAGEWAKE_PARAMS_W as SP_POWERMESSAGEWAKE_PARAMS_W ptr
#endif

#ifndef UNICODE
type SP_DRVINFO_DATA_V2_A
	cbSize as DWORD
	DriverType as DWORD
	Reserved as ULONG_PTR
	Description as zstring * 256
	MfgName as zstring * 256
	ProviderName as zstring * 256
	DriverDate as FILETIME
	DriverVersion_ as DWORDLONG
end type

type PSP_DRVINFO_DATA_V2_A as SP_DRVINFO_DATA_V2_A ptr

#else
type SP_DRVINFO_DATA_V2_W
	cbSize as DWORD
	DriverType as DWORD
	Reserved as ULONG_PTR
	Description as wstring * 256
	MfgName as wstring * 256
	ProviderName as wstring * 256
	DriverDate as FILETIME
	DriverVersion_ as DWORDLONG
end type

type PSP_DRVINFO_DATA_V2_W as SP_DRVINFO_DATA_V2_W ptr
#endif

#ifndef UNICODE
type SP_DRVINFO_DATA_V1_A
	cbSize as DWORD
	DriverType as DWORD
	Reserved as ULONG_PTR
	Description as zstring * 256
	MfgName as zstring * 256
	ProviderName as zstring * 256
end type

type PSP_DRVINFO_DATA_V1_A as SP_DRVINFO_DATA_V1_A ptr
type SP_DRVINFO_DATA_A as SP_DRVINFO_DATA_V2_A
type PSP_DRVINFO_DATA_A as SP_DRVINFO_DATA_V2_A ptr

#else
type SP_DRVINFO_DATA_V1_W
	cbSize as DWORD
	DriverType as DWORD
	Reserved as ULONG_PTR
	Description as wstring * 256
	MfgName as wstring * 256
	ProviderName as wstring * 256
end type

type PSP_DRVINFO_DATA_V1_W as SP_DRVINFO_DATA_V1_W ptr
type SP_DRVINFO_DATA_W as SP_DRVINFO_DATA_V2_W
type PSP_DRVINFO_DATA_W as SP_DRVINFO_DATA_V2_W ptr

#endif

type SP_DRVINFO_DATA as SP_DRVINFO_DATA_V2
type PSP_DRVINFO_DATA as SP_DRVINFO_DATA_V2 ptr

type SP_DRVINFO_DATA_V1 as SP_DRVINFO_DATA_V1_A
type PSP_DRVINFO_DATA_V1 as SP_DRVINFO_DATA_V1_A ptr
type SP_DRVINFO_DATA_V2 as SP_DRVINFO_DATA_V2_A
type PSP_DRVINFO_DATA_V2 as SP_DRVINFO_DATA_V2_A ptr

type PSP_DETSIG_CMPPROC as function(byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DEVINFO_DATA, byval as PVOID) as DWORD

#ifndef UNICODE
type SP_DRVINFO_DETAIL_DATA_A
	cbSize as DWORD
	InfDate as FILETIME
	CompatIDsOffset as DWORD
	CompatIDsLength as DWORD
	Reserved as ULONG_PTR
	SectionName as zstring * 256
	InfFileName as zstring * 260
	DrvDescription as zstring * 256
	HardwareID as zstring * 1
end type

type PSP_DRVINFO_DETAIL_DATA_A as SP_DRVINFO_DETAIL_DATA_A ptr

#else
type SP_DRVINFO_DETAIL_DATA_W
	cbSize as DWORD
	InfDate as FILETIME
	CompatIDsOffset as DWORD
	CompatIDsLength as DWORD
	Reserved as ULONG_PTR
	SectionName as wstring * 256
	InfFileName as wstring * 260
	DrvDescription as wstring * 256
	HardwareID as wstring * 1
end type

type PSP_DRVINFO_DETAIL_DATA_W as SP_DRVINFO_DETAIL_DATA_W ptr
#endif

type SP_DRVINSTALL_PARAMS
	cbSize as DWORD
	Rank as DWORD
	Flags as DWORD
	PrivateData as DWORD_PTR
	Reserved as DWORD
end type

type PSP_DRVINSTALL_PARAMS as SP_DRVINSTALL_PARAMS ptr

type COINSTALLER_CONTEXT_DATA
	PostProcessing as BOOL
	InstallResult as DWORD
	PrivateData as PVOID
end type

type PCOINSTALLER_CONTEXT_DATA as COINSTALLER_CONTEXT_DATA ptr

type SP_CLASSIMAGELIST_DATA
	cbSize as DWORD
	ImageList as HIMAGELIST
	Reserved as ULONG_PTR
end type

type PSP_CLASSIMAGELIST_DATA as SP_CLASSIMAGELIST_DATA ptr

type SP_PROPSHEETPAGE_REQUEST
	cbSize as DWORD
	PageRequested as DWORD
	DeviceInfoSet as HDEVINFO
	DeviceInfoData as PSP_DEVINFO_DATA
end type

type PSP_PROPSHEETPAGE_REQUEST as SP_PROPSHEETPAGE_REQUEST ptr

#ifndef UNICODE
type SP_BACKUP_QUEUE_PARAMS_A
	cbSize as DWORD
	FullInfPath as zstring * 260
	FilenameOffset as INT_
end type

type PSP_BACKUP_QUEUE_PARAMS_A as SP_BACKUP_QUEUE_PARAMS_A ptr

#else
type SP_BACKUP_QUEUE_PARAMS_W
	cbSize as DWORD
	FullInfPath as wstring * 260
	FilenameOffset as INT_
end type

type PSP_BACKUP_QUEUE_PARAMS_W as SP_BACKUP_QUEUE_PARAMS_W ptr
#endif

#ifdef UNICODE
type SP_ORIGINAL_FILE_INFO as SP_ORIGINAL_FILE_INFO_W
type PSP_ORIGINAL_FILE_INFO as SP_ORIGINAL_FILE_INFO_W ptr
type FILEPATHS as FILEPATHS_W
type PFILEPATHS as FILEPATHS_W ptr
type SOURCE_MEDIA as SOURCE_MEDIA_W
type PSOURCE_MEDIA as SOURCE_MEDIA_W ptr
type CABINET_INFO as CABINET_INFO_W
type PCABINET_INFO as CABINET_INFO_W ptr
type FILE_IN_CABINET_INFO as FILE_IN_CABINET_INFO_W
type PFILE_IN_CABINET_INFO as FILE_IN_CABINET_INFO_W ptr
type SP_FILE_COPY_PARAMS as SP_FILE_COPY_PARAMS_W
type PSP_FILE_COPY_PARAMS as SP_FILE_COPY_PARAMS_W ptr
type SP_DEVICE_INTERFACE_DETAIL_DATA as SP_DEVICE_INTERFACE_DETAIL_DATA_W
type PSP_DEVICE_INTERFACE_DETAIL_DATA as SP_DEVICE_INTERFACE_DETAIL_DATA_W ptr
type SP_INTERFACE_DEVICE_DETAIL_DATA as SP_INTERFACE_DEVICE_DETAIL_DATA_W
type PSP_INTERFACE_DEVICE_DETAIL_DATA as SP_INTERFACE_DEVICE_DETAIL_DATA_W ptr
type SP_DEVINFO_LIST_DETAIL_DATA as SP_DEVINFO_LIST_DETAIL_DATA_W
type PSP_DEVINFO_LIST_DETAIL_DATA as SP_DEVINFO_LIST_DETAIL_DATA_W ptr
type SP_DEVINSTALL_PARAMS as SP_DEVINSTALL_PARAMS_W
type PSP_DEVINSTALL_PARAMS as SP_DEVINSTALL_PARAMS_W ptr
type SP_SELECTDEVICE_PARAMS as SP_SELECTDEVICE_PARAMS_W
type PSP_SELECTDEVICE_PARAMS as SP_SELECTDEVICE_PARAMS_W ptr
type SP_TROUBLESHOOTER_PARAMS as SP_TROUBLESHOOTER_PARAMS_W
type PSP_TROUBLESHOOTER_PARAMS as SP_TROUBLESHOOTER_PARAMS_W ptr
type SP_POWERMESSAGEWAKE_PARAMS as SP_POWERMESSAGEWAKE_PARAMS_W
type PSP_POWERMESSAGEWAKE_PARAMS as SP_POWERMESSAGEWAKE_PARAMS_W ptr
type SP_DRVINFO_DETAIL_DATA as SP_DRVINFO_DETAIL_DATA_W
type PSP_DRVINFO_DETAIL_DATA as SP_DRVINFO_DETAIL_DATA_W ptr
type SP_BACKUP_QUEUE_PARAMS as SP_BACKUP_QUEUE_PARAMS_W
type PSP_BACKUP_QUEUE_PARAMS as SP_BACKUP_QUEUE_PARAMS_W ptr

#else
type SP_ORIGINAL_FILE_INFO as SP_ORIGINAL_FILE_INFO_A
type PSP_ORIGINAL_FILE_INFO as SP_ORIGINAL_FILE_INFO_A ptr
type FILEPATHS as FILEPATHS_A
type PFILEPATHS as FILEPATHS_A ptr
type SOURCE_MEDIA as SOURCE_MEDIA_A
type PSOURCE_MEDIA as SOURCE_MEDIA_A ptr
type CABINET_INFO as CABINET_INFO_A
type PCABINET_INFO as CABINET_INFO_A ptr
type FILE_IN_CABINET_INFO as FILE_IN_CABINET_INFO_A
type PFILE_IN_CABINET_INFO as FILE_IN_CABINET_INFO_A ptr
type SP_FILE_COPY_PARAMS as SP_FILE_COPY_PARAMS_A
type PSP_FILE_COPY_PARAMS as SP_FILE_COPY_PARAMS_A ptr
type SP_DEVICE_INTERFACE_DETAIL_DATA as SP_DEVICE_INTERFACE_DETAIL_DATA_A
type PSP_DEVICE_INTERFACE_DETAIL_DATA as SP_DEVICE_INTERFACE_DETAIL_DATA_A ptr
type SP_INTERFACE_DEVICE_DETAIL_DATA as SP_INTERFACE_DEVICE_DETAIL_DATA_A
type PSP_INTERFACE_DEVICE_DETAIL_DATA as SP_INTERFACE_DEVICE_DETAIL_DATA_A ptr
type SP_DEVINFO_LIST_DETAIL_DATA as SP_DEVINFO_LIST_DETAIL_DATA_A
type PSP_DEVINFO_LIST_DETAIL_DATA as SP_DEVINFO_LIST_DETAIL_DATA_A ptr
type SP_DEVINSTALL_PARAMS as SP_DEVINSTALL_PARAMS_A
type PSP_DEVINSTALL_PARAMS as SP_DEVINSTALL_PARAMS_A ptr
type SP_SELECTDEVICE_PARAMS as SP_SELECTDEVICE_PARAMS_A
type PSP_SELECTDEVICE_PARAMS as SP_SELECTDEVICE_PARAMS_A ptr
type SP_TROUBLESHOOTER_PARAMS as SP_TROUBLESHOOTER_PARAMS_A
type PSP_TROUBLESHOOTER_PARAMS as SP_TROUBLESHOOTER_PARAMS_A ptr
type SP_POWERMESSAGEWAKE_PARAMS as SP_POWERMESSAGEWAKE_PARAMS_A
type PSP_POWERMESSAGEWAKE_PARAMS as SP_POWERMESSAGEWAKE_PARAMS_A ptr
type SP_DRVINFO_DETAIL_DATA as SP_DRVINFO_DETAIL_DATA_A
type PSP_DRVINFO_DETAIL_DATA as SP_DRVINFO_DETAIL_DATA_A ptr
type SP_BACKUP_QUEUE_PARAMS as SP_BACKUP_QUEUE_PARAMS_A
type PSP_BACKUP_QUEUE_PARAMS as SP_BACKUP_QUEUE_PARAMS_A ptr
#endif

declare function SetupCancelTemporary alias "SetupCancelTemporary" () as BOOL
declare function SetupCloseFileQueue alias "SetupCloseFileQueue" (byval as HSPFILEQ) as BOOL
declare sub SetupCloseInfFile alias "SetupCloseInfFile" (byval as HINF)
declare sub SetupCloseLog alias "SetupCloseLog" ()
declare function SetupDestroyDiskSpaceList alias "SetupDestroyDiskSpaceList" (byval as HDSKSPC) as BOOL
declare function SetupDiAskForOEMDisk alias "SetupDiAskForOEMDisk" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiBuildClassInfoList alias "SetupDiBuildClassInfoList" (byval as DWORD, byval as LPGUID, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiBuildDriverInfoList alias "SetupDiBuildDriverInfoList" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD) as BOOL
declare function SetupDiCallClassInstaller alias "SetupDiCallClassInstaller" (byval as DI_FUNCTION, byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiCancelDriverInfoSearch alias "SetupDiCancelDriverInfoSearch" (byval as HDEVINFO) as BOOL
declare function SetupDiChangeState alias "SetupDiChangeState" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiCreateDeviceInfoList alias "SetupDiCreateDeviceInfoList" (byval as GUID ptr, byval as HWND) as HDEVINFO
declare function SetupDiDeleteDeviceInfo alias "SetupDiDeleteDeviceInfo" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiDeleteDeviceInterfaceData alias "SetupDiDeleteDeviceInterfaceData" (byval as HDEVINFO, byval as PSP_DEVICE_INTERFACE_DATA) as BOOL
declare function SetupDiDeleteDeviceInterfaceRegKey alias "SetupDiDeleteDeviceInterfaceRegKey" (byval as HDEVINFO, byval as PSP_DEVICE_INTERFACE_DATA, byval as DWORD) as BOOL
declare function SetupDiDeleteDevRegKey alias "SetupDiDeleteDevRegKey" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as DWORD, byval as DWORD) as BOOL
declare function SetupDiDestroyClassImageList alias "SetupDiDestroyClassImageList" (byval as PSP_CLASSIMAGELIST_DATA) as BOOL
declare function SetupDiDestroyDeviceInfoList alias "SetupDiDestroyDeviceInfoList" (byval as HDEVINFO) as BOOL
declare function SetupDiDestroyDriverInfoList alias "SetupDiDestroyDriverInfoList" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD) as BOOL
declare function SetupDiDrawMiniIcon alias "SetupDiDrawMiniIcon" (byval as HDC, byval as RECT, byval as INT_, byval as DWORD) as INT_
declare function SetupDiEnumDeviceInfo alias "SetupDiEnumDeviceInfo" (byval as HDEVINFO, byval as DWORD, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiEnumDeviceInterfaces alias "SetupDiEnumDeviceInterfaces" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as GUID ptr, byval as DWORD, byval as PSP_DEVICE_INTERFACE_DATA) as BOOL
declare function SetupDiGetClassBitmapIndex alias "SetupDiGetClassBitmapIndex" (byval as GUID ptr, byval as PINT) as BOOL
declare function SetupDiGetClassImageIndex alias "SetupDiGetClassImageIndex" (byval as PSP_CLASSIMAGELIST_DATA, byval as GUID ptr, byval as PINT) as BOOL
declare function SetupDiGetClassImageList alias "SetupDiGetClassImageList" (byval as PSP_CLASSIMAGELIST_DATA) as BOOL
declare function SetupDiGetDeviceInfoListClass alias "SetupDiGetDeviceInfoListClass" (byval as HDEVINFO, byval as LPGUID) as BOOL
declare function SetupDiGetDeviceInterfaceAlias alias "SetupDiGetDeviceInterfaceAlias" (byval as HDEVINFO, byval as PSP_DEVICE_INTERFACE_DATA, byval as GUID ptr, byval as PSP_DEVICE_INTERFACE_DATA) as BOOL
declare function SetupDiGetHwProfileList alias "SetupDiGetHwProfileList" (byval as PDWORD, byval as DWORD, byval as PDWORD, byval as PDWORD) as BOOL
declare function SetupDiGetSelectedDevice alias "SetupDiGetSelectedDevice" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiGetWizardage alias "SetupDiGetWizardage" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_INSTALLWIZARD_DATA, byval as DWORD, byval as DWORD) as HPROPSHEETPAGE
declare function SetupDiInstallDevice alias "SetupDiInstallDevice" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiInstallDeviceInterfaces alias "SetupDiInstallDeviceInterfaces" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiInstallDriverFiles alias "SetupDiInstallDriverFiles" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiLoadClassIcon alias "SetupDiLoadClassIcon" (byval as GUID ptr, byval as HICON ptr, byval as PINT) as BOOL
declare function SetupDiMoveDuplicateDevice alias "SetupDiMoveDuplicateDevice" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiOpenClassRegKey alias "SetupDiOpenClassRegKey" (byval as GUID ptr, byval as REGSAM) as HKEY
declare function SetupDiOpenDeviceInterfaceRegKey alias "SetupDiOpenDeviceInterfaceRegKey" (byval as HDEVINFO, byval as PSP_DEVICE_INTERFACE_DATA, byval as DWORD, byval as REGSAM) as HKEY
declare function SetupDiOpenDevRegKey alias "SetupDiOpenDevRegKey" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as DWORD, byval as DWORD, byval as REGSAM) as HKEY
declare function SetupDiRegisterCoDeviceInstallers alias "SetupDiRegisterCoDeviceInstallers" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiRegisterDeviceInfo alias "SetupDiRegisterDeviceInfo" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as PSP_DETSIG_CMPPROC, byval as PVOID, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiRemoveDevice alias "SetupDiRemoveDevice" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiRemoveDeviceInterface alias "SetupDiRemoveDeviceInterface" (byval as HDEVINFO, byval as PSP_DEVICE_INTERFACE_DATA) as BOOL
declare function SetupDiSelectBestCompatDrv alias "SetupDiSelectBestCompatDrv" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiSelectDevice alias "SetupDiSelectDevice" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiSelectOEMDrv alias "SetupDiSelectOEMDrv" (byval as HWND, byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiSetSelectedDevice alias "SetupDiSetSelectedDevice" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiUnremoveDevice alias "SetupDiUnremoveDevice" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupFindNextLine alias "SetupFindNextLine" (byval as PINFCONTEXT, byval as PINFCONTEXT) as BOOL
declare function SetupGetBinaryField alias "SetupGetBinaryField" (byval as PINFCONTEXT, byval as DWORD, byval as PBYTE, byval as DWORD, byval as LPDWORD) as BOOL
declare function SetupGetFieldCount alias "SetupGetFieldCount" (byval as PINFCONTEXT) as DWORD
declare function SetupGetIntField alias "SetupGetIntField" (byval as PINFCONTEXT, byval as DWORD, byval as PINT) as BOOL
declare function SetupInitDefaultQueueCallback alias "SetupInitDefaultQueueCallback" (byval as HWND) as PVOID
declare function SetupInitDefaultQueueCallbackEx alias "SetupInitDefaultQueueCallbackEx" (byval as HWND, byval as HWND, byval as UINT, byval as DWORD, byval as PVOID) as PVOID
declare function SetupOpenFileQueue alias "SetupOpenFileQueue" () as HSPFILEQ
declare function SetupOpenLog alias "SetupOpenLog" (byval as BOOL) as BOOL
declare function SetupOpenMasterInf alias "SetupOpenMasterInf" () as HINF
declare function SetupPromptReboot alias "SetupPromptReboot" (byval as HSPFILEQ, byval as HWND, byval as BOOL) as INT_
declare sub SetupTermDefaultQueueCallback alias "SetupTermDefaultQueueCallback" (byval as PVOID)
declare function SetupTerminateFileLog alias "SetupTerminateFileLog" (byval as HSPFILELOG) as BOOL

#ifdef UNICODE
declare function SetupAddInstallSectionToDiskSpaceList alias "SetupAddInstallSectionToDiskSpaceListW" (byval as HDSKSPC, byval as HINF, byval as HINF, byval as PCWSTR, byval as PVOID, byval as UINT) as BOOL
declare function SetupAddSectionToDiskSpaceList alias "SetupAddSectionToDiskSpaceListW" (byval as HDSKSPC, byval as HINF, byval as HINF, byval as PCWSTR, byval as UINT, byval as PVOID, byval as UINT) as BOOL
declare function SetupAddToDiskSpaceList alias "SetupAddToDiskSpaceListW" (byval as HDSKSPC, byval as PCWSTR, byval as LONGLONG, byval as UINT, byval as PVOID, byval as UINT) as BOOL
declare function SetupAddToSourceList alias "SetupAddToSourceListW" (byval as DWORD, byval as PCWSTR) as BOOL
declare function SetupAdjustDiskSpaceList alias "SetupAdjustDiskSpaceListW" (byval as HDSKSPC, byval as LPCWSTR, byval as LONGLONG, byval as PVOID, byval as UINT) as BOOL
declare function SetupBackupError alias "SetupBackupErrorW" (byval as HWND, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as UINT, byval as DWORD) as UINT
declare function SetupCommitFileQueue alias "SetupCommitFileQueueW" (byval as HWND, byval as HSPFILEQ, byval as PSP_FILE_CALLBACK_W, byval as PVOID) as BOOL
declare function SetupCopyError alias "SetupCopyErrorW" (byval as HWND, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as UINT, byval as DWORD, byval as PWSTR, byval as DWORD, byval as PDWORD) as UINT
declare function SetupCopyOEMInf alias "SetupCopyOEMInfW" (byval as PCWSTR, byval as PCWSTR, byval as DWORD, byval as DWORD, byval as PWSTR, byval as DWORD, byval as PDWORD, byval as PWSTR ptr) as BOOL
declare function SetupCreateDiskSpaceList alias "SetupCreateDiskSpaceListW" (byval as PVOID, byval as DWORD, byval as UINT) as HDSKSPC
declare function SetupDecompressOrCopyFile alias "SetupDecompressOrCopyFileW" (byval as PCWSTR, byval as PCWSTR, byval as PUINT) as DWORD
declare function SetupDefaultQueueCallback alias "SetupDefaultQueueCallbackW" (byval as PVOID, byval as UINT, byval as UINT_PTR, byval as UINT_PTR) as UINT
declare function SetupDeleteError alias "SetupDeleteErrorW" (byval as HWND, byval as PCWSTR, byval as PCWSTR, byval as UINT, byval as DWORD) as UINT
declare function SetupDiBuildClassInfoListEx alias "SetupDiBuildClassInfoListExW" (byval as DWORD, byval as LPGUID, byval as DWORD, byval as PDWORD, byval as PCWSTR, byval as PVOID) as BOOL
declare function SetupDiClassGuidsFromName alias "SetupDiClassGuidsFromNameW" (byval as PCWSTR, byval as LPGUID, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiClassGuidsFromNameEx alias "SetupDiClassGuidsFromNameExW" (byval as PCWSTR, byval as LPGUID, byval as DWORD, byval as PDWORD, byval as PCWSTR, byval as PVOID) as BOOL
declare function SetupDiClassNameFromGuid alias "SetupDiClassNameFromGuidW" (byval as GUID ptr, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiClassNameFromGuidEx alias "SetupDiClassNameFromGuidExW" (byval as GUID ptr, byval as PWSTR, byval as DWORD, byval as PDWORD, byval as PCWSTR, byval as PVOID) as BOOL
declare function SetupDiCreateDeviceInfo alias "SetupDiCreateDeviceInfoW" (byval as HDEVINFO, byval as PCWSTR, byval as GUID ptr, byval as PCWSTR, byval as HWND, byval as DWORD, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiCreateDeviceInfoListEx alias "SetupDiCreateDeviceInfoListExW" (byval as GUID ptr, byval as HWND, byval as PCWSTR, byval as PVOID) as HDEVINFO
declare function SetupDiCreateDeviceInterface alias "SetupDiCreateDeviceInterfaceW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as GUID ptr, byval as PCWSTR, byval as DWORD, byval as PSP_DEVICE_INTERFACE_DATA) as BOOL
declare function SetupDiCreateDeviceInterfaceRegKey alias "SetupDiCreateDeviceInterfaceRegKeyW" (byval as HDEVINFO, byval as PSP_DEVICE_INTERFACE_DATA, byval as DWORD, byval as REGSAM, byval as HINF, byval as PCWSTR) as HKEY
declare function SetupDiCreateDevRegKey alias "SetupDiCreateDevRegKeyW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as DWORD, byval as DWORD, byval as HINF, byval as PCWSTR) as HKEY
declare function SetupDiEnumDriverInfo alias "SetupDiEnumDriverInfoW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as DWORD, byval as PSP_DRVINFO_DATA_W) as BOOL
declare function SetupDiGetActualSectionToInstall alias "SetupDiGetActualSectionToInstallW" (byval as HINF, byval as PCWSTR, byval as PWSTR, byval as DWORD, byval as PDWORD, byval as PWSTR ptr) as BOOL
declare function SetupDiGetClassDescription alias "SetupDiGetClassDescriptionW" (byval as GUID ptr, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetClassDescriptionEx alias "SetupDiGetClassDescriptionExW" (byval as GUID ptr, byval as PWSTR, byval as DWORD, byval as PDWORD, byval as PCWSTR, byval as PVOID) as BOOL
declare function SetupDiGetClassDevPropertySheets alias "SetupDiGetClassDevPropertySheetsW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as LPPROPSHEETHEADERW, byval as DWORD, byval as PDWORD, byval as DWORD) as BOOL
declare function SetupDiGetClassDevs alias "SetupDiGetClassDevsW" (byval as GUID ptr, byval as PCWSTR, byval as HWND, byval as DWORD) as HDEVINFO
declare function SetupDiGetClassDevsEx alias "SetupDiGetClassDevsExW" (byval as GUID ptr, byval as PCWSTR, byval as HWND, byval as DWORD, byval as HDEVINFO, byval as PCWSTR, byval as PVOID) as HDEVINFO
declare function SetupDiGetClassImageListEx alias "SetupDiGetClassImageListExW" (byval as PSP_CLASSIMAGELIST_DATA, byval as PCWSTR, byval as PVOID) as BOOL
declare function SetupDiGetClassInstallParams alias "SetupDiGetClassInstallParamsW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_CLASSINSTALL_HEADER, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetClassRegistryProperty alias "SetupDiGetClassRegistryPropertyW" (byval as LPGUID, byval as DWORD, byval as PDWORD, byval as PBYTE, byval as DWORD, byval as PDWORD, byval as PCWSTR, byval as PVOID) as BOOL
declare function SetupDiGetDeviceInfoListDetail alias "SetupDiGetDeviceInfoListDetailW" (byval as HDEVINFO, byval as PSP_DEVINFO_LIST_DETAIL_DATA_W) as BOOL
declare function SetupDiGetDeviceInstallParams alias "SetupDiGetDeviceInstallParamsW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DEVINSTALL_PARAMS_W) as BOOL
declare function SetupDiGetDeviceInstanceId alias "SetupDiGetDeviceInstanceIdW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetDeviceInterfaceDetail alias "SetupDiGetDeviceInterfaceDetailW" (byval as HDEVINFO, byval as PSP_DEVICE_INTERFACE_DATA, byval as PSP_DEVICE_INTERFACE_DETAIL_DATA_W, byval as DWORD, byval as PDWORD, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiGetDeviceRegistryProperty alias "SetupDiGetDeviceRegistryPropertyW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as PDWORD, byval as PBYTE, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetDriverInfoDetail alias "SetupDiGetDriverInfoDetailW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_W, byval as PSP_DRVINFO_DETAIL_DATA_W, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetDriverInstallParams alias "SetupDiGetDriverInstallParamsW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_W, byval as PSP_DRVINSTALL_PARAMS) as BOOL
declare function SetupDiGetHwProfileFriendlyNameEx alias "SetupDiGetHwProfileFriendlyNameExW" (byval as DWORD, byval as PWSTR, byval as DWORD, byval as PDWORD, byval as PCWSTR, byval as PVOID) as BOOL
declare function SetupDiGetHwProfileFriendlyName alias "SetupDiGetHwProfileFriendlyNameW" (byval as DWORD, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetHwProfileListEx alias "SetupDiGetHwProfileListExW" (byval as PDWORD, byval as DWORD, byval as PDWORD, byval as PDWORD, byval as PCWSTR, byval as PVOID) as BOOL
declare function SetupDiGetINFClass alias "SetupDiGetINFClassW" (byval as PCWSTR, byval as LPGUID, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetSelectedDriver alias "SetupDiGetSelectedDriverW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_W) as BOOL
declare function SetupDiInstallClass alias "SetupDiInstallClassW" (byval as HWND, byval as PCWSTR, byval as DWORD, byval as HSPFILEQ) as BOOL
declare function SetupDiInstallClassEx alias "SetupDiInstallClassExW" (byval as HWND, byval as PCWSTR, byval as DWORD, byval as HSPFILEQ, byval as GUID ptr, byval as PVOID, byval as PVOID) as BOOL
declare function SetupDiOpenClassRegKeyEx alias "SetupDiOpenClassRegKeyExW" (byval as GUID ptr, byval as REGSAM, byval as DWORD, byval as PCWSTR, byval as PVOID) as HKEY
declare function SetupDiOpenDeviceInfo alias "SetupDiOpenDeviceInfoW" (byval as HDEVINFO, byval as PCWSTR, byval as HWND, byval as DWORD, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiOpenDeviceInterface alias "SetupDiOpenDeviceInterfaceW" (byval as HDEVINFO, byval as PCWSTR, byval as DWORD, byval as PSP_DEVICE_INTERFACE_DATA) as BOOL
declare function SetupDiSetClassInstallParams alias "SetupDiSetClassInstallParamsW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_CLASSINSTALL_HEADER, byval as DWORD) as BOOL
declare function SetupDiSetClassRegistryProperty alias "SetupDiSetClassRegistryPropertyW" (byval as LPGUID, byval as DWORD, byval as UBYTE ptr, byval as DWORD, byval as PCWSTR, byval as PVOID) as BOOL
declare function SetupDiSetDeviceInstallParams alias "SetupDiSetDeviceInstallParamsW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DEVINSTALL_PARAMS_W) as BOOL
declare function SetupDiSetDeviceRegistryProperty alias "SetupDiSetDeviceRegistryPropertyW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as UBYTE ptr, byval as DWORD) as BOOL
declare function SetupDiSetDriverInstallParams alias "SetupDiSetDriverInstallParamsW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_W, byval as PSP_DRVINSTALL_PARAMS) as BOOL
declare function SetupDiSetSelectedDriver alias "SetupDiSetSelectedDriverW" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_W) as BOOL
declare function SetupDuplicateDiskSpaceList alias "SetupDuplicateDiskSpaceListW" (byval as HDSKSPC, byval as PVOID, byval as DWORD, byval as UINT) as HDSKSPC
declare function SetupFindFirstLine alias "SetupFindFirstLineW" (byval as HINF, byval as PCWSTR, byval as PCWSTR, byval as PINFCONTEXT) as BOOL
declare function SetupFindNextMatchLine alias "SetupFindNextMatchLineW" (byval as PINFCONTEXT, byval as PCWSTR, byval as PINFCONTEXT) as BOOL
declare function SetupFree alias "SetupFreeW" (byval as PCWSTR ptr ptr, byval as UINT) as BOOL
declare function SetupGetBackupInformation alias "SetupGetBackupInformationW" (byval as HSPFILEQ, byval as PSP_BACKUP_QUEUE_PARAMS_W) as BOOL
declare function SetupGetFileCompressionInfo alias "SetupGetFileCompressionInfoW" (byval as PCWSTR, byval as PWSTR ptr, byval as PDWORD, byval as PDWORD, byval as PUINT) as DWORD
declare function SetupGetInfFileList alias "SetupGetInfFileListW" (byval as PCWSTR, byval as DWORD, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetInfInformation alias "SetupGetInfInformationW" (byval as LPCVOID, byval as DWORD, byval as PSP_INF_INFORMATION, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetLineByIndex alias "SetupGetLineByIndexW" (byval as HINF, byval as PCWSTR, byval as DWORD, byval as PINFCONTEXT) as BOOL
declare function SetupGetLineCount alias "SetupGetLineCountW" (byval as HINF, byval as PCWSTR) as LONG
declare function SetupGetLineText alias "SetupGetLineTextW" (byval as PINFCONTEXT, byval as HINF, byval as PCWSTR, byval as PCWSTR, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetMultiSzField alias "SetupGetMultiSzFieldW" (byval as PINFCONTEXT, byval as DWORD, byval as PWSTR, byval as DWORD, byval as LPDWORD) as BOOL
declare function SetupGetSourceFileLocation alias "SetupGetSourceFileLocationW" (byval as HINF, byval as PINFCONTEXT, byval as PCWSTR, byval as PUINT, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetSourceFileSize alias "SetupGetSourceFileSizeW" (byval as HINF, byval as PINFCONTEXT, byval as PCWSTR, byval as PCWSTR, byval as PDWORD, byval as UINT) as BOOL
declare function SetupGetSourceInfo alias "SetupGetSourceInfoW" (byval as HINF, byval as UINT, byval as UINT, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetStringField alias "SetupGetStringFieldW" (byval as PINFCONTEXT, byval as DWORD, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetTargetPath alias "SetupGetTargetPathW" (byval as HINF, byval as PINFCONTEXT, byval as PCWSTR, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupInitializeFileLog alias "SetupInitializeFileLogW" (byval as PCWSTR, byval as DWORD) as HSPFILELOG
declare function SetupInstallFile alias "SetupInstallFileW" (byval as HINF, byval as PINFCONTEXT, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as DWORD, byval as PSP_FILE_CALLBACK_W, byval as PVOID) as BOOL
declare function SetupInstallFileEx alias "SetupInstallFileExW" (byval as HINF, byval as PINFCONTEXT, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as DWORD, byval as PSP_FILE_CALLBACK_W, byval as PVOID, byval as PBOOL) as BOOL
declare function SetupInstallFilesFromInfSection alias "SetupInstallFilesFromInfSectionW" (byval as HINF, byval as HINF, byval as HSPFILEQ, byval as PCWSTR, byval as PCWSTR, byval as UINT) as BOOL
declare function SetupInstallFromInfSection alias "SetupInstallFromInfSectionW" (byval as HWND, byval as HINF, byval as PCWSTR, byval as UINT, byval as HKEY, byval as PCWSTR, byval as UINT, byval as PSP_FILE_CALLBACK_W, byval as PVOID, byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupInstallServicesFromInfSection alias "SetupInstallServicesFromInfSectionW" (byval as HINF, byval as PCWSTR, byval as DWORD) as BOOL
declare function SetupInstallServicesFromInfSectionEx alias "SetupInstallServicesFromInfSectionExW" (byval as HINF, byval as PCWSTR, byval as DWORD, byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PVOID, byval as PVOID) as BOOL
declare function SetupIterateCabinet alias "SetupIterateCabinetW" (byval as PCWSTR, byval as DWORD, byval as PSP_FILE_CALLBACK_W, byval as PVOID) as BOOL
declare function SetupLogError alias "SetupLogErrorW" (byval as LPCWSTR, byval as DWORD) as BOOL
declare function SetupLogFile alias "SetupLogFileW" (byval as HSPFILELOG, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as DWORD, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as DWORD) as BOOL
declare function SetupOpenAppendInfFile alias "SetupOpenAppendInfFileW" (byval as PCWSTR, byval as HINF, byval as PUINT) as BOOL
declare function SetupOpenInfFile alias "SetupOpenInfFileW" (byval as PCWSTR, byval as PCWSTR, byval as DWORD, byval as PUINT) as HINF
declare function SetupPromptForDisk alias "SetupPromptForDiskW" (byval as HWND, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as DWORD, byval as PWSTR, byval as DWORD, byval as PDWORD) as UINT
declare function SetupQuery alias "SetupQueryW" (byval as DWORD, byval as PCWSTR ptr ptr, byval as PUINT) as BOOL
declare function SetupQueryDrivesInDiskSpaceList alias "SetupQueryDrivesInDiskSpaceListW" (byval as HDSKSPC, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupQueryFileLog alias "SetupQueryFileLogW" (byval as HSPFILELOG, byval as PCWSTR, byval as PCWSTR, byval as SetupFileLogInfo, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupQueryInfFileInformation alias "SetupQueryInfFileInformationW" (byval as PSP_INF_INFORMATION, byval as UINT, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupQueryInfOriginalFileInformation alias "SetupQueryInfOriginalFileInformationW" (byval as PSP_INF_INFORMATION, byval as UINT, byval as PSP_ALTPLATFORM_INFO, byval as PSP_ORIGINAL_FILE_INFO_W) as BOOL
declare function SetupQueryInfVersionInformation alias "SetupQueryInfVersionInformationW" (byval as PSP_INF_INFORMATION, byval as UINT, byval as PCWSTR, byval as PWSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupQuerySpaceRequiredOnDrive alias "SetupQuerySpaceRequiredOnDriveW" (byval as HDSKSPC, byval as PCWSTR, byval as LONGLONG ptr, byval as PVOID, byval as UINT) as BOOL
declare function SetupQueueCopy alias "SetupQueueCopyW" (byval as HSPFILEQ, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as DWORD) as BOOL
declare function SetupQueueCopyIndirect alias "SetupQueueCopyIndirectW" (byval as PSP_FILE_COPY_PARAMS_W) as BOOL
declare function SetupQueueCopySection alias "SetupQueueCopySectionW" (byval as HSPFILEQ, byval as PCWSTR, byval as HINF, byval as HINF, byval as PCWSTR, byval as DWORD) as BOOL
declare function SetupQueueDefaultCopy alias "SetupQueueDefaultCopyW" (byval as HSPFILEQ, byval as HINF, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as DWORD) as BOOL
declare function SetupQueueDelete alias "SetupQueueDeleteW" (byval as HSPFILEQ, byval as PCWSTR, byval as PCWSTR) as BOOL
declare function SetupQueueDeleteSection alias "SetupQueueDeleteSectionW" (byval as HSPFILEQ, byval as HINF, byval as HINF, byval as PCWSTR) as BOOL
declare function SetupQueueRename alias "SetupQueueRenameW" (byval as HSPFILEQ, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR) as BOOL
declare function SetupQueueRenameSection alias "SetupQueueRenameSectionW" (byval as HSPFILEQ, byval as HINF, byval as HINF, byval as PCWSTR) as BOOL
declare function SetupRemoveFileLogEntry alias "SetupRemoveFileLogEntryW" (byval as HSPFILELOG, byval as PCWSTR, byval as PCWSTR) as BOOL
declare function SetupRemoveFromDiskSpaceList alias "SetupRemoveFromDiskSpaceListW" (byval as HDSKSPC, byval as PCWSTR, byval as UINT, byval as PVOID, byval as UINT) as BOOL
declare function SetupRemoveFromSourceList alias "SetupRemoveFromSourceListW" (byval as DWORD, byval as PCWSTR) as BOOL
declare function SetupRemoveInstallSectionFromDiskSpaceList alias "SetupRemoveInstallSectionFromDiskSpaceListW" (byval as HDSKSPC, byval as HINF, byval as HINF, byval as PCWSTR, byval as PVOID, byval as UINT) as BOOL
declare function SetupRemoveSectionFromDiskSpaceList alias "SetupRemoveSectionFromDiskSpaceListW" (byval as HDSKSPC, byval as HINF, byval as HINF, byval as PCWSTR, byval as UINT, byval as PVOID, byval as UINT) as BOOL
declare function SetupRenameError alias "SetupRenameErrorW" (byval as HWND, byval as PCWSTR, byval as PCWSTR, byval as PCWSTR, byval as UINT, byval as DWORD) as UINT
declare function SetupScanFileQueue alias "SetupScanFileQueueW" (byval as HSPFILEQ, byval as DWORD, byval as HWND, byval as PSP_FILE_CALLBACK_W, byval as PVOID, byval as PDWORD) as BOOL
declare function SetupSetDirectoryId alias "SetupSetDirectoryIdW" (byval as HINF, byval as DWORD, byval as PCWSTR) as BOOL
declare function SetupSetDirectoryIdEx alias "SetupSetDirectoryIdExW" (byval as HINF, byval as DWORD, byval as PCWSTR, byval as DWORD, byval as DWORD, byval as PVOID) as BOOL
declare function SetupSetFileQueueAlternatePlatform alias "SetupSetFileQueueAlternatePlatformW" (byval as HSPFILEQ, byval as PSP_ALTPLATFORM_INFO, byval as PCWSTR) as BOOL
declare function SetupSetPlatformPathOverride alias "SetupSetPlatformPathOverrideW" (byval as PCWSTR) as BOOL
declare function SetupSetSourceList alias "SetupSetSourceListW" (byval as DWORD, byval as PCWSTR ptr, byval as UINT) as BOOL

#else
declare function SetupAddInstallSectionToDiskSpaceList alias "SetupAddInstallSectionToDiskSpaceListA" (byval as HDSKSPC, byval as HINF, byval as HINF, byval as PCSTR, byval as PVOID, byval as UINT) as BOOL
declare function SetupAddSectionToDiskSpaceList alias "SetupAddSectionToDiskSpaceListA" (byval as HDSKSPC, byval as HINF, byval as HINF, byval as PCSTR, byval as UINT, byval as PVOID, byval as UINT) as BOOL
declare function SetupAddToDiskSpaceList alias "SetupAddToDiskSpaceListA" (byval as HDSKSPC, byval as PCSTR, byval as LONGLONG, byval as UINT, byval as PVOID, byval as UINT) as BOOL
declare function SetupAddToSourceList alias "SetupAddToSourceListA" (byval as DWORD, byval as PCSTR) as BOOL
declare function SetupAdjustDiskSpaceList alias "SetupAdjustDiskSpaceListA" (byval as HDSKSPC, byval as LPCSTR, byval as LONGLONG, byval as PVOID, byval as UINT) as BOOL
declare function SetupBackupError alias "SetupBackupErrorA" (byval as HWND, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as UINT, byval as DWORD) as UINT
declare function SetupCommitFileQueue alias "SetupCommitFileQueueA" (byval as HWND, byval as HSPFILEQ, byval as PSP_FILE_CALLBACK_A, byval as PVOID) as BOOL
declare function SetupCopyError alias "SetupCopyErrorA" (byval as HWND, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as UINT, byval as DWORD, byval as PSTR, byval as DWORD, byval as PDWORD) as UINT
declare function SetupCopyOEMInf alias "SetupCopyOEMInfA" (byval as PCSTR, byval as PCSTR, byval as DWORD, byval as DWORD, byval as PSTR, byval as DWORD, byval as PDWORD, byval as PSTR ptr) as BOOL
declare function SetupCreateDiskSpaceList alias "SetupCreateDiskSpaceListA" (byval as PVOID, byval as DWORD, byval as UINT) as HDSKSPC
declare function SetupDecompressOrCopyFile alias "SetupDecompressOrCopyFileA" (byval as PCSTR, byval as PCSTR, byval as PUINT) as DWORD
declare function SetupDefaultQueueCallback alias "SetupDefaultQueueCallbackA" (byval as PVOID, byval as UINT, byval as UINT_PTR, byval as UINT_PTR) as UINT
declare function SetupDeleteError alias "SetupDeleteErrorA" (byval as HWND, byval as PCSTR, byval as PCSTR, byval as UINT, byval as DWORD) as UINT
declare function SetupDiBuildClassInfoListEx alias "SetupDiBuildClassInfoListExA" (byval as DWORD, byval as LPGUID, byval as DWORD, byval as PDWORD, byval as PCSTR, byval as PVOID) as BOOL
declare function SetupDiClassGuidsFromName alias "SetupDiClassGuidsFromNameA" (byval as PCSTR, byval as LPGUID, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiClassGuidsFromNameEx alias "SetupDiClassGuidsFromNameExA" (byval as PCSTR, byval as LPGUID, byval as DWORD, byval as PDWORD, byval as PCSTR, byval as PVOID) as BOOL
declare function SetupDiClassNameFromGuid alias "SetupDiClassNameFromGuidA" (byval as GUID ptr, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiClassNameFromGuidEx alias "SetupDiClassNameFromGuidExA" (byval as GUID ptr, byval as PSTR, byval as DWORD, byval as PDWORD, byval as PCSTR, byval as PVOID) as BOOL
declare function SetupDiCreateDeviceInfo alias "SetupDiCreateDeviceInfoA" (byval as HDEVINFO, byval as PCSTR, byval as GUID ptr, byval as PCSTR, byval as HWND, byval as DWORD, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiCreateDeviceInfoListEx alias "SetupDiCreateDeviceInfoListExA" (byval as GUID ptr, byval as HWND, byval as PCSTR, byval as PVOID) as HDEVINFO
declare function SetupDiCreateDeviceInterface alias "SetupDiCreateDeviceInterfaceA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as GUID ptr, byval as PCSTR, byval as DWORD, byval as PSP_DEVICE_INTERFACE_DATA) as BOOL
declare function SetupDiCreateDeviceInterfaceRegKey alias "SetupDiCreateDeviceInterfaceRegKeyA" (byval as HDEVINFO, byval as PSP_DEVICE_INTERFACE_DATA, byval as DWORD, byval as REGSAM, byval as HINF, byval as PCSTR) as HKEY
declare function SetupDiCreateDevRegKey alias "SetupDiCreateDevRegKeyA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as DWORD, byval as DWORD, byval as HINF, byval as PCSTR) as HKEY
declare function SetupDiEnumDriverInfo alias "SetupDiEnumDriverInfoA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as DWORD, byval as PSP_DRVINFO_DATA_A) as BOOL
declare function SetupDiGetActualSectionToInstall alias "SetupDiGetActualSectionToInstallA" (byval as HINF, byval as PCSTR, byval as PSTR, byval as DWORD, byval as PDWORD, byval as PSTR ptr) as BOOL
declare function SetupDiGetClassDescription alias "SetupDiGetClassDescriptionA" (byval as GUID ptr, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetClassDescriptionEx alias "SetupDiGetClassDescriptionExA" (byval as GUID ptr, byval as PSTR, byval as DWORD, byval as PDWORD, byval as PCSTR, byval as PVOID) as BOOL
declare function SetupDiGetClassDevPropertySheets alias "SetupDiGetClassDevPropertySheetsA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as LPPROPSHEETHEADERA, byval as DWORD, byval as PDWORD, byval as DWORD) as BOOL
declare function SetupDiGetClassDevs alias "SetupDiGetClassDevsA" (byval as GUID ptr, byval as PCSTR, byval as HWND, byval as DWORD) as HDEVINFO
declare function SetupDiGetClassDevsEx alias "SetupDiGetClassDevsExA" (byval as GUID ptr, byval as PCSTR, byval as HWND, byval as DWORD, byval as HDEVINFO, byval as PCSTR, byval as PVOID) as HDEVINFO
declare function SetupDiGetClassImageListEx alias "SetupDiGetClassImageListExA" (byval as PSP_CLASSIMAGELIST_DATA, byval as PCSTR, byval as PVOID) as BOOL
declare function SetupDiGetClassInstallParams alias "SetupDiGetClassInstallParamsA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_CLASSINSTALL_HEADER, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetClassRegistryProperty alias "SetupDiGetClassRegistryPropertyA" (byval as LPGUID, byval as DWORD, byval as PDWORD, byval as PBYTE, byval as DWORD, byval as PDWORD, byval as PCSTR, byval as PVOID) as BOOL
declare function SetupDiGetDeviceInfoListDetail alias "SetupDiGetDeviceInfoListDetailA" (byval as HDEVINFO, byval as PSP_DEVINFO_LIST_DETAIL_DATA_A) as BOOL
declare function SetupDiGetDeviceInstallParams alias "SetupDiGetDeviceInstallParamsA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DEVINSTALL_PARAMS_A) as BOOL
declare function SetupDiGetDeviceInstanceId alias "SetupDiGetDeviceInstanceIdA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetDeviceInterfaceDetail alias "SetupDiGetDeviceInterfaceDetailA" (byval as HDEVINFO, byval as PSP_DEVICE_INTERFACE_DATA, byval as PSP_DEVICE_INTERFACE_DETAIL_DATA_A, byval as DWORD, byval as PDWORD, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiGetDeviceRegistryProperty alias "SetupDiGetDeviceRegistryPropertyA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as PDWORD, byval as PBYTE, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetDriverInfoDetail alias "SetupDiGetDriverInfoDetailA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_A, byval as PSP_DRVINFO_DETAIL_DATA_A, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetDriverInstallParams alias "SetupDiGetDriverInstallParamsA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_A, byval as PSP_DRVINSTALL_PARAMS) as BOOL
declare function SetupDiGetHwProfileFriendlyName alias "SetupDiGetHwProfileFriendlyNameA" (byval as DWORD, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetHwProfileFriendlyNameEx alias "SetupDiGetHwProfileFriendlyNameExA" (byval as DWORD, byval as PSTR, byval as DWORD, byval as PDWORD, byval as PCSTR, byval as PVOID) as BOOL
declare function SetupDiGetHwProfileListEx alias "SetupDiGetHwProfileListExA" (byval as PDWORD, byval as DWORD, byval as PDWORD, byval as PDWORD, byval as PCSTR, byval as PVOID) as BOOL
declare function SetupDiGetINFClass alias "SetupDiGetINFClassA" (byval as PCSTR, byval as LPGUID, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupDiGetSelectedDriver alias "SetupDiGetSelectedDriverA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_A) as BOOL
declare function SetupDiInstallClass alias "SetupDiInstallClassA" (byval as HWND, byval as PCSTR, byval as DWORD, byval as HSPFILEQ) as BOOL
declare function SetupDiInstallClassEx alias "SetupDiInstallClassExA" (byval as HWND, byval as PCSTR, byval as DWORD, byval as HSPFILEQ, byval as GUID ptr, byval as PVOID, byval as PVOID) as BOOL
declare function SetupDiOpenClassRegKeyEx alias "SetupDiOpenClassRegKeyExA" (byval as GUID ptr, byval as REGSAM, byval as DWORD, byval as PCSTR, byval as PVOID) as HKEY
declare function SetupDiOpenDeviceInfo alias "SetupDiOpenDeviceInfoA" (byval as HDEVINFO, byval as PCSTR, byval as HWND, byval as DWORD, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupDiOpenDeviceInterface alias "SetupDiOpenDeviceInterfaceA" (byval as HDEVINFO, byval as PCSTR, byval as DWORD, byval as PSP_DEVICE_INTERFACE_DATA) as BOOL
declare function SetupDiSetClassInstallParams alias "SetupDiSetClassInstallParamsA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_CLASSINSTALL_HEADER, byval as DWORD) as BOOL
declare function SetupDiSetClassRegistryProperty alias "SetupDiSetClassRegistryPropertyA" (byval as LPGUID, byval as DWORD, byval as UBYTE ptr, byval as DWORD, byval as PCSTR, byval as PVOID) as BOOL
declare function SetupDiSetDeviceInstallParams alias "SetupDiSetDeviceInstallParamsA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DEVINSTALL_PARAMS_A) as BOOL
declare function SetupDiSetDeviceRegistryProperty alias "SetupDiSetDeviceRegistryPropertyA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as DWORD, byval as UBYTE ptr, byval as DWORD) as BOOL
declare function SetupDiSetDriverInstallParams alias "SetupDiSetDriverInstallParamsA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_A, byval as PSP_DRVINSTALL_PARAMS) as BOOL
declare function SetupDiSetSelectedDriver alias "SetupDiSetSelectedDriverA" (byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PSP_DRVINFO_DATA_A) as BOOL
declare function SetupDuplicateDiskSpaceList alias "SetupDuplicateDiskSpaceListA" (byval as HDSKSPC, byval as PVOID, byval as DWORD, byval as UINT) as HDSKSPC
declare function SetupFindFirstLine alias "SetupFindFirstLineA" (byval as HINF, byval as PCSTR, byval as PCSTR, byval as PINFCONTEXT) as BOOL
declare function SetupFindNextMatchLine alias "SetupFindNextMatchLineA" (byval as PINFCONTEXT, byval as PCSTR, byval as PINFCONTEXT) as BOOL
declare function SetupFree alias "SetupFreeA" (byval as PCSTR ptr ptr, byval as UINT) as BOOL
declare function SetupGetBackupInformation alias "SetupGetBackupInformationA" (byval as HSPFILEQ, byval as PSP_BACKUP_QUEUE_PARAMS_A) as BOOL
declare function SetupGetFileCompressionInfo alias "SetupGetFileCompressionInfoA" (byval as PCSTR, byval as PSTR ptr, byval as PDWORD, byval as PDWORD, byval as PUINT) as DWORD
declare function SetupGetInfFileList alias "SetupGetInfFileListA" (byval as PCSTR, byval as DWORD, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetInfInformation alias "SetupGetInfInformationA" (byval as LPCVOID, byval as DWORD, byval as PSP_INF_INFORMATION, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetLineByIndex alias "SetupGetLineByIndexA" (byval as HINF, byval as PCSTR, byval as DWORD, byval as PINFCONTEXT) as BOOL
declare function SetupGetLineCount alias "SetupGetLineCountA" (byval as HINF, byval as PCSTR) as LONG
declare function SetupGetLineText alias "SetupGetLineTextA" (byval as PINFCONTEXT, byval as HINF, byval as PCSTR, byval as PCSTR, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetMultiSzField alias "SetupGetMultiSzFieldA" (byval as PINFCONTEXT, byval as DWORD, byval as PSTR, byval as DWORD, byval as LPDWORD) as BOOL
declare function SetupGetSourceFileLocation alias "SetupGetSourceFileLocationA" (byval as HINF, byval as PINFCONTEXT, byval as PCSTR, byval as PUINT, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetSourceFileSize alias "SetupGetSourceFileSizeA" (byval as HINF, byval as PINFCONTEXT, byval as PCSTR, byval as PCSTR, byval as PDWORD, byval as UINT) as BOOL
declare function SetupGetSourceInfo alias "SetupGetSourceInfoA" (byval as HINF, byval as UINT, byval as UINT, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetStringField alias "SetupGetStringFieldA" (byval as PINFCONTEXT, byval as DWORD, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupGetTargetPath alias "SetupGetTargetPathA" (byval as HINF, byval as PINFCONTEXT, byval as PCSTR, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupInitializeFileLog alias "SetupInitializeFileLogA" (byval as PCSTR, byval as DWORD) as HSPFILELOG
declare function SetupInstallFile alias "SetupInstallFileA" (byval as HINF, byval as PINFCONTEXT, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as DWORD, byval as PSP_FILE_CALLBACK_A, byval as PVOID) as BOOL
declare function SetupInstallFileEx alias "SetupInstallFileExA" (byval as HINF, byval as PINFCONTEXT, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as DWORD, byval as PSP_FILE_CALLBACK_A, byval as PVOID, byval as PBOOL) as BOOL
declare function SetupInstallFilesFromInfSection alias "SetupInstallFilesFromInfSectionA" (byval as HINF, byval as HINF, byval as HSPFILEQ, byval as PCSTR, byval as PCSTR, byval as UINT) as BOOL
declare function SetupInstallFromInfSection alias "SetupInstallFromInfSectionA" (byval as HWND, byval as HINF, byval as PCSTR, byval as UINT, byval as HKEY, byval as PCSTR, byval as UINT, byval as PSP_FILE_CALLBACK_A, byval as PVOID, byval as HDEVINFO, byval as PSP_DEVINFO_DATA) as BOOL
declare function SetupInstallServicesFromInfSection alias "SetupInstallServicesFromInfSectionA" (byval as HINF, byval as PCSTR, byval as DWORD) as BOOL
declare function SetupInstallServicesFromInfSectionEx alias "SetupInstallServicesFromInfSectionExA" (byval as HINF, byval as PCSTR, byval as DWORD, byval as HDEVINFO, byval as PSP_DEVINFO_DATA, byval as PVOID, byval as PVOID) as BOOL
declare function SetupIterateCabinet alias "SetupIterateCabinetA" (byval as PCSTR, byval as DWORD, byval as PSP_FILE_CALLBACK_A, byval as PVOID) as BOOL
declare function SetupLogError alias "SetupLogErrorA" (byval as LPCSTR, byval as DWORD) as BOOL
declare function SetupLogFile alias "SetupLogFileA" (byval as HSPFILELOG, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as DWORD, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as DWORD) as BOOL
declare function SetupOpenAppendInfFile alias "SetupOpenAppendInfFileA" (byval as PCSTR, byval as HINF, byval as PUINT) as BOOL
declare function SetupOpenInfFile alias "SetupOpenInfFileA" (byval as PCSTR, byval as PCSTR, byval as DWORD, byval as PUINT) as HINF
declare function SetupPromptForDisk alias "SetupPromptForDiskA" (byval as HWND, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as DWORD, byval as PSTR, byval as DWORD, byval as PDWORD) as UINT
declare function SetupQuery alias "SetupQueryA" (byval as DWORD, byval as PCSTR ptr ptr, byval as PUINT) as BOOL
declare function SetupQueryDrivesInDiskSpaceList alias "SetupQueryDrivesInDiskSpaceListA" (byval as HDSKSPC, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupQueryFileLog alias "SetupQueryFileLogA" (byval as HSPFILELOG, byval as PCSTR, byval as PCSTR, byval as SetupFileLogInfo, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupQueryInfFileInformation alias "SetupQueryInfFileInformationA" (byval as PSP_INF_INFORMATION, byval as UINT, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupQueryInfOriginalFileInformation alias "SetupQueryInfOriginalFileInformationA" (byval as PSP_INF_INFORMATION, byval as UINT, byval as PSP_ALTPLATFORM_INFO, byval as PSP_ORIGINAL_FILE_INFO_A) as BOOL
declare function SetupQueryInfVersionInformation alias "SetupQueryInfVersionInformationA" (byval as PSP_INF_INFORMATION, byval as UINT, byval as PSTR, byval as PSTR, byval as DWORD, byval as PDWORD) as BOOL
declare function SetupQuerySpaceRequiredOnDrive alias "SetupQuerySpaceRequiredOnDriveA" (byval as HDSKSPC, byval as PCSTR, byval as LONGLONG ptr, byval as PVOID, byval as UINT) as BOOL
declare function SetupQueueCopy alias "SetupQueueCopyA" (byval as HSPFILEQ, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as DWORD) as BOOL
declare function SetupQueueCopyIndirect alias "SetupQueueCopyIndirectA" (byval as PSP_FILE_COPY_PARAMS_A) as BOOL
declare function SetupQueueCopySection alias "SetupQueueCopySectionA" (byval as HSPFILEQ, byval as PCSTR, byval as HINF, byval as HINF, byval as PCSTR, byval as DWORD) as BOOL
declare function SetupQueueDefaultCopy alias "SetupQueueDefaultCopyA" (byval as HSPFILEQ, byval as HINF, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as DWORD) as BOOL
declare function SetupQueueDelete alias "SetupQueueDeleteA" (byval as HSPFILEQ, byval as PCSTR, byval as PCSTR) as BOOL
declare function SetupQueueDeleteSection alias "SetupQueueDeleteSectionA" (byval as HSPFILEQ, byval as HINF, byval as HINF, byval as PCSTR) as BOOL
declare function SetupQueueRename alias "SetupQueueRenameA" (byval as HSPFILEQ, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as PCSTR) as BOOL
declare function SetupQueueRenameSection alias "SetupQueueRenameSectionA" (byval as HSPFILEQ, byval as HINF, byval as HINF, byval as PCSTR) as BOOL
declare function SetupRemoveFileLogEntry alias "SetupRemoveFileLogEntryA" (byval as HSPFILELOG, byval as PCSTR, byval as PCSTR) as BOOL
declare function SetupRemoveFromDiskSpaceList alias "SetupRemoveFromDiskSpaceListA" (byval as HDSKSPC, byval as PCSTR, byval as UINT, byval as PVOID, byval as UINT) as BOOL
declare function SetupRemoveFromSourceList alias "SetupRemoveFromSourceListA" (byval as DWORD, byval as PCSTR) as BOOL
declare function SetupRemoveInstallSectionFromDiskSpaceList alias "SetupRemoveInstallSectionFromDiskSpaceListA" (byval as HDSKSPC, byval as HINF, byval as HINF, byval as PCSTR, byval as PVOID, byval as UINT) as BOOL
declare function SetupRemoveSectionFromDiskSpaceList alias "SetupRemoveSectionFromDiskSpaceListA" (byval as HDSKSPC, byval as HINF, byval as HINF, byval as PCSTR, byval as UINT, byval as PVOID, byval as UINT) as BOOL
declare function SetupRenameError alias "SetupRenameErrorA" (byval as HWND, byval as PCSTR, byval as PCSTR, byval as PCSTR, byval as UINT, byval as DWORD) as UINT
declare function SetupScanFileQueue alias "SetupScanFileQueueA" (byval as HSPFILEQ, byval as DWORD, byval as HWND, byval as PSP_FILE_CALLBACK_A, byval as PVOID, byval as PDWORD) as BOOL
declare function SetupSetDirectoryId alias "SetupSetDirectoryIdA" (byval as HINF, byval as DWORD, byval as PCSTR) as BOOL
declare function SetupSetDirectoryIdEx alias "SetupSetDirectoryIdExA" (byval as HINF, byval as DWORD, byval as PCSTR, byval as DWORD, byval as DWORD, byval as PVOID) as BOOL
declare function SetupSetFileQueueAlternatePlatform alias "SetupSetFileQueueAlternatePlatformA" (byval as HSPFILEQ, byval as PSP_ALTPLATFORM_INFO, byval as PCSTR) as BOOL
declare function SetupSetPlatformPathOverride alias "SetupSetPlatformPathOverrideA" (byval as PCSTR) as BOOL
declare function SetupSetSourceList alias "SetupSetSourceListA" (byval as DWORD, byval as PCSTR ptr, byval as UINT) as BOOL
#endif

#endif
