''
''
'' mmsystem -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __win_mmsystem_bi__
#define __win_mmsystem_bi__

#define MAXPNAMELEN 32
#define MAXERRORLENGTH 256
#define MAX_JOYSTICKOEMVXDNAME 260
#define TIME_MS 1
#define TIME_SAMPLES 2
#define TIME_BYTES 4
#define TIME_SMPTE 8
#define TIME_MIDI 16
#define TIME_TICKS 32
#ifndef MAKEFOURCC
#define MAKEFOURCC(c0,c1,c2,c3) (cuint(c0) or (cuint(c1) shl 8) or (cuint(c2) shl 16) or (cuint(c3) shl 24))
#endif
#ifndef mmioFOURCC
#define mmioFOURCC(c0,c1,c2,c3) MAKEFOURCC(c0,c1,c2,c3)
#endif
#define MM_JOY1MOVE &h3A0
#define MM_JOY2MOVE &h3A1
#define MM_JOY1ZMOVE &h3A2
#define MM_JOY2ZMOVE &h3A3
#define MM_JOY1BUTTONDOWN &h3B5
#define MM_JOY2BUTTONDOWN &h3B6
#define MM_JOY1BUTTONUP &h3B7
#define MM_JOY2BUTTONUP &h3B8
#define MM_MCINOTIFY &h3B9
#define MM_WOM_OPEN &h3BB
#define MM_WOM_CLOSE &h3BC
#define MM_WOM_DONE &h3BD
#define MM_WIM_OPEN &h3BE
#define MM_WIM_CLOSE &h3BF
#define MM_WIM_DATA &h3C0
#define MM_MIM_OPEN &h3C1
#define MM_MIM_CLOSE &h3C2
#define MM_MIM_DATA &h3C3
#define MM_MIM_LONGDATA &h3C4
#define MM_MIM_ERROR &h3C5
#define MM_MIM_LONGERROR &h3C6
#define MM_MOM_OPEN &h3C7
#define MM_MOM_CLOSE &h3C8
#define MM_MOM_DONE &h3C9
#define MM_DRVM_OPEN &h3D0
#define MM_DRVM_CLOSE &h3D1
#define MM_DRVM_DATA &h3D2
#define MM_DRVM_ERROR &h3D3
#define MM_STREAM_OPEN &h3D4
#define MM_STREAM_CLOSE &h3D5
#define MM_STREAM_DONE &h3D6
#define MM_STREAM_ERROR &h3D7
#define MM_MOM_POSITIONCB &h3CA
#define MM_MCISIGNAL &h3CB
#define MM_MIM_MOREDATA &h3CC
#define MM_MIXM_LINE_CHANGE &h3D0
#define MM_MIXM_CONTROL_CHANGE &h3D1
#define MMSYSERR_BASE 0
#define WAVERR_BASE 32
#define MIDIERR_BASE 64
#define TIMERR_BASE 96
#define JOYERR_BASE 160
#define MCIERR_BASE 256
#define MIXERR_BASE 1024
#define MCI_STRING_OFFSET 512
#define MCI_VD_OFFSET 1024
#define MCI_CD_OFFSET 1088
#define MCI_WAVE_OFFSET 1152
#define MCI_SEQ_OFFSET 1216
#define MMSYSERR_NOERROR 0
#define MMSYSERR_ERROR (0+1)
#define MMSYSERR_BADDEVICEID (0+2)
#define MMSYSERR_NOTENABLED (0+3)
#define MMSYSERR_ALLOCATED (0+4)
#define MMSYSERR_INVALHANDLE (0+5)
#define MMSYSERR_NODRIVER (0+6)
#define MMSYSERR_NOMEM (0+7)
#define MMSYSERR_NOTSUPPORTED (0+8)
#define MMSYSERR_BADERRNUM (0+9)
#define MMSYSERR_INVALFLAG (0+10)
#define MMSYSERR_INVALPARAM (0+11)
#define MMSYSERR_HANDLEBUSY (0+12)
#define MMSYSERR_INVALIDALIAS (0+13)
#define MMSYSERR_BADDB (0+14)
#define MMSYSERR_KEYNOTFOUND (0+15)
#define MMSYSERR_READERROR (0+16)
#define MMSYSERR_WRITEERROR (0+17)
#define MMSYSERR_DELETEERROR (0+18)
#define MMSYSERR_VALNOTFOUND (0+19)
#define MMSYSERR_NODRIVERCB (0+20)
#define MMSYSERR_LASTERROR (0+20)
#define DRV_LOAD 1
#define DRV_ENABLE 2
#define DRV_OPEN 3
#define DRV_CLOSE 4
#define DRV_DISABLE 5
#define DRV_FREE 6
#define DRV_CONFIGURE 7
#define DRV_QUERYCONFIGURE 8
#define DRV_INSTALL 9
#define DRV_REMOVE 10
#define DRV_EXITSESSION 11
#define DRV_POWER 15
#define DRV_RESERVED &h800
#define DRV_USER &h4000
#define DRVCNF_CANCEL 0
#define DRVCNF_OK 1
#define DRVCNF_RESTART 2
#define DRV_CANCEL 0
#define DRV_OK 1
#define DRV_RESTART 2
#define DRV_MCI_FIRST &h800
#define DRV_MCI_LAST (&h800+&hFFF)
#define CALLBACK_TYPEMASK &h70000
#define CALLBACK_NULL 0
#define CALLBACK_WINDOW &h10000
#define CALLBACK_TASK &h20000
#define CALLBACK_FUNCTION &h30000
#define CALLBACK_THREAD &h20000
#define CALLBACK_EVENT &h50000
#define SND_SYNC 0
#define SND_ASYNC 1
#define SND_NODEFAULT 2
#define SND_MEMORY 4
#define SND_LOOP 8
#define SND_NOSTOP 16
#define SND_NOWAIT &h2000
#define SND_ALIAS &h10000
#define SND_ALIAS_ID &h110000
#define SND_FILENAME &h20000
#define SND_RESOURCE &h40004
#define SND_PURGE &h40
#define SND_APPLICATION &h80
#define SND_ALIAS_START 0
#define	sndAlias(c0,c1)	(SND_ALIAS_START+cuint(c0) or (cuint(c1) shl 8))
#define SND_ALIAS_SYSTEMASTERISK sndAlias(asc("S"),asc("*"))
#define SND_ALIAS_SYSTEMQUESTION sndAlias(asc("S"),asc("?"))
#define SND_ALIAS_SYSTEMHAND sndAlias(asc("S"),asc("H"))
#define SND_ALIAS_SYSTEMEXIT sndAlias(asc("S"),asc("E"))
#define SND_ALIAS_SYSTEMSTART sndAlias(asc("S"),asc("S"))
#define SND_ALIAS_SYSTEMWELCOME sndAlias(asc("S"),asc("W"))
#define SND_ALIAS_SYSTEMEXCLAMATION sndAlias(asc("S"),asc("!"))
#define SND_ALIAS_SYSTEMDEFAULT sndAlias(asc("S"),asc("D"))
#define WAVERR_BADFORMAT (32+0)
#define WAVERR_STILLPLAYING (32+1)
#define WAVERR_UNPREPARED (32+2)
#define WAVERR_SYNC (32+3)
#define WAVERR_LASTERROR (32+3)
#define WOM_OPEN &h3BB
#define WOM_CLOSE &h3BC
#define WOM_DONE &h3BD
#define WIM_OPEN &h3BE
#define WIM_CLOSE &h3BF
#define WIM_DATA &h3C0
#define WAVE_FORMAT_QUERY 1
#define WAVE_ALLOWSYNC 2
#define WAVE_MAPPED 4
#define WAVE_FORMAT_DIRECT 8
#define WAVE_FORMAT_DIRECT_QUERY (1 or 8)
#define WHDR_DONE 1
#define WHDR_PREPARED 2
#define WHDR_BEGINLOOP 4
#define WHDR_ENDLOOP 8
#define WHDR_INQUEUE 16
#define WAVECAPS_PITCH 1
#define WAVECAPS_PLAYBACKRATE 2
#define WAVECAPS_VOLUME 4
#define WAVECAPS_LRVOLUME 8
#define WAVECAPS_SYNC 16
#define WAVECAPS_SAMPLEACCURATE 32
#define WAVECAPS_DIRECTSOUND 64
#define WAVE_INVALIDFORMAT 0
#define WAVE_FORMAT_1M08 1
#define WAVE_FORMAT_1S08 2
#define WAVE_FORMAT_1M16 4
#define WAVE_FORMAT_1S16 8
#define WAVE_FORMAT_2M08 16
#define WAVE_FORMAT_2S08 32
#define WAVE_FORMAT_2M16 64
#define WAVE_FORMAT_2S16 128
#define WAVE_FORMAT_4M08 256
#define WAVE_FORMAT_4S08 512
#define WAVE_FORMAT_4M16 1024
#define WAVE_FORMAT_4S16 2048
#define WAVE_FORMAT_PCM 1
#define MIDIERR_UNPREPARED 64
#define MIDIERR_STILLPLAYING (64+1)
#define MIDIERR_NOMAP (64+2)
#define MIDIERR_NOTREADY (64+3)
#define MIDIERR_NODEVICE (64+4)
#define MIDIERR_INVALIDSETUP (64+5)
#define MIDIERR_BADOPENMODE (64+6)
#define MIDIERR_DONT_CONTINUE (64+7)
#define MIDIERR_LASTERROR (64+7)
#define MIDIPATCHSIZE 128
#define MIM_OPEN &h3C1
#define MIM_CLOSE &h3C2
#define MIM_DATA &h3C3
#define MIM_LONGDATA &h3C4
#define MIM_ERROR &h3C5
#define MIM_LONGERROR &h3C6
#define MOM_OPEN &h3C7
#define MOM_CLOSE &h3C8
#define MOM_DONE &h3C9
#define MIM_MOREDATA &h3CC
#define MOM_POSITIONCB &h3CA
#define MIDIMAPPER cuint(-1)
#define MIDI_MAPPER cuint(-1)
#define MIDI_IO_STATUS 32
#define MIDI_CACHE_ALL 1
#define MIDI_CACHE_BESTFIT 2
#define MIDI_CACHE_QUERY 3
#define MIDI_UNCACHE 4
#define MOD_MIDIPORT 1
#define MOD_SYNTH 2
#define MOD_SQSYNTH 3
#define MOD_FMSYNTH 4
#define MOD_MAPPER 5
#define MIDICAPS_VOLUME 1
#define MIDICAPS_LRVOLUME 2
#define MIDICAPS_CACHE 4
#define MIDICAPS_STREAM 8
#define MHDR_DONE 1
#define MHDR_PREPARED 2
#define MHDR_INQUEUE 4
#define MHDR_ISSTRM 8
#define MEVT_F_SHORT 0
#define MEVT_F_LONG &h80000000
#define MEVT_F_CALLBACK &h40000000
#define MEVT_EVENTTYPE(x) (cubyte(((x) shr 24) and &hFF))
#define MEVT_EVENTPARM(x) (cuint((x) and &hFFFFFFL))
#define MEVT_SHORTMSG 0
#define MEVT_TEMPO 1
#define MEVT_NOP 2
#define MEVT_LONGMSG cubyte(&h80)
#define MEVT_COMMENT cubyte(&h82)
#define MEVT_VERSION cubyte(&h84)
#define MIDISTRM_ERROR (-2)
#define MIDIPROP_SET &h80000000
#define MIDIPROP_GET &h40000000
#define MIDIPROP_TIMEDIV 1
#define MIDIPROP_TEMPO 2
#define AUX_MAPPER cuint(-1)
#define AUXCAPS_CDAUDIO 1
#define AUXCAPS_AUXIN 2
#define AUXCAPS_VOLUME 1
#define AUXCAPS_LRVOLUME 2
#define MIXER_SHORT_NAME_CHARS 16
#define MIXER_LONG_NAME_CHARS 64
#define MIXERR_INVALLINE 1024
#define MIXERR_INVALCONTROL (1024+1)
#define MIXERR_INVALVALUE (1024+2)
#define MIXERR_LASTERROR (1024+2)
#define MIXER_OBJECTF_HANDLE &h80000000
#define MIXER_OBJECTF_MIXER 0
#define MIXER_OBJECTF_HMIXER (&h80000000 or 0)
#define MIXER_OBJECTF_WAVEOUT &h10000000
#define MIXER_OBJECTF_HWAVEOUT (&h80000000 or &h10000000)
#define MIXER_OBJECTF_WAVEIN &h20000000
#define MIXER_OBJECTF_HWAVEIN (&h80000000 or &h20000000)
#define MIXER_OBJECTF_MIDIOUT &h30000000
#define MIXER_OBJECTF_HMIDIOUT (&h80000000 or &h30000000)
#define MIXER_OBJECTF_MIDIIN &h40000000
#define MIXER_OBJECTF_HMIDIIN (&h80000000 or &h40000000)
#define MIXER_OBJECTF_AUX &h50000000
#define MIXERLINE_LINEF_ACTIVE 1
#define MIXERLINE_LINEF_DISCONNECTED &h8000
#define MIXERLINE_LINEF_SOURCE &h80000000
#define MIXERLINE_COMPONENTTYPE_DST_FIRST 0
#define MIXERLINE_COMPONENTTYPE_DST_UNDEFINED 0
#define MIXERLINE_COMPONENTTYPE_DST_DIGITAL (0+1)
#define MIXERLINE_COMPONENTTYPE_DST_LINE (0+2)
#define MIXERLINE_COMPONENTTYPE_DST_MONITOR (0+3)
#define MIXERLINE_COMPONENTTYPE_DST_SPEAKERS (0+4)
#define MIXERLINE_COMPONENTTYPE_DST_HEADPHONES (0+5)
#define MIXERLINE_COMPONENTTYPE_DST_TELEPHONE (0+6)
#define MIXERLINE_COMPONENTTYPE_DST_WAVEIN (0+7)
#define MIXERLINE_COMPONENTTYPE_DST_VOICEIN (0+8)
#define MIXERLINE_COMPONENTTYPE_DST_LAST (0+8)
#define MIXERLINE_COMPONENTTYPE_SRC_FIRST &h1000
#define MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED &h1000
#define MIXERLINE_COMPONENTTYPE_SRC_DIGITAL (&h1000+1)
#define MIXERLINE_COMPONENTTYPE_SRC_LINE (&h1000+2)
#define MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE (&h1000+3)
#define MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER (&h1000+4)
#define MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC (&h1000+5)
#define MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE (&h1000+6)
#define MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER (&h1000+7)
#define MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT (&h1000+8)
#define MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY (&h1000+9)
#define MIXERLINE_COMPONENTTYPE_SRC_ANALOG (&h1000+10)
#define MIXERLINE_COMPONENTTYPE_SRC_LAST (&h1000+10)
#define MIXERLINE_TARGETTYPE_UNDEFINED 0
#define MIXERLINE_TARGETTYPE_WAVEOUT 1
#define MIXERLINE_TARGETTYPE_WAVEIN 2
#define MIXERLINE_TARGETTYPE_MIDIOUT 3
#define MIXERLINE_TARGETTYPE_MIDIIN 4
#define MIXERLINE_TARGETTYPE_AUX 5
#define MIXER_GETLINEINFOF_DESTINATION 0
#define MIXER_GETLINEINFOF_SOURCE 1
#define MIXER_GETLINEINFOF_LINEID 2
#define MIXER_GETLINEINFOF_COMPONENTTYPE 3
#define MIXER_GETLINEINFOF_TARGETTYPE 4
#define MIXER_GETLINEINFOF_QUERYMASK 15
#define MIXERCONTROL_CONTROLF_UNIFORM 1
#define MIXERCONTROL_CONTROLF_MULTIPLE 2
#define MIXERCONTROL_CONTROLF_DISABLED &h80000000
#define MIXERCONTROL_CT_CLASS_MASK &hF0000000
#define MIXERCONTROL_CT_CLASS_CUSTOM 0
#define MIXERCONTROL_CT_CLASS_METER &h10000000
#define MIXERCONTROL_CT_CLASS_SWITCH &h20000000
#define MIXERCONTROL_CT_CLASS_NUMBER &h30000000
#define MIXERCONTROL_CT_CLASS_SLIDER &h40000000
#define MIXERCONTROL_CT_CLASS_FADER &h50000000
#define MIXERCONTROL_CT_CLASS_TIME &h60000000
#define MIXERCONTROL_CT_CLASS_LIST &h70000000
#define MIXERCONTROL_CT_SUBCLASS_MASK &hF000000
#define MIXERCONTROL_CT_SC_SWITCH_BOOLEAN 0
#define MIXERCONTROL_CT_SC_SWITCH_BUTTON &h1000000
#define MIXERCONTROL_CT_SC_METER_POLLED 0
#define MIXERCONTROL_CT_SC_TIME_MICROSECS 0
#define MIXERCONTROL_CT_SC_TIME_MILLISECS &h1000000
#define MIXERCONTROL_CT_SC_LIST_SINGLE 0
#define MIXERCONTROL_CT_SC_LIST_MULTIPLE &h1000000
#define MIXERCONTROL_CT_UNITS_MASK &hFF0000
#define MIXERCONTROL_CT_UNITS_CUSTOM 0
#define MIXERCONTROL_CT_UNITS_BOOLEAN &h10000
#define MIXERCONTROL_CT_UNITS_SIGNED &h20000
#define MIXERCONTROL_CT_UNITS_UNSIGNED &h30000
#define MIXERCONTROL_CT_UNITS_DECIBELS &h40000
#define MIXERCONTROL_CT_UNITS_PERCENT &h50000
#define MIXERCONTROL_CONTROLTYPE_CUSTOM (0 or 0)
#define MIXERCONTROL_CONTROLTYPE_BOOLEANMETER (&h10000000 or 0 or &h10000)
#define MIXERCONTROL_CONTROLTYPE_SIGNEDMETER (&h10000000 or 0 or &h20000)
#define MIXERCONTROL_CONTROLTYPE_PEAKMETER ((&h10000000 or 0 or &h20000) +1)
#define MIXERCONTROL_CONTROLTYPE_UNSIGNEDMETER (&h10000000 or 0 or &h30000)
#define MIXERCONTROL_CONTROLTYPE_BOOLEAN (&h20000000 or 0 or &h10000)
#define MIXERCONTROL_CONTROLTYPE_ONOFF ((&h20000000 or 0 or &h10000) +1)
#define MIXERCONTROL_CONTROLTYPE_MUTE ((&h20000000 or 0 or &h10000) +2)
#define MIXERCONTROL_CONTROLTYPE_MONO ((&h20000000 or 0 or &h10000) +3)
#define MIXERCONTROL_CONTROLTYPE_LOUDNESS ((&h20000000 or 0 or &h10000) +4)
#define MIXERCONTROL_CONTROLTYPE_STEREOENH ((&h20000000 or 0 or &h10000) +5)
#define MIXERCONTROL_CONTROLTYPE_BUTTON (&h20000000 or &h1000000 or &h10000)
#define MIXERCONTROL_CONTROLTYPE_DECIBELS (&h30000000 or &h40000)
#define MIXERCONTROL_CONTROLTYPE_SIGNED (&h30000000 or &h20000)
#define MIXERCONTROL_CONTROLTYPE_UNSIGNED (&h30000000 or &h30000)
#define MIXERCONTROL_CONTROLTYPE_PERCENT (&h30000000 or &h50000)
#define MIXERCONTROL_CONTROLTYPE_SLIDER (&h40000000 or &h20000)
#define MIXERCONTROL_CONTROLTYPE_PAN ((&h40000000 or &h20000) +1)
#define MIXERCONTROL_CONTROLTYPE_QSOUNDPAN ((&h40000000 or &h20000) +2)
#define MIXERCONTROL_CONTROLTYPE_FADER (&h50000000 or &h30000)
#define MIXERCONTROL_CONTROLTYPE_VOLUME ((&h50000000 or &h30000) +1)
#define MIXERCONTROL_CONTROLTYPE_BASS ((&h50000000 or &h30000) +2)
#define MIXERCONTROL_CONTROLTYPE_TREBLE ((&h50000000 or &h30000) +3)
#define MIXERCONTROL_CONTROLTYPE_EQUALIZER ((&h50000000 or &h30000) +4)
#define MIXERCONTROL_CONTROLTYPE_SINGLESELECT (&h70000000 or 0 or &h10000)
#define MIXERCONTROL_CONTROLTYPE_MUX ((&h70000000 or 0 or &h10000) +1)
#define MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT (&h70000000 or &h1000000 or &h10000)
#define MIXERCONTROL_CONTROLTYPE_MIXER ((&h70000000 or &h1000000 or &h10000) +1)
#define MIXERCONTROL_CONTROLTYPE_MICROTIME (&h60000000 or 0 or &h30000)
#define MIXERCONTROL_CONTROLTYPE_MILLITIME (&h60000000 or &h1000000 or &h30000)
#define MIXER_GETLINECONTROLSF_ALL 0
#define MIXER_GETLINECONTROLSF_ONEBYID 1
#define MIXER_GETLINECONTROLSF_ONEBYTYPE 2
#define MIXER_GETLINECONTROLSF_QUERYMASK 15
#define MIXER_GETCONTROLDETAILSF_VALUE 0
#define MIXER_GETCONTROLDETAILSF_LISTTEXT 1
#define MIXER_GETCONTROLDETAILSF_QUERYMASK 15
#define MIXER_SETCONTROLDETAILSF_VALUE 0
#define MIXER_SETCONTROLDETAILSF_CUSTOM 1
#define MIXER_SETCONTROLDETAILSF_QUERYMASK 15
#define TIMERR_NOERROR 0
#define TIMERR_NOCANDO (96+1)
#define TIMERR_STRUCT (96+33)
#define TIME_ONESHOT 0
#define TIME_PERIODIC 1
#define TIME_CALLBACK_FUNCTION 0
#define TIME_CALLBACK_EVENT_SET 16
#define TIME_CALLBACK_EVENT_PULSE 32
#define JOYERR_NOERROR (0)
#define JOYERR_PARMS (160+5)
#define JOYERR_NOCANDO (160+6)
#define JOYERR_UNPLUGGED (160+7)
#define JOY_BUTTON1 1
#define JOY_BUTTON2 2
#define JOY_BUTTON3 4
#define JOY_BUTTON4 8
#define JOY_BUTTON1CHG 256
#define JOY_BUTTON2CHG 512
#define JOY_BUTTON3CHG 1024
#define JOY_BUTTON4CHG 2048
#define JOY_BUTTON5 257
#define JOY_BUTTON6 513
#define JOY_BUTTON7 1025
#define JOY_BUTTON8 2049
#define JOY_BUTTON9 256
#define JOY_BUTTON10 512
#define JOY_BUTTON11 1024
#define JOY_BUTTON12 2048
#define JOY_BUTTON13 4096
#define JOY_BUTTON14 8192
#define JOY_BUTTON15 16384
#define JOY_BUTTON16 32768
#define JOY_BUTTON17 65536
#define JOY_BUTTON18 &h20000
#define JOY_BUTTON19 &h40000
#define JOY_BUTTON20 &h80000
#define JOY_BUTTON21 &h100000
#define JOY_BUTTON22 &h200000
#define JOY_BUTTON23 &h400000
#define JOY_BUTTON24 &h800000
#define JOY_BUTTON25 &h1000000
#define JOY_BUTTON26 &h2000000
#define JOY_BUTTON27 &h4000000
#define JOY_BUTTON28 &h8000000
#define JOY_BUTTON29 &h10000000
#define JOY_BUTTON30 &h20000000
#define JOY_BUTTON31 &h40000000
#define JOY_BUTTON32 &h80000000
#define JOY_POVCENTERED	cushort(-1)
#define JOY_POVFORWARD 0
#define JOY_POVRIGHT 9000
#define JOY_POVBACKWARD 18000
#define JOY_POVLEFT 27000
#define JOY_RETURNX 1
#define JOY_RETURNY 2
#define JOY_RETURNZ 4l
#define JOY_RETURNR 8
#define JOY_RETURNU 16
#define JOY_RETURNV 32
#define JOY_RETURNPOV 64
#define JOY_RETURNBUTTONS 128
#define JOY_RETURNRAWDATA 256
#define JOY_RETURNPOVCTS 512
#define JOY_RETURNCENTERED 1024
#define JOY_USEDEADZONE 2048
#define JOY_RETURNALL (1 or 2 or 4l or 8 or 16 or 32 or 64 or 128)
#define JOY_CAL_READALWAYS &h10000
#define JOY_CAL_READXYONLY &h20000
#define JOY_CAL_READ3 &h40000
#define JOY_CAL_READ4 &h80000
#define JOY_CAL_READXONLY &h100000
#define JOY_CAL_READYONLY &h200000
#define JOY_CAL_READ5 &h400000
#define JOY_CAL_READ6 &h800000
#define JOY_CAL_READZONLY &h1000000
#define JOY_CAL_READRONLY &h2000000
#define JOY_CAL_READUONLY &h4000000
#define JOY_CAL_READVONLY &h8000000
#define JOYSTICKID1 0
#define JOYSTICKID2 1
#define JOYCAPS_HASZ 1
#define JOYCAPS_HASR 2
#define JOYCAPS_HASU 4
#define JOYCAPS_HASV 8
#define JOYCAPS_HASPOV 16
#define JOYCAPS_POV4DIR 32
#define JOYCAPS_POVCTS 64
#define MMIOERR_BASE 256
#define MMIOERR_FILENOTFOUND (256+1)
#define MMIOERR_OUTOFMEMORY (256+2)
#define MMIOERR_CANNOTOPEN (256+3)
#define MMIOERR_CANNOTCLOSE (256+4)
#define MMIOERR_CANNOTREAD (256+5)
#define MMIOERR_CANNOTWRITE (256+6)
#define MMIOERR_CANNOTSEEK (256+7)
#define MMIOERR_CANNOTEXPAND (256+8)
#define MMIOERR_CHUNKNOTFOUND (256+9)
#define MMIOERR_UNBUFFERED (256+10)
#define MMIOERR_PATHNOTFOUND (256+11)
#define MMIOERR_ACCESSDENIED (256+12)
#define MMIOERR_SHARINGVIOLATION (256+13)
#define MMIOERR_NETWORKERROR (256+14)
#define MMIOERR_TOOMANYOPENFILES (256+15)
#define MMIOERR_INVALIDFILE (256+16)
#define CFSEPCHAR asc("+")
#define MMIO_RWMODE 3
#define MMIO_SHAREMODE &h70
#define MMIO_CREATE &h1000
#define MMIO_PARSE 256
#define MMIO_DELETE 512
#define MMIO_EXIST &h4000
#define MMIO_ALLOCBUF &h10000
#define MMIO_GETTEMP &h20000
#define MMIO_DIRTY &h10000000
#define MMIO_READ 0
#define MMIO_WRITE 1
#define MMIO_READWRITE 2
#define MMIO_COMPAT 0
#define MMIO_EXCLUSIVE 16
#define MMIO_DENYWRITE 32
#define MMIO_DENYREAD &h30
#define MMIO_DENYNONE 64
#define MMIO_FHOPEN 16
#define MMIO_EMPTYBUF 16
#define MMIO_TOUPPER 16
#define MMIO_INSTALLPROC &h10000
#define MMIO_GLOBALPROC &h10000000
#define MMIO_REMOVEPROC &h20000
#define MMIO_UNICODEPROC &h1000000
#define MMIO_FINDPROC &h40000
#define MMIO_FINDCHUNK 16
#define MMIO_FINDRIFF 32
#define MMIO_FINDLIST 64
#define MMIO_CREATERIFF 32
#define MMIO_CREATELIST 64
#define MMIOM_READ 0
#define MMIOM_WRITE 1
#define MMIOM_SEEK 2
#define MMIOM_OPEN 3
#define MMIOM_CLOSE 4
#define MMIOM_WRITEFLUSH 5
#define MMIOM_RENAME 6
#define MMIOM_USER &h8000
#define FOURCC_RIFF mmioFOURCC(asc("R"), asc("I"), asc("F"), asc("F"))
#define FOURCC_LIST mmioFOURCC(asc("L"), asc("I"), asc("S"), asc("T"))
#define FOURCC_DOS mmioFOURCC(asc("D"), asc("O"), asc("S"), asc(" "))
#define FOURCC_MEM mmioFOURCC(asc("M"), asc("E"), asc("M"), asc(" "))
#define MMIO_DEFAULTBUFFER 8192
#define MCIERR_INVALID_DEVICE_ID (256+1)
#define MCIERR_UNRECOGNIZED_KEYWORD (256+3)
#define MCIERR_UNRECOGNIZED_COMMAND (256+5)
#define MCIERR_HARDWARE (256+6)
#define MCIERR_INVALID_DEVICE_NAME (256+7)
#define MCIERR_OUT_OF_MEMORY (256+8)
#define MCIERR_DEVICE_OPEN (256+9)
#define MCIERR_CANNOT_LOAD_DRIVER (256+10)
#define MCIERR_MISSING_COMMAND_STRING (256+11)
#define MCIERR_PARAM_OVERFLOW (256+12)
#define MCIERR_MISSING_STRING_ARGUMENT (256+13)
#define MCIERR_BAD_INTEGER (256+14)
#define MCIERR_PARSER_INTERNAL (256+15)
#define MCIERR_DRIVER_INTERNAL (256+16)
#define MCIERR_MISSING_PARAMETER (256+17)
#define MCIERR_UNSUPPORTED_FUNCTION (256+18)
#define MCIERR_FILE_NOT_FOUND (256+19)
#define MCIERR_DEVICE_NOT_READY (256+20)
#define MCIERR_INTERNAL (256+21)
#define MCIERR_DRIVER (256+22)
#define MCIERR_CANNOT_USE_ALL (256+23)
#define MCIERR_MULTIPLE (256+24)
#define MCIERR_EXTENSION_NOT_FOUND (256+25)
#define MCIERR_OUTOFRANGE (256+26)
#define MCIERR_FLAGS_NOT_COMPATIBLE (256+28)
#define MCIERR_FILE_NOT_SAVED (256+30)
#define MCIERR_DEVICE_TYPE_REQUIRED (256+31)
#define MCIERR_DEVICE_LOCKED (256+32)
#define MCIERR_DUPLICATE_ALIAS (256+33)
#define MCIERR_BAD_CONSTANT (256+34)
#define MCIERR_MUST_USE_SHAREABLE (256+35)
#define MCIERR_MISSING_DEVICE_NAME (256+36)
#define MCIERR_BAD_TIME_FORMAT (256+37)
#define MCIERR_NO_CLOSING_QUOTE (256+38)
#define MCIERR_DUPLICATE_FLAGS (256+39)
#define MCIERR_INVALID_FILE (256+40)
#define MCIERR_NULL_PARAMETER_BLOCK (256+41)
#define MCIERR_UNNAMED_RESOURCE (256+42)
#define MCIERR_NEW_REQUIRES_ALIAS (256+43)
#define MCIERR_NOTIFY_ON_AUTO_OPEN (256+44)
#define MCIERR_NO_ELEMENT_ALLOWED (256+45)
#define MCIERR_NONAPPLICABLE_FUNCTION (256+46)
#define MCIERR_ILLEGAL_FOR_AUTO_OPEN (256+47)
#define MCIERR_FILENAME_REQUIRED (256+48)
#define MCIERR_EXTRA_CHARACTERS (256+49)
#define MCIERR_DEVICE_NOT_INSTALLED (256+50)
#define MCIERR_GET_CD (256+51)
#define MCIERR_SET_CD (256+52)
#define MCIERR_SET_DRIVE (256+53)
#define MCIERR_DEVICE_LENGTH (256+54)
#define MCIERR_DEVICE_ORD_LENGTH (256+55)
#define MCIERR_NO_INTEGER (256+56)
#define MCIERR_WAVE_OUTPUTSINUSE (256+64)
#define MCIERR_WAVE_SETOUTPUTINUSE (256+65)
#define MCIERR_WAVE_INPUTSINUSE (256+66)
#define MCIERR_WAVE_SETINPUTINUSE (256+67)
#define MCIERR_WAVE_OUTPUTUNSPECIFIED (256+68)
#define MCIERR_WAVE_INPUTUNSPECIFIED (256+69)
#define MCIERR_WAVE_OUTPUTSUNSUITABLE (256+70)
#define MCIERR_WAVE_SETOUTPUTUNSUITABLE (256+71)
#define MCIERR_WAVE_INPUTSUNSUITABLE (256+72)
#define MCIERR_WAVE_SETINPUTUNSUITABLE (256+73)
#define MCIERR_SEQ_DIV_INCOMPATIBLE (256+80)
#define MCIERR_SEQ_PORT_INUSE (256+81)
#define MCIERR_SEQ_PORT_NONEXISTENT (256+82)
#define MCIERR_SEQ_PORT_MAPNODEVICE (256+83)
#define MCIERR_SEQ_PORT_MISCERROR (256+84)
#define MCIERR_SEQ_TIMER (256+85)
#define MCIERR_SEQ_PORTUNSPECIFIED (256+86)
#define MCIERR_SEQ_NOMIDIPRESENT (256+87)
#define MCIERR_NO_WINDOW (256+90)
#define MCIERR_CREATEWINDOW (256+91)
#define MCIERR_FILE_READ (256+92)
#define MCIERR_FILE_WRITE (256+93)
#define MCIERR_NO_IDENTITY (256+94)
#define MCIERR_CUSTOM_DRIVER_BASE (256+256)
#define MCI_FIRST &h800
#define MCI_OPEN &h803
#define MCI_CLOSE &h804
#define MCI_ESCAPE &h805
#define MCI_PLAY &h806
#define MCI_SEEK &h807
#define MCI_STOP &h808
#define MCI_PAUSE &h809
#define MCI_INFO &h80A
#define MCI_GETDEVCAPS &h80B
#define MCI_SPIN &h80C
#define MCI_SET &h80D
#define MCI_STEP &h80E
#define MCI_RECORD &h80F
#define MCI_SYSINFO &h810
#define MCI_BREAK &h811
#define MCI_SAVE &h813
#define MCI_STATUS &h814
#define MCI_CUE &h830
#define MCI_REALIZE &h840
#define MCI_WINDOW &h841
#define MCI_PUT &h842
#define MCI_WHERE &h843
#define MCI_FREEZE &h844
#define MCI_UNFREEZE &h845
#define MCI_LOAD &h850
#define MCI_CUT &h851
#define MCI_COPY &h852
#define MCI_PASTE &h853
#define MCI_UPDATE &h854
#define MCI_RESUME &h855
#define MCI_DELETE &h856
#define MCI_USER_MESSAGES (&h800+&h400)
#define MCI_LAST &hFFF
#define MCI_ALL_DEVICE_ID cuint(-1)
#define MCI_DEVTYPE_VCR 513
#define MCI_DEVTYPE_VIDEODISC 514
#define MCI_DEVTYPE_OVERLAY 515
#define MCI_DEVTYPE_CD_AUDIO 516
#define MCI_DEVTYPE_DAT 517
#define MCI_DEVTYPE_SCANNER 518
#define MCI_DEVTYPE_ANIMATION 519
#define MCI_DEVTYPE_DIGITAL_VIDEO 520
#define MCI_DEVTYPE_OTHER 521
#define MCI_DEVTYPE_WAVEFORM_AUDIO 522
#define MCI_DEVTYPE_SEQUENCER 523
#define MCI_DEVTYPE_FIRST 513
#define MCI_DEVTYPE_LAST 523
#define MCI_DEVTYPE_FIRST_USER &h1000
#define MCI_MODE_NOT_READY (512+12)
#define MCI_MODE_STOP (512+13)
#define MCI_MODE_PLAY (512+14)
#define MCI_MODE_RECORD (512+15)
#define MCI_MODE_SEEK (512+16)
#define MCI_MODE_PAUSE (512+17)
#define MCI_MODE_OPEN (512+18)
#define MCI_FORMAT_MILLISECONDS 0
#define MCI_FORMAT_HMS 1
#define MCI_FORMAT_MSF 2
#define MCI_FORMAT_FRAMES 3
#define MCI_FORMAT_SMPTE_24 4
#define MCI_FORMAT_SMPTE_25 5
#define MCI_FORMAT_SMPTE_30 6
#define MCI_FORMAT_SMPTE_30DROP 7
#define MCI_FORMAT_BYTES 8
#define MCI_FORMAT_SAMPLES 9
#define MCI_FORMAT_TMSF 10
#define MCI_MSF_MINUTE(t) cubyte(t)
#define MCI_MSF_SECOND(t) cubyte(cushort(t) shr 8)
#define MCI_MSF_FRAME(t) cubyte((t) shr 16)
#define MCI_MAKE_MSF(m,s,f) cuint((cubyte(m) or (cushort(s) shl 8)) or (cuint(cubyte(f)) shl 16))
#define MCI_TMSF_TRACK(t) cubyte(t)
#define MCI_TMSF_MINUTE(t) cubyte(cushort(t) shr 8)
#define MCI_TMSF_SECOND(t) cubyte((t) shr 16)
#define MCI_TMSF_FRAME(t) cubyte((t) shr 24)
#define MCI_MAKE_TMSF(t,m,s,f) cuint((cubyte(t) or (cushort(m) shl 8)) or ((cuint(cubyte(s)) or (cushort(f) shl 8)) shl 16))
#define MCI_HMS_HOUR(t) cubyte(t)
#define MCI_HMS_MINUTE(t) cubyte(cushort(t) shr 8)
#define MCI_HMS_SECOND(t) cubyte((t) shr 16)
#define MCI_MAKE_HMS(h,m,s) cuint((cubyte(h) or (cushort(m) shl 8)) or ((cuint(cubyte(s))) shl 16))
#define MCI_NOTIFY_SUCCESSFUL 1
#define MCI_NOTIFY_SUPERSEDED 2
#define MCI_NOTIFY_ABORTED 4
#define MCI_NOTIFY_FAILURE 8
#define MCI_NOTIFY 1
#define MCI_WAIT 2
#define MCI_FROM 4
#define MCI_TO 8
#define MCI_TRACK 16
#define MCI_OPEN_SHAREABLE 256
#define MCI_OPEN_ELEMENT 512
#define MCI_OPEN_ALIAS 1024
#define MCI_OPEN_ELEMENT_ID 2048
#define MCI_OPEN_TYPE_ID &h1000
#define MCI_OPEN_TYPE &h2000
#define MCI_SEEK_TO_START 256
#define MCI_SEEK_TO_END 512
#define MCI_STATUS_ITEM 256
#define MCI_STATUS_START 512
#define MCI_STATUS_LENGTH 1
#define MCI_STATUS_POSITION 2
#define MCI_STATUS_NUMBER_OF_TRACKS 3
#define MCI_STATUS_MODE 4
#define MCI_STATUS_MEDIA_PRESENT 5
#define MCI_STATUS_TIME_FORMAT 6
#define MCI_STATUS_READY 7
#define MCI_STATUS_CURRENT_TRACK 8
#define MCI_INFO_PRODUCT 256
#define MCI_INFO_FILE 512
#define MCI_INFO_MEDIA_UPC 1024
#define MCI_INFO_MEDIA_IDENTITY 2048
#define MCI_INFO_NAME &h1000
#define MCI_INFO_COPYRIGHT &h2000
#define MCI_GETDEVCAPS_ITEM 256
#define MCI_GETDEVCAPS_CAN_RECORD 1
#define MCI_GETDEVCAPS_HAS_AUDIO 2
#define MCI_GETDEVCAPS_HAS_VIDEO 3
#define MCI_GETDEVCAPS_DEVICE_TYPE 4
#define MCI_GETDEVCAPS_USES_FILES 5
#define MCI_GETDEVCAPS_COMPOUND_DEVICE 6
#define MCI_GETDEVCAPS_CAN_EJECT 7
#define MCI_GETDEVCAPS_CAN_PLAY 8
#define MCI_GETDEVCAPS_CAN_SAVE 9
#define MCI_SYSINFO_QUANTITY 256
#define MCI_SYSINFO_OPEN 512
#define MCI_SYSINFO_NAME 1024
#define MCI_SYSINFO_INSTALLNAME 2048
#define MCI_SET_DOOR_OPEN 256
#define MCI_SET_DOOR_CLOSED 512
#define MCI_SET_TIME_FORMAT 1024
#define MCI_SET_AUDIO 2048
#define MCI_SET_VIDEO &h1000
#define MCI_SET_ON &h2000
#define MCI_SET_OFF &h4000
#define MCI_SET_AUDIO_ALL 0
#define MCI_SET_AUDIO_LEFT 1
#define MCI_SET_AUDIO_RIGHT 2
#define MCI_BREAK_KEY 256
#define MCI_BREAK_HWND 512
#define MCI_BREAK_OFF 1024
#define MCI_RECORD_INSERT 256
#define MCI_RECORD_OVERWRITE 512
#define MCI_SAVE_FILE 256
#define MCI_LOAD_FILE 256
#define MCI_VD_MODE_PARK (1024+1)
#define MCI_VD_MEDIA_CLV (1024+2)
#define MCI_VD_MEDIA_CAV (1024+3)
#define MCI_VD_MEDIA_OTHER (1024+4)
#define MCI_VD_FORMAT_TRACK &h4001
#define MCI_VD_PLAY_REVERSE &h10000
#define MCI_VD_PLAY_FAST &h20000
#define MCI_VD_PLAY_SPEED &h40000
#define MCI_VD_PLAY_SCAN &h80000
#define MCI_VD_PLAY_SLOW &h100000
#define MCI_VD_SEEK_REVERSE &h10000
#define MCI_VD_STATUS_SPEED &h4002
#define MCI_VD_STATUS_FORWARD &h4003
#define MCI_VD_STATUS_MEDIA_TYPE &h4004
#define MCI_VD_STATUS_SIDE &h4005
#define MCI_VD_STATUS_DISC_SIZE &h4006
#define MCI_VD_GETDEVCAPS_CLV &h10000
#define MCI_VD_GETDEVCAPS_CAV &h20000
#define MCI_VD_SPIN_UP &h10000
#define MCI_VD_SPIN_DOWN &h20000
#define MCI_VD_GETDEVCAPS_CAN_REVERSE &h4002
#define MCI_VD_GETDEVCAPS_FAST_RATE &h4003
#define MCI_VD_GETDEVCAPS_SLOW_RATE &h4004
#define MCI_VD_GETDEVCAPS_NORMAL_RATE &h4005
#define MCI_VD_STEP_FRAMES &h10000
#define MCI_VD_STEP_REVERSE &h20000
#define MCI_VD_ESCAPE_STRING 256
#define MCI_CDA_STATUS_TYPE_TRACK &h4001
#define MCI_CDA_TRACK_AUDIO 1088
#define MCI_CDA_TRACK_OTHER (1088+1)
#define MCI_WAVE_PCM 1152
#define MCI_WAVE_MAPPER (1152+1)
#define MCI_WAVE_OPEN_BUFFER &h10000
#define MCI_WAVE_SET_FORMATTAG &h10000
#define MCI_WAVE_SET_CHANNELS &h20000
#define MCI_WAVE_SET_SAMPLESPERSEC &h40000
#define MCI_WAVE_SET_AVGBYTESPERSEC &h80000
#define MCI_WAVE_SET_BLOCKALIGN &h100000
#define MCI_WAVE_SET_BITSPERSAMPLE &h200000
#define MCI_WAVE_INPUT &h400000
#define MCI_WAVE_OUTPUT &h800000
#define MCI_WAVE_STATUS_FORMATTAG &h4001
#define MCI_WAVE_STATUS_CHANNELS &h4002
#define MCI_WAVE_STATUS_SAMPLESPERSEC &h4003
#define MCI_WAVE_STATUS_AVGBYTESPERSEC &h4004
#define MCI_WAVE_STATUS_BLOCKALIGN &h4005
#define MCI_WAVE_STATUS_BITSPERSAMPLE &h4006
#define MCI_WAVE_STATUS_LEVEL &h4007
#define MCI_WAVE_SET_ANYINPUT &h4000000
#define MCI_WAVE_SET_ANYOUTPUT &h8000000
#define MCI_WAVE_GETDEVCAPS_INPUTS &h4001
#define MCI_WAVE_GETDEVCAPS_OUTPUTS &h4002
#define MCI_SEQ_DIV_PPQN 1216
#define MCI_SEQ_DIV_SMPTE_24 (1216+1)
#define MCI_SEQ_DIV_SMPTE_25 (1216+2)
#define MCI_SEQ_DIV_SMPTE_30DROP (1216+3)
#define MCI_SEQ_DIV_SMPTE_30 (1216+4)
#define MCI_SEQ_FORMAT_SONGPTR &h4001
#define MCI_SEQ_FILE &h4002
#define MCI_SEQ_MIDI &h4003
#define MCI_SEQ_SMPTE &h4004
#define MCI_SEQ_NONE 65533
#define MCI_SEQ_MAPPER 65535
#define MCI_SEQ_STATUS_TEMPO &h4002
#define MCI_SEQ_STATUS_PORT &h4003
#define MCI_SEQ_STATUS_SLAVE &h4007
#define MCI_SEQ_STATUS_MASTER &h4008
#define MCI_SEQ_STATUS_OFFSET &h4009
#define MCI_SEQ_STATUS_DIVTYPE &h400A
#define MCI_SEQ_STATUS_NAME &h400B
#define MCI_SEQ_STATUS_COPYRIGHT &h400C
#define MCI_SEQ_SET_TEMPO &h10000
#define MCI_SEQ_SET_PORT &h20000
#define MCI_SEQ_SET_SLAVE &h40000
#define MCI_SEQ_SET_MASTER &h80000
#define MCI_SEQ_SET_OFFSET &h1000000
#define MCI_ANIM_OPEN_WS &h10000
#define MCI_ANIM_OPEN_PARENT &h20000
#define MCI_ANIM_OPEN_NOSTATIC &h40000
#define MCI_ANIM_PLAY_SPEED &h10000
#define MCI_ANIM_PLAY_REVERSE &h20000
#define MCI_ANIM_PLAY_FAST &h40000
#define MCI_ANIM_PLAY_SLOW &h80000
#define MCI_ANIM_PLAY_SCAN &h100000
#define MCI_ANIM_STEP_REVERSE &h10000
#define MCI_ANIM_STEP_FRAMES &h20000
#define MCI_ANIM_STATUS_SPEED &h4001
#define MCI_ANIM_STATUS_FORWARD &h4002
#define MCI_ANIM_STATUS_HWND &h4003
#define MCI_ANIM_STATUS_HPAL &h4004
#define MCI_ANIM_STATUS_STRETCH &h4005
#define MCI_ANIM_INFO_TEXT &h10000
#define MCI_ANIM_GETDEVCAPS_CAN_REVERSE &h4001
#define MCI_ANIM_GETDEVCAPS_FAST_RATE &h4002
#define MCI_ANIM_GETDEVCAPS_SLOW_RATE &h4003
#define MCI_ANIM_GETDEVCAPS_NORMAL_RATE &h4004
#define MCI_ANIM_GETDEVCAPS_PALETTES &h4006
#define MCI_ANIM_GETDEVCAPS_CAN_STRETCH &h4007
#define MCI_ANIM_GETDEVCAPS_MAX_WINDOWS &h4008
#define MCI_ANIM_REALIZE_NORM &h10000
#define MCI_ANIM_REALIZE_BKGD &h20000
#define MCI_ANIM_WINDOW_HWND &h10000
#define MCI_ANIM_WINDOW_STATE &h40000
#define MCI_ANIM_WINDOW_TEXT &h80000
#define MCI_ANIM_WINDOW_ENABLE_STRETCH &h100000
#define MCI_ANIM_WINDOW_DISABLE_STRETCH &h200000
#define MCI_ANIM_WINDOW_DEFAULT &hL
#define MCI_ANIM_RECT &h10000
#define MCI_ANIM_PUT_SOURCE &h20000
#define MCI_ANIM_PUT_DESTINATION &h40000
#define MCI_ANIM_WHERE_SOURCE &h20000
#define MCI_ANIM_WHERE_DESTINATION &h40000
#define MCI_ANIM_UPDATE_HDC &h20000
#define MCI_OVLY_OPEN_WS &h10000
#define MCI_OVLY_OPEN_PARENT &h20000
#define MCI_OVLY_STATUS_HWND &h4001
#define MCI_OVLY_STATUS_STRETCH &h4002
#define MCI_OVLY_INFO_TEXT &h10000
#define MCI_OVLY_GETDEVCAPS_CAN_STRETCH &h4001
#define MCI_OVLY_GETDEVCAPS_CAN_FREEZE &h4002
#define MCI_OVLY_GETDEVCAPS_MAX_WINDOWS &h4003
#define MCI_OVLY_WINDOW_HWND &h10000
#define MCI_OVLY_WINDOW_STATE &h40000
#define MCI_OVLY_WINDOW_TEXT &h80000
#define MCI_OVLY_WINDOW_ENABLE_STRETCH &h100000
#define MCI_OVLY_WINDOW_DISABLE_STRETCH &h200000
#define MCI_OVLY_WINDOW_DEFAULT &hL
#define MCI_OVLY_RECT &h10000
#define MCI_OVLY_PUT_SOURCE &h20000
#define MCI_OVLY_PUT_DESTINATION &h40000
#define MCI_OVLY_PUT_FRAME &h80000
#define MCI_OVLY_PUT_VIDEO &h100000
#define MCI_OVLY_WHERE_SOURCE &h20000
#define MCI_OVLY_WHERE_DESTINATION &h40000
#define MCI_OVLY_WHERE_FRAME &h80000
#define MCI_OVLY_WHERE_VIDEO &h100000
#define NEWTRANSPARENT 3
#define QUERYROPSUPPORT 40
#define SELECTDIB 41
#define DIBINDEX(n) MAKELONG((n),&h10FF)
#define SC_SCREENSAVE &hF140
#define CAPS1 94
#define C1_TRANSPARENT 1
#ifndef SEEK_SET
#define SEEK_SET 0
#endif
#ifndef SEEK_CUR
#define SEEK_CUR 1
#endif
#ifndef SEEK_END
#define SEEK_END 2
#endif

type MCIERROR as DWORD
type MCIDEVICEID as UINT
type YIELDPROC as function (byval as MCIDEVICEID, byval as DWORD) as UINT
type MMVERSION as UINT
type MMRESULT as UINT

type MMTIME_u_smpte field=1
	hour as UBYTE
	min_ as UBYTE
	sec as UBYTE
	frame as UBYTE
	fps as UBYTE
	dummy as UBYTE
	pad(0 to 2-1) as UBYTE
end type

type MMTIME_u_midi field=1
	songptrpos as DWORD
end type

type MMTIME field=1
	wType as UINT
	union
		ms as DWORD
		sample as DWORD
		cb as DWORD
		ticks as DWORD
		smpte as MMTIME_u_smpte
		midi as MMTIME_u_midi
	end union
end type

type PMMTIME as MMTIME ptr
type LPMMTIME as MMTIME ptr

type HDRVR__
	i as integer
end type

type HDRVR as HDRVR__ ptr

type DRVCONFIGINFO field=1
	dwDCISize as DWORD
	lpszDCISectionName as LPCWSTR
	lpszDCIAliasName as LPCWSTR
end type

type PDRVCONFIGINFO as DRVCONFIGINFO ptr
type LPDRVCONFIGINFO as DRVCONFIGINFO ptr

type DRVCONFIGINFOEX field=1
	dwDCISize as DWORD
	lpszDCISectionName as LPCWSTR
	lpszDCIAliasName as LPCWSTR
	dnDevNode as DWORD
end type

type PDRVCONFIGINFOEX as DRVCONFIGINFOEX ptr
type LPDRVCONFIGINFOEX as DRVCONFIGINFOEX ptr
type DRIVERPROC as function (byval as DWORD, byval as HDRVR, byval as UINT, byval as LPARAM, byval as LPARAM) as LRESULT
type DRVCALLBACK as any
type LPDRVCALLBACK as DRVCALLBACK ptr
type PDRVCALLBACK as DRVCALLBACK ptr

type HWAVE__
	i as integer
end type

type HWAVE as HWAVE__ ptr

type HWAVEIN__
	i as integer
end type

type HWAVEIN as HWAVEIN__ ptr

type HWAVEOUT__
	i as integer
end type

type HWAVEOUT as HWAVEOUT__ ptr
type LPHWAVEIN as HWAVEIN ptr
type LPHWAVEOUT as HWAVEOUT ptr
type WAVECALLBACK as DRVCALLBACK
type LPWAVECALLBACK as WAVECALLBACK ptr

type WAVEHDR field=1
	lpData as LPSTR
	dwBufferLength as DWORD
	dwBytesRecorded as DWORD
	dwUser as DWORD
	dwFlags as DWORD
	dwLoops as DWORD
	lpNext as WAVEHDR ptr
	reserved as DWORD
end type

type PWAVEHDR as WAVEHDR ptr
type LPWAVEHDR as WAVEHDR ptr

type WAVEFORMAT field=1
	wFormatTag as WORD
	nChannels as WORD
	nSamplesPerSec as DWORD
	nAvgBytesPerSec as DWORD
	nBlockAlign as WORD
end type

type PWAVEFORMAT as WAVEFORMAT ptr
type LPWAVEFORMAT as WAVEFORMAT ptr

#ifndef UNICODE
type WAVEOUTCAPSA field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as zstring * 32
	dwFormats as DWORD
	wChannels as WORD
	wReserved1 as WORD
	dwSupport as DWORD
end type

type PWAVEOUTCAPSA as WAVEOUTCAPSA ptr
type LPWAVEOUTCAPSA as WAVEOUTCAPSA ptr

type WAVEINCAPSA field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as zstring * 32
	dwFormats as DWORD
	wChannels as WORD
	wReserved1 as WORD
end type

type PWAVEINCAPSA as WAVEINCAPSA ptr
type LPWAVEINCAPSA as WAVEINCAPSA ptr

#else ''UNICODE
type WAVEOUTCAPSW field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as wstring * 32
	dwFormats as DWORD
	wChannels as WORD
	wReserved1 as WORD
	dwSupport as DWORD
end type

type PWAVEOUTCAPSW as WAVEOUTCAPSW ptr
type LPWAVEOUTCAPSW as WAVEOUTCAPSW ptr

type WAVEINCAPSW field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as wstring * 32
	dwFormats as DWORD
	wChannels as WORD
	wReserved1 as WORD
end type

type PWAVEINCAPSW as WAVEINCAPSW ptr
type LPWAVEINCAPSW as WAVEINCAPSW ptr

#endif ''UNICODE

type PCMWAVEFORMAT field=1
	wf as WAVEFORMAT
	wBitsPerSample as WORD
end type

type PPCMWAVEFORMAT as PCMWAVEFORMAT ptr
type LPPCMWAVEFORMAT as PCMWAVEFORMAT ptr

type WAVEFORMATEX field=1
	wFormatTag as WORD
	nChannels as WORD
	nSamplesPerSec as DWORD
	nAvgBytesPerSec as DWORD
	nBlockAlign as WORD
	wBitsPerSample as WORD
	cbSize as WORD
end type

type PWAVEFORMATEX as WAVEFORMATEX ptr
type LPWAVEFORMATEX as WAVEFORMATEX ptr
type LPCWAVEFORMATEX as const WAVEFORMATEX ptr

type HMIDI__
	i as integer
end type

type HMIDI as HMIDI__ ptr

type HMIDIIN__
	i as integer
end type

type HMIDIIN as HMIDIIN__ ptr

type HMIDIOUT__
	i as integer
end type

type HMIDIOUT as HMIDIOUT__ ptr

type HMIDISTRM__
	i as integer
end type

type HMIDISTRM as HMIDISTRM__ ptr
type LPHMIDI as HMIDI ptr
type LPHMIDIIN as HMIDIIN ptr
type LPHMIDIOUT as HMIDIOUT ptr
type LPHMIDISTRM as HMIDISTRM ptr
type MIDICALLBACK as DRVCALLBACK
type LPMIDICALLBACK as MIDICALLBACK ptr
type PATCHARRAY as WORD ptr
type LPPATCHARRAY as WORD ptr
type KEYARRAY as WORD ptr
type LPKEYARRAY as WORD ptr

#ifndef UNICODE
type MIDIOUTCAPSA field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as zstring * 32
	wTechnology as WORD
	wVoices as WORD
	wNotes as WORD
	wChannelMask as WORD
	dwSupport as DWORD
end type

type PMIDIOUTCAPSA as MIDIOUTCAPSA ptr
type LPMIDIOUTCAPSA as MIDIOUTCAPSA ptr

type MIDIINCAPSA field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as zstring * 32
	dwSupport as DWORD
end type

type PMIDIINCAPSA as MIDIINCAPSA ptr
type LPMIDIINCAPSA as MIDIINCAPSA ptr

#else ''UNICODE
type MIDIOUTCAPSW field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as wstring * 32
	wTechnology as WORD
	wVoices as WORD
	wNotes as WORD
	wChannelMask as WORD
	dwSupport as DWORD
end type

type PMIDIOUTCAPSW as MIDIOUTCAPSW ptr
type LPMIDIOUTCAPSW as MIDIOUTCAPSW ptr

type MIDIINCAPSW field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as wstring * 32
	dwSupport as DWORD
end type

type PMIDIINCAPSW as MIDIINCAPSW ptr
type NPMIDIINCAPSW as MIDIINCAPSW ptr
type LPMIDIINCAPSW as MIDIINCAPSW ptr

#endif ''UNICODE

type MIDIHDR field=1
	lpData as LPSTR
	dwBufferLength as DWORD
	dwBytesRecorded as DWORD
	dwUser as DWORD
	dwFlags as DWORD
	lpNext as MIDIHDR ptr
	reserved as DWORD
	dwOffset as DWORD
	dwReserved(0 to 8-1) as DWORD
end type

type PMIDIHDR as MIDIHDR ptr
type LPMIDIHDR as MIDIHDR ptr

type MIDIEVENT field=1
	dwDeltaTime as DWORD
	dwStreamID as DWORD
	dwEvent as DWORD
	dwParms(0 to 1-1) as DWORD
end type

type MIDISTRMBUFFVER field=1
	dwVersion as DWORD
	dwMid as DWORD
	dwOEMVersion as DWORD
end type

type MIDIPROPTIMEDIV field=1
	cbStruct as DWORD
	dwTimeDiv as DWORD
end type

type LPMIDIPROPTIMEDIV as MIDIPROPTIMEDIV ptr

type MIDIPROPTEMPO field=1
	cbStruct as DWORD
	dwTempo as DWORD
end type

type LPMIDIPROPTEMPO as MIDIPROPTEMPO ptr

#ifndef UNICODE
type AUXCAPSA field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as zstring * 32
	wTechnology as WORD
	wReserved1 as WORD
	dwSupport as DWORD
end type

type PAUXCAPSA as AUXCAPSA ptr
type LPAUXCAPSA as AUXCAPSA ptr

#else ''UNICODE
type AUXCAPSW field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as wstring * 32
	wTechnology as WORD
	wReserved1 as WORD
	dwSupport as DWORD
end type

type PAUXCAPSW as AUXCAPSW ptr
type LPAUXCAPSW as AUXCAPSW ptr
#endif ''UNICODE

type HMIXEROBJ__
	i as integer
end type

type HMIXEROBJ as HMIXEROBJ__ ptr
type LPHMIXEROBJ as HMIXEROBJ ptr

type HMIXER__
	i as integer
end type

type HMIXER as HMIXER__ ptr
type LPHMIXER as HMIXER ptr

#ifndef UNICODE
type MIXERCAPSA field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as zstring * 32
	fdwSupport as DWORD
	cDestinations as DWORD
end type

type PMIXERCAPSA as MIXERCAPSA ptr
type LPMIXERCAPSA as MIXERCAPSA ptr

type MIXERLINEA_Target field=1
	dwType as DWORD
	dwDeviceID as DWORD
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as zstring * 32
end type

type MIXERLINEA field=1
	cbStruct as DWORD
	dwDestination as DWORD
	dwSource as DWORD
	dwLineID as DWORD
	fdwLine as DWORD
	dwUser as DWORD
	dwComponentType as DWORD
	cChannels as DWORD
	cConnections as DWORD
	cControls as DWORD
	szShortName as zstring * 16
	szName as zstring * 64
	Target as MIXERLINEA_Target
end type

type PMIXERLINEA as MIXERLINEA ptr
type LPMIXERLINEA as MIXERLINEA ptr

union MIXERCONTROLA_Metrics field=1
	cSteps as DWORD
	cbCustomData as DWORD
	dwReserved(0 to 6-1) as DWORD
end union

union MIXERCONTROLA_Bounds field=1
	type
		lMinimum as LONG
		lMaximum as LONG
	end type
	type
		dwMinimum as DWORD
		dwMaximum as DWORD
	end type
	dwReserved(0 to 6-1) as DWORD
end union

type MIXERCONTROLA field=1
	cbStruct as DWORD
	dwControlID as DWORD
	dwControlType as DWORD
	fdwControl as DWORD
	cMultipleItems as DWORD
	szShortName as zstring * 16
	szName as zstring * 64
	Bounds as MIXERCONTROLA_Bounds
	Metrics as MIXERCONTROLA_Metrics
end type

type PMIXERCONTROLA as MIXERCONTROLA ptr
type LPMIXERCONTROLA as MIXERCONTROLA ptr

type MIXERLINECONTROLSA field=1
	cbStruct as DWORD
	dwLineID as DWORD
	union
		dwControlID as DWORD
		dwControlType as DWORD
	end union
	cControls as DWORD
	cbmxctrl as DWORD
	pamxctrl as LPMIXERCONTROLA
end type

type PMIXERLINECONTROLSA as MIXERLINECONTROLSA ptr
type LPMIXERLINECONTROLSA as MIXERLINECONTROLSA ptr

#else ''UNICODE
type MIXERCAPSW field=1
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as wstring * 32
	fdwSupport as DWORD
	cDestinations as DWORD
end type

type PMIXERCAPSW as MIXERCAPSW ptr
type LPMIXERCAPSW as MIXERCAPSW ptr

type MIXERLINEW_Target field=1
	dwType as DWORD
	dwDeviceID as DWORD
	wMid as WORD
	wPid as WORD
	vDriverVersion as MMVERSION
	szPname as wstring * 32
end type

type MIXERLINEW field=1
	cbStruct as DWORD
	dwDestination as DWORD
	dwSource as DWORD
	dwLineID as DWORD
	fdwLine as DWORD
	dwUser as DWORD
	dwComponentType as DWORD
	cChannels as DWORD
	cConnections as DWORD
	cControls as DWORD
	szShortName as wstring * 16
	szName as wstring * 64
	Target as MIXERLINEW_Target
end type

type PMIXERLINEW as MIXERLINEW ptr
type LPMIXERLINEW as MIXERLINEW ptr

union MIXERCONTROLW_Metrics field=1
	cSteps as DWORD
	cbCustomData as DWORD
	dwReserved(0 to 6-1) as DWORD
end union

union MIXERCONTROLW_Bounds field=1
	type
		lMinimum as LONG
		lMaximum as LONG
	end type
	type
		dwMinimum as DWORD
		dwMaximum as DWORD
	end type
	dwReserved(0 to 6-1) as DWORD
end union

type MIXERCONTROLW field=1
	cbStruct as DWORD
	dwControlID as DWORD
	dwControlType as DWORD
	fdwControl as DWORD
	cMultipleItems as DWORD
	szShortName as wstring * 16
	szName as wstring * 64
	Bounds as MIXERCONTROLW_Bounds
	Metrics as MIXERCONTROLW_Metrics
end type

type PMIXERCONTROLW as MIXERCONTROLW ptr
type LPMIXERCONTROLW as MIXERCONTROLW ptr

type MIXERLINECONTROLSW field=1
	cbStruct as DWORD
	dwLineID as DWORD
	union
		dwControlID as DWORD
		dwControlType as DWORD
	end union
	cControls as DWORD
	cbmxctrl as DWORD
	pamxctrl as LPMIXERCONTROLW
end type

type PMIXERLINECONTROLSW as MIXERLINECONTROLSW ptr
type LPMIXERLINECONTROLSW as MIXERLINECONTROLSW ptr

#endif ''UNICODE

type MIXERCONTROLDETAILS field=1
	cbStruct as DWORD
	dwControlID as DWORD
	cChannels as DWORD
	union
		hwndOwner as HWND
		cMultipleItems as DWORD
	end union
	cbDetails as DWORD
	paDetails as PVOID
end type

type PMIXERCONTROLDETAILS as MIXERCONTROLDETAILS ptr
type LPMIXERCONTROLDETAILS as MIXERCONTROLDETAILS ptr

#ifndef UNICODE
type MIXERCONTROLDETAILS_LISTTEXTA field=1
	dwParam1 as DWORD
	dwParam2 as DWORD
	szName as zstring * 64
end type

type PMIXERCONTROLDETAILS_LISTTEXTA as MIXERCONTROLDETAILS_LISTTEXTA ptr
type LPMIXERCONTROLDETAILS_LISTTEXTA as MIXERCONTROLDETAILS_LISTTEXTA ptr

#else ''UNICODE
type MIXERCONTROLDETAILS_LISTTEXTW field=1
	dwParam1 as DWORD
	dwParam2 as DWORD
	szName as wstring * 64
end type

type PMIXERCONTROLDETAILS_LISTTEXTW as MIXERCONTROLDETAILS_LISTTEXTW ptr
type LPMIXERCONTROLDETAILS_LISTTEXTW as MIXERCONTROLDETAILS_LISTTEXTW ptr

#endif ''UNICODE

type MIXERCONTROLDETAILS_BOOLEAN field=1
	fValue as LONG
end type

type PMIXERCONTROLDETAILS_BOOLEAN as MIXERCONTROLDETAILS_BOOLEAN ptr
type LPMIXERCONTROLDETAILS_BOOLEAN as MIXERCONTROLDETAILS_BOOLEAN ptr

type MIXERCONTROLDETAILS_SIGNED field=1
	lValue as LONG
end type

type PMIXERCONTROLDETAILS_SIGNED as MIXERCONTROLDETAILS_SIGNED ptr
type LPMIXERCONTROLDETAILS_SIGNED as MIXERCONTROLDETAILS_SIGNED ptr

type MIXERCONTROLDETAILS_UNSIGNED field=1
	dwValue as DWORD
end type

type PMIXERCONTROLDETAILS_UNSIGNED as MIXERCONTROLDETAILS_UNSIGNED ptr
type LPMIXERCONTROLDETAILS_UNSIGNED as MIXERCONTROLDETAILS_UNSIGNED ptr

type TIMECALLBACK as any
type LPTIMECALLBACK as TIMECALLBACK ptr

type TIMECAPS field=1
	wPeriodMin as UINT
	wPeriodMax as UINT
end type

type PTIMECAPS as TIMECAPS ptr
type LPTIMECAPS as TIMECAPS ptr

#ifndef UNICODE
type JOYCAPSA field=1
	wMid as WORD
	wPid as WORD
	szPname as zstring * 32
	wXmin as UINT
	wXmax as UINT
	wYmin as UINT
	wYmax as UINT
	wZmin as UINT
	wZmax as UINT
	wNumButtons as UINT
	wPeriodMin as UINT
	wPeriodMax as UINT
	wRmin as UINT
	wRmax as UINT
	wUmin as UINT
	wUmax as UINT
	wVmin as UINT
	wVmax as UINT
	wCaps as UINT
	wMaxAxes as UINT
	wNumAxes as UINT
	wMaxButtons as UINT
	szRegKey as zstring * 32
	szOEMVxD as zstring * 260
end type

type PJOYCAPSA as JOYCAPSA ptr
type LPJOYCAPSA as JOYCAPSA ptr

#else ''UNICODE
type JOYCAPSW field=1
	wMid as WORD
	wPid as WORD
	szPname as wstring * 32
	wXmin as UINT
	wXmax as UINT
	wYmin as UINT
	wYmax as UINT
	wZmin as UINT
	wZmax as UINT
	wNumButtons as UINT
	wPeriodMin as UINT
	wPeriodMax as UINT
	wRmin as UINT
	wRmax as UINT
	wUmin as UINT
	wUmax as UINT
	wVmin as UINT
	wVmax as UINT
	wCaps as UINT
	wMaxAxes as UINT
	wNumAxes as UINT
	wMaxButtons as UINT
	szRegKey as wstring * 32
	szOEMVxD as wstring * 260
end type

type PJOYCAPSW as JOYCAPSW ptr
type LPJOYCAPSW as JOYCAPSW ptr
#endif ''UNICODE

type JOYINFO field=1
	wXpos as UINT
	wYpos as UINT
	wZpos as UINT
	wButtons as UINT
end type

type PJOYINFO as JOYINFO ptr
type LPJOYINFO as JOYINFO ptr

type JOYINFOEX field=1
	dwSize as DWORD
	dwFlags as DWORD
	dwXpos as DWORD
	dwYpos as DWORD
	dwZpos as DWORD
	dwRpos as DWORD
	dwUpos as DWORD
	dwVpos as DWORD
	dwButtons as DWORD
	dwButtonNumber as DWORD
	dwPOV as DWORD
	dwReserved1 as DWORD
	dwReserved2 as DWORD
end type

type PJOYINFOEX as JOYINFOEX ptr
type LPJOYINFOEX as JOYINFOEX ptr

type FOURCC as DWORD
type HPSTR as byte ptr

type HMMIO__
	i as integer
end type

type HMMIO as HMMIO__ ptr
type MMIOPROC as LRESULT
type LPMMIOPROC as MMIOPROC ptr

type MMIOINFO field=1
	dwFlags as DWORD
	fccIOProc as FOURCC
	pIOProc as LPMMIOPROC
	wErrorRet as UINT
	htask as HTASK
	cchBuffer as LONG
	pchBuffer as HPSTR
	pchNext as HPSTR
	pchEndRead as HPSTR
	pchEndWrite as HPSTR
	lBufOffset as LONG
	lDiskOffset as LONG
	adwInfo(0 to 3-1) as DWORD
	dwReserved1 as DWORD
	dwReserved2 as DWORD
	hmmio as HMMIO
end type

type PMMIOINFO as MMIOINFO ptr
type LPMMIOINFO as MMIOINFO ptr
type LPCMMIOINFO as const MMIOINFO ptr

type MMCKINFO field=1
	ckid as FOURCC
	cksize as DWORD
	fccType as FOURCC
	dwDataOffset as DWORD
	dwFlags as DWORD
end type

type PMMCKINFO as MMCKINFO ptr
type LPMMCKINFO as MMCKINFO ptr
type LPCMMCKINFO as const MMCKINFO ptr

type MCI_GENERIC_PARMS field=1
	dwCallback as DWORD
end type

type PMCI_GENERIC_PARMS as MCI_GENERIC_PARMS ptr
type LPMCI_GENERIC_PARMS as MCI_GENERIC_PARMS ptr

#ifndef UNICODE
type MCI_OPEN_PARMSA field=1
	dwCallback as DWORD
	wDeviceID as MCIDEVICEID
	lpstrDeviceType as LPCSTR
	lpstrElementName as LPCSTR
	lpstrAlias as LPCSTR
end type

type PMCI_OPEN_PARMSA as MCI_OPEN_PARMSA ptr
type LPMCI_OPEN_PARMSA as MCI_OPEN_PARMSA ptr

#else ''UNICODE
type MCI_OPEN_PARMSW field=1
	dwCallback as DWORD
	wDeviceID as MCIDEVICEID
	lpstrDeviceType as LPCWSTR
	lpstrElementName as LPCWSTR
	lpstrAlias as LPCWSTR
end type

type PMCI_OPEN_PARMSW as MCI_OPEN_PARMSW ptr
type LPMCI_OPEN_PARMSW as MCI_OPEN_PARMSW ptr
#endif ''UNICODE

type MCI_PLAY_PARMS field=1
	dwCallback as DWORD
	dwFrom as DWORD
	dwTo as DWORD
end type

type PMCI_PLAY_PARMS as MCI_PLAY_PARMS ptr
type LPMCI_PLAY_PARMS as MCI_PLAY_PARMS ptr

type MCI_SEEK_PARMS field=1
	dwCallback as DWORD
	dwTo as DWORD
end type

type PMCI_SEEK_PARMS as MCI_SEEK_PARMS ptr
type LPMCI_SEEK_PARMS as MCI_SEEK_PARMS ptr

type MCI_STATUS_PARMS field=1
	dwCallback as DWORD
	dwReturn as DWORD
	dwItem as DWORD
	dwTrack as DWORD
end type

type PMCI_STATUS_PARMS as MCI_STATUS_PARMS ptr
type LPMCI_STATUS_PARMS as MCI_STATUS_PARMS ptr

#ifndef UNICODE
type MCI_INFO_PARMSA field=1
	dwCallback as DWORD
	lpstrReturn as LPSTR
	dwRetSize as DWORD
end type

type LPMCI_INFO_PARMSA as MCI_INFO_PARMSA ptr

#else ''UNICODE
type MCI_INFO_PARMSW field=1
	dwCallback as DWORD
	lpstrReturn as LPWSTR
	dwRetSize as DWORD
end type

type LPMCI_INFO_PARMSW as MCI_INFO_PARMSW ptr
#endif ''UNICODE

type MCI_GETDEVCAPS_PARMS field=1
	dwCallback as DWORD
	dwReturn as DWORD
	dwItem as DWORD
end type

type PMCI_GETDEVCAPS_PARMS as MCI_GETDEVCAPS_PARMS ptr
type LPMCI_GETDEVCAPS_PARMS as MCI_GETDEVCAPS_PARMS ptr

#ifndef UNICODE
type MCI_SYSINFO_PARMSA field=1
	dwCallback as DWORD
	lpstrReturn as LPSTR
	dwRetSize as DWORD
	dwNumber as DWORD
	wDeviceType as UINT
end type

type PMCI_SYSINFO_PARMSA as MCI_SYSINFO_PARMSA ptr
type LPMCI_SYSINFO_PARMSA as MCI_SYSINFO_PARMSA ptr

#else ''UNICODE
type MCI_SYSINFO_PARMSW field=1
	dwCallback as DWORD
	lpstrReturn as LPWSTR
	dwRetSize as DWORD
	dwNumber as DWORD
	wDeviceType as UINT
end type

type PMCI_SYSINFO_PARMSW as MCI_SYSINFO_PARMSW ptr
type LPMCI_SYSINFO_PARMSW as MCI_SYSINFO_PARMSW ptr
#endif ''UNICODE

type MCI_SET_PARMS field=1
	dwCallback as DWORD
	dwTimeFormat as DWORD
	dwAudio as DWORD
end type

type PMCI_SET_PARMS as MCI_SET_PARMS ptr
type LPMCI_SET_PARMS as MCI_SET_PARMS ptr

type MCI_BREAK_PARMS field=1
	dwCallback as DWORD
	nVirtKey as integer
	hwndBreak as HWND
end type

type PMCI_BREAK_PARMS as MCI_BREAK_PARMS ptr
type LPMCI_BREAK_PARMS as MCI_BREAK_PARMS ptr

#ifndef UNICODE
type MCI_SAVE_PARMSA field=1
	dwCallback as DWORD
	lpfilename as LPCSTR
end type

type PMCI_SAVE_PARMSA as MCI_SAVE_PARMSA ptr
type LPMCI_SAVE_PARMSA as MCI_SAVE_PARMSA ptr

#else ''UNICODE
type MCI_SAVE_PARMSW field=1
	dwCallback as DWORD
	lpfilename as LPCWSTR
end type

type PMCI_SAVE_PARMSW as MCI_SAVE_PARMSW ptr
type LPMCI_SAVE_PARMSW as MCI_SAVE_PARMSW ptr
#endif ''UNICODE

#ifndef UNICODE
type MCI_LOAD_PARMSA field=1
	dwCallback as DWORD
	lpfilename as LPCSTR
end type

type PMCI_LOAD_PARMSA as MCI_LOAD_PARMSA ptr
type LPMCI_LOAD_PARMSA as MCI_LOAD_PARMSA ptr

#else ''UNICODE
type MCI_LOAD_PARMSW field=1
	dwCallback as DWORD
	lpfilename as LPCWSTR
end type

type PMCI_LOAD_PARMSW as MCI_LOAD_PARMSW ptr
type LPMCI_LOAD_PARMSW as MCI_LOAD_PARMSW ptr
#endif ''UNICODE

type MCI_RECORD_PARMS field=1
	dwCallback as DWORD
	dwFrom as DWORD
	dwTo as DWORD
end type

type LPMCI_RECORD_PARMS as MCI_RECORD_PARMS ptr

type MCI_VD_PLAY_PARMS field=1
	dwCallback as DWORD
	dwFrom as DWORD
	dwTo as DWORD
	dwSpeed as DWORD
end type

type PMCI_VD_PLAY_PARMS as MCI_VD_PLAY_PARMS ptr
type LPMCI_VD_PLAY_PARMS as MCI_VD_PLAY_PARMS ptr

type MCI_VD_STEP_PARMS field=1
	dwCallback as DWORD
	dwFrames as DWORD
end type

type PMCI_VD_STEP_PARMS as MCI_VD_STEP_PARMS ptr
type LPMCI_VD_STEP_PARMS as MCI_VD_STEP_PARMS ptr

#ifndef UNICODE
type MCI_VD_ESCAPE_PARMSA field=1
	dwCallback as DWORD
	lpstrCommand as LPCSTR
end type

type PMCI_VD_ESCAPE_PARMSA as MCI_VD_ESCAPE_PARMSA ptr
type LPMCI_VD_ESCAPE_PARMSA as MCI_VD_ESCAPE_PARMSA ptr

#else ''UNICODE
type MCI_VD_ESCAPE_PARMSW field=1
	dwCallback as DWORD
	lpstrCommand as LPCWSTR
end type

type PMCI_VD_ESCAPE_PARMSW as MCI_VD_ESCAPE_PARMSW ptr
type LPMCI_VD_ESCAPE_PARMSW as MCI_VD_ESCAPE_PARMSW ptr
#endif ''UNICODE

#ifndef UNICODE
type MCI_WAVE_OPEN_PARMSA field=1
	dwCallback as DWORD
	wDeviceID as MCIDEVICEID
	lpstrDeviceType as LPCSTR
	lpstrElementName as LPCSTR
	lpstrAlias as LPCSTR
	dwBufferSeconds as DWORD
end type

type PMCI_WAVE_OPEN_PARMSA as MCI_WAVE_OPEN_PARMSA ptr
type LPMCI_WAVE_OPEN_PARMSA as MCI_WAVE_OPEN_PARMSA ptr

#else ''UNICODE
type MCI_WAVE_OPEN_PARMSW field=1
	dwCallback as DWORD
	wDeviceID as MCIDEVICEID
	lpstrDeviceType as LPCWSTR
	lpstrElementName as LPCWSTR
	lpstrAlias as LPCWSTR
	dwBufferSeconds as DWORD
end type

type PMCI_WAVE_OPEN_PARMSW as MCI_WAVE_OPEN_PARMSW ptr
type LPMCI_WAVE_OPEN_PARMSW as MCI_WAVE_OPEN_PARMSW ptr
#endif ''UNICODE

type MCI_WAVE_DELETE_PARMS field=1
	dwCallback as DWORD
	dwFrom as DWORD
	dwTo as DWORD
end type

type PMCI_WAVE_DELETE_PARMS as MCI_WAVE_DELETE_PARMS ptr
type LPMCI_WAVE_DELETE_PARMS as MCI_WAVE_DELETE_PARMS ptr

type MCI_WAVE_SET_PARMS field=1
	dwCallback as DWORD
	dwTimeFormat as DWORD
	dwAudio as DWORD
	wInput as UINT
	wOutput as UINT
	wFormatTag as WORD
	wReserved2 as WORD
	nChannels as WORD
	wReserved3 as WORD
	nSamplesPerSec as DWORD
	nAvgBytesPerSec as DWORD
	nBlockAlign as WORD
	wReserved4 as WORD
	wBitsPerSample as WORD
	wReserved5 as WORD
end type

type PMCI_WAVE_SET_PARMS as MCI_WAVE_SET_PARMS ptr
type LPMCI_WAVE_SET_PARMS as MCI_WAVE_SET_PARMS ptr

extern "windows" lib "winmm"

declare function CloseDriver (byval as HDRVR, byval as LONG, byval as LONG) as LRESULT
declare function OpenDriver (byval as LPCWSTR, byval as LPCWSTR, byval as LONG) as HDRVR
declare function SendDriverMessage (byval as HDRVR, byval as UINT, byval as LONG, byval as LONG) as LRESULT
declare function DrvGetModuleHandle (byval as HDRVR) as HMODULE
declare function GetDriverModuleHandle (byval as HDRVR) as HMODULE
declare function DefDriverProc (byval as DWORD, byval as HDRVR, byval as UINT, byval as LPARAM, byval as LPARAM) as LRESULT
declare function mmsystemGetVersion () as UINT
declare function waveOutGetNumDevs () as UINT
declare function waveOutGetVolume (byval as HWAVEOUT, byval as PDWORD) as MMRESULT
declare function waveOutSetVolume (byval as HWAVEOUT, byval as DWORD) as MMRESULT
declare function waveOutOpen (byval as LPHWAVEOUT, byval as UINT, byval as LPCWAVEFORMATEX, byval as DWORD, byval as DWORD, byval as DWORD) as MMRESULT
declare function waveOutClose (byval as HWAVEOUT) as MMRESULT
declare function waveOutPrepareHeader (byval as HWAVEOUT, byval as LPWAVEHDR, byval as UINT) as MMRESULT
declare function waveOutUnprepareHeader (byval as HWAVEOUT, byval as LPWAVEHDR, byval as UINT) as MMRESULT
declare function waveOutWrite (byval as HWAVEOUT, byval as LPWAVEHDR, byval as UINT) as MMRESULT
declare function waveOutPause (byval as HWAVEOUT) as MMRESULT
declare function waveOutRestart (byval as HWAVEOUT) as MMRESULT
declare function waveOutReset (byval as HWAVEOUT) as MMRESULT
declare function waveOutBreakLoop (byval as HWAVEOUT) as MMRESULT
declare function waveOutGetPosition (byval as HWAVEOUT, byval as LPMMTIME, byval as UINT) as MMRESULT
declare function waveOutGetPitch (byval as HWAVEOUT, byval as PDWORD) as MMRESULT
declare function waveOutSetPitch (byval as HWAVEOUT, byval as DWORD) as MMRESULT
declare function waveOutGetPlaybackRate (byval as HWAVEOUT, byval as PDWORD) as MMRESULT
declare function waveOutSetPlaybackRate (byval as HWAVEOUT, byval as DWORD) as MMRESULT
declare function waveOutGetID (byval as HWAVEOUT, byval as LPUINT) as MMRESULT
declare function waveOutMessage (byval as HWAVEOUT, byval as UINT, byval as DWORD, byval as DWORD) as MMRESULT
declare function waveInGetNumDevs () as UINT
declare function waveInOpen (byval as LPHWAVEIN, byval as UINT, byval as LPCWAVEFORMATEX, byval as DWORD, byval as DWORD, byval as DWORD) as MMRESULT
declare function waveInClose (byval as HWAVEIN) as MMRESULT
declare function waveInPrepareHeader (byval as HWAVEIN, byval as LPWAVEHDR, byval as UINT) as MMRESULT
declare function waveInUnprepareHeader (byval as HWAVEIN, byval as LPWAVEHDR, byval as UINT) as MMRESULT
declare function waveInAddBuffer (byval as HWAVEIN, byval as LPWAVEHDR, byval as UINT) as MMRESULT
declare function waveInStart (byval as HWAVEIN) as MMRESULT
declare function waveInStop (byval as HWAVEIN) as MMRESULT
declare function waveInReset (byval as HWAVEIN) as MMRESULT
declare function waveInGetPosition (byval as HWAVEIN, byval as LPMMTIME, byval as UINT) as MMRESULT
declare function waveInGetID (byval as HWAVEIN, byval as LPUINT) as MMRESULT
declare function waveInMessage (byval as HWAVEIN, byval as UINT, byval as DWORD, byval as DWORD) as MMRESULT
declare function midiOutGetNumDevs () as UINT
declare function midiStreamOpen (byval as LPHMIDISTRM, byval as LPUINT, byval as DWORD, byval as DWORD, byval as DWORD, byval as DWORD) as MMRESULT
declare function midiStreamClose (byval as HMIDISTRM) as MMRESULT
declare function midiStreamProperty (byval as HMIDISTRM, byval as LPBYTE, byval as DWORD) as MMRESULT
declare function midiStreamPosition (byval as HMIDISTRM, byval as LPMMTIME, byval as UINT) as MMRESULT
declare function midiStreamOut (byval as HMIDISTRM, byval as LPMIDIHDR, byval as UINT) as MMRESULT
declare function midiStreamPause (byval as HMIDISTRM) as MMRESULT
declare function midiStreamRestart (byval as HMIDISTRM) as MMRESULT
declare function midiStreamStop (byval as HMIDISTRM) as MMRESULT
declare function midiConnect (byval as HMIDI, byval as HMIDIOUT, byval as PVOID) as MMRESULT
declare function midiDisconnect (byval as HMIDI, byval as HMIDIOUT, byval as PVOID) as MMRESULT
declare function midiOutGetVolume (byval as HMIDIOUT, byval as PDWORD) as MMRESULT
declare function midiOutSetVolume (byval as HMIDIOUT, byval as DWORD) as MMRESULT
declare function midiOutOpen (byval as LPHMIDIOUT, byval as UINT, byval as DWORD, byval as DWORD, byval as DWORD) as MMRESULT
declare function midiOutClose (byval as HMIDIOUT) as MMRESULT
declare function midiOutPrepareHeader (byval as HMIDIOUT, byval as LPMIDIHDR, byval as UINT) as MMRESULT
declare function midiOutUnprepareHeader (byval as HMIDIOUT, byval as LPMIDIHDR, byval as UINT) as MMRESULT
declare function midiOutShortMsg (byval as HMIDIOUT, byval as DWORD) as MMRESULT
declare function midiOutLongMsg (byval as HMIDIOUT, byval as LPMIDIHDR, byval as UINT) as MMRESULT
declare function midiOutReset (byval as HMIDIOUT) as MMRESULT
declare function midiOutCachePatches (byval as HMIDIOUT, byval as UINT, byval as LPWORD, byval as UINT) as MMRESULT
declare function midiOutCacheDrumPatches (byval as HMIDIOUT, byval as UINT, byval as LPWORD, byval as UINT) as MMRESULT
declare function midiOutGetID (byval as HMIDIOUT, byval as LPUINT) as MMRESULT
declare function midiOutMessage (byval as HMIDIOUT, byval as UINT, byval as DWORD, byval as DWORD) as MMRESULT
declare function midiInGetNumDevs () as UINT
declare function midiInOpen (byval as LPHMIDIIN, byval as UINT, byval as DWORD, byval as DWORD, byval as DWORD) as MMRESULT
declare function midiInClose (byval as HMIDIIN) as MMRESULT
declare function midiInPrepareHeader (byval as HMIDIIN, byval as LPMIDIHDR, byval as UINT) as MMRESULT
declare function midiInUnprepareHeader (byval as HMIDIIN, byval as LPMIDIHDR, byval as UINT) as MMRESULT
declare function midiInAddBuffer (byval as HMIDIIN, byval as LPMIDIHDR, byval as UINT) as MMRESULT
declare function midiInStart (byval as HMIDIIN) as MMRESULT
declare function midiInStop (byval as HMIDIIN) as MMRESULT
declare function midiInReset (byval as HMIDIIN) as MMRESULT
declare function midiInGetID (byval as HMIDIIN, byval as LPUINT) as MMRESULT
declare function midiInMessage (byval as HMIDIIN, byval as UINT, byval as DWORD, byval as DWORD) as MMRESULT
declare function auxGetNumDevs () as UINT
declare function auxSetVolume (byval as UINT, byval as DWORD) as MMRESULT
declare function auxGetVolume (byval as UINT, byval as PDWORD) as MMRESULT
declare function auxOutMessage (byval as UINT, byval as UINT, byval as DWORD, byval as DWORD) as MMRESULT
declare function mixerGetNumDevs () as UINT
declare function mixerOpen (byval as LPHMIXER, byval as UINT, byval as DWORD, byval as DWORD, byval as DWORD) as MMRESULT
declare function mixerClose (byval as HMIXER) as MMRESULT
declare function mixerMessage (byval as HMIXER, byval as UINT, byval as DWORD, byval as DWORD) as DWORD
declare function mixerGetID (byval as HMIXEROBJ, byval as PUINT, byval as DWORD) as MMRESULT
declare function mixerSetControlDetails (byval as HMIXEROBJ, byval as LPMIXERCONTROLDETAILS, byval as DWORD) as MMRESULT
declare function timeGetSystemTime (byval as LPMMTIME, byval as UINT) as MMRESULT
declare function timeGetTime () as DWORD
declare function timeSetEvent (byval as UINT, byval as UINT, byval as LPTIMECALLBACK, byval as DWORD, byval as UINT) as MMRESULT
declare function timeKillEvent (byval as UINT) as MMRESULT
declare function timeGetDevCaps (byval as LPTIMECAPS, byval as UINT) as MMRESULT
declare function timeBeginPeriod (byval as UINT) as MMRESULT
declare function timeEndPeriod (byval as UINT) as MMRESULT
declare function joyGetNumDevs () as UINT
declare function joyGetPos (byval as UINT, byval as LPJOYINFO) as MMRESULT
declare function joyGetPosEx (byval as UINT, byval as LPJOYINFOEX) as MMRESULT
declare function joyGetThreshold (byval as UINT, byval as LPUINT) as MMRESULT
declare function joyReleaseCapture (byval as UINT) as MMRESULT
declare function joySetCapture (byval as HWND, byval as UINT, byval as UINT, byval as BOOL) as MMRESULT
declare function joySetThreshold (byval as UINT, byval as UINT) as MMRESULT
declare function mmioClose (byval as HMMIO, byval as UINT) as MMRESULT
declare function mmioRead (byval as HMMIO, byval as HPSTR, byval as LONG) as LONG
declare function mmioWrite (byval as HMMIO, byval as LPCSTR, byval as LONG) as LONG
declare function mmioSeek (byval as HMMIO, byval as LONG, byval as integer) as LONG
declare function mmioGetInfo (byval as HMMIO, byval as LPMMIOINFO, byval as UINT) as MMRESULT
declare function mmioSetInfo (byval as HMMIO, byval as LPCMMIOINFO, byval as UINT) as MMRESULT
declare function mmioSetBuffer (byval as HMMIO, byval as LPSTR, byval as LONG, byval as UINT) as MMRESULT
declare function mmioFlush (byval as HMMIO, byval as UINT) as MMRESULT
declare function mmioAdvance (byval as HMMIO, byval as LPMMIOINFO, byval as UINT) as MMRESULT
declare function mmioSendMessage (byval as HMMIO, byval as UINT, byval as LPARAM, byval as LPARAM) as LRESULT
declare function mmioDescend (byval as HMMIO, byval as LPMMCKINFO, byval as MMCKINFO ptr, byval as UINT) as MMRESULT
declare function mmioAscend (byval as HMMIO, byval as LPMMCKINFO, byval as UINT) as MMRESULT
declare function mmioCreateChunk (byval as HMMIO, byval as LPMMCKINFO, byval as UINT) as MMRESULT
declare function mciSetYieldProc (byval as MCIDEVICEID, byval as YIELDPROC, byval as DWORD) as BOOL
declare function mciGetCreatorTask (byval as MCIDEVICEID) as HTASK
declare function mciGetYieldProc (byval as MCIDEVICEID, byval as PDWORD) as YIELDPROC

#ifdef UNICODE
declare function sndPlaySound alias "sndPlaySoundW" (byval as LPCWSTR, byval as UINT) as BOOL
declare function PlaySound alias "PlaySoundW" (byval as LPCWSTR, byval as HMODULE, byval as DWORD) as BOOL
declare function waveOutGetDevCaps alias "waveOutGetDevCapsW" (byval as UINT, byval as LPWAVEOUTCAPSW, byval as UINT) as MMRESULT
declare function waveOutGetErrorText alias "waveOutGetErrorTextW" (byval as MMRESULT, byval as LPWSTR, byval as UINT) as MMRESULT
declare function waveInGetDevCaps alias "waveInGetDevCapsW" (byval as UINT, byval as LPWAVEINCAPSW, byval as UINT) as MMRESULT
declare function waveInGetErrorText alias "waveInGetErrorTextW" (byval as MMRESULT, byval as LPWSTR, byval as UINT) as MMRESULT
declare function midiOutGetDevCaps alias "midiOutGetDevCapsW" (byval as UINT, byval as LPMIDIOUTCAPSW, byval as UINT) as MMRESULT
declare function midiOutGetErrorText alias "midiOutGetErrorTextW" (byval as MMRESULT, byval as LPWSTR, byval as UINT) as MMRESULT
declare function midiInGetDevCaps alias "midiInGetDevCapsW" (byval as UINT, byval as LPMIDIINCAPSW, byval as UINT) as MMRESULT
declare function midiInGetErrorText alias "midiInGetErrorTextW" (byval as MMRESULT, byval as LPWSTR, byval as UINT) as MMRESULT
declare function auxGetDevCaps alias "auxGetDevCapsW" (byval as UINT, byval as LPAUXCAPSW, byval as UINT) as MMRESULT
declare function mixerGetDevCaps alias "mixerGetDevCapsW" (byval as UINT, byval as LPMIXERCAPSW, byval as UINT) as MMRESULT
declare function mixerGetLineInfo alias "mixerGetLineInfoW" (byval as HMIXEROBJ, byval as LPMIXERLINEW, byval as DWORD) as MMRESULT
declare function mixerGetLineControls alias "mixerGetLineControlsW" (byval as HMIXEROBJ, byval as LPMIXERLINECONTROLSW, byval as DWORD) as MMRESULT
declare function mixerGetControlDetails alias "mixerGetControlDetailsW" (byval as HMIXEROBJ, byval as LPMIXERCONTROLDETAILS, byval as DWORD) as MMRESULT
declare function joyGetDevCaps alias "joyGetDevCapsW" (byval as UINT, byval as LPJOYCAPSW, byval as UINT) as MMRESULT
declare function mmioStringToFOURCC alias "mmioStringToFOURCCW" (byval as LPCWSTR, byval as UINT) as FOURCC
declare function mmioInstallIOProc alias "mmioInstallIOProcW" (byval as FOURCC, byval as LPMMIOPROC, byval as DWORD) as LPMMIOPROC
declare function mmioOpen alias "mmioOpenW" (byval as LPWSTR, byval as LPMMIOINFO, byval as DWORD) as HMMIO
declare function mmioRename alias "mmioRenameW" (byval as LPCWSTR, byval as LPCWSTR, byval as LPCMMIOINFO, byval as DWORD) as MMRESULT
declare function mciSendCommand alias "mciSendCommandW" (byval as MCIDEVICEID, byval as UINT, byval as DWORD, byval as DWORD) as MCIERROR
declare function mciSendString alias "mciSendStringW" (byval as LPCWSTR, byval as LPWSTR, byval as UINT, byval as HWND) as MCIERROR
declare function mciGetDeviceID alias "mciGetDeviceIDW" (byval as LPCWSTR) as MCIDEVICEID
declare function mciGetDeviceIDFromElementID alias "mciGetDeviceIDFromElementIDW" (byval as DWORD, byval as LPCWSTR) as MCIDEVICEID
declare function mciGetErrorString alias "mciGetErrorStringW" (byval as MCIERROR, byval as LPWSTR, byval as UINT) as BOOL

#else ''UNICODE
declare function sndPlaySound alias "sndPlaySoundA" (byval as LPCSTR, byval as UINT) as BOOL
declare function PlaySound alias "PlaySoundA" (byval as LPCSTR, byval as HMODULE, byval as DWORD) as BOOL
declare function waveOutGetDevCaps alias "waveOutGetDevCapsA" (byval as UINT, byval as LPWAVEOUTCAPSA, byval as UINT) as MMRESULT
declare function waveOutGetErrorText alias "waveOutGetErrorTextA" (byval as MMRESULT, byval as LPSTR, byval as UINT) as MMRESULT
declare function waveInGetDevCaps alias "waveInGetDevCapsA" (byval as UINT, byval as LPWAVEINCAPSA, byval as UINT) as MMRESULT
declare function waveInGetErrorText alias "waveInGetErrorTextA" (byval as MMRESULT, byval as LPSTR, byval as UINT) as MMRESULT
declare function midiOutGetDevCaps alias "midiOutGetDevCapsA" (byval as UINT, byval as LPMIDIOUTCAPSA, byval as UINT) as MMRESULT
declare function midiOutGetErrorText alias "midiOutGetErrorTextA" (byval as MMRESULT, byval as LPSTR, byval as UINT) as MMRESULT
declare function midiInGetDevCaps alias "midiInGetDevCapsA" (byval as UINT, byval as LPMIDIINCAPSA, byval as UINT) as MMRESULT
declare function midiInGetErrorText alias "midiInGetErrorTextA" (byval as MMRESULT, byval as LPSTR, byval as UINT) as MMRESULT
declare function auxGetDevCaps alias "auxGetDevCapsA" (byval as UINT, byval as LPAUXCAPSA, byval as UINT) as MMRESULT
declare function mixerGetDevCaps alias "mixerGetDevCapsA" (byval as UINT, byval as LPMIXERCAPSA, byval as UINT) as MMRESULT
declare function mixerGetLineInfo alias "mixerGetLineInfoA" (byval as HMIXEROBJ, byval as LPMIXERLINEA, byval as DWORD) as MMRESULT
declare function mixerGetLineControls alias "mixerGetLineControlsA" (byval as HMIXEROBJ, byval as LPMIXERLINECONTROLSA, byval as DWORD) as MMRESULT
declare function mixerGetControlDetails alias "mixerGetControlDetailsA" (byval as HMIXEROBJ, byval as LPMIXERCONTROLDETAILS, byval as DWORD) as MMRESULT
declare function joyGetDevCaps alias "joyGetDevCapsA" (byval as UINT, byval as LPJOYCAPSA, byval as UINT) as MMRESULT
declare function mmioStringToFOURCC alias "mmioStringToFOURCCA" (byval as LPCSTR, byval as UINT) as FOURCC
declare function mmioInstallIOProc alias "mmioInstallIOProcA" (byval as FOURCC, byval as LPMMIOPROC, byval as DWORD) as LPMMIOPROC
declare function mmioOpen alias "mmioOpenA" (byval as LPSTR, byval as LPMMIOINFO, byval as DWORD) as HMMIO
declare function mmioRename alias "mmioRenameA" (byval as LPCSTR, byval as LPCSTR, byval as LPCMMIOINFO, byval as DWORD) as MMRESULT
declare function mciSendCommand alias "mciSendCommandA" (byval as MCIDEVICEID, byval as UINT, byval as DWORD, byval as DWORD) as MCIERROR
declare function mciSendString alias "mciSendStringA" (byval as LPCSTR, byval as LPSTR, byval as UINT, byval as HWND) as MCIERROR
declare function mciGetDeviceID alias "mciGetDeviceIDA" (byval as LPCSTR) as MCIDEVICEID
declare function mciGetDeviceIDFromElementID alias "mciGetDeviceIDFromElementIDA" (byval as DWORD, byval as LPCSTR) as MCIDEVICEID
declare function mciGetErrorString alias "mciGetErrorStringA" (byval as MCIERROR, byval as LPSTR, byval as UINT) as BOOL

#endif ''UNICODE

end extern

type MCI_SEQ_SET_PARMS field=1
	dwCallback as DWORD
	dwTimeFormat as DWORD
	dwAudio as DWORD
	dwTempo as DWORD
	dwPort as DWORD
	dwSlave as DWORD
	dwMaster as DWORD
	dwOffset as DWORD
end type

type PMCI_SEQ_SET_PARMS as MCI_SEQ_SET_PARMS ptr
type LPMCI_SEQ_SET_PARMS as MCI_SEQ_SET_PARMS ptr

#ifndef UNICODE
type MCI_ANIM_OPEN_PARMSA field=1
	dwCallback as DWORD
	wDeviceID as MCIDEVICEID
	lpstrDeviceType as LPCSTR
	lpstrElementName as LPCSTR
	lpstrAlias as LPCSTR
	dwStyle as DWORD
	hWndParent as HWND
end type

type PMCI_ANIM_OPEN_PARMSA as MCI_ANIM_OPEN_PARMSA ptr
type LPMCI_ANIM_OPEN_PARMSA as MCI_ANIM_OPEN_PARMSA ptr

#else ''UNICODE
type MCI_ANIM_OPEN_PARMSW field=1
	dwCallback as DWORD
	wDeviceID as MCIDEVICEID
	lpstrDeviceType as LPCWSTR
	lpstrElementName as LPCWSTR
	lpstrAlias as LPCWSTR
	dwStyle as DWORD
	hWndParent as HWND
end type

type PMCI_ANIM_OPEN_PARMSW as MCI_ANIM_OPEN_PARMSW ptr
type LPMCI_ANIM_OPEN_PARMSW as MCI_ANIM_OPEN_PARMSW ptr
#endif ''UNICODE

type MCI_ANIM_PLAY_PARMS field=1
	dwCallback as DWORD
	dwFrom as DWORD
	dwTo as DWORD
	dwSpeed as DWORD
end type

type PMCI_ANIM_PLAY_PARMS as MCI_ANIM_PLAY_PARMS ptr
type LPMCI_ANIM_PLAY_PARMS as MCI_ANIM_PLAY_PARMS ptr

type MCI_ANIM_STEP_PARMS field=1
	dwCallback as DWORD
	dwFrames as DWORD
end type

type PMCI_ANIM_STEP_PARMS as MCI_ANIM_STEP_PARMS ptr
type LPMCI_ANIM_STEP_PARMS as MCI_ANIM_STEP_PARMS ptr

#ifndef UNICODE
type MCI_ANIM_WINDOW_PARMSA field=1
	dwCallback as DWORD
	hWnd as HWND
	nCmdShow as UINT
	lpstrText as LPCSTR
end type

type PMCI_ANIM_WINDOW_PARMSA as MCI_ANIM_WINDOW_PARMSA ptr
type LPMCI_ANIM_WINDOW_PARMSA as MCI_ANIM_WINDOW_PARMSA ptr

#else ''UNICODE
type MCI_ANIM_WINDOW_PARMSW field=1
	dwCallback as DWORD
	hWnd as HWND
	nCmdShow as UINT
	lpstrText as LPCWSTR
end type

type PMCI_ANIM_WINDOW_PARMSW as MCI_ANIM_WINDOW_PARMSW ptr
type LPMCI_ANIM_WINDOW_PARMSW as MCI_ANIM_WINDOW_PARMSW ptr
#endif ''UNICODE

type MCI_ANIM_RECT_PARMS field=1
	dwCallback as DWORD
	rc as RECT
end type

type PMCI_ANIM_RECT_PARMS as MCI_ANIM_RECT_PARMS ptr
type LPMCI_ANIM_RECT_PARMS as MCI_ANIM_RECT_PARMS ptr

type MCI_ANIM_UPDATE_PARMS field=1
	dwCallback as DWORD
	rc as RECT
	hDC as HDC
end type

type PMCI_ANIM_UPDATE_PARMS as MCI_ANIM_UPDATE_PARMS ptr
type LPMCI_ANIM_UPDATE_PARMS as MCI_ANIM_UPDATE_PARMS ptr

#ifndef UNICODE
type MCI_OVLY_OPEN_PARMSA field=1
	dwCallback as DWORD
	wDeviceID as MCIDEVICEID
	lpstrDeviceType as LPCSTR
	lpstrElementName as LPCSTR
	lpstrAlias as LPCSTR
	dwStyle as DWORD
	hWndParent as HWND
end type

type PMCI_OVLY_OPEN_PARMSA as MCI_OVLY_OPEN_PARMSA ptr
type LPMCI_OVLY_OPEN_PARMSA as MCI_OVLY_OPEN_PARMSA ptr

#else ''UNICODE
type MCI_OVLY_OPEN_PARMSW field=1
	dwCallback as DWORD
	wDeviceID as MCIDEVICEID
	lpstrDeviceType as LPCWSTR
	lpstrElementName as LPCWSTR
	lpstrAlias as LPCWSTR
	dwStyle as DWORD
	hWndParent as HWND
end type

type PMCI_OVLY_OPEN_PARMSW as MCI_OVLY_OPEN_PARMSW ptr
type LPMCI_OVLY_OPEN_PARMSW as MCI_OVLY_OPEN_PARMSW ptr
#endif ''UNICODE

#ifndef UNICODE
type MCI_OVLY_WINDOW_PARMSA field=1
	dwCallback as DWORD
	hWnd as HWND
	nCmdShow as UINT
	lpstrText as LPCSTR
end type

type PMCI_OVLY_WINDOW_PARMSA as MCI_OVLY_WINDOW_PARMSA ptr
type LPMCI_OVLY_WINDOW_PARMSA as MCI_OVLY_WINDOW_PARMSA ptr

#else ''UNICODE
type MCI_OVLY_WINDOW_PARMSW field=1
	dwCallback as DWORD
	hWnd as HWND
	nCmdShow as UINT
	lpstrText as LPCWSTR
end type

type PMCI_OVLY_WINDOW_PARMSW as MCI_OVLY_WINDOW_PARMSW ptr
type LPMCI_OVLY_WINDOW_PARMSW as MCI_OVLY_WINDOW_PARMSW ptr
#endif ''UNICODE

type MCI_OVLY_RECT_PARMS field=1
	dwCallback as DWORD
	rc as RECT
end type

type PMCI_OVLY_RECT_PARMS as MCI_OVLY_RECT_PARMS ptr
type LPMCI_OVLY_RECT_PARMS as MCI_OVLY_RECT_PARMS ptr

#ifndef UNICODE
type MCI_OVLY_SAVE_PARMSA field=1
	dwCallback as DWORD
	lpfilename as LPCSTR
	rc as RECT
end type

type PMCI_OVLY_SAVE_PARMSA as MCI_OVLY_SAVE_PARMSA ptr
type LPMCI_OVLY_SAVE_PARMSA as MCI_OVLY_SAVE_PARMSA ptr

#else ''UNICODE
type MCI_OVLY_SAVE_PARMSW field=1
	dwCallback as DWORD
	lpfilename as LPCWSTR
	rc as RECT
end type

type PMCI_OVLY_SAVE_PARMSW as MCI_OVLY_SAVE_PARMSW ptr
type LPMCI_OVLY_SAVE_PARMSW as MCI_OVLY_SAVE_PARMSW ptr
#endif ''UNICODE

#ifndef UNICODE
type MCI_OVLY_LOAD_PARMSA field=1
	dwCallback as DWORD
	lpfilename as LPCSTR
	rc as RECT
end type

type PMCI_OVLY_LOAD_PARMSA as MCI_OVLY_LOAD_PARMSA ptr
type LPMCI_OVLY_LOAD_PARMSA as MCI_OVLY_LOAD_PARMSA ptr

#else ''UNICODE
type MCI_OVLY_LOAD_PARMSW field=1
	dwCallback as DWORD
	lpfilename as LPCWSTR
	rc as RECT
end type

type PMCI_OVLY_LOAD_PARMSW as tagMCI_OVLY_LOAD_PARMSW ptr
type LPMCI_OVLY_LOAD_PARMSW as tagMCI_OVLY_LOAD_PARMSW ptr
#endif ''UNICODE

#ifdef UNICODE
type WAVEOUTCAPS as WAVEOUTCAPSW
type PWAVEOUTCAPS as WAVEOUTCAPSW ptr
type LPWAVEOUTCAPS as WAVEOUTCAPSW ptr
type WAVEINCAPS as WAVEINCAPSW
type PWAVEINCAPS as WAVEINCAPSW ptr
type LPWAVEINCAPS as WAVEINCAPSW ptr
type MIDIOUTCAPS as MIDIOUTCAPSW
type PMIDIOUTCAPS as MIDIOUTCAPSW ptr
type LPMIDIOUTCAPS as MIDIOUTCAPSW ptr
type MIDIINCAPS as MIDIINCAPSW
type PMIDIINCAPS as MIDIINCAPSW ptr
type LPMIDIINCAPS as MIDIINCAPSW ptr
type AUXCAPS as AUXCAPSW
type PAUXCAPS as AUXCAPSW ptr
type LPAUXCAPS as AUXCAPSW ptr
type MIXERCAPS as MIXERCAPSW
type PMIXERCAPS as MIXERCAPSW ptr
type LPMIXERCAPS as MIXERCAPSW ptr
type MIXERLINE as MIXERLINEW
type PMIXERLINE as MIXERLINEW ptr
type LPMIXERLINE as MIXERLINEW ptr
type MIXERCONTROL as MIXERCONTROLW
type PMIXERCONTROL as MIXERCONTROLW ptr
type LPMIXERCONTROL as MIXERCONTROLW ptr
type MIXERLINECONTROLS as MIXERLINECONTROLSW
type PMIXERLINECONTROLS as MIXERLINECONTROLSW ptr
type LPMIXERLINECONTROLS as MIXERLINECONTROLSW ptr
type MIXERCONTROLDETAILS_LISTTEXT as MIXERCONTROLDETAILS_LISTTEXTW
type PMIXERCONTROLDETAILS_LISTTEXT as MIXERCONTROLDETAILS_LISTTEXTW ptr
type LPMIXERCONTROLDETAILS_LISTTEXT as MIXERCONTROLDETAILS_LISTTEXTW ptr
type JOYCAPS as JOYCAPSW
type PJOYCAPS as JOYCAPSW ptr
type LPJOYCAPS as JOYCAPSW ptr
type MCI_OPEN_PARMS as MCI_OPEN_PARMSW
type PMCI_OPEN_PARMS as MCI_OPEN_PARMSW ptr
type LPMCI_OPEN_PARMS as MCI_OPEN_PARMSW ptr
type MCI_INFO_PARMS as MCI_INFO_PARMSW
type LPMCI_INFO_PARMS as MCI_INFO_PARMSW ptr
type MCI_SYSINFO_PARMS as MCI_SYSINFO_PARMSW
type PMCI_SYSINFO_PARMS as MCI_SYSINFO_PARMSW ptr
type LPMCI_SYSINFO_PARMS as MCI_SYSINFO_PARMSW ptr
type MCI_SAVE_PARMS as MCI_SAVE_PARMSW
type PMCI_SAVE_PARMS as MCI_SAVE_PARMSW ptr
type LPMCI_SAVE_PARMS as MCI_SAVE_PARMSW ptr
type MCI_LOAD_PARMS as MCI_LOAD_PARMSW
type PMCI_LOAD_PARMS as MCI_LOAD_PARMSW ptr
type LPMCI_LOAD_PARMS as MCI_LOAD_PARMSW ptr
type MCI_VD_ESCAPE_PARMS as MCI_VD_ESCAPE_PARMSW
type PMCI_VD_ESCAPE_PARMS as MCI_VD_ESCAPE_PARMSW ptr
type LPMCI_VD_ESCAPE_PARMS as MCI_VD_ESCAPE_PARMSW ptr
type MCI_WAVE_OPEN_PARMS as MCI_WAVE_OPEN_PARMSW
type PMCI_WAVE_OPEN_PARMS as MCI_WAVE_OPEN_PARMSW ptr
type LPMCI_WAVE_OPEN_PARMS as MCI_WAVE_OPEN_PARMSW ptr
type MCI_ANIM_OPEN_PARMS as MCI_ANIM_OPEN_PARMSW
type PMCI_ANIM_OPEN_PARMS as MCI_ANIM_OPEN_PARMSW ptr
type LPMCI_ANIM_OPEN_PARMS as MCI_ANIM_OPEN_PARMSW ptr
type MCI_ANIM_WINDOW_PARMS as MCI_ANIM_WINDOW_PARMSW
type PMCI_ANIM_WINDOW_PARMS as MCI_ANIM_WINDOW_PARMSW ptr
type LPMCI_ANIM_WINDOW_PARMS as MCI_ANIM_WINDOW_PARMSW ptr
type MCI_OVLY_OPEN_PARMS as MCI_OVLY_OPEN_PARMSW
type PMCI_OVLY_OPEN_PARMS as MCI_OVLY_OPEN_PARMSW ptr
type LPMCI_OVLY_OPEN_PARMS as MCI_OVLY_OPEN_PARMSW ptr
type MCI_OVLY_WINDOW_PARMS as MCI_OVLY_WINDOW_PARMSW
type PMCI_OVLY_WINDOW_PARMS as MCI_OVLY_WINDOW_PARMSW ptr
type LPMCI_OVLY_WINDOW_PARMS as MCI_OVLY_WINDOW_PARMSW ptr
type MCI_OVLY_SAVE_PARMS as MCI_OVLY_SAVE_PARMSW
type PMCI_OVLY_SAVE_PARMS as MCI_OVLY_SAVE_PARMSW ptr
type LPMCI_OVLY_SAVE_PARMS as MCI_OVLY_SAVE_PARMSW ptr

#else ''UNICODE
type WAVEOUTCAPS as WAVEOUTCAPSA
type PWAVEOUTCAPS as WAVEOUTCAPSA ptr
type LPWAVEOUTCAPS as WAVEOUTCAPSA ptr
type WAVEINCAPS as WAVEINCAPSA
type PWAVEINCAPS as WAVEINCAPSA ptr
type LPWAVEINCAPS as WAVEINCAPSA ptr
type MIDIOUTCAPS as MIDIOUTCAPSA
type PMIDIOUTCAPS as MIDIOUTCAPSA ptr
type LPMIDIOUTCAPS as MIDIOUTCAPSA ptr
type MIDIINCAPS as MIDIINCAPSA
type PMIDIINCAPS as MIDIINCAPSA ptr
type LPMIDIINCAPS as MIDIINCAPSA ptr
type AUXCAPS as AUXCAPSA
type PAUXCAPS as AUXCAPSA ptr
type LPAUXCAPS as AUXCAPSA ptr
type MIXERCAPS as MIXERCAPSA
type PMIXERCAPS as MIXERCAPSA ptr
type LPMIXERCAPS as MIXERCAPSA ptr
type MIXERLINE as MIXERLINEA
type PMIXERLINE as MIXERLINEA ptr
type LPMIXERLINE as MIXERLINEA ptr
type MIXERCONTROL as MIXERCONTROLA
type PMIXERCONTROL as MIXERCONTROLA ptr
type LPMIXERCONTROL as MIXERCONTROLA ptr
type MIXERLINECONTROLS as MIXERLINECONTROLSA
type PMIXERLINECONTROLS as MIXERLINECONTROLSA ptr
type LPMIXERLINECONTROLS as MIXERLINECONTROLSA ptr
type MIXERCONTROLDETAILS_LISTTEXT as MIXERCONTROLDETAILS_LISTTEXTA
type PMIXERCONTROLDETAILS_LISTTEXT as MIXERCONTROLDETAILS_LISTTEXTA ptr
type LPMIXERCONTROLDETAILS_LISTTEXT as MIXERCONTROLDETAILS_LISTTEXTA ptr
type JOYCAPS as JOYCAPSA
type PJOYCAPS as JOYCAPSA ptr
type LPJOYCAPS as JOYCAPSA ptr
type MCI_OPEN_PARMS as MCI_OPEN_PARMSA
type PMCI_OPEN_PARMS as MCI_OPEN_PARMSA ptr
type LPMCI_OPEN_PARMS as MCI_OPEN_PARMSA ptr
type MCI_INFO_PARMS as MCI_INFO_PARMSA
type LPMCI_INFO_PARMS as MCI_INFO_PARMSA ptr
type MCI_SYSINFO_PARMS as MCI_SYSINFO_PARMSA
type PMCI_SYSINFO_PARMS as MCI_SYSINFO_PARMSA ptr
type LPMCI_SYSINFO_PARMS as MCI_SYSINFO_PARMSA ptr
type MCI_SAVE_PARMS as MCI_SAVE_PARMSA
type PMCI_SAVE_PARMS as MCI_SAVE_PARMSA ptr
type LPMCI_SAVE_PARMS as MCI_SAVE_PARMSA ptr
type MCI_LOAD_PARMS as MCI_LOAD_PARMSA
type PMCI_LOAD_PARMS as MCI_LOAD_PARMSA ptr
type LPMCI_LOAD_PARMS as MCI_LOAD_PARMSA ptr
type MCI_VD_ESCAPE_PARMS as MCI_VD_ESCAPE_PARMSA
type PMCI_VD_ESCAPE_PARMS as MCI_VD_ESCAPE_PARMSA ptr
type LPMCI_VD_ESCAPE_PARMS as MCI_VD_ESCAPE_PARMSA ptr
type MCI_WAVE_OPEN_PARMS as MCI_WAVE_OPEN_PARMSA
type PMCI_WAVE_OPEN_PARMS as MCI_WAVE_OPEN_PARMSA ptr
type LPMCI_WAVE_OPEN_PARMS as MCI_WAVE_OPEN_PARMSA ptr
type MCI_ANIM_OPEN_PARMS as MCI_ANIM_OPEN_PARMSA
type PMCI_ANIM_OPEN_PARMS as MCI_ANIM_OPEN_PARMSA ptr
type LPMCI_ANIM_OPEN_PARMS as MCI_ANIM_OPEN_PARMSA ptr
type MCI_ANIM_WINDOW_PARMS as MCI_ANIM_WINDOW_PARMSA
type PMCI_ANIM_WINDOW_PARMS as MCI_ANIM_WINDOW_PARMSA ptr
type LPMCI_ANIM_WINDOW_PARMS as MCI_ANIM_WINDOW_PARMSA ptr
type MCI_OVLY_OPEN_PARMS as MCI_OVLY_OPEN_PARMSA
type PMCI_OVLY_OPEN_PARMS as MCI_OVLY_OPEN_PARMSA ptr
type LPMCI_OVLY_OPEN_PARMS as MCI_OVLY_OPEN_PARMSA ptr
type MCI_OVLY_WINDOW_PARMS as MCI_OVLY_WINDOW_PARMSA
type PMCI_OVLY_WINDOW_PARMS as MCI_OVLY_WINDOW_PARMSA ptr
type LPMCI_OVLY_WINDOW_PARMS as MCI_OVLY_WINDOW_PARMSA ptr
type MCI_OVLY_SAVE_PARMS as MCI_OVLY_SAVE_PARMSA
type PMCI_OVLY_SAVE_PARMS as MCI_OVLY_SAVE_PARMSA ptr
type LPMCI_OVLY_SAVE_PARMS as MCI_OVLY_SAVE_PARMSA ptr

#endif ''UNICODE

#endif
