''
''
'' olectl -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __win_olectl_bi__
#define __win_olectl_bi__

#inclib "oleaut32"

#include once "win/ocidl.bi"
#include once "win/olectlid.bi"

#define STD_CTL_SCODE(n) MAKE_SCODE(SEVERITY_ERROR,FACILITY_CONTROL,n)
#define CTL_E_ILLEGALFUNCTIONCALL STD_CTL_SCODE(5)
#define CTL_E_OVERFLOW STD_CTL_SCODE(6)
#define CTL_E_OUTOFMEMORY STD_CTL_SCODE(7)
#define CTL_E_DIVISIONBYZERO STD_CTL_SCODE(11)
#define CTL_E_OUTOFSTRINGSPACE STD_CTL_SCODE(14)
#define CTL_E_OUTOFSTACKSPACE STD_CTL_SCODE(28)
#define CTL_E_BADFILENAMEORNUMBER STD_CTL_SCODE(52)
#define CTL_E_FILENOTFOUND STD_CTL_SCODE(53)
#define CTL_E_BADFILEMODE STD_CTL_SCODE(54)
#define CTL_E_FILEALREADYOPEN STD_CTL_SCODE(55)
#define CTL_E_DEVICEIOERROR STD_CTL_SCODE(57)
#define CTL_E_FILEALREADYEXISTS STD_CTL_SCODE(58)
#define CTL_E_BADRECORDLENGTH STD_CTL_SCODE(59)
#define CTL_E_DISKFULL STD_CTL_SCODE(61)
#define CTL_E_BADRECORDNUMBER STD_CTL_SCODE(63)
#define CTL_E_BADFILENAME STD_CTL_SCODE(64)
#define CTL_E_TOOMANYFILES STD_CTL_SCODE(67)
#define CTL_E_DEVICEUNAVAILABLE STD_CTL_SCODE(68)
#define CTL_E_PERMISSIONDENIED STD_CTL_SCODE(70)
#define CTL_E_DISKNOTREADY STD_CTL_SCODE(71)
#define CTL_E_PATHFILEACCESSERROR STD_CTL_SCODE(75)
#define CTL_E_PATHNOTFOUND STD_CTL_SCODE(76)
#define CTL_E_INVALIDPATTERNSTRING STD_CTL_SCODE(93)
#define CTL_E_INVALIDUSEOFNULL STD_CTL_SCODE(94)
#define CTL_E_INVALIDFILEFORMAT STD_CTL_SCODE(321)
#define CTL_E_INVALIDPROPERTYVALUE STD_CTL_SCODE(380)
#define CTL_E_INVALIDPROPERTYARRAYINDEX STD_CTL_SCODE(381)
#define CTL_E_SETNOTSUPPORTEDATRUNTIME STD_CTL_SCODE(382)
#define CTL_E_SETNOTSUPPORTED STD_CTL_SCODE(383)
#define CTL_E_NEEDPROPERTYARRAYINDEX STD_CTL_SCODE(385)
#define CTL_E_SETNOTPERMITTED STD_CTL_SCODE(387)
#define CTL_E_GETNOTSUPPORTEDATRUNTIME STD_CTL_SCODE(393)
#define CTL_E_GETNOTSUPPORTED STD_CTL_SCODE(394)
#define CTL_E_PROPERTYNOTFOUND STD_CTL_SCODE(422)
#define CTL_E_INVALIDCLIPBOARDFORMAT STD_CTL_SCODE(460)
#define CTL_E_INVALIDPICTURE STD_CTL_SCODE(481)
#define CTL_E_PRINTERERROR STD_CTL_SCODE(482)
#define CTL_E_CANTSAVEFILETOTEMP STD_CTL_SCODE(735)
#define CTL_E_SEARCHTEXTNOTFOUND STD_CTL_SCODE(744)
#define CTL_E_REPLACEMENTSTOOLONG STD_CTL_SCODE(746)
#define CUSTOM_CTL_SCODE(n) MAKE_SCODE(SEVERITY_ERROR,FACILITY_CONTROL,n)
#define CTL_E_CUSTOM_FIRST CUSTOM_CTL_SCODE(600)
#define CLASS_E_NOTLICENSED (CLASSFACTORY_E_FIRST+2)
#define CONNECT_E_FIRST MAKE_SCODE(SEVERITY_ERROR,FACILITY_ITF,&h200)
#define CONNECT_E_LAST MAKE_SCODE(SEVERITY_ERROR,FACILITY_ITF,&h20F)
#define CONNECT_S_FIRST MAKE_SCODE(SEVERITY_SUCCESS,FACILITY_ITF,&h200)
#define CONNECT_S_LAST MAKE_SCODE(SEVERITY_SUCCESS,FACILITY_ITF,&h20F)
#define CONNECT_E_NOCONNECTION (CONNECT_E_FIRST+0)
#define CONNECT_E_ADVISELIMIT (CONNECT_E_FIRST+1)
#define CONNECT_E_CANNOTCONNECT (CONNECT_E_FIRST+2)
#define CONNECT_E_OVERRIDDEN (CONNECT_E_FIRST+3)
#define SELFREG_E_FIRST MAKE_SCODE(SEVERITY_ERROR,FACILITY_ITF,&h200)
#define SELFREG_E_LAST MAKE_SCODE(SEVERITY_ERROR,FACILITY_ITF,&h20F)
#define SELFREG_S_FIRST MAKE_SCODE(SEVERITY_SUCCESS,FACILITY_ITF,&h200)
#define SELFREG_S_LAST MAKE_SCODE(SEVERITY_SUCCESS,FACILITY_ITF,&h20F)
#define SELFREG_E_TYPELIB (SELFREG_E_FIRST+0)
#define SELFREG_E_CLASS (SELFREG_E_FIRST+1)
#define PERPROP_E_FIRST MAKE_SCODE(SEVERITY_ERROR,FACILITY_ITF,&h200)
#define PERPROP_E_LAST MAKE_SCODE(SEVERITY_ERROR,FACILITY_ITF,&h20F)
#define PERPROP_S_FIRST MAKE_SCODE(SEVERITY_SUCCESS,FACILITY_ITF,&h200)
#define PERPROP_S_LAST MAKE_SCODE(SEVERITY_SUCCESS,FACILITY_ITF,&h20F)
#define PERPROP_E_NOPAGEAVAILABLE PERPROP_E_FIRST
#define OLEMISC_RECOMPOSEONRESIZE &h1
#define OLEMISC_ONLYICONIC &h2
#define OLEMISC_INSERTNOTREPLACE &h4
#define OLEMISC_STATIC &h8
#define OLEMISC_CANTLINKINSIDE &h10
#define OLEMISC_CANLINKBYOLE1 &h20
#define OLEMISC_ISLINKOBJECT &h40
#define OLEMISC_INSIDEOUT &h80
#define OLEMISC_ACTIVATEWHENVISIBLE &h100
#define OLEMISC_RENDERINGISDEVICEINDEPENDENT &h200
#define OLEMISC_INVISIBLEATRUNTIME &h400
#define OLEMISC_ALWAYSRUN &h800
#define OLEMISC_ACTSLIKEBUTTON &h1000
#define OLEMISC_ACTSLIKELABEL &h2000
#define OLEMISC_NOUIACTIVATE &h4000
#define OLEMISC_ALIGNABLE &h8000
#define OLEMISC_SIMPLEFRAME &h10000
#define OLEMISC_SETCLIENTSITEFIRST &h20000
#define OLEMISC_IMEMODE &h40000
#define OLEMISC_IGNOREACTIVATEWHENVISIBLE &h80000
#define OLEMISC_WANTSTOMENUMERGE &h100000
#define OLEMISC_SUPPORTSMULTILEVELUNDO &h200000
#define OLEIVERB_PROPERTIES (-7)
#define VT_STREAMED_PROPSET 73
#define VT_STORED_PROPSET 74
#define VT_BLOB_PROPSET 75
#define VT_VERBOSE_ENUM 76
#define OCM__BASE (1024+&h1c00)
#define OCM_COMMAND ((1024+&h1c00) +273)
#define OCM_CTLCOLORBTN ((1024+&h1c00) +309)
#define OCM_CTLCOLOREDIT ((1024+&h1c00) +307)
#define OCM_CTLCOLORDLG ((1024+&h1c00) +310)
#define OCM_CTLCOLORLISTBOX ((1024+&h1c00) +308)
#define OCM_CTLCOLORMSGBOX ((1024+&h1c00) +306)
#define OCM_CTLCOLORSCROLLBAR ((1024+&h1c00) +311)
#define OCM_CTLCOLORSTATIC ((1024+&h1c00) +312)
#define OCM_DRAWITEM ((1024+&h1c00) +43)
#define OCM_MEASUREITEM ((1024+&h1c00) +44)
#define OCM_DELETEITEM ((1024+&h1c00) +45)
#define OCM_VKEYTOITEM ((1024+&h1c00) +46)
#define OCM_CHARTOITEM ((1024+&h1c00) +47)
#define OCM_COMPAREITEM ((1024+&h1c00) +57)
#define OCM_HSCROLL ((1024+&h1c00) +276)
#define OCM_VSCROLL ((1024+&h1c00) +277)
#define OCM_PARENTNOTIFY ((1024+&h1c00) +528)
#define OCM_NOTIFY ((1024+&h1c00) +78)
#define CTRLINFO_EATS_RETURN 1
#define CTRLINFO_EATS_ESCAPE 2
#define XFORMCOORDS_POSITION 1
#define XFORMCOORDS_SIZE 2
#define XFORMCOORDS_HIMETRICTOCONTAINER 4
#define XFORMCOORDS_CONTAINERTOHIMETRIC 8
#define GUIDKIND_DEFAULT_SOURCE_DISP_IID 1
#define PROPPAGESTATUS_DIRTY 1
#define PROPPAGESTATUS_VALIDATE 2
#define PICTURE_SCALABLE 1
#define PICTURE_TRANSPARENT 2
#define PICTYPE_UNINITIALIZED (-1)
#define PICTYPE_NONE 0
#define PICTYPE_BITMAP 1
#define PICTYPE_METAFILE 2
#define PICTYPE_ICON 3
#define PICTYPE_ENHMETAFILE 4
#define DISPID_AUTOSIZE (-500)
#define DISPID_BACKCOLOR (-501)
#define DISPID_BACKSTYLE (-502)
#define DISPID_BORDERCOLOR (-503)
#define DISPID_BORDERSTYLE (-504)
#define DISPID_BORDERWIDTH (-505)
#define DISPID_DRAWMODE (-507)
#define DISPID_DRAWSTYLE (-508)
#define DISPID_DRAWWIDTH (-509)
#define DISPID_FILLCOLOR (-510)
#define DISPID_FILLSTYLE (-511)
#define DISPID_FONT (-512)
#define DISPID_FORECOLOR (-513)
#define DISPID_ENABLED (-514)
#define DISPID_HWND (-515)
#define DISPID_TABSTOP (-516)
#define DISPID_TEXT (-517)
#define DISPID_CAPTION (-518)
#define DISPID_BORDERVISIBLE (-519)
#define DISPID_APPEARANCE (-520)
#define DISPID_MOUSEPOINTER (-521)
#define DISPID_MOUSEICON (-522)
#define DISPID_PICTURE (-523)
#define DISPID_VALID (-524)
#define DISPID_REFRESH (-550)
#define DISPID_DOCLICK (-551)
#define DISPID_ABOUTBOX (-552)
#define DISPID_CLICK (-600)
#define DISPID_DBLCLICK (-601)
#define DISPID_KEYDOWN (-602)
#define DISPID_KEYPRESS (-603)
#define DISPID_KEYUP (-604)
#define DISPID_MOUSEDOWN (-605)
#define DISPID_MOUSEMOVE (-606)
#define DISPID_MOUSEUP (-607)
#define DISPID_ERROREVENT (-608)
#define DISPID_AMBIENT_BACKCOLOR (-701)
#define DISPID_AMBIENT_DISPLAYNAME (-702)
#define DISPID_AMBIENT_FONT (-703)
#define DISPID_AMBIENT_FORECOLOR (-704)
#define DISPID_AMBIENT_LOCALEID (-705)
#define DISPID_AMBIENT_MESSAGEREFLECT (-706)
#define DISPID_AMBIENT_SCALEUNITS (-707)
#define DISPID_AMBIENT_TEXTALIGN (-708)
#define DISPID_AMBIENT_USERMODE (-709)
#define DISPID_AMBIENT_UIDEAD (-710)
#define DISPID_AMBIENT_SHOWGRABHANDLES (-711)
#define DISPID_AMBIENT_SHOWHATCHING (-712)
#define DISPID_AMBIENT_DISPLAYASDEFAULT (-713)
#define DISPID_AMBIENT_SUPPORTSMNEMONICS (-714)
#define DISPID_AMBIENT_AUTOCLIP (-715)
#define DISPID_AMBIENT_APPEARANCE (-716)
#define DISPID_AMBIENT_CODEPAGE (-725)
#define DISPID_AMBIENT_PALETTE (-726)
#define DISPID_AMBIENT_CHARSET (-727)
#define DISPID_AMBIENT_RIGHTTOLEFT (-732)
#define DISPID_AMBIENT_TOPTOBOTTOM (-733)
#define DISPID_FONT_NAME 0
#define DISPID_FONT_SIZE 2
#define DISPID_FONT_BOLD 3
#define DISPID_FONT_ITALIC 4
#define DISPID_FONT_UNDER 5
#define DISPID_FONT_STRIKE 6
#define DISPID_FONT_WEIGHT 7
#define DISPID_FONT_CHARSET 8
#define DISPID_PICT_HANDLE 0
#define DISPID_PICT_HPAL 2
#define DISPID_PICT_TYPE 3
#define DISPID_PICT_WIDTH 4
#define DISPID_PICT_HEIGHT 5
#define DISPID_PICT_RENDER 6

type LPOLECONTROL as IOleControl ptr
type LPOLECONTROLSITE as IOleControlSite ptr
type LPSIMPLEFRAMESITE as ISimpleFrameSite ptr
type LPPERSISTPROPERTYBAG as IPersistPropertyBag ptr
type LPPERSISTSTREAMINIT as IPersistStreamInit ptr
type LPPERSISTMEMORY as IPersistMemory ptr
type LPPROPERTYNOTIFYSINK as IPropertyNotifySink ptr
type LPPROVIDECLASSINFO as IProvideClassInfo ptr
type LPPROVIDECLASSINFO2 as IProvideClassInfo2 ptr
type LPCONNECTIONPOINTCONTAINER as IConnectionPointContainer ptr
type LPCLASSFACTORY2 as IClassFactory2 ptr
type LPSPECIFYPROPERTYPAGES as ISpecifyPropertyPages ptr
type LPPERPROPERTYBROWSING as IPerPropertyBrowsing ptr
type LPPROPERTYPAGE as IPropertyPage ptr
type LPPROPERTYPAGE2 as IPropertyPage2 ptr
type LPPICTURE as IPicture ptr
type LPPICTUREDISP as IPictureDisp ptr
type OLE_XPOS_PIXELS as integer
type OLE_YPOS_PIXELS as integer
type OLE_XSIZE_PIXELS as integer
type OLE_YSIZE_PIXELS as integer
type OLE_XPOS_CONTAINER as single
type OLE_YPOS_CONTAINER as single
type OLE_XSIZE_CONTAINER as single
type OLE_OPTEXCLUSIVE as VARIANT_BOOL
type OLE_CANCELBOOL as VARIANT_BOOL
type OLE_ENABLEDEFAULTBOOL as VARIANT_BOOL

enum OLE_TRISTATE
	triUnchecked
	triChecked1
	triGray
end enum

type OCPFIPARAMS
	cbStructSize as ULONG
	hWndOwner as HWND
	x as integer
	y as integer
	lpszCaption as LPCOLESTR
	cObjects as ULONG
	lplpUnk as LPUNKNOWN ptr
	cPages as ULONG
	lpPages as CLSID ptr
	lcid as LCID
	dispidInitialProperty as DISPID
end type

type LPOCPFIPARAMS as OCPFIPARAMS ptr

type FONTDESC
	cbSizeofstruct as UINT
	lpstrName as LPOLESTR
	cySize as CY
	sWeight as SHORT
	sCharset as SHORT
	fItalic as BOOL
	fUnderline as BOOL
	fStrikethrough as BOOL
end type

type LPFONTDESC as FONTDESC ptr

type PICTDESC_emf
	hemf as HENHMETAFILE
end type

type PICTDESC_icon
	hicon as HICON
end type

type PICTDESC_wmf
	hmeta as HMETAFILE
	xExt as integer
	yExt as integer
end type

type PICTDESC_bmp
	hbitmap as HBITMAP
	hpal as HPALETTE
end type

type PICTDESC
	cbSizeofstruct as UINT
	picType as UINT
	union
		bmp as PICTDESC_bmp
		wmf as PICTDESC_wmf
		icon as PICTDESC_icon
		emf as PICTDESC_emf
	end union
end type

type LPPICTDESC as PICTDESC ptr

declare function DllRegisterServer alias "DllRegisterServer" () as HRESULT
declare function DllUnregisterServer alias "DllUnregisterServer" () as HRESULT
declare function OleCreateFontIndirect alias "OleCreateFontIndirect" (byval as LPFONTDESC, byval as IID ptr, byval as PVOID ptr) as HRESULT
declare function OleCreatePictureIndirect alias "OleCreatePictureIndirect" (byval as LPPICTDESC, byval as IID ptr, byval as BOOL, byval as PVOID ptr) as HRESULT
declare function OleCreatePropertyFrame alias "OleCreatePropertyFrame" (byval as HWND, byval as UINT, byval as UINT, byval as LPCOLESTR, byval as ULONG, byval as LPUNKNOWN ptr, byval as ULONG, byval as LPCLSID, byval as LCID, byval as DWORD, byval as PVOID) as HRESULT
declare function OleCreatePropertyFrameIndirect alias "OleCreatePropertyFrameIndirect" (byval as LPOCPFIPARAMS) as HRESULT
declare function OleIconToCursor alias "OleIconToCursor" (byval as HINSTANCE, byval as HICON) as HCURSOR
declare function OleLoadPicture alias "OleLoadPicture" (byval as LPSTREAM, byval as LONG, byval as BOOL, byval as IID ptr, byval as PVOID ptr) as HRESULT
declare function OleLoadPictureEx alias "OleLoadPictureEx" (byval as LPSTREAM, byval as LONG, byval as BOOL, byval as IID ptr, byval as DWORD, byval as DWORD, byval as DWORD, byval as LPVOID ptr) as HRESULT
declare function OleLoadPicturePath alias "OleLoadPicturePath" (byval as LPOLESTR, byval as LPUNKNOWN, byval as DWORD, byval as OLE_COLOR, byval as IID ptr, byval as LPVOID ptr) as HRESULT
declare function OleLoadPictureFile alias "OleLoadPictureFile" (byval as VARIANT_, byval as LPDISPATCH ptr) as HRESULT
declare function OleLoadPictureFileEx alias "OleLoadPictureFileEx" (byval as VARIANT_, byval as DWORD, byval as DWORD, byval as DWORD, byval as LPDISPATCH ptr) as HRESULT
declare function OleSavePictureFile alias "OleSavePictureFile" (byval as LPDISPATCH, byval as BSTR) as HRESULT
declare function OleTranslateColor alias "OleTranslateColor" (byval as OLE_COLOR, byval as HPALETTE, byval as COLORREF ptr) as HRESULT

#endif
