''
''
'' d3drmdef -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __win_d3drmdef_bi__
#define __win_d3drmdef_bi__

#include once "win/d3dtypes.bi"

type D3DRMVECTOR4D
	x as D3DVALUE
	y as D3DVALUE
	z as D3DVALUE
	w as D3DVALUE
end type

type LPD3DRMVECTOR4D as D3DRMVECTOR4D ptr
type D3DRMMATRIX4D as D3DVALUE		'' array (0-3,0-3)

type D3DRMQUATERNION
	s as D3DVALUE
	v as D3DVECTOR
end type

type LPD3DRMQUATERNION as D3DRMQUATERNION ptr

type D3DRMRAY
	dvDir as D3DVECTOR
	dvPos as D3DVECTOR
end type

type LPD3DRMRAY as D3DRMRAY ptr

type D3DRMBOX
	min_ as D3DVECTOR
	max_ as D3DVECTOR
end type

type LPD3DRMBOX as D3DRMBOX ptr
type D3DRMWRAPCALLBACK as sub(byval as LPD3DVECTOR, byval as integer ptr, byval as integer ptr, byval as LPD3DVECTOR, byval as LPD3DVECTOR, byval as LPVOID)

enum D3DRMLIGHTTYPE
	D3DRMLIGHT_AMBIENT
	D3DRMLIGHT_POINT
	D3DRMLIGHT_SPOT
	D3DRMLIGHT_DIRECTIONAL
	D3DRMLIGHT_PARALLELPOINT
end enum

type LPD3DRMLIGHTTYPE as D3DRMLIGHTTYPE

enum D3DRMSHADEMODE
	D3DRMSHADE_FLAT = 0
	D3DRMSHADE_GOURAUD = 1
	D3DRMSHADE_PHONG = 2
	D3DRMSHADE_MASK = 7
	D3DRMSHADE_MAX = 8
end enum

type LPD3DRMSHADEMODE as D3DRMSHADEMODE

enum D3DRMLIGHTMODE
	D3DRMLIGHT_OFF = 0*D3DRMSHADE_MAX
	D3DRMLIGHT_ON = 1*D3DRMSHADE_MAX
	D3DRMLIGHT_MASK = 7*D3DRMSHADE_MAX
	D3DRMLIGHT_MAX = 8*D3DRMSHADE_MAX
end enum

type LPD3DRMLIGHTMODE as D3DRMLIGHTMODE

enum D3DRMFILLMODE
	D3DRMFILL_POINTS = 0*D3DRMLIGHT_MAX
	D3DRMFILL_WIREFRAME = 1*D3DRMLIGHT_MAX
	D3DRMFILL_SOLID = 2*D3DRMLIGHT_MAX
	D3DRMFILL_MASK = 7*D3DRMLIGHT_MAX
	D3DRMFILL_MAX = 8*D3DRMLIGHT_MAX
end enum

type LPD3DRMFILLMODE as D3DRMFILLMODE
type D3DRMRENDERQUALITY as DWORD
type LPD3DRMRENDERQUALITY as DWORD ptr

#define D3DRMRENDERMODE_BLENDEDTRANSPARENCY 1
#define D3DRMRENDERMODE_SORTEDTRANSPARENCY 2
#define D3DRMRENDERMODE_LIGHTINMODELSPACE 8
#define D3DRMRENDERMODE_VIEWDEPENDENTSPECULAR 16
#define D3DRMRENDERMODE_DISABLESORTEDALPHAZWRITE 32

enum D3DRMTEXTUREQUALITY
	D3DRMTEXTURE_NEAREST
	D3DRMTEXTURE_LINEAR
	D3DRMTEXTURE_MIPNEAREST
	D3DRMTEXTURE_MIPLINEAR
	D3DRMTEXTURE_LINEARMIPNEAREST
	D3DRMTEXTURE_LINEARMIPLINEAR
end enum

type LPD3DRMTEXTUREQUALITY as D3DRMTEXTUREQUALITY

#define D3DRMTEXTURE_FORCERESIDENT &h00000001
#define D3DRMTEXTURE_STATIC &h00000002
#define D3DRMTEXTURE_DOWNSAMPLEPOINT &h00000004
#define D3DRMTEXTURE_DOWNSAMPLEBILINEAR &h00000008
#define D3DRMTEXTURE_DOWNSAMPLEREDUCEDEPTH &h00000010
#define D3DRMTEXTURE_DOWNSAMPLENONE &h00000020
#define D3DRMTEXTURE_CHANGEDPIXELS &h00000040
#define D3DRMTEXTURE_CHANGEDPALETTE &h00000080
#define D3DRMTEXTURE_INVALIDATEONLY &h00000100
#define D3DRMSHADOW_TRUEALPHA &h00000001

enum D3DRMCOMBINETYPE
	D3DRMCOMBINE_REPLACE
	D3DRMCOMBINE_BEFORE
	D3DRMCOMBINE_AFTER
end enum

type LPD3DRMCOMBINETYPE as D3DRMCOMBINETYPE
type D3DRMCOLORMODEL as D3DCOLORMODEL
type LPD3DRMCOLORMODEL as D3DCOLORMODEL ptr

enum D3DRMPALETTEFLAGS
	D3DRMPALETTE_FREE
	D3DRMPALETTE_READONLY
	D3DRMPALETTE_RESERVED
end enum

type LPD3DRMPALETTEFLAGS as D3DRMPALETTEFLAGS

type D3DRMPALETTEENTRY
	red as ubyte
	green as ubyte
	blue as ubyte
	flags as ubyte
end type

type LPD3DRMPALETTEENTRY as D3DRMPALETTEENTRY ptr

type D3DRMIMAGE
	width as integer
	height as integer
	aspectx_ as integer
	aspecty_ as integer
	depth as integer
	rgb_ as integer
	bytes_per_line as integer
	buffer1 as any ptr
	buffer2 as any ptr
	red_mask as uinteger
	green_mask as uinteger
	blue_mask as uinteger
	alpha_mask as uinteger
	palette_size as integer
	palette as D3DRMPALETTEENTRY ptr
end type

type LPD3DRMIMAGE as D3DRMIMAGE ptr

enum D3DRMWRAPTYPE
	D3DRMWRAP_FLAT
	D3DRMWRAP_CYLINDER
	D3DRMWRAP_SPHERE
	D3DRMWRAP_CHROME
	D3DRMWRAP_SHEET
	D3DRMWRAP_BOX
end enum

type LPD3DRMWRAPTYPE as D3DRMWRAPTYPE

#define D3DRMWIREFRAME_CULL 1
#define D3DRMWIREFRAME_HIDDENLINE 2

enum D3DRMPROJECTIONTYPE
	D3DRMPROJECT_PERSPECTIVE
	D3DRMPROJECT_ORTHOGRAPHIC
	D3DRMPROJECT_RIGHTHANDPERSPECTIVE
	D3DRMPROJECT_RIGHTHANDORTHOGRAPHIC
end enum

type LPD3DRMPROJECTIONTYPE as D3DRMPROJECTIONTYPE

#define D3DRMOPTIONS_LEFTHANDED &h00000001L
#define D3DRMOPTIONS_RIGHTHANDED &h00000002L

enum D3DRMXOFFORMAT
	D3DRMXOF_BINARY
	D3DRMXOF_COMPRESSED
	D3DRMXOF_TEXT
end enum

type LPD3DRMXOFFORMAT as D3DRMXOFFORMAT
type D3DRMSAVEOPTIONS as DWORD

#define D3DRMXOFSAVE_NORMALS 1
#define D3DRMXOFSAVE_TEXTURECOORDINATES 2
#define D3DRMXOFSAVE_MATERIALS 4
#define D3DRMXOFSAVE_TEXTURENAMES 8
#define D3DRMXOFSAVE_ALL 15
#define D3DRMXOFSAVE_TEMPLATES 16
#define D3DRMXOFSAVE_TEXTURETOPOLOGY 32

enum D3DRMCOLORSOURCE
	D3DRMCOLOR_FROMFACE
	D3DRMCOLOR_FROMVERTEX
end enum

type LPD3DRMCOLORSOURCE as D3DRMCOLORSOURCE

enum D3DRMFRAMECONSTRAINT
	D3DRMCONSTRAIN_Z
	D3DRMCONSTRAIN_Y
	D3DRMCONSTRAIN_X
end enum

type LPD3DRMFRAMECONSTRAINT as D3DRMFRAMECONSTRAINT

enum D3DRMMATERIALMODE
	D3DRMMATERIAL_FROMMESH
	D3DRMMATERIAL_FROMPARENT
	D3DRMMATERIAL_FROMFRAME
end enum

type LPD3DRMMATERIALMODE as D3DRMMATERIALMODE

enum D3DRMFOGMODE
	D3DRMFOG_LINEAR
	D3DRMFOG_EXPONENTIAL
	D3DRMFOG_EXPONENTIALSQUARED
end enum

type LPD3DRMFOGMODE as D3DRMFOGMODE

enum D3DRMZBUFFERMODE
	D3DRMZBUFFER_FROMPARENT
	D3DRMZBUFFER_ENABLE
	D3DRMZBUFFER_DISABLE
end enum

type LPD3DRMZBUFFERMODE as D3DRMZBUFFERMODE

enum D3DRMSORTMODE
	D3DRMSORT_FROMPARENT
	D3DRMSORT_NONE
	D3DRMSORT_FRONTTOBACK
	D3DRMSORT_BACKTOFRONT
end enum

type LPD3DRMSORTMODE as D3DRMSORTMODE

type D3DRMMATERIALOVERRIDE
	dwSize as DWORD
	dwFlags as DWORD
	dcDiffuse as D3DCOLORVALUE
	dcAmbient as D3DCOLORVALUE
	dcEmissive as D3DCOLORVALUE
	dcSpecular as D3DCOLORVALUE
	dvPower as D3DVALUE
	lpD3DRMTex as LPUNKNOWN
end type

type LPD3DRMMATERIALOVERRIDE as D3DRMMATERIALOVERRIDE ptr

#define D3DRMMATERIALOVERRIDE_DIFFUSE_ALPHAONLY &h00000001L
#define D3DRMMATERIALOVERRIDE_DIFFUSE_RGBONLY &h00000002L
#define D3DRMMATERIALOVERRIDE_DIFFUSE &h00000003L
#define D3DRMMATERIALOVERRIDE_AMBIENT &h00000004L
#define D3DRMMATERIALOVERRIDE_EMISSIVE &h00000008L
#define D3DRMMATERIALOVERRIDE_SPECULAR &h00000010L
#define D3DRMMATERIALOVERRIDE_POWER &h00000020L
#define D3DRMMATERIALOVERRIDE_TEXTURE &h00000040L
#define D3DRMMATERIALOVERRIDE_DIFFUSE_ALPHAMULTIPLY &h00000080L
#define D3DRMMATERIALOVERRIDE_ALL &h000000FFL
#define D3DRMFPTF_ALPHA &h00000001L
#define D3DRMFPTF_NOALPHA &h00000002L
#define D3DRMFPTF_PALETTIZED &h00000004L
#define D3DRMFPTF_NOTPALETTIZED &h00000008L
#define D3DRMSTATECHANGE_UPDATEONLY &h000000001L
#define D3DRMSTATECHANGE_VOLATILE &h000000002L
#define D3DRMSTATECHANGE_NONVOLATILE &h000000004L
#define D3DRMSTATECHANGE_RENDER &h000000020L
#define D3DRMSTATECHANGE_LIGHT &h000000040L
#define D3DRMDEVICE_NOZBUFFER &h00000001L
#define D3DRMCLIENTDATA_NONE &h00000001L
#define D3DRMCLIENTDATA_LOCALFREE &h00000002L
#define D3DRMCLIENTDATA_IUNKNOWN &h00000004L
#define D3DRMCALLBACK_PREORDER 0
#define D3DRMCALLBACK_POSTORDER 1
#define D3DRMRAYPICK_ONLYBOUNDINGBOXES 1
#define D3DRMRAYPICK_IGNOREFURTHERPRIMITIVES 2
#define D3DRMRAYPICK_INTERPOLATEUV 4
#define D3DRMRAYPICK_INTERPOLATECOLOR 8
#define D3DRMRAYPICK_INTERPOLATENORMAL &h10
#define D3DRMADDFACES_VERTICESONLY 1
#define D3DRMGENERATENORMALS_PRECOMPACT 1
#define D3DRMGENERATENORMALS_USECREASEANGLE 2
#define D3DRMMESHBUILDER_DIRECTPARENT 1
#define D3DRMMESHBUILDER_ROOTMESH 2
#define D3DRMMESHBUILDER_RENDERENABLE &h00000001L
#define D3DRMMESHBUILDER_PICKENABLE &h00000002L
#define D3DRMADDMESHBUILDER_DONTCOPYAPPDATA 1
#define D3DRMADDMESHBUILDER_FLATTENSUBMESHES 2
#define D3DRMADDMESHBUILDER_NOSUBMESHES 4
#define D3DRMMESHBUILDERAGE_GEOMETRY &h00000001L
#define D3DRMMESHBUILDERAGE_MATERIALS &h00000002L
#define D3DRMMESHBUILDERAGE_TEXTURES &h00000004L
#define D3DRMFVF_TYPE &h00000001L
#define D3DRMFVF_NORMAL &h00000002L
#define D3DRMFVF_COLOR &h00000004L
#define D3DRMFVF_TEXTURECOORDS &h00000008L
#define D3DRMVERTEX_STRIP &h00000001L
#define D3DRMVERTEX_FAN &h00000002L
#define D3DRMVERTEX_LIST &h00000004L
#define D3DRMCLEAR_TARGET &h00000001L
#define D3DRMCLEAR_ZBUFFER &h00000002L
#define D3DRMCLEAR_DIRTYRECTS &h00000004L
#define D3DRMCLEAR_ALL (&h00000001L or &h00000002L or &h00000004L)
#define D3DRMFOGMETHOD_VERTEX &h00000001L
#define D3DRMFOGMETHOD_TABLE &h00000002L
#define D3DRMFOGMETHOD_ANY &h00000004L
#define D3DRMFRAME_RENDERENABLE &h00000001L
#define D3DRMFRAME_PICKENABLE &h00000002L

type D3DRMANIMATIONOPTIONS as DWORD

#define D3DRMANIMATION_OPEN &h01L
#define D3DRMANIMATION_CLOSED &h02L
#define D3DRMANIMATION_LINEARPOSITION &h04L
#define D3DRMANIMATION_SPLINEPOSITION &h08L
#define D3DRMANIMATION_SCALEANDROTATION &h00000010L
#define D3DRMANIMATION_POSITION &h00000020L

type D3DRMINTERPOLATIONOPTIONS as DWORD

#define D3DRMINTERPOLATION_OPEN &h01L
#define D3DRMINTERPOLATION_CLOSED &h02L
#define D3DRMINTERPOLATION_NEAREST &h0100L
#define D3DRMINTERPOLATION_LINEAR &h04L
#define D3DRMINTERPOLATION_SPLINE &h08L
#define D3DRMINTERPOLATION_VERTEXCOLOR &h40L
#define D3DRMINTERPOLATION_SLERPNORMALS &h80L

type D3DRMLOADOPTIONS as DWORD

#define D3DRMLOAD_FROMFILE &h00L
#define D3DRMLOAD_FROMRESOURCE &h01L
#define D3DRMLOAD_FROMMEMORY &h02L
#define D3DRMLOAD_FROMSTREAM &h04L
#define D3DRMLOAD_FROMURL &h08L
#define D3DRMLOAD_BYNAME &h10L
#define D3DRMLOAD_BYPOSITION &h20L
#define D3DRMLOAD_BYGUID &h40L
#define D3DRMLOAD_FIRST &h80L
#define D3DRMLOAD_INSTANCEBYREFERENCE &h100L
#define D3DRMLOAD_INSTANCEBYCOPYING &h200L
#define D3DRMLOAD_ASYNCHRONOUS &h400L

type D3DRMLOADRESOURCE
	hModule as HMODULE
	lpName as LPCTSTR
	lpType as LPCTSTR
end type

type LPD3DRMLOADRESOURCE as D3DRMLOADRESOURCE ptr

type D3DRMLOADMEMORY
	lpMemory as LPVOID
	dSize as DWORD
end type

type LPD3DRMLOADMEMORY as D3DRMLOADMEMORY ptr

#define D3DRMPMESHSTATUS_VALID &h01L
#define D3DRMPMESHSTATUS_INTERRUPTED &h02L
#define D3DRMPMESHSTATUS_BASEMESHCOMPLETE &h04L
#define D3DRMPMESHSTATUS_COMPLETE &h08L
#define D3DRMPMESHSTATUS_RENDERABLE &h10L
#define D3DRMPMESHEVENT_BASEMESH &h01L
#define D3DRMPMESHEVENT_COMPLETE &h02L

type D3DRMPMESHLOADSTATUS
	dwSize as DWORD
	dwPMeshSize as DWORD
	dwBaseMeshSize as DWORD
	dwBytesLoaded as DWORD
	dwVerticesLoaded as DWORD
	dwFacesLoaded as DWORD
	dwLoadResult as HRESULT
	dwFlags as DWORD
end type

type LPD3DRMPMESHLOADSTATUS as D3DRMPMESHLOADSTATUS ptr

enum D3DRMUSERVISUALREASON
	D3DRMUSERVISUAL_CANSEE
	D3DRMUSERVISUAL_RENDER
end enum

type LPD3DRMUSERVISUALREASON as D3DRMUSERVISUALREASON

type D3DRMANIMATIONKEY
	dwSize as DWORD
	dwKeyType as DWORD
	dvTime as D3DVALUE
	dwID as DWORD
end type

type LPD3DRMANIMATIONKEY as D3DRMANIMATIONKEY ptr

#define D3DRMANIMATION_ROTATEKEY &h01
#define D3DRMANIMATION_SCALEKEY &h02
#define D3DRMANIMATION_POSITIONKEY &h03

type D3DRMMAPPING as DWORD
type D3DRMMAPPINGFLAG as DWORD
type LPD3DRMMAPPING as DWORD ptr

type D3DRMVERTEX
	position as D3DVECTOR
	normal as D3DVECTOR
	tu as D3DVALUE
	tv as D3DVALUE
	color as D3DCOLOR
end type

type LPD3DRMVERTEX as D3DRMVERTEX ptr
type D3DRMGROUPINDEX as LONG

declare function D3DRMCreateColorRGB alias "D3DRMCreateColorRGB" (byval red as D3DVALUE, byval green as D3DVALUE, byval blue as D3DVALUE) as D3DCOLOR
declare function D3DRMCreateColorRGBA alias "D3DRMCreateColorRGBA" (byval red as D3DVALUE, byval green as D3DVALUE, byval blue as D3DVALUE, byval alpha as D3DVALUE) as D3DCOLOR
declare function D3DRMColorGetRed alias "D3DRMColorGetRed" (byval as D3DCOLOR) as D3DVALUE
declare function D3DRMColorGetGreen alias "D3DRMColorGetGreen" (byval as D3DCOLOR) as D3DVALUE
declare function D3DRMColorGetBlue alias "D3DRMColorGetBlue" (byval as D3DCOLOR) as D3DVALUE
declare function D3DRMColorGetAlpha alias "D3DRMColorGetAlpha" (byval as D3DCOLOR) as D3DVALUE
declare function D3DRMVectorAdd alias "D3DRMVectorAdd" (byval d as LPD3DVECTOR, byval s1 as LPD3DVECTOR, byval s2 as LPD3DVECTOR) as LPD3DVECTOR
declare function D3DRMVectorSubtract alias "D3DRMVectorSubtract" (byval d as LPD3DVECTOR, byval s1 as LPD3DVECTOR, byval s2 as LPD3DVECTOR) as LPD3DVECTOR
declare function D3DRMVectorReflect alias "D3DRMVectorReflect" (byval d as LPD3DVECTOR, byval ray as LPD3DVECTOR, byval norm as LPD3DVECTOR) as LPD3DVECTOR
declare function D3DRMVectorCrossProduct alias "D3DRMVectorCrossProduct" (byval d as LPD3DVECTOR, byval s1 as LPD3DVECTOR, byval s2 as LPD3DVECTOR) as LPD3DVECTOR
declare function D3DRMVectorDotProduct alias "D3DRMVectorDotProduct" (byval s1 as LPD3DVECTOR, byval s2 as LPD3DVECTOR) as D3DVALUE
declare function D3DRMVectorNormalize alias "D3DRMVectorNormalize" (byval as LPD3DVECTOR) as LPD3DVECTOR
declare function D3DRMVectorModulus alias "D3DRMVectorModulus" (byval v as LPD3DVECTOR) as D3DVALUE
declare function D3DRMVectorRotate alias "D3DRMVectorRotate" (byval r as LPD3DVECTOR, byval v as LPD3DVECTOR, byval axis as LPD3DVECTOR, byval theta as D3DVALUE) as LPD3DVECTOR
declare function D3DRMVectorScale alias "D3DRMVectorScale" (byval d as LPD3DVECTOR, byval s as LPD3DVECTOR, byval factor as D3DVALUE) as LPD3DVECTOR
declare function D3DRMVectorRandom alias "D3DRMVectorRandom" (byval d as LPD3DVECTOR) as LPD3DVECTOR
declare function D3DRMQuaternionFromRotation alias "D3DRMQuaternionFromRotation" (byval quat as LPD3DRMQUATERNION, byval v as LPD3DVECTOR, byval theta as D3DVALUE) as LPD3DRMQUATERNION
declare function D3DRMQuaternionMultiply alias "D3DRMQuaternionMultiply" (byval q as LPD3DRMQUATERNION, byval a as LPD3DRMQUATERNION, byval b as LPD3DRMQUATERNION) as LPD3DRMQUATERNION
declare function D3DRMQuaternionSlerp alias "D3DRMQuaternionSlerp" (byval q as LPD3DRMQUATERNION, byval a as LPD3DRMQUATERNION, byval b as LPD3DRMQUATERNION, byval alpha as D3DVALUE) as LPD3DRMQUATERNION
declare sub D3DRMMatrixFromQuaternion alias "D3DRMMatrixFromQuaternion" (byval dmMat as D3DRMMATRIX4D, byval lpDqQuat as LPD3DRMQUATERNION)
declare function D3DRMQuaternionFromMatrix alias "D3DRMQuaternionFromMatrix" (byval as LPD3DRMQUATERNION, byval as D3DRMMATRIX4D) as LPD3DRMQUATERNION

#endif
