/*
 *  libgfx2 - FreeBASIC's alternative gfx library
 *	Copyright (C) 2005 Angelo Mottola (a.mottola@libero.it)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * stick.c -- QB compatible STICK(n) and STRIG(n) functions
 *
 * chng: oct/2007 written [jeffm]
 *
 */

#include "fb_gfx.h"

/* save state for x,y,buttons for A,B sticks */

static int stick_posn[4] = { 0, 0, 0, 0 };
static int stick_btns[2] = { 0, 0 };

/*:::::*/
FBCALL int fb_GfxStickQB( int n )
{
	/*
		if n == 0 then 
			read and save x,y positions for stick A and B.
			return A.x
		if n == 1,2,3
			return the last read position for A.y, B.x, B.y
	*/

	if( n >= 0 && n <= 3 )
	{
		if( n == 0 )
		{
			int i;
			for( i=0; i<2; i++ )
			{
				float x, y, a;
				int buttons;
				int ret = fb_GfxGetJoystick( i, &buttons, &x, &y, &a, &a, &a, &a, &a, &a );
				if( ret == FB_RTERROR_OK )
				{
					stick_posn[i*2] = (int)(x * 100 + 101);
					stick_posn[i*2+1] = (int)(y * 100 + 101);
					stick_btns[i] = buttons;
				}
				else
				{
					stick_posn[i*2] = 0;
					stick_posn[i*2+1] = 0;
					stick_btns[i] = 0;
				}
			}
		}
		return stick_posn[n];
	}

	fb_ErrorSetNum( FB_RTERROR_ILLEGALFUNCTIONCALL );
	return 0;
}

/*:::::*/
FBCALL int fb_GfxStrigQB( int n )
{
	/* 
		n	result ( -1 == TRUE, 0 == FALSE )
		0	A button 1 pressed since last STICK(0)
		1	A button 1 is pressed
		2	B button 1 pressed since last STICK(0)
		3	B button 1 is pressed
		4	A button 2 pressed since last STICK(0)
		5	A button 2 is pressed
		6	B button 2 pressed since last STICK(0)
		7	B button 2 is pressed
	*/
	
	if( (n >= 0) && (n <= 7) )
	{
		int i = (n>>1)&1;
		int bmask = (n>>2)+1;

		if( n & 1 )
		{
			float a;
			int buttons;

			if( FB_RTERROR_OK == fb_GfxGetJoystick( i, &buttons, &a, &a, &a, &a, &a, &a, &a, &a ))
			{
				stick_btns[i] |= buttons;
				return ( buttons & bmask) ? -1 : 0;
			}
		}
		else
		{
			return ( stick_btns[i] & bmask) ? -1 : 0;
		}
	}

	fb_ErrorSetNum( FB_RTERROR_ILLEGALFUNCTIONCALL );
	return 0;
}
