;********************************;
; WASM System Shell, Run Program ;
; By Eric Tauck                  ;
;                                ;
; Defines:                       ;
;                                ;
;   RunPro  execute a program    ;
;                                ;
; Requires:                      ;
;                                ;
;   STACK.ASM                    ;
;   STRING.ASM                   ;
;********************************;

        jmp     _shell1_end

_SHELL_MAXINP   EQU     128     ;maximum input length
_shell_FCB_size EQU     37      ;size of FCB

;--- offsets of shell parameter block

_shell_enviro   EQU     0       ;environment
_shell_cmdlin   EQU     2       ;command line offset
_shell_fcb1     EQU     6       ;first FCB offset
_shell_fcb2     EQU     10      ;second FCB offset
_shell_size     EQU     14      ;size of shell parameter block

;--- saved stack

_shell_ss       DW      ?       ;saved SS
_shell_sp       DW      ?       ;saved SP

;========================================
; Execute a program.
;
; In: AX= address of command; BX= address
;     of command line.
;
; Out: CY= set if error; AL= DOS error
;      code.

RunPro  PROC    NEAR
        push    di
        push    si
        push    bp
        push    ds
        push    es

        mov     di, ax          ;save program name
        mov     bp, bx          ;save command line address

;--- allocate memory

        StkAll  si, _shell_size                 ;allocate parameter block
        mov     ax, [002CH]                     ;this program's environment
        mov     [si + _shell_enviro], ax
        StkAll  ax, _SHELL_MAXINP + 2           ;allocate input space
        mov     [si + _shell_cmdlin], ax
        StkAll  ax, _shell_FCB_size             ;allocate first FCB
        mov     [si + _shell_fcb1], ax
        StkAll  ax, _shell_FCB_size             ;allocate second FCB
        mov     [si + _shell_fcb2], ax
        mov     ax, ds                          ;save segments
        mov     [si + _shell_cmdlin + 2], ax
        mov     [si + _shell_fcb1 + 2], ax
        mov     [si + _shell_fcb2 + 2], ax

;--- set up command line

        push    di
        push    si

        mov     ax, bp
        call    StrLen                  ;get length of input
        cmp     ax, _SHELL_MAXINP       ;check if too large
        jbe     _rnpro1
        mov     ax, _SHELL_MAXINP

_rnpro1 push    WORD [si+_shell_fcb2]   ;
        push    WORD [si+_shell_fcb1]   ;save FCB locations for later

        cld
        mov     di, [si+_shell_cmdlin]  ;place to store command line
        push    di                      ;save for parsing
        stosb                           ;store length
        mov     cx, ax
        mov     si, bp
        rep
        movsb                   ;copy rest of string
        mov     al, 13          ;carriage return
        stosb                   ;store it

;--- set up FCB's

        pop     si
        inc     si              ;skip length
        pop     di
        mov     ax, 2901H       ;parse file name function
        int     21H             ;execute

        pop     di
        mov     ax, 2901H       ;parse file name function
        int     21H             ;execute

        pop     si
        pop     di

;--- save stack pointers

        mov     _shell_ss, ss   ;save SS
        mov     _shell_sp, sp   ;save SP

;--- execute shell

        mov     ax, 4B00H       ;execute function
        mov     dx, di          ;name of program
        mov     bx, si          ;shell paramters
        int     21H             ;execute

        mov     dx, ax          ;save return code
        lahf                    ;save return flags

;--- restore stack

        cli
        seg     cs
        mov     ss, _shell_ss   ;restore SS
        seg     cs
        mov     sp, _shell_sp   ;restore SP
        sti

        StkRel  _shell_size, _SHELL_MAXINP + 2, _shell_FCB_size * 2

;--- restore registers

        pop     es
        pop     ds
        pop     bp
        pop     si
        pop     di

        sahf                    ;restore flags
        mov     ax, dx          ;restore return code
        ret
        ENDP

_shell1_end
