#include "Python.h"
#include "nidaqex.h"


static PyObject *
ex_foo(self, args)
	PyObject *self, *args;
{
	printf("Hello, world\n");
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *Py_AI_VRead (PyObject *self, PyObject *args) 
{
	short device;
	short channel;
	short gain;
	short status;
	double volts;

	if (!PyArg_ParseTuple(args, "iii", &device, &channel, &gain))
		return NULL;

	status = AI_VRead(device, channel, gain, &volts);

	return (Py_BuildValue ("(id)", status, volts));		 
}



static PyObject *Py_DIG_Prt_Config(PyObject *self, PyObject *args)
{
	short device;
	short port;
	short mode;
	short direction;
	short status;

	if (!PyArg_ParseTuple(args, "iiii", &device, &port, &mode, &direction))
		return NULL;

	status = DIG_Prt_Config(device, port, mode, direction);

	return (Py_BuildValue("i", status));
}
	
static PyObject *Py_DIG_Out_Port(PyObject *self, PyObject *args)
{
	short device;
	short port;
	short pattern;
	short status;

	if (!PyArg_ParseTuple(args, "iii", &device, &port, &pattern))
		return NULL;

	status = DIG_Out_Port(device, port, pattern);

	return (Py_BuildValue("i", status));
}


static PyMethodDef nidaq_methods[] = {
	{"foo", ex_foo, 1, "foo() doc string"},
	{"ai_vread", Py_AI_VRead, 1, "AI_VRead doc string"},
	{"dig_port_config", Py_DIG_Prt_Config, 1, "DIG_Prt_Config doc string"},
	{"dig_out_port", Py_DIG_Out_Port, 1, "DIG_Out_Port doc string"},
	{NULL, NULL}
};

void
initnidaq()
{
	Py_InitModule("nidaq", nidaq_methods);
}
