////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:20
//  it declares the content of the module _Classes
////

unit Python_Classes;

interface

uses
   Windows,
   Classes,
   SysUtils,
   PythonEngine;

type
  TModule_Classes = class( TPythonModule )
  public
    procedure Initialize; override;
  end;

  function TList_ReadAttribute( Self : TList; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TList_WriteAttribute( Self : TList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TThreadList_ReadAttribute( Self : TThreadList; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TThreadList_WriteAttribute( Self : TThreadList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TBits_ReadAttribute( Self : TBits; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TBits_WriteAttribute( Self : TBits; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TPersistent_ReadAttribute( Self : TPersistent; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TPersistent_WriteAttribute( Self : TPersistent; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCollectionItem_ReadAttribute( Self : TCollectionItem; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCollectionItem_WriteAttribute( Self : TCollectionItem; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCollection_ReadAttribute( Self : TCollection; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCollection_WriteAttribute( Self : TCollection; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TStrings_ReadAttribute( Self : TStrings; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TStrings_WriteAttribute( Self : TStrings; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TStringList_ReadAttribute( Self : TStringList; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TStringList_WriteAttribute( Self : TStringList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TStream_ReadAttribute( Self : TStream; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TStream_WriteAttribute( Self : TStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function THandleStream_ReadAttribute( Self : THandleStream; argSelf : PPyObject; key : PChar ) : PPyObject;
  function THandleStream_WriteAttribute( Self : THandleStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TFileStream_ReadAttribute( Self : TFileStream; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TFileStream_WriteAttribute( Self : TFileStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomMemoryStream_ReadAttribute( Self : TCustomMemoryStream; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomMemoryStream_WriteAttribute( Self : TCustomMemoryStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TMemoryStream_ReadAttribute( Self : TMemoryStream; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TMemoryStream_WriteAttribute( Self : TMemoryStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TStringStream_ReadAttribute( Self : TStringStream; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TStringStream_WriteAttribute( Self : TStringStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TResourceStream_ReadAttribute( Self : TResourceStream; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TResourceStream_WriteAttribute( Self : TResourceStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TStreamAdapter_ReadAttribute( Self : TStreamAdapter; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TStreamAdapter_WriteAttribute( Self : TStreamAdapter; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TFiler_ReadAttribute( Self : TFiler; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TFiler_WriteAttribute( Self : TFiler; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TReader_ReadAttribute( Self : TReader; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TReader_WriteAttribute( Self : TReader; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TWriter_ReadAttribute( Self : TWriter; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TWriter_WriteAttribute( Self : TWriter; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TParser_ReadAttribute( Self : TParser; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TParser_WriteAttribute( Self : TParser; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TThread_ReadAttribute( Self : TThread; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TThread_WriteAttribute( Self : TThread; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TComponent_ReadAttribute( Self : TComponent; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TComponent_WriteAttribute( Self : TComponent; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;

  procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 

implementation

uses
   Delphi_System,
   Delphi_Classes,
   Python_System,
   Py_Misc,
   PyRecords,
   PyDelphiAssoc;

var
  IsInitialized : Boolean;
  gClasses : TModule_Classes;
procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 
begin
  if IsInitialized then
    Exit;
  IsInitialized := True;
  gClasses := TModule_Classes.Create( AOwner );
  with gClasses do
    begin
      Engine := AEngine;
      ModuleName := '_Classes';
    end;
end;

///////////// Functions for class TList //////////////////

function TList_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyList;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TList.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyList.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TList_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TList) then begin
      ErrorWrongExpectedType( argSelf, 'TList' );
      Exit;
    end;
    realObj := TList(obj);
    // Check attribute
    Result := TList_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TList_ReadAttribute( Self : TList; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Capacity' ) = 0 then Result := VariantAsPyObject( Self.Capacity )
    else if CompareText( key, 'Count' ) = 0 then Result := VariantAsPyObject( Self.Count )
    else if CompareText( key, 'List' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'PPointerList' ); Result := nil; end
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TList_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TList) then begin
      ErrorWrongExpectedType( argSelf, 'TList' );
      Exit;
    end;
    realObj := TList(obj);
    // Check attribute
    Result := TList_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TList_WriteAttribute( Self : TList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Capacity' ) = 0 then begin
      Self.Capacity := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Count' ) = 0 then begin
      Self.Count := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'List' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TThreadList //////////////////

function TThreadList_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyThreadList;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TThreadList.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyThreadList.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TThreadList_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TThreadList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TThreadList) then begin
      ErrorWrongExpectedType( argSelf, 'TThreadList' );
      Exit;
    end;
    realObj := TThreadList(obj);
    // Check attribute
    Result := TThreadList_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TThreadList_ReadAttribute( Self : TThreadList; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TThreadList_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TThreadList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TThreadList) then begin
      ErrorWrongExpectedType( argSelf, 'TThreadList' );
      Exit;
    end;
    realObj := TThreadList(obj);
    // Check attribute
    Result := TThreadList_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TThreadList_WriteAttribute( Self : TThreadList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TBits //////////////////

function TBits_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyBits;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TBits.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyBits.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TBits_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBits;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBits) then begin
      ErrorWrongExpectedType( argSelf, 'TBits' );
      Exit;
    end;
    realObj := TBits(obj);
    // Check attribute
    Result := TBits_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TBits_ReadAttribute( Self : TBits; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Size' ) = 0 then Result := VariantAsPyObject( Self.Size )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TBits_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBits;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBits) then begin
      ErrorWrongExpectedType( argSelf, 'TBits' );
      Exit;
    end;
    realObj := TBits(obj);
    // Check attribute
    Result := TBits_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TBits_WriteAttribute( Self : TBits; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Size' ) = 0 then begin
      Self.Size := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TPersistent //////////////////

function TPersistent_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyPersistent;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TPersistent.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyPersistent.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TPersistent_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPersistent;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPersistent) then begin
      ErrorWrongExpectedType( argSelf, 'TPersistent' );
      Exit;
    end;
    realObj := TPersistent(obj);
    // Check attribute
    Result := TPersistent_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TPersistent_ReadAttribute( Self : TPersistent; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TPersistent_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPersistent;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPersistent) then begin
      ErrorWrongExpectedType( argSelf, 'TPersistent' );
      Exit;
    end;
    realObj := TPersistent(obj);
    // Check attribute
    Result := TPersistent_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TPersistent_WriteAttribute( Self : TPersistent; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCollectionItem //////////////////

function TCollectionItem_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCollectionItem;
  argSelf : PPyObject;
  argCollection : PPyObject;
  objCollection : TCollection;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCollectionItem.Create', [ @argSelf,
                  @argCollection       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objCollection := GetObjectOf( argCollection ) as TCollection;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCollectionItem.Create( objCollection );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCollectionItem_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCollectionItem;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCollectionItem) then begin
      ErrorWrongExpectedType( argSelf, 'TCollectionItem' );
      Exit;
    end;
    realObj := TCollectionItem(obj);
    // Check attribute
    Result := TCollectionItem_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCollectionItem_ReadAttribute( Self : TCollectionItem; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Collection' ) = 0 then Result := GetPythonObject( Self.Collection, 'Classes', 'TCollection' )
    else if CompareText( key, 'ID' ) = 0 then Result := VariantAsPyObject( Self.ID )
    else if CompareText( key, 'Index' ) = 0 then Result := VariantAsPyObject( Self.Index )
    else if CompareText( key, 'DisplayName' ) = 0 then Result := VariantAsPyObject( Self.DisplayName )
    else Result := TPersistent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCollectionItem_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCollectionItem;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCollectionItem) then begin
      ErrorWrongExpectedType( argSelf, 'TCollectionItem' );
      Exit;
    end;
    realObj := TCollectionItem(obj);
    // Check attribute
    Result := TCollectionItem_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCollectionItem_WriteAttribute( Self : TCollectionItem; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Collection' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TCollection then begin
        Self.Collection := TCollection( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Collection', 'TCollection' );
    end else if CompareText( key, 'ID' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Index' ) = 0 then begin
      Self.Index := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DisplayName' ) = 0 then begin
      Self.DisplayName := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TPersistent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCollection //////////////////

function TCollection_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCollection;
  argSelf : PPyObject;
  argItemClass : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCollection.Create', [ @argSelf,
                  @argItemClass       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCollection.Create( nil );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCollection_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCollection;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCollection) then begin
      ErrorWrongExpectedType( argSelf, 'TCollection' );
      Exit;
    end;
    realObj := TCollection(obj);
    // Check attribute
    Result := TCollection_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCollection_ReadAttribute( Self : TCollection; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Count' ) = 0 then Result := VariantAsPyObject( Self.Count )
    else if CompareText( key, 'ItemClass' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TCollectionItemClass' ); Result := nil; end
    else Result := TPersistent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCollection_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCollection;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCollection) then begin
      ErrorWrongExpectedType( argSelf, 'TCollection' );
      Exit;
    end;
    realObj := TCollection(obj);
    // Check attribute
    Result := TCollection_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCollection_WriteAttribute( Self : TCollection; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Count' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ItemClass' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TPersistent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TStrings //////////////////

function TStrings_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyStrings;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TStrings.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyStrings.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TStrings_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStrings;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStrings) then begin
      ErrorWrongExpectedType( argSelf, 'TStrings' );
      Exit;
    end;
    realObj := TStrings(obj);
    // Check attribute
    Result := TStrings_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TStrings_ReadAttribute( Self : TStrings; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Capacity' ) = 0 then Result := VariantAsPyObject( Self.Capacity )
    else if CompareText( key, 'CommaText' ) = 0 then Result := VariantAsPyObject( Self.CommaText )
    else if CompareText( key, 'Count' ) = 0 then Result := VariantAsPyObject( Self.Count )
    else if CompareText( key, 'Text' ) = 0 then Result := VariantAsPyObject( Self.Text )
    else if CompareText( key, 'StringsAdapter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'IStringsAdapter' ); Result := nil; end
    else Result := TPersistent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TStrings_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStrings;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStrings) then begin
      ErrorWrongExpectedType( argSelf, 'TStrings' );
      Exit;
    end;
    realObj := TStrings(obj);
    // Check attribute
    Result := TStrings_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TStrings_WriteAttribute( Self : TStrings; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Capacity' ) = 0 then begin
      Self.Capacity := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'CommaText' ) = 0 then begin
      Self.CommaText := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Count' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Text' ) = 0 then begin
      Self.Text := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'StringsAdapter' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'IStringsAdapter' );
    end else Result := TPersistent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TStringList //////////////////

function TStringList_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyStringList;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TStringList.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyStringList.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TStringList_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStringList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStringList) then begin
      ErrorWrongExpectedType( argSelf, 'TStringList' );
      Exit;
    end;
    realObj := TStringList(obj);
    // Check attribute
    Result := TStringList_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TStringList_ReadAttribute( Self : TStringList; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Duplicates' ) = 0 then Result := VariantAsPyObject( Integer( Self.Duplicates ) )
    else if CompareText( key, 'Sorted' ) = 0 then Result := VariantAsPyObject( Self.Sorted )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnChanging' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TStrings_ReadAttribute( Self, argSelf, key );
  end;
end;

function TStringList_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStringList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStringList) then begin
      ErrorWrongExpectedType( argSelf, 'TStringList' );
      Exit;
    end;
    realObj := TStringList(obj);
    // Check attribute
    Result := TStringList_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TStringList_WriteAttribute( Self : TStringList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Duplicates' ) = 0 then begin
      Self.Duplicates := TDuplicates(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Sorted' ) = 0 then begin
      Self.Sorted := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStringList then
          with TPyStringList(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnChanging' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChanging := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStringList then
          with TPyStringList(Self) do
            OnChanging := EventOnChanging;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TStrings_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TStream //////////////////

function TStream_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyStream;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TStream.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyStream.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TStream_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStream) then begin
      ErrorWrongExpectedType( argSelf, 'TStream' );
      Exit;
    end;
    realObj := TStream(obj);
    // Check attribute
    Result := TStream_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TStream_ReadAttribute( Self : TStream; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Position' ) = 0 then Result := VariantAsPyObject( Self.Position )
    else if CompareText( key, 'Size' ) = 0 then Result := VariantAsPyObject( Self.Size )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TStream_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStream) then begin
      ErrorWrongExpectedType( argSelf, 'TStream' );
      Exit;
    end;
    realObj := TStream(obj);
    // Check attribute
    Result := TStream_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TStream_WriteAttribute( Self : TStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Position' ) = 0 then begin
      Self.Position := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Size' ) = 0 then begin
      Self.Size := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class THandleStream //////////////////

function THandleStream_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyHandleStream;
  argSelf : PPyObject;
  argAHandle : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:THandleStream.Create', [ @argSelf,
                  @argAHandle       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyHandleStream.Create( Integer(argAHandle) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function THandleStream_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : THandleStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is THandleStream) then begin
      ErrorWrongExpectedType( argSelf, 'THandleStream' );
      Exit;
    end;
    realObj := THandleStream(obj);
    // Check attribute
    Result := THandleStream_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function THandleStream_ReadAttribute( Self : THandleStream; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Handle' ) = 0 then Result := VariantAsPyObject( Self.Handle )
    else Result := TStream_ReadAttribute( Self, argSelf, key );
  end;
end;

function THandleStream_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : THandleStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is THandleStream) then begin
      ErrorWrongExpectedType( argSelf, 'THandleStream' );
      Exit;
    end;
    realObj := THandleStream(obj);
    // Check attribute
    Result := THandleStream_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function THandleStream_WriteAttribute( Self : THandleStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TStream_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TFileStream //////////////////

function TFileStream_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyFileStream;
  argSelf : PPyObject;
  argFileName : PChar;
  argMode : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Osi:TFileStream.Create', [ @argSelf,
                  @argFileName,
                  @argMode       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyFileStream.Create( string(argFileName), Word(argMode) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TFileStream_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TFileStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TFileStream) then begin
      ErrorWrongExpectedType( argSelf, 'TFileStream' );
      Exit;
    end;
    realObj := TFileStream(obj);
    // Check attribute
    Result := TFileStream_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TFileStream_ReadAttribute( Self : TFileStream; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := THandleStream_ReadAttribute( Self, argSelf, key );
  end;
end;

function TFileStream_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TFileStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TFileStream) then begin
      ErrorWrongExpectedType( argSelf, 'TFileStream' );
      Exit;
    end;
    realObj := TFileStream(obj);
    // Check attribute
    Result := TFileStream_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TFileStream_WriteAttribute( Self : TFileStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := THandleStream_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomMemoryStream //////////////////

function TCustomMemoryStream_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomMemoryStream;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TCustomMemoryStream.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomMemoryStream.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomMemoryStream_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomMemoryStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomMemoryStream) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomMemoryStream' );
      Exit;
    end;
    realObj := TCustomMemoryStream(obj);
    // Check attribute
    Result := TCustomMemoryStream_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomMemoryStream_ReadAttribute( Self : TCustomMemoryStream; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Memory' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'Pointer' ); Result := nil; end
    else Result := TStream_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomMemoryStream_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomMemoryStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomMemoryStream) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomMemoryStream' );
      Exit;
    end;
    realObj := TCustomMemoryStream(obj);
    // Check attribute
    Result := TCustomMemoryStream_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomMemoryStream_WriteAttribute( Self : TCustomMemoryStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Memory' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TStream_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TMemoryStream //////////////////

function TMemoryStream_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMemoryStream;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TMemoryStream.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMemoryStream.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMemoryStream_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMemoryStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMemoryStream) then begin
      ErrorWrongExpectedType( argSelf, 'TMemoryStream' );
      Exit;
    end;
    realObj := TMemoryStream(obj);
    // Check attribute
    Result := TMemoryStream_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TMemoryStream_ReadAttribute( Self : TMemoryStream; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TCustomMemoryStream_ReadAttribute( Self, argSelf, key );
  end;
end;

function TMemoryStream_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMemoryStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMemoryStream) then begin
      ErrorWrongExpectedType( argSelf, 'TMemoryStream' );
      Exit;
    end;
    realObj := TMemoryStream(obj);
    // Check attribute
    Result := TMemoryStream_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TMemoryStream_WriteAttribute( Self : TMemoryStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TCustomMemoryStream_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TStringStream //////////////////

function TStringStream_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyStringStream;
  argSelf : PPyObject;
  argAString : PChar;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Os:TStringStream.Create', [ @argSelf,
                  @argAString       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyStringStream.Create( string(argAString) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TStringStream_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStringStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStringStream) then begin
      ErrorWrongExpectedType( argSelf, 'TStringStream' );
      Exit;
    end;
    realObj := TStringStream(obj);
    // Check attribute
    Result := TStringStream_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TStringStream_ReadAttribute( Self : TStringStream; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'DataString' ) = 0 then Result := VariantAsPyObject( Self.DataString )
    else Result := TStream_ReadAttribute( Self, argSelf, key );
  end;
end;

function TStringStream_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStringStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStringStream) then begin
      ErrorWrongExpectedType( argSelf, 'TStringStream' );
      Exit;
    end;
    realObj := TStringStream(obj);
    // Check attribute
    Result := TStringStream_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TStringStream_WriteAttribute( Self : TStringStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'DataString' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TStream_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TResourceStream //////////////////

function TResourceStream_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyResourceStream;
  argSelf : PPyObject;
  argInstance : Integer;
  argResName : PChar;
  argResType : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OisO:TResourceStream.Create', [ @argSelf,
                  @argInstance,
                  @argResName,
                  @argResType       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyResourceStream.Create( THandle(argInstance), string(argResName), nil );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TResourceStream_CreateFromID( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyResourceStream;
  argSelf : PPyObject;
  argInstance : Integer;
  argResID : Integer;
  argResType : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OiiO:TResourceStream.CreateFromID', [ @argSelf,
                  @argInstance,
                  @argResID,
                  @argResType       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyResourceStream.CreateFromID( THandle(argInstance), Integer(argResID), nil );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TResourceStream_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TResourceStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TResourceStream) then begin
      ErrorWrongExpectedType( argSelf, 'TResourceStream' );
      Exit;
    end;
    realObj := TResourceStream(obj);
    // Check attribute
    Result := TResourceStream_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TResourceStream_ReadAttribute( Self : TResourceStream; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TCustomMemoryStream_ReadAttribute( Self, argSelf, key );
  end;
end;

function TResourceStream_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TResourceStream;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TResourceStream) then begin
      ErrorWrongExpectedType( argSelf, 'TResourceStream' );
      Exit;
    end;
    realObj := TResourceStream(obj);
    // Check attribute
    Result := TResourceStream_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TResourceStream_WriteAttribute( Self : TResourceStream; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TCustomMemoryStream_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TStreamAdapter //////////////////

function TStreamAdapter_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyStreamAdapter;
  argSelf : PPyObject;
  argStream : PPyObject;
  objStream : TStream;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TStreamAdapter.Create', [ @argSelf,
                  @argStream       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objStream := GetObjectOf( argStream ) as TStream;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyStreamAdapter.Create( objStream );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TStreamAdapter_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStreamAdapter;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStreamAdapter) then begin
      ErrorWrongExpectedType( argSelf, 'TStreamAdapter' );
      Exit;
    end;
    realObj := TStreamAdapter(obj);
    // Check attribute
    Result := TStreamAdapter_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TStreamAdapter_ReadAttribute( Self : TStreamAdapter; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TInterfacedObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TStreamAdapter_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStreamAdapter;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStreamAdapter) then begin
      ErrorWrongExpectedType( argSelf, 'TStreamAdapter' );
      Exit;
    end;
    realObj := TStreamAdapter(obj);
    // Check attribute
    Result := TStreamAdapter_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TStreamAdapter_WriteAttribute( Self : TStreamAdapter; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TInterfacedObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TFiler //////////////////

function TFiler_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyFiler;
  argSelf : PPyObject;
  argStream : PPyObject;
  objStream : TStream;
  argBufSize : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OOi:TFiler.Create', [ @argSelf,
                  @argStream,
                  @argBufSize       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objStream := GetObjectOf( argStream ) as TStream;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyFiler.Create( objStream, Integer(argBufSize) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TFiler_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TFiler;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TFiler) then begin
      ErrorWrongExpectedType( argSelf, 'TFiler' );
      Exit;
    end;
    realObj := TFiler(obj);
    // Check attribute
    Result := TFiler_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TFiler_ReadAttribute( Self : TFiler; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Root' ) = 0 then Result := GetPythonObject( Self.Root, 'Classes', 'TComponent' )
    else if CompareText( key, 'Ancestor' ) = 0 then Result := GetPythonObject( Self.Ancestor, 'Classes', 'TPersistent' )
    else if CompareText( key, 'IgnoreChildren' ) = 0 then Result := VariantAsPyObject( Self.IgnoreChildren )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TFiler_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TFiler;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TFiler) then begin
      ErrorWrongExpectedType( argSelf, 'TFiler' );
      Exit;
    end;
    realObj := TFiler(obj);
    // Check attribute
    Result := TFiler_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TFiler_WriteAttribute( Self : TFiler; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Root' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TComponent then begin
        Self.Root := TComponent( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Root', 'TComponent' );
    end else if CompareText( key, 'Ancestor' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPersistent then begin
        Self.Ancestor := TPersistent( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Ancestor', 'TPersistent' );
    end else if CompareText( key, 'IgnoreChildren' ) = 0 then begin
      Self.IgnoreChildren := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TReader //////////////////

function TReader_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyReader;
  argSelf : PPyObject;
  argStream : PPyObject;
  objStream : TStream;
  argBufSize : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OOi:TReader.Create', [ @argSelf,
                  @argStream,
                  @argBufSize       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objStream := GetObjectOf( argStream ) as TStream;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyReader.Create( objStream, Integer(argBufSize) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TReader_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TReader;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TReader) then begin
      ErrorWrongExpectedType( argSelf, 'TReader' );
      Exit;
    end;
    realObj := TReader(obj);
    // Check attribute
    Result := TReader_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TReader_ReadAttribute( Self : TReader; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Owner' ) = 0 then Result := GetPythonObject( Self.Owner, 'Classes', 'TComponent' )
    else if CompareText( key, 'Parent' ) = 0 then Result := GetPythonObject( Self.Parent, 'Classes', 'TComponent' )
    else if CompareText( key, 'Position' ) = 0 then Result := VariantAsPyObject( Self.Position )
    else if CompareText( key, 'OnError' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TReaderError' ); Result := nil; end
    else if CompareText( key, 'OnFindMethod' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TFindMethodEvent' ); Result := nil; end
    else if CompareText( key, 'OnSetName' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TSetNameEvent' ); Result := nil; end
    else if CompareText( key, 'OnReferenceName' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TReferenceNameEvent' ); Result := nil; end
    else if CompareText( key, 'OnAncestorNotFound' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TAncestorNotFoundEvent' ); Result := nil; end
    else Result := TFiler_ReadAttribute( Self, argSelf, key );
  end;
end;

function TReader_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TReader;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TReader) then begin
      ErrorWrongExpectedType( argSelf, 'TReader' );
      Exit;
    end;
    realObj := TReader(obj);
    // Check attribute
    Result := TReader_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TReader_WriteAttribute( Self : TReader; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Owner' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TComponent then begin
        Self.Owner := TComponent( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Owner', 'TComponent' );
    end else if CompareText( key, 'Parent' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TComponent then begin
        Self.Parent := TComponent( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Parent', 'TComponent' );
    end else if CompareText( key, 'Position' ) = 0 then begin
      Self.Position := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnError' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnError := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyReader then
          with TPyReader(Self) do
            OnError := EventOnError;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnFindMethod' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnFindMethod := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyReader then
          with TPyReader(Self) do
            OnFindMethod := EventOnFindMethod;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnSetName' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnSetName := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyReader then
          with TPyReader(Self) do
            OnSetName := EventOnSetName;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnReferenceName' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnReferenceName := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyReader then
          with TPyReader(Self) do
            OnReferenceName := EventOnReferenceName;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnAncestorNotFound' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnAncestorNotFound := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyReader then
          with TPyReader(Self) do
            OnAncestorNotFound := EventOnAncestorNotFound;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TFiler_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TWriter //////////////////

function TWriter_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyWriter;
  argSelf : PPyObject;
  argStream : PPyObject;
  objStream : TStream;
  argBufSize : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OOi:TWriter.Create', [ @argSelf,
                  @argStream,
                  @argBufSize       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objStream := GetObjectOf( argStream ) as TStream;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyWriter.Create( objStream, Integer(argBufSize) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TWriter_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TWriter;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TWriter) then begin
      ErrorWrongExpectedType( argSelf, 'TWriter' );
      Exit;
    end;
    realObj := TWriter(obj);
    // Check attribute
    Result := TWriter_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TWriter_ReadAttribute( Self : TWriter; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Position' ) = 0 then Result := VariantAsPyObject( Self.Position )
    else if CompareText( key, 'RootAncestor' ) = 0 then Result := GetPythonObject( Self.RootAncestor, 'Classes', 'TComponent' )
    else Result := TFiler_ReadAttribute( Self, argSelf, key );
  end;
end;

function TWriter_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TWriter;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TWriter) then begin
      ErrorWrongExpectedType( argSelf, 'TWriter' );
      Exit;
    end;
    realObj := TWriter(obj);
    // Check attribute
    Result := TWriter_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TWriter_WriteAttribute( Self : TWriter; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Position' ) = 0 then begin
      Self.Position := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'RootAncestor' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TComponent then begin
        Self.RootAncestor := TComponent( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'RootAncestor', 'TComponent' );
    end else Result := TFiler_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TParser //////////////////

function TParser_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyParser;
  argSelf : PPyObject;
  argStream : PPyObject;
  objStream : TStream;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TParser.Create', [ @argSelf,
                  @argStream       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objStream := GetObjectOf( argStream ) as TStream;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyParser.Create( objStream );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TParser_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TParser;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TParser) then begin
      ErrorWrongExpectedType( argSelf, 'TParser' );
      Exit;
    end;
    realObj := TParser(obj);
    // Check attribute
    Result := TParser_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TParser_ReadAttribute( Self : TParser; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'SourceLine' ) = 0 then Result := VariantAsPyObject( Self.SourceLine )
    else if CompareText( key, 'Token' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'Char' ); Result := nil; end
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TParser_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TParser;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TParser) then begin
      ErrorWrongExpectedType( argSelf, 'TParser' );
      Exit;
    end;
    realObj := TParser(obj);
    // Check attribute
    Result := TParser_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TParser_WriteAttribute( Self : TParser; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'SourceLine' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Token' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TThread //////////////////

function TThread_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyThread;
  argSelf : PPyObject;
  argCreateSuspended : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TThread.Create', [ @argSelf,
                  @argCreateSuspended       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyThread.Create( Boolean(argCreateSuspended) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TThread_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TThread;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TThread) then begin
      ErrorWrongExpectedType( argSelf, 'TThread' );
      Exit;
    end;
    realObj := TThread(obj);
    // Check attribute
    Result := TThread_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TThread_ReadAttribute( Self : TThread; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'FreeOnTerminate' ) = 0 then Result := VariantAsPyObject( Self.FreeOnTerminate )
    else if CompareText( key, 'Handle' ) = 0 then Result := VariantAsPyObject( Self.Handle )
    else if CompareText( key, 'Priority' ) = 0 then Result := VariantAsPyObject( Integer( Self.Priority ) )
    else if CompareText( key, 'Suspended' ) = 0 then Result := VariantAsPyObject( Self.Suspended )
    else if CompareText( key, 'ThreadID' ) = 0 then Result := VariantAsPyObject( Self.ThreadID )
    else if CompareText( key, 'OnTerminate' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TThread_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TThread;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TThread) then begin
      ErrorWrongExpectedType( argSelf, 'TThread' );
      Exit;
    end;
    realObj := TThread(obj);
    // Check attribute
    Result := TThread_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TThread_WriteAttribute( Self : TThread; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'FreeOnTerminate' ) = 0 then begin
      Self.FreeOnTerminate := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Priority' ) = 0 then begin
      Self.Priority := TThreadPriority(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Suspended' ) = 0 then begin
      Self.Suspended := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ThreadID' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'OnTerminate' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnTerminate := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyThread then
          with TPyThread(Self) do
            OnTerminate := EventOnTerminate;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TComponent //////////////////

function TComponent_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyComponent;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TComponent.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyComponent.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TComponent_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TComponent;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TComponent) then begin
      ErrorWrongExpectedType( argSelf, 'TComponent' );
      Exit;
    end;
    realObj := TComponent(obj);
    // Check attribute
    Result := TComponent_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TComponent_ReadAttribute( Self : TComponent; argSelf : PPyObject; key : PChar ) : PPyObject;
var
  tmpComponentState : TComponentState;
  tmpComponentStyle : TComponentStyle;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'ComObject' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'IUnknown' ); Result := nil; end
    else if CompareText( key, 'ComponentCount' ) = 0 then Result := VariantAsPyObject( Self.ComponentCount )
    else if CompareText( key, 'ComponentIndex' ) = 0 then Result := VariantAsPyObject( Self.ComponentIndex )
    else if CompareText( key, 'ComponentState' ) = 0 then begin
      tmpComponentState := Self.ComponentState;
      Result := SetToList( @tmpComponentState, sizeof(tmpComponentState) )
    end
    else if CompareText( key, 'ComponentStyle' ) = 0 then begin
      tmpComponentStyle := Self.ComponentStyle;
      Result := SetToList( @tmpComponentStyle, sizeof(tmpComponentStyle) )
    end
    else if CompareText( key, 'DesignInfo' ) = 0 then Result := VariantAsPyObject( Self.DesignInfo )
    else if CompareText( key, 'Owner' ) = 0 then Result := GetPythonObject( Self.Owner, 'Classes', 'TComponent' )
    else if CompareText( key, 'VCLComObject' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'Pointer' ); Result := nil; end
    else if CompareText( key, 'Name' ) = 0 then Result := VariantAsPyObject( Self.Name )
    else if CompareText( key, 'Tag' ) = 0 then Result := VariantAsPyObject( Self.Tag )
    else Result := TPersistent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TComponent_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TComponent;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TComponent) then begin
      ErrorWrongExpectedType( argSelf, 'TComponent' );
      Exit;
    end;
    realObj := TComponent(obj);
    // Check attribute
    Result := TComponent_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TComponent_WriteAttribute( Self : TComponent; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
  tmpComponentState : TComponentState;
  tmpComponentStyle : TComponentStyle;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'ComObject' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ComponentCount' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ComponentIndex' ) = 0 then begin
      Self.ComponentIndex := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ComponentState' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ComponentStyle' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'DesignInfo' ) = 0 then begin
      Self.DesignInfo := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Owner' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'VCLComObject' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'Pointer' );
    end else if CompareText( key, 'Name' ) = 0 then begin
      Self.Name := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Tag' ) = 0 then begin
      Self.Tag := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TPersistent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Initialization of the module ///////////

procedure TModule_Classes.Initialize;
begin
  AddMethod( 'CreateList', TList_Create, '' );
  AddMethod( 'List_GetAttr', TList_GetAttr, '' );
  AddMethod( 'List_SetAttr', TList_SetAttr, '' );
  AddMethod( 'CreateThreadList', TThreadList_Create, '' );
  AddMethod( 'ThreadList_GetAttr', TThreadList_GetAttr, '' );
  AddMethod( 'ThreadList_SetAttr', TThreadList_SetAttr, '' );
  AddMethod( 'CreateBits', TBits_Create, '' );
  AddMethod( 'Bits_GetAttr', TBits_GetAttr, '' );
  AddMethod( 'Bits_SetAttr', TBits_SetAttr, '' );
  AddMethod( 'CreatePersistent', TPersistent_Create, '' );
  AddMethod( 'Persistent_GetAttr', TPersistent_GetAttr, '' );
  AddMethod( 'Persistent_SetAttr', TPersistent_SetAttr, '' );
  AddMethod( 'CreateCollectionItem', TCollectionItem_Create, '' );
  AddMethod( 'CollectionItem_GetAttr', TCollectionItem_GetAttr, '' );
  AddMethod( 'CollectionItem_SetAttr', TCollectionItem_SetAttr, '' );
  AddMethod( 'CreateCollection', TCollection_Create, '' );
  AddMethod( 'Collection_GetAttr', TCollection_GetAttr, '' );
  AddMethod( 'Collection_SetAttr', TCollection_SetAttr, '' );
  AddMethod( 'CreateStrings', TStrings_Create, '' );
  AddMethod( 'Strings_GetAttr', TStrings_GetAttr, '' );
  AddMethod( 'Strings_SetAttr', TStrings_SetAttr, '' );
  AddMethod( 'CreateStringList', TStringList_Create, '' );
  AddMethod( 'StringList_GetAttr', TStringList_GetAttr, '' );
  AddMethod( 'StringList_SetAttr', TStringList_SetAttr, '' );
  AddMethod( 'CreateStream', TStream_Create, '' );
  AddMethod( 'Stream_GetAttr', TStream_GetAttr, '' );
  AddMethod( 'Stream_SetAttr', TStream_SetAttr, '' );
  AddMethod( 'CreateHandleStream', THandleStream_Create, '' );
  AddMethod( 'HandleStream_GetAttr', THandleStream_GetAttr, '' );
  AddMethod( 'HandleStream_SetAttr', THandleStream_SetAttr, '' );
  AddMethod( 'CreateFileStream', TFileStream_Create, '' );
  AddMethod( 'FileStream_GetAttr', TFileStream_GetAttr, '' );
  AddMethod( 'FileStream_SetAttr', TFileStream_SetAttr, '' );
  AddMethod( 'CreateCustomMemoryStream', TCustomMemoryStream_Create, '' );
  AddMethod( 'CustomMemoryStream_GetAttr', TCustomMemoryStream_GetAttr, '' );
  AddMethod( 'CustomMemoryStream_SetAttr', TCustomMemoryStream_SetAttr, '' );
  AddMethod( 'CreateMemoryStream', TMemoryStream_Create, '' );
  AddMethod( 'MemoryStream_GetAttr', TMemoryStream_GetAttr, '' );
  AddMethod( 'MemoryStream_SetAttr', TMemoryStream_SetAttr, '' );
  AddMethod( 'CreateStringStream', TStringStream_Create, '' );
  AddMethod( 'StringStream_GetAttr', TStringStream_GetAttr, '' );
  AddMethod( 'StringStream_SetAttr', TStringStream_SetAttr, '' );
  AddMethod( 'CreateResourceStream', TResourceStream_Create, '' );
  AddMethod( 'CreateFromIDResourceStream', TResourceStream_CreateFromID, '' );
  AddMethod( 'ResourceStream_GetAttr', TResourceStream_GetAttr, '' );
  AddMethod( 'ResourceStream_SetAttr', TResourceStream_SetAttr, '' );
  AddMethod( 'CreateStreamAdapter', TStreamAdapter_Create, '' );
  AddMethod( 'StreamAdapter_GetAttr', TStreamAdapter_GetAttr, '' );
  AddMethod( 'StreamAdapter_SetAttr', TStreamAdapter_SetAttr, '' );
  AddMethod( 'CreateFiler', TFiler_Create, '' );
  AddMethod( 'Filer_GetAttr', TFiler_GetAttr, '' );
  AddMethod( 'Filer_SetAttr', TFiler_SetAttr, '' );
  AddMethod( 'CreateReader', TReader_Create, '' );
  AddMethod( 'Reader_GetAttr', TReader_GetAttr, '' );
  AddMethod( 'Reader_SetAttr', TReader_SetAttr, '' );
  AddMethod( 'CreateWriter', TWriter_Create, '' );
  AddMethod( 'Writer_GetAttr', TWriter_GetAttr, '' );
  AddMethod( 'Writer_SetAttr', TWriter_SetAttr, '' );
  AddMethod( 'CreateParser', TParser_Create, '' );
  AddMethod( 'Parser_GetAttr', TParser_GetAttr, '' );
  AddMethod( 'Parser_SetAttr', TParser_SetAttr, '' );
  AddMethod( 'CreateThread', TThread_Create, '' );
  AddMethod( 'Thread_GetAttr', TThread_GetAttr, '' );
  AddMethod( 'Thread_SetAttr', TThread_SetAttr, '' );
  AddMethod( 'CreateComponent', TComponent_Create, '' );
  AddMethod( 'Component_GetAttr', TComponent_GetAttr, '' );
  AddMethod( 'Component_SetAttr', TComponent_SetAttr, '' );
  inherited;
end;

end.
