unit PythonGUIInputOutput;

(**************************************************************************)
(*                                                                        *)
(* Module: Unit 'PythonGUIInputOutput' Copyright (c) 1997                 *)
(*                                                                        *)
(*                                     Dr. Dietmar Budelsky               *)
(*                                     budelsky@ibs.bm.eunet.de           *)
(*                                     IBS Schillings GmbH & Co KG        *)
(*                                     Ein Unternehmen der KROHNE-Gruppe  *)
(*                                     Heisenbergstr. 18                  *)
(*                                     50169 Kerpen-Trnich               *)
(*                                     Phone: (49)22 37/97 44-0           *)
(*                                                                        *)
(*                                     Morgan Martinet                    *)
(*                                     23 rue du 14 juillet               *)
(*                                     94270 le Kremlin-Bicetre           *)
(*                                     Phone (Work): 01 47 25 70 77       *)
(*                                     e-mail: mmm@imaginet.fr            *)
(*                                                                        *)
(*  look our page at: http://www.imaginet.fr/~mmm/python.html             *)
(**************************************************************************)
(*  Functionality:  Delphi Components that provide an interface to the    *)
(*                  Python language (see python.txt for more infos on     *)
(*                  Python itself).                                       *)
(*                                                                        *)
(**************************************************************************)
(*  Contributors:                                                         *)
(*      Mark Watts(mark_watts@hotmail.com)                                *)
(**************************************************************************)
(* This source code is distributed with no WARRANTY, for no reason or use.*)
(* Everyone is allowed to use and change this code free for his own tasks *)
(* and projects, as long as this header and its copyright text is intact. *)
(* For changed versions of this code, which are public distributed the    *)
(* following additional conditions have to be fullfilled:                 *)
(* 1) The header has to contain a comment on the change and the author of *)
(*    it.                                                                 *)
(* 2) A copy of the changed source has to be sent to the above E-Mail     *)
(*    address or my then valid address, if this is possible to the        *)
(*    author.                                                             *)
(* The second condition has the target to maintain an up to date central  *)
(* version of the component. If this condition is not acceptable for      *)
(* confidential or legal reasons, everyone is free to derive a component  *)
(* or to generate a diff file to my or other original sources.            *)
(* Dr. Dietmar Budelsky, 1997-11-17                                       *)
(**************************************************************************)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, PythonEngine;

const
  WM_WriteOutput = WM_USER + 1;

type
  TPythonGUIInputOutput = class(TPythonInputOutput)
  private
    { Private declarations }
    FRichEdit : TRichEdit;
    FWinHandle : HWND;
  protected
    { Protected declarations }
    procedure pyGUIOutputWndProc (var Message: TMessage);
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure SendData( const Data : String ); override;
    function  ReceiveData : String; override;
    procedure AddPendingWrite; override;
    procedure WriteOutput;
  public
    { Public declarations }
    constructor Create( AOwner : TComponent ); override;
    destructor  Destroy; override;

    procedure DisplayString( const str : String );

  published
    { Published declarations }
    property Output : TRichEdit read FRichEdit write FRichEdit;
  end;

procedure Register;

implementation

{PROTECTED METHODS}

{------------------------------------------------------------------------------}
procedure TPythonGUIInputOutput.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if Operation = opRemove then
    if aComponent = fRichEdit then
      fRichEdit := nil;
end;

{------------------------------------------------------------------------------}
procedure TPythonGUIInputOutput.pyGUIOutputWndProc(var Message: TMessage);
begin
  case Message.Msg of
    WM_WriteOutput : WriteOutput;
  end;{case}
end;

{------------------------------------------------------------------------------}
procedure TPythonGUIInputOutput.SendData( const Data : String );
begin
  if Assigned(FOnSendData) then
    inherited
  else
    DisplayString( Data );
end;

{------------------------------------------------------------------------------}
function  TPythonGUIInputOutput.ReceiveData : String;
begin
  if Assigned( FOnReceiveData ) then
    Result := inherited ReceiveData
  else
    InputQuery( 'Query for Python', 'Enter text', Result);
end;

{------------------------------------------------------------------------------}
procedure TPythonGUIInputOutput.AddPendingWrite;
begin
  PostMessage( fWinHandle, WM_WriteOutput, 0, 0 );
end;

{------------------------------------------------------------------------------}
procedure TPythonGUIInputOutput.WriteOutput;
var
  s : String;
begin
  if FQueue.Count = 0 then
    Exit;
  s := FQueue.Strings[ 0 ];
  FQueue.Delete(0);
  SendData( s );
end;

{PUBLIC METHODS}

{------------------------------------------------------------------------------}
constructor TPythonGUIInputOutput.Create( AOwner : TComponent );
begin
  inherited Create(AOwner);
  // Create an internal window for use in delayed writes
  // This will allow writes from multiple threads to be queue up and
  // then written out to the associated TRichEdit by the main UI thread.
  fWinHandle := AllocateHWnd(pyGUIOutputWndProc);
end;

{------------------------------------------------------------------------------}
destructor TPythonGUIInputOutput.Destroy;
begin
  // Destroy the internal window used for Delayed write operations
  DeallocateHWnd(fWinHandle);
  inherited Destroy;
end;

{------------------------------------------------------------------------------}
procedure TPythonGUIInputOutput.DisplayString( const str : String );
begin
  if Assigned(Output) then
  begin
    if Output.Lines.Count >= MaxLines then
      Output.Lines.Delete(0);
    Output.Lines.Add(str);
    SendMessage( Output.Handle, em_ScrollCaret, 0, 0);
  end;{if}
end;

{------------------------------------------------------------------------------}
procedure Register;
begin
  RegisterComponents('Python', [TPythonGUIInputOutput]);
end;

end.