/* ClassAccessorImpl.java */
/* Chris Jacobi, October 23, 1997 2:40 pm PDT */

/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: ClassAccessorImpl.java,v 1.3 1997/10/24 20:09:00 jacobi Exp $ */

/*
create jar file like
cd classes
jar cv0f ../MyJarFile.jar *
cd ..

compile
javac -d classes ClassAccessorImpl.java

run
java xerox.javaSerialObjects.ClassAccessorImpl

*/


package xerox.javaSerialObjects;

public class ClassAccessorImpl 
    implements xerox.javaSerialObjects.ClassAccessor {

    static final char separatorChar = '/';
    static boolean debug = true;
    
    java.lang.String path = null;
    
    public ClassAccessorImpl(java.lang.String path) {
        this.path = path;
    }
    
    public byte[] GetBytes(java.lang.String classname)
        throws xerox.javaSerialObjects.notFound, xerox.ilu.IluSystemException
    {
        java.lang.String entryName = 
            classname.replace('.', separatorChar) + ".class";
        java.lang.String pathRest = this.path;
        while (pathRest != null) {
            //loop through the filenames found on the path variable
            java.lang.String thisName
                = xerox.basics.Environment.toColon(pathRest).trim();
            try {
                if (debug) {
                    System.out.println("Check [" + thisName + "]");
                }
                java.util.zip.ZipFile zf = new java.util.zip.ZipFile(thisName);
                if  (zf != null) {
                    java.util.zip.ZipEntry ze = zf.getEntry(entryName);
                    if  (ze != null) {
                        java.io.InputStream is = zf.getInputStream(ze);
                        long sizeLong = ze.getSize();
                        int sizeInt = (int) sizeLong;
                        if  ((sizeLong == (long) sizeInt) && (sizeInt > 0)) {
                            byte[] b = new byte[sizeInt];
                            int didRead = is.read(b, 0, sizeInt);
                            if (didRead == sizeInt) {
                                is.close();
                                zf.close();
                                if (debug) {
                                    System.out.println(
                                    "Successfully accessed " + classname
                                    );
                                }
                                return b;
                            }
                        }
                        is.close();
                    }
                    zf.close();
                }
            } catch (java.io.IOException e) {
                //try next entry on path
                if (debug) {
                    System.out.println(
                        "exception while accessing [" + thisName + "]: " + e
                        );
                    e.printStackTrace();
                }
            }
        pathRest = xerox.basics.Environment.fromColon(pathRest);
        }
        throw new xerox.javaSerialObjects.notFound("not available");
    } // GetBytes
     
    /** main is only used to debug ClassAccessorImpl */
    public static void main(String argv[]) {
        System.out.println("Start ClassAccessorImpl.main");
        byte[] b = null;
        ClassAccessorImpl ai = new ClassAccessorImpl(
            "YourJarFile.jar:MyJarFile.jar"
            );
        try {
            b = ai.GetBytes("xerox.javaSerialObjects.ClassAccessorImpl");
        } catch (xerox.javaSerialObjects.notFound e) {
            System.out.println("Exception " + e);
            e.printStackTrace();
        }
        System.out.println("Done ClassAccessorImpl.main; got " + b);
    } //main
        
} //ClassAccessorImpl


