(* $Id: javaSerialObjects.isl,v 1.2 1997/10/24 20:09:00 jacobi Exp $ *)
(* Last edited by Chris Jacobi, October 23, 1997 2:44 pm PDT *)

INTERFACE javaSerialObjects;

TYPE JavaObject = OPTIONAL ObjectState;

TYPE ObjectState =               (* Represents non null java.lang.Object *)
  RECORD
    sb: ObjectBytes,             (* State of this java.lang.Object instance *)
    accessor: ClassAccessor      (* Accessing referenced classes  *)
  END;

TYPE ObjectBytes =               (* The serialized object instance *)
  SEQUENCE OF BYTE;

TYPE ClassBytes =                (* The bytecodes for a class *)
  SEQUENCE OF BYTE;

TYPE String =                    (* Unicode *)
  SEQUENCE OF CHARACTER;

EXCEPTION notFound: String;      (* "class"  (bytecodes) not found *)   

TYPE ClassAccessor =             (* ...input for class loader *)
  OBJECT OPTIONAL 
    DOCUMENTATION "Accessing the bytecodes of the class"
    METHODS
      GetBytes(classname: String): ClassBytes RAISES notFound END
    END;
