NAME
    RISCOS::BBox -- functions to compute relationships between
    bounding boxes

SYNOPSIS
        use RISCOS::BBox qw(union intersect);
        @bbox = union (\@thing, \@other);
        @problems = intersect \@dinsdale, \@plan, \@other_plan, \@other_other_plan


DESCRIPTION
    This module provides functions to compute relationships between
    rectangular bounding boxes, which are always passed as
    references to four value arrays. They are primarily of use when
    processing Drawfiles with `Do' or `Change'

  union

    `union' returns the union of the bounding boxes passed to it as
    array references. In scalar context it returns a reference to
    the union bounding box array, in array context the array itself.

  Spatial Relationships

    All other subroutines are identical in calling conventions. The
    first argument is a box to test against, and all other arguments
    generate true or false values if they match or fail the named
    criterion. In scalar context only the second argument is checked
    against the reference, in array context a list of true/false
    corresponding to the arguments is returned

    intersect
        True if the bounding box intersects the reference box. False
        if the bounding box is entirely within or outside the
        reference, or touches it without crossing it.

    intersect_or_touching
        True if the bounding box intersects or touches the reference
        box.

    inside
        True if the bounding box is entirely inside the reference
        box (without touching).

    inside_or_touching
        True if no part of the bounding box is outside the reference
        box.

    outside
        True if the bounding box is entirely outside the reference
        box (without touching).


BUGS
    Not tested enough yet.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

