/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    Cursor cursor;
    int lastCursor;
    int window;
    boolean tracking;
    boolean cancelled;
    boolean grabbed;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n) {
        super(composite, Tracker.checkStyle(n));
        this.parent = composite;
    }

    public Tracker(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n);
        this.display = display;
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = this.bounds.x + this.bounds.width / 2;
        int n2 = this.bounds.y;
        Point point = this.display.map(this.parent, null, n, n2);
        this.display.setCursorLocation(point);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gdk_window_get_pointer(this.window, nArray, nArray2, nArray3);
        return new Point(nArray[0], nArray2[0]);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n2 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        Point point = this.display.map(this.parent, null, n, n2);
        this.display.setCursorLocation(point);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gdk_window_get_pointer(this.window, nArray, nArray2, nArray3);
        return new Point(nArray[0], nArray2[0]);
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    static int checkStyle(int n) {
        if ((n & 0x24480) == 0) {
            n |= 0x24480;
        }
        return n;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n = this.rectangles[0].x;
        int n2 = this.rectangles[0].y;
        int n3 = this.rectangles[0].x + this.rectangles[0].width;
        int n4 = this.rectangles[0].y + this.rectangles[0].height;
        int n5 = 1;
        while (n5 < this.rectangles.length) {
            int n6;
            int n7;
            if (this.rectangles[n5].x < n) {
                n = this.rectangles[n5].x;
            }
            if (this.rectangles[n5].y < n2) {
                n2 = this.rectangles[n5].y;
            }
            if ((n7 = this.rectangles[n5].x + this.rectangles[n5].width) > n3) {
                n3 = n7;
            }
            if ((n6 = this.rectangles[n5].y + this.rectangles[n5].height) > n4) {
                n4 = n6;
            }
            ++n5;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int n = 0;
            while (n < rectangleArray.length) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (this.bounds.width != 0) {
                    n2 = (rectangleArray[n].x - this.bounds.x) * 100 / this.bounds.width;
                    n4 = rectangleArray[n].width * 100 / this.bounds.width;
                } else {
                    n4 = 100;
                }
                if (this.bounds.height != 0) {
                    n3 = (rectangleArray[n].y - this.bounds.y) * 100 / this.bounds.height;
                    n5 = rectangleArray[n].height * 100 / this.bounds.height;
                } else {
                    n5 = 100;
                }
                rectangleArray2[n] = new Rectangle(n2, n3, n4, n5);
                ++n;
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(Rectangle[] rectangleArray) {
        int n = OS.GDK_ROOT_PARENT();
        if (this.parent != null) {
            n = OS.GTK_WIDGET_WINDOW(this.parent.paintHandle());
        }
        if (n == 0) {
            return;
        }
        int n2 = OS.gdk_gc_new(n);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.gdk_colormap_get_system();
        GdkColor gdkColor = new GdkColor();
        OS.gdk_color_white(n3, gdkColor);
        OS.gdk_gc_set_foreground(n2, gdkColor);
        OS.gdk_gc_set_subwindow(n2, 1);
        OS.gdk_gc_set_function(n2, 2);
        int n4 = 0;
        while (n4 < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n4];
            int n5 = rectangle.x;
            if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
                n5 = this.parent.getClientWidth() - rectangle.width - n5;
            }
            OS.gdk_draw_rectangle(n, n2, 0, n5, rectangle.y, rectangle.width, rectangle.height);
            ++n4;
        }
        OS.g_object_unref(n2);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        int n = 0;
        while (n < this.rectangles.length) {
            Rectangle rectangle = this.rectangles[n];
            rectangleArray[n] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n;
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    boolean grab() {
        int n = this.cursor != null ? this.cursor.handle : 0;
        int n2 = OS.gdk_pointer_grab(this.window, false, 516, this.window, n, 0);
        return n2 == 0;
    }

    int gtk_button_release_event(int n, int n2) {
        return this.gtk_mouse(7, n, n2);
    }

    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        int n4 = (gdkEventKey.state & 4) != 0 ? 1 : 9;
        int n5 = 0;
        int n6 = 0;
        switch (gdkEventKey.keyval) {
            case 65307: {
                this.cancelled = true;
            }
            case 65293: {
                this.tracking = false;
                break;
            }
            case 65361: {
                n5 = -n4;
                break;
            }
            case 65363: {
                n5 = n4;
                break;
            }
            case 65362: {
                n6 = -n4;
                break;
            }
            case 65364: {
                n6 = n4;
            }
        }
        if (n5 != 0 || n6 != 0) {
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            int n7 = 0;
            while (n7 < this.rectangles.length) {
                Rectangle rectangle = this.rectangles[n7];
                rectangleArray2[n7] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n7;
            }
            Event event = new Event();
            event.x = this.oldX + n5;
            event.y = this.oldY + n6;
            if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
                event.x = this.parent.getClientWidth() - event.width - event.x;
            }
            if ((this.style & 0x10) != 0) {
                Point point;
                this.resizeRectangles(n5, n6);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n8 = this.rectangles.length;
                    if (n8 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        int n9 = 0;
                        while (n9 < n8) {
                            if (!this.rectangles[n9].equals(rectangleArray2[n9])) {
                                bl = true;
                                break;
                            }
                            ++n9;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(rectangleArray2);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    this.oldX = point.x;
                    this.oldY = point.y;
                }
            } else {
                Point point;
                this.moveRectangles(n5, n6);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n10 = this.rectangles.length;
                    if (n10 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        int n11 = 0;
                        while (n11 < n10) {
                            if (!this.rectangles[n11].equals(rectangleArray2[n11])) {
                                bl = true;
                                break;
                            }
                            ++n11;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(rectangleArray2);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
                if ((point = this.adjustMoveCursor()) != null) {
                    this.oldX = point.x;
                    this.oldY = point.y;
                }
            }
        }
        return n3;
    }

    int gtk_motion_notify_event(int n, int n2) {
        int n3;
        int n4 = n3 = this.cursor != null ? this.cursor.handle : 0;
        if (n3 != this.lastCursor) {
            this.ungrab();
            this.grabbed = this.grab();
            this.lastCursor = n3;
        }
        return this.gtk_mouse(3, n, n2);
    }

    int gtk_mouse(int n, int n2, int n3) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_pointer(this.window, nArray, nArray2, null);
        if (this.oldX != nArray[0] || this.oldY != nArray2[0]) {
            SerializableCompatibility serializableCompatibility;
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            int n4 = 0;
            while (n4 < this.rectangles.length) {
                serializableCompatibility = this.rectangles[n4];
                rectangleArray2[n4] = new Rectangle(serializableCompatibility.x, serializableCompatibility.y, serializableCompatibility.width, serializableCompatibility.height);
                ++n4;
            }
            Event event = new Event();
            if (this.parent == null) {
                event.x = nArray[0];
                event.y = nArray2[0];
            } else {
                serializableCompatibility = this.display.map(this.parent, null, nArray[0], nArray2[0]);
                event.x = ((Point)serializableCompatibility).x;
                event.y = ((Point)serializableCompatibility).y;
            }
            if ((this.style & 0x10) != 0) {
                Point point;
                this.resizeRectangles(nArray[0] - this.oldX, nArray2[0] - this.oldY);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n5 = this.rectangles.length;
                    if (n5 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        int n6 = 0;
                        while (n6 < n5) {
                            if (!this.rectangles[n6].equals(rectangleArray2[n6])) {
                                bl = true;
                                break;
                            }
                            ++n6;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(rectangleArray2);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    nArray[0] = point.x;
                    nArray2[0] = point.y;
                }
            } else {
                this.moveRectangles(nArray[0] - this.oldX, nArray2[0] - this.oldY);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n7 = this.rectangles.length;
                    if (n7 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        int n8 = 0;
                        while (n8 < n7) {
                            if (!this.rectangles[n8].equals(rectangleArray2[n8])) {
                                bl = true;
                                break;
                            }
                            ++n8;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(rectangleArray2);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
            }
            this.oldX = nArray[0];
            this.oldY = nArray2[0];
        }
        this.tracking = n != 7;
        return 0;
    }

    void moveRectangles(int n, int n2) {
        if (this.bounds == null) {
            return;
        }
        if (n < 0 && (this.style & 0x4000) == 0) {
            n = 0;
        }
        if (n > 0 && (this.style & 0x20000) == 0) {
            n = 0;
        }
        if (n2 < 0 && (this.style & 0x80) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x400) == 0) {
            n2 = 0;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
            n *= -1;
        }
        this.bounds.x += n;
        this.bounds.y += n2;
        int n3 = 0;
        while (n3 < this.rectangles.length) {
            this.rectangles[n3].x += n;
            this.rectangles[n3].y += n2;
            ++n3;
        }
    }

    public boolean open() {
        Object object;
        int n;
        boolean bl;
        int n2;
        this.checkWidget();
        this.window = OS.GDK_ROOT_PARENT();
        if (this.parent != null) {
            this.window = OS.GTK_WIDGET_WINDOW(this.parent.paintHandle());
        }
        if (this.window == 0) {
            return false;
        }
        this.cancelled = false;
        this.tracking = true;
        this.update();
        this.drawRectangles(this.rectangles);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gdk_window_get_pointer(this.window, nArray, nArray2, nArray3);
        int n3 = this.style & 0x480;
        if (n3 == 128 || n3 == 1024) {
            this.cursorOrientation |= n3;
        }
        if ((n2 = this.style & 0x24000) == 16384 || n2 == 131072) {
            this.cursorOrientation |= n2;
        }
        boolean bl2 = bl = (nArray3[0] & (n = 1792)) != 0;
        if (!bl) {
            object = null;
            object = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
            if (object != null) {
                nArray[0] = ((Point)object).x;
                nArray2[0] = ((Point)object).y;
            }
        }
        this.oldX = nArray[0];
        this.oldY = nArray2[0];
        this.grabbed = this.grab();
        this.lastCursor = this.cursor != null ? this.cursor.handle : 0;
        object = new GdkEvent();
        while (this.tracking) {
            int n4;
            if (this.parent != null && this.parent.isDisposed()) break;
            while ((n4 = OS.gdk_event_get()) == 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            OS.memmove((GdkEvent)object, n4, GdkEvent.sizeof);
            int n5 = OS.gtk_get_event_widget(n4);
            switch (((GdkEvent)object).type) {
                case 3: {
                    this.gtk_motion_notify_event(n5, n4);
                    break;
                }
                case 7: {
                    this.gtk_button_release_event(n5, n4);
                    break;
                }
                case 8: {
                    this.gtk_key_press_event(n5, n4);
                    break;
                }
                case 9: {
                    this.gtk_key_release_event(n5, n4);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: {
                    break;
                }
                case 2: {
                    this.update();
                    this.drawRectangles(this.rectangles);
                    OS.gtk_main_do_event(n4);
                    this.drawRectangles(this.rectangles);
                    break;
                }
                default: {
                    OS.gtk_main_do_event(n4);
                }
            }
            OS.gdk_event_free(n4);
        }
        if (!this.isDisposed()) {
            this.update();
            this.drawRectangles(this.rectangles);
        }
        this.ungrab();
        this.window = 0;
        return !this.cancelled;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    void resizeRectangles(int n, int n2) {
        Rectangle rectangle;
        int n3;
        if (this.bounds == null) {
            return;
        }
        if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
            n *= -1;
        }
        if (n < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (n > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (n2 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (n2 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    n3 = 0;
                    while (n3 < this.proportions.length) {
                        rectangle = this.proportions[n3];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                        ++n3;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                n3 = 0;
                while (n3 < this.proportions.length) {
                    rectangle = this.proportions[n3];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                    ++n3;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n2 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n2 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    n3 = 0;
                    while (n3 < this.proportions.length) {
                        rectangle = this.proportions[n3];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                        ++n3;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n2) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n2 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                n3 = 0;
                while (n3 < this.proportions.length) {
                    rectangle = this.proportions[n3];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                    ++n3;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n;
            this.bounds.width -= n;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n2;
            this.bounds.height -= n2;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n2;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        int n4 = 0;
        while (n4 < this.rectangles.length) {
            Rectangle rectangle2 = this.proportions[n4];
            rectangleArray[n4] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
            ++n4;
        }
        this.rectangles = rectangleArray;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.cursor = cursor;
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        int n = rectangleArray.length;
        this.rectangles = new Rectangle[n];
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = rectangleArray[n2];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[n2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n2;
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl) {
        this.checkWidget();
        this.stippled = bl;
    }

    void ungrab() {
        if (this.grabbed) {
            OS.gdk_pointer_ungrab(0);
        }
    }

    void update() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
    }
}

