<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

class Note extends NoteAppModel{

	var $name = 'Note';
	var $useTable = 'T_NOTE';
	var $primaryKey = 'NOTE_ID';

	var $user;
	var $userID;
	var $noteID;

	var $belongsTo = array('User' =>
		array(
			'className'  => 'User',
			'fields'     => array('NAME'),
			'conditions' => '',
			'order'      => '',
			'dependent'  => true,
			'foreignKey' => 'USR_ID',
		),
	);

	var $status = array('1' => '公開', '0' => '下書き');
	var $default_public = array('All' => '全体公開', 'OnlyMe' => '自分のみ', 'Followed' => 'フォローされているユーザー');
	var $public;

	function saveNote($_data, $isEdit = false) {


		if(empty($this->userID)) {
			return false;
		}


		if($isEdit) {
			$_data['Note']['UPDATE_DATE'] = date("Y-m-d H:i:s");
		}
		else {
			if($_data['Note']['STATUS']) {
				//$this->postMessage();
			}

			$_data['Note']['USR_ID'] = $this->userID;
			$_data['Note']['INSERT_DATE'] = date("Y-m-d H:i:s");
			$_data['Note']['UPDATE_DATE'] = date("Y-m-d H:i:s");
		}

		if(isset($_data['Note']['STATUS']) && $_data['Note']['STATUS'] == 0) {
			$_data['Note']['PUBLIC'] = 'OnlyMe';
		}


		$this->save($_data);
		$_data['Note']['NOTE_ID'] = $this->id;
		$this->postMessage($_data);

	}

	function getNoteContent() {
		if(empty($this->noteID)) {
			return false;
		}else {
			return $this->find('first', array('conditions' => array('Note.NOTE_ID' => $this->noteID)));
		}

	}

	function setPublic() {
		$this->public = $this->default_public;

		App::import('Model','Group');
		App::import('Model','Join');
		$group = new Group();
		$join  = new Join();

		if(empty($this->userID)) {
			return false;
		}

		$result = $join->Join_Group($this->userID);
		$joinGroup = array();

		foreach($result as $key => $val) {
			array_push($joinGroup, $val['Join']['GRP_ID']);
		}

		$public = $group->find('all', array('fields' => array('Group.GRP_ID', 'Group.NAME'), 'conditions' => array('Group.GRP_ID' => $joinGroup)));

		foreach($public as $key => $val) {
			$this->public[$val['Group']['GRP_ID']] = $val['Group']['NAME'];
		}


	}

	function getPaginateCondition($action) {

		if($action == 'All') {
			App::import('Model','Friend');
			$friend = new Friend();

			//フォローしているユーザの取得
			$aryFriendId = array();
			$result = $friend->Get_Friend($this->userID);
			foreach ($result as $key => $val) {
				array_push($aryFriendId, $result['Friend']['F_USR_ID']);
			}
			array_push($aryFriendId, $this->userID);

			//所属グループ取得
			$aryGrpId = array();
			foreach ($this->public as $key => $val) {
				if(!in_array($val, $this->default_public)) array_push($aryGrpId, $key);
			}

			$conditions['or'][] = array('Note.PUBLIC' => 'All', 'Note.STATUS' => 1);
			$conditions['or'][] = array('Note.PUBLIC' => 'OnlyMe',   'Note.USR_ID' => $this->userID);
			$conditions['or'][] = array('Note.PUBLIC' => 'Followed', 'Note.USR_ID' => $aryFriendId, 'Note.STATUS' => 1);
			$conditions['or'][] = array('Note.PUBLIC' => $aryGrpId, 'Note.STATUS' => 1);

		}else {
			$conditions = array('Note.USR_ID' => $this->userID);
		}

		return $conditions;
	}

	function postMessage($_note, $_isEdit = false) {
		App::import('Model','Timeline');
		$timeline = new Timeline();

		$model = 'Note';
		$data['Timeline']['MESSAGE'] = "ノート「".$_note['Note']['TITLE']."」を公開しました。\n".Router::url(array('plugin' => 'note', 'controller' => 'note', 'action' => 'content', 'noteID' => $_note['Note']['NOTE_ID']), true);;

		return $timeline->Save_Message($model, $data, $this->user);

	}

	function checkInspectionAuth() {
		$this->userID;
		$this->noteID;

		$note = $this->find('first', array('conditions' => array('Note.NOTE_ID' => $this->noteID)));

		if(empty($note)) {
			return false;
		}
		//自分が作ったもの
		if($note['Note']['USR_ID'] == $this->userID) {
			return true;
		}

		//他人が作ったもの
		else {
			if($note['Note']['PUBLIC'] == 'All') {
				return true;
			}
			else if($note['Note']['PUBLIC'] == 'Followed') {
				App::import('Model','Friend');
				$friend = new Friend();

				//フォローしているユーザの取得
				$aryFriendId = array();
				$result = $friend->Get_Friend($this->userID);
				foreach ($result as $key => $val) {
					array_push($aryFriendId, $result['Friend']['F_USR_ID']);
				}

				return in_array($note['Note']['USR_ID'], $aryFriendId);

			}
			else if($note['Note']['PUBLIC'] == 'OnlyMe') {
				return false;
			}
			else {
				//所属グループ取得
				$aryGrpId = array();
				foreach ($this->public as $key => $val) {
					if(!in_array($val, $this->default_public)) array_push($aryGrpId, $key);
				}

				return in_array($note['Note']['PUBLIC'], $aryGrpId);
			}
		}

	}

}