<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

class NoteController extends NoteAppController {

	var $name = 'Note';
	var $uses = array('Note.Note', 'Join');
	var $autoLayout = true;
	var $components = array('Session','Auth','Cookie');

	public $paginate = array(
		'page' => 1,
		'conditions' => array(),
		'sort' => '',
		'limit' => 20,
		'order' => 'Note.UPDATE_DATE asc',
		'recursive' => 0
	);

	function beforeFilter(){
		parent::beforeFilter();
		//この2文を入れることにより、デフォルトのレイアウトのままでも動作する。
 		$route= Router::getInstance();
 		$route->__params[0]['plugin']=null;

		$user = $this->Auth->user();
		$this->Note->user = $user;
		$this->Note->userID = $user['User']['USR_ID'];
		$this->Note->setPublic();
		$this->set('status', $this->Note->status);
		$this->set('public', $this->Note->public);
		if(isset($this->params['named']['noteID'])) $this->Note->noteID = $this->params['named']['noteID'];
		if($this->action == 'index' && empty($this->params['named']['tab'])) $this->params['named']['tab'] = 'All';
	}

	function index() {
		$this->set('main_title', 'ノート機能');
		$this->set('title_text', 'ノート一覧');

		$this->paginate['conditions'] = $this->Note->getPaginateCondition($this->params['named']['tab']);
		$list = $this->paginate();
		$this->set('list', $list);
	}

	function add() {
		$this->set('main_title', 'ノート機能');
		$this->set('title_text', 'ノート作成');

		if(isset($this->data) && $this->data) {
			$this->Note->saveNote($this->data);
			$this->Session->setFlash('ノートを作成しました。');
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		}
	}

	function edit() {
		$this->set('main_title', 'ノート機能');
		$this->set('title_text', 'ノート作成');
		$this->autoRender = false;

		if(isset($this->data) && $this->data) {
			$this->Note->saveNote($this->data, true);
			$this->Session->setFlash('ノートを保存しました。');
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		} else {
			$this->data = $this->Note->getNoteContent();
		}

		$this->render('add');
	}

	function delete() {
		$this->autoRender = false;
		$this->Note->delete($this->Note->noteID);
		$this->Session->setFlash('ノートを削除しました。');
		$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
	}

	function content() {
		$this->set('main_title', 'ノート機能');
		$this->set('title_text', 'ノート内容');

		if(empty($this->Note->noteID)) {
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		}
		if(!$this->Note->checkInspectionAuth()) {
			$this->Session->setFlash('ノートを閲覧する権限がありません。');
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		}
		$this->set('note', $this->Note->getNoteContent());
	}

	function renderNoteContent() {
		$this->set('main_title', 'ノート機能');
		$this->set('title_text', 'ノート内容');
		$this->autoRender = false;

		if(empty($this->Note->noteID)) {
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		}

		$note = $this->Note->getNoteContent();
		if(empty($note)) {
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		}

		//TODO ヘッダー出力
		echo $note['Note']['CONTENT'];
	}
}