<?php
App::import('Core', 'Controller');
App::import('Component', 'Qdmail');
App::import('Component', 'Common');

class SummarymailShell extends Shell {
	var $uses = array('User', 'Administrator', 'Timeline', 'Friend', 'Configration');

	//サマリーメール送信希望ユーザーの取得（現在はUSR_IDが１のユーザーを取得）
	function getUsers(){
		//サマリーメールの設定を取得
		$summail_status = $this->Configration->find('first', array('conditions' => array('Configration.NAME' => 'SUMMAIL_STATUS')));
		if($summail_status['Configration']['VALUE'] == 0){		//送らない設定の場合
			$this->out('サマリーメール送信をしない設定です');
			return 0;
		}else{												//送る設定の場合、ユーザー取得
			//全ユーザー
 			$users = $this->User->find('all', array('conditions' => array('User.STATUS' => '1'),
 													'fields' => array('User.USR_ID', 'User.GRP_ID', 'User.NAME', 'User.MAIL')
 					));
			//ユーザーIDが1
//			$users = $this->User->find('all', array('conditions' => array('User.USR_ID' => '1'),
//													'fields' => array('User.USR_ID', 'User.GRP_ID', 'User.NAME', 'User.MAIL')
//					));
			//取得したユーザーを調べる
			if(empty($users)){		//取得したユーザーなしの場合
				$this->out('送信するユーザーがいません');
				return 0;
			}
			return $users;
		}
	}

	//タイムラインを取得する関数
	function getTimelines(){
		//サマリーメール送信希望ユーザーの取得
		//$today = date('Y-m-d');  $yesterday = date('Y-m-d', strtotime("-1 day", strtotime($today)));	//取得した日付を変数に入れる場合
		$users = $this->getUsers();
		//usersの値を調べる
		if($users){
 			$userstimeline = $users;
		}else{
			return 0;
		}
 		foreach($users as $key_user => $user){
			$timeline_limit = 5;
			$timeline_comments_limit = 5;

 			//タイムラインを取得する条件を記述（現在はフォローするユーザーのみ）
 			$conditions = array('conditions'=>
				 					array('AND' =>
				 							array('Timeline.USR_ID IN ( SELECT F_USR_ID FROM T_FRIEND WHERE USR_ID = '.$user['User']['USR_ID'].' )'),
				 							'OR' => array(array('Timeline.ACT_ID' => '1'), array('Timeline.ACT_ID' => '4')),
 											'Timeline.LAST_DATE BETWEEN ? AND ?' => array(date('Y-m-d H:i:s', strtotime('-24 hours')), date('Y-m-d H:i:s'))
				 							));
 			//タイムラインの件数を取得
 			$timeline_count = $this->Timeline->find('count', $conditions);
 			//タイムラインを取得
 			$timeline = $this->Timeline->find('all', array_merge($conditions,
 																	array('order' => 'Timeline.LAST_DATE DESC',
 																			'limit' => $timeline_limit,
 																			'fields' => array('Timeline.MESSAGE',
 																								'Timeline.ACT_ID',
 																								'Timeline.LAST_DATE',
 																								'Timeline.TML_ID',
 																								'User.NAME',
 																								'User.USR_ID'
 																		))));
 			//取得したタイムラインを結合
 			$userstimeline[$key_user] = array_merge($user['User'], array('TML_ALL' => $timeline,
 																			'TML_COUNT' => $timeline_count,
 																			'TML_LIMIT' => $timeline_limit,
 																			'TML_COMMENTS_LIMIT' => $timeline_comments_limit
 																		));
 			//それぞれのタイムラインについて、コメントを取得
 			foreach($timeline as $key_timeline => $timeline_value){
 				//コメントを取得する条件を記述
 				$conditions = array('conditions' =>
 						array('AND'=>
 								array('Timeline.ACT_ID' => '2',
 										'Timeline.VAL_ID' => $timeline_value['Timeline']['TML_ID']
 										)));
 				$timeline_comments_count = $this->Timeline->find('count', $conditions);
 				$timeline_comments = $this->Timeline->find('all', array_merge($conditions, array('order' => 'Timeline.INSERT_DATE DESC',
 																									'limit' => $timeline_comments_limit,
 																									'fields' => array('Timeline.MESSAGE',
 																														'Timeline.ACT_ID',
 																														'Timeline.INSERT_DATE',
 																														'Timeline.TML_ID',
 																														'User.NAME',
 																														'User.USR_ID'
 																											))));
				$userstimeline[$key_user]['TML_ALL'][$key_timeline]['Timeline'] = array_merge($timeline_value['Timeline'], array('TML_COMMENTS' => $timeline_comments, 'TML_COMMENTS_COUNT' => $timeline_comments_count));
 			}
 		}
		return $userstimeline;
	}

	//メイン関数
	function main(){
		$this->out('送信データの取得開始');
		$userstimeline = $this->getTimelines();
		$this->out('送信データの取得終了');
		if($userstimeline == 0){
			$this->out('取得データはありませんでした。');
		}else {
			$this->out('送信開始');
			$this->Common = new CommonComponent();
			foreach($userstimeline as $usertimeline) {
				//件名
				$subject = '本日のサマリーメール';
				//送信
				if($this->Common->send_mail_beta($usertimeline['MAIL'], $subject, null, null, $usertimeline, 'summail', null, 1, 1)) {
					$this->out('送信完了('.$usertimeline['NAME'].'さん)');
				}else {
					$this->out('送信失敗('.$usertimeline['NAME'].'さん)');
				}
			}
		}
	}
}
?>