<?php
/**
 * @copyright ICZ Corporation (http://www.icz.co.jp/)
 * @license See the LICENCE file
 * @author <sencha@icz.co.jp>
 * @version $Id$
 */
App::import('Helper','CustomHtml');
class MobileHelper extends HtmlHelper {
	var $maxDispSize = 42;
	var $maxDispLine = 3;
	/**
	 * 発言内容をタイムライン表示用に変換
	 *   -> 特殊文字のエスケープ
	 *   -> 最大文字数・行数を超えた場合は、文字列の切り出し
	 *   -> 改行文字の変換
	 *   -> リンクの変換
	 */
	function convertMessageDisp($plainttext_message, $isDetail = false) {
		//詳細ページ
		if($isDetail == true) {
			$custom = new CustomHtmlHelper();

			$custom->url_search($plainttext_message);
			return nl2br($plainttext_message);
		}
		//通常
		else {
			$message = htmlspecialchars($plainttext_message);
			$cut_message =  $this->cutoutMessage($message);
			return nl2br($cut_message);
		}
	}

	function cutoutMessage($message, $escape = false) {
		if($escape == true) {
			$message = htmlspecialchars($message);
		}

		$ln_message = explode("\n", $message);
		$count_line = count($ln_message);

		if($count_line > $this->maxDispLine) {
			for($message = '', $i = 0; $i < $this->maxDispLine; $i++) {
				$message .= $ln_message[$i]."\n";
			}

			$message = trim($message);

			if(mb_strlen($message) > $this->maxDispSize) {
				$message = mb_substr($message, 0, $this->maxDispSize);
			}
			$message = $message."...";
		}
		else if(mb_strlen($message) > $this->maxDispSize) {
			$message = mb_substr($message, 0, $this->maxDispSize)."...";
		}

		return $message;
	}

	function fileImage($entry) {
		if(preg_match('/image/', $entry['Storage']['F_TYPE']) && ($entry['Storage']['EXTENSION'] != 'bmp')) {
			//画像ファイル
			$out = $this->image(array(
					'plugin' => 'mobile',
					'controller' => 'mobile_storages',
					'action' => 'preview',
					$entry['Storage']['RAND_NAME'],
					"thumb"));
		}
		else if(preg_match('/doc/', $entry['Storage']['EXTENSION']) ||
				preg_match('/docx/', $entry['Storage']['EXTENSION'])){
			//wordファイル
			$out = $this->image('common/thumb/word.png');
		}
		else if(preg_match('/xls/', $entry['Storage']['EXTENSION']) ||
				preg_match('/xlsx/', $entry['Storage']['EXTENSION'])){
			//excelファイル
			$out = $this->image('common/thumb/excel.png');
		}
		else if(preg_match('/txt/', $entry['Storage']['EXTENSION'])){
			//txtファイル
			$this->image('common/thumb/txt.png');

		}
		else if(preg_match('/zip/', $entry['Storage']['EXTENSION'])){
			//zipファイル
			$out = $this->image('common/thumb/zip.png');
		}else{
			//その他
			$out = $this->image('common/thumb/other.png');
		}

		return $out;
	}


	function isImage($entry) {
		if(preg_match('/image/', $entry['Storage']['F_TYPE']) && ($entry['Storage']['EXTENSION'] != 'bmp')) {
			return true;
		}
		else {
			return false;
		}
	}

	function getFileSizeDisp($size) {
		$sizes = Array('Byte', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB');
		$ext = $sizes[0];
		for ($i=1; (($i < count($sizes)) && ($size >= 1024)); $i++) {
			$size = $size / 1024;
			$ext = $sizes[$i];
		}
		return round($size, 2).$ext;
	}
}
