<?php
class Mobile extends MobileAppModel {
	var $name = 'Mobile';
	var $useTable = false;
	var $MAX_MESSAGE_SIZE = 1000;
	/**
	 * validatePostFields
	 * 発言データのバリデーション
	 * @param unknown_type $data
	 * @return bool
	 */
	function validatePostFields($data) {
		if( !isset($data['Timeline']['MESSAGE']) && !isset($data['Timeline']['COMMENT']) ) {
			return false;
		}
		else if( isset($data['Timeline']['COMMENT']) ) {
			$message = $data['Timeline']['COMMENT'];
		}
		else {
			$message = $data['Timeline']['MESSAGE'];
		}

		//メッセージが空のとき
		if( empty($message) ) {
			return false;
		}
		//メッセージが最大サイズを超えていたとき
		else if( mb_strlen($message) > $this->MAX_MESSAGE_SIZE) {
			return false;
		}

		//NGワードチェック
		App::import('Model', 'Configration');
		$config  = new Configration;

		$ngword = $config->find('first', array('conditions' => array('NAME' => 'NGWORD')));
		if (empty($ngword)) return true;

		$ngword = split("\n", $ngword["Configrations"]['VALUE']);
		foreach ($ngword as $word) {
			$str = str_replace(array("\r\n", "\r", "\n"), '', $word);  //改行削除
			if (empty($str)) continue;
			if (preg_match("/$str/", $message)) {
				return false;
			}
		}


		return true;

	}
}