<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/
App::import('Controller', 'Users');
class MobileUsersController extends UsersController {
	var $name = 'MobileUsers';
	var $autoLayout = true;
	var $autoRender = true;
	var $layout = 'mobile';


	function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->loginAction = array('plugin' => 'mobile', 'controller' => 'mobile_users', 'action' => 'login');
		$this->Auth->logoutRedirect = Router::url(array('plugin' => 'mobile', 'controller' => 'mobile_users', 'action' => 'login'));
		$this->set('copyright', Configure::read('Copyright'));
		$this->set('version', Configure::read('Version'));
	}

	function login() {
		if(isset($this->data) && $this->data && $this->data['User']['save']) {
			$this->Cookie->write('mobile.mailaddress', $this->data['User']['MAIL']);
			parent::login();
		}
		else {
			parent::login();
			$this->data['User']['MAIL'] = $this->Cookie->read('mobile.mailaddress');
		}
		$this->set('main_title', 'ログイン');

	}

}
