<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/
App::import('Controller', 'Timelines');
class MobileTimelinesController extends TimelinesController {
	var $name = 'MobileTimelines';
	var $autoLayout = true;
	var $autoRender = true;
	var $layout = 'mobile';
	var $helpers = array('Mobile.Mobile');

	function beforeFilter() {
		$this->isMobile = true;
		parent::beforeFilter();
		App::import('Model', 'Mobile.Mobile');
		$this->Mobile = new Mobile();
		$this->set('copyright', Configure::read('Copyright'));
		$this->set('version', Configure::read('Version'));
	}

	function getmessage() {
		parent::getmessage();
		$this->render("getmessage");
	}

	function message() {
		$this->autoRender = false;
		if($this->Mobile->validatePostFields($this->data)) {
			parent::message();
			$this->redirect(array(
				'plugin' => 'mobile',
				'controller' => 'mobile_homes',
				'action' => 'index'
			));
		}
		else {
			$this->Session->setFlash('発言内容にエラーがあります');
			$this->redirect('/mobile/mobile_homes/#post');
		}

	}

	function comment() {
		$this->autoRender = false;
		if($this->Mobile->validatePostFields($this->data)) {
			parent::comment();
			$this->redirect('/mobile/mobile_homes/detail/'.$this->data['Timeline']['TML_ID']);
		}
		else {
			$this->Session->setFlash('コメント内容にエラーがあります');
			$this->redirect('/mobile/mobile_homes/detail/'.$this->data['Timeline']['TML_ID'].'#comment_form');
		}

	}

	function watch_list() {
		$this->layout = "mobile";
		$this->autoRender = false;
		parent::watch_list();
		$this->Session->write('prev_tab', 'watch_list');
		$this->set('tab_name', 'WATCH');
		$this->set('main_title', 'タイムライン');
		$this->render("/mobile_home/index");
	}

	function watch() {
		$WATCH_ACTION_ADD    = 0;
		$WATCH_ACTION_DELETE = 1;

		//パスからIDと動作を取得
		if (isset($this->params['named']['id'])
				&& isset($this->params['named']['action'])) {
			$tmlid = $this->params['named']['id'];
			$watch_action = $this->params['named']['action'];
		} else {
			$this->redirect('/mobile/mobile_home/index');
		}

		$user = $this->Auth->user();
		if ($this->Watch->Watch_Save($tmlid, $user['User']['USR_ID'])) {
			if($watch_action == $WATCH_ACTION_ADD) {
				$this->Session->setFlash('ウォッチリストに追加しました。');
			}
			else {
				$this->Session->setFlash('ウォッチリストから削除しました。');
			}

		}
		else {
			$this->Session->setFlash('ウォッチリストに追加できませんでした。');
		}

		$this->redirect('/mobile/mobile_homes/detail/'.$tmlid);

	}

	function read() {
		$READ_ACTION_ADD    = 0;
		$READ_ACTION_DELETE = 1;

		//パスからIDと動作を取得
		if (isset($this->params['named']['id'])
				&& isset($this->params['named']['action'])) {
			$tmlid = $this->params['named']['id'];
			$watch_action = $this->params['named']['action'];
		} else {
			$this->redirect('/mobile/mobile_home/index');
		}

		$user = $this->Auth->user();
		if ($this->Read->Reads($tmlid, $user['User']['USR_ID'])) {
			if($watch_action == $READ_ACTION_ADD) {
				$this->Session->setFlash('読んだ！に追加しました。');
			}
			else {
				$this->Session->setFlash('読んだ！を取り消しました。');
			}

		}
		else {
			$this->Session->setFlash('読んだ！に追加できませんでした。');
		}

		$this->redirect('/mobile/mobile_homes/detail/'.$tmlid);

	}
}
