<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/
App::import('Controller', 'Homes');
class MobileHomesController extends HomesController {
	var $name = 'MobileHome';
	var $autoLayout = true;
	var $autoRender = true;
	var $layout = 'mobile';
	var $helpers = array('Mobile.Mobile');

	function beforeFilter() {
		$this->isMobile = true;
		$this->Auth->autoRedirect = false;
		$this->Auth->fields = array('username' => 'MAIL', 'password' => 'PASSWORD');
		$user = $this->Auth->user();
		$joinGroup = $this->Join->Join_Group($user['User']['USR_ID']);
		$this->set('user', $user);
		$this->set('joinGroup', $joinGroup);
		$url['plugin'] = 'mobile';
		$url['controller'] = 'mobile_homes';
		$this->set('url', $url);
		$tabs = array(
			'FOLLOW' => 'index',
			'ONLY'   => 'only',
			'GROUP'  => 'group',
			'ALL'    => 'all'
		);
		$this->set('tabs', $tabs);
		$this->set('copyright', Configure::read('Copyright'));
		$this->set('version', Configure::read('Version'));
	}

	function index() {
		parent::index();

		if(isset($this->params['pass'][0])) {
			$this->Session->write('prev_tab', $this->params['pass'][0]);
			$this->set('prev_tab', $this->params['pass'][0]);
		}
		else {
			$this->Session->write('prev_tab', 'index');
		}
		$this->set('main_title', 'タイムライン');

	}

	//もっと読む
	function read_more() {
		$this->autoRender = false;
		$this->autoLayout = false;

	}

	//発言詳細
	function detail() {
		$this->autoRender = false;

		$prev_tab = $this->Session->read('prev_tab');
		$message = $this->Session->read();
		if(isset($message['Message']['flash']['message'])) {
			$this->set('message', $message['Message']['flash']['message']);
		}

		parent::one();
		$this->set('prev_tab', $prev_tab);
		$this->set('tmlid', $this->params['pass'][0]);
		$this->set('isDetail', true);
		$this->set('main_title', '投稿詳細');
		$this->render('detail');

	}

	function only() {
		parent::only();
		$this->Session->write('prev_tab', 'only');
		$this->set('main_title', 'タイムライン');
		$this->render('index');


	}

	function group() {
		parent::group();
		$this->Session->write('prev_tab', 'group');
		$this->set('main_title', 'タイムライン');
		$this->render('index');
	}

	function all() {
		parent::all();
		$this->Session->write('prev_tab', 'all');
		$this->set('main_title', 'タイムライン');
		$this->render('index');
	}

	function slide_menu() {
		$this->layout = "menu";
		$this->render("/elements/slide_menu");
	}
}
