<?php
/**
 * スマートフォン用 Controller
 */

class MobileController extends MobileAppController {
/**
 * Controller name
 *
 * @var string
 * @access public
 */
	var $name = 'Mobile';
/**
 * No models required
 *
 * @var array
 * @access public
 */
	var $uses = 'Mobile.Mobile';
/**
 * No components required
 *
 * @var array
 * @access public
 */
	var $components = array('Session');

	var $autoLayout = true;

	var $helpers = array('Ajax');

	var $layout = 'mobile';

/**
 * beforeFilter
 *
 * @return void
 */
	function beforeFilter() {
		parent::beforeFilter();
		$this->set('main_title', 'スマートフォン版');
	}
/**
 * index
 * @return void
 */
	function index() {
		$this->redirect('/mobile/mobile_homes/index');
	}

/**
 * show_pc_page
 * PC用のページを表示する際に利用。
 * @return void
 */
	function show_pc_page() {
		$this->autoRender = false;
		$this->Session->write('show_pc_page', true);
		if(isset($this->params['named']['controller'])) {
			$this->redirect('/'.$this->params['named']['controller']);
		}
		else {
			$this->redirect('/homes/');
		}
	}
/**
 * show_mobile_page
 * モバイル用のページを表示する際に利用。
 * @return void
 */
	function show_mobile_page() {
		$this->autoRender = false;
		$this->Session->delete('show_pc_page');
		$this->redirect('/mobile/mobile_users/login');
	}

}