<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

class Watch extends AppModel{

	var $name		= 'Watch';
	var $useTable	= 'T_WATCH';
	var $primaryKey = 'WCH_ID';

	var $components = array('Auth');

	var $belongsTo = array('User' =>
		array(
			'className'		=>	'User',
			'conditions'	=>	'',
			'order'			=>	'',
			'dependent'		=>	true,
			'foreignKey'	=>	'USR_ID',
		),
	);
	//プラグイン読み込み
	var $actsAs = array('Cakeplus.AddValidationRule');

	Public Function Watch_Save($_tmlid, $_userid) {
		$result = $this->find('first', array(
				'conditions' => array(
						'Watch.TML_ID' => $_tmlid,
						'Watch.USR_ID' => $_userid
				)
		));

		if ($result != null) {
			if ($this->delete($result['Watch']['WCH_ID'])) {
				return $_tmlid;
			} else {
				return false;
			}
		} else {
			$params = array();
			$params['TML_ID'] = $_tmlid;
			$params['USR_ID'] = $_userid;

			if ($this->save($params)) {
				return $_tmlid;
			} else {
				return false;
			}
		}
	}

	Public Function Watch_Search(&$_list, $_user) {
		if (!$_list) {
			return false;
		}

		foreach ($_list as $key => $val) {
			$result	= $this->find('all', array(
					'conditions' => array(
							'Watch.TML_ID' => $val['Timeline']['TML_ID'],
							'Watch.USR_ID'=>$_user['User']['USR_ID']
					)
			));
			if ($result != null) {
				$_list[$key]['Watch']['MINE'] = true;
			}else{
				$_list[$key]['Watch']['MINE'] = false;
			}
		}
	}

	Public Function Get_Timeline($_user, $grpid=null) {
		$result = array();
		//prefixの取得
		$db =& ConnectionManager::getDataSource($this->useDbConfig);
		$prefix = $db->config['prefix'];

		//参加情報モデルの読み込み
		App::import('Model', 'Join');
		$join = new Join;

		//参加しているグループの取得とリスト化
		$jg = $join->Join_Group($_user['User']['USR_ID']);
		$gid_or = array();
		foreach($jg as $key => $val){
			$gid_or[$key] = $val['Join']['GRP_ID'];
		}

		$joins = array(
			0 => array(
					'type'       => 'INNER',
					'table'      => '(SELECT WCH_ID,TML_ID FROM '.(!empty($prefix) ? $prefix : '').'T_WATCH WHERE USR_ID = '.$_user['User']['USR_ID'].')',
					'alias'      => 'Watch',
					'conditions' => 'Watch.TML_ID = Timeline.TML_ID',
					'fields'     => 'WCH_ID,TML_ID',
			),
			1 => array(
					'type'       => 'LEFT',
					'table'      => '(SELECT '.(!empty($prefix) ? $prefix : '').'T_FILE.GRP_ID,'.(!empty($prefix) ? $prefix : '').'T_FILE.FLE_ID,'.(!empty($prefix) ? $prefix : '').'M_GROUP.TYPE FROM '.(!empty($prefix) ? $prefix : '').'T_FILE LEFT JOIN '.(!empty($prefix) ? $prefix : '').'M_GROUP ON '.(!empty($prefix) ? $prefix : '').'M_GROUP.GRP_ID = '.(!empty($prefix) ? $prefix : '').'T_FILE.GRP_ID WHERE '.(!empty($prefix) ? $prefix : '').'T_FILE.PUBLIC=1)',
					'alias'      => 'Storageg',
					'conditions' => 'Timeline.VAL_ID = Storageg.FLE_ID',
					'fields'     => array('GRP_ID', 'FLE_ID', 'TYPE'),
			)
		);
		$conditions = array(
				'Timeline'=>array(
						"fields" =>array('Timeline.*', 'User.*', 'Group.*', 'Storage.*', 'Watch.WCH_ID'),
						'conditions' =>array(
								'OR'=>array(
										'1' => array('Timeline.ACT_ID' => Timeline::ACT_ID_TIMELINE),
										'2' => array('Timeline.ACT_ID' => Timeline::ACT_ID_FILE_TIMELINE),
										'3' => array(
												'Timeline.ACT_ID' => Timeline::ACT_ID_GROUP,
												'Timeline.VAL_ID' => $gid_or,
												'Group.TYPE'      => array(
														Group::TYPE_PUBLIC,
														Group::TYPE_PRIVATE
												)
										),
										'4' => array(
												'Timeline.ACT_ID' => Timeline::ACT_ID_GROUP,
												'Group.TYPE' => Group::TYPE_PUBLIC
										),
										'5' => array(
												'Timeline.ACT_ID' => Timeline::ACT_ID_FILE_GROUP,
												'Storageg.GRP_ID' => $gid_or,
												'Group.TYPE'      => array(
														Group::TYPE_PUBLIC,
														Group::TYPE_PRIVATE
												)
										),
										'6' => array(
												'Timeline.ACT_ID' => Timeline::ACT_ID_FILE_GROUP,
												'Storageg.TYPE'   => 0
										),
								),
						),
						'limit' => 20,
						'joins' => $joins,
						'order' => 'Watch.WCH_ID DESC',
				)
		);
		return $conditions;
	}
}