<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

class Join extends AppModel{

    // STATUS
    const STATUS_ADMINISTRATOR = 0; // 管理者 - そのグループの管理者である状態
    const STATUS_WAITING       = 1; // 申請中 - ユーザから管理者へグループ参加の申請をしている状態（現在未使用）
    const STATUS_JOINED        = 2; // 参加中 - ユーザがグループへ参加している状態
    const STATUS_NOT_JOINED    = 3; // 参加する - ユーザが退会した後に表示
    const STATUS_WAITING_JOIN  = 8; // 参加待ち - 管理者がユーザを招待した状態

	var $name		= 'Join';
	var $useTable	= 'T_JOIN';
	var $primaryKey = 'JIN_ID';

	var $belongsTo = array(
		'User' =>
			array(
				'className'		=>	'User',
				'conditions'	=>	'',
				'order'			=>	'',
				'dependent'		=>	true,
				'foreignKey'	=>	'USR_ID',
		),
		'Group' =>
			array(
				'className'		=>	'Group',
				'conditions'	=>	'',
				'order'			=>	'',
				'dependent'		=>	true,
				'foreignKey'	=>	'GRP_ID',
		)
	);

	public Function Serarch_User($_grpid, $_userid, $_status=null) {

		$conditions = array(
				'Join.GRP_ID' => $_grpid,
				'Join.USR_ID' => $_userid
		);

		if ($_status != null) {
			$conditions = array_merge($conditions, array(
					'or' => array(
							'Join.STATUS' => $_status
					)
			));
		}

		$result = $this->find('first', array(
				'fields' => array(
						'STATUS',
						'JIN_ID'
				),
				'conditions' => $conditions
		));
		return $result;
	}

	Function Join_Group($_userid) {
		$result = $this->find('all', array(
				'fields'     => array('GRP_ID'),
				'conditions' => array(
						'Join.USR_ID' => $_userid,
						'Join.STATUS' => array(
                                Join::STATUS_ADMINISTRATOR,
								Join::STATUS_JOINED,
						),
				)
		));
		return $result;
	}

	Function Group_User($_grpid, $num=10) {
		$result = $this->find('all', array(
				'conditions' => array(
						'User.STATUS' => User::STATUS_ENABLED,
						'Join.GRP_ID' => $_grpid,
						'Join.STATUS' => array(
                                Join::STATUS_ADMINISTRATOR,
								Join::STATUS_JOINED,
						),
				),
				'limit'=>$num
		));
		return $result;
	}

	Function Join_User($_grpid, $_userid, $option=null, $auth=false) {

		$_params = array();

		$status = $this->Serarch_User($_grpid, $_userid);
		App::import('Model', 'Request');
		$request = new Request;
		if ($status['Join']['STATUS'] == Join::STATUS_NOT_JOINED ||
			$status == false) {
			App::import('Model', 'Group');
			$group = new Group;

			$type = $group->find('first', array(
					'fields' => array(
							'TYPE',
							'USR_ID'
					),
					'conditions' => array(
							'Group.GRP_ID' => $_grpid
					)
			));

			$_params['GRP_ID'] = $_grpid;
			$_params['USR_ID'] = $_userid;

			if ($_userid == $type['Group']['USR_ID']) {
				$_params['STATUS'] = Join::STATUS_ADMINISTRATOR;
			} else {
				if ($type['Group']['TYPE'] == Group::TYPE_PRIVATE) {
					if (!$auth) {
						$_params['STATUS'] = Join::STATUS_WAITING;
					} else {
						$_params['STATUS'] = Join::STATUS_JOINED;
					}
				} else {
					$_params['STATUS'] = Join::STATUS_JOINED;
				}
			}
			$_params['INSERT_DATE'] = date("Y-m-d H:i:s");
			$_params['LAST_UPDATE'] = date("Y-m-d H:i:s");

			//トランザクションの開始
			$dataSource = $this->getDataSource();
			$dataSource->begin($this);

			if ($this->save($_params)) {
				if ($_params['STATUS'] == Join::STATUS_WAITING) {
					if ($request->Group_Request($_userid, $_grpid)) {
						$dataSource->commit($this);
						return $_params['STATUS'];
					} else {
						return false;
					}
				} else {
					$dataSource->commit($this);
					return $_params['STATUS'];
				}
			} else  {
				$dataSource->rollback($this);
				return false;
			}
		} else {
			if ($status['Join']['STATUS'] == Join::STATUS_WAITING) {
				if (!$request->Delete_Request($_userid, $_grpid)) {
					return false;
				} else {
					$this->delete($status['Join']['JIN_ID']);
					return 3;
				}
			} else {
				App::import('Model', 'Timeline');
				$timeline = new Timeline;
				App::import('Model', 'Watch');
				$watch = new Watch;

				$result = $timeline->find('all', array(
						'fields'     => array('Timeline.TML_ID'),
						'conditions' => array(
								'Timeline.ACT_ID' => array(
                                        Timeline::ACT_ID_GROUP,
										Timeline::ACT_ID_FILE_GROUP,
								),
								'Timeline.VAL_ID' => $_grpid
						)
				));
				foreach($result as $key => $val){
					$res = $watch->find('first', array(
							'fields'     => array('Watch.WCH_ID'),
							'conditions' => array(
									'Watch.TML_ID' => $val['Timeline']['TML_ID'],
									'Watch.USR_ID' => $_userid
							)
					));
					if ($res != null) {
						$watch->delete($res['Watch']['WCH_ID']);
					}
				}
				$this->delete($status['Join']['JIN_ID']);
				return 3;
			}
		}
		return false;
	}

	function Delete_All($userid) {
		$conditions = array('Join.USR_ID' => $userid);
		$this->deleteAll($conditions, false, false);
	}


	/* グループの権限変更
	* 副管理者 (STATUS_SEMI_ADMINISTRATOR) 4 ⇔ 一般ユーザ (STATUS_JOINED) 2
	*
	* Role_Change($_grpid, $_userid)
	* $_grpid  グループID
	* $_userid ユーザID
	*
	* return true(成功) or false(失敗)
	*/
	function Role_Change($_grpid, $_userid){

		$_params = $this->find('first',array(
				'conditions' => array(
						'Join.GRP_ID' => $_grpid,
						'Join.USR_ID' => $_userid
					)
				)
			);

		//一般ユーザなら
		if($_params['Join']['STATUS'] == Join::STATUS_JOINED){
			//一般ユーザ → 副管理者
			$_params['Join']['STATUS'] = Join::STATUS_SEMI_ADMINISTRATOR;
		}
		//副管理者なら
		elseif ($_params['Join']['STATUS'] == Join::STATUS_SEMI_ADMINISTRATOR){
			//副管理者 → 一般ユーザ
			$_params['Join']['STATUS'] = Join::STATUS_JOINED;
		}

		if($this->save($_params)){
			return true;
		}else{
			return false;
		}
	}

	/* ユーザ一覧を表示させる条件の設定
	 *
	 * Paginate_Conditions($_action, $_grpid, $_user, $_keyword = null)
	 * $_action  アクションなどの切り分け
	 * $_grpid グループID
	 * $_user  ユーザ情報(Authでとってきた情報)
	 * $_keyword 検索のキーワード
	 *
	 * return paginateの条件
	 *
	 */
	function Paginate_Conditions($_action, $_grpid, $_user, $_keyword = null){


		//action role
		if ($_action == 'role_default'){
			$conditions = array(
					'Join.GRP_ID' => $_grpid,
					'Join.STATUS' => array(
							Join::STATUS_SEMI_ADMINISTRATOR,
							Join::STATUS_JOINED
						),
					'NOT' => array(
							'Administrator.USR_ID' => array($_user['User']['USR_ID']),
							'Join.STATUS'          => Join::STATUS_ADMINISTRATOR
							)
					);
		}
		//action role search
		elseif ($_action == 'role_keyword'){
			$conditions = array(
					'Join.GRP_ID' => $_grpid,
					'Join.STATUS' => array(
							Join::STATUS_SEMI_ADMINISTRATOR,
							Join::STATUS_JOINED
						),
					'Administrator.NAME LIKE' => "%{$_keyword}%",
					'NOT' => array(
							'Administrator.USR_ID' => array($_user['User']['USR_ID']),
							'Join.STATUS'          => Join::STATUS_ADMINISTRATOR
							)
					);
		}
		//action invite_user
		elseif ($_action == 'invite_user_default'){

			$_join = $this->find('all', array(
					'fields'     => array('Join.USR_ID'),
					'conditions' => array(
							'Join.GRP_ID' => $_grpid
						)
					)
				);

			$join_or = array();
			foreach ($_join as $key => $val){
				$join_or[$key] = $val['Join']['USR_ID'];
			}

			$conditions = array(
					'NOT' => array(
							'User.USR_ID' => $join_or,
						),
					'AND' => array(
							'User.STATUS' => User::STATUS_ENABLED
						)
					);
		}
		//action invite_user search
		elseif ($_action == 'invite_user_keyword'){

			$_join = $this->find('all',array(
					'fields'     => array('Join.USR_ID'),
					'conditions' => array(
							'Join.GRP_ID' => $_grpid
						)
					)
				);

			$join_or = array();
			foreach ($_join as $key => $val){
				$join_or[$key] = $val['Join']['USR_ID'];
			}

			$conditions = array(
					'User.NAME LIKE' => "%{$_keyword}%",
					'NOT' => array(
							'User.USR_ID' => $join_or,
						),
					'AND' => array(
							'User.STATUS' => User::STATUS_ENABLED
						)
					);
		}
		return $conditions;
	}


}
