<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

/**
 * 申請管理用のcontrollerクラス
 */
class RequestsController extends AppController {

	var $name = "Request";
	var $uses = array("Request");
	var $autoLayout = true;

    /*
     * SNS参加申請、グループ参加申請に対して許可するか否か判断するポップアップで使うコントローラ
     */
	function judge() {
		//初期化
		$this->autoRender = false;
		$this->uses = null;
		configure::write('debug',0);
		$user = $this->Auth->user();

        /*
         * Request model のコードにあるコメントによれば
         * r = Refuse
         * p = Permit
         * c = Confirmの略のようだ
         *
         * それで else に分岐するのはどんなケースなのだろう？
         * 他人が読めるコードを書いてほしい
         */
        if ($this->params['pass'][0] == 'r' ||
            $this->params['pass'][0] == 'p' ||
            $this->params['pass'][0] == 'c') {

			//サブミットが押された場合
			$this->isCorrectToken($this->data['Security']['token']);

			//申請情報を変更
			if ($this->Request->Change_Request($this->data['Request']['REQ_ID'], $this->params['pass'][0], $user)) {
				//成功
				/* ↑
                 * 必要なのはこういうコメントではない
                 * 何を返しているのかが知りたい
                 * returnしている ['Request']['no'] とは何なのか
                 * no という変数名はいかにも短い
                 * view を見ると RequestNo のようだがこれは主キーとは違うようだ
                 * ではいったい何が入るのか
                 * ナンバーの No. であれば型は int のはずだ
                 * いや… else 側で BOOLのfalse を返しているということは YES/NO なのだろうか？
                 *
                 * viewを見ると RequestNo = 0 のケースがあって
                 * ということはこの judge() の呼び出し先で 0 と false の区別をつける必要があるのだろうか？まさか！
                 *
                 * ではこの返り値は何を意図しているのだ？どうやって使うのだ？
                 *
                 * わからん… ｡ﾟ(ﾟ´Д｀ﾟ)ﾟ｡
                 *
                 * 他人が controller だけを見たときに動作が想像できるようにコードを書いてほしい
                 * view や DB を探したり 実際に動かして変数の意味を探るのには限界がある
				 */
				return $this->data['Request']['no'];
			} else {
				//失敗
				return false;
			}
		} else {
			//初期表示

			//パスからIDを取得
			if (isset($this->params['pass'][1])) {
				$reqid = $this->params['pass'][1];
			}

			//情報を取得
            $result = $this->Request->find('first', array(
                'conditions' => array(
                    'REQ_ID' => $reqid
                )
            ));

            if ($result["Request"]['TYPE'] == Request::TYPE_JOIN_SNS ||
                $result["Request"]['TYPE'] == Request::TYPE_JOIN_SNS_DENY) {
				//タイプが参加申請の場合
				$this->set("no", $this->params['pass'][0]);
				$this->set("list", $result);
				$this->render('user', false);
			} else {
				//その他の場合
				$this->set("no", $this->params['pass'][0]);
				$this->set("list", $result);
				$this->render('judge', false);
			}
		}
	}
}
