<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

/**
 * メッセージ用のcontrollerクラス
 */

class PluginsController extends AppController {

	var $name = "Plugin";
	var $uses = array('Plugin');
	var $autoLayout = true;

    public $paginate = array(
        'page'       => 1,
        'conditions' => array(),
        'sort'       => '',
        'limit'      => 30,
        'order'      => 'Plugin.INSERT_DATE DESC',
        'recursive'  => 0
    );

	//一覧画面用
	function index() {
		//初期化
		$this->set("main_title", "プラグイン");
		$this->set("title_text", "プラグイン");
		$user = $this->Auth->user();
		$list = array();
		$list = $this->Plugin->find('all');

		$this->set('index_list', $list);
	}

	function add() {
		//初期化
		$this->autoRender = false;
		$this->uses = null;
		configure::write('debug', 0);
		$user = $this->Auth->user();
		$this->set("main_title", "プラグイン");
		$this->set("title_text", "プラグイン");
		$user = $this->Auth->user();

		if ($this->data != null) {
			if (($check = $this->Plugin->Save_Plugin($this->data['Plugin'])) === true) {
				$this->Session->setFlash('プラグインを追加しました。');
				return 'true';
				exit;
			} else {
				return 'アップロードに失敗しました。'.$check;
			}
		}
		$this->render('add', false);
	}

	function install() {
		$id = $this->params['pass'][0];
		if($id == null) {
			$this->Session->setFlash('インストールに失敗しました。', '');
            $this->redirect(array(
                'controller' => 'plugins',
                'action'     => 'index'
            ));
		}
        $result = $this->Plugin->find('first', array(
            'conditions' => array(
                'Plugin.PLU_ID' => $id
            )
        ));
		$file = APP."sencha_plugins/tmp/".$result['Plugin']['FILE_NAME'];

		if ($result['Plugin']['STATUS'] == 0) {
			$zip = new ZipArchive();
			$zip->open($file);
			$zip->extractTo(APP."sencha_plugins/content");
			$zip->close();

			$params['PLU_ID'] = $id;
			$params['STATUS'] = 1;

			$this->Plugin->save($params);

			$output = shell_exec('chmod -R 777 '.APP.'sencha_plugins/content/');

			if ($result['Plugin']['DB'] != null) {
				App::import('Core', 'File');
				App::import('Model', 'ConnectionManager');
				$db = ConnectionManager::getDataSource('default');
				$this->Plugin->__executeSQLScript($db, APP.'sencha_plugins/content/'.$result['Plugin']['NAME']."/setting/sql/dump.sql");
			}
			$this->Session->setFlash('プラグインのインストールが完了しました。');

			//キャッシュの削除
			unlink(TMP.DS.'cache/persistent/cake_core_default_ja');
			unlink(TMP.DS.'cache/persistent/cake_core_dir_map');
			unlink(TMP.DS.'cache/persistent/cake_core_file_map');
			unlink(TMP.DS.'cache/persistent/cake_core_object_map');

			$this->redirect(array('controller'=>'plugins','action'=>'index'));
		} elseif ($result['Plugin']['STATUS'] == 1) {
			$params['PLU_ID'] = $id;
			$params['STATUS'] = 2;
			$this->Plugin->save($params);
			$this->Session->setFlash('プラグインを利用停止しました。');
            $this->redirect(array(
                'controller' => 'plugins',
                'action'     => 'index'
            ));
		}elseif($result['Plugin']['STATUS']==2){
			$params['PLU_ID'] = $id;
			$params['STATUS'] = 1;
			$this->Plugin->save($params);
			$this->Session->setFlash('プラグインの利用を開始しました。');
            $this->redirect(array(
                'controller' => 'plugins',
                'action'     => 'index'
            ));
		}
	}
}
