<?php
/**
 * @copyright ICZ Corporation (http://www.icz.co.jp/)
 * @license See the LICENCE file
 * @author <sencha@icz.co.jp>
 * @version $Id$
 */

class CommonComponent extends Object {
	var $components = array('Qdmail');

	function startup(& $controller) {
		$this->_controller = $controller;

		//$this->Qdmail->startup($this->_controller);
	}

	/**
	 * メール送信関連の処理
	 *
	 * @param  $to      メール送信先アドレス
	 * @param  $subject メールのサブジェクト
	 * @param  $body    メールの本文
	 * @param  $from	送信元アドレス
	 * @param  $contents テンプレート用のデータ
	 * @param  $template テンプレート名
	 * @param  $layout   レイアウト名
	 * @param  $mail_form メール形式(null or 0：text形式, 1:html形式, 2:両方)
	 * @param  $smtp_enable smtpを使用させるかどうか
	 *
	 * @return bool     メールが送信できたかどうか
	 */
// 	function send_mail($to=null, $subject, $body,$from=null)
// 	{
// 		App::import('Model','User');
// 		$User = new User();
// 		App::import('Component', 'Qdmail');
// 		$mail = new QdmailComponent();

// 		$admin =$User->find('first',array('conditions' => array('AUTHORITY' => 0)));
// 		if($from==null){
// 			$sender = $User->find('first',array('conditions' => array('AUTHORITY' => 0)));
// 		}else{
// 			$sender=array();
// 			$sender = $from;
// 		}
// 		if($to==null){
// 			$to_u = $User->find('first',array('conditions' => array('AUTHORITY' => 0)));
// 			$to = $to_u['User']['MAIL'];
// 		}
// 		//メールを送信するユーザーリストの取得
// 		$mail->mtaOption( "-f ".$admin['User']['MAIL']);
// 		$mail->subject($subject);
// 		$mail->from(array($sender['User']['MAIL'], $sender['User']['NAME']));
// 		$mail->kana(true);
// 		$mail->text($body);
// 		$mail->to($to);
// 		$mail->errorDisplay(false);
//  		return $mail->send();
// 	}

	function send_mail_beta($to=null, $subject, $body=null, $from=null, $content=null, $template=null, $layout=null, $mail_form=null, $smtp_enable=null)
	{
		App::import('Model','User');
		$User = new User();

		$this->Qdmail = new QdmailComponent();
		App::import('Controller', 'App');
		$dummy = new AppController();
		$this->Qdmail->startup($dummy);

		if($smtp_enable==1){
			//Configrationから設定データを取得
			App::import('Model', 'Configration');
			$Configration = new Configration();
			$smtp_status = $Configration->find('first', array('conditions' => array('NAME' => 'SMTP_STATUS')));

			//SMTPサーバーを使用する場合
			if($smtp_status['Configrations']['VALUE'] == 1){
				$this->Qdmail->smtp(true);
				$protocol = Configure::read('MailProtocolCode');

				$smtp_security = $Configration->find('first', array('conditions' => array('NAME' => 'SMTP_SECURITY')));
				$smtp_host = $Configration->find('first', array('conditions' => array('NAME' => 'SMTP_HOST')));
				if($smtp_security['Configrations']['VALUE']==1){
					$smtp_host['Configrations']['VALUE'] = "ssl://".$smtp_host['Configrations']['VALUE'];
				}
				else if($smtp_security['Configrations']['VALUE']==2){
					$smtp_host['Configrations']['VALUE'] = "tls://".$smtp_host['Configrations']['VALUE'];
				}
				$smtp_protocol = $Configration->find('first', array('conditions' => array('NAME' => 'SMTP_PROTOCOL')));
				$smtp_port     = $Configration->find('first', array('conditions' => array('NAME' => 'SMTP_PORT')));
				$smtp_from     = $Configration->find('first', array('conditions' => array('NAME' => 'SMTP_FROM')));
				$sender_name = $Configration->find('first', array('conditions' => array('NAME' => 'FROM_NAME')));
				$sender_mail = $Configration->find('first', array('conditions' => array('NAME' => 'FROM_MAIL')));
				if($smtp_protocol['Configrations']['VALUE']==0){
					$smtpparam = array(
							'host'=>$smtp_host['Configrations']['VALUE'],
							'port'=> $smtp_port['Configrations']['VALUE'],
							'from'=>$sender_mail['Configrations']['VALUE'],
							'protocol'=>$protocol[$smtp_protocol['Configrations']['VALUE']],
					);
				}
				else if($smtp_protocol['Configrations']['VALUE']==1){
					$smtp_user     = $Configration->find('first', array('conditions' => array('NAME' => 'SMTP_USER')));
					$smtp_pass     = $Configration->find('first', array('conditions' => array('NAME' => 'SMTP_PASS')));
					$smtpparam = array(
							'host'=>$smtp_host['Configrations']['VALUE'],
							'port'=> $smtp_port['Configrations']['VALUE'],
							'from'=>$sender_mail['Configrations']['VALUE'],
							'protocol'=>$protocol[$smtp_protocol['Configrations']['VALUE']],
							'user'=>$smtp_user['Configrations']['VALUE'],
							'pass' => $smtp_pass['Configrations']['VALUE'],
					);
				}
				$this->Qdmail->smtpServer($smtpparam);
				$from = array($sender_mail['Configrations']['VALUE'],$sender_name['Configrations']['VALUE']);
			}else {
				App::import('Model','User');
				$User = new User();

				$admin =$User->find('first',array('conditions' => array('AUTHORITY' => 0)));
				if($from==null){
					$sender = $User->find('first',array('conditions' => array('AUTHORITY' => 0)));
					$from = array($sender['User']['MAIL'], $sender['User']['NAME']);
				}
				//メールを送信するユーザーリストの取得
				$this->Qdmail->mtaOption( "-f ".$admin['User']['MAIL']);
			}
		}else {
			$admin =$User->find('first',array('conditions' => array('AUTHORITY' => 0)));
			if($from==null){
				$sender = $User->find('first',array('conditions' => array('AUTHORITY' => 0)));
				$from = array($sender['User']['MAIL'], $sender['User']['NAME']);
			}
			//メールを送信するユーザーリストの取得
			$this->Qdmail->mtaOption( "-f ".$admin['User']['MAIL']);
		}
		//Qdmailの設定
		$this->Qdmail->subject($subject);
		$this->Qdmail->from($from);
		$this->Qdmail->kana(true);
		//テンプレートを使用する場合
		if($template){
			if($content == null) {
				$content =array();
			}
			$webroot = $Configration->find('first' , array('conditions' => array('NAME' => 'WEBROOT')));
			//webrootを配列に入れる
			$content = array_merge($content, array('WEBROOT' => $webroot['Configrations']['VALUE']));
			if($to == null){
				$to_u = $User->find('first',array('conditions' => array('AUTHORITY' => 0)));
				$to = $to_u['User']['MAIL'];
			}
			$this->Qdmail->to($to);

			if($mail_form == 1) {
				$this->Qdmail->cakeHtml($content, $template, $layout);
			}else if($mail_form == 2){
				$this->Qdmail->cakeHtml($content, $template, $layout);
				$this->Qdmail->cakeText($content, $template, $layout);
			}else {
				$this->Qdmail->cakeText($content, $template, $layout);
			}

			$this->Qdmail->errorDisplay(false);
			return $this->Qdmail->send();

		//テンプレートを使用しない場合
		}else {
			if($to==null){
				$to_u = $User->find('first',array('conditions' => array('AUTHORITY' => 0)));
				$to = $to_u['User']['MAIL'];
			}
			$this->Qdmail->to($to);
			if($mail_form == 1) {
				$this->Qdmail->html($body);
			}else {
				$this->Qdmail->text($body);
			}
			$this->Qdmail->errorDisplay(false);
			return $this->Qdmail->send();

		}
	}

// 	function send_mail_comment($tml_id)
// 	{
// 		//コメント通知メール設定を取得
// 		App::import('Model', 'Configration');
// 		$Configration = new Configration();
// 		$comment_status = $Configration->find('first', array('conditions' => array('NAME' => 'COMMAIL_STATUS')));
// 		if($comment_status['Configrations']['VALUE'] == 1){
// 			App::import('Model', 'Timeline');
// 			$Timeline = new Timeline();
// 			//コメントを取得
// 			$comment = $Timeline->find('first', array('conditions' => array('TML_ID' => $tml_id),
// 														'fields' => array('Timeline.MESSAGE','Timeline.VAL_ID','User.USR_ID','User.NAME')
// 										));
// 			//コメントされた発言を取得
// 			$timeline = $Timeline->find('first', array('conditions' => array('TML_ID' => $comment['Timeline']['VAL_ID']),
// 														'fields' => array('Timeline.MESSAGE','User.USR_ID','User.NAME', 'User.MAIL')
// 										));

// 			//自分の投稿にコメントした場合はメール通知をしない
// 			if($comment['User']['USR_ID'] != $timeline['User']['USR_ID']){
// 				//テンプレート用に配列を作成
// 				$content = array('0' => array('Message' => array(), 'Comment' => array()));
// 				$content['0']['Message'] = array_merge($content['0']['Message'], $timeline['Timeline'], $timeline['User']);
// 				$content['0']['Comment'] = array_merge($content['0']['Comment'], $comment['Timeline'], $comment['User']);

// 				$to = array($content['0']['Message']['MAIL'], $content['0']['Comment']['NAME']);
// 				$subject = 'コメント投稿通知メール';
// 				$template = 'comment_notification';
// 				$layout = 'comment_notification';

// 				$this->send_mail_beta($to , $subject, null, null, $content, $template, $layout, 2, 1);
// 			}
// 		}
// 	}
}