<?php
/**
 * @copyright ICZ Corporation (http://www.icz.co.jp/)
 * @license See the LICENCE file
 * @author <sencha@icz.co.jp>
 * @version $Id$
 */

class CustomHtmlHelper extends HtmlHelper {
	var $helpers = array('Form');
	function plink($title, $url = null, $options = array(), $confirmMessage = false) {
		$escapeTitle = true;
		if ($url !== null) {
			$url = $this->url($url);
		} else {
			$url = $this->url($title);
			$title = $url;
			$escapeTitle = false;
		}

		if (isset($options['escape'])) {
			$escapeTitle = $options['escape'];
		}

		if ($escapeTitle === true) {
			$title = h($title);
		} elseif (is_string($escapeTitle)) {
			$title = htmlentities($title, ENT_QUOTES, $escapeTitle);
		}

		if (!empty($options['confirm'])) {
			$confirmMessage = $options['confirm'];
			unset($options['confirm']);
		}
		if ($confirmMessage) {
			$confirmMessage = str_replace("'", "\'", $confirmMessage);
			$confirmMessage = str_replace('"', '\"', $confirmMessage);
			$options['onclick'] = "return confirm('{$confirmMessage}');";
		} elseif (isset($options['default']) && $options['default'] == false) {
			if (isset($options['onclick'])) {
				$options['onclick'] .= ' event.returnValue = false; return false;';
			} else {
				$options['onclick'] = 'event.returnValue = false; return false;';
			}
			unset($options['default']);
		}
		return sprintf($this->tags['link'], $url, $this->_parseAttributes($options), '<p>'.$title.'</p>');
	}

	function dateFormat($date,$format = "Y年m月d日") {
		return date($format,strtotime($date));
	}
	function df($date,$format = "Y年m月d日") {
		return $this->dateFormat($date,$format);
	}
	function dateTimeFormat($datetime,$format = "Y年m月d日 H:i:s") {
		return date($format,strtotime($datetime));
	}
	function dtf($datetime,$format = "Y年m月d日 H:i:s") {
		return $this->dateTimeFormat($datetime,$format);
	}

	//
	public function float_format($_data){
		$i = strpos($_data,'.');
	}
	function ht2br($_data, $_cont = null, $_attr = null, $_decimal = null) {

		$data = h($_data);
		return $data;
	}
	function endsWith($haystack, $needle){
		$length = strlen($haystack) - strlen($needle);
		if($length <0) return FALSE;
		return strpos($haystack, $needle, $length) !== FALSE;
	}
	function url_search(&$data){
		$domein = Configure::read('DomeinCode');
		$pattern = '/[-_.!~*\'a-zA-Z0-9;\/?:\@&=+\$,%#]+/';
		preg_match_all($pattern, $data, $matches,PREG_SET_ORDER);
		$pattern2 = '/\s\n/';
		$i=0;
		$array=array();
		foreach($matches as $key =>$val){
			$array[$i] = preg_split($pattern2,$val[0]);
			$i++;
		}
		$pos=0;
		$i=0;
		$body=array();
		$tes = 0;
		foreach($array as $key => $val){
			foreach($val as $key3 => $val3){
				if($val3!=null){
					$tes = strpos($data,$val3,$pos)+strlen($val3)-$pos;
					$body[$i] = substr($data,$pos,$tes);
					$pos = $pos+strlen($body[$i]);
					$test = preg_match('/(https?|ftp)(:\/\/[-_.!~*\'a-zA-Z0-9;\/?:\@&=+\$,%#]+)/',$body[$i],$str);
					if($test>0){

						//同じドメイン(サブドメイン)の場合以外の場合は、targetを_blankにする
						$dom = env('HTTP_HOST');

						$tar = "";
						$ma = preg_match("/".$dom."/", $str[0]);
						if ($ma == "1"){
							$tar = "_self";
						}if ($ma == "0"){
							$tar = "_blank";
						}

						$body[$i] = preg_replace('/(https?|ftp)(:\/\/[-_.!~*\'a-zA-Z0-9;\/?:\@&=+\$,%#]+)/', '<A href="\\1\\2" target=' .$tar. '>\\1\\2</A>', $body[$i]);


					}else{
						foreach($domein as $key2 => $val2){
							if(preg_match('/[a-zA-z0-9]+\.'.$val2.'$/',$body[$i])){
								if(strpos($val3,'@')!==false){
									if (preg_match("/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+$/",$val3)){
										$str = '<A href = "mailto:'.$val3.'">'.$val3.'</A>';
									}else{
										$str = $val3;
									}
								}else{
									$str = '<A href = "http://'.$val3.'">'.$val3.'</A>';
								}
								$body[$i] = str_replace($val3, $str, $body[$i]);
							}
						}
					}
					$i++;
				}
			}
		}

		$body[$i] = substr($data,$pos);

		$data='';
		foreach($body as $key =>$val){
				$data .= $val;
 		}
	}
	function text_cut($data,$no=null,$parentId=null,$dnum=null,$url=true,$short=true){
		$data = h($data);
		if($url){
			$this->url_search($data);
		}


 		$data = nl2br($data);
//		$data = preg_replace("/<br \/>\r\n<br \/>{1,}/","",$data);

		$tmp_s="";
		$result ="";
		$result = $data;
		$ar =array();
		if($short){
			if(mb_strlen($result)>400){
				$match_number=preg_match_all("/<br \/>/",$result,$ar);
				if($match_number<5){
					$result_tmp = mb_substr($result,0,400);
					$a = preg_match('/<A href=/',$result_tmp);
					$hidden_string = mb_substr($result,400);
					if($a){
						$pos = strpos($hidden_string,'/A>');
						$result_tmp=$result_tmp.substr($hidden_string,0,$pos+3);
						$hidden_string = substr($hidden_string,$pos+3);

					}
					if($hidden_string!=false){
						$result= $result_tmp."<span class='open_".$no." open_parent_".$parentId."'>…".$this->link("さらに表示",'#',array('onclick'=>'open_text('.$no.');return false;'))."</span>";
						$result = $result."<span style='display:none'class='hidden_text_".$no." hidden_text_parent_".$parentId."'>".$hidden_string."</span>";

					}
				}else{
					$first=0;
					$tmp="";
					$result_tmp="";
					$dst = $result;
					for($i=0;$i<4;$i++){
						$tmp = substr($dst,0,strpos($dst,'<br />')+6);
						$dst = substr($dst,strlen($tmp));
						$result_tmp = $result_tmp.$tmp;
					}
					$a = preg_match('/<A href=/',$result_tmp);
					$a_end = preg_match('/\/A>/',$result_tmp);

					$hidden_string = substr($result,strlen($result_tmp));
					if($a && $a != $a_end){
						$pos = strpos($hidden_string,'/A>');
						$result_tmp=$result_tmp.substr($hidden_string,0,$pos+3);
						$hidden_string = substr($hidden_string,$pos+3);
					}
					if($hidden_string!=false){

						$result= $result_tmp."<span class='open_".$no." open_parent_".$parentId."'>…".$this->link("さらに表示",'#',array('onclick'=>'open_text('.$no.');return false;'))."</span>";
						$result = $result."<span style='display:none'class='hidden_text_".$no." hidden_text_parent_".$parentId."'>".$hidden_string."</span>";
					}
				}
			}else{
				$match_number=preg_match_all("/<br \/>/",$result,$ar);
				if($match_number>5){
					$first=0;
					$tmp="";
					$result_tmp="";
					$dst = $result;
					for($i=0;$i<5;$i++){
						$tmp = substr($dst,0,strpos($dst,'<br />')+6);
						$dst = substr($dst,strlen($tmp));
						//$first = strlen($tmp);
						$result_tmp = $result_tmp.$tmp;
					}
					$a = preg_match('/<A href=/',$result_tmp);
					$a_end = preg_match('/\/A>/',$result_tmp);
					$hidden_string = substr($result,strlen($result_tmp));
					if($a && $a != $a_end){
						$pos = strpos($hidden_string,'/A>');

						$result_tmp=$result_tmp.substr($hidden_string,0,$pos+3);
						$hidden_string = substr($hidden_string,$pos+3);
					}
					if($hidden_string!=false){
						$result= $result_tmp."<span class='open_".$no." open_parent_".$parentId."'>…".$this->link("さらに表示",'#',array('onclick'=>'open_text('.$no.');return false;'))."</span>";
						$result = $result."<span style='display:none'class='hidden_text_".$no." hidden_text_parent_".$parentId."'>".$hidden_string."</span>";

					}
				}
			}
		}

		$data=$result;

		return $data;

	}
	function file_size($data){
		if($data>1023){
			$tmp = round(((float)$data/1024.0),1);
			if($tmp>1023){
				$tmp2 = round(((float)$tmp/1024.0),1);
				$data = $tmp2."MB";
			}else{
				$data =$tmp."KB";
			}
		}else{
			$data = $data."B";
		}

		return $data;
	}

	function hiddenToken() {
		return $this->Form->hidden('Security.token', array('value' => session_id() ));
	}
	function date_split($_date){
		$pieces = explode(" ", $_date);
		return $pieces[0]."<br />".$pieces[1];
	}

	//Jsヘルパーによって作成されたIDを取得
	function getJsSubmitId($out) {
		preg_match_all("/submit-[0-9]+/", $out, $result);

		if(isset($result[0][0])) {
			return $result[0][0];
		}
		else {
			return false;
		}
	}
}
