<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

class NoteController extends NoteAppController {

	var $name = 'Note';
	var $uses = array('Note.Note', 'Join', 'Storage', 'Timeline');
	var $autoLayout = true;
	var $components = array('Session','Auth','Cookie');

	public $paginate = array(
		'page' => 1,
		'conditions' => array(),
		'sort' => '',
		'limit' => 20,
		'order' => 'Note.UPDATE_DATE DESC',
		'recursive' => 0
	);

	function beforeFilter(){
		parent::beforeFilter();
		//この2文を入れることにより、デフォルトのレイアウトのままでも動作する。
 		$route= Router::getInstance();
 		$route->__params[0]['plugin']=null;

		$user = $this->Auth->user();
		$this->Note->user = $user;
		$this->Note->userID = $user['User']['USR_ID'];
		$this->Note->setPublic();
		$this->set('status', $this->Note->status);
		$this->set('public', $this->Note->public);
		if(isset($this->params['named']['noteID'])) $this->Note->noteID = $this->params['named']['noteID'];
		if($this->action == 'index' && empty($this->params['named']['tab'])) $this->params['named']['tab'] = 'OnlyMe';
	}

	function index() {
		$this->set('main_title', 'ノート機能');
		$this->set('title_text', 'ノート一覧');

		if(isset($this->data['Note']['KEYWORD'])) {
			$keyword = $this->data['Note']['KEYWORD'];
			$this->set('keyword', $keyword);
			$this->data['Note']['KEYWORD'] = $keyword;
		}
		else if(isset($this->params['named']['keyword'])) {
			$keyword = urldecode($this->params['named']['keyword']);
			$this->set('keyword', urldecode($keyword));
			$this->data['Note']['KEYWORD'] = $keyword;
		}
		else {
			$keyword = null;
		}

		$this->paginate['conditions'] = $this->Note->getPaginateCondition($this->params['named']['tab'], $keyword);
		$list = $this->paginate();
		$this->set('list', $list);
		$this->set('page', isset($this->params['named']['page']) ? $this->params['named']['page'] : 1);
		$this->set('note_public', $this->Note->public);

	}

	function add() {
		$this->set('main_title', 'ノート機能');
		$this->set('title_text', 'ノート作成');

		if(isset($this->data) && $this->data) {
			if($this->Note->saveNote($this->data)) {
				$this->Session->setFlash('ノートを作成しました。');
				$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'content', 'noteID' => $this->Note->id));
			}
		}
	}

	function edit() {

		$this->set('title_text', 'ノート作成');
		$this->autoRender = false;


		if(isset($this->data) && $this->data) {
			$this->Note->saveNote($this->data, true);
			$this->Session->setFlash('ノートを保存しました。');
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'content', 'noteID' => $this->Note->id));
		} else {
			if(empty($this->Note->noteID)) {
				$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
			}
			if(!$this->Note->checkEditAuth($this->Note->noteID)) {
				$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
			}
			$this->data = $this->Note->getNoteContent();
			$this->set('note_public', $this->data['Note']['PUBLIC']);
			$this->set('note_status', $this->data['Note']['STATUS']);
			$this->set('main_title', h($this->data['Note']['TITLE']));
		}
		$this->render('add');
	}

	function delete() {
		$this->autoRender = false;
		$this->Note->delete($this->Note->noteID);
		$this->Session->setFlash('ノートを削除しました。');
		$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
	}

	function content() {
		$this->set('title_text', 'ノート内容');

		if(empty($this->Note->noteID)) {
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		}
		if(!$this->Note->checkInspectionAuth()) {
			$this->Session->setFlash('ノートを閲覧する権限がありません。');
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		}
		$note = $this->Note->getNoteContent($this->Note->noteID);
		$this->set('note', $note);
		$this->set('isMyNote', $this->Note->checkEditAuth($this->Note->noteID));
		$this->set('main_title', h($note['Note']['TITLE']));
	}

	function renderNoteContent() {
		$this->autoRender = false;

		if(empty($this->Note->noteID)) {
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		}

		$note = $this->Note->getNoteContent();
		if(empty($note)) {
			$this->redirect(array('plugin' => 'note', 'controller' => 'note', 'action' => 'index'));
		}

		//TODO ヘッダー出力
		echo "<style>body {font-size:12px;} p{margin:3px;} ul{margin:10px; padding: 10px;}</style>";
		echo "<script type='text/javascript'>function iframeResize(){var PageHight = document.body.scrollHeight + 30;window.parent.document.getElementById('note_content').style.height = PageHight + 'px';}window.onload = iframeResize;</script>";
		echo $note['Note']['CONTENT'];
		$this->set('main_title', h($note['Note']['TITLE']));
	}


	function upload(){
		$this->autoRender = false;
		$this->autoLayout = false;
		$user = $this->Auth->user();
		//アップロードの場合


		if(isset($this->data) && $this->data && $this->isCorrectToken($this->data['Security']['token'])){
			//画像ファイル以外
			if ($this->data['Storage']['FILE']['type']==='image/jpeg' ||
			$this->data['Storage']['FILE']['type']==='image/gif'      ||
			$this->data['Storage']['FILE']['type']==='image/pjpeg'    ||
			$this->data['Storage']['FILE']['type']=== 'image/png'     ||
			$this->data['Storage']['FILE']['type']=== 'image/x-png') {
				$error='';
				if($id = $this->Storage->Save_File('Note', $this->data, $user, $this->data['Storage']['GRP_ID'], 1, $error)){
					echo $id;
				}else{
					//失敗
					if($error == 1){
						echo "画像ファイルのサイズが大きすぎます。";
					}else{
						echo "画像のアップロードに失敗しました。";
					}
				}
			}
			else {
				echo "画像ファイル以外はアップロードできません";
				return false;
			}

		//アップロードフォーム表示
		}else{
			$this->set("m_class",'Storage');
			$this->set("grpid",$this->params['pass'][0]);
			if(isset($this->params['pass'][1])){
				echo "PHPの設定以上のファイルです。";
			}else{
				$this->render('upload');
			}
		}
	}

	function insert_image() {
		$this->autoRender = false;
		$this->autoLayout = false;
		$this->render('insert_image');
	}
}
