<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

/*
 * プロフィール用モデル
 */
class Profile extends AppModel {

	var $name = 'Profile';
	var $useTable = false;

	/* Save_Profile($_data,$_user,&$error)
	 * プロフィール保存の関数
	 * $_data 保存したいデータ
	 * $_user ユーザのID
	 *
	 * returnn bool
	 */
	function Save_Profile($_data, $_user, &$error) {
		//ユーザモデルの読み込み
		App::import('Model', 'User');
		$user = new User;

		//保存
		if ($user->save($_data)) {
			//成功
			return true;
		} else {
			//失敗
			$error = $user->invalidFields();
			return false;
		}
	}

/*
 * Get_timeline($_user,$_groupid,$_status)
 * タイムラインの所得
 * 条件１　Timeline.ACT_ID=>1,Timeline.USR_ID=>自分のID　自分のコメント、他人へのコメントを含む
 * 条件２　Timeline.ACT_ID=>1,Timeline.VAL_ID=>自分のグループID　自分の場所へのコメント
 * 条件３　Timeline.ACT_ID=>4,Storage.GRP_ID=>自分のグループID,'Storage.PUBLIC' => 1　自分の場所へのファイル
 *
 * $_user 取得したいユーザのID
 * $_groupid 取得したいグループのID
 * $_status ステータス
 *
 * return $conditions ページング条件
 *
 */
	function Get_Timeline($_user, $_grpid=null, $while=null, $_tmlid=null, $_usrid=null) {

		// プロフィールのタイムラインがログインユーザである
		if ($_usrid == null) {
			//実際の構文作成
			if ($while == 1) {
				//発言のみ取得
				$conditions = array('or' => array(
						'1' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_TIMELINE,
								'Timeline.USR_ID' => $_user['User']['USR_ID']
						),
						'2' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_TIMELINE,
								'Timeline.VAL_ID' => $_grpid
						)
				));
			} elseif($while == 2) {
				//ファイルアップロードのみ取得
				$conditions = array('or'=>array(
						'3' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_FILE_TIMELINE,
								'Storage.GRP_ID'  => $_grpid,
								'Storage.PUBLIC'  => Storage::STATUS_PUBLIC
						)
				));
			} else {
				$conditions = array('or'=>array(
						'1' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_TIMELINE,
								'Timeline.USR_ID' => $_user['User']['USR_ID']
						),
						'2' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_TIMELINE,
								'Timeline.VAL_ID' => $_grpid
						),
						'3' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_FILE_TIMELINE,
								'Storage.GRP_ID'  => $_grpid,
								'Storage.PUBLIC'  => Storage::STATUS_PUBLIC
						)
				));
			}
		// プロフィールのタイムラインがログインユーザでない
		} else {
			//実際の構文作成
			if ($while == 1) {
				//発言のみ取得
				$conditions = array('or' => array(
						'1' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_TIMELINE,
								'Timeline.USR_ID' => $_usrid
						),
						'2' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_TIMELINE,
								'Timeline.VAL_ID' => $_grpid
						)
				));
			} elseif ($while == 2) {
				//ファイルアップロードのみ取得
				$conditions = array('or' => array(
						'3' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_FILE_TIMELINE,
								'Storage.GRP_ID'  => $_grpid,
								'Storage.PUBLIC'  => Storage::STATUS_PUBLIC
						)
				));
			} else {
				$conditions = array('or' => array(
						'1' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_TIMELINE,
								'Timeline.USR_ID' => $_usrid
						),
						'2' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_TIMELINE,
								'Timeline.VAL_ID' => $_grpid
						),
						'3' => array(
								'Timeline.ACT_ID' => Timeline::ACT_ID_FILE_TIMELINE,
								'Storage.GRP_ID'  => $_grpid,
								'Storage.PUBLIC'  => Storage::STATUS_PUBLIC
						)
				));
			}
		}
        return $conditions;
	}
}