<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

//ユーザ用モデル
class Friend extends AppModel {

    // STATUS
    const STATUS_NOT_FOLLOW   = 0; // フォローされていない
    const STATUS_FOLLOW       = 1; // フォローされている

	var $name       = 'Friend';
	var $useTable   = 'T_FRIEND';
	var $primaryKey = 'FRD_ID';

	/* Get_Friend_Status($_userid, $_name=false, $_status=false)
	 * 条件指定の取得のための関数
	 * $_userid ユーザID
	 * $_name 名前条件
	 * $status ステータス
	 *
	 * return $conditions 条件指定
	 *
	 */
	Public Function Get_Friend_Status($_userid, $_name=false, $_status=false, $num=10) {
		//prefixの取得
		$db =& ConnectionManager::getDataSource($this->useDbConfig);
		$prefix = $db->config['prefix'];

		$result = array();
		$name_con = array();
		if ($_name) {
			//名前条件が指定された場合
			$name_con =array(
					'NOT' => array(
							'Administrator.USR_ID'=>$_userid
					),
					'Administrator.NAME LIKE' => "%$_name%",
					'Administrator.DEL_FLG'   => '0',
					'Administrator.STATUS'    => User::STATUS_ENABLED
			);
		} else {
			$name_con = array(
					'NOT' => array(
							'Administrator.USR_ID' => $_userid
					),
					'Administrator.DEL_FLG'   => '0',
					'Administrator.STATUS'    => User::STATUS_ENABLED
			);
		}

		if ($_status == 'r') {
			//フォローされているユーザ条件の取得
			$joins = array(
					array(
							'type'       => 'LEFT',
							'table'      => '(SELECT * FROM '.(!empty($prefix) ? $prefix : '').'T_USER )',
							'alias'      => 'Administrator',
							'conditions' => 'Administrator.USR_ID = Friend.USR_ID',
							'fields'     => '',
					)
			);
			$conditions = array(
					'Friend'=>array(
							"fields"     => array('Administrator.*'),
							'conditions' => array_merge(array('Friend.F_USR_ID'=>$_userid), $name_con),
							'limit'      => $num,
							'joins'      => $joins,
							'order'      => 'Friend.FRD_ID DESC',
					)
			);
		} elseif ($_status == 'n') {
			//フォローしていないユーザー条件の取得
			$conditions = array(
					'conditions' => array_merge(array('USR_ID NOT IN (SELECT F_USR_ID FROM T_FRIEND WHERE USR_ID = '.$_userid.')'), $name_con),
					'limit' => $num,
		            'order' => '',
			);
		} elseif ($_status == 'all') {
			//フォローしているユーザ条件の取得
			$joins = array(
					array(
							'type'       => 'LEFT',
							'table'      => '(SELECT F_USR_ID FROM '.(!empty($prefix) ? $prefix : '').'T_FRIEND WHERE USR_ID = '.$_userid.')',
							'alias'      => 'Friend',
							'conditions' => 'Administrator.USR_ID = Friend.F_USR_ID',
							'fields'     => '',
					)
			);
			$conditions = array(
					'Administrator'      => array(
							'fields'     => array('Administrator.*', 'Friend.F_USR_ID'),
							'conditions' => $name_con,
							'limit'      => $num,
							'joins'      => $joins,
							'order'      => '',
					)
			);
		} else {
			//フォローしているユーザ条件の取得
			$joins = array(
				array(
					'type'       => 'LEFT',
					'table'      => '(SELECT * FROM '.(!empty($prefix) ? $prefix : '').'T_USER )',
				    'alias'      => 'Administrator',
					'conditions' => 'Administrator.USR_ID = Friend.F_USR_ID',
					'fields'     => '',
				)
			);
			$conditions = array(
				'Friend'         => array(
					"fields"     => array('Administrator.*','Friend.F_USR_ID'),
					'conditions' => array_merge(array('Friend.USR_ID'=>$_userid),$name_con),
					'limit'      => $num,
					'joins'      => $joins,
					'order'      => 'Friend.FRD_ID DESC',
				)
			);
		}
		return $conditions;
	}

	/* Friend_Create($_userid,$_c_userid)
	 * ユーザをフォローするための関数
	 * $_userid フォローする人のユーザID
	 * $_c_userid フォローされる人のユーザID
	 *
	 * return bool
	 */
	Private Function Friend_Create($_userid, $_c_userid) {

		$_data = array();
		//情報の整理
		$_data['INSERT_DATE'] = date("Y-m-d H:i:s");
		$_data['USR_ID'] = $_userid;
		$_data['F_USR_ID'] = $_c_userid;
		$_data['STATUS'] = Friend::STATUS_FOLLOW;

		//保存
		if($this->save($_data)){
			return true;
		}
	}
	/* Change_Friend($_userid,$_c_userid)
	 * フォローステータス変更の関数
	 * $_userid フォローする(はずす）人のユーザID
	 * $_c_userid フォローされる（はずされる）人のユーザID
	 *
	 * return 0 フォロー取り消し
	 * return 1 フォロー
	*/
	Public Function Change_Friend($_userid, $_c_userid) {
		//現在のステータスを取得
		$follow = $this->find('first', array(
				'fields'     => array('FRD_ID', 'STATUS'),
				'conditions' => array(
						'Friend.USR_ID'   => $_userid,
						'Friend.F_USR_ID' => $_c_userid
				)
		));

		//管理者モデルの取得（ユーザモデルの代わり)
		App::import('Model', 'Administrator');
		$admin = new Administrator;

		if ($follow['Friend']['STATUS'] == Friend::STATUS_FOLLOW) {
			//フォロー取り消しの場合
			$this->delete($follow['Friend']['FRD_ID']);

			//フォロしている人数を減らす
			$following = $admin->find('first', array(
					'fields' => array(
							'Administrator.FOLLOWING',
							'Administrator.USR_ID'
					),
					'conditions' => array('Administrator.USR_ID' => $_userid)
			));
			$following['Administrator']['FOLLOWING']--;
			$admin->save($following);

			//フォローされている人数うを減らす
			$follower = $admin->find('first', array(
					'fields' => array(
							'Administrator.FOLLOWER', 'Administrator.USR_ID'
					),
					'conditions' => array('Administrator.USR_ID'=>$_c_userid)));
			$follower['Administrator']['FOLLOWER']--;
			$admin->save($follower);
			return 0;
		} else {
			//フォローする
			if($this->Friend_Create($_userid, $_c_userid)){
				//フォローしている人数を増やす
				$following = $admin->find('first', array(
						'fields' => array(
								'Administrator.FOLLOWING',
								'Administrator.USR_ID'
						),
						'conditions' => array('Administrator.USR_ID' => $_userid)
				));
				$following['Administrator']['FOLLOWING']++;
				$admin->save($following);
				//フォローされている人数を減らす
				$follower = $admin->find('first', array(
						'fields' => array(
								'Administrator.FOLLOWER',
								'Administrator.USR_ID'
						),
						'conditions' => array(
								'Administrator.USR_ID' => $_c_userid
						)
				));
				$follower['Administrator']['FOLLOWER']++;
				$admin->save($follower);
				return 1;
			}
		}
		return false;
	}

	/* Get_Friend($_userid,$_status=null,$_name=null)
	 * 友達の取得をする関数
	 * $_userid 自分のユーザID
	 *
	 * return フォローしているユーザのID
	 */
	Public Function Get_Friend($_userid) {
		$result = $this->find('all', array(
				'fields'     => array('F_USR_ID'),
				'conditions' => array(
						'Friend.USR_ID' => $_userid,
						'Friend.STATUS' => Friend::STATUS_FOLLOW
				)
		));
		return $result;
	}

	Public Function Delete_All($userid) {
		$conditions = array(
				'or' => array(
						'0' => array(
								'Friend.F_USR_ID' => $userid
						),
						'1' => array(
								'Friend.USR_ID' => $userid
						)
				)
		);
		$this->deleteAll($conditions, false, false);
	}
}
