<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

//環境設定モデル
class Configration extends AppModel {


	/**
	 * APP'O'ROVAL --> APPROVAL
	 * INVI'E'TE   --> INVITE
	 *
	 * という2つのtypoがあって混在しているのでバグらないか心配
	 * 時間があったら直したほうがいいけどDBにも反映されているのでどうしたものやら
	 */

	var $name	    = 'Configrations';
	var $useTable	= 'T_CONFIGURE';
	var $primaryKey = 'CON_ID';

	var $components = array('Auth');

	//プラグイン読み込み
	var $actsAs = array('Cakeplus.AddValidationRule');


	/* save_conf($_params)
	 * 環境設定を保存するための関数
	 * $_params 保存したいデータ
	 *
	 * return  bool
	 */
	Public Function save_conf($_params) {

		//現在のデータを取得
		$invite_v     = $this->find('first', array('conditions' => array('NAME' => 'INVIETE')));
		$apporoval_v  = $this->find('first', array('conditions' => array('NAME' => 'APPOROVAL')));
		$general_v    = $this->find('first', array('conditions' => array('NAME' => 'GENERAL')));
		$withdrawal_v = $this->find('first', array('conditions' => array('NAME' => 'WITHDRAWAL')));
		$ngword_v     = $this->find('first', array('conditions' => array('NAME' => 'NGWORD')));

		if (empty($ngword_v)) {
			$ngword_v['Configration']['NAME'] = 'NGWORD';
		}

		//取得したデータを上書き
		$invite_v['Configration']['VALUE']     = $_params['INVITE'];
		$apporoval_v['Configration']['VALUE']  = $_params['APPOROVAL'];
		$general_v['Configration']['VALUE']    = $_params['GENERAL'];
		$withdrawal_v['Configration']['VALUE'] = $_params['WITHDRAWAL'];
 		$ngword_v['Configration']['VALUE']     = $_params['NGWORD'];


		$result = array();

		array_push($result, $invite_v, $apporoval_v, $general_v, $withdrawal_v, $ngword_v);

		//保存
		if ($this->saveAll($result)) {
			return true;
		}
		return false;
	}

	/* save_mail_conf($_params, $data_name)
	 * 環境設定を保存するための関数
	* $_params 保存したいデータ
	* $data_name 保存したいデータの名前の配列（SUMMAIL_STATUSなど）
	* return  bool
	*/
	Public Function save_mail_conf($data, $data_name) {
		//$dataの要素キー→NAME、データ→VALUEとして、保存する（存在しない場合は新しく作成する）
		$result = array();
		foreach($data_name as $d_name) {
			if(array_key_exists($d_name, $data['Configration'])) {
				$data_v = $this->find('first', array('conditions' => array('NAME' => $d_name)));
				if(empty($data_v)) {
					$data_v['Configration']['NAME'] = $d_name;
				}
// 				if($d_name == 'SMTP_PASS') {
// 					//暗号化
// 					$str_array = str_split($data['Configration'][$d_name], 2);
// 					$secret = '';
// 					foreach($str_array as $str_data) {
// 						$secret_temp = Security::cipher($str_data, 'my_key');
// 						$secret = $secret.$secret_temp;
// 					}
// 					$data_v['Configration']['VALUE'] = $secret;
// 				}else {
					$data_v['Configration']['VALUE'] = $data['Configration'][$d_name];
// 				}
				array_push($result, $data_v);
			}
		}

		//画像やリンクのためのwebrootを取得し、データベースに保存する
		$data_v = $this->find('first', array('conditions' => array('NAME' => 'WEBROOT')));
		if(empty($data_v)) {
			$data_v['Configration']['NAME'] = 'WEBROOT';
		}
		if($data_v['Configration']['VALUE'] != $data['Configration']['WEBROOT']) {
			$data_v['Configration']['VALUE'] = $data['Configration']['WEBROOT'];
			array_push($result, $data_v);
		}

		//保存
		if ($this->saveAll($result)) {
			return true;
		}
		return false;
	}


	Public Function validate_mail($data) {
		//エラーメッセージ用の空の配列を作成
		$errors = array();
		//バリデーション
		if($data['SMTP_STATUS'] == '1') {
			if($data['FROM_NAME'] == '') {
				$errors = array_merge($errors, array('FROM_NAME' => '送信者名は必須項目です。'));
			}
			if($data['FROM_MAIL'] == '') {
				$errors = array_merge($errors, array('FROM_MAIL' => 'メールアドレスは必須項目です。'));
			}else if(strpos($data['FROM_MAIL'], '@') == false){
				$errors = array_merge($errors, array('FROM_MAIL' => '正しいメールアドレスを入力してください。'));
			}
			if($data['SMTP_HOST'] == '') {
				$errors = array_merge($errors, array('SMTP_HOST' => 'SMTPホストは必須項目です。'));
			}
			if($data['SMTP_PORT'] == '') {
				$errors = array_merge($errors, array('SMTP_PORT' => 'ポート番号は必須項目です。'));
			}else if(!is_numeric($data['SMTP_PORT'])) {
				$errors = array_merge($errors, array('SMTP_PORT' => 'ポート番号には半角数字を入力してください。'));
			}
			if($data['SMTP_PROTOCOL'] == '1') {
				if($data['SMTP_USER'] == '') {
					$errors = array_merge($errors, array('SMTP_USER' => 'SMTPユーザは必須項目です。'));
				}
				if($data['SMTP_PASS'] == '') {
					$errors = array_merge($errors, array('SMTP_PASS' => 'SMTPパスワードは必須項目です。'));
				}
			}
		}

		return $errors;
	}
}
