<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

/**
 * ログイン管理用のcontrollerクラス
 */

class UsersController extends AppController {

	var $name = "User";
	var $uses = array("User",'Administrator','Configration','Message','Timeline','Join','Friend','Group','Notice','Watch','Read', 'Request');
	var $autoLayout = true;
	var $layout = 'login_layout';

	function beforeFilter(){
 		$this->Auth->autoRedirect = false;
 		$this->Auth->allow('reset', 'reminder','regist','finish','active', 'mobile/mobile_users/login');
 		$this->Auth->fields = array('username' => 'MAIL', 'password' => 'PASSWORD');
	}

	//ログイン画面用
	function login(){

		$this->set("main_title", "ログイン");
		$this->set("title_text","ログイン");
		if($this->Auth->User()){
			$user = $this->Auth->User();
			if($user['User']['STATUS']==0){
				$this->Session->setFlash('ユーザ名またはパスワードが間違っているため、<br />ログインできませんでした。','');
				$this->redirect(array('controller'=>'users','action'=>'logout'));
			}
			//セッションID書き換え
			App::import('Helper', 'Session');
			$sessionHelper = new SessionHelper();
			$sessionHelper->__regenerateId();
			$this->redirect(array('plugin' => false, 'controller'=>'homes','action'=>'index'));
		}
		elseif(!empty($this->data)){
			$this->Session->setFlash('ユーザ名またはパスワードが間違っているため、<br />ログインできませんでした。','');
		}
		$this->set("general_conf",$this->Configration->find('first',array('conditions'=>array('NAME'=>'GENERAL'))));
		$this->Session->delete('show_pc_page');
	}

	//ログアウト用
	function logout(){
		//ログアウトのログを投入
		$this->redirect($this->Auth->logout());
	}

	//パスワードリマインダ メール送信画面
	function reminder(){
		$this->set("main_title", "パスワード再設定");
		$this->set("title_text","パスワード再設定");

		if(isset($this->data['User']['MAIL'])) {
			$option = array('conditions' => array('MAIL' => $this->data['User']['MAIL'], 'NOT' => array('STATUS' => 0)), 'fields' => array('USR_ID', 'MAIL','NAME'));
			$user = $this->User->find('first', $option);

			if($this->data['User']['MAIL']==null){
				$this->User->validationErrors["MAIL"]="メールアドレスを入力してください。";
			}
			elseif(empty($user)) {
				//$this->Session->setFlash('入力されたメールアドレスは登録されていません','');
				$this->User->validationErrors["MAIL"]="入力されたメールアドレスは登録されていません。";
			}
			else {
				$key = Security::hash(uniqid().mt_rand());
				$this->data['User']['RANDOM_KEY'] = $key;
				$this->User->id = $user['User']['USR_ID'];
				$this->data['User']['LAST_UPDATE'] = date("Y-m-d H:i:s");
				if($this->User->save($this->data)) {
					//送信内容
					$url = Router::url('/users/reset/?key='.$key, true);
					$subject = "【せん茶SNS】パスワード再設定のお知らせ";
// 					$body = "■□――――――――――――――――――――――――――――■\n".
// 							"　　　　パスワード再設定のお知らせ\n".
// 							"■――――――――――――――――――――――――――――■□\n".
// 							"\n".$user['User']['NAME']."様\n".
// 							"\n".
// 							"\n".
// 							"▼こちらのURLからパスワードの再設定を行なってください。\n".
// 							$url."\n".
// 							"\n".
// 							"クリックしてもページが開かない場合は、WebブラウザのURL欄に\n".
// 							"直接入力してください。\n".
// 							"\n".
// 							"*本メールは自動送信メールとなりますので、返信いただいてもご返答が、\n".
// 							"できない可能性がございますので、ご了承ください。\n";
					//メール送信
					$content = array('USER_NAME' => $user['User']['NAME'], 'URL' => $url);
					if($this->Common->send_mail_beta($this->data['User']['MAIL'], $subject, $body, null, $content, 'password_reset', null, 0, 1)){
						$this->Session->setFlash('メールの送信に成功しました','');
						$this->redirect('/users/login');
					}else {
						$this->Session->setFlash('メールの送信に失敗しました','');
						$this->redirect('/users/reminder');
					}

				}
			}

		}

	}

	//パスワードリマインダ 再設定画面
	function reset() {
		$this->set("main_title", "パスワード再設定");
		$this->set("title_text","パスワード再設定");

		$key = isset($this->params['url']['key']) ? $this->params['url']['key'] : $this->data['User']['KEY'];
		$option = array('conditions' => array('RANDOM_KEY' => $key));
		$this->data['User']['KEY'] = $key;

		//keyパラメータがない場合
		if(!isset($key)){
			$this->redirect('/');
		}

		$user = $this->User->find('first',$option);

		//keyパラメータが不正
		if(!isset($user)||!$user){
			$this->redirect('/');
		}

		$l_date = strtotime($user['User']['LAST_UPDATE']);
		$n_date =  strtotime(date("Y-m-d H:i:s"));
		$s_diff = $n_date - $l_date;

		$diff = $s_diff / (60 * 60 * 24);

		if($diff>1){
			//パスワード・ランダムキー削除
			$this->User->id = $user['User']['USR_ID'];
			$this->data['User']['RANDOM_KEY'] = null;
			$this->data['User']['LAST_UPDATE'] = date("Y-m-d H:i:s");
			if($this->User->save($this->data)) {
				$this->Session->setFlash('URLの期限が切れています。','');
				$this->redirect('/');
			}
		}
		if(isset($this->data['User']['EDIT_PASSWORD']) && isset($this->data['User']['EDIT_PASSWORD_CHECK'])){
			//パスワード・ランダムキー削除
			$this->User->id = $user['User']['USR_ID'];
			$this->data['User']['RANDOM_KEY'] = null;
			$this->data['User']['PASSWORD'] = $this->Auth->password($this->data['User']['EDIT_PASSWORD']);
			$this->data['User']['LAST_UPDATE'] = date("Y-m-d H:i:s");
			$dataSource = $this->User->getDataSource();
			$dataSource->begin($this->User);
			$pass_valid = Validation::equalTo($this->data['User']['PASSWORD'],$this->Auth->password($this->data['User']['EDIT_PASSWORD_CHECK']));
			if($this->User->save($this->data)&& $pass_valid) {
				$dataSource->commit($this->User);
				$this->Session->setFlash('パスワード変更完了しました。','');
				$this->redirect('/');
			}else{
				//失敗
				$dataSource->rollback($this->User);
				if(!$pass_valid){
					$this->User->validationErrors['EDIT_PASSWORD']='パスワードが一致しません';
					$this->User->validationErrors['EDIT_PASSWORD_CHECK']='パスワードが一致しません';
				}else{
					$this->User->validationErrors['EDIT_PASSWORD_CHECK']= 'パスワードは6～20文字で入力してください。';
				}
			}
		}

	}

	function finish(){
		$this->set("main_title", "登録完了");
		$this->set("title_text","登録完了");

		$stat = $this->params['pass'][0];

		$this->set("stat",$stat);
	}
	//新規ユーザ登録用
	//
	//0 退会済み
	//1 有効
	//2 承認待ち
	//3 有効化待ち

	function regist(){

		$this->set("main_title", "新規登録");
		$this->set("title_text","新規登録");

		$g_conf = $this->Configration->find('first',array('conditions'=>array('NAME'=>'GENERAL')));
		$i_conf = $this->Configration->find('first',array('conditions'=>array('NAME'=>'INVIETE')));
		if($g_conf['Configration']['VALUE']!=0&& $i_conf['Configration']['VALUE']!=0){
			$this->Session->setFlash('不正な操作が行われました','');
			$this->redirect('../');
		}
		if($g_conf['Configration']['VALUE'] == 1 && $i_conf['Configration']['VALUE'] == 0){

 			if(!isset($_GET['token'])) {
 				$this->Session->setFlash('不正な操作が行われました','');
 				$this->redirect('../');
			}else{
				$this->set("token", $_GET['token']);
				$request = $this->Request->find('first', array('conditions' => array('Request.TOKEN' => $_GET['token'])));
				if(empty($request)) {
					$this->Session->setFlash('無効なトークンです','');
					$this->redirect('../');
				}
			}
		}

		if(isset($this->data)&& $this->data){
			$this->Administrator->set($this->data['User']);
			$error = $this->Administrator->invalidFields(array('fieldList'=>'EDIT_PASSWORD'));
			if(!isset($error['EDIT_PASSWORD'])){
				$this->data['User']['PASSWORD'] = $this->Auth->password($this->data['User']['EDIT_PASSWORD']);
			}
			$mail = $this->Administrator->Mail_Search($this->data['User']['MAIL']);
			$params = array();
			$apporoval_config = $this->Configration->find('first',array('conditions'=>array('NAME'=>'APPOROVAL')));
			$this->Administrator->set($this->data['User']["MAIL"]);
			$vl_mail =$this->Administrator->invalidFields();


			//ユーザが有効化を行わずに再度登録した場合
			if(!$mail) {
				$registed_user = $this->User->find('first', array('conditions' => array('User.MAIL' => $this->data['User']['MAIL'])));
				$registed_request = $this->Request->find('first', array('conditions' => array('Request.USR_ID' => $registed_user['User']['USR_ID'], 'Request.TYPE' => 6)));

				//有効化待ち状態のユーザとリクエストがある場合
				if(!empty($registed_user) && !empty($registed_request)) {
					//リクエストの有効期限チェック
					$l_date = strtotime($registed_request['Request']['INSERT_DATE']);
					$n_date =  strtotime(date("Y-m-d H:i:s"));
					$s_diff = $n_date - $l_date;
					$diff = $s_diff / (60 * 60 * 24);
					if($diff > 1){
						//有効期限が切れている場合はDB上のリクエストとユーザを削除
						$this->Request->delete($registed_request['Request']['REQ_ID']);
						$this->User->delete($registed_user['User']['USR_ID']);
						$mail = true;
					}else {
						//有効期限内に再登録しようとした場合
						$this->Administrator->validationErrors["MAIL"]="すでに登録申請されています。メールに送信されたユーザ有効化URLから有効化を行ってください。";
						$this->User->validationErrors=$this->Administrator->validationErrors;
						return false;
					}
				}
			}




			if($apporoval_config['Configration']['VALUE']!=1){
				$this->data['User']['STATUS']=2;
				$this->data['User']['DEL_FLG']=1;

				if(!$vl_mail){
					$id = $this->User->User_Regist($this->data,null,$mail,true,true);

					if($id != false){

						//成功
						//メール送信
						$subject = "【せん茶SNS】"."参加申請受付のお知らせ";
// 						$body = "■□――――――――――――――――――――――――――――■\n".
// 								"　　　　　　　参加申請受付のお知らせ\n".
// 								"■――――――――――――――――――――――――――――■□\n".
// 								"\n".
// 								"せん茶SNSへの参加申請を受付けました。\n".
// 								"\n".
// 								"管理者にて申請が承認されると、承認メールが送付されますので、\n".
// 								"それまでしばらくお待ちください。\n".
// 								"\n".
// 								"*本メールは自動送信メールとなりますので、返信いただいてもご返答が、\n".
// 								"できない可能性がございますので、ご了承ください。\n";

						if($this->Common->send_mail_beta($this->data['User']['MAIL'], $subject, null, null, null, 'join_application_user', null, 0, 1)){

							$subject = "【せん茶SNS】"."参加申請のお知らせ";
// 							$body = "■□――――――――――――――――――――――――――――■\n".
// 									"　　　　　　　参加申請のお知らせ\n".
// 									"■――――――――――――――――――――――――――――■□\n".
// 									"\n".
// 									"以下のユーザから、せん茶SNSへの参加申請を受付けました。\n".
// 									"\n".
// 									"名前：".$this->data['User']['NAME']."\n".
// 									"メール：".$this->data['User']['MAIL']."\n \n".
// 									"ログインの後、承認か拒否かお選びください。\n".
// 									"\n".
// 									"\n".
// 									"*本メールは自動送信メールとなりますので、返信いただいてもご返答が、\n".
// 									"できない可能性がございますので、ご了承ください。\n";
							$content = array(
												'USER_NAME' => $this->data['User']['NAME'],
												'USER_MAIL' => $this->data['User']['MAIL']
											);
							if($this->Common->send_mail_beta(null, $subject, null, null, $content, 'join_application_admin', null, 0, 1)){
								if($g_conf['Configration']['VALUE'] == 1 && $i_conf['Configration']['VALUE'] == 0) {
									$request['Request']['TOKEN'] = null;
									$this->Request->save($request['Request']);
								}
							}
							$this->Session->setFlash('申請が完了しました。管理者からの認証が必要になりますのでしばらくお待ちください。','');
							$this->redirect("login");
						}else{

						}
					}else{
						//失敗
						if(!$mail){
							$this->Administrator->validationErrors["MAIL"]="そのメールアドレスは使用できません。";
						}
						$this->User->validationErrors=$this->Administrator->validationErrors;
					}
				}
				else{
					//失敗
					if(!$mail){
						$this->Administrator->validationErrors["MAIL"]="そのメールアドレスは使用できません。";
					}
					$this->User->validationErrors=$this->Administrator->validationErrors;

				}
			}else{
				$this->data['User']['STATUS']=3;
				$this->data['User']['DEL_FLG']=1;


				$params=array();
				foreach($this->data['User'] as $key =>$val){
					$params['Administrator'][$key] = $val;
				}


				if(!$vl_mail){
					$id = $this->User->User_Regist($this->data,null,$mail);
					if($id != false){
						//メール送信
						$subject = "【せん茶SNS】"."登録完了";
// 						$body = "■□――――――――――――――――――――――――――――■\n".
// 								"　　　　　　　登録完了のお知らせ\n".
// 								"■――――――――――――――――――――――――――――■□\n".
// 								"\n".
// 								"せん茶SNSへの登録を完了しました。\n".
// 								"\n".
// 								"以下URLにアクセスし、ユーザの有効化を行ってください。\n".
// 								"\n".
// 								Router::url(array('controller'=>'users','action'=>'active'),true).'?token='.$id."\n".
// 								"\n".
// 								"*有効化URLの期限は1日間です。".
// 								"\n".
// 								"*本メールは自動送信メールとなりますので、返信いただいてもご返答が、\n".
// 								"できない可能性がございますので、ご了承ください。\n";
						$content = array('URL' => Router::url(array('controller'=>'users','action'=>'active'),true).'?token='.$id);
						if($this->Common->send_mail_beta($this->data['User']['MAIL'], $subject,$body=nulll, null, $content, 'register_complete', null, 0, 1)){
							//成功
							if($g_conf['Configration']['VALUE'] == 1 && $i_conf['Configration']['VALUE'] == 0) {
								$request['Request']['TOKEN'] = null;
								$this->Request->save($request['Request']);
							}
							$this->Session->setFlash('登録したメールアドレスに送信されたURLからユーザの有効化を行ってください','');
							$this->redirect("login");
						}
					}else{
						//失敗
						if(!$mail){
							$this->Administrator->validationErrors["MAIL"]="そのメールアドレスは使用できません。";
						}
						$this->User->validationErrors=$this->Administrator->validationErrors;

					}
				}
				else{
					//失敗
					if(!$mail){
						$this->Administrator->validationErrors["MAIL"]="そのメールアドレスは使用できません。";
					}
					$this->User->validationErrors=$this->Administrator->validationErrors;
				}
			}


		}

	}

	//ユーザ編集用
	function edit(){
		$this->set("main_title", "管理者メニュー");
		$this->set("title_text","ユーザ管理");

		if(isset($this->data) && $this->isCorrectToken($this->data['Security']['token'])){
			$this->Administrator->set($this->data['User']);
			if($this->data['User']['PASS_C']==1){
				$error = $this->Administrator->invalidFields(array('fieldList'=>'EDIT_PASSWORD'));
				if(!isset($error['EDIT_PASSWORD'])){
					$this->data['User']['PASSWORD'] = $this->Auth->password($this->data['User']['EDIT_PASSWORD']);
				}
			}else{
				unset($this->data['User']['PASSWORD']);
				unset($this->data['User']['EDIT_PASSWORD']);
			}
			$mail = $this->Administrator->Mail_Search($this->data['User']['MAIL'],$this->data['User']['USR_ID']);
			$auth=$this->Administrator->find('first',array('fields'=>array('AUTHORITY'),'conditions'=>array('Administrator.USR_ID'=>$this->data['User']['USR_ID'])));
			if($auth['Administrator']['AUTHORITY']==0){
				$id = $this->User->User_Regist($this->data,true,$mail,false);
			}else{
				$id = $this->User->User_Regist($this->data,null,$mail,false);
			}
			if($id != false){
				//成功
				$result = $this->User->find('first',array('conditions'=>array('User.USR_ID'=>$id)));
				$this->Auth->login($result);

				//パスワードを変更した場合は2、メールアドレスのみの場合は1を返す
				//custom_ajax内で処理
				echo $this->data['User']['PASS_C'] ? 2 : 1;
				exit;
			}
			else{
				//失敗
				if(!$mail){
					$this->User->validationErrors["MAIL"]="そのメールアドレスは使用できません。";
				}
				$pas = $this->data['User']['PASS_C'];
				$this->set('pass',$pas);
			}
		}
		else{
			$id = $this->params['pass'][0];
	 		$this->data = $this->User->find('first',array('conditions'=>array('User.USR_ID'=>$id)));
	 		$this->data['User']['USR_ID']=$id;
	 		$this->set('pass',0);
		}
		$withdrawal=$this->Configration->find('first',array('conditions'=>array('Configration.NAME'=>'WITHDRAWAL')));
		$this->set('withdrawal',$withdrawal['Configration']['VALUE']);
		$this->set('user',$this->Auth->user());
		$this->render('edit',false);
	}

	function withdrawal(){
		$this->autoRender = false;
		$this->uses = null;
		configure::write('debug',0);

		$user = $this->Auth->user();

		if(isset($this->data['User']["hide_with"]) && $this->isCorrectToken($this->data['Security']['token'])){
			$id= $user['User']['USR_ID'];

			$w=array('Watch.USR_ID'=>$id);
			$this->Watch->create();
			$this->Watch->deleteAll($w,false,false);

			$this->Read->Read_Delete($id);
			$r=array('Read.USR_ID'=>$id);
			$this->Read->create();
			$this->Read->deleteAll($r,false,false);
			$this->Request->Delete_Request($id,null);

			//メッセージ削除
			$this->Message->Delete_All($id);
			//グループ参加情報を全て削除
			$this->Join->Delete_All($id);
			//友人関係を全て削除
			$this->Friend->Delete_All($id);
			//ユーザグループ削除
			$this->Group->delete_my_group($id);
			$this->Notice->Delete_Notice($id);
			$this->Administrator->Delete_User($id);
			$this->Timeline->Delete_All($id,false,false);
			$this->Session->setFlash('退会が完了しました。<br />ご利用ありがとうございました。','');
		}
		$this->set("main_title", "管理者メニュー");
		$this->set("title_text","ユーザ招待");

		$result = $this->Group->find('all',array('conditions'=>array('Group.USR_ID'=>$user['User']['USR_ID'],'NOT'=>array('Group.TYPE'=>'2'))));
		$this->set('index_list',$result);
		$this->set('id',$user['User']['USR_ID']);
		$this->render('withdrawal',false);
	}
	//ユーザ招待
	function invite(){
		$this->autoRender = false;
		$this->uses = null;
		configure::write('debug',0);

		//システム設定取得
		$_invite  =  $this->Configration->find('first', array('conditions'=>array('Configration.NAME' => 'INVIETE')));
		$_general =  $this->Configration->find('first', array('conditions'=>array('Configration.NAME' => 'GENERAL')));

		$user = $this->Auth->user();

		$this->set("main_title", "管理者メニュー");
		$this->set("title_text","ユーザ招待");

		if(isset($this->data)&& $this->data!=null ){
			$j=0;
			$result=array();
			for($i=1;$i<6;$i++){
				if($this->data['User']["MAIL$i"]!=null){
					$mail[$i] = $this->Administrator->Mail_Search($this->data['User']["MAIL$i"]);
					if(!preg_match("/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+$/", $this->data['User']["MAIL$i"])) {
						$this->User->validationErrors["MAIL$i"]="メールアドレス形式で入力してください";
						$result[$i]=false;
					}
					else if(!$mail[$i]){
						$this->User->validationErrors["MAIL$i"]="既に登録されているユーザです。";
						$result[$i]=false;
					}
					else{
						if($_invite['Configration']['VALUE'] == 0 && $_general['Configration']['VALUE'] == 1) {
							//招待ありで一般登録なしの場合はトークンを発行
							$token = Security::hash(uniqid().mt_rand());
							$url  = Router::url(array('controller'=>'users','action'=>'regist'),true)."?token=".$token;
						}else {
							$token = null;
							$url  = Router::url(array('controller'=>'users','action'=>'regist'),true);
						}

						$subject = "【せん茶SNS】".$user['User']['NAME']."さんがあなたをせん茶SNSへ招待しています";
// 						$body = "■□――――――――――――――――――――――――――――■\n".
// 								"　　　　　　　せん茶SNSへの招待のお知らせ\n".
// 								"■――――――――――――――――――――――――――――■□\n".
// 								"\n".
// 								$user['User']['NAME']."さんよりせん茶SNSへの招待が届きました。\n".
// 								"下記URLよりアクセスして、アカウント登録を行なってください。\n".
// 								"\n".
// 								"▼▼アカウント登録はこちら▼▼\n".
// 								$url."\n".
// 								"\n".
// 								"クリックしてもページが開かない場合は、WebブラウザのURL欄に\n".
// 								"直接入力してください。\n".
// 								"\n".
// 								"*本メールは自動送信メールとなりますので、返信いただいてもご返答が、\n".
// 								"できない可能性がございますので、ご了承ください。\n";
						$content = array(
											'USER_NAME' => $user['User']['NAME'],
											'URL' => $url
										);
						if(Validation::email($this->data['User']["MAIL$i"])){
							if($this->Common->send_mail_beta($this->data['User']["MAIL$i"], $subject, null, null, $content, 'invite', null, 0, 1)) {
								$result[$i]=true;

								if($_invite['Configration']['VALUE'] == 0 && $_general['Configration']['VALUE'] == 1) {
									$data['TOKEN'] = $token;
									$data['MAIL'] = $this->data['User']["MAIL$i"];
									$data['TYPE'] = 5;
									$this->Request->create($data);
									$this->Request->save($data);
								}


							}
						}else{

							$result[$i]=false;
						}
					}
				}else{
					$result[$i]=true;
					$j++;
				}
			}

			if($result[1]==true&& $result[2]==true&& $result[3]==true&& $result[4]==true&& $result[5]==true){
				if($j!=5){
					return true;
				}else{
					return "2";
				}
			}else{
				if($result[1]){ $this->data['User']["MAIL1"]=NULL;}
				if($result[2]){ $this->data['User']["MAIL2"]=NULL;}
				if($result[3]){ $this->data['User']["MAIL3"]=NULL;}
				if($result[4]){ $this->data['User']["MAIL4"]=NULL;}
				if($result[5]){	$this->data['User']["MAIL5"]=NULL;}
			}
		}

		$this->render('invite',false);
	}

	//ユーザのアクティブ化
	function active() {
		$this->set("main_title", "ユーザ登録");
		$this->set("title_text","確認画面");

		$autoRender = false;

		if(!isset($_GET['token'])) {
			$this->Session->setFlash('不正な操作が行われました','');
			$this->redirect('../');
		}

		$request = $this->Request->find('first', array('conditions' => array('Request.TOKEN' => $_GET['token'])));

		if(empty($request)){
			$this->Session->setFlash('無効なトークンです','');
			$this->redirect('../');
		}


		$l_date = strtotime($request['Request']['INSERT_DATE']);
		$n_date =  strtotime(date("Y-m-d H:i:s"));
		$s_diff = $n_date - $l_date;

		$diff = $s_diff / (60 * 60 * 24);

		if($diff>1){
			if($this->Request->delete($request['Request']['REQ_ID']) && $this->User->delete($request['Request']['USR_ID'])) {
				$this->Session->setFlash('URLの期限が切れています。','');
				$this->redirect('/');
			}
		}



		$params=array();
		foreach($request['User'] as $key =>$val){
			$params['Administrator'][$key] = $val;
		}

		$params['Administrator']['STATUS'] = 1;
		if($this->Administrator->User_Save($params, null)) {
			$request['Request']['TOKEN'] = null;
			$request['Request']['TYPE'] = 6;
			$this->Request->save($request['Request']);
		}
		$this->render('finish');

	}
}
