<?php
/**
* @copyright ICZ Corporation (http://www.icz.co.jp/)
* @license See the LICENCE file
* @author <sencha@icz.co.jp>
* @version $Id$
*/

/**
 * ホーム用のcontrollerクラス
 */

class HomesController extends AppController {
	var $name = "Home";
	var $uses = array("Home", "Timeline", 'Storage', 'Group', 'Read', 'Watch', 'Friend', 'Join', 'Notice', 'User');
	var $autoLayout = true;

	// 追加
	var $tab_name;

	public $paginate = array(
		'page'       => 1,
		'conditions' => array(),
		'sort'       => '',
		'limit'      => 20,
		'order'      => 'Timeline.LAST_DATE DESC',
        'recursive'  => 0
	);

	//メイン用
    function index() {
		//タイムライン画面トップページ
		$this->set("main_title", "タイムライン");
		$this->set("title_text", "タイムライン");

		// 追加
		$tab_name = 'FOLLOW';
		$this->set("tab_name", $tab_name);

		//初期化
		$list = array();
		$user = $this->Auth->User();
		$mon = date("m");
		$year = date("Y");
		$day = date("d");
		$calender = array("mon"=>$mon, "year"=>$year, "day"=>$day);
		$this->Session->write('calender',-1);
		$select = $this->Session->write('select');

		// セット
		$tab_name = 'FOLLOW';
		$this->set("tab_name", $tab_name);

		//投稿の場合
		if (isset($this->data) && $this->data) {
			$this->Timeline->validates();
			$this->requestAction('/timelines/message');

			//リロードによる二重投稿防止のため、ページを再表示
			$this->redirect(Router::url(null, true));
		}

		//タイムラインの取得
		$conditions = $this->Home->Get_Timeline($user, $user['User']['GRP_ID'], null, null, 1);

		$list = $this->paginate('Timeline', $conditions);

		//コメントの取得
		$this->Timeline->Comment_Search($list);
		if (isset($list[0])) {
			$this->set("first", $list[0]['Timeline']['TML_ID']);
			$this->set("lastid", $list[count($list)-1]['Timeline']['TML_ID']);
			$this->set("lastdate", $list[count($list)-1]['Timeline']['LAST_DATE']);
		} else {
			$this->set("first", 0);
		}

		//お気に入りとウォッチリストの取得
		$this->Read->Read_Search($list, $user);
		$this->Watch->Watch_Search($list, $user);

		//カレンダー日付にデータがあるか検証
		for ($i=1; $i<$this->month_days($calender['mon'],$calender['year'])+1; $i++) {
            $conditions_tmp = array_merge($conditions, array(
                'and' => array(
                    'Timeline.INSERT_DATE LIKE'=>"%".$calender['year']."-".$calender['mon']."-".sprintf('%02d',$i)."%")
                )
            );
			$is_data[$i] = $this->Timeline->find('first', array('conditions' => $conditions_tmp));
		}

		//グループ情報の取得
		$this->paginate = $this->Group->Search_Group($user['User']['USR_ID'], null, array(0, 1, 2), 5);
		$group = $this->paginate('Group');
		$count = $this->Join->find('count', array('conditions' => array('Join.USR_ID' => $user['User']['USR_ID'])));
		$group[0]['Count'] = $count;

        $belong=array('belongsTo'=> array(
            'Administrator' => array(
                'className'		=>	'Administrator',
                'conditions'	=>	array('Administrator.STATUS' => User::STATUS_ENABLED),
                'order'			=>	'',
                'dependent'		=>	true,
                'foreignKey'	=>	'F_USR_ID',
            ),
        ));

		//フォロー－しているユーザの取得
		$this->paginate = $this->Friend->Get_Friend_Status($user['User']['USR_ID'], false, 's', 6);
		$following_user = $this->paginate('Friend');
		$this->Friend->bindModel($belong);
        $count = $this->Friend->find('count', array('conditions' => array(
            'Friend.USR_ID'        => $user['User']['USR_ID'],
            'Administrator.STATUS' => User::STATUS_ENABLED
        )));
		$following_user[0]['Count'] = $count;

		$belong['belongsTo']['Administrator']['foreignKey'] = 'USR_ID';

		//フォローされているユーザの取得
		$this->paginate = $this->Friend->Get_Friend_Status($user['User']['USR_ID'], false, 'r' ,6);
		$follower_user = $this->paginate('Friend');
		$this->Friend->bindModel($belong);
        $count = $this->Friend->find('count', array('conditions' => array(
            'Friend.F_USR_ID' => $user['User']['USR_ID'],
            'Administrator.STATUS' => User::STATUS_ENABLED
        )));
		$follower_user[0]['Count'] = $count;

		//セット
		$this->set("following_user", $following_user);
		$this->set("follower_user", $follower_user);
		$this->set("select", array('order' => -1, 'while' => -1, 'tab_name' => 'FOLLOW'));
		$this->set("date_frag", isset($this->params['pass'][0]) && $this->params['pass'][0] == 'calender' ? 0 : 1);
		$this->set("calender", $calender);
		$this->set("is_data", $is_data);
		$this->set("read_page",  1);
		$this->set("group", $group);
		$this->set("list", $list);
		$this->set("groupid", $user['User']['GRP_ID']);
		$this->set("m_class", 'Home');
	}

	//一件分だけ表示
	function one() {
		//タイムライン画面トップページ
		$this->set("main_title", "タイムライン");
		$this->set("title_text", "タイムライン");

		//初期化
		$list = array();
		$user = $this->Auth->User();

		if (!isset($this->params['pass'][0])) {
			$this->redirect('home');
		}
		$tmlid = $this->params['pass'][0];

        $ret = $this->Notice->find('all', array(
            'fields'     => 'Notice.NTC_ID',
            'conditions' => array(
                'Notice.TML_ID' => $tmlid,
                'Notice.USR_ID' => $user['User']['USR_ID'],
                'Notice.STATUS' => 0
            ),
        ));
		$tmp = array();
		foreach ($ret as $key => $val) {
			$tmp[$key]['NTC_ID'] = $val['Notice']['NTC_ID'];
			$tmp[$key]['STATUS'] = 1;
		}
		$this->Notice->saveAll($tmp);
		$this->set("notice", $this->Notice->Get_Notice($this->Auth->user()));

		//タイムラインの取得
		$conditions = $this->Home->Get_Timeline($user, $user['User']['GRP_ID'], null, $tmlid, 4);

		$list = $this->paginate('Timeline', $conditions, array());

		//コメントの取得
		$this->Timeline->Comment_Search($list);
		if (isset($list[0])) {
			$this->set("first", $list[0]['Timeline']['TML_ID']);
			$this->set("lastid", $list[count($list)-1]['Timeline']['TML_ID']);
			$this->set("lastdate", $list[count($list)-1]['Timeline']['LAST_DATE']);
		} else {
			$this->set("first", 0);
		}
		//お気に入りとウォッチリストの取得
		$this->Read->Read_Search($list, $user);
		$this->Watch->Watch_Search($list, $user);

		//セット
		$this->set("list", $list);
	}

	function notice() {
		//一括既読機能
		if(!empty($this->data) && isset($this->data['Notice']) && $this->isCorrectToken($this->data['Security']['token'])) {
			if ($this->data['Action']['read'] == 0) {
				//選択されたものを既読にする
				$read_notice = array();
				$i = 0;
				foreach ($this->data['Notice'] as $key => $val) {
					if ($val != 0) {
						$read_notice[$i]['NTC_ID'] = $val;
						$read_notice[$i]['STATUS'] = 1;
						$i++;
					}
				}
				$this->Notice->saveAll($read_notice);
			} else {
				//すべて既読にする
				$this->Notice->updateAll(array('Notice.STATUS' => 1), array('Notice.STATUS' => 0));
			}
			$this->set("notice", $this->Notice->Get_Notice($this->Auth->user()));
		}

		//通知メッセージ画面
		$this->set("main_title", "通知メッセージ");

		$user = $this->Auth->user();

		$this->paginate = array(
            'Notice' => array(
                "fields"     => array('*'),
                'limit'      => 30,
                'joins'      => array(),
                'order'      => 'Notice.NTC_ID DESC',
                'conditions' => array(
                    'Notice.USR_ID' => $user['User']['USR_ID'],
                    'NOT'           => array('Notice.P_USR_ID' => $user['User']['USR_ID'])
                )
            )
        );
		$list = $this->paginate('Notice');

		foreach ($list as $key => $val) {
			if ($val['Notice']['ACT_ID'] == 2) {
                $tmp = $this->User->find('first', array(
                    'conditions' => array('User.USR_ID' => $val['Timeline']['USR_ID']),
                    'fields'     => array('User.NAME')
                ));
				if ($tmp['User']['NAME'] == $val['P_User']['NAME']) {
					$tmp['User']['NAME'] = "自分";
				} elseif ($tmp['User']['NAME'] == $val['User']['NAME']) {
					$tmp['User']['NAME'] = "あなた";
				}
				$list[$key]['Timeline']['NAME'] = $tmp['User']['NAME'];
			}
		}
		$this->set("list",$list);
	}

	function search() {
		//タイムライン検索
		$this->set("main_title", "タイムライン検索");
		$this->set("title_text", "タイムライン検索");

		//初期化
		$list = array();
		$user = $this->Auth->User();

		//タイムラインの取得
		$option = array();
		$cond_pos = array();
		$cond_com = array();

		$this->paginate = $this->Home->Search_Timeline($this->data['Home']['KEYWORD'], $user, $user['User']['GRP_ID'], null, null, 1, $cond_com, $cond_pos);
		$list = $this->paginate('Timeline', $option);

		$com_num = $this->Timeline->find('count', $cond_com);
		$post_num = $this->Timeline->find('count', $cond_pos);

		$this->Timeline->Comment_Search($list);
		if (isset($list[0])) {
			$this->set("first", $list[0]['Timeline']['TML_ID']);
			$this->set("lastid", $list[count($list)-1]['Timeline']['TML_ID']);
		} else {
			$this->set("first", 0);
		}

		//お気に入りとウォッチリストの取得
		$this->Read->Read_Search($list, $user);
		$this->Watch->Watch_Search($list, $user);

		$this->set("list", $list);
		$this->set("date_frag", isset($this->params['pass'][0]) && $this->params['pass'][0] == 'calender' ? 0 : 1);
		$this->set("m_class", 'Home');
		$this->set("keyword", $this->data['Home']['KEYWORD']);
		$this->set("match_post", $post_num);
		$this->set("match_comment", $com_num);
	}

	//すべてを表示
	function all() {
		//初期化
		$this->autoRender = false;
		$this->uses = null;
		configure::write('debug', 0);
		$list = array();
		$user = $this->Auth->User();
		$select = $this->Session->read('select');

		$tab_name = 'ALL';
		$this->set("tab_name", $tab_name);
        $this->set("tab_name2", $tab_name);

        //絞込条件を取得
        if($select['while']==0 ){
        	$while = 0;
        }elseif($select['while']==1 ){
        	$while = 1;
        }else{
        	$while = 2;
        }
        // タイムラインの取得
        $conditions = $this->Home->Get_Timeline($user,$user['User']['GRP_ID'],$while);
        $this->Get_Timeline($conditions);

		//描画するviewの指定
        if($this->isMobile == false) {
        	$this->render('../elements/timeline/timeline', false);
        }
	}

	//グループのみを表示
	function group() {
		//初期化
		$this->autoRender = false;
		$this->uses = null;
		configure::write('debug', 0);
		$list = array();
		$user = $this->Auth->User();
		$select = $this->Session->read('select');

		//追加
		$tab_name = 'GROUP';
		$this->set("tab_name", $tab_name);
        $this->set("tab_name2", $tab_name);

        // タイムラインの取得
        $conditions = $this->Home->Get_Timeline($user, $user['User']['GRP_ID'], $this->Get_While(), null, 3);

        $this->Get_Timeline($conditions);


		//描画するviewの指定
        if($this->isMobile == false) {
        	$this->render('../elements/timeline/timeline', false);
        }
	}

	// 自分のみを表示
	function only() {
		//初期化
		$this->autoRender = false;
		$this->uses = null;
		configure::write('debug', 0);
		$list = array();
		$user = $this->Auth->User();
		$select = $this->Session->read('select');

		$tab_name = 'ONLY';
		$this->set("tab_name", $tab_name);
        $this->set("tab_name2", $tab_name);

		// ログインユーザーのコメントに紐付くタイムラインIDを取得
        $result = $this->Timeline->find('all', array(
            'fields'     => array('Timeline.VAL_ID'),
            'conditions' => array(
                'Timeline.USR_ID'  => $user['User']['USR_ID'],
                'Timeline.ACT_ID'  => 2,
                'Timeline.DEL_FLG' => 0,
            ),
        ));
		$vid_or = array();
		foreach ($result as $key => $val) {
			// 同一のタイムラインIDが配列に格納されていない場合のみ実行
			if (isset($tmp) && $tmp != $val['Timeline']['VAL_ID']) {
				$vid_or[$key] = $val['Timeline']['VAL_ID'];
				// 配列に設定したIDを格納
				$tmp = $vid_or[$key];
			}
		}

        // タイムラインの取得
		$conditions = $this->Home->Get_Timeline($user, $user['User']['GRP_ID'], $this->Get_While(), $vid_or, 2);
        $this->Get_Timeline($conditions);

		//描画するviewの指定
		if($this->isMobile == false) {
			$this->render('../elements/timeline/timeline', false);
		}
	}

	//フォローのみを表示
	function follow() {
		//初期化
		$this->autoRender = false;
		$this->uses = null;
		configure::write('debug', 0);
		$list = array();
		$user = $this->Auth->User();
		$select = $this->Session->read('select');

		$tab_name = 'FOLLOW';
		$this->set("tab_name", $tab_name);
        $this->set("tab_name2", $tab_name);

        // タイムラインの取得
		$conditions = $this->Home->Get_Timeline($user, $user['User']['GRP_ID'], $this->Get_While(), null, 1);
        $this->Get_Timeline($conditions);

		//描画するviewの指定
        if($this->isMobile == false) {
        	$this->render('../elements/timeline/timeline', false);
        }
	}



    /***
     *
     * 以下 Get_While() と Get_Timeline() は
     *
     * Follow, Only, Group, All のタブで共通の処理
     *
     */

    // 絞込条件を取得
    function Get_While() {
        $select = $this->Session->read('select');
        $while = 0;

		if ($select['while'] == 0) {
			$while = 0;
		} elseif ($select['while'] == 1) {
			$while = 1;
		} else {
			$while = 2;
		}
        return $while;
    }

    // タイムラインを取得
    function Get_Timeline($conditions) {
        $user = $this->Auth->User();
        $select = $this->Session->read('select');

        //ページングの設定
		if ($select['order'] == 1) {
			//新しい投稿順から取得
			$this->paginate = array(
                'Timeline' => array(
                    'order'      => 'Timeline.INSERT_DATE DESC',
                    'conditions' => array('Timeline.RED_NUM >=' => 0),
                    'limit'      => 20,
                    'page'       => 1
                )
			);
		} elseif ($select['order'] == 2) {
			//古い投稿順から取得
		    $this->paginate = array(
                'Timeline' => array(
                    'order'      => 'Timeline.INSERT_DATE',
                    'conditions' => array('Timeline.RED_NUM >=' => 0),
                    'limit'      => 20,
                    'page'       => 1
                )
			);
		} elseif ($select['order'] == 3) {
			//いいねが多い順の取得
            $this->paginate = array(
                'Timeline' => array(
                    'order'      => 'Timeline.RED_NUM DESC,Timeline.TML_ID DESC',
                    'conditions' => array('Timeline.RED_NUM >=' => 0),
                    'limit'      => 20,
                    'page'       => 1
                )
            );
		}
		//タイムラインの取得
		$list = $this->paginate('Timeline', $conditions);



		//コメントの取得
		if ($this->Timeline->Comment_Search($list)) {
			$this->set("first", $list[0]['Timeline']['TML_ID']);
			$this->set("lastid", $list[count($list)-1]['Timeline']['TML_ID']);
			$this->set("lastdate", $list[count($list)-1]['Timeline']['LAST_DATE']);
		} else {
			$this->set("first", 0);
		}

		//いいねの取得
		$this->Read->Read_Search($list, $user);
		//ウォッチリストの取得
		$this->Watch->Watch_Search($list, $user);

		//変数のセット
		$this->set("list", $list);
		$this->set("date_frag", true);
		$this->set("m_class", 'Home');
		$this->set("groupid", $user['User']['GRP_ID']);
    }
}
