SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
--

CREATE TABLE IF NOT EXISTS `M_GROUP` (
  `GRP_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'グループマスターID',
  `NAME` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'グループ名',
  `USR_ID` int(11) NOT NULL COMMENT '管理ユーザID',
  `TYPE` int(2) NOT NULL COMMENT '種別',
  `DESCRIPTION` text COLLATE utf8_general_ci COMMENT '説明',
  `DIRECTORY1` varchar(255) COLLATE utf8_general_ci DEFAULT NULL,
  `DIRECTORY2` varchar(255) COLLATE utf8_general_ci DEFAULT NULL,
  `THUMBNAIL` varchar(255) COLLATE utf8_general_ci DEFAULT NULL,
  `INSERT_DATE` datetime NOT NULL COMMENT '登録日',
  `LAST_UPDATE` datetime NOT NULL COMMENT '更新日',
  `DEL_FLG` tinyint(1) NOT NULL DEFAULT '0' COMMENT '削除フラグ',
  PRIMARY KEY (`GRP_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='グループ情報マスター';

CREATE TABLE IF NOT EXISTS `T_CONFIGURE` (
  `CON_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '環境設定ID',
  `NAME` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT '名前',
  `VALUE` text COLLATE utf8_general_ci NOT NULL COMMENT '値',
  PRIMARY KEY (`CON_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `T_READ` (
  `RED_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '読んだID',
  `TML_ID` int(11) NOT NULL COMMENT 'タイムラインID',
  `USR_ID` int(11) NOT NULL COMMENT 'ユーザID',
  PRIMARY KEY (`RED_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `T_FILE` (
  `FLE_ID` int(11) NOT NULL AUTO_INCREMENT,
  `USR_ID` int(11) NOT NULL,
  `GRP_ID` int(11) NOT NULL,
  `ORIGINAL_NAME` varchar(255) COLLATE utf8_general_ci NOT NULL,
  `RAND_NAME` varchar(255) COLLATE utf8_general_ci NOT NULL,
  `EXTENSION` varchar(255) COLLATE utf8_general_ci DEFAULT NULL,
  `F_TYPE` varchar(255) COLLATE utf8_general_ci NOT NULL,
  `F_SIZE` varchar(255) COLLATE utf8_general_ci NOT NULL,
  `PUBLIC` tinyint(1) NOT NULL,
  `DISP` int(8) NOT NULL DEFAULT '1',
  `INSERT_DATE` datetime NOT NULL,
  `LAST_UPDATE` datetime NOT NULL,
  `DEL_FLG` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`FLE_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `T_FRIEND` (
  `FRD_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'フォロー情報ID',
  `USR_ID` int(11) NOT NULL COMMENT 'ユーザID',
  `F_USR_ID` int(11) NOT NULL COMMENT 'フォローユーザID',
  `STATUS` int(2) DEFAULT NULL COMMENT 'ステータス',
  `INSERT_DATE` datetime NOT NULL COMMENT '登録日',
  PRIMARY KEY (`FRD_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='フレンド情報';

CREATE TABLE IF NOT EXISTS `T_JOIN` (
  `JIN_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'グループID',
  `GRP_ID` int(11) NOT NULL COMMENT 'グループマスターID',
  `USR_ID` int(11) NOT NULL COMMENT 'ユーザID',
  `STATUS` int(2) DEFAULT NULL COMMENT 'ステータス',
  `INSERT_DATE` datetime NOT NULL COMMENT '登録日',
  `LAST_UPDATE` datetime NOT NULL COMMENT '更新日',
  PRIMARY KEY (`JIN_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='グループ参加情報' ;

CREATE TABLE IF NOT EXISTS `T_MESSAGE` (
  `MSG_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'メッセージ情報ID',
  `S_USR_ID` int(11) NOT NULL COMMENT '送信者ID',
  `S_NAME` text COLLATE utf8_general_ci NOT NULL,
  `R_USR_ID` int(11) NOT NULL,
  `R_NAME` text COLLATE utf8_general_ci NOT NULL,
  `MESSAGE` text COLLATE utf8_general_ci NOT NULL COMMENT 'メッセージ',
  `SUBJECT` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT '件名',
  `STATUS` tinyint(1) NOT NULL COMMENT 'ステータス',
  `READ` tinyint(4) NOT NULL,
  `INSERT_DATE` datetime NOT NULL,
  `DEL_FLG` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`MSG_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='ダイレクトメッセージテーブル' ;


CREATE TABLE IF NOT EXISTS `T_REQUEST` (
  `REQ_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '申請情報ID',
  `USR_ID` int(11) NOT NULL COMMENT 'ユーザID',
  `TYPE` int(2) NOT NULL COMMENT '種別',
  `GRP_ID` int(11) NOT NULL COMMENT 'グループID',
  `MAIL` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT 'メールアドレス',
  `TOKEN` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT 'トークン',
  `PASSWORD` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT 'パスワード',
  `MESSAGE` text COLLATE utf8_general_ci COMMENT 'メッセージ',
  `INSERT_DATE` datetime NOT NULL COMMENT '登録日',
  PRIMARY KEY (`REQ_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='申請情報';

CREATE TABLE IF NOT EXISTS `T_TIME_LINE` (
  `TML_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'タイムラインID',
  `ACT_ID` int(11) NOT NULL COMMENT 'アクションマスターID',
  `USR_ID` int(11) NOT NULL COMMENT 'ユーザID',
  `VAL_ID` int(11) DEFAULT NULL COMMENT '値',
  `MESSAGE` text COLLATE utf8_general_ci NOT NULL COMMENT 'メッセージ',
  `RED_NUM` int(11) NOT NULL DEFAULT '0',
  `INSERT_DATE` datetime NOT NULL COMMENT '登録日',
  `LAST_DATE` datetime COMMENT '変更日',
  `DEL_FLG` tinyint(1) NOT NULL DEFAULT '0' COMMENT '削除フラグ',
  PRIMARY KEY (`TML_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='タイムライン情報' ;

CREATE TABLE IF NOT EXISTS `T_USER` (
  `USR_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ユーザID',
  `GRP_ID` int(11) DEFAULT NULL COMMENT 'マイグループ',
  `NAME` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT 'ユーザ名',
  `NAME_KANA` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT 'ユーザ名（カナ）',
  `UNIT` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT '部署名',
  `MAIL` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'メールアドレス',
  `PASSWORD` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT 'パスワード',
  `FOLLOWER` int(11) NOT NULL DEFAULT '0',
  `FOLLOWING` int(11) NOT NULL DEFAULT '0',
  `POSTCODE1` varchar(3) COLLATE utf8_general_ci DEFAULT NULL,
  `POSTCODE2` varchar(4) COLLATE utf8_general_ci DEFAULT NULL,
  `CNT_ID` int(2) DEFAULT NULL,
  `ADDRESS` varchar(255) COLLATE utf8_general_ci DEFAULT NULL,
  `PHONE_NO1` varchar(5) COLLATE utf8_general_ci DEFAULT NULL,
  `PHONE_NO2` varchar(4) COLLATE utf8_general_ci DEFAULT NULL,
  `PHONE_NO3` varchar(4) COLLATE utf8_general_ci DEFAULT NULL,
  `M_PHONE_NO1` varchar(5) COLLATE utf8_general_ci DEFAULT NULL,
  `M_PHONE_NO2` varchar(4) COLLATE utf8_general_ci DEFAULT NULL,
  `M_PHONE_NO3` varchar(4) COLLATE utf8_general_ci DEFAULT NULL,
  `DESCRIPTION` text COLLATE utf8_general_ci,
  `RANDOM_KEY` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT 'ランダムキー',
  `DIRECTORY1` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT 'フォルダ1',
  `DIRECTORY2` varchar(255) COLLATE utf8_general_ci DEFAULT NULL COMMENT 'フォルダ2',
  `THUMBNAIL` varchar(255) COLLATE utf8_general_ci DEFAULT NULL,
  `AUTHORITY` int(2) NOT NULL COMMENT '権限',
  `STATUS` int(2) NOT NULL COMMENT 'ステータス',
  `INSERT_DATE` datetime DEFAULT NULL COMMENT '登録日',
  `LAST_UPDATE` datetime DEFAULT NULL COMMENT '更新日',
  `DEL_FLG` int(1) NOT NULL DEFAULT '0' COMMENT '削除フラグ',
  PRIMARY KEY (`USR_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='ユーザ情報';

CREATE TABLE IF NOT EXISTS `T_WATCH` (
  `WCH_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ウォッチリストID',
  `TML_ID` int(11) NOT NULL COMMENT 'タイムラインID',
  `USR_ID` int(11) NOT NULL COMMENT 'ユーザID',
  PRIMARY KEY (`WCH_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `T_NOTICE` (
  `NTC_ID` int(11) NOT NULL AUTO_INCREMENT,
  `USR_ID` int(11) NOT NULL,
  `TML_ID` int(11) NOT NULL,
  `CMT_ID` int(4) NULL,
  `P_USR_ID` int(11) NOT NULL,
  `GRP_ID` int(11) DEFAULT NULL,
  `ACT_ID` int(1) NOT NULL,
  `STATUS` int(1) NOT NULL,
  `INSERT_DATE` datetime NOT NULL,
  PRIMARY KEY (`NTC_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `T_CONFIGURE` (`CON_ID`, `NAME`, `VALUE`) VALUES
(1, 'INVIETE', '0'),
(2, 'APPOROVAL', '0'),
(3, 'GENERAL', '0'),
(4, 'WITHDRAWAL', '0'),
(5, 'NGWORD', ''),
(6, 'MAINTE_FLG', '0'),
(7, 'IPHOST', ''),
(8, 'SUMMAIL_STATUS', '0'),
(9, 'SMTP_STATUS', '0'),
(10, 'FROM_NAME', ''),
(11, 'FROM_MAIL', ''),
(12, 'SMTP_PROTOCOL', '0'),
(13, 'SMTP_SECURITY', '0'),
(14, 'SMTP_HOST', ''),
(15, 'SMTP_PORT', ''),
(16, 'SMTP_USER', ''),
(17, 'SMTP_PASS', ''),
(18, 'WEBROOT', '');
CREATE TABLE IF NOT EXISTS `T_PLUGIN` (
  `PLU_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'プラグインID',
  `NAME` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT '名前',
  `DISP_NAME` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT '表示名',
  `FILE_NAME` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'ファイル名',
  `DESCRIPTION` text COLLATE utf8_general_ci NOT NULL COMMENT '説明',
  `AUTHOR` varchar(255) COLLATE utf8_general_ci NOT NULL,
  `URL` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'URL',
  `DB` varchar(255) COLLATE utf8_general_ci DEFAULT NULL,
  `NOT_STOP` int(1) NOT NULL DEFAULT '0' COMMENT '使用停止不可フラグ',
  `STATUS` int(1) NOT NULL COMMENT 'ステータス',
  `INSERT_DATE` datetime NOT NULL COMMENT '登録日',
  `LAST_UPDATE` datetime NOT NULL COMMENT '更新日',
  `DEL_FLG` tinyint(1) NOT NULL DEFAULT '0' COMMENT '削除フラグ',
  PRIMARY KEY (`PLU_ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='プラグイン情報';

CREATE TABLE IF NOT EXISTS `T_NOTE` (
  `NOTE_ID` int(11) NOT NULL AUTO_INCREMENT,
  `TITLE` text NOT NULL,
  `CONTENT` text NOT NULL,
  `INSERT_DATE` datetime NOT NULL,
  `UPDATE_DATE` datetime NOT NULL,
  `STATUS` int(2) NOT NULL,
  `PUBLIC` varchar(20) DEFAULT NULL,
  `USR_ID` int(11) NOT NULL,
  PRIMARY KEY (`NOTE_ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1 ;

INSERT INTO `T_PLUGIN` (`PLU_ID`, `NAME`, `DISP_NAME`, `FILE_NAME`, `DESCRIPTION`, `AUTHOR`, `URL`, `DB`, `NOT_STOP`, `STATUS`, `INSERT_DATE`, `LAST_UPDATE`, `DEL_FLG`) VALUES
(1, 'note', 'ノート', 'note.zip', 'ノート機能として長文を共有でき、アーカイブとして読み直しできます。<br>会議の議事録なども、せん茶SNSのタイムライン上にアップロードするだけで、簡単にフォローしているユーザや所属しているグループに対してファイルを共有することができます。<br><br>※デフォルト機能のため、利用を停止することはできません。', '株式会社アイシーズ', 'http://oss.icz.co.jp/', '1', 1, 1, '2012-10-17 11:04:33', '2012-10-17 11:04:33', 0);

