/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSetTextJustification
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_SPACELENGTH = 0;
    private static final int POS_BREAKCOUNT = 1;
    private int extraSpaceLength;
    private int breakCount;

    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setTextJustification(this.extraSpaceLength, this.breakCount);
    }

    public MfCmd getInstance() {
        return new MfCmdSetTextJustification();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_TEXT_JUSTIFICATION] breakCount=");
        b.append(this.getBreakCount());
        b.append(" extraSpaceLength=");
        b.append(this.getExtraSpaceLength());
        return b.toString();
    }

    public void setRecord(MfRecord record) {
        int spaceLength = record.getParam(0);
        int breakCount = record.getParam(1);
        this.setExtraSpaceLength(spaceLength);
        this.setBreakCount(breakCount);
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(2);
        record.setParam(1, this.getBreakCount());
        record.setParam(0, this.getExtraSpaceLength());
        return record;
    }

    public int getFunction() {
        return 522;
    }

    public int getBreakCount() {
        return this.breakCount;
    }

    public void setBreakCount(int count) {
        this.breakCount = count;
    }

    public int getExtraSpaceLength() {
        return this.extraSpaceLength;
    }

    public void setExtraSpaceLength(int count) {
        this.extraSpaceLength = count;
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

