/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.cache;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class CachingResourceData
implements ResourceData,
Serializable {
    private static final int CACHE_THRESHOLD = 524288;
    private ResourceData data;
    private HashMap attributes;
    private transient byte[] rawData;
    private static final long serialVersionUID = -1749415356208356705L;

    public CachingResourceData(ResourceData data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        byte[] data = this.getResource(caller);
        return new ByteArrayInputStream(data);
    }

    public long getLength() {
        if (this.rawData != null) {
            return this.rawData.length;
        }
        return this.data.getLength();
    }

    public synchronized byte[] getResource(ResourceManager caller) throws ResourceLoadingException {
        if (this.rawData == null) {
            this.rawData = this.data.getResource(caller);
        }
        return (byte[])this.rawData.clone();
    }

    public synchronized int getResource(ResourceManager caller, byte[] target, long offset, int length) throws ResourceLoadingException {
        int iOffset;
        int maxLength;
        if (target == null) {
            throw new NullPointerException();
        }
        if ((long)target.length < offset + (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.rawData == null) {
            this.rawData = this.data.getResource(caller);
        }
        if ((maxLength = Math.min(this.rawData.length - (iOffset = (int)(Integer.MAX_VALUE & offset)), length)) <= 0) {
            return -1;
        }
        System.arraycopy(this.rawData, iOffset, target, 0, maxLength);
        return maxLength;
    }

    public synchronized Object getAttribute(String key) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        } else {
            Object cached = this.attributes.get(key);
            if (cached != null) {
                return cached;
            }
        }
        Object value = this.data.getAttribute(key);
        if (value != null) {
            this.attributes.put(key, value);
        }
        return value;
    }

    public ResourceKey getKey() {
        return this.data.getKey();
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        return this.data.getVersion(caller);
    }

    public static ResourceData createCached(ResourceData data) {
        Number contentLength;
        Object rawCl = data.getAttribute("content-length");
        if (rawCl instanceof Number && (contentLength = (Number)rawCl).intValue() < 524288) {
            return new CachingResourceData(data);
        }
        return data;
    }
}

