/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class EcmaError
extends RuntimeException {
    private String errorName;
    private String errorMessage;
    private String sourceName;
    private int lineNumber;
    private int columnNumber;
    private String lineSource;

    EcmaError(String errorName, String errorMessage, String sourceName, int lineNumber, String lineSource, int columnNumber) {
        super("EcmaError: " + errorName + ": " + errorMessage);
        this.errorName = errorName;
        this.errorMessage = errorMessage;
        this.sourceName = sourceName;
        this.lineNumber = lineNumber;
        this.lineSource = lineSource;
        this.columnNumber = columnNumber;
    }

    public EcmaError(Scriptable nativeError, String sourceName, int lineNumber, int columnNumber, String lineSource) {
        this("InternalError", ScriptRuntime.toString(nativeError), sourceName, lineNumber, lineSource, columnNumber);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.errorName);
        buf.append(": ");
        buf.append(this.errorMessage);
        if (this.sourceName != null || this.lineNumber > 0) {
            buf.append(" (");
            if (this.sourceName != null) {
                buf.append(this.sourceName);
                buf.append("; ");
            }
            if (this.lineNumber > 0) {
                buf.append("line ");
                buf.append(this.lineNumber);
            }
            buf.append(')');
        }
        return buf.toString();
    }

    public String getName() {
        return this.errorName;
    }

    public String getMessage() {
        return this.errorMessage;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getLineSource() {
        return this.lineSource;
    }

    public Scriptable getErrorObject() {
        return Undefined.instance;
    }
}

