/*
 * Decompiled with CFR 0.152.
 */
package codecLib.mpa;

public class FrameInfo {
    protected int mpegId;
    protected int layerId;
    protected int modeId;
    protected static final String[] modeNames = new String[]{"stereo", "joint stereo", "dual channel", "single channel"};
    protected int headerOffset;
    protected int frameLength;
    protected int bitRate;
    protected long samplingRate;
    protected int numberOfChannels;
    protected int numberOfSamples;
    protected int negativeOffset;

    public int getMpegId() {
        return this.mpegId;
    }

    public int getLayerId() {
        return this.layerId;
    }

    public int getModeId() {
        return this.modeId;
    }

    public String getModeName() {
        return modeNames[this.modeId];
    }

    public int getHeaderOffset() {
        return this.headerOffset;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public long getSamplingRate() {
        return this.samplingRate;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public int getNegativeOffset() {
        return this.negativeOffset;
    }

    public String toString() {
        if (this.mpegId != 1 && this.mpegId != 2 || this.layerId < 1 || this.layerId > 3 || this.modeId < 0 || this.modeId > 3) {
            return "(no info)";
        }
        String string = "MPEG-" + this.mpegId + " layer " + this.layerId + ", " + modeNames[this.modeId] + ", " + this.samplingRate + " Hz, ";
        if (this.bitRate > 0) {
            return string + this.bitRate + " kbit/s";
        }
        return string + "free bitrate";
    }
}

