/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.TlsProtocolHandler;

public class TlsUtils {
    static byte[] toByteArray(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    protected static void writeUint8(short s, OutputStream outputStream) throws IOException {
        outputStream.write(s);
    }

    protected static void writeUint8(short s, byte[] byArray, int n) {
        byArray[n] = (byte)s;
    }

    protected static void writeUint16(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n >> 8);
        outputStream.write(n);
    }

    protected static void writeUint16(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 8);
        byArray[n2 + 1] = (byte)n;
    }

    protected static void writeUint24(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n >> 16);
        outputStream.write(n >> 8);
        outputStream.write(n);
    }

    protected static void writeUint24(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 16);
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2 + 2] = (byte)n;
    }

    protected static void writeUint32(long l, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l >> 24));
        outputStream.write((int)(l >> 16));
        outputStream.write((int)(l >> 8));
        outputStream.write((int)l);
    }

    protected static void writeUint32(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >> 24);
        byArray[n + 1] = (byte)(l >> 16);
        byArray[n + 2] = (byte)(l >> 8);
        byArray[n + 3] = (byte)l;
    }

    protected static void writeUint64(long l, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l >> 56));
        outputStream.write((int)(l >> 48));
        outputStream.write((int)(l >> 40));
        outputStream.write((int)(l >> 32));
        outputStream.write((int)(l >> 24));
        outputStream.write((int)(l >> 16));
        outputStream.write((int)(l >> 8));
        outputStream.write((int)l);
    }

    protected static void writeUint64(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    protected static short readUint8(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (short)n;
    }

    protected static int readUint16(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n;
    }

    protected static int readUint24(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3 = inputStream.read();
        if ((n3 | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return n3 << 16 | n2 << 8 | n;
    }

    protected static long readUint32(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (long)n4 << 24 | (long)n3 << 16 | (long)n2 << 8 | (long)n;
    }

    protected static void readFully(byte[] byArray, InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        do {
            if ((n2 = inputStream.read(byArray, n, byArray.length - n)) != -1) continue;
            throw new EOFException();
        } while ((n += n2) != byArray.length);
    }

    protected static void checkVersion(byte[] byArray, TlsProtocolHandler tlsProtocolHandler) throws IOException {
        if (byArray[0] != 3 || byArray[1] != 1) {
            tlsProtocolHandler.failWithError((short)2, (short)70);
        }
    }

    protected static void checkVersion(InputStream inputStream, TlsProtocolHandler tlsProtocolHandler) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n != 3 || n2 != 1) {
            tlsProtocolHandler.failWithError((short)2, (short)70);
        }
    }

    protected static void writeVersion(OutputStream outputStream) throws IOException {
        outputStream.write(3);
        outputStream.write(1);
    }

    private static void hmac_hash(Digest digest, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        HMac hMac = new HMac(digest);
        KeyParameter keyParameter = new KeyParameter(byArray);
        byte[] byArray4 = byArray2;
        int n = digest.getDigestSize();
        int n2 = (byArray3.length + n - 1) / n;
        byte[] byArray5 = new byte[hMac.getMacSize()];
        byte[] byArray6 = new byte[hMac.getMacSize()];
        for (int i = 0; i < n2; ++i) {
            hMac.init(keyParameter);
            hMac.update(byArray4, 0, byArray4.length);
            hMac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            hMac.init(keyParameter);
            hMac.update(byArray4, 0, byArray4.length);
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n * i, Math.min(n, byArray3.length - n * i));
        }
    }

    protected static void PRF(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n = (byArray.length + 1) / 2;
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        System.arraycopy(byArray, 0, byArray5, 0, n);
        System.arraycopy(byArray, byArray.length - n, byArray6, 0, n);
        byte[] byArray7 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray7, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray7, byArray2.length, byArray3.length);
        byte[] byArray8 = new byte[byArray4.length];
        TlsUtils.hmac_hash(new MD5Digest(), byArray5, byArray7, byArray8);
        TlsUtils.hmac_hash(new SHA1Digest(), byArray6, byArray7, byArray4);
        for (int i = 0; i < byArray4.length; ++i) {
            int n2 = i;
            byArray4[n2] = (byte)(byArray4[n2] ^ byArray8[i]);
        }
    }
}

